/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vlogdt.model.reflection.ImportInfo;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;

public class RfVunit
extends RfModule {
    private static final long serialVersionUID = 1L;
    private List<String> targetModuleOrInstance;
    private transient IRfNamedElement cachedResolvedModuleOrInstance;

    public RfVunit(String name, boolean escaped, String defaultNetType, HidImplicit[] timescale) {
        super(name, escaped, defaultNetType, timescale);
    }

    public void setTargetModuleOrInstance(List<String> targetModuleOrInstance) {
        this.targetModuleOrInstance = targetModuleOrInstance;
    }

    @Override
    protected void resolveImports(RfProject rfProject, boolean report, boolean thisLanguage, boolean otherLanguage, boolean force, Set<String> incrementalTypeNames, Collection<ImportInfo> incrementalAddedImports) {
        super.resolveImports(rfProject, report, thisLanguage, otherLanguage, force, incrementalTypeNames, incrementalAddedImports);
        RfNamedElement enclosing = this.getEnclosingScope();
        RfDefElement declaration = this.getDeclaration();
        if (declaration == null) {
            return;
        }
        if (this.targetModuleOrInstance == null) {
            return;
        }
        if (this.targetModuleOrInstance.size() == 1) {
            this.cachedResolvedModuleOrInstance = enclosing.getLocalMember(RfModule.class, this.targetModuleOrInstance.get(0), true);
        }
    }

    public IRfNamedElement getResolvedModuleOrInstance() {
        if (this.cachedResolvedModuleOrInstance != null) {
            return this.cachedResolvedModuleOrInstance;
        }
        if (this.targetModuleOrInstance == null || this.targetModuleOrInstance.isEmpty()) {
            return null;
        }
        RfProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return null;
        }
        ElementPath targetPath = ElementPath.join(null, this.targetModuleOrInstance);
        if (targetPath.isEmpty()) {
            return null;
        }
        ELManager elManager = rfProject.getELManager();
        if (elManager == null) {
            return null;
        }
        ELInstance instanceFor = elManager.getMemory().instanceFor(targetPath);
        if (instanceFor == null) {
            return null;
        }
        this.cachedResolvedModuleOrInstance = instanceFor.getBinding(false);
        return this.cachedResolvedModuleOrInstance;
    }

    @Override
    public IRfNamedElement getVisibleMemberInScope(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean isOnlyType, boolean skipParents) {
        IRfNamedElement result = super.getVisibleMemberInScope(name, classes, exclude, visited, enumNameProposals, isFirst, isLast, isOnlyType, skipParents);
        if (result != null) {
            return result;
        }
        IRfNamedElement resolvedModuleOrInstance = this.getResolvedModuleOrInstance();
        if (resolvedModuleOrInstance == null) {
            return null;
        }
        if (visited.contains(resolvedModuleOrInstance)) {
            return null;
        }
        return resolvedModuleOrInstance.getVisibleMemberInScope(name, classes, exclude, visited, enumNameProposals, isFirst, isLast, isOnlyType, skipParents);
    }

    @Override
    protected IRfNamedElement semanticGetMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement initialScope, IRfNamedElement prevScope, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean recursiveCall) {
        IRfNamedElement result = super.semanticGetMember(name, hid, parserPath, initialScope, prevScope, visited, enumNameProposals, isFirst, isLast, recursiveCall);
        if (result != null) {
            return result;
        }
        IRfNamedElement resolvedModuleOrInstance = this.getResolvedModuleOrInstance();
        if (resolvedModuleOrInstance == null) {
            return null;
        }
        if (visited.contains(resolvedModuleOrInstance)) {
            return null;
        }
        return ((RfNamedElement)resolvedModuleOrInstance).semanticGetMember(name, hid, parserPath, initialScope, null, visited, enumNameProposals, isFirst, isLast, recursiveCall);
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_VUNIT);
    }
}

