/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import ro.amiq.dvt.model.reflection.IRfWaitElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.model.reflection.RfMembersHolder;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.parser.MacroCallInfo;

public class RfWait
extends RfMembersHolder
implements IRfWaitElement {
    private static final long serialVersionUID = 2L;
    private int kind;
    private MacroCallInfo macroCallInfo;
    private IHidObject expression;

    public RfWait(String name, boolean escaped, int kind, MacroCallInfo macroCallInfo) {
        super(name, escaped);
        this.kind = kind;
        this.macroCallInfo = macroCallInfo;
    }

    public void init(int kind, MacroCallInfo macroCallInfo) {
        this.kind = kind;
        this.macroCallInfo = macroCallInfo;
    }

    public int getKind() {
        return this.kind;
    }

    public boolean isWaitFork() {
        return this.kind == 1;
    }

    public boolean isWaitOrder() {
        return this.kind == 2;
    }

    public MacroCallInfo getMacroCallInfo() {
        return this.macroCallInfo;
    }

    public IHidObject getExpression() {
        return this.expression;
    }

    public void setExpression(IHidObject expression) {
        this.expression = expression;
    }

    @Override
    public void deepClean() {
        super.deepClean();
        this.macroCallInfo = null;
        this.expression = null;
    }

    @Override
    public void printScope(StringBuilder result, boolean appendThis) {
        RfNamedElement scope = this.getEnclosingScope();
        if (scope != null) {
            scope.printScope(result, true);
        }
        if (appendThis && !this.isAnonymous()) {
            result.append(this.getName()).append('.');
        }
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        switch (this.kind) {
            case 0: {
                return "wait " + this.getName();
            }
            case 1: {
                return "wait_fork " + this.getName();
            }
            case 2: {
                return "wait_order " + this.getName();
            }
        }
        return null;
    }
}

