/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConfiguration;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFragment;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModportPort;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;

public class SearchDependencyContainer {
    private static void collectDependencyList(Collection<? extends IRfNamedElement> namedElements, IRfLibraryElement library, Set<IRfNamedElement> result, boolean checkReferences) {
        try {
            Set visitedElement = Collections.newSetFromMap(new IdentityHashMap());
            for (IRfNamedElement iRfNamedElement : namedElements) {
                Collection references;
                Collection<RfNamedElement> members;
                IRfScopeElement typeContainer;
                if (iRfNamedElement == null || !((typeContainer = iRfNamedElement.getEnclosingScope(VlogRfReferencesUtils.CLOSEST_TYPE_CONTAINER_FOR_REFERENCES)) instanceof IRfNamedElement) || visitedElement.contains(iRfNamedElement)) continue;
                visitedElement.add(iRfNamedElement);
                String typeName = typeContainer.getName();
                if (library == null) continue;
                if (iRfNamedElement instanceof RfPackage && (members = ((RfPackage)iRfNamedElement).getMembers(true, false)) != null && !members.isEmpty()) {
                    SearchDependencyContainer.collectDependencyList(members, library, result, checkReferences);
                }
                if ((references = library.getReferences(typeName)) == null) continue;
                for (IRfNamedElement reference : references) {
                    boolean isInstanceOrModule;
                    if (reference == null || result.contains(reference)) continue;
                    String elementName = iRfNamedElement.getName();
                    boolean bl = isInstanceOrModule = reference instanceof RfInstanceHolder || reference instanceof IRfInstanceElement;
                    if (reference.hasReferenceToIdentifierName(elementName)) {
                        RfNamedElement enclosingScope;
                        if (reference instanceof RfClass && reference.hasNoDefs(false) && !reference.isPredefined() && (enclosingScope = (RfNamedElement)reference.getEnclosingScope()) != null) {
                            RfNamedElement tmpReference = enclosingScope.getLocalMember(RfClass.class, reference.getName(), true);
                            if (tmpReference == null) {
                                tmpReference = enclosingScope.getLocalMember(RfFragment.class, reference.getName(), true);
                            }
                            if (tmpReference != null) {
                                reference = tmpReference;
                            }
                        }
                        result.add(reference);
                        continue;
                    }
                    if (!isInstanceOrModule && !(reference instanceof RfConfiguration)) continue;
                    result.add(reference);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static Set<IRfNamedElement> getAllDependencies(IRfNamedElement element, IRfSingleLangProject singleLangProject, boolean includeDeclarations, boolean semanticSearch, boolean searchForType, boolean overlapScopes) {
        Set<IRfNamedElement> result = new HashSet<IRfNamedElement>();
        if (!searchForType) {
            if (element instanceof RfField && ((RfField)element).isVariable() && !((RfField)element).isStorageStatic() && element.getEnclosingScope() instanceof RfActionBlock && ((RfActionBlock)element.getEnclosingScope()).isForOrForeach()) {
                result.add((RfActionBlock)element.getEnclosingScope());
                return result;
            }
            List<IRfNamedElement> elementsToSearch = VlogRfReferencesUtils.getElementsToSearch(element, includeDeclarations, semanticSearch);
            Collection libraries = singleLangProject.getLibraries();
            if (libraries == null || libraries.isEmpty()) {
                return result;
            }
            for (IRfLibraryElement library : libraries) {
                SearchDependencyContainer.collectDependencyList(elementsToSearch, library, result, true);
            }
            if (element instanceof RfModportPort && element.getEnclosingScope() instanceof RfModport && element.getEnclosingScope().getEnclosingScope() instanceof IRfNamedElement) {
                result.add((IRfNamedElement)element.getEnclosingScope().getEnclosingScope());
            }
        } else {
            ArrayList libraries = new ArrayList();
            IRfScopeElement enclosingScope = element.getEnclosingScope(VlogRfReferencesUtils.CLOSEST_TYPE_CONTAINER_FOR_REFERENCES);
            if (enclosingScope == null) {
                enclosingScope = element.getEnclosingScope();
            }
            String typeName = element.getName();
            if (enclosingScope != null) {
                typeName = enclosingScope.getName();
            }
            Collection projectLibraries = singleLangProject.getLibraries();
            libraries.addAll(projectLibraries);
            if (libraries.isEmpty()) {
                return result;
            }
            for (IRfLibraryElement library : libraries) {
                Collection scopes = library.getReferences(typeName);
                if (scopes == null || scopes.isEmpty()) continue;
                result.addAll(scopes);
            }
            if (overlapScopes && RfSearchUtils.isInstantiable((IRfNamedElement)element)) {
                if (!(element.getEnclosingScope() instanceof RfLibrary)) {
                    result.add((IRfNamedElement)element.getEnclosingScope());
                }
                result = VlogRfReferencesUtils.getNonOverlappingScopes(result);
            }
        }
        return result;
    }
}

