/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.debug.ui.breakpoints.DVTBreakpointUtils;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.BCXmlTopSaverViewType;
import ro.amiq.dvt.ui.views.DVTXmlSaveConfig;
import ro.amiq.dvt.ui.views.HistoryItemType;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.MembersViewInput;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTRfNameTypeScopeHelper;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.NamedElementAndConfigInfo;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfKind;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.RfScopeUtil;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.VlogReflectionContributorCommon;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.views.DHHistoryItem;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.TypesViewMembersLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VlogQuickViewersUtil;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObject;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObjectInstance;
import ro.amiq.vlogdt.parser.RfMacroRefInfo;
import ro.amiq.vlogdt.ui.editor.VlogPartitionScanner;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.vlogdt.ui.editor.quickassist.MethodObjectVisitor;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;

public class VlogReflectionContributor
extends VlogReflectionContributorCommon {
    @Override
    public IRfNamedElementAndScope getRfElement(IFile file, IDocument document, int offset, boolean validateContentType) {
        boolean validContentType;
        if (validateContentType && !(validContentType = RfSearchUtils.validContentType((IProject)file.getProject(), (IDocument)document, (int)offset))) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(file.getProject());
        return RfUtils.getRfElement(rfProject, file, document, offset, null);
    }

    public List<? extends DVTRfNameTypeScopeHelper> getDefOfScopeElement(IRfNamedElement element) {
        if (!(element instanceof RfNamedElement)) {
            return null;
        }
        return RfScopeUtil.getDefOfScopeElement((IRfScopeElement)element);
    }

    public HistoryItem createHistoryItem(DVTXmlSaveConfig config, IProject project, HistoryItemType historyItemType) {
        if (project == null || config == null || historyItemType == null) {
            return null;
        }
        switch (historyItemType) {
            case DESIGN_HIERARCHY_ELABORATION: 
            case SHOW_INSTANCES_IN_DESIGN_HIERARCHY: {
                return VlogQuickViewersUtil.getInstance().createDHHistoryItem(config, project, true, historyItemType);
            }
        }
        return null;
    }

    public HistoryItem getHistoryItemFromBCXmlString(String bcXMLString, IProject project, HistoryItemType historyItemType) {
        if (project == null || bcXMLString == null || bcXMLString.isEmpty() || historyItemType == null) {
            return null;
        }
        switch (historyItemType) {
            case DESIGN_HIERARCHY_ELABORATION: {
                return DHHistoryItem.parseHistoryItem(project.getName(), bcXMLString, true, historyItemType);
            }
        }
        return null;
    }

    public NamedElementAndConfigInfo getNamedElementAndConfigFromHistoryItem(HistoryItem historyItem, IProject project, BCXmlTopSaverViewType viewType) {
        switch (viewType) {
            case DESIGN_HIERARCHY_ELABORATION: {
                RfProject rfProject = RfManager.getInstance().getRfProject(project);
                if (!(historyItem instanceof DHHistoryItem) || rfProject == null) {
                    return null;
                }
                IRfNamedElement namedElement = this.getDHNamedElementFromDVTRfNameTypeScopeHelper(rfProject, ((DHHistoryItem)historyItem).getElementScope());
                String historyConfig = ((DHHistoryItem)historyItem).getConfigurationName();
                String configName = historyConfig == null || historyConfig.isEmpty() ? null : historyConfig;
                return new NamedElementAndConfigInfo(namedElement, configName);
            }
        }
        return null;
    }

    public HistoryItemType getHistoryItemTypeFromHistoryItem(HistoryItem historyItem, IProject project, BCXmlTopSaverViewType viewType) {
        switch (viewType) {
            case DESIGN_HIERARCHY_ELABORATION: {
                RfProject rfProject = RfManager.getInstance().getRfProject(project);
                if (!(historyItem instanceof DHHistoryItem) || rfProject == null) {
                    return null;
                }
                return ((DHHistoryItem)historyItem).getHistoryItemType();
            }
        }
        return null;
    }

    public boolean gotoSelectedMember(IProject project, IDVTElementWrapper element) {
        if (element == null) {
            return false;
        }
        Object elem = element.getRfElement();
        if (!(elem instanceof RfNamedElement)) {
            return false;
        }
        RfUtils.createOpenAction((IRfNamedElement)elem, project, null).open();
        return true;
    }

    public boolean gotoElement(IProject project, Object wrapper) {
        RfNamedElementActionHyperlink actionHyperlink;
        block11: {
            Object object;
            block10: {
                try {
                    object = null;
                    if (wrapper instanceof RfTreeElementWrapper) {
                        object = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
                    } else if (wrapper instanceof RfNamedElement) {
                        object = wrapper;
                    }
                    if (wrapper instanceof RfXvmObjectInstance) {
                        object = ((RfXvmObjectInstance)wrapper).getNamedElement();
                    } else if (wrapper instanceof RfXvmObject) {
                        object = ((RfXvmObject)wrapper).getNamedElement();
                    }
                    if (object != null && object instanceof RfNamedElement) break block10;
                    return false;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return false;
                }
            }
            RfNamedElement element = (RfNamedElement)object;
            actionHyperlink = RfUtils.createOpenAction(element, project, null);
            if (actionHyperlink != null) break block11;
            return false;
        }
        actionHyperlink.open();
        return true;
    }

    public MembersViewInput getMembersInput(IDVTElementWrapper wrapper, StringMatcher stringMatcher, IMembersLabelProvider membersLabelProvider, boolean applyContentFilters) {
        ArrayList<IDVTElementWrapper> elements;
        boolean hasGUIFilteredMembers = false;
        MembersViewInput emptyResult = new MembersViewInput(Collections.emptyList(), false);
        if (wrapper == null) {
            return emptyResult;
        }
        Object rfElement = wrapper.getRfElement();
        if (!(rfElement instanceof RfNamedElement)) {
            return emptyResult;
        }
        RfNamedElement namedElemet = (RfNamedElement)rfElement;
        if (namedElemet instanceof RfTypeAlias) {
            IRfNamedElement assocType = ((RfTypeAlias)namedElemet).getAssociatedType();
            if (!(assocType instanceof RfStruct)) {
                return emptyResult;
            }
            namedElemet = (RfStruct)assocType;
        }
        hasGUIFilteredMembers = this.collectMatchingMembers(elements = new ArrayList<IDVTElementWrapper>(), namedElemet.getLocalMembers(RfFunction.class), stringMatcher, membersLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
        hasGUIFilteredMembers = this.collectMatchingMembers(elements, namedElemet.getLocalMembers(RfField.class), stringMatcher, membersLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
        hasGUIFilteredMembers = this.collectMatchingMembers(elements, namedElemet.getLocalMembers(RfCoverpoint.class), stringMatcher, membersLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
        hasGUIFilteredMembers = this.collectMatchingMembers(elements, namedElemet.getLocalMembers(RfActionBlock.class), stringMatcher, membersLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
        hasGUIFilteredMembers = this.collectMatchingMembers(elements, namedElemet.getLocalMembers(RfModport.class), stringMatcher, membersLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
        hasGUIFilteredMembers = this.collectMatchingMembers(elements, namedElemet.getLocalMembers(RfConstraint.class), stringMatcher, membersLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
        hasGUIFilteredMembers = this.collectMatchingMembers(elements, namedElemet.getLocalMembers(RfPropertySequence.class), stringMatcher, membersLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
        hasGUIFilteredMembers = this.collectMatchingMembers(elements, namedElemet.getLocalMembers(RfClockingBlock.class), stringMatcher, membersLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
        hasGUIFilteredMembers = this.collectMatchingMembers(elements, namedElemet.getLocalMembers(RfInstance.class), stringMatcher, membersLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
        hasGUIFilteredMembers = this.collectMatchingMembers(elements, namedElemet.getLocalMembers(RfAssertExpect.class), stringMatcher, membersLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
        return new MembersViewInput(elements, hasGUIFilteredMembers);
    }

    /*
     * WARNING - void declaration
     */
    private boolean collectMatchingMembers(Collection<IDVTElementWrapper> result, Iterable<? extends RfNamedElement> members, StringMatcher stringMatcher, IMembersLabelProvider membersLabelProvider, boolean applyContentFilters) {
        boolean hasGUIFilteredMembers = false;
        if (members == null) {
            return hasGUIFilteredMembers;
        }
        for (RfNamedElement rfNamedElement : members) {
            void var8_8;
            RfNamedElement rfNamedElement2;
            RfActionBlock actionBlock;
            if (rfNamedElement.isPredefined() || rfNamedElement.getName() == null || rfNamedElement.getName().isEmpty() || rfNamedElement instanceof RfField && ((RfField)rfNamedElement).isVariable() || rfNamedElement instanceof RfField && ((RfField)rfNamedElement).isEnumRangeElement() || rfNamedElement instanceof RfActionBlock && !(actionBlock = (RfActionBlock)rfNamedElement).isNamedBlock() && (rfNamedElement2 = this.getNamedBeginEndInsideAlways(actionBlock)) == null) continue;
            RfTreeElementWrapper elementWrapper = new RfTreeElementWrapper(var8_8, true);
            if (stringMatcher != null && !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)stringMatcher, (String)membersLabelProvider.getText((Object)elementWrapper))) continue;
            if (applyContentFilters && DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.TYPES_MEMBERS, (IRfNamedElement)var8_8, () -> membersLabelProvider.getText((Object)elementWrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                hasGUIFilteredMembers = true;
                continue;
            }
            result.add(elementWrapper);
        }
        return hasGUIFilteredMembers;
    }

    private RfNamedElement getNamedBeginEndInsideAlways(RfActionBlock actionBlock) {
        if (!actionBlock.isAlways()) {
            return null;
        }
        List<RfActionBlock> localActionBlocks = actionBlock.getLocalMembers(RfActionBlock.class);
        if (localActionBlocks == null || localActionBlocks.isEmpty()) {
            return null;
        }
        RfActionBlock beginEnd = (RfActionBlock)localActionBlocks.iterator().next();
        if (beginEnd.isNamedBlock()) {
            return beginEnd;
        }
        return null;
    }

    public IRfKind getKind(IRfNamedElement e) {
        return RfKind.of(e);
    }

    public IMembersLabelProvider getMembersLabelProvider() {
        return new TypesViewMembersLabelProvider();
    }

    public IRfNamedElement getElementAtExactCursor() {
        return VlogQuickViewersUtil.getInstance().getElementAtExactCursor();
    }

    public String computeTraceTextAtLine(IResource resource, int lineNumber) {
        IProject project = resource.getProject();
        if (project == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        ParserPath parserPath = rfProject.resource2parser(resource);
        if (parserPath == null) {
            return null;
        }
        Map<ParserPath, List<RfMacroRefInfo>> macroRefsByFile = rfProject.getPreprocessingTable().getMacroRefsMapByFile();
        List<RfMacroRefInfo> macros = macroRefsByFile.get(parserPath);
        if (macros == null) {
            return "$display(\"TODO edit tracepoint message on line " + lineNumber + " in @" + resource.getName() + "\")";
        }
        HashSet uvmMessageMacros = DVTBreakpointUtils.INSTANCE.getUvmMessageMacros();
        for (RfMacroRefInfo macroRef : macros) {
            String[] params;
            if (!uvmMessageMacros.contains(macroRef.getMacroName()) || macroRef.getLine() != lineNumber || (params = macroRef.getParams()) == null || params.length < 2) continue;
            return "$display(" + DVTBreakpointUtils.INSTANCE.sanitizeTraceText(params[1]) + ")";
        }
        return "$display(\"TODO edit tracepoint message on line " + lineNumber + " in @" + resource.getName() + "\")";
    }

    public void installPartitionerForDocument(LanguageKind lang, IDocument document) {
        if (lang != LanguageKind.VLOG) {
            return;
        }
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new VlogPartitionScanner(), new String[]{"__vlog_sl_comment", "__vlog_ml_comment", "__vlog_literal", "__vlog_escaped_id", "__dftl_partition_content_type"});
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            extension3.setDocumentPartitioner("__vlog_partitioning", (IDocumentPartitioner)partitioner);
        } else {
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        partitioner.connect(document);
    }

    public int getStatementLine(IFile resource, DVTEditor editor, IRfNamedElement namedElement, IRfDefElement scopeDef, int breakpointLine, int offset) {
        if (scopeDef instanceof RfFileDef) {
            return breakpointLine;
        }
        RfNamedElement containerNamedElement = ((RfDefElement)scopeDef).getNamedElement();
        if (containerNamedElement == null) {
            return -1;
        }
        int functionStartLine = this.getFunctionStartLine(offset, containerNamedElement);
        if (functionStartLine != -1) {
            return functionStartLine;
        }
        int fieldDefStartLine = this.getFieldDefStartLine(scopeDef, breakpointLine);
        if (fieldDefStartLine != -1) {
            return fieldDefStartLine;
        }
        RfHidHolder hidHolder = containerNamedElement.getHidHolder();
        if (hidHolder == null || hidHolder.isEmpty() || hidHolder.isHidObjectsEmpty()) {
            return this.isCondition(editor, scopeDef, breakpointLine) ? breakpointLine : -1;
        }
        RfHidOperator completeHidOperator = null;
        Map hidObjectsMap = hidHolder.getHidObjectsMap();
        int maxOffset = offset + DVTFileUtils.getInstance().getLineLength(resource, breakpointLine - 1);
        boolean isolatedHid = false;
        int alternativeBreakpointLine = breakpointLine;
        for (ListContainer hidsListContainer : hidObjectsMap.values()) {
            if (hidsListContainer.isEmpty()) continue;
            for (IHidObject hid : hidsListContainer) {
                if (hid instanceof RfHid && ((RfHid)hid).getLine() == breakpointLine && (functionStartLine = this.getFunctionStartLineFromHid(breakpointLine, hid)) != -1) {
                    return functionStartLine;
                }
                if (hid instanceof RfHid && !isolatedHid && (isolatedHid = this.isHidInAccess(breakpointLine, hid))) {
                    alternativeBreakpointLine = ((RfHid)hid).getLine();
                }
                if (!(hid instanceof RfHidOperator)) continue;
                RfHidOperator currentOperator = (RfHidOperator)hid;
                if (completeHidOperator != null) {
                    if (!this.isLineInHidOperator(currentOperator, completeHidOperator.getOpenBoundary(), completeHidOperator.getCloseBoundary())) continue;
                    completeHidOperator = currentOperator;
                    continue;
                }
                if (currentOperator.getLine() == breakpointLine) {
                    completeHidOperator = currentOperator;
                    continue;
                }
                if (!this.isLineInHidOperator(currentOperator, offset, maxOffset)) continue;
                completeHidOperator = currentOperator;
            }
        }
        if (completeHidOperator == null && isolatedHid) {
            return alternativeBreakpointLine;
        }
        if (completeHidOperator == null) {
            return this.isCondition(editor, scopeDef, breakpointLine) ? breakpointLine : -1;
        }
        return DVTFileUtils.getInstance().getLineFromOffset(resource, completeHidOperator.getOpenBoundary());
    }

    private boolean isHidInAccess(int breakpointLine, IHidObject hid) {
        RfHid currentHid = (RfHid)hid;
        while (currentHid != null) {
            if (currentHid.getLine() == breakpointLine) {
                return true;
            }
            HidAccess access = currentHid.getFirstAccess();
            if (access == null || !(access.getFirstHid() instanceof RfHid)) {
                return false;
            }
            currentHid = (RfHid)access.getFirstHid();
        }
        return false;
    }

    private boolean isCondition(DVTEditor editor, IRfDefElement scopeDef, int lineBreakpoint) {
        int openParenLine;
        RfDefElement closestNextActionBlock;
        block16: {
            IRegion openParenRegion;
            IDocument document;
            block15: {
                ICharacterPairMatcher bracketMatcher;
                int closedParenOffset;
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                document = editor.getDocument();
                                if (document != null) break block11;
                                return false;
                            }
                            Collection<RfDefElement> children = ((RfDefElement)scopeDef).getChildren();
                            closestNextActionBlock = null;
                            if (children != null) {
                                for (RfDefElement child : children) {
                                    if (!(child instanceof RfActionBlockDef)) continue;
                                    RfActionBlockDef childActionBlockDef = (RfActionBlockDef)child;
                                    if (child.getStartLine() < lineBreakpoint) continue;
                                    RfActionBlock childActionBlock = (RfActionBlock)child.getNamedElement();
                                    if (!childActionBlock.isIf() && !childActionBlock.isWhile()) break;
                                    closestNextActionBlock = childActionBlockDef;
                                    break;
                                }
                            }
                            if (closestNextActionBlock != null) break block12;
                            return false;
                        }
                        closedParenOffset = VlogQuickFixUtil.getInstance().getBackwardOffsetFor(document, ")", document.getLineOffset(closestNextActionBlock.getStartLine() - 1), closestNextActionBlock.getStartOffset() + 1, false);
                        if (closedParenOffset >= 0) break block13;
                        return false;
                    }
                    bracketMatcher = editor.getBracketMatcher();
                    if (bracketMatcher != null) break block14;
                    return false;
                }
                openParenRegion = bracketMatcher.match(document, closedParenOffset);
                if (openParenRegion != null) break block15;
                return false;
            }
            int openParenOffset = openParenRegion.getOffset();
            openParenLine = document.getLineOfOffset(openParenOffset);
            if (openParenLine >= 0) break block16;
            return false;
        }
        try {
            if (openParenLine <= lineBreakpoint && lineBreakpoint <= closestNextActionBlock.getStartLine()) {
                return true;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    private boolean isLineInHidOperator(RfHidOperator currentOperator, int startOffset, int endOffset) {
        int openBoundary = currentOperator.getOpenBoundary();
        int closeBoundary = currentOperator.getCloseBoundary();
        return Math.min(closeBoundary, endOffset) >= Math.max(openBoundary, startOffset);
    }

    private int getFunctionStartLineFromHid(int breakpointLine, IHidObject hid) {
        HidAccess access;
        RfHid currentHid = (RfHid)hid;
        if (currentHid.getElement() instanceof RfFunction) {
            return breakpointLine;
        }
        while ((access = currentHid.getFirstAccess()) != null && access.getFirstHid() instanceof RfHid && (currentHid = (RfHid)access.getFirstHid()) != null && !(currentHid.getElement() instanceof RfFunction)) {
        }
        if (currentHid != null && (currentHid.getElement() instanceof RfFunction || currentHid.getFirstAccess() instanceof RfHidAccessArgs)) {
            return currentHid.getLine();
        }
        return -1;
    }

    private int getFieldDefStartLine(IRfDefElement scopeDef, int breakpointLine) {
        int startLine = -1;
        Collection<RfDefElement> children = ((RfDefElement)scopeDef).getChildren();
        if (children != null) {
            for (RfDefElement child : children) {
                RfFieldDef childDef;
                if (!(child instanceof RfFieldDef) || (childDef = (RfFieldDef)child).getStartLine() > breakpointLine || breakpointLine > childDef.getEndLine()) continue;
                return childDef.getStartLine();
            }
        }
        return startLine;
    }

    private int getFunctionStartLine(int startOffset, RfNamedElement containerNamedElement) {
        MethodObjectVisitor methodObjVisitor = new MethodObjectVisitor(startOffset);
        containerNamedElement.visitHidObject(containerNamedElement.getRfProject(), methodObjVisitor);
        IHidObject methodObjFound = methodObjVisitor.getFound();
        if (methodObjFound instanceof RfHidAccessArgs) {
            return ((RfHidAccessArgs)methodObjFound).getParentHid().getLine();
        }
        return -1;
    }
}

