/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import ro.amiq.dvt.buildconfig.BCFileInstance;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.debug.core.model.breakpoints.LineBreakpoint;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.ch.CHDiagram;
import ro.amiq.dvt.diagrams.ch.CHDiagram2;
import ro.amiq.dvt.diagrams.ch.ICHDiagram;
import ro.amiq.dvt.diagrams.ch.model.CHRoot;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.indexer.IdentifierIndexerManager;
import ro.amiq.dvt.model.persistence.PersistenceBase;
import ro.amiq.dvt.model.reflection.IReflectionContributor;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTRfNameTypeScopeHelper;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vlogdt.diagrams.chd.VlogCHModel;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.model.indexer.IdentifierIndexer;
import ro.amiq.vlogdt.model.persistence.Persistence;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedActionBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfScopeUtil;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogMacroZone;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;
import ro.amiq.vlogdt.ui.editor.VlogDebugSourceViewerConfiguration;
import ro.amiq.vlogdt.ui.editor.VlogSourceViewerConfiguration;
import ro.amiq.vlogdt.utils.Utils;

public abstract class VlogReflectionContributorCommon
implements IReflectionContributor {
    public boolean hasHits(IFile file, String[] names, Matcher matcher, boolean isRegexp) {
        return IdentifierIndexerManager.getInstance().hasHits(IdentifierIndexer.class, file, names, matcher, isRegexp);
    }

    public boolean hasHits(ParserPath file, IProject project, String[] names, Matcher matcher, boolean isRegexp) {
        return IdentifierIndexerManager.getInstance().hasHits(IdentifierIndexer.class, file, project, names, matcher, isRegexp);
    }

    public IRfSingleLangProject makeRfProject(IProject project, RfMixedLangProject rfMixedLangProject) {
        return new RfProject(project, rfMixedLangProject);
    }

    public PersistenceBase makePersistence(IProject project) {
        return new Persistence(project);
    }

    public DVTSourceViewerConfiguration getSourceViewerConfiguration() {
        return new VlogSourceViewerConfiguration();
    }

    public DVTSourceViewerConfiguration getDebugSourceViewerConfiguration(LineBreakpoint breakpoint, ISourceViewer viewer) {
        return new VlogDebugSourceViewerConfiguration(breakpoint, viewer);
    }

    public String getNature() {
        return "ro.amiq.vlogdt.VlogNature";
    }

    public boolean isEnabled(IProject project) {
        try {
            return project.hasNature("ro.amiq.vlogdt.VlogNature");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public List<? extends IDVTFileInstance> getFileInstances(IProject project, ParserPath path) {
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        VlogPreprocessingInfo preprocessingTable = rfProject.getPreprocessingTable();
        if (preprocessingTable == null) {
            return null;
        }
        VlogFileInstance topInstance = preprocessingTable.getTopFileInstance();
        if (topInstance == null) {
            return null;
        }
        return topInstance.getFileInstances(path);
    }

    public IRfNamedElement getDHTransformedNamedElement(IRfNamedElement element) {
        List<? extends DVTRfNameTypeScopeHelper> defOfScopeElement = RfScopeUtil.getDefOfScopeElement((IRfScopeElement)element);
        return this.getDHNamedElementFromDVTRfNameTypeScopeHelper(element.getRfProject(), defOfScopeElement);
    }

    protected IRfNamedElement getDHNamedElementFromDVTRfNameTypeScopeHelper(IRfSingleLangProject rfProject, List<? extends DVTRfNameTypeScopeHelper> defOfScopeElement) {
        if (rfProject == null) {
            return null;
        }
        IRfScopeElement scope = RfScopeUtil.getScopeElementOfDef((IRfScopeElement)rfProject, defOfScopeElement);
        if (scope == null || scope instanceof IRfSingleLangProject || scope instanceof RfLibrary || !(scope instanceof IRfNamedElement)) {
            return null;
        }
        return (IRfNamedElement)scope;
    }

    public CHRoot makeSubRoot(ICHDiagram input, DProgressMonitor monitor) throws DCanceledException {
        if (input instanceof CHDiagram) {
            return super.makeSubRoot(input, monitor);
        }
        IDVTElementWrapper newWrapper = input.getComponent().getWrapper();
        ((CHDiagram2)input).setWrapper(newWrapper);
        return VlogCHModel.getInstance().makeComponentDiagramFor(input, monitor);
    }

    public IHidObject parsePattern(String pattern, String defaultKeywordSet, Map<String, String> extensionKeywordsetMap, IBuildConfigParserConstants.ToolCompat toolCompat, boolean isAssert, IRfSingleLangProject rfProject) {
        return Utils.getInstance().parsePattern(pattern, defaultKeywordSet, extensionKeywordsetMap, toolCompat, isAssert, (RfProject)rfProject);
    }

    public void clearBacklogElements(IProject project) {
        RfProject rfProjectWithoutRestore = RfManager.getInstance().getRfProjectWithoutRestore(project);
        if (rfProjectWithoutRestore != null) {
            rfProjectWithoutRestore.getChangedFilesManager().clear();
        }
    }

    public void addBacklogElement(IProject project, FileCompileInfo info) {
        RfProject rfProjectWithoutRestore = RfManager.getInstance().getRfProjectWithoutRestore(project);
        if (rfProjectWithoutRestore == null) {
            return;
        }
        rfProjectWithoutRestore.getChangedFilesManager().addBacklogElements(new LinkedHashSet<FileCompileInfo>(Collections.singleton(info)));
    }

    public Set<FileCompileInfo> getChangedElements(IProject project) {
        RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
        if (rfProject != null) {
            return rfProject.getChangedFilesManager().getBacklogElements();
        }
        return null;
    }

    public void cbIncrementalBuild(IProgressMonitor monitor, FileCompileInfo changedElement, IDocument document, IProject project) {
        VlogModelManager.getInstance().cbIncrementalBuild(monitor, changedElement, document, true);
    }

    public void restoreInvocationsInfo(IProject project, Map<String, BCFileInstance> buildConfigFiles) {
        RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
        if (rfProject != null) {
            rfProject.restoreInvocationsInfo(null, null, buildConfigFiles);
        }
    }

    public ParserPath getRfHidParserPath(IHidObject statement) {
        if (statement instanceof HidEvalCenter.MethodCallPlaceholder) {
            HidEvalCenter.MethodCallPlaceholder methodPlaceholder = (HidEvalCenter.MethodCallPlaceholder)statement;
            IHidObject iHidObject = methodPlaceholder.getHidOrAccess();
            if (!(iHidObject instanceof HidAccess)) {
                return null;
            }
            HidAccess hidAccess = (HidAccess)iHidObject;
            RfHid parentHid = (RfHid)hidAccess.getParentHid();
            if (parentHid == null) {
                return null;
            }
            VlogMacroZone parentMacroZone = parentHid.getMacroZone();
            if (parentMacroZone != null) {
                return parentMacroZone.getParserPath();
            }
            return null;
        }
        if (statement instanceof RfHidOperator) {
            VlogMacroZone macroZone = ((RfHidOperator)statement).getMacroZone();
            return macroZone == null ? null : macroZone.getParserPath();
        }
        return null;
    }

    public IRfActionBlockElement createVcdActionBlock(IRfNamedElement enclosingScope) {
        if (!(enclosingScope instanceof RfNamedElement)) {
            return null;
        }
        IRfDefElement enclosingScopeDeclaration = enclosingScope.getDeclaration();
        if (!(enclosingScopeDeclaration instanceof RfDefElement)) {
            return null;
        }
        String vcdFileName = "\"dvt_wave/dvt_wave.vcd\"";
        RfNamedActionBlock vcdDummyActionBlock = new RfNamedActionBlock("vcd block", false, IRfActionBlockElement.BlockQualifier.INITIAL.value(), (RfNamedElement)enclosingScope, null, 0, true);
        RfActionBlockDef vcdDummyActionBlockDef = new RfActionBlockDef(((RfDefElement)enclosingScopeDeclaration).getDefFile(), "vcd block", LineInfo.INFINITE, LineInfo.INFINITE, null, null);
        vcdDummyActionBlock.addDeclaration(vcdDummyActionBlockDef);
        ParserPath parserPath = vcdDummyActionBlockDef.getParserPath();
        RfHidHolder hidHolder = vcdDummyActionBlock.getOrCreateHidHolder();
        HidOccurrence taskHidOccurrence = new HidOccurrence(-1, -1, -1, HidQualifierCache.STATEMENT_QUALIFIER, null);
        HidOperatorOccurrence argumentConnectionOccurrence = new HidOperatorOccurrence(-1, -1, -1, HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER, null);
        RfHid dumpFileDummyHid = RfHid.create("$dumpfile", null, enclosingScope.getMember("$dumpfile", null, null, true, true, false, false, false), taskHidOccurrence, null);
        hidHolder.addHid(dumpFileDummyHid, parserPath);
        RfHid fileNameHid = RfHid.create(IHidImplicitConstants.ImplicitType.IMPLICIT_CONNECTED_STRING, null, dumpFileDummyHid.getElement().getMember("filename", null, null, true, true, false, false, false), HidOccurrence.DUMMY_OCCURRENCE, null);
        RfHidImplicit actualArgHid = RfHidImplicit.makeImplicit(vcdFileName, 557);
        RfHidOperator argConnection = RfHidOperator.create(IHidOperatorConstants.OperatorType.ASSOCIATION.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, ".", argumentConnectionOccurrence, null);
        argConnection.setLHValue((IHidObject)fileNameHid);
        argConnection.setRHValues((ListContainer)actualArgHid);
        dumpFileDummyHid.addAccess(new RfHidAccessArgs(Integer.MIN_VALUE, null, Arrays.asList(argConnection), null, null));
        RfHid dumpVarsHid = RfHid.create("$dumpvars", null, enclosingScope.getMember("$dumpvars", null, null, true, true, false, false, false), taskHidOccurrence, null);
        RfHid levelArgHid = RfHid.create(IHidImplicitConstants.ImplicitType.IMPLICIT_CONNECTED_STRING, null, dumpVarsHid.getElement().getMember("levels", null, null, true, true, false, false, false), HidOccurrence.DUMMY_OCCURRENCE, null);
        RfHidImplicit levelArgHidHid = RfHidImplicit.makeImplicit("0", IHidImplicitConstants.ImplicitType.QUA_NUMBER.id);
        RfHidOperator argConnection1 = RfHidOperator.create(IHidOperatorConstants.OperatorType.ASSOCIATION.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, ".", argumentConnectionOccurrence, null);
        argConnection1.setLHValue((IHidObject)levelArgHid);
        argConnection1.setRHValues((ListContainer)levelArgHidHid);
        RfHid topModuleArgHid = RfHid.create(IHidImplicitConstants.ImplicitType.IMPLICIT_CONNECTED_STRING, null, dumpVarsHid.getElement().getMember("list_of_modules_or_variables", null, null, true, true, false, false, false), HidOccurrence.DUMMY_OCCURRENCE, null);
        RfHid topModuleArgHidHid = RfHid.create(enclosingScope.getName(), null, enclosingScope, taskHidOccurrence, null);
        RfHidOperator argConnection2 = RfHidOperator.create(IHidOperatorConstants.OperatorType.ASSOCIATION.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, ".", argumentConnectionOccurrence, null);
        argConnection2.setLHValue((IHidObject)topModuleArgHid);
        argConnection2.setRHValues((ListContainer)topModuleArgHidHid);
        hidHolder.addHid(topModuleArgHidHid, parserPath);
        hidHolder.addHid(dumpVarsHid, parserPath);
        dumpVarsHid.addAccess(new RfHidAccessArgs(Integer.MIN_VALUE, null, Arrays.asList(argConnection1, argConnection2), null, null));
        return vcdDummyActionBlock;
    }

    public IRfNamedElementAndScope getRfElement(IFile file, IDocument document, int offset, boolean validateContentType) {
        boolean validContentType;
        if (validateContentType && !(validContentType = RfSearchUtils.validContentType((IProject)file.getProject(), (IDocument)document, (int)offset))) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(file.getProject());
        return RfUtils.getRfElement(rfProject, file, document, offset, null);
    }
}

