/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.ovm.fieldeditor;

import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FEConstants;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.XVMElementModel;
import ro.amiq.vlogdt.parser.RfMacroRefInfo;

public class ClassModel
extends XVMElementModel
implements Cloneable {
    private RfClass fRfClass;

    public ClassModel(RfClass rfClass, String regMacroName, String name, boolean registered, boolean corrupted, String corruptionReason, FEConstants constants) {
        this.fName = name;
        this.fRegistered = registered;
        this.fCorrupted = corrupted;
        this.fCorruptionReason = corruptionReason;
        this.fRfClass = rfClass;
        this.fMacroName = regMacroName;
        this.fConstants = constants;
    }

    public ClassModel(RfClass rfClass, String regMacroName, RfMacroRefInfo macroRef, String name, FEConstants constants) {
        this.fName = name;
        this.fRegistered = true;
        this.fCorrupted = false;
        this.fRfClass = rfClass;
        this.fMacroRef = macroRef;
        this.fMacroName = regMacroName;
        this.fConstants = constants;
    }

    public RfClass getRfClass() {
        return this.fRfClass;
    }

    public void setRfClass(RfClass rfClass) {
        this.fRfClass = rfClass;
    }

    @Override
    protected void setDefault(boolean state) {
    }

    @Override
    public ClassModel clone() {
        ClassModel result = new ClassModel(this.fRfClass, this.fMacroName, this.fMacroRef, this.fName, this.fConstants);
        result.setRegistered(this.fRegistered);
        result.setCorrupted(this.fCorrupted);
        result.setCorruptionReason(this.fCorruptionReason);
        result.setMacroName(this.fMacroName);
        return result;
    }

    @Override
    public boolean hasAnyFlags() {
        return true;
    }

    @Override
    public String getSignature() {
        return this.getName();
    }

    public void makeSingleLineMacro() {
        if (this.fConstants.OVM_DOUBLE_TO_SINGLE_MACROS.containsKey(this.fMacroName)) {
            this.fMacroName = this.fConstants.OVM_DOUBLE_TO_SINGLE_MACROS.get(this.fMacroName);
        }
    }

    public void makeDoubleLineMacro() {
        if (this.fConstants.OVM_SINGLE_TO_DOUBLE_MACROS.containsKey(this.fMacroName)) {
            this.fMacroName = this.fConstants.OVM_SINGLE_TO_DOUBLE_MACROS.get(this.fMacroName);
        }
    }

    @Override
    public String getStatusMessage() {
        if (this.getStatus() == 13) {
            return this.fCorruptionReason;
        }
        if (this.getStatus() == 12) {
            return "This class is registered with `" + this.getEditorMacroName() + " instead of `" + this.getDVTMacroName() + ".";
        }
        return this.fConstants.STATUS_STRINGS.get(this.getStatus());
    }
}

