/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.ovm.fieldeditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.ui.editor.VlogSourceViewerConfiguration;

public class DocumentMirror {
    private int fStartLine;
    private int fEndLine;
    private boolean fInsertMode;
    private IDocument fDocument;
    private IProject fProject;
    private ArrayList<LineWrapper> fLines = new ArrayList();

    public DocumentMirror(IDocument document, int line, IProject project) {
        this.fDocument = document;
        this.fInsertMode = true;
        this.fStartLine = line;
        this.fProject = project;
    }

    public DocumentMirror(IDocument document, int startLine, int endLine) throws BadLocationException {
        this.fDocument = document;
        this.fInsertMode = false;
        this.fStartLine = startLine;
        this.fEndLine = endLine;
        int line = startLine;
        while (line <= endLine) {
            this.fLines.add(new LineWrapper(DVTStringUtil.replaceAll((Pattern)DVTStringUtil.NEW_LINE, (CharSequence)this.fDocument.get(this.fDocument.getLineOffset(line - 1), this.fDocument.getLineLength(line - 1)), (String)"")));
            ++line;
        }
    }

    public void replaceLine(int lineNo, String text) {
        int relativeLine = lineNo - this.fStartLine;
        if (relativeLine < 0 || relativeLine >= this.fLines.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.fLines.remove(relativeLine);
        this.insertText(lineNo, text);
    }

    public void insertText(int lineNo, String text) {
        int relativeLine = lineNo - this.fStartLine;
        if (relativeLine < 0 || relativeLine > this.fLines.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        List<String> lines = Arrays.asList(text.split("(\r\n|\r|\n)"));
        Collections.reverse(lines);
        for (String line : lines) {
            this.fLines.add(relativeLine, new LineWrapper(line));
        }
    }

    public void appendText(String text) {
        List<String> lines = Arrays.asList(text.split("(\r\n|\r|\n)"));
        Collections.reverse(lines);
        for (String line : lines) {
            this.fLines.add(new LineWrapper(line));
        }
    }

    public void removeLine(int lineNo) {
        int relativeLine = lineNo - this.fStartLine;
        if (relativeLine < 0 || relativeLine >= this.fLines.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.fLines.remove(relativeLine);
    }

    public void updateDocument() throws BadLocationException {
        this.fDocument.replace(this.getReplacementOffset(), this.getReplacementLength(), this.getReplacementString());
        this.fInsertMode = false;
        this.fEndLine = this.fStartLine + this.fLines.size();
    }

    public String getReplacementString() {
        return Utils.formatString(() -> new VlogSourceViewerConfiguration(null, false), (String)this.getText(), (IDocument)this.fDocument, (String)Utils.getStartIndentation((int)(this.fStartLine - 2), (IDocument)this.fDocument), (boolean)false);
    }

    public int getReplacementOffset() throws BadLocationException {
        return this.fDocument.getLineOffset(this.fStartLine - 1);
    }

    public int getReplacementLength() throws BadLocationException {
        return this.fInsertMode ? 0 : this.fDocument.getLineOffset(this.fEndLine - 1) + this.fDocument.getLineLength(this.fEndLine - 1) - this.fDocument.getLineOffset(this.fStartLine - 1);
    }

    String getText() {
        String lineDelimiter = DVTDocumentCommon.getLineDelimiterByProject((IProject)this.fProject);
        StringBuilder result = this.fInsertMode ? new StringBuilder(lineDelimiter) : new StringBuilder();
        for (LineWrapper lineWrapper : this.fLines) {
            if (lineWrapper.fRemove) continue;
            result.append(lineWrapper).append(lineDelimiter);
        }
        return result.toString();
    }

    public void markForRemoval(int lineNo) {
        int relativeLine = lineNo - this.fStartLine;
        if (relativeLine < 0 || relativeLine >= this.fLines.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.fLines.get(relativeLine).markForRemoval();
    }

    private static class LineWrapper {
        String fLine;
        boolean fRemove;

        public LineWrapper(String line) {
            this.fLine = line;
        }

        private void markForRemoval() {
            this.fRemove = true;
        }

        public String toString() {
            return this.fLine;
        }
    }
}

