/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.ovm.fieldeditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.ClassModel;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FEConstants;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FEUtils;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FieldModel;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FieldOperationsAndRadixComponent;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.XVMElementModel;
import ro.amiq.vlogdt.model.reflection.views.THViewLabelProvider;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;

public class FEDialog
extends TrayDialog {
    private CheckboxTableViewer fTableViewer;
    private CheckboxTableViewer fClassViewer;
    private Text fMessageLabel;
    private Label fMacroLabel;
    private Button fFixButton;
    private List<XVMElementModel> fInput;
    private List<ClassModel> fClassInput;
    private List<XVMElementModel> fSelection;
    private String fClassName;
    private Label fSummaryLabel;
    private FEConstants fConstants;
    private Label fGUIFilteredIndication;
    private boolean fHasGUIFilteredElements;
    private Button fSelectAllFieldsButton;
    private Button fDeselectAllFieldsButton;
    private FieldOperationsAndRadixComponent fieldOperationAndRadixComponent;

    public FEDialog(Shell parentShell, String className, FEConstants constants) {
        super(parentShell);
        this.fClassName = className;
        this.fConstants = constants;
        this.setHelpAvailable(false);
    }

    public void setInput(List<XVMElementModel> input, List<ClassModel> classModel, boolean hasGUIFilteredElements) {
        this.fClassInput = classModel;
        this.fInput = input;
        this.fHasGUIFilteredElements = hasGUIFilteredElements;
    }

    public void setSelection(XVMElementModel selection) {
        this.fSelection = new ArrayList<XVMElementModel>();
        this.fSelection.add(selection);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(String.valueOf(this.fConstants.PREFIX.toUpperCase()) + " Field Editor ");
        if (this.fConstants.METHODLOGY == 0) {
            shell.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_FIELD_REGISTERED));
        } else if (this.fConstants.METHODLOGY == 1) {
            shell.setImage(DVTImages.imageCache.getImage(DVTImages.UVM_FIELD_REGISTERED));
        }
    }

    protected boolean isResizable() {
        return true;
    }

    public int open() {
        if (this.fClassInput == null) {
            return 7;
        }
        return super.open();
    }

    public boolean close() {
        if (this.getReturnCode() == 1) {
            return super.close();
        }
        if (!this.isValid()) {
            FEUtils.showError(this.getShell(), "Invalid input", "Please select at least a flag for field '" + this.fSelection.get(0).getName() + "'");
            return false;
        }
        return super.close();
    }

    private boolean isValid() {
        return this.fSelection == null || this.fSelection.size() != 1 || !this.fSelection.get(0).isRegistered() || this.fSelection.get(0).isCorrupted() || this.fSelection.get(0).hasAnyFlags();
    }

    private boolean isClassChecked() {
        return this.fClassViewer.getCheckedElements() != null && this.fClassViewer.getCheckedElements().length > 0;
    }

    private void setData() {
        this.fClassViewer.setInput(this.fClassInput);
        this.fTableViewer.setInput(this.fInput);
        if (this.fSelection != null) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(this.fSelection), true);
        } else {
            this.updateOnSelectionChange(new StructuredSelection(new Object[0]));
        }
        this.fTableViewer.getTable().setEnabled(this.isClassChecked());
        this.fSelectAllFieldsButton.setEnabled(this.isClassChecked());
        this.fDeselectAllFieldsButton.setEnabled(this.isClassChecked());
    }

    private void updateOnSelectionChange(StructuredSelection selection) {
        if (!this.isValid()) {
            FEUtils.showError(this.getShell(), "Invalid input", "Please select at least a flag for field '" + this.fSelection.get(0).getName() + "'");
            return;
        }
        this.fSelection = selection.toList();
        if (this.fSelection.isEmpty()) {
            this.enableBoxes(false);
            this.setMessageLabel(3, "Please select fields from the list on the left.");
            this.setMacroLabel(3, "");
        } else if (this.fSelection.size() == 1) {
            XVMElementModel selModel = this.fSelection.get(0);
            if (selModel instanceof FieldModel) {
                this.fClassViewer.setSelection(null);
            } else if (selModel instanceof ClassModel) {
                this.fTableViewer.setSelection(null);
            }
            this.setSelection(selModel);
            if (!this.isClassChecked() && selModel instanceof FieldModel) {
                return;
            }
            if (selModel instanceof FieldModel) {
                this.enableBoxes(selModel.isRegistered() && !selModel.isCorrupted());
            } else {
                this.enableBoxes(false);
            }
            this.fFixButton.setEnabled(selModel.getStatus() == 12);
            this.setMessageLabel(selModel.getStatusSeverity(), selModel.getStatusMessage());
            this.setMacroLabel(selModel.getStatusSeverity(), selModel.getEditorMacroName());
        }
    }

    private void setMessageLabel(int severity, String message) {
        switch (severity) {
            case 1: {
                DVTColorUtil.INSTANCE.setBackground((Control)this.fMessageLabel, DVTUiUtils.COLOR_GREEN);
                this.fMessageLabel.setText(message);
                break;
            }
            case 2: {
                DVTColorUtil.INSTANCE.setBackground((Control)this.fMessageLabel, DVTUiUtils.COLOR_YELLOW);
                this.fMessageLabel.setText(message);
                break;
            }
            case 3: {
                DVTColorUtil.INSTANCE.setBackground((Control)this.fMessageLabel, DVTUiUtils.COLOR_RED);
                this.fMessageLabel.setText(message);
            }
        }
    }

    private void setMacroLabel(int severity, String macroName) {
        this.fMacroLabel.setText(macroName);
        if (macroName.equals("")) {
            DVTColorUtil.INSTANCE.setBackground((Control)this.fMacroLabel, DVTColorUtil.INSTANCE.getBackground((Control)this.fMacroLabel.getParent()));
        } else {
            switch (severity) {
                case 1: {
                    DVTColorUtil.INSTANCE.setBackground((Control)this.fMacroLabel, DVTUiUtils.COLOR_GREEN);
                    break;
                }
                case 2: {
                    DVTColorUtil.INSTANCE.setBackground((Control)this.fMacroLabel, DVTUiUtils.COLOR_YELLOW);
                    break;
                }
                case 3: {
                    DVTColorUtil.INSTANCE.setBackground((Control)this.fMacroLabel, DVTUiUtils.COLOR_RED);
                }
            }
        }
    }

    public void saveElementData(String fieldsOperation, String fieldRadix) {
        List<String> fieldsOperationList = Arrays.asList(fieldsOperation.split(","));
        if (this.fSelection.isEmpty() || this.fSelection.get(0) instanceof ClassModel) {
            return;
        }
        this.fSelection.get(0).setRegistered(this.fTableViewer.getChecked((Object)this.fSelection.get(0)));
        int i = 0;
        while (i < this.fConstants.FIELD_OPERATIONS.length) {
            this.fSelection.get(0).setOperation(i, fieldsOperationList.contains(this.fConstants.FIELD_OPERATIONS[i]));
            ++i;
        }
        boolean radixSet = false;
        int i2 = 0;
        while (i2 < this.fConstants.PRINT_RADIXES.length) {
            if (this.fConstants.PRINT_RADIXES[i2].equals(fieldRadix)) {
                this.fSelection.get(0).setRadix(i2);
                radixSet = true;
                break;
            }
            ++i2;
        }
        if (!radixSet) {
            this.fSelection.get(0).clearRadix();
        }
    }

    private void updateSummary() {
        int total = 0;
        int registered = 0;
        int errors = 0;
        int warnings = 0;
        for (XVMElementModel xVMElementModel : this.fInput) {
            if (!(xVMElementModel instanceof FieldModel)) continue;
            ++total;
            if (!xVMElementModel.isRegistered()) continue;
            ++registered;
            if (xVMElementModel.getStatusSeverity() == 3) {
                ++errors;
            }
            if (xVMElementModel.getStatusSeverity() != 2) continue;
            ++warnings;
        }
        for (XVMElementModel xVMElementModel : this.fClassInput) {
            if (!(xVMElementModel instanceof ClassModel)) continue;
            xVMElementModel.getStatusSeverity();
        }
        this.fSummaryLabel.setText("Class " + this.fClassName + "  [" + registered + "/" + total + " fields registered]  [" + errors + " errors]  [" + warnings + " warnings]");
    }

    private void updateOnRegister(boolean newState, boolean fix) {
        for (XVMElementModel model : this.fSelection) {
            HashSet<String> operations = new HashSet<String>();
            String radix = "";
            if (fix && model instanceof FieldModel) {
                operations.addAll(((FieldModel)model).getOperations());
                radix = ((FieldModel)model).getRadix();
            }
            if (this.isClassChecked() || model instanceof ClassModel) {
                model.performRegistration(newState);
            }
            if (fix && model instanceof FieldModel) {
                ((FieldModel)model).setOperations(operations);
                ((FieldModel)model).setRadix(radix);
            }
            if (!fix && model instanceof ClassModel) {
                this.fTableViewer.getTable().setEnabled(this.isClassChecked());
                this.fSelectAllFieldsButton.setEnabled(this.isClassChecked());
                this.fDeselectAllFieldsButton.setEnabled(this.isClassChecked());
            }
            if (this.fSelection.size() != 1 || fix) continue;
            if (this.fSelection.get(0) instanceof FieldModel) {
                this.enableBoxes(newState);
                continue;
            }
            this.enableBoxes(false);
        }
        this.fClassViewer.refresh();
        this.fTableViewer.refresh();
        if (this.fClassViewer.getCheckedElements() != null && this.fClassViewer.getCheckedElements().length == 1) {
            if (this.fTableViewer.getCheckedElements() == null || this.fTableViewer.getCheckedElements().length == 0) {
                singleClass = (ClassModel)this.fClassViewer.getCheckedElements()[0];
                singleClass.makeSingleLineMacro();
            } else if (this.fTableViewer.getCheckedElements() != null && this.fTableViewer.getCheckedElements().length > 0) {
                singleClass = (ClassModel)this.fClassViewer.getCheckedElements()[0];
                singleClass.makeDoubleLineMacro();
            }
        } else {
            singleClass = (ClassModel)this.fClassViewer.getElementAt(0);
            if (singleClass.getRfClass().getDeclaration().getChildren() == null || singleClass.getRfClass().getDeclaration().getChildren().isEmpty()) {
                singleClass.makeSingleLineMacro();
            } else {
                singleClass.makeDoubleLineMacro();
            }
        }
        if (!this.fSelection.isEmpty()) {
            if (this.fSelection.get(0) instanceof ClassModel) {
                this.fClassViewer.setSelection((ISelection)new StructuredSelection(this.fSelection));
            } else {
                this.fTableViewer.setSelection((ISelection)new StructuredSelection(this.fSelection));
            }
        }
        this.updateSummary();
    }

    private void enableBoxes(boolean isEnabled) {
        String selectedFields = "";
        String selectedRadix = "";
        this.fieldOperationAndRadixComponent.setEnabled(isEnabled);
        if (isEnabled) {
            int i = 0;
            while (i < this.fConstants.FIELD_OPERATIONS.length) {
                if (this.fSelection.get(0).hasOperation(i)) {
                    selectedFields = selectedFields.isEmpty() ? this.fConstants.FIELD_OPERATIONS[i] : String.valueOf(selectedFields) + "," + this.fConstants.FIELD_OPERATIONS[i];
                }
                ++i;
            }
            if (this.fSelection.get(0).getRadixIndex() != -1) {
                selectedRadix = this.fConstants.PRINT_RADIXES[this.fSelection.get(0).getRadixIndex()];
            }
        }
        this.fieldOperationAndRadixComponent.setOperationsFields(selectedFields);
        this.fieldOperationAndRadixComponent.setRadixField(selectedRadix);
    }

    protected Control createDialogArea(Composite parent) {
        Composite ancestor = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(ancestor, 0);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = 700;
        composite.setLayoutData((Object)layoutData);
        composite.setLayout((Layout)new GridLayout());
        this.createSummaryGroup(composite);
        this.createMainArea(composite);
        this.createMessageArea(composite);
        this.setData();
        return ancestor;
    }

    private void createMainArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        this.createFieldGroup(composite);
        this.fieldOperationAndRadixComponent = new FieldOperationsAndRadixComponent(composite, this.fConstants, this::saveElementData);
    }

    private void createMessageArea(Composite composite) {
        Composite group = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).extendedMargins(5, 0, 5, 5).applyTo(group);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)group);
        this.fMessageLabel = new Text(group, 2056);
        this.fMessageLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        DVTColorUtil.INSTANCE.setForeground((Control)this.fMessageLabel, DVTUiUtils.COLOR_BLACK, true);
    }

    private void createSummaryGroup(Composite parent) {
        Composite labelContainer = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(5, 0, 5, 5).applyTo(labelContainer);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)labelContainer);
        this.fGUIFilteredIndication = new Label(labelContainer, 0);
        this.fGUIFilteredIndication.setImage(DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI));
        this.fGUIFilteredIndication.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.fGUIFilteredIndication.setToolTipText("Content Filters matched!");
        this.fGUIFilteredIndication.setEnabled(this.fHasGUIFilteredElements);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false).applyTo((Control)this.fGUIFilteredIndication);
        this.fSummaryLabel = new Label(labelContainer, 2048);
        this.fSummaryLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fSummaryLabel, PlatformUI.getWorkbench().getDisplay().getSystemColor(1), true);
        this.updateSummary();
    }

    private void createFieldGroup(Composite parent) {
        Composite fieldComposite = new Composite(parent, 0);
        fieldComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout fieldLayout = new GridLayout(1, false);
        fieldLayout.marginHeight = 0;
        fieldComposite.setLayout((Layout)fieldLayout);
        Group group = new Group(fieldComposite, 0);
        group.setText("Class");
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout classGroupLayout = new GridLayout();
        classGroupLayout.verticalSpacing = 0;
        group.setLayout((Layout)classGroupLayout);
        Table classTableViewer = new Table((Composite)group, 2100);
        this.fClassViewer = new CheckboxTableViewer(classTableViewer);
        GridData classGridData = new GridData(4, 4, true, false);
        classGridData.heightHint = 25;
        this.fClassViewer.getTable().setLayoutData((Object)classGridData);
        GridLayout classLayout = new GridLayout(1, false);
        classLayout.marginHeight = 0;
        this.fClassViewer.getTable().setLayout((Layout)classLayout);
        this.fClassViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FEDialog.this.updateOnSelectionChange((StructuredSelection)event.getSelection());
            }
        });
        this.fClassViewer.setContentProvider((IContentProvider)new FieldEditorContentProvider());
        this.fClassViewer.setCheckStateProvider((ICheckStateProvider)new FieldEditorCheckStateProvider());
        this.fClassViewer.addCheckStateListener((ICheckStateListener)new FieldEditorCheckStateListener());
        this.fClassViewer.setLabelProvider((IBaseLabelProvider)new FieldEditorLabelProvider());
        Group fieldGroup = new Group(fieldComposite, 0);
        fieldGroup.setText("Fields");
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 0;
        fieldGroup.setLayoutData((Object)gd);
        GridLayout fieldGroupLayout = new GridLayout();
        fieldGroupLayout.verticalSpacing = 0;
        fieldGroup.setLayout((Layout)fieldGroupLayout);
        TableViewer tv = new TableViewer((Composite)fieldGroup, 2852);
        this.fTableViewer = new CheckboxTableViewer(tv.getTable());
        this.fTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTableViewer.getTable().setLayout((Layout)new GridLayout(2, false));
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FEDialog.this.updateOnSelectionChange((StructuredSelection)event.getSelection());
            }
        });
        this.fTableViewer.setContentProvider((IContentProvider)new FieldEditorContentProvider());
        this.fTableViewer.setCheckStateProvider((ICheckStateProvider)new FieldEditorCheckStateProvider());
        this.fTableViewer.addCheckStateListener((ICheckStateListener)new FieldEditorCheckStateListener());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new FieldEditorLabelProvider());
        Composite selectionComposite = new Composite((Composite)fieldGroup, 0);
        selectionComposite.setLayoutData((Object)new GridData(131072, 4, true, false));
        selectionComposite.setLayout((Layout)new GridLayout(2, true));
        this.fSelectAllFieldsButton = new Button(selectionComposite, 0);
        this.fSelectAllFieldsButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fSelectAllFieldsButton.setText("Select all");
        this.fSelectAllFieldsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean enableBoxes = false;
                if (!FEDialog.this.fSelection.isEmpty() && FEDialog.this.fSelection.get(0) instanceof FieldModel && !FEDialog.this.fSelection.get(0).isRegistered()) {
                    enableBoxes = true;
                }
                for (XVMElementModel element : FEDialog.this.fInput) {
                    if (element.isRegistered()) continue;
                    element.performRegistration(true);
                }
                if (FEDialog.this.fClassViewer.getCheckedElements() != null && FEDialog.this.fClassViewer.getCheckedElements().length == 1) {
                    singleClass = (ClassModel)FEDialog.this.fClassViewer.getCheckedElements()[0];
                    singleClass.makeDoubleLineMacro();
                } else {
                    singleClass = (ClassModel)FEDialog.this.fClassViewer.getElementAt(0);
                    if (singleClass.getRfClass().getDeclaration().getChildren() == null || singleClass.getRfClass().getDeclaration().getChildren().isEmpty()) {
                        singleClass.makeSingleLineMacro();
                    } else {
                        singleClass.makeDoubleLineMacro();
                    }
                }
                FEDialog.this.fTableViewer.refresh();
                if (enableBoxes) {
                    FEDialog.this.enableBoxes(enableBoxes);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fDeselectAllFieldsButton = new Button(selectionComposite, 0);
        this.fDeselectAllFieldsButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fDeselectAllFieldsButton.setText("Deselect all");
        this.fDeselectAllFieldsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                for (XVMElementModel element : FEDialog.this.fInput) {
                    if (!element.isRegistered()) continue;
                    element.performRegistration(false);
                }
                if (FEDialog.this.fClassViewer.getCheckedElements() != null && FEDialog.this.fClassViewer.getCheckedElements().length == 1) {
                    singleClass = (ClassModel)FEDialog.this.fClassViewer.getCheckedElements()[0];
                    singleClass.makeSingleLineMacro();
                } else {
                    singleClass = (ClassModel)FEDialog.this.fClassViewer.getElementAt(0);
                    if (singleClass.getRfClass().getDeclaration().getChildren() == null || singleClass.getRfClass().getDeclaration().getChildren().isEmpty()) {
                        singleClass.makeSingleLineMacro();
                    } else {
                        singleClass.makeDoubleLineMacro();
                    }
                }
                FEDialog.this.fTableViewer.refresh();
                if (FEDialog.this.fSelection.isEmpty() || FEDialog.this.fSelection.get(0) instanceof FieldModel) {
                    FEDialog.this.enableBoxes(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.createMacroLabelGroup(fieldComposite);
    }

    private void createMacroLabelGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(String.valueOf(this.fConstants.PREFIX.toUpperCase()) + " Registration Macro");
        GridData gd = new GridData(4, 4, false, false);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        group.setLayout((Layout)new GridLayout(2, false));
        this.fMacroLabel = new Label((Composite)group, 2048);
        this.fMacroLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        DVTColorUtil.INSTANCE.setForeground((Control)this.fMacroLabel, DVTUiUtils.COLOR_BLACK, true);
        this.fFixButton = new Button((Composite)group, 2048);
        this.fFixButton.setText("Fix");
        this.fFixButton.setEnabled(false);
        GridData fixButtonLayoutData = new GridData(4, 0x1000000, false, false);
        fixButtonLayoutData.widthHint = 100;
        this.fFixButton.setLayoutData((Object)fixButtonLayoutData);
        this.fFixButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FEDialog.this.updateOnRegister(((Button)e.getSource()).getSelection(), true);
                FEDialog.this.updateOnRegister(!((Button)e.getSource()).getSelection(), true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private class FieldEditorCheckStateListener
    implements ICheckStateListener {
        private FieldEditorCheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            FEDialog.this.updateOnRegister(event.getChecked(), false);
        }
    }

    private static class FieldEditorCheckStateProvider
    implements ICheckStateProvider {
        private FieldEditorCheckStateProvider() {
        }

        public boolean isGrayed(Object element) {
            return false;
        }

        public boolean isChecked(Object element) {
            XVMElementModel model = (XVMElementModel)element;
            return model.isRegistered();
        }
    }

    private static class FieldEditorContentProvider
    implements IStructuredContentProvider {
        private FieldEditorContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            List v = (List)inputElement;
            return v.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class FieldEditorLabelProvider
    extends LabelProvider {
        private FieldEditorLabelProvider() {
        }

        public Image getImage(Object element) {
            Image result;
            if (element instanceof ClassModel) {
                result = ((ClassModel)element).isRegistered() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_CLASS) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_CLASS_GRAY);
            } else {
                DataType fieldDataType;
                FieldModel model = (FieldModel)element;
                THViewLabelProvider.getImageForUVMField(model.getRfField());
                result = THViewLabelProvider.getImageForUVMField(model.getRfField());
                if (RfXvmFactory.isPortForXvmObject(model.getRfField())) {
                    result = DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(result, DVTImages.OVR_TLM_PORTS, 1));
                }
                if ((fieldDataType = model.getRfField().getDataType()) != null && fieldDataType.getUnpackedDimension() != null && !fieldDataType.getUnpackedDimension().isEmpty()) {
                    result = DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(result, DVTImages.OVR_ARRAY, 3));
                }
            }
            if (((XVMElementModel)element).isRegistered()) {
                switch (((XVMElementModel)element).getStatusSeverity()) {
                    case 3: {
                        result = DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(result, DVTImages.DESC_OVR_ERROR, 2));
                        break;
                    }
                    case 2: {
                        result = DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(result, DVTImages.DESC_OVR_WARNING, 2));
                    }
                }
            }
            return result;
        }

        public String getText(Object element) {
            String result = "";
            if (element != null && element instanceof XVMElementModel) {
                XVMElementModel tmpElement = (XVMElementModel)element;
                result = String.valueOf(result) + tmpElement.getSignature();
            }
            return result;
        }
    }
}

