/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.ovm.fieldeditor;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FEConstants;

public class FERegistration {
    public String fMacroName;
    public List<String> fMacroParams;
    public RfProject fRfProject;
    public FEConstants fConstants;

    public FERegistration(String fMacroName, RfProject fRfProject, FEConstants fConstants) {
        this.fMacroName = fMacroName;
        this.fMacroParams = new ArrayList<String>();
        this.fRfProject = fRfProject;
        this.fConstants = fConstants;
    }

    public int nofLines() {
        return this.fMacroName == null ? 3 : 1;
    }

    public void addParam(String p) {
        if (p == null || p.isEmpty()) {
            return;
        }
        this.fMacroParams.add(p);
    }

    public String toString(boolean prependBacktick) {
        String backtickOrEmpty;
        StringBuilder result = new StringBuilder();
        String lineDelimiter = DVTDocumentCommon.getLineDelimiterByProject(this.fRfProject != null ? this.fRfProject.getProject() : null);
        String string = backtickOrEmpty = prependBacktick ? "`" : "";
        if (this.fMacroName == null) {
            result.append("// FIXME: DVT could not determine the registration macro for this").append(lineDelimiter).append("// field, so ").append(this.fConstants.OVM_FIELD_OBJECT).append(" was used.").append(lineDelimiter).append(backtickOrEmpty).append(this.fConstants.OVM_FIELD_OBJECT);
        } else {
            result.append(backtickOrEmpty).append(this.fMacroName);
        }
        result.append("(" + DVTStringUtil.join(this.fMacroParams, (String)", ") + ")");
        return result.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    public String getMacroName() {
        return this.fMacroName;
    }
}

