/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.ovm.fieldeditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedTypeWrapper;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.ClassModel;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.DocumentMirror;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FEConstants;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FERegistration;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FEUtils;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FieldModel;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.XVMElementModel;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedEventType;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.parser.RfMacroRefInfo;

public class FERegistrationArea {
    private boolean fExists;
    private boolean fHasOneLineRegArea;
    private int fRegAreaStartLine;
    private int fRegAreaEndLine;
    private int fClassEndLine;
    private int fErrorStatus;
    private HashMap<String, RfMacroRefInfo> fFieldMacroRefsByName = new HashMap();
    private RfMacroRefInfo fClassMacroRef;
    private String fPreferedSequencer;
    private IDocument fDocument;
    private IFile fFile;
    private int fCursorLine;
    private RfProject fRfProject;
    private RfClass fRfClass;
    private List<XVMElementModel> fOriginalModels;
    private ClassModel fOriginalClassModel;
    private FEConstants fConstants;

    public FERegistrationArea(IDocument document, IFile file, int offset, RfProject rfProject, RfClass rfClass, FEConstants constants) {
        this.fDocument = document;
        this.fFile = file;
        this.fRfProject = rfProject;
        this.fRfClass = rfClass;
        this.fConstants = constants;
        try {
            this.fCursorLine = document.getLineOfOffset(offset) + 1;
            if (this.fCursorLine == this.fRfClass.getDeclaration().getStartLine()) {
                ++this.fCursorLine;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.fCursorLine = -1;
        }
    }

    public void performPreliminaryChecks() {
        this.fErrorStatus = 0;
        if (!FEUtils.checkInheritance1(this.fRfProject, this.fConstants.OVM_OBJECT_BASE, this.fConstants.OVM_OBJECT_BASE)) {
            this.fErrorStatus = 8;
            return;
        }
        List<RfNamedElement> ovmMacros = this.fRfProject.getMacrosWithPrefix(String.valueOf(this.fConstants.PREFIX) + "_", 2);
        if (ovmMacros == null || ovmMacros.isEmpty()) {
            this.fErrorStatus = 8;
        }
    }

    public void makeModel() {
        if (this.fRfClass != null) {
            this.fOriginalClassModel = this.getClassModel(this.fRfClass);
            List<RfField> children = this.fRfClass.getFields();
            if (children != null) {
                children.addAll(this.fRfClass.getEvents());
            }
            this.fOriginalModels = new ArrayList<XVMElementModel>();
            if (children != null) {
                for (RfField child : children) {
                    FieldModel fieldModel;
                    if (child == null || FEConstants.OVM_UTILS_INTERNAL_FIELDS.contains(child.getName()) || (fieldModel = this.getFieldModel(child)) == null) continue;
                    this.fOriginalModels.add(fieldModel);
                }
            }
        }
    }

    public void resetOriginalModels() {
        this.fOriginalModels = null;
    }

    public void scanRegistrationArea() throws BadLocationException {
        this.fHasOneLineRegArea = false;
        this.fClassMacroRef = null;
        this.fFieldMacroRefsByName.clear();
        if (this.fRfClass.getDeclaration() == null) {
            this.fErrorStatus = 7;
            return;
        }
        int classStartLine = this.fRfClass.getDeclaration().getStartLine();
        if (!this.fRfClass.getFile().getFileAdapter().equals((Object)this.fFile)) {
            this.fErrorStatus = 7;
            return;
        }
        this.fClassEndLine = this.fDocument.getLineOfOffset(this.fRfClass.getDeclaration().getEndOffset()) + 1;
        if (this.fCursorLine == -1) {
            this.fCursorLine = this.fClassEndLine;
        }
        ParserPath fileName = this.fRfClass.getFile().getParserPath();
        List<RfMacroRefInfo> fileMacroRefs = this.fRfProject.getPreprocessingTable().getMacroRefsMapByFile().get(fileName);
        if (fileMacroRefs == null) {
            this.fExists = false;
            return;
        }
        ArrayList<RfMacroRefInfo> classMacroRefs = new ArrayList<RfMacroRefInfo>();
        for (RfMacroRefInfo macroRef : fileMacroRefs) {
            if (macroRef.getLine() <= classStartLine || macroRef.getLine() >= this.fClassEndLine) continue;
            classMacroRefs.add(macroRef);
        }
        for (RfMacroRefInfo macroRef : classMacroRefs) {
            if (!this.fConstants.OVM_UTILS_MACROS.contains(macroRef.getMacroName()) || !this.isMacroInClass(macroRef)) continue;
            this.fExists = true;
            this.fHasOneLineRegArea = true;
            this.fRegAreaStartLine = this.fRegAreaEndLine = macroRef.getLine();
            if (macroRef.getMacroName().equals(this.fConstants.OVM_SEQUENCE_UTILS) && macroRef.getParams().length == 2) {
                this.fPreferedSequencer = macroRef.getParams()[1];
            }
            this.fClassMacroRef = macroRef;
            return;
        }
        this.fRegAreaEndLine = -1;
        this.fRegAreaStartLine = -1;
        for (RfMacroRefInfo macroRef : classMacroRefs) {
            if (this.fConstants.OVM_UTILS_BEGIN_MACROS.contains(macroRef.getMacroName()) && this.isMacroInClass(macroRef)) {
                this.fRegAreaStartLine = macroRef.getLine();
            }
            if (!this.fConstants.OVM_UTILS_END_MACROS.contains(macroRef.getMacroName()) || !this.isMacroInClass(macroRef)) continue;
            this.fRegAreaEndLine = macroRef.getLine();
        }
        if (this.fRegAreaStartLine != -1 && this.fRegAreaEndLine != -1) {
            this.fExists = true;
        } else if (this.fRegAreaStartLine == -1 && this.fRegAreaEndLine == -1) {
            this.fExists = false;
        } else {
            if (this.fRegAreaStartLine == -1 && this.fRegAreaEndLine != -1) {
                this.fErrorStatus = 2;
                return;
            }
            if (this.fRegAreaStartLine != -1 && this.fRegAreaEndLine == -1) {
                this.fErrorStatus = 3;
                return;
            }
        }
        if (this.fExists) {
            for (RfMacroRefInfo macroRef : classMacroRefs) {
                if (macroRef.getLine() < this.fRegAreaStartLine || macroRef.getLine() >= this.fRegAreaEndLine || !this.fConstants.OVM_FIELD_MACROS.contains(macroRef.getMacroName()) && !this.fConstants.OVM_CLASS_MACROS.contains(macroRef.getMacroName())) continue;
                String[] params = macroRef.getParams();
                String fieldName = null;
                if (this.fConstants.OVM_UTILS_BEGIN_MACROS.contains(macroRef.getMacroName()) && params.length == 1) {
                    this.fClassMacroRef = macroRef;
                }
                if (params.length == 2) {
                    fieldName = params[0];
                } else {
                    if (params.length != 3) continue;
                    fieldName = params[1];
                }
                if (fieldName == null) continue;
                this.fFieldMacroRefsByName.put(fieldName, macroRef);
            }
        }
    }

    public DocumentMirror computeChanges(List<XVMElementModel> modifiedModels, List<ClassModel> modifiedClassModels, boolean useTemplate) throws BadLocationException {
        ArrayList<XVMElementModel> fieldsToUpdate = new ArrayList<XVMElementModel>(modifiedModels);
        fieldsToUpdate.addAll(modifiedClassModels);
        if (fieldsToUpdate.isEmpty()) {
            return null;
        }
        ArrayList<XVMElementModel> originalModels = new ArrayList<XVMElementModel>(this.fOriginalModels);
        originalModels.add(this.fOriginalClassModel);
        boolean containsAll = true;
        for (XVMElementModel xvmModel : fieldsToUpdate) {
            if (originalModels.contains(xvmModel)) continue;
            containsAll = false;
            break;
        }
        if (containsAll) {
            return null;
        }
        int previousEndLine = this.fRegAreaEndLine;
        DocumentMirror mirror = this.createDocumentMirror(this.getRegAreaString(fieldsToUpdate));
        int previousModifiedLine = -1;
        int insertedLines = 0;
        for (XVMElementModel xvmModel : fieldsToUpdate) {
            RfMacroRefInfo regMacro = this.fFieldMacroRefsByName.get(xvmModel.getName());
            if (xvmModel.isRegistered()) {
                if (xvmModel instanceof FieldModel) {
                    FieldModel fieldModel = (FieldModel)xvmModel;
                    FERegistration reg = this.getRegistration(fieldModel.getRfField());
                    if (reg == null) continue;
                    if (useTemplate) {
                        reg.addParam("${" + fieldModel.getFlags() + "}");
                    } else {
                        reg.addParam(fieldModel.getFlags());
                    }
                    if (fieldModel.getMacroRef() != null) {
                        reg.fMacroName = fieldModel.getMacroRef().getMacroName();
                    }
                    if (regMacro == null) {
                        mirror.insertText(previousModifiedLine == -1 ? this.fRegAreaStartLine + 1 : previousModifiedLine + 1, reg.toString());
                        this.fRegAreaEndLine += reg.nofLines();
                        previousModifiedLine = previousModifiedLine == -1 ? this.fRegAreaStartLine + reg.nofLines() : previousModifiedLine + reg.nofLines();
                        insertedLines += reg.nofLines();
                        continue;
                    }
                    mirror.markForRemoval(regMacro.getLine() + insertedLines);
                    mirror.insertText(previousModifiedLine == -1 ? this.fRegAreaStartLine + 1 : previousModifiedLine + 1, reg.toString());
                    ++insertedLines;
                    previousModifiedLine = previousModifiedLine == -1 ? this.fRegAreaStartLine + reg.nofLines() : previousModifiedLine + reg.nofLines();
                    continue;
                }
                if (!(xvmModel instanceof ClassModel) || (regMacro = this.fClassMacroRef) == null || regMacro.getMacroName().equals(xvmModel.getDVTMacroName())) continue;
                if (xvmModel.getMacroRef() == null) {
                    mirror.replaceLine(this.fRegAreaStartLine, "`" + xvmModel.getDVTMacroName() + "(" + regMacro.getParamsString() + ")");
                    if (this.fHasOneLineRegArea) continue;
                    if (this.fConstants.OVM_BEGIN_TO_END_MACROS.keySet().contains(xvmModel.getDVTMacroName())) {
                        mirror.replaceLine(this.fRegAreaEndLine + insertedLines, "`" + this.fConstants.OVM_BEGIN_TO_END_MACROS.get(xvmModel.getDVTMacroName()));
                        continue;
                    }
                    mirror.markForRemoval(this.fRegAreaEndLine);
                    continue;
                }
                if (this.fConstants.OVM_UTILS_BEGIN_MACROS.contains(regMacro.getMacroName()) && this.fConstants.OVM_UTILS_MACROS.contains(xvmModel.getDVTMacroName())) {
                    mirror.markForRemoval(regMacro.getLine() + insertedLines);
                    mirror.insertText(previousModifiedLine == -1 ? this.fRegAreaStartLine + 1 : previousModifiedLine + 1, "`" + this.fConstants.OVM_DOUBLE_TO_SINGLE_MACROS.get(regMacro.getMacroName()) + "(" + xvmModel.getMacroRef().getParamsString() + ")");
                    previousModifiedLine = previousModifiedLine == -1 ? this.fRegAreaStartLine + 1 : previousModifiedLine + 1;
                    mirror.markForRemoval(previousEndLine + ++insertedLines);
                    continue;
                }
                if (!this.fConstants.OVM_UTILS_BEGIN_MACROS.contains(xvmModel.getDVTMacroName()) || !this.fConstants.OVM_UTILS_MACROS.contains(regMacro.getMacroName()) || this.fConstants.OVM_DOUBLE_TO_SINGLE_MACROS.get(xvmModel.getDVTMacroName()).equals(regMacro.getMacroName())) continue;
                mirror.replaceLine(this.fRegAreaStartLine, "`" + this.fConstants.OVM_SINGLE_TO_DOUBLE_MACROS.get(regMacro.getMacroName()) + "(" + xvmModel.getMacroRef().getParamsString() + ")");
                mirror.replaceLine(this.fRegAreaEndLine, "`" + this.fConstants.OVM_BEGIN_TO_END_MACROS.get(this.fConstants.OVM_SINGLE_TO_DOUBLE_MACROS.get(regMacro.getMacroName())));
                continue;
            }
            if (xvmModel instanceof ClassModel) {
                regMacro = this.fClassMacroRef;
            }
            if (regMacro == null) continue;
            if (this.fConstants.OVM_CLASS_MACROS.contains(regMacro.getMacroName())) {
                int i = this.fRegAreaStartLine;
                while (i <= this.fRegAreaEndLine + insertedLines) {
                    mirror.markForRemoval(i);
                    ++i;
                }
            }
            mirror.markForRemoval(regMacro.getLine() + insertedLines);
            if (previousModifiedLine + 1 != regMacro.getLine() + insertedLines) continue;
            ++previousModifiedLine;
        }
        this.fRegAreaEndLine = previousEndLine;
        if (!this.exists()) {
            mirror.appendText("");
        }
        return mirror;
    }

    public boolean applyModel(List<XVMElementModel> modifiedModels, List<ClassModel> modifiedClassModels) throws BadLocationException {
        DocumentMirror mirror = this.computeChanges(modifiedModels, modifiedClassModels, false);
        if (mirror == null) {
            return false;
        }
        mirror.updateDocument();
        return true;
    }

    private String getRegAreaString(List<XVMElementModel> modifiedModels) {
        String beginMacro = "`";
        String endMacro = "`";
        boolean hasParameter = this.fRfClass.hasPortListParameters();
        String typeName = FEUtils.getClassNameWithParameters(this.fRfClass, hasParameter);
        boolean hasChildren = FEUtils.hasActualFields(this.fRfClass, hasParameter);
        boolean isVirtual = this.fRfClass.hasVirtualQualifier();
        String lineDelimiter = DVTDocumentCommon.getLineDelimiterByProject(this.fRfProject != null ? this.fRfProject.getProject() : null);
        if (!isVirtual) {
            if (FEUtils.checkInheritance(this.fRfClass, this.fConstants.OVM_SEQUENCE_BASE)) {
                if (this.fConstants.METHODLOGY == 1) {
                    if (!hasChildren) {
                        if (!hasParameter) {
                            beginMacro = String.valueOf(beginMacro) + this.fConstants.OVM_OBJECT_PARAM_UTILS + "(" + typeName + ")";
                            endMacro = String.valueOf(endMacro) + "`" + this.fConstants.OVM_DECLARE_P_SEQUENCER + "(" + this.fPreferedSequencer + ")";
                        } else {
                            beginMacro = String.valueOf(beginMacro) + this.fConstants.OVM_OBJECT_UTILS + "(" + typeName + ")";
                            endMacro = String.valueOf(endMacro) + "`" + this.fConstants.OVM_DECLARE_P_SEQUENCER + "(" + this.fPreferedSequencer + ")";
                        }
                    } else if (!hasParameter) {
                        beginMacro = String.valueOf(beginMacro) + this.fConstants.OVM_OBJECT_UTILS_BEGIN + "(" + typeName + ")";
                        endMacro = String.valueOf(endMacro) + this.fConstants.OVM_OBJECT_UTILS_END;
                        endMacro = String.valueOf(endMacro) + lineDelimiter + "`" + this.fConstants.OVM_DECLARE_P_SEQUENCER + "(" + this.fPreferedSequencer + ")";
                    } else {
                        beginMacro = String.valueOf(beginMacro) + this.fConstants.OVM_OBJECT_PARAM_UTILS_BEGIN + "(" + typeName + ")";
                        endMacro = String.valueOf(endMacro) + this.fConstants.OVM_OBJECT_UTILS_END;
                        endMacro = String.valueOf(endMacro) + lineDelimiter + "`" + this.fConstants.OVM_DECLARE_P_SEQUENCER + "(" + this.fPreferedSequencer + ")";
                    }
                } else {
                    if (!hasChildren) {
                        beginMacro = String.valueOf(beginMacro) + this.fConstants.OVM_SEQUENCE_UTILS + "(" + typeName + ", " + this.fPreferedSequencer + ")";
                        this.fHasOneLineRegArea = true;
                        return String.valueOf(beginMacro) + lineDelimiter;
                    }
                    beginMacro = String.valueOf(beginMacro) + this.fConstants.OVM_SEQUENCE_UTILS_BEGIN + "(" + typeName + ", " + this.fPreferedSequencer + ")";
                    endMacro = String.valueOf(endMacro) + this.fConstants.OVM_SEQUENCE_UTILS_END;
                }
            } else if (FEUtils.checkInheritance(this.fRfClass, this.fConstants.OVM_COMPONENT_BASE)) {
                if (!hasChildren) {
                    if (!hasParameter) {
                        beginMacro = String.valueOf(beginMacro) + this.fConstants.OVM_COMPONENT_UTILS + "(" + typeName + ")";
                        this.fHasOneLineRegArea = true;
                    } else {
                        beginMacro = String.valueOf(beginMacro) + this.fConstants.OVM_COMPONENT_PARAM_UTILS + "(" + typeName + ")";
                        this.fHasOneLineRegArea = true;
                    }
                    return String.valueOf(beginMacro) + lineDelimiter;
                }
                if (!hasParameter) {
                    beginMacro = String.valueOf(beginMacro) + this.fConstants.OVM_COMPONENT_UTILS_BEGIN + "(" + typeName + ")";
                    endMacro = String.valueOf(endMacro) + this.fConstants.OVM_COMPONENT_UTILS_END;
                } else {
                    beginMacro = String.valueOf(beginMacro) + this.fConstants.OVM_COMPONENT_PARAM_UTILS_BEGIN + "(" + typeName + ")";
                    endMacro = String.valueOf(endMacro) + this.fConstants.OVM_COMPONENT_UTILS_END;
                }
            } else if (FEUtils.checkInheritance(this.fRfClass, this.fConstants.OVM_OBJECT_BASE)) {
                if (!hasChildren) {
                    if (!hasParameter) {
                        beginMacro = String.valueOf(beginMacro) + this.fConstants.OVM_OBJECT_UTILS + "(" + typeName + ")";
                        this.fHasOneLineRegArea = true;
                        return String.valueOf(beginMacro) + lineDelimiter;
                    }
                    beginMacro = String.valueOf(beginMacro) + this.fConstants.OVM_OBJECT_PARAM_UTILS + "(" + typeName + ")";
                    this.fHasOneLineRegArea = true;
                    return String.valueOf(beginMacro) + lineDelimiter;
                }
                if (!hasParameter) {
                    beginMacro = String.valueOf(beginMacro) + this.fConstants.OVM_OBJECT_UTILS_BEGIN + "(" + typeName + ")";
                    endMacro = String.valueOf(endMacro) + this.fConstants.OVM_OBJECT_UTILS_END;
                } else {
                    beginMacro = String.valueOf(beginMacro) + this.fConstants.OVM_OBJECT_PARAM_UTILS_BEGIN + "(" + typeName + ")";
                    endMacro = String.valueOf(endMacro) + this.fConstants.OVM_OBJECT_UTILS_END;
                }
            } else {
                beginMacro = String.valueOf(beginMacro) + this.fConstants.OVM_FIELD_UTILS_BEGIN + "(" + typeName + ")";
                endMacro = String.valueOf(endMacro) + this.fConstants.OVM_FIELD_UTILS_END;
            }
        } else {
            beginMacro = String.valueOf(beginMacro) + this.fConstants.OVM_FIELD_UTILS_BEGIN + "(" + typeName + ")";
            endMacro = String.valueOf(endMacro) + this.fConstants.OVM_FIELD_UTILS_END;
        }
        if (modifiedModels == null || modifiedModels.isEmpty()) {
            return String.valueOf(beginMacro) + lineDelimiter + endMacro + lineDelimiter;
        }
        StringBuilder beginMacroSB = new StringBuilder(beginMacro);
        for (XVMElementModel model : modifiedModels) {
            if (!(model instanceof ClassModel) || !model.isRegistered()) continue;
            if (!this.fConstants.OVM_UTILS_MACROS.contains(model.getDVTMacroName())) break;
            beginMacroSB = new StringBuilder().append("`").append(model.getDVTMacroName()).append("(").append(typeName).append(")");
            if (FEUtils.checkInheritance(this.fRfClass, this.fConstants.OVM_SEQUENCE_BASE)) {
                if (this.fConstants.METHODLOGY == 1) {
                    beginMacroSB.append(lineDelimiter).append("`").append(this.fConstants.OVM_DECLARE_P_SEQUENCER).append("(").append(this.fPreferedSequencer).append(")");
                } else {
                    beginMacroSB = new StringBuilder().append("`").append(model.getDVTMacroName()).append("(").append(typeName).append(", ").append(this.fPreferedSequencer).append(")");
                }
            }
            this.fHasOneLineRegArea = true;
            return beginMacroSB.append(lineDelimiter).toString();
        }
        beginMacro = beginMacroSB.toString();
        return String.valueOf(beginMacro) + lineDelimiter + endMacro + lineDelimiter;
    }

    private boolean isMacroInClass(RfMacroRefInfo macroRef) {
        try {
            RfWNamedElementAndScope nes = RfUtils.getRfElement(this.fRfProject, this.fFile, this.fDocument, this.fDocument.getLineOffset(macroRef.getLine() - 1), null);
            return this.fRfClass == FEUtils.getEnclosingClass(nes.getScope());
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private ClassModel getClassModel(RfClass clazz) {
        String[] params;
        FERegistration reg = this.getRegistration(clazz);
        if (reg == null) {
            return null;
        }
        boolean hasParameter = clazz.hasPortListParameters();
        String className = FEUtils.getClassNameWithParameters(clazz, hasParameter);
        RfMacroRefInfo macroRef = this.fClassMacroRef;
        if (macroRef != null && this.fConstants.OVM_CLASS_MACROS.contains(macroRef.getMacroName()) && (params = macroRef.getParams()).length >= 1 && params[0].equals(className)) {
            return new ClassModel(clazz, reg.fMacroName, macroRef, className, this.fConstants);
        }
        return new ClassModel(clazz, reg.fMacroName, className, false, false, this.fConstants.STATUS_STRINGS.get(this.fErrorStatus), this.fConstants);
    }

    private FieldModel getFieldModel(RfField field) {
        FERegistration reg = this.getRegistration(field);
        if (reg == null) {
            return null;
        }
        String fieldName = field.getName();
        String signingString = field.getSigningString();
        String fieldTypeName = String.valueOf(field.getAssociatedTypeName()) + (!signingString.isEmpty() ? " " + signingString : signingString);
        for (RfMacroRefInfo macroRef : this.fFieldMacroRefsByName.values()) {
            if (!this.fConstants.OVM_FIELD_MACROS.contains(macroRef.getMacroName())) continue;
            String[] params = macroRef.getParams();
            if (params.length == 2 && params[0].equals(fieldName)) {
                Set<String> ops = this.getOperations(params[1]);
                String radix = this.getRadix(params[1]);
                if (ops != null && radix != null) {
                    return new FieldModel(field, reg.fMacroName, macroRef, fieldName, fieldTypeName, radix, ops, this.fConstants);
                }
                return new FieldModel(field, reg.fMacroName, fieldName, fieldTypeName, true, true, this.fConstants.STATUS_STRINGS.get(this.fErrorStatus), this.fConstants);
            }
            if (params.length != 3 || !params[1].equals(fieldName)) continue;
            Set<String> ops = this.getOperations(params[2]);
            String radix = this.getRadix(params[2]);
            if (ops != null && radix != null) {
                return new FieldModel(field, reg.fMacroName, macroRef, fieldName, fieldTypeName, radix, ops, this.fConstants);
            }
            return new FieldModel(field, reg.fMacroName, fieldName, fieldTypeName, true, true, this.fConstants.STATUS_STRINGS.get(this.fErrorStatus), this.fConstants);
        }
        return new FieldModel(field, reg.fMacroName, fieldName, fieldTypeName, false, false, this.fConstants.STATUS_STRINGS.get(this.fErrorStatus), this.fConstants);
    }

    public FERegistration getRegistration(RfClass clazz) {
        String macroName = null;
        boolean hasParameter = clazz.hasPortListParameters();
        String className = FEUtils.getClassNameWithParameters(clazz, hasParameter);
        boolean hasChildren = FEUtils.hasActualFields(clazz, hasParameter);
        macroName = clazz.isVirtual() ? this.fConstants.OVM_FIELD_UTILS_BEGIN : (FEUtils.checkInheritance(this.fRfClass, this.fConstants.OVM_SEQUENCE_BASE) ? (this.fConstants.METHODLOGY == 1 ? (hasChildren && !this.fHasOneLineRegArea ? (hasParameter ? this.fConstants.OVM_OBJECT_PARAM_UTILS_BEGIN : this.fConstants.OVM_OBJECT_UTILS_BEGIN) : (hasParameter ? this.fConstants.OVM_OBJECT_PARAM_UTILS : this.fConstants.OVM_OBJECT_UTILS)) : (hasChildren && !this.fHasOneLineRegArea ? this.fConstants.OVM_SEQUENCE_UTILS_BEGIN : this.fConstants.OVM_SEQUENCE_UTILS)) : (FEUtils.checkInheritance(this.fRfClass, this.fConstants.OVM_COMPONENT_BASE) ? (hasChildren && !this.fHasOneLineRegArea ? (hasParameter ? this.fConstants.OVM_COMPONENT_PARAM_UTILS_BEGIN : this.fConstants.OVM_COMPONENT_UTILS_BEGIN) : (hasParameter ? this.fConstants.OVM_COMPONENT_PARAM_UTILS : this.fConstants.OVM_COMPONENT_UTILS)) : (FEUtils.checkInheritance(this.fRfClass, this.fConstants.OVM_OBJECT_BASE) ? (hasChildren && !this.fHasOneLineRegArea ? (hasParameter ? this.fConstants.OVM_OBJECT_PARAM_UTILS_BEGIN : this.fConstants.OVM_OBJECT_UTILS_BEGIN) : (hasParameter ? this.fConstants.OVM_OBJECT_PARAM_UTILS : this.fConstants.OVM_OBJECT_UTILS)) : this.fConstants.OVM_FIELD_UTILS_BEGIN)));
        FERegistration registration = new FERegistration(macroName, this.fRfProject, this.fConstants);
        registration.addParam(className);
        return registration;
    }

    private String getFieldRelativeScopeAndTypeName(RfField field, IRfNamedElement fieldType) {
        String fieldTypeName = fieldType.getName();
        String scope = RfBatchUtils.getScopeRelativeTo(field, fieldType, false);
        if (!scope.isEmpty()) {
            fieldTypeName = String.valueOf(scope) + "::" + fieldTypeName;
        }
        return fieldTypeName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FERegistration getRegistration(RfField field) {
        String fieldName;
        String firstParam;
        String macroName;
        block52: {
            macroName = null;
            firstParam = null;
            fieldName = field.getName();
            DataType fieldDT = field.getDataType();
            if (fieldDT == null) {
                return null;
            }
            String fieldTypeName = fieldDT != null ? fieldDT.getType() : null;
            IRfNamedElement fieldType = field.getAssociatedTypeNoLastLevelParams();
            if (fieldType != null) {
                String string = fieldType instanceof RfField && ((RfField)fieldType).isTypeParameter() && field.getAssociatedType() != null ? field.getAssociatedType().getName() : (fieldTypeName = fieldType instanceof RfListType ? ((RfListType)fieldType).getAssociatedBaseType().getName() : this.getFieldRelativeScopeAndTypeName(field, fieldType));
            }
            if (fieldTypeName != null) {
                if (field.getDataType().getSign() == 2) {
                    fieldTypeName = fieldTypeName.replace("unsigned", "");
                } else if (field.getDataType().getSign() == 1) {
                    fieldTypeName = fieldTypeName.replace("signed", "");
                }
                fieldTypeName = fieldTypeName.trim();
            }
            if (fieldType instanceof RfTypeAlias) {
                fieldType = ((RfTypeAlias)fieldType).getTranslatedType(RfTypesResolver.create(fieldType.getEnclosingScope(), field.getRfProject(), 8));
            }
            try {
                IRfNamedElement elementType;
                block53: {
                    RfAssociatedTypeWrapper wrap;
                    block56: {
                        IRfNamedElement assocType;
                        block58: {
                            String indexSign;
                            String indexTypeName;
                            String indexTypeNameForEnum;
                            IRfNamedElement assocIndexType;
                            block68: {
                                block67: {
                                    block66: {
                                        block65: {
                                            block64: {
                                                block63: {
                                                    block62: {
                                                        block61: {
                                                            block60: {
                                                                block59: {
                                                                    block57: {
                                                                        block54: {
                                                                            block55: {
                                                                                if (RfListType.isQueue((IRfScopeElement)fieldType)) {
                                                                                    String elementTypeName;
                                                                                    elementType = ((RfListType)fieldType).getAssociatedType();
                                                                                    if (elementType instanceof RfTypeAlias) {
                                                                                        elementType = ((RfTypeAlias)elementType).getTranslatedType();
                                                                                    }
                                                                                    if (FEConstants.INTEGRAL_TYPES.contains(elementTypeName = elementType.getName()) || FEUtils.isPackedStruct(elementType) || FEUtils.isPackedUnion(elementType)) {
                                                                                        macroName = this.fConstants.OVM_FIELD_QUEUE_INT;
                                                                                        break block52;
                                                                                    }
                                                                                    if (elementTypeName.equals("string")) {
                                                                                        macroName = this.fConstants.OVM_FIELD_QUEUE_STRING;
                                                                                        break block52;
                                                                                    }
                                                                                    if (FEUtils.isEnum(elementType)) {
                                                                                        macroName = this.fConstants.OVM_FIELD_QUEUE_ENUM;
                                                                                        firstParam = fieldTypeName;
                                                                                        break block52;
                                                                                    }
                                                                                    if (FEUtils.checkInheritance1(this.fRfProject, elementTypeName, this.fConstants.OVM_OBJECT_BASE)) {
                                                                                        macroName = this.fConstants.OVM_FIELD_QUEUE_OBJECT;
                                                                                    }
                                                                                    break block52;
                                                                                }
                                                                                if (!RfListType.isAssociativeArray((IRfScopeElement)fieldType)) break block53;
                                                                                DataType indexType = ((RfListType)fieldType).getIndexTypeRaw();
                                                                                assocType = ((RfListType)fieldType).getAssociatedType();
                                                                                if (assocType instanceof RfTypeAlias) {
                                                                                    assocType = ((RfTypeAlias)assocType).getTranslatedType();
                                                                                }
                                                                                wrap = new RfAssociatedTypeWrapper(indexType, field);
                                                                                assocIndexType = wrap.getAssociatedType();
                                                                                indexTypeNameForEnum = assocIndexType.getName();
                                                                                String scope = RfBatchUtils.getScopeRelativeTo(field, assocIndexType, false);
                                                                                if (!scope.isEmpty()) {
                                                                                    indexTypeNameForEnum = String.valueOf(scope) + "::" + indexTypeNameForEnum;
                                                                                }
                                                                                if (assocIndexType instanceof RfTypeAlias) {
                                                                                    assocIndexType = ((RfTypeAlias)assocIndexType).getTranslatedType();
                                                                                }
                                                                                if (assocIndexType instanceof RfBitVectorScalarType) {
                                                                                    assocIndexType = ((RfBitVectorScalarType)assocIndexType).getScalarWithDefaultSign();
                                                                                }
                                                                                indexTypeName = assocIndexType.getName();
                                                                                indexSign = null;
                                                                                if (indexType.getSign() != 0) {
                                                                                    String string = indexSign = indexType.getSign() == 1 ? "signed" : "unsigned";
                                                                                }
                                                                                if (!indexTypeName.equals("string")) break block54;
                                                                                if (!FEConstants.INTEGRAL_TYPES.contains(fieldTypeName) && !FEUtils.isPackedStruct(assocType) && !FEUtils.isPackedUnion(assocType) && !FEUtils.isPackedIntegralList(assocType)) break block55;
                                                                                macroName = this.fConstants.OVM_FIELD_AA_INT_STRING;
                                                                                break block56;
                                                                            }
                                                                            if (FEUtils.checkInheritance1(this.fRfProject, fieldTypeName, this.fConstants.OVM_OBJECT_BASE)) {
                                                                                macroName = this.fConstants.OVM_FIELD_AA_OBJECT_STRING;
                                                                                break block56;
                                                                            } else if (fieldTypeName.equals("string")) {
                                                                                macroName = this.fConstants.OVM_FIELD_AA_STRING_STRING;
                                                                            }
                                                                            break block56;
                                                                        }
                                                                        if (!indexTypeName.equals("int") || !FEUtils.checkInheritance1(this.fRfProject, fieldTypeName, this.fConstants.OVM_OBJECT_BASE)) break block57;
                                                                        macroName = this.fConstants.OVM_FIELD_AA_OBJECT_INT;
                                                                        break block56;
                                                                    }
                                                                    if (!FEConstants.INTEGRAL_TYPES.contains(fieldTypeName) && !FEUtils.isPackedStruct(assocType) && !FEUtils.isPackedUnion(assocType) && !FEUtils.isPackedIntegralList(assocType)) break block58;
                                                                    if (!indexTypeName.equals("int") || indexSign != null && !indexSign.equals("signed")) break block59;
                                                                    macroName = this.fConstants.OVM_FIELD_AA_INT_INT;
                                                                    break block56;
                                                                }
                                                                if (!indexTypeName.equals("int") || indexSign == null || !indexSign.equals("unsigned")) break block60;
                                                                macroName = this.fConstants.OVM_FIELD_AA_INT_INT_UNSIGNED;
                                                                break block56;
                                                            }
                                                            if (!indexTypeName.equals("integer") || indexSign != null && !indexSign.equals("signed")) break block61;
                                                            macroName = this.fConstants.OVM_FIELD_AA_INT_INTEGER;
                                                            break block56;
                                                        }
                                                        if (!indexTypeName.equals("integer") || indexSign == null || !indexSign.equals("unsigned")) break block62;
                                                        macroName = this.fConstants.OVM_FIELD_AA_INT_INTEGER_UNSIGNED;
                                                        break block56;
                                                    }
                                                    if (!indexTypeName.equals("byte") || indexSign != null && !indexSign.equals("signed")) break block63;
                                                    macroName = this.fConstants.OVM_FIELD_AA_INT_BYTE;
                                                    break block56;
                                                }
                                                if (!indexTypeName.equals("byte") || indexSign == null || !indexSign.equals("unsigned")) break block64;
                                                macroName = this.fConstants.OVM_FIELD_AA_INT_BYTE_UNSIGNED;
                                                break block56;
                                            }
                                            if (!indexTypeName.equals("shortint") || indexSign != null && !indexSign.equals("signed")) break block65;
                                            macroName = this.fConstants.OVM_FIELD_AA_INT_SHORTINT;
                                            break block56;
                                        }
                                        if (!indexTypeName.equals("shortint") || indexSign == null || !indexSign.equals("unsigned")) break block66;
                                        macroName = this.fConstants.OVM_FIELD_AA_INT_SHORTINT_UNSIGNED;
                                        break block56;
                                    }
                                    if (!indexTypeName.equals("longint") || indexSign != null && !indexSign.equals("signed")) break block67;
                                    macroName = this.fConstants.OVM_FIELD_AA_INT_LONGINT;
                                    break block56;
                                }
                                if (!indexTypeName.equals("longint") || indexSign == null || !indexSign.equals("unsigned")) break block68;
                                macroName = this.fConstants.OVM_FIELD_AA_INT_LONGINT_UNSIGNED;
                                break block56;
                            }
                            if (FEConstants.INTEGRAL_TYPES.contains(indexTypeName) || FEUtils.isPackedStruct(assocIndexType) || FEUtils.isPackedUnion(assocIndexType) || FEUtils.isPackedIntegralList(assocIndexType)) {
                                macroName = this.fConstants.OVM_FIELD_AA_INT_KEY;
                                firstParam = indexTypeNameForEnum;
                                if (indexSign != null) {
                                    firstParam = String.valueOf(firstParam) + " " + indexSign;
                                }
                                break block56;
                            } else if (FEUtils.isEnum(assocIndexType)) {
                                macroName = this.fConstants.OVM_FIELD_AA_INT_ENUMKEY;
                                firstParam = indexTypeNameForEnum;
                            }
                            break block56;
                        }
                        if (assocType instanceof RfPredefinedEventType) {
                            macroName = this.fConstants.OVM_FIELD_EVENT;
                        }
                    }
                    String range = wrap.getDataType().getPackedDimensionString();
                    if (range != null && !(range = range.trim()).isEmpty()) {
                        firstParam = String.valueOf(firstParam) + wrap.getDataType().getPackedDimensionString();
                    }
                    break block52;
                }
                if (fieldType instanceof RfListType) {
                    elementType = ((RfListType)fieldType).getAssociatedType();
                    if (elementType instanceof RfTypeAlias) {
                        elementType = ((RfTypeAlias)elementType).getTranslatedType();
                    }
                    if (elementType == null) break block52;
                    DataType fieldDataType = ((RfListType)fieldType).getDataType();
                    String elementTypeName = fieldDataType.getType();
                    String packedDimension = fieldDataType.getPackedDimensionString();
                    String unpackedDimension = fieldDataType.getUnpackedDimensionString();
                    if (packedDimension != null && !packedDimension.isEmpty() && (unpackedDimension == null || unpackedDimension.isEmpty())) {
                        if (FEConstants.INTEGRAL_TYPES.contains(elementTypeName) || FEUtils.isEnum(elementType) || FEUtils.isPackedStruct(elementType) || FEUtils.isPackedUnion(elementType)) {
                            macroName = this.fConstants.OVM_FIELD_INT;
                            break block52;
                        }
                        if (FEUtils.checkInheritance1(this.fRfProject, elementTypeName, this.fConstants.OVM_OBJECT_BASE)) {
                            macroName = this.fConstants.OVM_FIELD_OBJECT;
                        }
                        break block52;
                    }
                    if (!unpackedDimension.startsWith("[]")) {
                        if (FEConstants.INTEGRAL_TYPES.contains(elementTypeName)) {
                            macroName = this.fConstants.OVM_FIELD_SARRAY_INT;
                            break block52;
                        }
                        if (elementTypeName.equals("string")) {
                            macroName = this.fConstants.OVM_FIELD_SARRAY_STRING;
                            break block52;
                        }
                        if (FEUtils.isEnum(elementType)) {
                            macroName = this.fConstants.OVM_FIELD_SARRAY_ENUM;
                            firstParam = fieldTypeName;
                            break block52;
                        }
                        if (FEUtils.checkInheritance1(this.fRfProject, elementTypeName, this.fConstants.OVM_OBJECT_BASE)) {
                            macroName = this.fConstants.OVM_FIELD_SARRAY_OBJECT;
                        }
                        break block52;
                    }
                    if (FEConstants.INTEGRAL_TYPES.contains(elementTypeName)) {
                        macroName = this.fConstants.OVM_FIELD_ARRAY_INT;
                        break block52;
                    }
                    if (elementTypeName.equals("string")) {
                        macroName = this.fConstants.OVM_FIELD_ARRAY_STRING;
                        break block52;
                    }
                    if (FEUtils.isEnum(elementType)) {
                        macroName = this.fConstants.OVM_FIELD_ARRAY_ENUM;
                        firstParam = fieldTypeName;
                        break block52;
                    }
                    if (elementType instanceof RfPredefinedEventType) {
                        return null;
                    }
                    if (FEUtils.checkInheritance1(this.fRfProject, elementTypeName, this.fConstants.OVM_OBJECT_BASE)) {
                        macroName = this.fConstants.OVM_FIELD_ARRAY_OBJECT;
                    }
                    break block52;
                }
                if (fieldType == null || fieldTypeName == null) break block52;
                String translatedTypeName = fieldTypeName;
                if (fieldType instanceof RfPredefinedEventType) {
                    macroName = this.fConstants.OVM_FIELD_EVENT;
                    break block52;
                }
                if (FEConstants.INTEGRAL_TYPES.contains(translatedTypeName)) {
                    macroName = this.fConstants.OVM_FIELD_INT;
                    break block52;
                }
                if (translatedTypeName.equals("string")) {
                    macroName = this.fConstants.OVM_FIELD_STRING;
                    break block52;
                }
                if (FEConstants.REAL_TYPES.contains(translatedTypeName)) {
                    macroName = this.fConstants.OVM_FIELD_REAL;
                    break block52;
                }
                if (FEUtils.isEnum(fieldType)) {
                    macroName = this.fConstants.OVM_FIELD_ENUM;
                    firstParam = fieldTypeName;
                    break block52;
                }
                if (FEUtils.isPackedStruct(fieldType) || FEUtils.isPackedUnion(fieldType)) {
                    macroName = this.fConstants.OVM_FIELD_INT;
                    break block52;
                }
                if (FEUtils.checkInheritance1(this.fRfProject, translatedTypeName, this.fConstants.OVM_OBJECT_BASE)) {
                    macroName = this.fConstants.OVM_FIELD_OBJECT;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        FERegistration registration = new FERegistration(macroName, this.fRfProject, this.fConstants);
        if (firstParam != null) {
            registration.addParam(firstParam);
        }
        registration.addParam(fieldName);
        return registration;
    }

    private Set<String> getOperations(String flags) {
        String[] pieces = flags.split(Pattern.quote("|"));
        HashSet<String> fieldOperations = new HashSet<String>(Arrays.asList(this.fConstants.FIELD_OPERATIONS));
        HashSet<String> printRadixes = new HashSet<String>(Arrays.asList(this.fConstants.PRINT_RADIXES));
        HashSet<String> ops = new HashSet<String>();
        String[] stringArray = pieces;
        int n = pieces.length;
        int n2 = 0;
        while (n2 < n) {
            String piece = stringArray[n2];
            if (fieldOperations.contains(piece = piece.trim())) {
                ops.add(piece);
            } else if (!printRadixes.contains(piece)) {
                this.fErrorStatus = 5;
                return null;
            }
            ++n2;
        }
        return ops;
    }

    private String getRadix(String flags) {
        String[] pieces = flags.split(Pattern.quote("|"));
        HashSet<String> printRadixes = new HashSet<String>(Arrays.asList(this.fConstants.PRINT_RADIXES));
        HashSet<String> fieldOperations = new HashSet<String>(Arrays.asList(this.fConstants.FIELD_OPERATIONS));
        String radix = "";
        boolean found = false;
        String[] stringArray = pieces;
        int n = pieces.length;
        int n2 = 0;
        while (n2 < n) {
            String piece = stringArray[n2];
            if (printRadixes.contains(piece = piece.trim())) {
                if (found && !radix.equals(piece)) {
                    this.fErrorStatus = 4;
                    return null;
                }
                radix = piece;
                found = true;
            } else if (!fieldOperations.contains(piece)) {
                this.fErrorStatus = 5;
                return null;
            }
            ++n2;
        }
        return radix;
    }

    public DocumentMirror createDocumentMirror(String regAreaString) throws BadLocationException {
        DocumentMirror mirror;
        if (!this.exists()) {
            mirror = new DocumentMirror(this.fDocument, this.fCursorLine, this.fRfProject != null ? this.fRfProject.getProject() : null);
            mirror.insertText(this.fCursorLine, regAreaString);
            this.fRegAreaStartLine = this.fCursorLine;
            this.fRegAreaEndLine = this.fHasOneLineRegArea ? this.fCursorLine : this.fCursorLine + 1;
        } else {
            mirror = new DocumentMirror(this.fDocument, this.fRegAreaStartLine, this.fRegAreaEndLine);
            if (this.fHasOneLineRegArea) {
                mirror.replaceLine(this.fRegAreaStartLine, regAreaString);
                this.fRegAreaEndLine = this.fRegAreaStartLine + 1;
            }
        }
        return mirror;
    }

    public List<XVMElementModel> getOriginalModels() {
        return this.fOriginalModels;
    }

    public ClassModel getOriginalClassModel() {
        return this.fOriginalClassModel;
    }

    public boolean exists() {
        return this.fExists;
    }

    public int getErrorStatus() {
        return this.fErrorStatus;
    }

    public void setSequencer(String preferredSequencer) {
        this.fPreferedSequencer = preferredSequencer;
    }

    public boolean hasOneLineRegArea() {
        return this.fHasOneLineRegArea;
    }

    public RfProject getProject() {
        return this.fRfProject;
    }

    public int getRegAreaStartLine() {
        return this.fRegAreaStartLine;
    }

    public int getRegAreaEndLine() {
        return this.fRegAreaEndLine;
    }
}

