/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.ovm.fieldeditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FEConstants;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FEUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.parser.RfMacroRefInfo;
import ro.amiq.vlogdt.r2lparser.R2LTooltipManager;

public class FEUtilsCommon {
    public static final String UVM_VOID = "uvm_void";
    public static final String OVM_VOID = "ovm_void";
    public static final String OUTSIDE_CLASS_ERROR = "Please place the cursor inside the class you want to use with Field Editor.";
    public static final String CLASS_NOT_UVM_EXTENDED_ERROR = "The enclosing class must extend a class from the OVM/UVM library!";

    public static boolean isEnum(IRfNamedElement assocType) {
        return assocType instanceof RfStruct && ((RfStruct)assocType).isEnum();
    }

    public static boolean isPackedStruct(IRfNamedElement assocType) {
        return assocType instanceof RfStruct && ((RfStruct)assocType).isStruct() && ((RfStruct)assocType).isPacked();
    }

    public static boolean isPackedUnion(IRfNamedElement assocType) {
        return assocType instanceof RfStruct && ((RfStruct)assocType).isUnion() && ((RfStruct)assocType).isPacked();
    }

    public static boolean isPackedIntegralList(IRfNamedElement assocType) {
        if (!(assocType instanceof RfListType)) {
            return false;
        }
        String packedDimension = ((RfListType)assocType).getPackedDimension();
        String unpackedDimension = ((RfListType)assocType).getUnpackedDimension();
        return packedDimension != null && !packedDimension.isEmpty() && (unpackedDimension == null || unpackedDimension.isEmpty());
    }

    public static boolean checkInheritance1(RfProject rfProject, String typeName, String supertypeName) {
        RfNamedElement[] types = rfProject.getAllTypes(false, false);
        if (types == null || types.length == 0) {
            return false;
        }
        RfNamedElement[] rfNamedElementArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            RfNamedElement type = rfNamedElementArray[n2];
            if (type instanceof RfClass && type.getName().equals(typeName)) {
                return FEUtilsCommon.checkInheritance((RfClass)type, supertypeName);
            }
            ++n2;
        }
        return false;
    }

    public static boolean checkInheritance(RfClass clazz, String parent) {
        do {
            if (!clazz.getName().equals(parent)) continue;
            return true;
        } while ((clazz = clazz.getParent()) != null);
        return false;
    }

    public static RfClass getEnclosingClass(IRfScopeElement scope) {
        if (scope == null || !(scope instanceof RfDefElement)) {
            return null;
        }
        RfNamedElement result = ((RfDefElement)scope).getNamedElement();
        while (result != null) {
            if (result instanceof RfClass) {
                return (RfClass)result;
            }
            result = result.getEnclosingScope();
        }
        return null;
    }

    public static boolean isOvmUvmRegistrationArea(RfProject project, RfFileDef fileDef, IDocument document, RfClass rfClass, int methodology, int currentLine) {
        FEConstants constants = FEConstants.getInstance(methodology);
        HashMap classMacroRefsByName = new HashMap();
        classMacroRefsByName.clear();
        if (rfClass.getDeclaration() == null) {
            return false;
        }
        int classStartOffset = rfClass.getDeclaration().getStartOffset();
        int classEndOffset = rfClass.getDeclaration().getEndOffset();
        ParserPath fileName = rfClass.getFile().getParserPath();
        List<RfMacroRefInfo> fileMacroRefs = project.getPreprocessingTable().getMacroRefsMapByFile().get(fileName);
        if (fileMacroRefs == null) {
            return false;
        }
        ArrayList<RfMacroRefInfo> classMacroRefs = new ArrayList<RfMacroRefInfo>();
        for (RfMacroRefInfo macroRef : fileMacroRefs) {
            if (macroRef.getStartOffset() <= classStartOffset || macroRef.getStartOffset() >= classEndOffset) continue;
            classMacroRefs.add(macroRef);
        }
        for (RfMacroRefInfo macroRef : classMacroRefs) {
            if (!constants.OVM_UTILS_MACROS.contains(macroRef.getMacroName()) || !FEUtilsCommon.isMacroInClass(project, fileDef, document, rfClass, macroRef) || currentLine != macroRef.getLine()) continue;
            return true;
        }
        int regAreaEndLine = -1;
        int regAreaStartLine = -1;
        for (RfMacroRefInfo macroRef : classMacroRefs) {
            if (constants.OVM_UTILS_BEGIN_MACROS.contains(macroRef.getMacroName()) && FEUtilsCommon.isMacroInClass(project, fileDef, document, rfClass, macroRef)) {
                regAreaStartLine = macroRef.getLine();
            }
            if (!constants.OVM_UTILS_END_MACROS.contains(macroRef.getMacroName()) || !FEUtilsCommon.isMacroInClass(project, fileDef, document, rfClass, macroRef)) continue;
            regAreaEndLine = macroRef.getLine();
        }
        if (regAreaStartLine != -1 && regAreaEndLine != -1 && regAreaStartLine <= currentLine && currentLine <= regAreaEndLine) {
            return true;
        }
        if (regAreaStartLine == -1 && regAreaEndLine == -1) {
            return false;
        }
        if (regAreaStartLine == -1 && regAreaEndLine != -1) {
            return false;
        }
        if (regAreaStartLine != -1 && regAreaEndLine == -1) {
            return false;
        }
        return false;
    }

    private static boolean isMacroInClass(RfProject project, RfFileDef fileDef, IDocument document, RfClass rfClass, RfMacroRefInfo macroRef) {
        try {
            int offset = document.getLineOffset(macroRef.getLine() - 1);
            RfDefElement rfScope = fileDef.getScope(offset, true);
            R2LTooltipManager manager = new R2LTooltipManager(null, project, rfScope, null, fileDef.getParserPath(), document, offset, offset, null, false, false, false);
            RfWNamedElementAndScope nes = manager.getElement();
            return rfClass == FEUtilsCommon.getEnclosingClass(nes.getScope());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean hasActualFields(RfClass clazz, boolean hasParameter) {
        int nofParameters = 0;
        boolean result = true;
        if (clazz.getDeclaration().getChildren() == null || clazz.getDeclaration().getChildren().isEmpty()) {
            result = false;
        }
        if (hasParameter) {
            for (RfField field : clazz.getLocalParameters(384)) {
                if (!field.isInParameterPortList()) continue;
                ++nofParameters;
            }
            if (result && clazz.getDeclaration().getChildren().size() == nofParameters) {
                result = false;
            }
        }
        return result;
    }

    public static String getClassNameWithParameters(RfClass clazz, boolean hasParameter) {
        StringBuilder result = new StringBuilder(clazz.getName());
        if (hasParameter) {
            result.append("#(");
            for (RfField field : clazz.getLocalParameters(384)) {
                if (!field.isInParameterPortList()) continue;
                result.append(field.getName()).append(", ");
            }
            if (result.length() > 2) {
                result.delete(result.length() - 2, result.length());
            }
            result.append(")");
        }
        return result.toString();
    }

    public static List<String> collectSequencers(RfProject rfProject, RfClass clazz, FEConstants constants) {
        if (rfProject == null || clazz == null || constants == null) {
            return null;
        }
        if (!FEUtils.checkInheritance(clazz, constants.OVM_SEQUENCE_BASE)) {
            return null;
        }
        ArrayList<String> sequencers = new ArrayList<String>();
        RfClass[] rfClassArray = rfProject.getAllClasses();
        int n = rfClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            RfClass c = rfClassArray[n2];
            if (c != null && FEUtils.checkInheritance(c, constants.OVM_SEQUENCER_BASE)) {
                sequencers.add(c.getName());
            }
            ++n2;
        }
        return sequencers;
    }
}

