/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.ovm.fieldeditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.utils.DVTJobsUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.ClassModel;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FEConstants;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FEDialog;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FERegistrationArea;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FEUtils;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FieldModel;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.XVMElementModel;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;

public class FieldEditor {
    private Shell fShell;
    private RfProject fRfProject;
    private RfClass fRfClass;
    private RfField fRfField;
    private List<XVMElementModel> fModifiedModels;
    private FEConstants fConstants;
    private List<ClassModel> fModifiedClassModels;
    private boolean fHasGUIFilteredElements;
    private FERegistrationArea registrationArea;

    public FieldEditor(Shell shell, IDocument document, ITextEditor textEditor, int offset, RfProject rfProject, RfClass rfClass, RfField rfField, FEConstants constants) {
        this.fShell = shell;
        this.fRfProject = rfProject;
        this.fRfClass = rfClass;
        this.fRfField = rfField;
        this.fConstants = constants;
        IFile file = RfBatchUtils.getFileFromTextEditor(textEditor);
        this.registrationArea = new FERegistrationArea(document, file, offset, rfProject, rfClass, constants);
    }

    public void open() throws BadLocationException {
        int result;
        this.fHasGUIFilteredElements = false;
        this.registrationArea.performPreliminaryChecks();
        if (this.registrationArea.getErrorStatus() != 0) {
            FEUtils.showError(this.fShell, "Preliminary Check Failed", this.fConstants.STATUS_STRINGS.get(this.registrationArea.getErrorStatus()));
            return;
        }
        this.registrationArea.scanRegistrationArea();
        if (this.registrationArea.getErrorStatus() != 0) {
            FEUtils.showError(this.fShell, "Scanning Class " + this.fRfClass.getName() + " Failed", this.fConstants.STATUS_STRINGS.get(this.registrationArea.getErrorStatus()));
            return;
        }
        if (!this.registrationArea.exists()) {
            String sequencer = this.pickSequencer();
            if (sequencer == null) {
                return;
            }
            this.registrationArea.setSequencer(sequencer);
        }
        DVTJobsUtils.runWithBusyIndicator((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    FieldEditor.this.registrationArea.makeModel();
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    FieldEditor.this.registrationArea.resetOriginalModels();
                }
            }
        });
        ClassModel originalClassModel = this.registrationArea.getOriginalClassModel();
        List<XVMElementModel> originalModels = this.registrationArea.getOriginalModels();
        if (originalClassModel == null || originalModels == null) {
            if (this.registrationArea.getErrorStatus() != 0) {
                FEUtils.showError(this.fShell, "Error scanning class", "DVT was unable to scan this class for a valid registration area.");
            }
            return;
        }
        this.fModifiedModels = new ArrayList<XVMElementModel>();
        for (XVMElementModel fm : originalModels) {
            if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.FIELD_EDITOR, (IRfNamedElement)((FieldModel)fm).getRfField(), () -> fm.getSignature()) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                this.fHasGUIFilteredElements = true;
                continue;
            }
            this.fModifiedModels.add(fm.clone());
        }
        this.fModifiedClassModels = new ArrayList<ClassModel>();
        this.fModifiedClassModels.add(originalClassModel.clone());
        FEDialog dialog = new FEDialog(this.fShell, this.fRfClass.getName(), this.fConstants);
        dialog.setInput(this.fModifiedModels, this.fModifiedClassModels, this.fHasGUIFilteredElements);
        if (this.fRfField != null) {
            for (XVMElementModel m : this.fModifiedModels) {
                if (!m.getName().equals(this.fRfField.getName())) continue;
                dialog.setSelection(m);
                break;
            }
        }
        if ((result = dialog.open()) != 0) {
            return;
        }
        DVTJobsUtils.runWithBusyIndicator((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    FieldEditor.this.registrationArea.applyModel(FieldEditor.this.fModifiedModels, FieldEditor.this.fModifiedClassModels);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    FEUtils.showError(FieldEditor.this.fShell, "Internal Error", "DVT encountered an internal error while trying to update the registration area.");
                }
            }
        });
    }

    private String pickSequencer() {
        List<String> sequencers = FEUtils.collectSequencers(this.fRfProject, this.fRfClass, this.fConstants);
        if (sequencers == null) {
            return "";
        }
        LabelProvider renderer = new LabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.fShell, (ILabelProvider)renderer);
        dialog.setTitle("Choose sequencer");
        dialog.setMessage("Pick the sequencer you want to use with this sequence.");
        dialog.setElements(sequencers.toArray());
        if (dialog.open() == 0) {
            return (String)dialog.getFirstResult();
        }
        return null;
    }
}

