/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.ovm.fieldeditor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FEConstants;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.XVMElementModel;
import ro.amiq.vlogdt.parser.RfMacroRefInfo;
import ro.amiq.vlogdt.ui.preferences.PrefConst;

public class FieldModel
extends XVMElementModel
implements Cloneable {
    public static final int DEFAULT_RADIX_INDEX = 4;
    public static final int DEFAULT_OPERATION_INDEX = 0;
    private String fType;
    private Set<String> fOperations;
    private String fRadix;
    private RfField fRfField;

    public FieldModel(RfField rfField, String regMacroName, String name, String type, boolean registered, boolean corrupted, String corruptionReason, FEConstants constants) {
        this.fName = name;
        this.fType = type;
        this.fRegistered = registered;
        this.fCorrupted = corrupted;
        this.fCorruptionReason = corruptionReason;
        this.fRadix = "";
        this.fOperations = new HashSet<String>();
        this.fRfField = rfField;
        this.fMacroName = regMacroName;
        this.fConstants = constants;
    }

    public FieldModel(RfField rfField, String regMacroName, RfMacroRefInfo macroRef, String name, String type, String radix, Set<String> flags, FEConstants constants) {
        this.fName = name;
        this.fType = type;
        this.fRegistered = true;
        this.fCorrupted = false;
        this.fRadix = radix;
        this.fOperations = new HashSet<String>(flags);
        this.fRfField = rfField;
        this.fMacroRef = macroRef;
        this.fMacroName = regMacroName;
        this.fConstants = constants;
    }

    public String getType() {
        return this.fType;
    }

    public String getRadix() {
        return this.fRadix;
    }

    @Override
    public int getRadixIndex() {
        int i = 0;
        while (i < this.fConstants.PRINT_RADIXES.length) {
            if (this.fConstants.PRINT_RADIXES[i].equals(this.fRadix)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setRadix(String radix) {
        this.fRadix = radix;
    }

    @Override
    public void setRadix(int radixIndex) {
        this.fRadix = this.fConstants.PRINT_RADIXES[radixIndex];
    }

    public Set<String> getOperations() {
        return this.fOperations;
    }

    @Override
    public void setOperation(int operationIndex, boolean isSelected) {
        if (isSelected) {
            this.fOperations.add(this.fConstants.FIELD_OPERATIONS[operationIndex]);
        } else {
            this.fOperations.remove(this.fConstants.FIELD_OPERATIONS[operationIndex]);
        }
    }

    public boolean hasOperation(String operation) {
        return this.fOperations.contains(operation);
    }

    @Override
    public boolean hasOperation(int operationIndex) {
        return this.fOperations.contains(this.fConstants.FIELD_OPERATIONS[operationIndex]);
    }

    public RfField getRfField() {
        return this.fRfField;
    }

    public void setRfField(RfField rfField) {
        this.fRfField = rfField;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FieldModel)) {
            return false;
        }
        FieldModel model = (FieldModel)obj;
        if (!model.fName.equals(this.fName)) {
            return false;
        }
        if (!model.fType.equals(this.fType)) {
            return false;
        }
        if (model.fCorrupted != this.fCorrupted) {
            return false;
        }
        if (model.fRegistered != this.fRegistered) {
            return false;
        }
        if (!model.fRadix.equals(this.fRadix)) {
            return false;
        }
        if (model.fMacroRef == null && this.fMacroRef != null || model.fMacroRef != null && this.fMacroRef == null) {
            return false;
        }
        if (model.fMacroRef != null && this.fMacroRef != null && model.fMacroRef != this.fMacroRef) {
            return false;
        }
        return this.fOperations.equals(model.fOperations);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fName == null ? 0 : this.fName.hashCode());
        result = 31 * result + (this.fType == null ? 0 : this.fType.hashCode());
        result = 31 * result + Boolean.hashCode(this.fCorrupted);
        result = 31 * result + Boolean.hashCode(this.fRegistered);
        result = 31 * result + (this.fRadix == null ? 0 : this.fRadix.hashCode());
        result = 31 * result + (this.fMacroRef == null ? 0 : this.fMacroRef.hashCode());
        result = 31 * result + (this.fOperations == null ? 0 : this.fOperations.hashCode());
        return result;
    }

    public String getFlags() {
        String result = DVTStringUtil.join(this.fOperations, (String)" | ");
        if (!this.fRadix.equals("")) {
            return result.isEmpty() ? this.fRadix : String.valueOf(result) + " | " + this.fRadix;
        }
        return result;
    }

    public String toString() {
        return "[" + this.fName + ":" + this.fType + ", " + (this.isRegistered() ? "registered" : "unregistered") + ", " + (this.isCorrupted() ? "corrupted" : "not corrupted") + ", " + this.getFlags() + "]";
    }

    @Override
    public FieldModel clone() {
        HashSet<String> ops = new HashSet<String>();
        for (String op : this.fOperations) {
            ops.add(op);
        }
        FieldModel result = new FieldModel(this.fRfField, this.fMacroName, this.fMacroRef, this.fName, this.fType, this.fRadix, ops, this.fConstants);
        result.setRegistered(this.fRegistered);
        result.setCorrupted(this.fCorrupted);
        result.setCorruptionReason(this.fCorruptionReason);
        result.setMacroName(this.fMacroName);
        return result;
    }

    @Override
    public boolean hasAnyFlags() {
        return !this.fOperations.isEmpty() || !this.fRadix.equals("");
    }

    @Override
    public void setDefault(boolean state) {
        IPreferenceStore preferenceStore = VlogPlugin.getDefault().getPreferenceStore();
        List<String> fieldOperationsPref = Arrays.asList(PrefConst.getXVMFieldOperations(preferenceStore, this.fConstants.METHODLOGY).split(","));
        this.setDefaultRadix();
        this.clearOperations();
        if (state) {
            int i = 0;
            while (i < this.fConstants.FIELD_OPERATIONS.length) {
                if (fieldOperationsPref.contains(this.fConstants.FIELD_OPERATIONS[i])) {
                    this.fOperations.add(this.fConstants.FIELD_OPERATIONS[i]);
                }
                ++i;
            }
            i = 0;
            while (i < this.fConstants.PRINT_RADIXES.length) {
                if (PrefConst.getXVMFieldRadix(preferenceStore, this.fConstants.METHODLOGY).equals(this.fConstants.PRINT_RADIXES[i])) {
                    this.setRadix(this.fConstants.PRINT_RADIXES[i]);
                    break;
                }
                ++i;
            }
        }
    }

    private void setDefaultRadix() {
        String fieldType = this.getType();
        if (fieldType.equals("bit") || fieldType.equals("reg") || fieldType.equals("logic") || fieldType.equals("time")) {
            this.setRadix(this.fConstants.OVM_UNSIGNED);
        } else {
            this.clearRadix();
        }
    }

    @Override
    public void clearRadix() {
        this.fRadix = "";
    }

    @Override
    public void clearOperations() {
        this.fOperations.clear();
    }

    @Override
    public void setAllOperations() {
        this.fOperations.clear();
        String[] stringArray = this.fConstants.FIELD_OPERATIONS;
        int n = this.fConstants.FIELD_OPERATIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String fOp = stringArray[n2];
            this.fOperations.add(fOp);
            ++n2;
        }
    }

    public void setOperations(Set<String> operations) {
        this.fOperations = operations;
    }

    int getFieldLine() {
        return this.fRfField.getLine();
    }

    @Override
    public String getStatusMessage() {
        if (this.getStatus() == 13) {
            return this.fCorruptionReason;
        }
        if (this.getStatus() == 12) {
            return "This field is registered with `" + this.getEditorMacroName() + " instead of `" + this.getDVTMacroName() + ".";
        }
        return this.fConstants.STATUS_STRINGS.get(this.getStatus());
    }

    @Override
    public String getSignature() {
        return String.valueOf(this.getName()) + " : " + this.getType();
    }
}

