/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.ovm.fieldeditor;

import java.util.function.BiConsumer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FEConstants;

public class FieldOperationsAndRadixComponent {
    private Button fAllOnButton;
    private Button fAllOffButton;
    private Button[] fOperationButtons;
    private Button[] fRadixButtons;
    private Button fClearButton;
    private BiConsumer<String, String> listener;

    public FieldOperationsAndRadixComponent(Composite parent, FEConstants fConstants, BiConsumer<String, String> listener) {
        this(parent, fConstants);
        this.listener = listener;
    }

    public FieldOperationsAndRadixComponent(Composite parent, FEConstants fConstants) {
        Composite bigComposite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        GridData gd = new GridData(4, 4, true, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        bigComposite.setLayout((Layout)gl);
        bigComposite.setLayoutData((Object)gd);
        this.createOperationsGroup(bigComposite, fConstants);
        this.createRadixGroup(bigComposite, fConstants);
        Dialog.applyDialogFont((Control)bigComposite);
    }

    public String getSelectedOperationFields() {
        String selectedOperationFields = "";
        int i = 0;
        while (i < this.fOperationButtons.length) {
            if (this.fOperationButtons[i].getSelection()) {
                selectedOperationFields = selectedOperationFields.isEmpty() ? this.fOperationButtons[i].getText() : String.valueOf(selectedOperationFields) + "," + this.fOperationButtons[i].getText();
            }
            ++i;
        }
        return selectedOperationFields;
    }

    public String getSelectedRadixField() {
        int i = 0;
        while (i < this.fRadixButtons.length) {
            if (this.fRadixButtons[i].getSelection()) {
                return this.fRadixButtons[i].getText();
            }
            ++i;
        }
        return "";
    }

    public void setOperationsFields(String operationFields) {
        this.setAllOperations(false);
        String[] stringArray = operationFields.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String operationField = stringArray[n2];
            int i = 0;
            while (i < this.fOperationButtons.length) {
                if (this.fOperationButtons[i].getText().equals(operationField)) {
                    this.fOperationButtons[i].setSelection(true);
                    break;
                }
                ++i;
            }
            ++n2;
        }
    }

    public void setRadixField(String radixField) {
        int i = 0;
        while (i < this.fRadixButtons.length) {
            this.fRadixButtons[i].setSelection(this.fRadixButtons[i].getText().equals(radixField));
            ++i;
        }
    }

    public void setEnabled(boolean isEnabled) {
        int i = 0;
        while (i < this.fOperationButtons.length) {
            this.fOperationButtons[i].setEnabled(isEnabled);
            ++i;
        }
        i = 0;
        while (i < this.fRadixButtons.length) {
            this.fRadixButtons[i].setEnabled(isEnabled);
            ++i;
        }
        this.fAllOffButton.setEnabled(isEnabled);
        this.fAllOnButton.setEnabled(isEnabled);
        this.fClearButton.setEnabled(isEnabled);
    }

    private void setAllOperations(boolean isOn) {
        int i = 0;
        while (i < this.fOperationButtons.length) {
            this.fOperationButtons[i].setSelection(isOn);
            ++i;
        }
    }

    private void clearPrintRadix() {
        int i = 0;
        while (i < this.fRadixButtons.length) {
            this.fRadixButtons[i].setSelection(false);
            ++i;
        }
    }

    private void createOperationsGroup(Composite parent, FEConstants fConstants) {
        Group group = new Group(parent, 0);
        group.setText("Field Operations");
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout());
        this.createOperationCheckBoxes((Composite)group, fConstants);
        this.createOperationButtons((Composite)group);
        Dialog.applyDialogFont((Control)group);
    }

    private void createOperationButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 1024, true, false));
        GridLayout gl = new GridLayout(2, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        this.fAllOnButton = new Button(composite, 8);
        this.fAllOnButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fAllOnButton.setText("All on");
        this.fAllOnButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FieldOperationsAndRadixComponent.this.setAllOperations(true);
                FieldOperationsAndRadixComponent.this.notifyListener();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fAllOffButton = new Button(composite, 8);
        this.fAllOffButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fAllOffButton.setText("All off");
        this.fAllOffButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FieldOperationsAndRadixComponent.this.setAllOperations(false);
                FieldOperationsAndRadixComponent.this.notifyListener();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createOperationCheckBoxes(Composite parent, FEConstants fConstants) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        this.fOperationButtons = new Button[fConstants.FIELD_OPERATIONS.length];
        int i = 0;
        while (i < fConstants.FIELD_OPERATIONS.length) {
            this.fOperationButtons[i] = new Button(composite, 32);
            this.fOperationButtons[i].setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.fOperationButtons[i].setText(fConstants.FIELD_OPERATIONS[i]);
            this.fOperationButtons[i].setToolTipText(FEConstants.FIELD_OPERATION_TOOLTIPS[i]);
            this.fOperationButtons[i].addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    FieldOperationsAndRadixComponent.this.notifyListener();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            ++i;
        }
    }

    private void createRadixGroup(Composite parent, FEConstants fConstants) {
        Group group = new Group(parent, 0);
        group.setText("Print Radix");
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout());
        this.createRadixCheckBoxes((Composite)group, fConstants);
        this.createDefaultButton((Composite)group);
        Dialog.applyDialogFont((Control)group);
    }

    private void createDefaultButton(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.fClearButton = new Button(composite, 8);
        this.fClearButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fClearButton.setText("Clear");
        this.fClearButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FieldOperationsAndRadixComponent.this.clearPrintRadix();
                FieldOperationsAndRadixComponent.this.notifyListener();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createRadixCheckBoxes(Composite parent, FEConstants fConstants) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fRadixButtons = new Button[fConstants.PRINT_RADIXES.length];
        int i = 0;
        while (i < fConstants.PRINT_RADIXES.length) {
            this.fRadixButtons[i] = new Button(composite, 16);
            this.fRadixButtons[i].setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.fRadixButtons[i].setText(fConstants.PRINT_RADIXES[i]);
            this.fRadixButtons[i].setToolTipText(FEConstants.PRINT_RADIX_TOOLTIPS[i]);
            this.fRadixButtons[i].addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    FieldOperationsAndRadixComponent.this.notifyListener();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            ++i;
        }
    }

    private void notifyListener() {
        if (this.listener != null) {
            this.listener.accept(this.getSelectedOperationFields(), this.getSelectedRadixField());
        }
    }
}

