/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.ovm.fieldeditor;

import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FEConstants;
import ro.amiq.vlogdt.parser.RfMacroRefInfo;

public abstract class XVMElementModel
implements Cloneable {
    protected String fName;
    protected boolean fRegistered;
    protected RfMacroRefInfo fMacroRef;
    protected boolean fCorrupted;
    protected String fCorruptionReason;
    protected String fMacroName;
    protected FEConstants fConstants;

    public String getName() {
        return this.fName;
    }

    public void setRegistered(boolean registered) {
        this.fRegistered = registered;
    }

    public boolean isRegistered() {
        return this.fRegistered;
    }

    public boolean isCorrupted() {
        return this.fCorrupted;
    }

    public void setCorrupted(boolean corrupted) {
        this.fCorrupted = corrupted;
    }

    public String getCorruptionReason() {
        return this.fCorruptionReason;
    }

    public void setCorruptionReason(String corruptionReason) {
        this.fCorruptionReason = corruptionReason;
    }

    int getMacroRefLine() {
        return this.fMacroRef.getLine();
    }

    public RfMacroRefInfo getMacroRef() {
        return this.fMacroRef;
    }

    public void setMacroRef(RfMacroRefInfo fMacroRef) {
        this.fMacroRef = fMacroRef;
    }

    public boolean isMacroUndetermined() {
        return this.fMacroName == null;
    }

    public String getDVTMacroName() {
        return this.fMacroName == null ? this.fConstants.OVM_FIELD_OBJECT : this.fMacroName;
    }

    public String getEditorMacroName() {
        if (this.fMacroRef != null) {
            return this.fMacroRef.getMacroName();
        }
        return this.getDVTMacroName();
    }

    public void setMacroName(String macroName) {
        this.fMacroName = macroName;
    }

    public void performRegistration(boolean state) {
        this.setRegistered(state);
        this.setCorrupted(false);
        this.setDefault(state);
        if (!state) {
            this.fMacroRef = null;
        }
    }

    protected abstract void setDefault(boolean var1);

    public int getStatus() {
        if (this.isMacroUndetermined() && this.isRegistered() && !this.isCorrupted()) {
            return 10;
        }
        if (this.isMacroUndetermined() && !this.isRegistered()) {
            return 11;
        }
        if (!this.isMacroUndetermined() && this.isRegistered() && !this.areMacroNamesEqual(this.getDVTMacroName(), this.getEditorMacroName())) {
            return 12;
        }
        if (this.isCorrupted()) {
            return 13;
        }
        return 0;
    }

    private boolean areMacroNamesEqual(String dvtMacroName, String editorMacroName) {
        if (dvtMacroName.equals(editorMacroName)) {
            return true;
        }
        if (this.fConstants.OVM_SINGLE_TO_DOUBLE_MACROS.containsKey(editorMacroName) && this.fConstants.OVM_SINGLE_TO_DOUBLE_MACROS.containsValue(dvtMacroName) && this.fConstants.OVM_SINGLE_TO_DOUBLE_MACROS.get(editorMacroName).equals(dvtMacroName)) {
            return true;
        }
        return this.fConstants.OVM_SINGLE_TO_DOUBLE_MACROS.containsKey(dvtMacroName) && this.fConstants.OVM_SINGLE_TO_DOUBLE_MACROS.containsValue(editorMacroName) && this.fConstants.OVM_SINGLE_TO_DOUBLE_MACROS.get(dvtMacroName).equals(editorMacroName);
    }

    public int getStatusSeverity() {
        switch (this.getStatus()) {
            case 13: {
                return 3;
            }
            case 12: {
                return 3;
            }
            case 10: {
                return 2;
            }
            case 11: {
                return 2;
            }
        }
        return 1;
    }

    public String getSignature() {
        return null;
    }

    public abstract XVMElementModel clone();

    public boolean equals(Object obj) {
        if (!(obj instanceof XVMElementModel)) {
            return false;
        }
        XVMElementModel xvmObj = (XVMElementModel)obj;
        if (!xvmObj.getName().equals(this.fName)) {
            return false;
        }
        if (xvmObj.isRegistered() != this.fRegistered) {
            return false;
        }
        if (xvmObj.isCorrupted() != this.fCorrupted) {
            return false;
        }
        String dvtMacroName = xvmObj.getDVTMacroName();
        if (dvtMacroName != null && !dvtMacroName.equals(this.fMacroName)) {
            return false;
        }
        String editorMacroName = xvmObj.getEditorMacroName();
        return editorMacroName == null || editorMacroName.equals(this.getEditorMacroName());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fName == null ? 0 : this.fName.hashCode());
        result = 31 * result + Boolean.hashCode(this.fRegistered);
        result = 31 * result + Boolean.hashCode(this.fCorrupted);
        result = 31 * result + (this.fMacroName == null ? 0 : this.fMacroName.hashCode());
        String editorMacroName = this.getEditorMacroName();
        result = 31 * result + (editorMacroName == null ? 0 : editorMacroName.hashCode());
        return result;
    }

    public abstract String getStatusMessage();

    public void setOperation(int i, boolean selection) {
    }

    public void setRadix(int i) {
    }

    public void clearRadix() {
    }

    public boolean hasOperation(int i) {
        return false;
    }

    public int getRadixIndex() {
        return 0;
    }

    public void setAllOperations() {
    }

    public void clearOperations() {
    }

    public boolean hasAnyFlags() {
        return false;
    }
}

