/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.predefined;

import java.util.IdentityHashMap;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfComputedListType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedScalarType;

public class RfBitVectorScalarType
extends RfPredefinedScalarType {
    private static final long serialVersionUID = 1L;
    public static final RfBitVectorScalarType SHORTINT = new RfBitVectorScalarType("shortint", "Shortint type - 2-state SystemVerilog data type", 16, 1, 1, 0);
    public static final RfBitVectorScalarType SHORTINT_UNSIGNED = new RfBitVectorScalarType("shortint unsigned", "Shortint type - 2-state SystemVerilog data type", 16, 2, 1, 1);
    public static final RfBitVectorScalarType INT = new RfBitVectorScalarType("int", "Integer type - 2-state SystemVerilog data type", 32, 1, 1, 0);
    public static final RfBitVectorScalarType INT_UNSIGNED = new RfBitVectorScalarType("int unsigned", "Integer type - 2-state SystemVerilog data type", 32, 2, 1, 1);
    public static final RfBitVectorScalarType LONGINT = new RfBitVectorScalarType("longint", "Longint type - 2-state SystemVerilog data type", 64, 1, 1, 0);
    public static final RfBitVectorScalarType LONGINT_UNSIGNED = new RfBitVectorScalarType("longint unsigned", "Longint type - 2-state SystemVerilog data type", 64, 2, 1, 1);
    public static final RfBitVectorScalarType BYTE = new RfBitVectorScalarType("byte", "Byte type - 2-state SystemVerilog data type", 8, 1, 1, 0);
    public static final RfBitVectorScalarType BYTE_UNSIGNED = new RfBitVectorScalarType("byte unsigned", "Byte type - 2-state SystemVerilog data type", 8, 2, 1, 1);
    public static final RfBitVectorScalarType BIT = new RfBitVectorScalarType("bit", "Bit type - 2-state SystemVerilog data type", 1, 2, 1, 0);
    public static final RfBitVectorScalarType BIT_SIGNED = new RfBitVectorScalarType("bit signed", "Bit type - 2-state SystemVerilog data type", 1, 1, 1, 1);
    public static final RfBitVectorScalarType LOGIC = new RfBitVectorScalarType("logic", "Logic type - 4-state SystemVerilog data type", 1, 2, 2, 0);
    public static final RfBitVectorScalarType LOGIC_SIGNED = new RfBitVectorScalarType("logic signed", "Logic type - 4-state SystemVerilog data type", 1, 1, 2, 1);
    public static final RfBitVectorScalarType REG = new RfBitVectorScalarType("reg", "Reg type - 4-state SystemVerilog data type", 1, 2, 2, 0);
    public static final RfBitVectorScalarType REG_SIGNED = new RfBitVectorScalarType("reg signed", "Reg type - 4-state SystemVerilog data type", 1, 1, 2, 1);
    public static final RfBitVectorScalarType INTEGER = new RfBitVectorScalarType("integer", "Integer type - 4-state SystemVerilog data type", 32, 1, 2, 0);
    public static final RfBitVectorScalarType INTEGER_UNSIGNED = new RfBitVectorScalarType("integer unsigned", "Integer type - 4-state SystemVerilog data type", 32, 2, 2, 1);
    public static final RfBitVectorScalarType TIME = new RfBitVectorScalarType("time", "Time type - 4-state SystemVerilog data type", 64, 2, 2, 0);
    public static final RfBitVectorScalarType TIME_SIGNED = new RfBitVectorScalarType("time signed", "Time type - 4-state SystemVerilog data type", 64, 1, 2, 1);
    private static final IdentityHashMap<RfBitVectorScalarType, VlogBitVector> CONTEXT_CACHE = new IdentityHashMap();
    private final byte sign;
    private final byte notDefaultSign;
    private final byte bitState;
    private final byte bitSize;
    private RfComputedListType simpleBitVectorType;
    private RfBitVectorScalarType flippedSignScalarType;

    static {
        CONTEXT_CACHE.put(BIT, DataType.BIT_UNSIGNED_CONTEXT);
        CONTEXT_CACHE.put(BIT_SIGNED, DataType.BIT_SIGNED_CONTEXT);
        CONTEXT_CACHE.put(REG, DataType.LOGIC_UNSIGNED_CONTEXT);
        CONTEXT_CACHE.put(REG_SIGNED, DataType.LOGIC_SIGNED_CONTEXT);
        CONTEXT_CACHE.put(LOGIC, DataType.LOGIC_UNSIGNED_CONTEXT);
        CONTEXT_CACHE.put(LOGIC_SIGNED, DataType.LOGIC_SIGNED_CONTEXT);
        CONTEXT_CACHE.put(BYTE, DataType.BYTE_SIGNED_CONTEXT);
        CONTEXT_CACHE.put(BYTE_UNSIGNED, DataType.BYTE_UNSIGNED_CONTEXT);
        CONTEXT_CACHE.put(SHORTINT, DataType.SHORT_SIGNED_CONTEXT);
        CONTEXT_CACHE.put(SHORTINT_UNSIGNED, DataType.SHORT_UNSIGNED_CONTEXT);
        CONTEXT_CACHE.put(INT, DataType.INT_SIGNED_CONTEXT);
        CONTEXT_CACHE.put(INT_UNSIGNED, DataType.INT_UNSIGNED_CONTEXT);
        CONTEXT_CACHE.put(LONGINT, DataType.LONG_SIGNED_CONTEXT);
        CONTEXT_CACHE.put(LONGINT_UNSIGNED, DataType.LONG_UNSIGNED_CONTEXT);
        CONTEXT_CACHE.put(INTEGER, DataType.INTEGER_SIGNED_CONTEXT);
        CONTEXT_CACHE.put(INTEGER_UNSIGNED, DataType.INTEGER_UNSIGNED_CONTEXT);
        CONTEXT_CACHE.put(TIME, DataType.TIME_UNSIGNED_CONTEXT);
        CONTEXT_CACHE.put(TIME_SIGNED, DataType.TIME_SIGNED_CONTEXT);
        RfBitVectorScalarType.BIT.flippedSignScalarType = BIT_SIGNED;
        RfBitVectorScalarType.BIT_SIGNED.flippedSignScalarType = BIT;
        RfBitVectorScalarType.LOGIC.flippedSignScalarType = LOGIC_SIGNED;
        RfBitVectorScalarType.LOGIC_SIGNED.flippedSignScalarType = LOGIC;
        RfBitVectorScalarType.REG.flippedSignScalarType = REG_SIGNED;
        RfBitVectorScalarType.REG_SIGNED.flippedSignScalarType = REG;
        RfBitVectorScalarType.BYTE.flippedSignScalarType = BYTE_UNSIGNED;
        RfBitVectorScalarType.BYTE_UNSIGNED.flippedSignScalarType = BYTE;
        RfBitVectorScalarType.SHORTINT.flippedSignScalarType = SHORTINT_UNSIGNED;
        RfBitVectorScalarType.SHORTINT_UNSIGNED.flippedSignScalarType = SHORTINT;
        RfBitVectorScalarType.INT.flippedSignScalarType = INT_UNSIGNED;
        RfBitVectorScalarType.INT_UNSIGNED.flippedSignScalarType = INT;
        RfBitVectorScalarType.LONGINT.flippedSignScalarType = LONGINT_UNSIGNED;
        RfBitVectorScalarType.LONGINT_UNSIGNED.flippedSignScalarType = LONGINT;
        RfBitVectorScalarType.INTEGER.flippedSignScalarType = INTEGER_UNSIGNED;
        RfBitVectorScalarType.INTEGER_UNSIGNED.flippedSignScalarType = INTEGER;
        RfBitVectorScalarType.TIME.flippedSignScalarType = TIME_SIGNED;
        RfBitVectorScalarType.TIME_SIGNED.flippedSignScalarType = TIME;
        RfBitVectorScalarType.BYTE.simpleBitVectorType = RfComputedListType.of(BIT, RfBitVectorScalarType.BYTE.bitSize, RfBitVectorScalarType.BYTE.sign);
        RfBitVectorScalarType.BYTE_UNSIGNED.simpleBitVectorType = RfComputedListType.of(BIT, RfBitVectorScalarType.BYTE_UNSIGNED.bitSize, RfBitVectorScalarType.BYTE_UNSIGNED.sign);
        RfBitVectorScalarType.SHORTINT.simpleBitVectorType = RfComputedListType.of(BIT, RfBitVectorScalarType.SHORTINT.bitSize, RfBitVectorScalarType.SHORTINT.sign);
        RfBitVectorScalarType.SHORTINT_UNSIGNED.simpleBitVectorType = RfComputedListType.of(BIT, RfBitVectorScalarType.SHORTINT_UNSIGNED.bitSize, RfBitVectorScalarType.SHORTINT_UNSIGNED.sign);
        RfBitVectorScalarType.INT.simpleBitVectorType = RfComputedListType.of(BIT, RfBitVectorScalarType.INT.bitSize, RfBitVectorScalarType.INT.sign);
        RfBitVectorScalarType.INT_UNSIGNED.simpleBitVectorType = RfComputedListType.of(BIT, RfBitVectorScalarType.INT_UNSIGNED.bitSize, RfBitVectorScalarType.INT_UNSIGNED.sign);
        RfBitVectorScalarType.LONGINT.simpleBitVectorType = RfComputedListType.of(BIT, RfBitVectorScalarType.LONGINT.bitSize, RfBitVectorScalarType.LONGINT.sign);
        RfBitVectorScalarType.LONGINT_UNSIGNED.simpleBitVectorType = RfComputedListType.of(BIT, RfBitVectorScalarType.LONGINT_UNSIGNED.bitSize, RfBitVectorScalarType.LONGINT_UNSIGNED.sign);
        RfBitVectorScalarType.INTEGER.simpleBitVectorType = RfComputedListType.of(LOGIC, RfBitVectorScalarType.INTEGER.bitSize, RfBitVectorScalarType.INTEGER.sign);
        RfBitVectorScalarType.INTEGER_UNSIGNED.simpleBitVectorType = RfComputedListType.of(LOGIC, RfBitVectorScalarType.INTEGER_UNSIGNED.bitSize, RfBitVectorScalarType.INTEGER_UNSIGNED.sign);
        RfBitVectorScalarType.TIME.simpleBitVectorType = RfComputedListType.of(BIT, RfBitVectorScalarType.TIME.bitSize, RfBitVectorScalarType.TIME.sign);
        RfBitVectorScalarType.TIME_SIGNED.simpleBitVectorType = RfComputedListType.of(BIT, RfBitVectorScalarType.TIME_SIGNED.bitSize, RfBitVectorScalarType.TIME_SIGNED.sign);
    }

    public static boolean isFourState(IRfNamedElement scalar) {
        return scalar instanceof RfBitVectorScalarType && ((RfBitVectorScalarType)scalar).getBitState() == 2;
    }

    public static boolean isSigned(IRfNamedElement scalar) {
        return scalar instanceof RfBitVectorScalarType && ((RfBitVectorScalarType)scalar).getSign() == 1;
    }

    public static boolean isUnsigned(IRfNamedElement scalar) {
        return scalar instanceof RfBitVectorScalarType && ((RfBitVectorScalarType)scalar).getSign() == 2;
    }

    public static int getSign(String name) {
        switch (name) {
            case "bit signed": 
            case "shortint": 
            case "int": 
            case "byte": 
            case "longint": 
            case "time signed": 
            case "integer": 
            case "reg signed": 
            case "logic signed": {
                return 1;
            }
            case "integer unsigned": 
            case "shortint unsigned": 
            case "bit": 
            case "reg": 
            case "time": 
            case "logic": 
            case "byte unsigned": 
            case "int unsigned": 
            case "longint unsigned": {
                return 2;
            }
        }
        return 0;
    }

    public static int getBitSize(String name) {
        switch (name) {
            case "bit signed": 
            case "bit": {
                return BIT.getBitSize();
            }
            case "byte": 
            case "byte unsigned": {
                return BYTE.getBitSize();
            }
            case "shortint unsigned": 
            case "shortint": {
                return SHORTINT.getBitSize();
            }
            case "int": 
            case "int unsigned": {
                return INT.getBitSize();
            }
            case "longint": 
            case "longint unsigned": {
                return LONGINT.getBitSize();
            }
            case "reg": 
            case "logic": 
            case "reg signed": 
            case "logic signed": {
                return LOGIC.getBitSize();
            }
            case "integer unsigned": 
            case "integer": {
                return INTEGER.getBitSize();
            }
            case "time": 
            case "time signed": {
                return TIME.getBitSize();
            }
        }
        return -2;
    }

    public static RfBitVectorScalarType getBitVectorScalar(int bitSize, int sign, int bitState) {
        if (bitSize < 1 | bitSize > 64) {
            return null;
        }
        int code = Integer.highestOneBit(bitSize);
        if ((bitSize & ~code) != 0) {
            return null;
        }
        switch (bitState << 9 | sign << 7 | code) {
            case 513: 
            case 769: {
                return BIT;
            }
            case 641: {
                return BIT_SIGNED;
            }
            case 520: 
            case 648: {
                return BYTE;
            }
            case 776: {
                return BYTE_UNSIGNED;
            }
            case 528: 
            case 656: {
                return SHORTINT;
            }
            case 784: {
                return SHORTINT_UNSIGNED;
            }
            case 544: 
            case 672: {
                return INT;
            }
            case 800: {
                return INT_UNSIGNED;
            }
            case 576: 
            case 704: {
                return LONGINT;
            }
            case 832: {
                return LONGINT_UNSIGNED;
            }
            case 1025: 
            case 1281: {
                return LOGIC;
            }
            case 129: {
                return LOGIC_SIGNED;
            }
            case 1056: 
            case 1184: {
                return INTEGER;
            }
            case 1312: {
                return INTEGER_UNSIGNED;
            }
            case 1088: 
            case 1344: {
                return TIME;
            }
            case 1216: {
                return TIME_SIGNED;
            }
        }
        return null;
    }

    private RfBitVectorScalarType(String name, String predefinedComment, int bitSize, int sign, int bitState, int notDefaultSign) {
        super(name, predefinedComment);
        this.sign = (byte)sign;
        this.notDefaultSign = (byte)notDefaultSign;
        this.bitState = (byte)bitState;
        this.bitSize = (byte)bitSize;
    }

    public boolean isPacked() {
        return true;
    }

    public boolean isBitStream() {
        return true;
    }

    public boolean isPackedBitStream() {
        return true;
    }

    public byte getSign() {
        return this.sign;
    }

    public byte getBitState() {
        return this.bitState;
    }

    public int getBitSize() {
        return this.bitSize;
    }

    public RfComputedListType getSimpleBitVectorType() {
        return this.simpleBitVectorType;
    }

    public RfBitVectorScalarType getScalarWithSign(int sign) {
        return this.notDefaultSign != sign & this.sign != sign ? this.flippedSignScalarType : this;
    }

    public RfBitVectorScalarType getScalarWithDefaultSign() {
        return this.notDefaultSign == 1 ? this.flippedSignScalarType : this;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    public BitVectorContext getBitVectorContext(IHidEvaluator evaluator, IHidEvaluationGuardian guardian, IRfNamedElement origin) {
        return BitVectorContext.of((DVTNumber)((DVTNumber)CONTEXT_CACHE.get(this)), (IRfNamedElement)this, (IRfNamedElement)origin);
    }
}

