/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.predefined;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedEventType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;

public class RfPredefinedFunction
extends RfFunction {
    private static final String RAND_MODE_STRING = "rand_mode";
    private static final long serialVersionUID = 1L;
    protected String predefinedComment;
    private String nameForNoDuplicateList;
    private boolean allowsMoreArguments;
    public static final Set<String> PREDEFINED_BOTH_TASK_AND_FUNCTION = new HashSet<String>(Arrays.asList("$cast", "$system", "rand_mode", "constraint_mode"));
    public static final RfPredefinedFunction ANY_PREDEFINED_FUNCTION = new RfPredefinedFunction("$__dvt_any_predefined_function_dummy", RfProject.getSimpleDataType("void"), null, 0, "Match for any predefined function");

    public RfPredefinedFunction(String name, DataType type, List<ArgInfo> arguments, int kind, boolean isEnumSelfReferential, String predefinedComment, int qualifiers) {
        super(name, false, type, null, kind, 0, null, null);
        this.predefinedComment = predefinedComment;
        if (arguments != null && !arguments.isEmpty()) {
            DataType prevDataType = null;
            for (ArgInfo argInfo : arguments) {
                DataType currDataType = argInfo.getDataType();
                if (currDataType != null) {
                    currDataType.updateImplicit(prevDataType);
                }
                RfPredefinedField newField = new RfPredefinedField(argInfo.getName(), currDataType, 2, 0, argInfo.getInitialValue(), null);
                newField.setOptionalArgument(argInfo.isOptional());
                newField.internalSetTransientAssociatedType(argInfo.getTransientAssociatedType());
                this.addMember(newField);
                prevDataType = currDataType;
            }
        }
        this.internalSetTransientAssociatedType(RfProject.getSimpleType(type));
        if (qualifiers != 0) {
            this.setQualifiers(this.getQualifiers() | qualifiers);
        }
    }

    public RfPredefinedFunction(String name, DataType type, List<ArgInfo> arguments, boolean allowsMoreArguments, int kind, String predefinedComment) {
        this(name, type, arguments, kind, predefinedComment);
        this.allowsMoreArguments = allowsMoreArguments;
    }

    public RfPredefinedFunction(String name, DataType type, List<ArgInfo> arguments, int kind, String predefinedComment) {
        this(name, type, arguments, kind, false, predefinedComment, 0);
    }

    public RfPredefinedFunction(String name, DataType type, List<ArgInfo> arguments, int kind, String predefinedComment, int qualifiers) {
        this(name, type, arguments, kind, false, predefinedComment, qualifiers);
    }

    @Override
    public String getComment() {
        return String.valueOf(this.isAutoDefined() ? "" : "PREDEFINED: ") + this.predefinedComment;
    }

    @Override
    public boolean isPredefined() {
        return true;
    }

    public boolean isPredefinedOverridden() {
        return !this.hasNoDefs(false);
    }

    public boolean allowsMoreArguments() {
        return this.allowsMoreArguments;
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (obj == null || !(obj instanceof RfPredefinedField) && !(obj instanceof RfPredefinedFunction)) {
            return false;
        }
        if (!(obj instanceof RfNamedElement)) {
            return false;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        RfNamedElement otherEnclosingScope = ((RfNamedElement)obj).getEnclosingScope();
        if (enclosingScope instanceof RfPredefinedEventType && enclosingScope.checkEquals(otherEnclosingScope)) {
            return "triggered".equals(this.getName()) && "triggered".equals(((RfNamedElement)obj).getName());
        }
        if (!(obj instanceof RfPredefinedFunction)) {
            return false;
        }
        if (this.getName() != null && this.getName().equals(((RfPredefinedFunction)obj).getName()) && RAND_MODE_STRING.equals(this.getName())) {
            return true;
        }
        if (this.getClosestTypeContainer() != null && this.getClosestTypeContainer().equals(((RfFunction)obj).getClosestTypeContainer())) {
            return super.equals(obj);
        }
        return false;
    }

    @Override
    public boolean isDirtyElement() {
        return false;
    }

    @Override
    protected void removeDirtyElements(Iterator<? extends RfNamedElement> it, ParserPath parserPath, RfProject project, Map<ParserPath, Collection<RfNamedElement>> createdClassFragments) {
    }

    public void setNameForNoDuplicateList(String name) {
        this.nameForNoDuplicateList = name;
    }

    @Override
    public String getNameForNoDuplicateList() {
        if (this.nameForNoDuplicateList == null) {
            return this.getName();
        }
        return this.nameForNoDuplicateList;
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (!result) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this.getNameForNoDuplicateList() == null) {
            return ((RfPredefinedFunction)obj).getNameForNoDuplicateList() == null;
        }
        return this.getNameForNoDuplicateList().equals(((RfPredefinedFunction)obj).getNameForNoDuplicateList());
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + super.hashCode();
        String nameForNoDuplicateList = this.getNameForNoDuplicateList();
        result = 31 * result + (nameForNoDuplicateList == null ? 0 : nameForNoDuplicateList.hashCode());
        return result;
    }

    @Override
    public IRfNamedElement getAssociatedType(RfTypesResolver typesResolver) {
        IRfNamedElement result = super.getAssociatedType(typesResolver);
        if (result instanceof RfClass && this.getEnclosingScope() instanceof RfListType && RfListType.ARRAY_REDUCTION_METHODS.contains(this.getName())) {
            return RfProject.PREDEFINED_GLOBAL.getLocalMember("integer", null, true, true);
        }
        return result;
    }

    public IRfNamedElement xGetFastAssocType() {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (!(enclosingScope instanceof RfListType)) {
            return null;
        }
        if ("exists".equals(this.getName()) && enclosingScope instanceof RfListType) {
            return RfBitVectorScalarType.INT;
        }
        if ("size".equals(this.getName())) {
            return RfBitVectorScalarType.INT;
        }
        if ("prev".equals(this.getName())) {
            return RfBitVectorScalarType.INT;
        }
        if ("next".equals(this.getName())) {
            return RfBitVectorScalarType.INT;
        }
        if ("last".equals(this.getName())) {
            return RfBitVectorScalarType.INT;
        }
        if ("first".equals(this.getName())) {
            return RfBitVectorScalarType.INT;
        }
        if ("num".equals(this.getName())) {
            return RfBitVectorScalarType.INT;
        }
        if ("empty".equals(this.getName())) {
            return RfBitVectorScalarType.BIT;
        }
        return null;
    }
}

