/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.predefined;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.DummyField;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPredefinedGate;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public class RfPredefinedGate
extends RfPrimitive
implements IRfPredefinedGate {
    private static final long serialVersionUID = 1L;
    private final List<PortPattern> portPatterns;
    public static final Map<String, RfPredefinedGate> PREDEFINED_GATES = new HashMap<String, RfPredefinedGate>();

    static {
        PREDEFINED_GATES.put("cmos", new RfPredefinedGate("cmos", Arrays.asList(PortPattern.ONE_OUTPUT, PortPattern.ONE_INPUT, PortPattern.ONE_CONTROL_INPUT, PortPattern.ONE_CONTROL_INPUT)));
        PREDEFINED_GATES.put("rcmos", new RfPredefinedGate("rcmos", Arrays.asList(PortPattern.ONE_OUTPUT, PortPattern.ONE_INPUT, PortPattern.ONE_CONTROL_INPUT, PortPattern.ONE_CONTROL_INPUT)));
        PREDEFINED_GATES.put("bufif0", new RfPredefinedGate("bufif0", Arrays.asList(PortPattern.ONE_OUTPUT, PortPattern.ONE_INPUT, PortPattern.ONE_ENABLE_INPUT)));
        PREDEFINED_GATES.put("bufif1", new RfPredefinedGate("bufif1", Arrays.asList(PortPattern.ONE_OUTPUT, PortPattern.ONE_INPUT, PortPattern.ONE_ENABLE_INPUT)));
        PREDEFINED_GATES.put("notif0", new RfPredefinedGate("notif0", Arrays.asList(PortPattern.ONE_OUTPUT, PortPattern.ONE_INPUT, PortPattern.ONE_ENABLE_INPUT)));
        PREDEFINED_GATES.put("notif1", new RfPredefinedGate("notif1", Arrays.asList(PortPattern.ONE_OUTPUT, PortPattern.ONE_INPUT, PortPattern.ONE_ENABLE_INPUT)));
        PREDEFINED_GATES.put("nmos", new RfPredefinedGate("nmos", Arrays.asList(PortPattern.ONE_OUTPUT, PortPattern.ONE_INPUT, PortPattern.ONE_ENABLE_INPUT)));
        PREDEFINED_GATES.put("pmos", new RfPredefinedGate("pmos", Arrays.asList(PortPattern.ONE_OUTPUT, PortPattern.ONE_INPUT, PortPattern.ONE_ENABLE_INPUT)));
        PREDEFINED_GATES.put("rnmos", new RfPredefinedGate("rnmos", Arrays.asList(PortPattern.ONE_OUTPUT, PortPattern.ONE_INPUT, PortPattern.ONE_ENABLE_INPUT)));
        PREDEFINED_GATES.put("rpmos", new RfPredefinedGate("rpmos", Arrays.asList(PortPattern.ONE_OUTPUT, PortPattern.ONE_INPUT, PortPattern.ONE_ENABLE_INPUT)));
        PREDEFINED_GATES.put("and", new RfPredefinedGate("and", Arrays.asList(PortPattern.ONE_OUTPUT, PortPattern.N_INPUTS)));
        PREDEFINED_GATES.put("nand", new RfPredefinedGate("nand", Arrays.asList(PortPattern.ONE_OUTPUT, PortPattern.N_INPUTS)));
        PREDEFINED_GATES.put("or", new RfPredefinedGate("or", Arrays.asList(PortPattern.ONE_OUTPUT, PortPattern.N_INPUTS)));
        PREDEFINED_GATES.put("nor", new RfPredefinedGate("nor", Arrays.asList(PortPattern.ONE_OUTPUT, PortPattern.N_INPUTS)));
        PREDEFINED_GATES.put("xor", new RfPredefinedGate("xor", Arrays.asList(PortPattern.ONE_OUTPUT, PortPattern.N_INPUTS)));
        PREDEFINED_GATES.put("xnor", new RfPredefinedGate("xnor", Arrays.asList(PortPattern.ONE_OUTPUT, PortPattern.N_INPUTS)));
        PREDEFINED_GATES.put("buf", new RfPredefinedGate("buf", Arrays.asList(PortPattern.N_OUTPUTS, PortPattern.ONE_INPUT)));
        PREDEFINED_GATES.put("not", new RfPredefinedGate("not", Arrays.asList(PortPattern.N_OUTPUTS, PortPattern.ONE_INPUT)));
        PREDEFINED_GATES.put("tranif0", new RfPredefinedGate("tranif0", Arrays.asList(PortPattern.ONE_INOUT, PortPattern.ONE_INOUT, PortPattern.ONE_ENABLE_INPUT)));
        PREDEFINED_GATES.put("tranif1", new RfPredefinedGate("tranif1", Arrays.asList(PortPattern.ONE_INOUT, PortPattern.ONE_INOUT, PortPattern.ONE_ENABLE_INPUT)));
        PREDEFINED_GATES.put("rtranif1", new RfPredefinedGate("rtranif1", Arrays.asList(PortPattern.ONE_INOUT, PortPattern.ONE_INOUT, PortPattern.ONE_ENABLE_INPUT)));
        PREDEFINED_GATES.put("rtranif0", new RfPredefinedGate("rtranif0", Arrays.asList(PortPattern.ONE_INOUT, PortPattern.ONE_INOUT, PortPattern.ONE_ENABLE_INPUT)));
        PREDEFINED_GATES.put("tran", new RfPredefinedGate("tran", Arrays.asList(PortPattern.ONE_INOUT, PortPattern.ONE_INOUT)));
        PREDEFINED_GATES.put("rtran", new RfPredefinedGate("rtran", Arrays.asList(PortPattern.ONE_INOUT, PortPattern.ONE_INOUT)));
        PREDEFINED_GATES.put("pullup", new RfPredefinedGate("pullup", Arrays.asList(PortPattern.N_OUTPUTS)));
        PREDEFINED_GATES.put("pulldown", new RfPredefinedGate("pulldown", Arrays.asList(PortPattern.N_OUTPUTS)));
    }

    public RfPredefinedGate(String name, List<PortPattern> portPatterns) {
        super(name, false, "wire", null);
        this.portPatterns = portPatterns;
    }

    @Override
    public boolean isPredefined() {
        return true;
    }

    @Override
    public boolean isStaticLikeAccessible() {
        return true;
    }

    @Override
    public boolean isDirtyElement() {
        return false;
    }

    public List<PortPattern> getPortPatterns() {
        return this.portPatterns;
    }

    public Set<DummyPort> getDummyPorts(IRfInstanceElement instance, List<IHidOperator> portConnections) {
        if (instance == null || portConnections == null || portConnections.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayDeque<PortPattern> patterns = new ArrayDeque<PortPattern>(this.portPatterns);
        PortPattern currPattern = (PortPattern)((Object)patterns.pollFirst());
        LinkedHashSet<DummyPort> ports = new LinkedHashSet<DummyPort>();
        int pcs = portConnections.size();
        int counter = 1;
        int i = 1;
        while (i <= portConnections.size()) {
            if (currPattern == null) {
                return ports;
            }
            DummyPort.DummyPortDirection currPortDirection = currPattern.getDirection();
            String currPortName = String.valueOf(currPattern.getNamePrefix()) + counter++;
            ports.add(new DummyPort(currPortName, currPortName, currPortDirection, (IRfNamedElement)instance, this.getImageFromDummyPortDirection(currPortDirection)));
            PortPattern prevPattern = currPattern;
            switch (currPattern) {
                case ONE_INPUT: 
                case ONE_ENABLE_INPUT: 
                case ONE_CONTROL_INPUT: 
                case ONE_OUTPUT: 
                case ONE_INOUT: {
                    currPattern = (PortPattern)((Object)patterns.pollFirst());
                    break;
                }
                case N_OUTPUTS: 
                case N_INOUTS: {
                    PortPattern peekFirst;
                    if (i != pcs - 1 || (peekFirst = (PortPattern)((Object)patterns.peekFirst())) != PortPattern.ONE_INPUT && peekFirst != PortPattern.ONE_ENABLE_INPUT && peekFirst != PortPattern.ONE_CONTROL_INPUT) break;
                    currPattern = (PortPattern)((Object)patterns.pollFirst());
                    break;
                }
                case N_INPUTS: {
                    break;
                }
            }
            if (prevPattern != currPattern) {
                counter = 1;
            }
            ++i;
        }
        return ports;
    }

    private ImageDescriptor getImageFromDummyPortDirection(DummyPort.DummyPortDirection direction) {
        if (direction == DummyPort.DummyPortDirection.INPUT) {
            return DVTImages.OUTLINE_INPUT_PORT;
        }
        if (direction == DummyPort.DummyPortDirection.OUTPUT) {
            return DVTImages.OUTLINE_OUTPUT_PORT;
        }
        return DVTImages.OUTLINE_INOUT_PORT;
    }

    @Override
    protected void removeDirtyElements(Iterator<? extends RfNamedElement> it, ParserPath parserPath, RfProject project, Map<ParserPath, Collection<RfNamedElement>> createdClassFragments) {
    }

    public Set<DummyField> getDummyGenerics(IRfInstanceElement instance, List<IHidOperator> genericConnections) {
        return null;
    }

    public List<IHidOperator> xGetPredefGateAssignOperators(HidOperator driveStrength, HidOperator delayControl, List<IHidOperator> portConnections, HidOperatorOccurrence occurrence, IHidEvaluationGuardian guardian) {
        ArrayList<IHidOperator> result = new ArrayList<IHidOperator>();
        String name = this.getName();
        IHidObject strength0 = driveStrength == null ? null : driveStrength.getLHValue();
        IHidObject strength1 = driveStrength == null ? null : driveStrength.getFirstRHValue();
        block27 : switch (name) {
            case "pullup": 
            case "pulldown": {
                for (IHidOperator operator : portConnections) {
                    IHid portHid = (IHid)operator.getLHValue();
                    RfHid output = RfHid.create(XUtils.getName((IHid)portHid), null, portHid.getElement(), (HidOccurrence)occurrence, null);
                    RfHidOperator assignOperator = RfHidOperator.create(498, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", occurrence, null);
                    assignOperator.addLHValue((IHidObject)output);
                    boolean isPullup = "pullup".equals(name);
                    RfHidImplicit pullValue = RfHidImplicit.makeImplicit(isPullup ? "1'b1" : "1'b0", IHidImplicitConstants.ImplicitType.QUA_NUMBER.id);
                    assignOperator.addRHValue((IHidObject)pullValue);
                    HidOperator driveStrength2 = new HidOperator(-1, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "", occurrence.getOffset(), occurrence.getLine(), -1, -1, HidQualifierCache.IS_WITH_DRIVE_STRENGTH_QUALIFIER){
                        private static final long serialVersionUID = 1L;

                        public LanguageKind getLanguageKind() {
                            return LanguageKind.VLOG;
                        }
                    };
                    driveStrength2.setLHValue((IHidObject)(strength0 != null ? strength0 : RfHidImplicit.makeImplicit(isPullup ? "highz0" : "pull0", IHidImplicitConstants.ImplicitType.ID.id)));
                    driveStrength2.setRHValues((ListContainer)(strength1 != null ? strength1 : RfHidImplicit.makeImplicit(isPullup ? "pull1" : "highz1", IHidImplicitConstants.ImplicitType.ID.id)));
                    assignOperator = HidEvalCenter.INSTANCE.createDriveStrengthContinuousAssign(driveStrength2, (HidOperator)assignOperator, occurrence);
                    result.add(assignOperator);
                }
                break;
            }
            case "buf": 
            case "not": {
                for (IHidOperator operator1 : portConnections) {
                    IHid portHid1 = (IHid)operator1.getLHValue();
                    boolean isInputPort = XUtils.isInputPort((IHid)portHid1, (IHidObject)operator1.getFirstRHValue());
                    if (!isInputPort) continue;
                    for (IHidOperator operator2 : portConnections) {
                        IHid portHid2 = (IHid)operator2.getLHValue();
                        boolean isOutputPort = XUtils.isOutputPort((IHid)portHid2, (IHidObject)operator2.getFirstRHValue());
                        if (!isOutputPort) continue;
                        Object input = RfHid.create(XUtils.getName((IHid)portHid1), null, portHid1.getElement(), (HidOccurrence)occurrence, null);
                        RfHid output = RfHid.create(XUtils.getName((IHid)portHid2), null, portHid2.getElement(), (HidOccurrence)occurrence, null);
                        RfHidOperator tmpOperator = RfHidOperator.create(478, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "~", occurrence, null);
                        tmpOperator.addLHValue((IHidObject)input);
                        input = tmpOperator;
                        if ("buf".equals(name)) {
                            tmpOperator = RfHidOperator.create(478, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "~", occurrence, null);
                            tmpOperator.addLHValue((IHidObject)input);
                            input = tmpOperator;
                        }
                        RfHidOperator bufOperator = RfHidOperator.create(498, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", occurrence, null);
                        bufOperator.addLHValue((IHidObject)output);
                        bufOperator.addRHValue((IHidObject)input);
                        result.add(bufOperator);
                    }
                    break block27;
                }
                break;
            }
            case "and": 
            case "nand": {
                RfHid output = null;
                Object andOperator = null;
                for (IHidOperator operator : portConnections) {
                    IHid portHid = (IHid)operator.getLHValue();
                    boolean isInputPort = XUtils.isInputPort((IHid)portHid, (IHidObject)operator.getFirstRHValue());
                    if (!isInputPort) {
                        output = RfHid.create(XUtils.getName((IHid)portHid), null, portHid.getElement(), (HidOccurrence)occurrence, null);
                        continue;
                    }
                    RfHid input = RfHid.create(XUtils.getName((IHid)portHid), null, portHid.getElement(), (HidOccurrence)occurrence, null);
                    if (andOperator == null) {
                        andOperator = input;
                        continue;
                    }
                    RfHidOperator tmpOperator = RfHidOperator.create(471, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "&&", occurrence, null);
                    tmpOperator.addLHValue((IHidObject)andOperator);
                    tmpOperator.addRHValue((IHidObject)input);
                    andOperator = tmpOperator;
                }
                if ("nand".equals(name)) {
                    RfHidOperator tmpOperator = RfHidOperator.create(478, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "~", occurrence, null);
                    tmpOperator.addLHValue((IHidObject)andOperator);
                    andOperator = tmpOperator;
                }
                RfHidOperator assignOperator = RfHidOperator.create(498, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", occurrence, null);
                assignOperator.addLHValue((IHidObject)output);
                assignOperator.addRHValue((IHidObject)andOperator);
                result.add(assignOperator);
                break;
            }
            case "or": 
            case "nor": {
                RfHid output = null;
                Object orOperator = null;
                for (IHidOperator operator : portConnections) {
                    IHid portHid = (IHid)operator.getLHValue();
                    boolean isInputPort = XUtils.isInputPort((IHid)portHid, (IHidObject)operator.getFirstRHValue());
                    if (!isInputPort) {
                        output = RfHid.create(XUtils.getName((IHid)portHid), null, portHid.getElement(), (HidOccurrence)occurrence, null);
                        continue;
                    }
                    RfHid input = RfHid.create(XUtils.getName((IHid)portHid), null, portHid.getElement(), (HidOccurrence)occurrence, null);
                    if (orOperator == null) {
                        orOperator = input;
                        continue;
                    }
                    RfHidOperator tmpOperator = RfHidOperator.create(473, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "||", occurrence, null);
                    tmpOperator.addLHValue((IHidObject)orOperator);
                    tmpOperator.addRHValue((IHidObject)input);
                    orOperator = tmpOperator;
                }
                if ("nor".equals(name)) {
                    RfHidOperator tmpOperator = RfHidOperator.create(478, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "~", occurrence, null);
                    tmpOperator.addLHValue((IHidObject)orOperator);
                    orOperator = tmpOperator;
                }
                RfHidOperator assignOperator = RfHidOperator.create(498, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", occurrence, null);
                assignOperator.addLHValue((IHidObject)output);
                assignOperator.addRHValue((IHidObject)orOperator);
                result.add(assignOperator);
                break;
            }
            case "xor": 
            case "xnor": {
                IHid output = null;
                RfHidOperator xorOperator = null;
                for (IHidOperator operator : portConnections) {
                    IHid portHid = (IHid)operator.getLHValue();
                    boolean isInputPort = XUtils.isInputPort((IHid)portHid, (IHidObject)operator.getFirstRHValue());
                    if (!isInputPort) {
                        output = portHid;
                        continue;
                    }
                    IHid input = portHid;
                    if (xorOperator == null) {
                        xorOperator = input;
                        continue;
                    }
                    RfHidOperator tmpOperator = RfHidOperator.create(475, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "^", occurrence, null);
                    tmpOperator.addLHValue((IHidObject)xorOperator);
                    tmpOperator.addRHValue((IHidObject)input);
                    xorOperator = tmpOperator;
                }
                if ("xnor".equals(name)) {
                    RfHidOperator tmpOperator = RfHidOperator.create(478, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "~", occurrence, null);
                    tmpOperator.addLHValue((IHidObject)xorOperator);
                    xorOperator = tmpOperator;
                }
                RfHidOperator assignOperator = RfHidOperator.create(498, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", occurrence, null);
                assignOperator.addLHValue((IHidObject)output);
                assignOperator.addRHValue((IHidObject)xorOperator);
                result.add(assignOperator);
                break;
            }
            case "tran": 
            case "rtran": {
                IHid portHid1 = (IHid)portConnections.get(0).getLHValue();
                IHid portHid2 = (IHid)portConnections.get(1).getLHValue();
                RfHid inout1 = RfHid.create(XUtils.getName((IHid)portHid1), null, portHid1.getElement(), (HidOccurrence)occurrence, null);
                RfHid inout2 = RfHid.create(XUtils.getName((IHid)portHid2), null, portHid2.getElement(), (HidOccurrence)occurrence, null);
                RfHidOperator assign12 = RfHidOperator.create(498, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", occurrence, null);
                assign12.addLHValue((IHidObject)inout1);
                assign12.addRHValue((IHidObject)inout2);
                RfHidOperator assign21 = RfHidOperator.create(498, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", occurrence, null);
                assign21.addLHValue((IHidObject)inout2);
                assign21.addRHValue((IHidObject)inout1);
                result.add(assign12);
                result.add(assign21);
                break;
            }
            case "bufif0": 
            case "bufif1": 
            case "notif0": 
            case "notif1": 
            case "nmos": 
            case "pmos": 
            case "rnmos": 
            case "rpmos": {
                IHid portHid = (IHid)portConnections.get(0).getLHValue();
                RfHid output = RfHid.create(XUtils.getName((IHid)portHid), null, portHid.getElement(), (HidOccurrence)occurrence, null);
                portHid = (IHid)portConnections.get(1).getLHValue();
                Object input = RfHid.create(XUtils.getName((IHid)portHid), null, portHid.getElement(), (HidOccurrence)occurrence, null);
                portHid = (IHid)portConnections.get(2).getLHValue();
                Object control = RfHid.create(XUtils.getName((IHid)portHid), null, portHid.getElement(), (HidOccurrence)occurrence, null);
                RfHidOperator assignOperator = RfHidOperator.create(498, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", occurrence, null);
                assignOperator.addLHValue((IHidObject)output);
                RfHidOperator controlOperator = RfHidOperator.create(481, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "||", occurrence, null);
                RfHidOperator controlZX = RfHidOperator.create(481, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "||", occurrence, null);
                controlZX.addLHValue((IHidObject)this.equalsImplicitOperator(occurrence, (IHidObject)control, "1'bz"));
                controlZX.addRHValue((IHidObject)this.equalsImplicitOperator(occurrence, (IHidObject)control, "1'bx"));
                controlOperator.addLHValue((IHidObject)controlZX);
                RfHidOperator ternaryOperator = RfHidOperator.create(499, IHidOperatorConstants.OperatorKind.TERNARY_OPERATOR, "?", occurrence, null);
                if ("pmos".equals(name) || "rpmos".equals(name) || "bufif0".equals(name) || "notif0".equals(name)) {
                    RfHidOperator notControl = RfHidOperator.create(478, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "~", occurrence, null);
                    notControl.addLHValue((IHidObject)control);
                    control = notControl;
                }
                controlOperator.addRHValue((IHidObject)control);
                ternaryOperator.addLHValue((IHidObject)controlOperator);
                assignOperator.addRHValue((IHidObject)ternaryOperator);
                if ("bufif0".equals(name) || "bufif1".equals(name) || "notif0".equals(name) || "notif1".equals(name)) {
                    RfHidOperator tmpOperator = RfHidOperator.create(478, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "~", occurrence, null);
                    tmpOperator.addLHValue((IHidObject)input);
                    input = tmpOperator;
                    if ("bufif0".equals(name) || "bufif1".equals(name)) {
                        tmpOperator = RfHidOperator.create(478, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "~", occurrence, null);
                        tmpOperator.addLHValue((IHidObject)input);
                        input = tmpOperator;
                    }
                }
                ternaryOperator.addRHValue((IHidObject)RfHidImplicit.makeImplicit("1'bz", IHidImplicitConstants.ImplicitType.QUA_NUMBER.id));
                ternaryOperator.addRHValue((IHidObject)input);
                result.add(assignOperator);
                break;
            }
            case "cmos": {
                IHid portHid = (IHid)portConnections.get(0).getLHValue();
                RfHid output = RfHid.create(XUtils.getName((IHid)portHid), null, portHid.getElement(), (HidOccurrence)occurrence, null);
                portHid = (IHid)portConnections.get(1).getLHValue();
                RfHid input = RfHid.create(XUtils.getName((IHid)portHid), null, portHid.getElement(), (HidOccurrence)occurrence, null);
                portHid = (IHid)portConnections.get(2).getLHValue();
                RfHid nControl = RfHid.create(XUtils.getName((IHid)portHid), null, portHid.getElement(), (HidOccurrence)occurrence, null);
                portHid = (IHid)portConnections.get(3).getLHValue();
                RfHid pControl = RfHid.create(XUtils.getName((IHid)portHid), null, portHid.getElement(), (HidOccurrence)occurrence, null);
                RfHidOperator assignOperator1 = RfHidOperator.create(498, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", occurrence, null);
                assignOperator1.addLHValue((IHidObject)output);
                assignOperator1.addRHValue((IHidObject)input);
                RfHidOperator assignOperator2 = RfHidOperator.create(498, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", occurrence, null);
                assignOperator2.addLHValue((IHidObject)output);
                assignOperator2.addRHValue((IHidObject)RfHidImplicit.makeImplicit("1'bz", IHidImplicitConstants.ImplicitType.QUA_NUMBER.id));
                RfHidOperator nmos = RfHidOperator.create(499, IHidOperatorConstants.OperatorKind.TERNARY_OPERATOR, "?", occurrence, null);
                nmos.addLHValue((IHidObject)nControl);
                nmos.addRHValue((IHidObject)assignOperator2);
                nmos.addRHValue((IHidObject)assignOperator1);
                RfHidOperator pmos = RfHidOperator.create(499, IHidOperatorConstants.OperatorKind.TERNARY_OPERATOR, "?", occurrence, null);
                RfHidOperator pMosControl = RfHidOperator.create(478, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "~", occurrence, null);
                pMosControl.addLHValue((IHidObject)pControl);
                pmos.addLHValue((IHidObject)pMosControl);
                pmos.addRHValue((IHidObject)assignOperator2);
                pmos.addRHValue((IHidObject)assignOperator1);
                result.add(nmos);
                result.add(pmos);
                break;
            }
            case "tranif0": 
            case "tranif1": 
            case "rtranif0": 
            case "rtranif1": {
                IHid portHid = (IHid)portConnections.get(0).getLHValue();
                RfHid inout1 = RfHid.create(XUtils.getName((IHid)portHid), null, portHid.getElement(), (HidOccurrence)occurrence, null);
                portHid = (IHid)portConnections.get(1).getLHValue();
                RfHid inout2 = RfHid.create(XUtils.getName((IHid)portHid), null, portHid.getElement(), (HidOccurrence)occurrence, null);
                portHid = (IHid)portConnections.get(2).getLHValue();
                RfHid controlHid = RfHid.create(XUtils.getName((IHid)portHid), null, portHid.getElement(), (HidOccurrence)occurrence, null);
                RfHidOperator condition = this.equalsImplicitOperator(occurrence, (IHidObject)controlHid, "tranif0".equals(name) || "rtranif0".equals(name) ? "1'b0" : "1'b1");
                RfHidOperator inout2AssignRHS = RfHidOperator.create(499, IHidOperatorConstants.OperatorKind.TERNARY_OPERATOR, "?", occurrence, null);
                inout2AssignRHS.addLHValue((IHidObject)condition);
                inout2AssignRHS.addRHValue((IHidObject)RfHidImplicit.makeImplicit("1'bz", IHidImplicitConstants.ImplicitType.QUA_NUMBER.id));
                inout2AssignRHS.addRHValue((IHidObject)inout1);
                RfHidOperator inout2Assign = RfHidOperator.create(498, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", occurrence, null);
                inout2Assign.addLHValue((IHidObject)inout2);
                inout2Assign.addRHValue((IHidObject)inout2AssignRHS);
                result.add(inout2Assign);
                RfHidOperator inout1AssignRHS = RfHidOperator.create(499, IHidOperatorConstants.OperatorKind.TERNARY_OPERATOR, "?", occurrence, null);
                inout1AssignRHS.addLHValue((IHidObject)condition);
                inout1AssignRHS.addRHValue((IHidObject)RfHidImplicit.makeImplicit("1'bz", IHidImplicitConstants.ImplicitType.QUA_NUMBER.id));
                inout1AssignRHS.addRHValue((IHidObject)inout2);
                RfHidOperator inout1Assign = RfHidOperator.create(498, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", occurrence, null);
                inout1Assign.addLHValue((IHidObject)inout1);
                inout1Assign.addRHValue((IHidObject)inout1AssignRHS);
                result.add(inout1Assign);
                break;
            }
            default: {
                guardian.logError("Predefined gate '" + name + "' support is not implemented!");
            }
        }
        return result;
    }

    protected RfHidOperator equalsImplicitOperator(HidOperatorOccurrence occurrence, IHidObject output, String implicitValue) {
        RfHidOperator condition = RfHidOperator.create(484, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "===", occurrence, null);
        condition.addLHValue(output);
        condition.addRHValue((IHidObject)RfHidImplicit.makeImplicit(implicitValue, IHidImplicitConstants.ImplicitType.QUA_NUMBER.id));
        return condition;
    }

    public static enum PortPattern {
        ONE_INPUT(DummyPort.DummyPortDirection.INPUT, "in"),
        ONE_ENABLE_INPUT(DummyPort.DummyPortDirection.INPUT, "en"),
        ONE_CONTROL_INPUT(DummyPort.DummyPortDirection.INPUT, "control"),
        ONE_OUTPUT(DummyPort.DummyPortDirection.OUTPUT, "out"),
        ONE_INOUT(DummyPort.DummyPortDirection.INOUT, "inout"),
        N_OUTPUTS(DummyPort.DummyPortDirection.OUTPUT, "out"),
        N_INPUTS(DummyPort.DummyPortDirection.INPUT, "in"),
        N_INOUTS(DummyPort.DummyPortDirection.INOUT, "inout");

        private DummyPort.DummyPortDirection direction;
        private String namePrefix;

        private PortPattern(DummyPort.DummyPortDirection direction, String namePrefix) {
            this.direction = direction;
            this.namePrefix = namePrefix;
        }

        public DummyPort.DummyPortDirection getDirection() {
            return this.direction;
        }

        public String getNamePrefix() {
            return this.namePrefix;
        }
    }
}

