/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.predefined;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfNonStandardFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedScalarType;

public class RfStringType
extends RfPredefinedScalarType
implements IRfListType {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "string";
    public static final RfStringType INSTANCE = new RfStringType();

    private RfStringType() {
        super(NAME, "String data type");
        this.addMember(new RfPredefinedFunction("len", RfProject.getSimpleDataType("int"), null, 0, "returns the length of the string"));
        List<ArgInfo> args = new ArrayList<ArgInfo>(2);
        args.add(new ArgInfo("i", RfProject.getSimpleDataType("int"), null));
        args.add(new ArgInfo("c", RfProject.getSimpleDataType("byte"), null));
        this.addMember(new RfPredefinedFunction("putc", RfProject.getSimpleDataType("void"), args, 0, "str.putc(i, c) replaces the ith character in str with the given integral value"));
        args = OptimizedUtils.listAdd(null, (Object)new ArgInfo("i", RfProject.getSimpleDataType("int"), null));
        this.addMember(new RfPredefinedFunction("getc", RfProject.getSimpleDataType("byte"), args, 0, "str.getc(i) returns the ASCII code of the ith character in str"));
        this.addMember(new RfPredefinedFunction("toupper", RfProject.getSimpleDataType(NAME), null, 0, "str.toupper() returns a string with characters in str converted to uppercase"));
        this.addMember(new RfPredefinedFunction("tolower", RfProject.getSimpleDataType(NAME), null, 0, "str.tolower() returns a string with characters in str converted to lowercase"));
        args = OptimizedUtils.listAdd(null, (Object)new ArgInfo("s", RfProject.getSimpleDataType(NAME), null));
        this.addMember(new RfPredefinedFunction("compare", RfProject.getSimpleDataType("int"), args, 0, "str.compare(s) compares str and s as in the ANSI C strcmp function with regard to lexical ordering and return value"));
        this.addMember(new RfPredefinedFunction("icompare", RfProject.getSimpleDataType("int"), args, 0, "str.compare(s) compares str and s as in the ANSI C strcmp function with regard to lexical ordering and return value, but the comparison is case insensitive"));
        args = new ArrayList(2);
        args.add(new ArgInfo("i", RfProject.getSimpleDataType("int"), null));
        args.add(new ArgInfo("j", RfProject.getSimpleDataType("int"), null));
        this.addMember(new RfPredefinedFunction("substr", RfProject.getSimpleDataType(NAME), args, 0, "str.substr(i, j) returns a new string that is a substring formed by characters in position i through j of str"));
        this.addMember(new RfPredefinedFunction("atoi", RfProject.getSimpleDataType("integer"), null, 0, "str.atoi() returns the integer corresponding to the ASCII decimal representation in str"));
        this.addMember(new RfPredefinedFunction("atohex", RfProject.getSimpleDataType("integer"), null, 0, "interprets the string as hexadecimal"));
        this.addMember(new RfPredefinedFunction("atooct", RfProject.getSimpleDataType("integer"), null, 0, "interprets the string as octal"));
        this.addMember(new RfPredefinedFunction("atobin", RfProject.getSimpleDataType("integer"), null, 0, "interprets the string as binary"));
        this.addMember(new RfPredefinedFunction("atoreal", RfProject.getSimpleDataType("real"), null, 0, "str.atoreal() returns the real number corresponding to the ASCII decimal representation in str"));
        args = OptimizedUtils.listAdd(null, (Object)new ArgInfo("i", RfProject.getSimpleDataType("integer"), null));
        this.addMember(new RfPredefinedFunction("itoa", RfProject.getSimpleDataType("void"), args, 0, "str.itoa(i) stores the ASCII decimal representation of i into str (inverse of atoi)"));
        this.addMember(new RfPredefinedFunction("hextoa", RfProject.getSimpleDataType("void"), args, 0, "str.hextoa(i) stores the ASCII hexadecimal representation of i into str (inverse of atohex)"));
        this.addMember(new RfPredefinedFunction("octtoa", RfProject.getSimpleDataType("void"), args, 0, "str.octtoa(i) stores the ASCII octal representation of i into str (inverse of atooct)"));
        this.addMember(new RfPredefinedFunction("bintoa", RfProject.getSimpleDataType("void"), args, 0, "str.bintoa(i) stores the ASCII binary representation of i into str (inverse of atobin)"));
        args = OptimizedUtils.listAdd(null, (Object)new ArgInfo("r", RfProject.getSimpleDataType("real"), null));
        this.addMember(new RfPredefinedFunction("realtoa", RfProject.getSimpleDataType("void"), args, 0, "str.realtoa(r) stores the ASCII real representation of r into str (inverse of atoreal)"));
        args = OptimizedUtils.listAdd(null, (Object)new ArgInfo("text", RfProject.getSimpleDataType(NAME), null));
        this.addMember(new RfNonStandardFunction("search", RfProject.getSimpleDataType("logic"), args, 0, "str.search(text) returns 0/1 if the text is not-found/found into str"));
        DataType stringDataType = RfProject.getSimpleDataType(NAME);
        args = OptimizedUtils.listAdd(null, (Object)new ArgInfo("pattern", stringDataType, null));
        this.addMember(new RfNonStandardFunction("match", RfProject.getSimpleDataType("integer"), args, 0, "The match() method processes a regular expression pattern match. It returns 1 if the pattern is found else, it returns 0 if the pattern is not found."));
        this.addMember(new RfNonStandardFunction("prematch", RfProject.getSimpleDataType(NAME), null, 0, "The prematch() method returns the string that is located just before the string found by the last match() function call."));
        this.addMember(new RfNonStandardFunction("postmatch", RfProject.getSimpleDataType(NAME), null, 0, "The postmatch() method returns the string that is located just after the string found by the last match() function call."));
        this.addMember(new RfNonStandardFunction("thismatch", RfProject.getSimpleDataType(NAME), null, 0, "The thismatch() method returns the matched string, based on theresult of the last match() function call."));
        args = OptimizedUtils.listAdd(null, (Object)new ArgInfo("index", new DataType("integer"), null, null));
        this.addMember(new RfNonStandardFunction("backref", RfProject.getSimpleDataType(NAME), args, 0, "The backref() method returns the matched patterns, based on thelast match() function call."));
    }

    public boolean isPacked() {
        return false;
    }

    public boolean isBitStream() {
        return true;
    }

    public boolean isPackedBitStream() {
        return false;
    }

    public int getBitSize() {
        return -1;
    }

    public String getAssociatedTypeName() {
        return RfBitVectorScalarType.BYTE.getName();
    }

    public IRfNamedElement getAssociatedBaseType() {
        return RfBitVectorScalarType.BYTE;
    }

    public IRfNamedElement getAssociatedType() {
        return RfBitVectorScalarType.BYTE;
    }

    public BitVectorContext getBitVectorContext(IHidEvaluator evaluator, IHidEvaluationGuardian guardian, IRfNamedElement origin) {
        return BitVectorContext.of((DVTNumber)DataType.STRING_CONTEXT, (IRfNamedElement)this, (IRfNamedElement)origin);
    }
}

