/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.semantic;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.VlogProblemCategories;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.vlogdt.model.problems.Bridge;
import ro.amiq.vlogdt.model.reflection.RfSemanticError;

public abstract class SemanticErrorsManagerCommon {
    public void reparsed(IProject project, List<RfSemanticError> semanticErrors, boolean toConsole) {
        if (!DVTPlugin.getDefault().collect().c(project.getProject(), "F7376")) {
            return;
        }
        if (TestHelper.isTestMode()) {
            Collections.sort(semanticErrors);
        }
        if (semanticErrors != null) {
            for (RfSemanticError error : semanticErrors) {
                DVTProblemManager.getInstance().reportProblem(Bridge.from(project.getProject(), error, null, toConsole));
            }
        }
        this.updateProblemsUI(project);
    }

    public void clean(IProject project) {
        DVTProblemManager.getInstance().removeProblemsWithCategory(project, VlogProblemCategories.SVLOG_SEMANTIC);
        this.cleanProblemsUI(project);
    }

    protected abstract void updateProblemsUI(IProject var1);

    protected abstract void cleanProblemsUI(IProject var1);
}

