/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.semantic.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.model.reflection.semantic.extension.FormatSpecifierInfo;
import ro.amiq.vlogdt.model.reflection.semantic.extension.FormatStringInfo;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;

public class FormatSpecifiersUtils {
    public static final List<String> ALL_FORMAT_STRING_SYSTEM_TASKS = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("$value$plusargs");
            this.add("$display");
            this.add("$displayb");
            this.add("$displayo");
            this.add("$displayh");
            this.add("$write");
            this.add("$writeb");
            this.add("$writeo");
            this.add("$writeh");
            this.add("$swrite");
            this.add("$swriteb");
            this.add("$swriteh");
            this.add("$swriteo");
            this.add("$strobe");
            this.add("$strobeb");
            this.add("$strobeo");
            this.add("$strobeh");
            this.add("$monitor");
            this.add("$monitorb");
            this.add("$monitoro");
            this.add("$monitorh");
            this.add("$sformat");
            this.add("$sformatf");
            this.add("$psprintf");
            this.add("$fdisplay");
            this.add("$fdisplayb");
            this.add("$fdisplayo");
            this.add("$fdisplayh");
            this.add("$fwrite");
            this.add("$fwriteb");
            this.add("$fwriteo");
            this.add("$fwriteh");
            this.add("$fstrobe");
            this.add("$fstrobeb");
            this.add("$fstrobeo");
            this.add("$fstrobeh");
            this.add("$fmonitor");
            this.add("$fmonitorb");
            this.add("$fmonitoro");
            this.add("$fmonitorh");
            this.add("$fscanf");
            this.add("$sscanf");
        }
    };
    public static final List<String> ALL_SYSTEM_TIMING_CHECKS = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("$setup");
            this.add("$hold");
            this.add("$setuphold");
            this.add("$recovery");
            this.add("$removal");
            this.add("$recrem");
            this.add("$skew");
            this.add("$timeskew");
            this.add("$fullskew");
            this.add("$period");
            this.add("$width");
            this.add("$nochange");
        }
    };
    public static final List<String> FORMAT_STRING_SYSTEM_TASKS = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("$sformat");
            this.add("$sformatf");
            this.add("$psprintf");
        }
    };
    public static final Map<String, Integer> FORMAT_STR_INDEX_BY_SYSTEM_TASK = new HashMap<String, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("$sformat", 1);
            this.put("$sformatf", 0);
            this.put("$psprintf", 0);
        }
    };

    public static List<FormatStringInfo> getAllFormatStringInfos(List<? extends IHidObject> arguments, String methodName) {
        int startIndex;
        ArrayList<FormatStringInfo> allFormatStringInfos = new ArrayList<FormatStringInfo>();
        boolean strictCheck = FORMAT_STRING_SYSTEM_TASKS.contains(methodName);
        Integer formatStringEnforcedIndex = FORMAT_STR_INDEX_BY_SYSTEM_TASK.get(methodName);
        if (!(formatStringEnforcedIndex == null || formatStringEnforcedIndex < arguments.size() && FormatSpecifiersUtils.argumentIsString(arguments.get(formatStringEnforcedIndex)))) {
            return Collections.emptyList();
        }
        int i = startIndex = formatStringEnforcedIndex != null ? formatStringEnforcedIndex : 0;
        block0: while (i < arguments.size()) {
            Object[] allFormatSpecifiers;
            String valueString;
            IHidObject candidateArg = arguments.get(i);
            if (FormatSpecifiersUtils.argumentIsString(candidateArg) && (valueString = HidUtils.toNiceString((IHidObject)candidateArg)) != null && (allFormatSpecifiers = FormatSpecifiersUtils.getFormatSpecifiersInFormatString(valueString)) != null && allFormatSpecifiers.length >= 2) {
                List formatSpecifiers = (List)allFormatSpecifiers[0];
                List invalidSpecifiers = (List)allFormatSpecifiers[1];
                if (!formatSpecifiers.isEmpty() || !invalidSpecifiers.isEmpty() || strictCheck) {
                    IHidObject formatHid = candidateArg;
                    FormatStringInfo formatStringInfo = new FormatStringInfo(formatHid);
                    formatStringInfo.setSpecifiers(formatSpecifiers);
                    formatStringInfo.setInvalidSpecifiers(invalidSpecifiers);
                    int requiredSpecValues = formatSpecifiers.size();
                    int remainingValuesArgs = arguments.size() - i - 1;
                    int foundSpecifierValueNum = 0;
                    ArrayList<IHidObject> specifierValues = new ArrayList<IHidObject>();
                    int formatSpecifierStringIndex = i;
                    while (foundSpecifierValueNum < requiredSpecValues && remainingValuesArgs > 0) {
                        IHidObject nextArgValue = arguments.get(formatSpecifierStringIndex + foundSpecifierValueNum + 1);
                        specifierValues.add(nextArgValue);
                        --remainingValuesArgs;
                        ++foundSpecifierValueNum;
                        ++i;
                    }
                    formatStringInfo.setSpecifierValues(specifierValues);
                    allFormatStringInfos.add(formatStringInfo);
                    if (strictCheck && remainingValuesArgs > 0) {
                        formatStringInfo.setCheckSpecifiersExtraValues(true);
                        int j = arguments.size() - 1;
                        while (j >= 0) {
                            if (remainingValuesArgs == 0) break block0;
                            formatStringInfo.addSpecifiersExtraValues(arguments.get(j));
                            --j;
                            --remainingValuesArgs;
                        }
                        break;
                    }
                }
            }
            ++i;
        }
        return allFormatStringInfos;
    }

    private static boolean argumentIsString(IHidObject argValueOp) {
        IHidObject argValueHid = MethodCallUtils.getValue((IHidObject)argValueOp);
        if (!HidUtils.isHidImplicit((IHidObject)argValueHid)) {
            return false;
        }
        RfHidImplicit implicitHid = (RfHidImplicit)argValueHid;
        return implicitHid.getType() == 557;
    }

    /*
     * Unable to fully structure code
     */
    private static Object[] getFormatSpecifiersInFormatString(String argumentValueString) {
        if (argumentValueString == null) {
            return null;
        }
        argumentValueString = argumentValueString.replaceAll("\"", "");
        textArray = argumentValueString.toCharArray();
        formatSpecifiers = new ArrayList<FormatSpecifierInfo>();
        invalidFormatSpecifiers = new ArrayList<FormatSpecifierInfo>();
        formatSpecifiersMatcher = MethodCallUtils.VLOG_FORMAT_SPECIFIER_PATTERN.matcher(argumentValueString);
        while (formatSpecifiersMatcher.find()) {
            formatSpecifierString = formatSpecifiersMatcher.group("FORMATSPECGROUP");
            if (formatSpecifierString == null || formatSpecifierString.isEmpty()) continue;
            formatSpecifier = formatSpecifierString.substring(formatSpecifierString.length() - 1);
            endOffset = formatSpecifiersMatcher.end("FORMATSPECGROUP");
            startOffset = endOffset - 1;
            if (startOffset <= textArray.length) ** GOTO lbl18
            continue;
            while (startOffset >= textArray.length || textArray[startOffset] != '%') {
                --startOffset;
lbl18:
                // 2 sources

                if (startOffset >= 0) continue;
            }
            if (startOffset < 0 || endOffset < 0) continue;
            specifierRegion = new Region(startOffset, endOffset - startOffset);
            formatSpecifierInfo = new FormatSpecifierInfo(formatSpecifierString, specifierRegion);
            if (!MethodCallUtils.VLOG_VALID_FORMAT_SPECIFIERS_WITH_ARGUMENTS.contains(formatSpecifier)) {
                if (MethodCallUtils.VLOG_VALID_FORMAT_SPECIFIERS_WITHOUT_ARGUMENTS.contains(formatSpecifier)) continue;
                invalidFormatSpecifiers.add(formatSpecifierInfo);
                continue;
            }
            formatSpecifiers.add(formatSpecifierInfo);
        }
        return new Object[]{formatSpecifiers, invalidFormatSpecifiers};
    }
}

