/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.semantic.extension;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.eclipse.core.runtime.OperationCanceledException;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.csp.constraints.Method;
import ro.amiq.dvt.csp.solver.Model;
import ro.amiq.dvt.csp.variables.IDomain;
import ro.amiq.dvt.csp.variables.IntDomain;
import ro.amiq.dvt.csp.variables.IntVariable;
import ro.amiq.dvt.csp.variables.Variable;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XComputedSelect;
import ro.amiq.dvt.interpreter.XSelectProxy;
import ro.amiq.dvt.interpreter.XStringFormatter;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.constraints.XCModel;
import ro.amiq.dvt.interpreter.constraints.XCValue;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.ElementFromCursorDetectionException;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfTypeElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorScopeWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IDataType;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.SkippedHidObjectEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataTypeCategory;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ArrayListContainer;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSemanticError;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.FormatSpecifierInfo;
import ro.amiq.vlogdt.model.reflection.semantic.extension.FormatSpecifiersUtils;
import ro.amiq.vlogdt.model.reflection.semantic.extension.FormatStringInfo;
import ro.amiq.vlogdt.model.reflection.semantic.extension.IRfHidImplicitLayer;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SEvaluator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SMethodCallInfo;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;
import ro.amiq.vlogdt.parser.VlogMacroZone;
import ro.amiq.vlogdt.r2lparser.R2LTooltipManager;
import ro.amiq.vlogdt.ui.search.new_engine.IReferenceHidOperatorVisitor;

public class RfHidAccessArgs
extends RfHidAccess
implements IHidAccessArgs {
    private static final long serialVersionUID = 6L;
    private static final String $CLOG2 = "$clog2";
    private static final String $ABS = "$abs";
    private static final String $MIN = "$min";
    private static final String $MAX = "$max";
    private static final String $LN = "$ln";
    private static final String $LOG10 = "$log10";
    private static final String $EXP = "$exp";
    private static final String $SQRT = "$sqrt";
    private static final String $POW = "$pow";
    private static final String $FLOOR = "$floor";
    private static final String $CEIL = "$ceil";
    private static final String $SIN = "$sin";
    private static final String $COS = "$cos";
    private static final String $TAN = "$tan";
    private static final String $ASIN = "$asin";
    private static final String $ACOS = "$acos";
    private static final String $ATAN = "$atan";
    private static final String $ATAN2 = "$atan2";
    private static final String $RTOI = "$rtoi";
    private static final String $ITOR = "$itor";
    private static final String $HYPOT = "$hypot";
    private static final String $SINH = "$sinh";
    private static final String $COSH = "$cosh";
    private static final String $TANH = "$tanh";
    private static final String $ASINH = "$asinh";
    private static final String $ACOSH = "$acosh";
    private static final String $ATANH = "$atanh";
    private static final String $BITS = "$bits";
    private static final String $SIZE = "$size";
    private static final String $LEFT = "$left";
    private static final String $RIGHT = "$right";
    private static final String $UNSIGNED = "$unsigned";
    private static final String $SIGNED = "$signed";
    private static final String $COUNTBITS = "$countbits";
    private static final String $COUNTONES = "$countones";
    private static final String $ONEHOT = "$onehot";
    private static final String $ONEHOT0 = "$onehot0";
    private static final String $ISUNKNOWN = "$isunknown";
    private static final String $PSPRINTF = "$psprintf";
    private static final String $SFORMATF = "$sformatf";
    private static final String $HIGH = "$high";
    private static final String $LOW = "$low";
    private static final String $INCREMENT = "$increment";
    private static final String $DIMENSIONS = "$dimensions";
    private static final String $UNPACKED_DIMENSIONS = "$unpacked_dimensions";
    private static final String $TEST$PLUSARGS = "$test$plusargs";
    private static final String $PAST = "$past";
    private static final String $SAMPLED = "$sampled";
    private static final String $REALTOBITS = "$realtobits";
    private static final String $BITSTOREAL = "$bitstoreal";
    private static final String $SHORTREALTOBITS = "$shortrealtobits";
    private static final String $BITSTOSHORTREAL = "$bitstoshortreal";
    @NotNull
    private ListContainer<? extends IHidObject> argumentValues;
    private HidOperator withClause;

    public RfHidAccessArgs(int accessKind, List<IHidObject> selects, List<? extends IHidObject> argumentValues, HidOperator withClause, IDataType dataType) {
        super(accessKind, selects, dataType);
        this.argumentValues = argumentValues == IHidAccessArgs.EMPTY_PARENTHESES ? IHidAccessArgs.EMPTY_PARENTHESES : OptimizedUtils.listContainerCreate(argumentValues, (boolean)false);
        this.withClause = withClause;
    }

    public RfHidAccessArgs(int accessKind, ListContainer<IHidObject> selectsContainer, ListContainer<? extends IHidObject> argumentsContainer, HidOperator withClause, IDataType dataType) {
        super(accessKind, selectsContainer, dataType);
        this.argumentValues = argumentsContainer;
        this.withClause = withClause;
    }

    public void setWithClause(HidOperator withClause) {
        this.withClause = withClause;
    }

    public HidOperator getWithClause() {
        return this.withClause;
    }

    public boolean hasWithClause() {
        return this.withClause != null;
    }

    @NotNull
    public List<? extends IHidObject> getArgumentValues() {
        if (this.argumentValues == IHidAccessArgs.EMPTY_PARENTHESES) {
            return IHidAccessArgs.EMPTY_PARENTHESES;
        }
        if (this.argumentValues == null) {
            return Collections.emptyList();
        }
        return OptimizedUtils.asList(this.argumentValues, (boolean)false);
    }

    public MethodCall getMethodCall(IHidEvaluationGuardian guardian) {
        Map methodsWithFormalArgs = MethodCallUtils.getMethodsWithFormalArguments((IHid)this.parentHid);
        if (methodsWithFormalArgs != null && !methodsWithFormalArgs.isEmpty()) {
            Map.Entry methodEntry = methodsWithFormalArgs.entrySet().iterator().next();
            IRfNamedElement method = (IRfNamedElement)methodEntry.getKey();
            List<IRfFieldElement> methodArguments = (List<IRfFieldElement>)methodEntry.getValue();
            if (guardian != null && guardian != IHidEvaluationGuardian.DUMMY_EVAL_GUARDIAN) {
                RfFunction methodElement = this.parentHid.getElement() instanceof RfFunction ? (RfFunction)this.parentHid.getElement() : null;
                RfNamedElement methodEnclosingScope = methodElement == null ? null : methodElement.getEnclosingScope();
                XValueHolderFactory factory = guardian.getFactory();
                if (factory != null && factory.isEnableEncryptedCodeAutoDefine() && methodElement != null && methodElement.isConstructor() && methodEnclosingScope instanceof IRfClassElement && (methodElement.isAutoDefined() || methodElement.xMissingConstructorImpl() || ((IRfClassElement)methodEnclosingScope).xRuntimeElabMissingConstructor(factory)) && (methodArguments == null || methodArguments.isEmpty()) && this.argumentValues != null && !this.argumentValues.isEmpty()) {
                    methodArguments = ((RfClass)methodElement.getEnclosingScope()).xGetRuntimeElabDummyConstructorArgs();
                }
            }
            return MethodCallUtils.getMethodCall((IHidObject)this.parentHid, (IRfNamedElement)method, (List)methodArguments, this.getArgumentValues(), (boolean)false, (HidOccurrence)this.getOccurrence());
        }
        if (!HidUtils.isResolved((IHidObject)this.parentHid)) {
            return MethodCallUtils.getMethodCall((IHidObject)this.parentHid, null, null, this.getArgumentValues(), (boolean)false, (HidOccurrence)this.getOccurrence());
        }
        return null;
    }

    public List<MethodCall> getMethodCalls(IHidEvaluationGuardian guardian) {
        MethodCall call = this.getMethodCall(guardian);
        return call != null ? Collections.singletonList(call) : null;
    }

    @Override
    public final RfHidAccessArgs deepCopy() {
        RfHidAccessArgs result = new RfHidAccessArgs(this.accessKind, (ListContainer<IHidObject>)this.selectsContainer, this.argumentValues, this.withClause, this.dataType);
        result.parametricDependencyValue = this.parametricDependencyValue;
        if (!this.isHidObjectsEmpty()) {
            for (Hid hid : this.hidsContainer) {
                result.addHid(hid.deepCopy());
            }
        }
        return result;
    }

    @Override
    public RfHidAccessArgs upwardsCopy(boolean addResolved) {
        RfHidAccessArgs result = new RfHidAccessArgs(this.accessKind, (ListContainer<IHidObject>)this.selectsContainer, this.argumentValues, this.withClause, this.dataType);
        result.parametricDependencyValue = this.parametricDependencyValue;
        if (addResolved) {
            result.associatedType = this.associatedType;
        }
        if (this.parentHid != null) {
            result.parentHid = this.parentHid.upwardsCopy(addResolved);
            result.parentHid.addAccess((HidAccess)result);
        }
        return result;
    }

    public RfHidAccessArgs hidObjectCopy() {
        ArrayListContainer selectsContainerCopy = null;
        if (this.selectsContainer != null) {
            selectsContainerCopy = new ArrayListContainer(this.selectsContainer.size());
            for (IHidObject select : this.selectsContainer) {
                selectsContainerCopy = OptimizedUtils.listContainerAdd((ListContainer)selectsContainerCopy, (Object)select.hidObjectCopy());
            }
        }
        ArrayListContainer argumentValuesCopy = null;
        if (this.argumentValues != null && !this.argumentValues.isEmpty()) {
            argumentValuesCopy = new ArrayListContainer(this.argumentValues.size());
            for (IHidObject argumentValue : this.argumentValues) {
                argumentValuesCopy = OptimizedUtils.listContainerAdd((ListContainer)argumentValuesCopy, (Object)argumentValue.hidObjectCopy());
            }
        }
        RfHidAccessArgs result = new RfHidAccessArgs(this.accessKind, (ListContainer<IHidObject>)selectsContainerCopy, (ListContainer<? extends IHidObject>)argumentValuesCopy, this.withClause != null ? this.withClause.hidObjectCopy() : null, this.dataType);
        if (this.argumentValues == EMPTY_PARENTHESES) {
            result.argumentValues = EMPTY_PARENTHESES;
        }
        result.parametricDependencyValue = this.parametricDependencyValue;
        result.associatedType = this.associatedType;
        if (this.parentHid != null) {
            result.parentHid = (Hid)this.parentHid.hidObjectCopy();
            result.parentHid.addAccess((HidAccess)result);
        }
        return result;
    }

    @Override
    public boolean hasHierarchyPathReferences() {
        if (super.hasHierarchyPathReferences()) {
            return true;
        }
        if (this.argumentValues.isEmpty()) {
            return false;
        }
        for (IHidObject argValue : this.argumentValues) {
            if (!argValue.hasHierarchyPathReferences()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean resolve(ConfigInfo configInfo, Object2ObjectMap<IHidObject, RfHidHolder.HidContextInfo> visitedResolvedHids, IRfNamedElement initialScope, IRfNamedElement parentElement, ParserPath parserPath, RfTypesResolver typesResolver, IHidObject lastChild, byte semanticEnabled, boolean lintCall, boolean triggerError, boolean resolveWithoutChildren, boolean isHierarchyPathSegment, boolean isInPortConnection) throws BuildCancelException {
        boolean isResolved = super.resolve(configInfo, visitedResolvedHids, initialScope, parentElement, parserPath, typesResolver, lastChild, semanticEnabled, lintCall, triggerError, resolveWithoutChildren, isHierarchyPathSegment, isInPortConnection);
        if (triggerError) {
            RfHidAccessArgs.resolveMethodCall(configInfo, initialScope, this.argumentValues, parentElement, this.parentHid, this.getOccurrence(), parserPath, lintCall);
        }
        return isResolved;
    }

    private static void resolveMethodCall(ConfigInfo configInfo, IRfNamedElement initialScope, ListContainer<? extends IHidObject> argumentValues, IRfNamedElement parentElement, Hid parentHid, HidOccurrence occurrence, ParserPath parserPath, boolean lintCall) {
        block46: {
            RfHidOperator connection;
            IHidObject connectionValue;
            int methodNameLength;
            if (!(parentElement instanceof RfFunction) || lintCall) {
                return;
            }
            if (argumentValues == null || argumentValues.isEmpty()) {
                return;
            }
            if (occurrence == null) {
                return;
            }
            int index = -1;
            RfProject rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vlogdt.VlogNature");
            HashMap<String, RfField> remaining = new HashMap<String, RfField>();
            HashSet<RfField> connectedWithNoValue = new HashSet<RfField>();
            RfFunction methodElement = (RfFunction)parentElement;
            String methodName = methodElement.getName();
            int n = methodNameLength = parentHid != null && parentHid.getName() != null ? parentHid.getName().length() : methodName.length();
            if ("new".equals(methodName) && argumentValues instanceof RfHidOperator && initialScope instanceof RfFunction && (connectionValue = MethodCallUtils.getValue((IHidObject)(connection = (RfHidOperator)argumentValues))) instanceof IRfHidImplicitLayer && ((IRfHidImplicitLayer)connectionValue).isLiteralDefault()) {
                boolean hasDefault = false;
                RfFunctionDef def = (RfFunctionDef)((RfFunction)initialScope).getDeclaration();
                for (ArgInfo argInfo : def.getArgumentInfos()) {
                    if (!"default".equals(argInfo.getName())) continue;
                    hasDefault = true;
                    break;
                }
                if (!hasDefault) {
                    int line = MethodCallUtils.getLine((IHidObject)connection);
                    int offsetStart = MethodCallUtils.getOffset((IHidObject)connection);
                    int offsetEnd = offsetStart + "default".length();
                    HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                    rfProject.addSemanticError(1, "ILLEGAL_DEFAULT_IN_SUPER_CALL: Missing 'default' argument in constructor ''{0}'.new'' declaration", initialScope.getLibPkgScope(), offsetStart, offsetEnd, attributes, line, parserPath, initialScope.getEnclosingScope());
                }
                return;
            }
            List<RfField> arguments = RfHid.computeValidArgumentsForValues(methodElement);
            for (RfField arg : arguments) {
                remaining.put(arg.getName(), arg);
                configInfo.addReferenceToIdentifierName(arg.getName());
            }
            boolean hasTooManyConnections = false;
            for (IHidObject connection2 : argumentValues) {
                String formalPartName;
                RfField arg;
                ++index;
                if (MethodCallUtils.isOrderedUnconnected((IHidObject)connection2)) {
                    if (index >= arguments.size()) {
                        hasTooManyConnections = true;
                        continue;
                    }
                    arg = arguments.get(index);
                    remaining.remove(arg.getName());
                    if (arg.getInitialValue(false) != null) continue;
                    connectedWithNoValue.add(arg);
                    continue;
                }
                if (MethodCallUtils.isOrderedConnected((IHidObject)connection2)) {
                    if (index >= arguments.size()) {
                        hasTooManyConnections = true;
                        continue;
                    }
                    arg = arguments.get(index);
                    remaining.remove(arg.getName());
                    continue;
                }
                if (!MethodCallUtils.isNamed((IHidObject)connection2) || (formalPartName = MethodCallUtils.getMethodArgumentName((IHidObject)connection2)).isEmpty()) continue;
                RfField argumentCandidate = methodElement.getLocalMember(RfField.class, formalPartName, true);
                if (argumentCandidate == null || !argumentCandidate.isArgument()) {
                    configInfo.addReferenceToIdentifierName(formalPartName);
                    int line = MethodCallUtils.getLine((IHidObject)connection2);
                    int offsetStart = MethodCallUtils.getOffset((IHidObject)connection2);
                    int offsetEnd = offsetStart + formalPartName.length();
                    HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                    attributes.put("QUICKFIX_ELEMENT_NAME", formalPartName);
                    attributes.put("QUICKFIX_KIND", 31);
                    rfProject.addSemanticError(1, "NON_EXISTING_METHOD_ARGUMENT: Non existing argument ''{0}'' of function/task ''{1}''", initialScope.getLibPkgScope(), offsetStart, offsetEnd, attributes, line, parserPath, formalPartName, methodName);
                    continue;
                }
                RfField arg2 = (RfField)remaining.remove(formalPartName);
                if (arg2 == null) {
                    int line = occurrence.getLine();
                    int offsetStart = occurrence.getVirtualOffset() > 0 ? -1 : occurrence.getOffset();
                    int offsetEnd = offsetStart + methodNameLength;
                    Map<String, Object> attributes = null;
                    rfProject.addSemanticError(1, "MULTIPLE_ARGUMENT_VALUES: Multiple values for argument ''{0}''", initialScope.getLibPkgScope(), offsetStart, offsetEnd, attributes, line, parserPath, formalPartName);
                    continue;
                }
                if (!MethodCallUtils.isNamedUnconnected((IHidObject)connection2) || arg2.getInitialValue(false) != null) continue;
                connectedWithNoValue.add(arg2);
            }
            boolean isEscaped = methodElement.isEscaped();
            boolean ignoreArgumentValues = RfHid.ignoreArgumentValues(methodElement, isEscaped, occurrence, argumentValues.size());
            if (!ignoreArgumentValues) {
                if (!(!hasTooManyConnections || methodElement instanceof RfPredefinedFunction && ((RfPredefinedFunction)methodElement).allowsMoreArguments())) {
                    int line = occurrence.getLine();
                    int offsetStart = occurrence.getVirtualOffset() > 0 ? -1 : occurrence.getOffset();
                    int offsetEnd = offsetStart + methodNameLength;
                    Map<String, Object> attributes = null;
                    if ("$typename".equals(methodName)) {
                        rfProject.addSemanticError(2, RfSemanticError.NON_STANDARD_SYSTEM_FUNCTION_ARGUMENTS, initialScope.getLibPkgScope(), offsetStart, offsetEnd, attributes, line, parserPath, methodName, arguments.size());
                    } else {
                        rfProject.addSemanticError(1, "METHOD_CALL_ARGUMENTS: Expecting maximum ''{1}'' argument{1,choice,0#s|1#|1<s} when calling ''{2}'', found ''{0}''", initialScope.getLibPkgScope(), offsetStart, offsetEnd, attributes, line, parserPath, argumentValues.size(), arguments.size(), methodName);
                    }
                    return;
                }
                int nofInputs = 0;
                int nofOutputs = 0;
                int nofInouts = 0;
                int nofRefs = 0;
                StringJoiner inputNames = new StringJoiner(", ");
                StringJoiner outputNames = new StringJoiner(", ");
                StringJoiner inoutNames = new StringJoiner(", ");
                StringJoiner refNames = new StringJoiner(", ");
                for (RfField arg : connectedWithNoValue) {
                    if (arg.isInput()) {
                        if (nofInputs > 4) continue;
                        inputNames.add(nofInputs++ == 4 ? "..." : arg.getName());
                        continue;
                    }
                    if (arg.isOutput()) {
                        if (nofOutputs > 4) continue;
                        outputNames.add(nofOutputs++ == 4 ? "..." : arg.getName());
                        continue;
                    }
                    if (arg.isInout()) {
                        if (nofInouts > 4) continue;
                        inoutNames.add(nofInouts++ == 4 ? "..." : arg.getName());
                        continue;
                    }
                    if (arg.isRef()) {
                        if (nofRefs > 4) continue;
                        refNames.add(nofRefs++ == 4 ? "..." : arg.getName());
                        continue;
                    }
                    if (nofInputs > 4) continue;
                    inputNames.add(nofInputs++ == 4 ? "..." : arg.getName());
                }
                for (RfField arg : remaining.values()) {
                    if (arg.getInitialValue(false) != null || arg.isOptionalArgument()) continue;
                    if (arg.isInput()) {
                        if (nofInputs > 4) continue;
                        inputNames.add(nofInputs++ == 4 ? "..." : arg.getName());
                        continue;
                    }
                    if (arg.isOutput()) {
                        if (nofOutputs > 4) continue;
                        outputNames.add(nofOutputs++ == 4 ? "..." : arg.getName());
                        continue;
                    }
                    if (arg.isInout()) {
                        if (nofInouts > 4) continue;
                        inoutNames.add(nofInouts++ == 4 ? "..." : arg.getName());
                        continue;
                    }
                    if (arg.isRef()) {
                        if (nofRefs > 4) continue;
                        refNames.add(nofRefs++ == 4 ? "..." : arg.getName());
                        continue;
                    }
                    if (nofInputs > 4) continue;
                    inputNames.add(nofInputs++ == 4 ? "..." : arg.getName());
                }
                int line = occurrence.getLine();
                int offsetStart = occurrence.getVirtualOffset() > 0 ? -1 : occurrence.getOffset();
                int offsetEnd = offsetStart + methodNameLength;
                RfHid.addMissingArgumentValueError(1, inputNames, "input", methodName, offsetStart, offsetEnd, line, rfProject, parserPath, initialScope, configInfo);
                RfHid.addMissingArgumentValueError(2, outputNames, "output", methodName, offsetStart, offsetEnd, line, rfProject, parserPath, initialScope, configInfo);
                RfHid.addMissingArgumentValueError(1, inoutNames, "inout", methodName, offsetStart, offsetEnd, line, rfProject, parserPath, initialScope, configInfo);
                RfHid.addMissingArgumentValueError(1, refNames, "ref", methodName, offsetStart, offsetEnd, line, rfProject, parserPath, initialScope, configInfo);
            }
            if (argumentValues.size() > 1 && methodElement instanceof RfPredefinedFunction && $PAST.equals(methodName)) {
                IHidObject connection3 = (IHidObject)argumentValues.get(1);
                IHidObject value = MethodCallUtils.getValue((IHidObject)connection3);
                ArrayList hids = new ArrayList();
                Predicate<IHidObject> result = element -> {
                    IHid hid = HidUtils.getHidFrom((IHidObject)element);
                    if (hid instanceof RfHid) {
                        hids.add((RfHid)hid);
                    }
                    return true;
                };
                HidUtils.flattenToObjects(result, (IHidObject)value, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
                for (RfHid hid : hids) {
                    boolean isCovergroupExpression = hid.hasQualifier(HidQualifierCache.IS_IN_COVERGROUP_EXPRESSION);
                    boolean isConstantHid = hid.isConstantExpression(isCovergroupExpression);
                    boolean isResolved = hid.getElement() != null;
                    if (!(isResolved & !isConstantHid)) continue;
                    int line = hid.getLine();
                    int offsetStart = hid.getOffset();
                    int offsetEnd = offsetStart + hid.getName().length();
                    HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                    rfProject.addSemanticError(1, "ILLEGAL_NONCONSTANT_EXPRESSION: Expecting constant expression, but found ''{0}''", initialScope.getLibPkgScope(), offsetStart, offsetEnd, attributes, line, parserPath, HidUtils.toNiceString((IHidObject)hid));
                }
            }
            if (methodElement instanceof RfPredefinedFunction && methodName.startsWith("$") && FormatSpecifiersUtils.ALL_SYSTEM_TIMING_CHECKS.contains(methodName)) {
                index = -1;
                for (IHidObject connection4 : argumentValues) {
                    ISDataAbstract data;
                    ISDataType dataType;
                    IRfNamedElement type;
                    RfField arg;
                    IHidObject value = MethodCallUtils.getValue((IHidObject)connection4);
                    if (!"notifier".equals((arg = arguments.get(++index)).getName()) || !(value instanceof RfHid) || (type = (dataType = SDataUtils.getDataType((ISDataAbstract)(data = SEvaluator.INSTANCE.calculateDataType(configInfo, value, initialScope, null, null)))).getType()) instanceof RfBitVectorScalarType && ((RfBitVectorScalarType)type).getBitSize() == 1) continue;
                    int line = MethodCallUtils.getLine((IHidObject)connection4);
                    int offsetStart = MethodCallUtils.getOffset((IHidObject)connection4);
                    int offsetEnd = offsetStart + ((RfHid)value).getName().length();
                    HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                    rfProject.addSemanticError(1, "ILLEGAL_SYSTEM_TIMING_CHECK_ARGUMENT: ''{0}'' passed to notifier argument must be of 1-bit type", initialScope.getLibPkgScope(), offsetStart, offsetEnd, attributes, line, parserPath, ((RfHid)value).getName());
                }
            }
            if (!(methodElement instanceof RfPredefinedFunction) || !methodName.startsWith("$") || !FormatSpecifiersUtils.ALL_FORMAT_STRING_SYSTEM_TASKS.contains(methodName)) break block46;
            List<FormatStringInfo> allFormatStringInfos = FormatSpecifiersUtils.getAllFormatStringInfos(OptimizedUtils.asList(argumentValues, (boolean)false), methodName);
            if (allFormatStringInfos == null || allFormatStringInfos.isEmpty()) {
                return;
            }
            for (FormatStringInfo formatStringInfo : allFormatStringInfos) {
                int foundSpecifiersValueNum;
                int requiredSpecifiersValueNum;
                block47: {
                    requiredSpecifiersValueNum = formatStringInfo.getRequiredSpecifiersValueNum();
                    if (requiredSpecifiersValueNum != (foundSpecifiersValueNum = formatStringInfo.getFoundSpecifiersValueNum())) break block47;
                    List<FormatSpecifierInfo> specifiers = formatStringInfo.getSpecifiers();
                    List<IHidObject> specifiersValues = formatStringInfo.getSpecifierValues();
                    int i = 0;
                    while (i < requiredSpecifiersValueNum) {
                        block48: {
                            RfPredefinedField dummyComparisonValue;
                            String specifier;
                            IHidObject initialValue;
                            IHidObject initialOperator;
                            block51: {
                                block53: {
                                    block52: {
                                        block50: {
                                            block49: {
                                                FormatSpecifierInfo specifierRaw = specifiers.get(i);
                                                initialOperator = specifiersValues.get(i);
                                                initialValue = MethodCallUtils.getValue((IHidObject)specifiersValues.get(i));
                                                if (initialValue == null) break block48;
                                                specifier = specifierRaw.getSpecifierName().toLowerCase();
                                                if (!specifier.equals("p")) break block49;
                                                ISDataAbstract data = SEvaluator.INSTANCE.calculateDataType(configInfo, initialValue, initialScope, null, null);
                                                ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)data);
                                                if (SDataUtils.getUndefinedDataType((ISDataAbstract)dataType) != null) break;
                                                SDataTypeCategory categoryValue = SDataAbstracts.getOperandCategory((ISDataAbstract)dataType);
                                                if (categoryValue == SDataTypeCategory.COVERGROUP || categoryValue == SDataTypeCategory.CLOCKING_BLOCK || categoryValue == SDataTypeCategory.NULL || categoryValue == SDataTypeCategory.VOID) {
                                                    int line = MethodCallUtils.getLine((IHidObject)initialOperator);
                                                    String valueName = HidUtils.toNiceString((IHidObject)initialOperator);
                                                    int offsetStart = MethodCallUtils.getVirtualOffset((IHidObject)initialOperator) >= 0 ? -1 : MethodCallUtils.getOpenBoundary((IHidObject)initialOperator);
                                                    int offsetEnd = offsetStart < 0 ? -1 : MethodCallUtils.getClosedBoundary((IHidObject)initialOperator);
                                                    rfProject.addSemanticError(2, "ILLEGAL_FORMAT_SPEC: Illegal format specifier ''%{1}'' for argument ''{0}'' when calling ''{2}''", initialScope.getLibPkgScope(), offsetStart, offsetEnd, null, line, parserPath, valueName, specifier, methodName);
                                                }
                                                break block48;
                                            }
                                            dummyComparisonValue = null;
                                            if (!specifier.equals("s")) break block50;
                                            dummyComparisonValue = new RfPredefinedField("%" + specifier, RfProject.getSimpleDataType("string"), 1, 0, null, null);
                                            break block51;
                                        }
                                        if (!specifier.equals("v")) break block52;
                                        dummyComparisonValue = new RfPredefinedField("%" + specifier, RfProject.getSimpleDataType("logic"), 1, 0, null, null);
                                        break block51;
                                    }
                                    if (!MethodCallUtils.REAL_FORMAT_DISPLAY_SPECIFIERS.contains(specifier)) break block53;
                                    dummyComparisonValue = new RfPredefinedField("%" + specifier, RfProject.getSimpleDataType("real"), 1, 0, null, null);
                                    break block51;
                                }
                                if (!MethodCallUtils.INTEGER_FORMAT_DISPLAY_SPECIFIERS.contains(specifier)) break block48;
                                dummyComparisonValue = new RfPredefinedField("%" + specifier, RfProject.getSimpleDataType("integer"), 1, 0, null, null);
                            }
                            HidOperatorOccurrence occ2 = new HidOperatorOccurrence(occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), occurrence.getQualifiers(), occurrence.getReparseInfo());
                            RfHid makeStandInHid = STransformer.makeStandInHid("lh", dummyComparisonValue, occurrence, 0L);
                            RfHidOperator operator = STransformer.makeStandInOperator((IHidObject)makeStandInHid, Arrays.asList(initialValue), IHidOperatorConstants.OperatorType.ASSOCIATION.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, ":", occ2, 0L);
                            ISDataAbstract result = SEvaluator.INSTANCE.checkTypeCompatibility(operator, false, false, false, initialScope, configInfo);
                            ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)result);
                            boolean isStringSpecifier = specifier.equals("s");
                            if (!(isStringSpecifier && dataType != SDataAbstracts.ILLEGAL || !isStringSpecifier && !SDataUtils.isIllegalDataType((ISDataAbstract)dataType))) {
                                int line = MethodCallUtils.getLine((IHidObject)initialOperator);
                                String valueName = HidUtils.toNiceString((IHidObject)initialOperator);
                                int offsetStart = MethodCallUtils.getVirtualOffset((IHidObject)initialOperator) >= 0 ? -1 : MethodCallUtils.getOpenBoundary((IHidObject)initialOperator);
                                int offsetEnd = offsetStart < 0 ? -1 : MethodCallUtils.getClosedBoundary((IHidObject)initialOperator);
                                rfProject.addSemanticError(2, "ILLEGAL_FORMAT_SPEC: Illegal format specifier ''%{1}'' for argument ''{0}'' when calling ''{2}''", initialScope.getLibPkgScope(), offsetStart, offsetEnd, null, line, parserPath, valueName, specifier, methodName);
                            }
                        }
                        ++i;
                    }
                }
                if (requiredSpecifiersValueNum == foundSpecifiersValueNum && !formatStringInfo.hasInvalidSpecifiers() && !formatStringInfo.hasSpecifiersExtraValues()) continue;
                IHidObject formatHid = formatStringInfo.getFormatHid();
                int formatHidOffset = MethodCallUtils.getOffset((IHidObject)formatHid);
                if (formatStringInfo.hasInvalidSpecifiers()) {
                    List<FormatSpecifierInfo> invalidSpecifiers = formatStringInfo.getInvalidSpecifiers();
                    for (FormatSpecifierInfo invalidSpecfier : invalidSpecifiers) {
                        int line = occurrence.getLine();
                        String invalidSpecifierName = invalidSpecfier.getSpecifierName();
                        int offsetStart = MethodCallUtils.getVirtualOffset((IHidObject)formatHid) >= 0 ? -1 : formatHidOffset + invalidSpecfier.getRegionInFormatString().getOffset() + 1;
                        int offsetEnd = offsetStart < 0 ? -1 : offsetStart + invalidSpecfier.getRegionInFormatString().getLength();
                        rfProject.addSemanticError(2, "INVALID_FORMAT_SPEC: Invalid ''%{0}'' when calling ''{1}''", initialScope.getLibPkgScope(), offsetStart, offsetEnd, null, line, parserPath, invalidSpecifierName, methodName);
                    }
                }
                if (requiredSpecifiersValueNum > foundSpecifiersValueNum) {
                    List<FormatSpecifierInfo> specifiers = formatStringInfo.getSpecifiers();
                    int i = foundSpecifiersValueNum;
                    while (i < requiredSpecifiersValueNum) {
                        FormatSpecifierInfo specifier = specifiers.get(i);
                        int line = occurrence.getLine();
                        String specifierName = specifier.getSpecifierName();
                        int offsetStart = MethodCallUtils.getVirtualOffset((IHidObject)formatHid) >= 0 ? -1 : formatHidOffset + specifier.getRegionInFormatString().getOffset() + 1;
                        int offsetEnd = offsetStart < 0 ? -1 : offsetStart + specifier.getRegionInFormatString().getLength();
                        rfProject.addSemanticError(1, "MISSING_ARG_FORMAT_SPEC: Missing argument for ''%{0}'' when calling ''{1}''", initialScope.getLibPkgScope(), offsetStart, offsetEnd, null, line, parserPath, specifierName, methodName);
                        ++i;
                    }
                }
                if (!formatStringInfo.checkSpecifiersExtraValues()) continue;
                List<IHidObject> specifiersExtraValues = formatStringInfo.getSpecifiersExtraValues();
                for (IHidObject extraValue : specifiersExtraValues) {
                    int line = MethodCallUtils.getLine((IHidObject)extraValue);
                    String valueName = HidUtils.toNiceString((IHidObject)extraValue);
                    int offsetStart = MethodCallUtils.getVirtualOffset((IHidObject)extraValue) >= 0 ? -1 : MethodCallUtils.getOpenBoundary((IHidObject)extraValue);
                    int offsetEnd = offsetStart < 0 ? -1 : MethodCallUtils.getClosedBoundary((IHidObject)extraValue);
                    rfProject.addSemanticError(2, "EXTRA_ARG_FORMAT_SPEC: Extra argument ''{0}'' when calling ''{1}''", initialScope.getLibPkgScope(), offsetStart, offsetEnd, null, line, parserPath, valueName, methodName);
                }
            }
        }
    }

    @Override
    public void deepClean() {
        super.deepClean();
        this.argumentValues = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ELParamValueScope evaluateForSize(IHidEvaluator evaluator, IRfNamedElement origin, IHidEvaluationGuardian guardian) {
        HidAccess parentAccess;
        if (guardian.shouldSkip((IHidObject)this)) {
            throw new SkippedHidObjectEvaluationException((IHidObject)this);
        }
        if (this.parentHid == null) {
            throw new UnknownHidObjectEvaluationException((IHidObject)this);
        }
        String parentHidName = this.parentHid.getName();
        IRfNamedElement parentElement = this.parentHid.getElement();
        if (this.withClause != null && parentElement instanceof RfPredefinedFunction && RfHid.ARRAY_REDUCTION_METHODS.contains(parentHidName)) {
            return this.withClause.evaluateForSize(evaluator, origin, guardian);
        }
        Object currentEvaluator = evaluator;
        if (currentEvaluator.isInterpreter() && (parentAccess = this.parentHid.getParentAccess()) != null) {
            ELParamValueScope currentEvaluatorValueScope = guardian.getMethodCallFromCache((IHidObject)parentAccess);
            if (currentEvaluatorValueScope == null) {
                currentEvaluatorValueScope = ELUtils.evaluate((IHidObject)parentAccess, (IHidEvaluator)evaluator, null, (IHidEvaluationGuardian)guardian);
            }
            currentEvaluator = (parentElement == null || parentElement.isPredefined()) && "rand_mode".equals(parentHidName) ? currentEvaluatorValueScope.scope : currentEvaluatorValueScope.value;
            if (parentAccess.isMethodCall(false)) {
                guardian.cacheMethodCall((IHidObject)parentAccess, ELParamValueScope.of((IELParamValue)((IELParamValue)currentEvaluator)));
            }
        }
        IHidEvaluationGuardian hidEvalGuardian = guardian;
        if (evaluator.isInterpreter()) {
            hidEvalGuardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.WIDTH_CHECKING, (IRfNamedElement)evaluator.getNamedElement(), (ElementPath)guardian.getHierarchyPath(), (boolean)false, (ELManager)guardian.getManager());
        }
        if (parentHidName.startsWith("$") && !guardian.isVlogSystemCallExecuted(parentHidName)) {
            MethodCall methodCall = null;
            Hid hid = this.parentHid;
            synchronized (hid) {
                if (this.parentHid.getElement() == null) {
                    evaluator.resolveHidInContext((IHidObject)this.parentHid, hidEvalGuardian, false);
                }
                methodCall = this.getMethodCall(hidEvalGuardian);
            }
            return ELParamValueScope.of((IELParamValue)this.evaluateSystemFunctionCallForSize(methodCall, (IHidEvaluator)currentEvaluator, origin, guardian));
        }
        return super.evaluateForSize(evaluator, origin, guardian);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
        ELParamValueScope eLParamValueScope;
        void typesResolver;
        RfTypesResolver rfTypesResolver;
        if (guardian.shouldSkip((IHidObject)this)) {
            throw new SkippedHidObjectEvaluationException((IHidObject)this);
        }
        if (this.parentHid == null) {
            throw new UnknownHidObjectEvaluationException((IHidObject)this);
        }
        if (evaluator instanceof RfTypesResolver && ((RfTypesResolver)evaluator).isExpressionTypeComputation()) {
            return super.evaluate(evaluator, context, guardian);
        }
        IELParamValue result = null;
        String parentHidName = this.parentHid.getName();
        if (parentHidName.startsWith("$")) {
            if (guardian.isSystfUserDefined(parentHidName)) {
                ELParamValueScope eLParamValueScope2;
                ELParamValueScope value = this.evaluateInterpreter(evaluator, context, guardian);
                if (value == null) {
                    eLParamValueScope2 = ELParamValueScope.UNDEFINED_VALUE;
                    return eLParamValueScope2;
                }
                eLParamValueScope2 = value;
                return eLParamValueScope2;
            }
            if (!guardian.isVlogSystemCallExecuted(parentHidName)) {
                try {
                    IELParamValue iELParamValue;
                    MethodCall methodCall = this.getMethodCall(guardian);
                    result = this.evaluateSystemFunctionCall(methodCall, evaluator, context, guardian);
                    if (context != null) {
                        iELParamValue = context.transform(result);
                        return ELParamValueScope.of((IELParamValue)iELParamValue);
                    }
                    iELParamValue = result;
                    return ELParamValueScope.of((IELParamValue)iELParamValue);
                }
                catch (UnknownHidObjectEvaluationException uex) {
                    if (!evaluator.isInterpreter()) throw uex;
                    guardian.logError("System call '" + parentHidName + "' is not implemented.");
                    return ELParamValueScope.UNDEFINED_VALUE;
                }
            }
        }
        if (evaluator.isInterpreter()) {
            ELParamValueScope eLParamValueScope3;
            ELParamValueScope value = this.evaluateInterpreter(evaluator, context, guardian);
            if (value == null) {
                eLParamValueScope3 = ELParamValueScope.UNDEFINED_VALUE;
                return eLParamValueScope3;
            }
            eLParamValueScope3 = value;
            return eLParamValueScope3;
        }
        IRfNamedElement element = null;
        MethodCall methodCall = null;
        IHidEvaluator iHidEvaluator = evaluator;
        IHidEvaluator methodEvaluator = iHidEvaluator instanceof RfTypesResolver && (rfTypesResolver = (RfTypesResolver)iHidEvaluator) == (RfTypesResolver)iHidEvaluator ? RfTypesResolver.create((RfTypesResolver)typesResolver) : evaluator;
        Hid hid = this.parentHid;
        synchronized (hid) {
            try {
                element = this.parentHid.getElement();
                if (element == null) {
                    methodEvaluator.resolveHidInContext((IHidObject)this.parentHid, guardian, false);
                    element = this.parentHid.getElement();
                }
                if (!HidUtils.isResolved((IHidObject)this.parentHid)) {
                    ELParamValueScope eLParamValueScope4 = ELParamValueScope.UNDEFINED_VALUE;
                    return eLParamValueScope4;
                }
                methodCall = this.getMethodCall(guardian);
            }
            finally {
                this.parentHid.setElement(element);
            }
        }
        ELParamValueScope resultValueScope = RfHidAccessArgs.evaluateFunctionCall((IHidObject)this, (MethodCall)methodCall, (IHidEvaluator)methodEvaluator, (IHidEvaluator)evaluator, (IHidEvaluationGuardian)guardian);
        if (context != null) {
            eLParamValueScope = context.transform(resultValueScope);
            return eLParamValueScope;
        }
        eLParamValueScope = resultValueScope;
        return eLParamValueScope;
    }

    public ELParamValueScope evaluateInterpreter(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
        if (guardian.shouldSkip((IHidObject)this)) {
            return null;
        }
        if (this.parentHid == null) {
            throw new UnknownHidObjectEvaluationException((IHidObject)this);
        }
        IHidEvaluator argumentsEvaluator = evaluator;
        Object currentEvaluator = evaluator;
        String parentHidName = this.parentHid.getName();
        IRfNamedElement parentElement = this.parentHid.getElement();
        HidAccess parentAccess = this.parentHid.getParentAccess();
        if (parentAccess != null) {
            boolean isArrayStoreFunction;
            Hid parentHid2 = this.parentHid.getParentHid();
            if (parentHid2 != null && parentAccess.getAccessKind() == 2 && "self".equals(parentHidName) && "interface".equals(parentHid2.getName())) {
                ELParamValueScope valueScope = ((XValueHolder)evaluator).getValueImpl("self", null, false, false, false, guardian);
                return valueScope;
            }
            ELParamValueScope currentEvaluatorValueScope = guardian.getMethodCallFromCache((IHidObject)parentAccess);
            boolean bl = isArrayStoreFunction = parentElement instanceof RfPredefinedFunction && ("push_back".equals(parentHidName) || "push_front".equals(parentHidName) || "insert".equals(parentHidName));
            if (currentEvaluatorValueScope == null || isArrayStoreFunction) {
                boolean prevLHS = guardian.setLHS(isArrayStoreFunction);
                try {
                    currentEvaluatorValueScope = ELUtils.evaluate((IHidObject)parentAccess, (IHidEvaluator)evaluator, null, (IHidEvaluationGuardian)guardian);
                }
                finally {
                    guardian.setLHS(prevLHS);
                }
            }
            currentEvaluator = (parentElement == null || parentElement.isPredefined()) && "rand_mode".equals(parentHidName) ? currentEvaluatorValueScope.scope : currentEvaluatorValueScope.value;
        }
        ELParamValueScope result = null;
        MethodCall methodCall = null;
        try {
            IELParamValue methodValue = XUtils.getMethodValue((IHid)this.parentHid, (IHidEvaluator)currentEvaluator, (IHidEvaluationGuardian)guardian);
            if (methodValue != null) {
                IRfNamedElement namedElement = methodValue.getNamedElement();
                if (namedElement != null) {
                    this.parentHid.setElement(namedElement);
                }
                if ((methodCall = this.getMethodCall(guardian)) == null) {
                    return null;
                }
                methodCall.methodValueHolder = methodValue;
            } else if (currentEvaluator instanceof ELParamValues.ParamValueNumber && parentElement == null) {
                currentEvaluator = this.parentHid.resolveHidInterpreter(evaluator, currentEvaluator);
            }
            if (!HidUtils.isResolved((IHidObject)this.parentHid)) {
                return null;
            }
            if (methodCall == null) {
                methodCall = this.getMethodCall(guardian);
            }
        }
        finally {
            this.parentHid.setElement(parentElement);
        }
        result = RfHidAccessArgs.evaluateFunctionCall((IHidObject)this, (MethodCall)methodCall, (IHidEvaluator)currentEvaluator, (IHidEvaluator)argumentsEvaluator, (IHidEvaluationGuardian)guardian);
        if (this.selectsContainer == null) {
            return context != null ? context.transform(result) : result;
        }
        IELParamValue selectProxyValue = XValueHolderFactory.createSelectProxyValue((HidAccess)this, (IELParamValue)XUtils.getValue((ELParamValueScope)result), (BitVectorContext)context, (IHidEvaluator)evaluator, (boolean)false, (boolean)false, (IHidEvaluationGuardian)guardian, (LanguageKind)LanguageKind.VLOG);
        return ELParamValueScope.of((IELParamValue)selectProxyValue, (IHidEvaluator)XUtils.getScope((ELParamValueScope)result));
    }

    private IELParamValue evaluateSystemFunctionCallForSize(MethodCall methodCall, IHidEvaluator origEvaluator, IRfNamedElement origin, IHidEvaluationGuardian guardian) {
        String methodName;
        guardian.checkBuildCanceled();
        if (methodCall == null) {
            throw new UnknownHidObjectEvaluationException((IHidObject)this);
        }
        switch (methodName = methodCall.getMethodName()) {
            case "$clog2": {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.ZERO));
            }
            case "$unsigned": 
            case "$signed": {
                if (methodCall.argumentValuesMapRaw == null) {
                    throw new UnknownHidObjectEvaluationException((IHidObject)this);
                }
                Collection rawArguments = methodCall.argumentValuesMapRaw.values();
                if (rawArguments == null || rawArguments.isEmpty()) {
                    throw new UnknownHidObjectEvaluationException((IHidObject)this);
                }
                Iterator iterator = rawArguments.iterator();
                IELParamValue evaluateForSize = XUtils.getValue((ELParamValueScope)ELUtils.evaluateForSize((IHidObject)((IHidObject)iterator.next()), (IHidEvaluator)origEvaluator, (IRfNamedElement)origin, (IHidEvaluationGuardian)guardian));
                if (ELUtils.isUnsuccessfulEval((IELParamValue)evaluateForSize)) {
                    throw new UnknownHidObjectEvaluationException((IHidObject)this);
                }
                DVTNumber number = evaluateForSize.getDVTNumber();
                if (!(number instanceof VlogBitVector)) {
                    throw new UnknownHidObjectEvaluationException((IHidObject)this);
                }
                return $UNSIGNED.equals(methodName) ? ELParamValues.ParamValueNumber.of((DVTNumber)DVTNumber.$unsigned((DVTNumber)number)) : ELParamValues.ParamValueNumber.of((DVTNumber)DVTNumber.$signed((DVTNumber)number));
            }
            case "$past": 
            case "$sampled": {
                if (methodCall.argumentValuesMapRaw == null) {
                    throw new UnknownHidObjectEvaluationException((IHidObject)this);
                }
                Collection rawArguments = methodCall.argumentValuesMapRaw.values();
                if (rawArguments == null || rawArguments.isEmpty()) {
                    throw new UnknownHidObjectEvaluationException((IHidObject)this);
                }
                IELParamValue evaluateForSize = XUtils.getValue((ELParamValueScope)ELUtils.evaluateForSize((IHidObject)((IHidObject)rawArguments.iterator().next()), (IHidEvaluator)origEvaluator, (IRfNamedElement)origin, (IHidEvaluationGuardian)guardian));
                if (ELUtils.isUnsuccessfulEval((IELParamValue)evaluateForSize) || DVTNumber.isUndefined((DVTNumber)evaluateForSize.getDVTNumber())) {
                    throw new UnknownHidObjectEvaluationException((IHidObject)this);
                }
                return evaluateForSize;
            }
        }
        if (methodCall.method == null) {
            throw new UnknownHidObjectEvaluationException((IHidObject)this);
        }
        ELManager manager = origEvaluator instanceof ELParamValuesHidEvaluator ? ((ELParamValuesHidEvaluator)origEvaluator).getManager() : null;
        BitVectorContext returnContext = ((IRfMethodElement)methodCall.method).getDataTypeBitVectorContext(origEvaluator, false, null, manager);
        if (returnContext != null) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)returnContext.getContextNumber());
        }
        throw new UnknownHidObjectEvaluationException((IHidObject)this);
    }

    private IELParamValue evaluateSystemFunctionCall(MethodCall methodCall, IHidEvaluator origEvaluator, BitVectorContext origContext, IHidEvaluationGuardian guardian) {
        guardian.checkBuildCanceled();
        guardian.incrementStepCount();
        ELManager manager = origEvaluator.getManager();
        if (manager != null) {
            manager.state.incrementSystemMethodCallsEvals();
        }
        if (methodCall == null || methodCall.argumentValuesMapRaw == null) {
            throw new UnknownHidObjectEvaluationException((IHidObject)this);
        }
        Collection rawArguments = methodCall.argumentValuesMapRaw.values();
        if (rawArguments == null || rawArguments.isEmpty()) {
            throw new UnknownHidObjectEvaluationException((IHidObject)this);
        }
        Iterator<IHidObject> iterator = rawArguments.iterator();
        String methodName = methodCall.getMethodName();
        if (methodName.equals($SFORMATF) || methodName.equals($PSPRINTF)) {
            return this.computesPrintfSformatf(methodCall, origEvaluator, origContext, guardian, manager, iterator);
        }
        UnaryOperator function = null;
        BinaryOperator biFunction = null;
        switch (methodName) {
            case "$clog2": {
                function = DVTNumber::$clog2;
                break;
            }
            case "$abs": {
                function = DVTNumber::$abs;
                break;
            }
            case "$min": {
                biFunction = DVTNumber::$min;
                break;
            }
            case "$max": {
                biFunction = DVTNumber::$max;
                break;
            }
            case "$ln": {
                function = DVTNumber::$ln;
                break;
            }
            case "$log10": {
                function = DVTNumber::$log10;
                break;
            }
            case "$exp": {
                function = DVTNumber::$exp;
                break;
            }
            case "$sqrt": {
                function = DVTNumber::$sqrt;
                break;
            }
            case "$pow": {
                biFunction = DVTNumber::$pow;
                break;
            }
            case "$floor": {
                function = DVTNumber::$floor;
                break;
            }
            case "$ceil": {
                function = DVTNumber::$ceil;
                break;
            }
            case "$sin": {
                function = DVTNumber::$sin;
                break;
            }
            case "$cos": {
                function = DVTNumber::$cos;
                break;
            }
            case "$tan": {
                function = DVTNumber::$tan;
                break;
            }
            case "$asin": {
                function = DVTNumber::$asin;
                break;
            }
            case "$acos": {
                function = DVTNumber::$acos;
                break;
            }
            case "$atan": {
                function = DVTNumber::$atan;
                break;
            }
            case "$rtoi": {
                function = DVTNumber::$rtoi;
                break;
            }
            case "$itor": {
                function = DVTNumber::$itor;
                break;
            }
            case "$realtobits": {
                function = DVTNumber::$realtobits;
                break;
            }
            case "$bitstoreal": {
                function = DVTNumber::$bitstoreal;
                break;
            }
            case "$shortrealtobits": {
                function = DVTNumber::$shortrealtobits;
                break;
            }
            case "$bitstoshortreal": {
                function = DVTNumber::$bitstoshortreal;
                break;
            }
            case "$atan2": {
                biFunction = DVTNumber::$atan2;
                break;
            }
            case "$hypot": {
                biFunction = DVTNumber::$hypot;
                break;
            }
            case "$sinh": {
                function = DVTNumber::$sinh;
                break;
            }
            case "$cosh": {
                function = DVTNumber::$cosh;
                break;
            }
            case "$tanh": {
                function = DVTNumber::$tanh;
                break;
            }
            case "$asinh": {
                function = DVTNumber::$asinh;
                break;
            }
            case "$acosh": {
                function = DVTNumber::$acosh;
                break;
            }
            case "$atanh": {
                function = DVTNumber::$atanh;
                break;
            }
            case "$unsigned": {
                function = DVTNumber::$unsigned;
                break;
            }
            case "$signed": {
                function = DVTNumber::$signed;
                break;
            }
            case "$countones": {
                function = DVTNumber::$countones;
                break;
            }
            case "$isunknown": {
                function = DVTNumber::$isunknown;
                break;
            }
            case "$countbits": {
                biFunction = DVTNumber::$countbits;
                break;
            }
            case "$onehot": {
                function = DVTNumber::$onehot;
                break;
            }
            case "$onehot0": {
                function = DVTNumber::$onehot0;
                break;
            }
            case "$test$plusargs": {
                function = DVTNumber::$test$plusargs;
                break;
            }
        }
        if (function != null || biFunction != null) {
            IRfNamedElement origin = origContext != null ? origContext.getOrigin() : null;
            IELParamValue arg1Value = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)iterator.next(), (IHidEvaluator)origEvaluator, (BitVectorContext)BitVectorContext.of((IRfNamedElement)origin, (boolean)false), (IHidEvaluationGuardian)guardian));
            if (ELUtils.isUnsuccessfulEval((IELParamValue)arg1Value)) {
                return null;
            }
            if (!ELUtils.isParamValueNumber((IELParamValue)arg1Value)) {
                throw new UnknownHidObjectEvaluationException((IHidObject)this);
            }
            IELParamValue finalValueSystemCall = null;
            if (biFunction != null) {
                if ($COUNTBITS.equals(methodName) && rawArguments.size() > 1) {
                    int partialResult = 0;
                    HashSet<IELParamValue> controlBits = new HashSet<IELParamValue>();
                    while (iterator.hasNext()) {
                        IELParamValue controlBitValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)iterator.next(), (IHidEvaluator)origEvaluator, (BitVectorContext)BitVectorContext.of((IRfNamedElement)origin, (boolean)false), (IHidEvaluationGuardian)guardian));
                        if (ELUtils.isUnsuccessfulEval((IELParamValue)controlBitValue)) {
                            return null;
                        }
                        if (controlBitValue == null || !ELUtils.isParamValueNumber((IELParamValue)controlBitValue)) {
                            throw new UnknownHidObjectEvaluationException((IHidObject)this);
                        }
                        controlBits.add(controlBitValue);
                    }
                    for (IELParamValue controlBit : controlBits) {
                        partialResult += ((DVTNumber)biFunction.apply(arg1Value.getDVTNumber(), controlBit.getDVTNumber())).intValue();
                    }
                    finalValueSystemCall = ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(partialResult)));
                } else {
                    IELParamValue arg2Value;
                    IELParamValue iELParamValue = arg2Value = rawArguments.size() > 1 ? XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)iterator.next(), (IHidEvaluator)origEvaluator, (BitVectorContext)BitVectorContext.of((IRfNamedElement)origin, (boolean)false), (IHidEvaluationGuardian)guardian)) : null;
                    if (ELUtils.isUnsuccessfulEval(arg2Value)) {
                        return null;
                    }
                    if (arg2Value == null || !ELUtils.isParamValueNumber(arg2Value)) {
                        throw new UnknownHidObjectEvaluationException((IHidObject)this);
                    }
                    finalValueSystemCall = ELParamValues.ParamValueNumber.of((DVTNumber)((DVTNumber)biFunction.apply(arg1Value.getDVTNumber(), arg2Value.getDVTNumber())));
                }
            } else if (function != null) {
                if (origEvaluator.isInterpreter() && $TEST$PLUSARGS.equals(methodName)) {
                    String stringValue = ELUtils.valueToString((IELParamValue)arg1Value);
                    if (origEvaluator instanceof XValueHolder) {
                        boolean testPlusarg = ((XValueHolder)origEvaluator).getFactory().getTestPlusarg(stringValue);
                        finalValueSystemCall = ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)(testPlusarg ? BigInteger.ONE : BigInteger.ZERO)));
                    }
                } else {
                    finalValueSystemCall = ELParamValues.ParamValueNumber.of((DVTNumber)((DVTNumber)function.apply(arg1Value.getDVTNumber())));
                }
            }
            if (manager != null) {
                manager.state.incrementSystemMethodCallsSuccEvals(finalValueSystemCall);
            }
            return finalValueSystemCall;
        }
        switch (methodName) {
            case "$bits": {
                function = DVTNumber::$bits;
                break;
            }
            case "$size": {
                biFunction = DVTNumber::$size;
                break;
            }
            case "$left": {
                biFunction = DVTNumber::$left;
                break;
            }
            case "$right": {
                biFunction = DVTNumber::$right;
                break;
            }
            case "$high": {
                biFunction = DVTNumber::$high;
                break;
            }
            case "$low": {
                biFunction = DVTNumber::$low;
                break;
            }
            case "$increment": {
                biFunction = DVTNumber::$increment;
                break;
            }
            case "$dimensions": {
                function = DVTNumber::$dimensions;
                break;
            }
            case "$unpacked_dimensions": {
                function = DVTNumber::$unpackedDimensions;
                break;
            }
        }
        if (function != null || biFunction != null) {
            IRfNamedElement origin = origContext != null ? origContext.getOrigin() : null;
            IHidObject arg1HidObject = iterator.next();
            if ($SIZE.equals(methodName) && !(arg1HidObject instanceof Hid) && !(arg1HidObject instanceof RfHidAccess) && !(arg1HidObject instanceof HidImplicit)) {
                throw new UnknownHidObjectEvaluationException(arg1HidObject);
            }
            IELParamValue arg1Value = null;
            boolean tmp = guardian.setEvaluateForSize(true);
            try {
                arg1Value = XUtils.getValue((ELParamValueScope)ELUtils.evaluateForSize((IHidObject)arg1HidObject, (IHidEvaluator)origEvaluator, (IRfNamedElement)origin, (IHidEvaluationGuardian)guardian));
                if (ELUtils.isUnsuccessfulEval((IELParamValue)arg1Value)) {
                    throw new UnknownHidObjectEvaluationException(arg1HidObject);
                }
            }
            finally {
                guardian.setEvaluateForSize(tmp);
            }
            if ($BITS.equals(methodName) && origEvaluator.isInterpreter() && function != null && arg1Value instanceof XValueHolder) {
                int size = ((XValueHolder)arg1Value).getSize();
                if (size < 0) {
                    return null;
                }
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(size)));
            }
            IRfNamedElement element = arg1Value.getElement();
            if ($DIMENSIONS.equals(methodName) && origEvaluator.isInterpreter() && (arg1Value instanceof XArrayValueHolder || element == null && arg1Value instanceof ELParamValues.ParamValueNumber)) {
                return RfHidAccessArgs.$dimension(arg1Value);
            }
            if ($UNPACKED_DIMENSIONS.equals(methodName) && origEvaluator.isInterpreter()) {
                int nofDimensions = 0;
                if (arg1Value instanceof XArrayValueHolder) {
                    ++nofDimensions;
                    IELParamValue itemElementValue = ((XArrayValueHolder)arg1Value).getItemElementValue();
                    while (itemElementValue instanceof XArrayValueHolder) {
                        ++nofDimensions;
                        itemElementValue = ((XArrayValueHolder)itemElementValue).getItemElementValue();
                    }
                }
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)false, (int)31, (int)0, (BigInteger)BigInteger.valueOf(nofDimensions)));
            }
            if (biFunction != null) {
                int[] dimension;
                arg1Value = origEvaluator.isInterpreter() ? XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)arg1HidObject, (IHidEvaluator)origEvaluator, (BitVectorContext)BitVectorContext.of((IRfNamedElement)origin, (boolean)false), (IHidEvaluationGuardian)guardian)) : arg1Value;
                IELParamValue arg2Value = rawArguments.size() > 1 ? XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)iterator.next(), (IHidEvaluator)origEvaluator, (BitVectorContext)BitVectorContext.of((IRfNamedElement)origin, (boolean)false), (IHidEvaluationGuardian)guardian)) : null;
                if ((arg1Value = RfHidAccessArgs.getRefferedArrayByDimension(arg1Value, arg2Value, dimension = new int[1])) instanceof XArrayValueHolder) {
                    return RfHidAccessArgs.executeSVOpenArrayQuery(methodName, arg1Value);
                }
                VlogBitVector secondParam = VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(dimension[0]));
                IELParamValue finalValueSystemCall = ELParamValues.ParamValueNumber.of((DVTNumber)((DVTNumber)biFunction.apply(arg1Value.getDVTNumber(), secondParam)));
                if (manager != null) {
                    manager.state.incrementSystemMethodCallsSuccEvals(finalValueSystemCall);
                }
                return finalValueSystemCall;
            }
            if (!(arg1Value instanceof ELParamValues.ParamValueNumber) && !(arg1Value instanceof ELParamValues.ParamValueType)) {
                throw new UnknownHidObjectEvaluationException((IHidObject)this);
            }
            if (function != null) {
                IELParamValue finalValueSystemCall = ELParamValues.ParamValueNumber.of((DVTNumber)((DVTNumber)function.apply(arg1Value.getDVTNumber())));
                if (manager != null) {
                    manager.state.incrementSystemMethodCallsSuccEvals(finalValueSystemCall);
                }
                return finalValueSystemCall;
            }
        }
        if ("$typename".equals(methodName) && iterator.hasNext()) {
            RfTypesResolver typesResolver = RfTypesResolver.create(origEvaluator, guardian.getOriginElement(), guardian.getHierarchyPath(), 0, true);
            typesResolver.setIsExpressionTypeComputation(true);
            IHidObject argExpression = iterator.next();
            ELParamValueScope result = ELUtils.evaluate((IHidObject)argExpression, (IHidEvaluator)typesResolver, (BitVectorContext)origContext, (IHidEvaluationGuardian)guardian);
            if (ELUtils.isUnsuccessfulEval((ELParamValueScope)result) || !(result.value instanceof ELParamValues.ParamValueType)) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            IRfNamedElement typeCandidate = result.value.getNamedElement();
            if (!(typeCandidate instanceof IRfTypeElement)) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            String typeName = typeCandidate.getQualifiedName();
            int nofBits = typeName.length() * 8;
            byte[] specifiedBytes = typeName.getBytes(IDVTConstants.ASCII);
            int[] nArray = new int[2];
            nArray[0] = nofBits - 1;
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)false, (int)(nofBits - 1), (int)0, (int[])nArray, (boolean)false, (boolean)true, (BigInteger)new BigInteger(specifiedBytes)));
        }
        throw new UnknownHidObjectEvaluationException((IHidObject)this);
    }

    public static IELParamValue $dimension(IELParamValue arg1Value) {
        IRfNamedElement element = arg1Value.getElement();
        if (element == null && arg1Value instanceof ELParamValues.ParamValueNumber) {
            DVTNumber dvtNumber = arg1Value.getDVTNumber();
            return ELParamValues.ParamValueNumber.of((DVTNumber)DVTNumber.$dimensions((DVTNumber)dvtNumber));
        }
        if (arg1Value instanceof XArrayValueHolder) {
            int nofDimensions = 0;
            ++nofDimensions;
            IELParamValue itemElementValue = ((XArrayValueHolder)arg1Value).getItemElementValue();
            while (itemElementValue instanceof XArrayValueHolder) {
                ++nofDimensions;
                itemElementValue = ((XArrayValueHolder)itemElementValue).getItemElementValue();
            }
            if (itemElementValue instanceof ELParamValues.ParamValueNumber) {
                DVTNumber dvtNumber = itemElementValue.getDVTNumber();
                nofDimensions += DVTNumber.$dimensions((DVTNumber)dvtNumber).intValue();
            }
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)false, (int)31, (int)0, (BigInteger)BigInteger.valueOf(nofDimensions)));
        }
        return IELParamValue.UNDEFINED_VALUE;
    }

    public static IELParamValue executeSVOpenArrayQuery(String methodName, IELParamValue arg1Value) {
        if ($SIZE.equals(methodName)) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(((XArrayValueHolder)arg1Value).$size())));
        }
        if ($LEFT.equals(methodName)) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(((XArrayValueHolder)arg1Value).$left())));
        }
        if ($RIGHT.equals(methodName)) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(((XArrayValueHolder)arg1Value).$right())));
        }
        if ($INCREMENT.equals(methodName)) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(((XArrayValueHolder)arg1Value).$increment())));
        }
        if ($LOW.equals(methodName)) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(((XArrayValueHolder)arg1Value).$low())));
        }
        if ($HIGH.equals(methodName)) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(((XArrayValueHolder)arg1Value).$high())));
        }
        return IELParamValue.UNDEFINED_VALUE;
    }

    public static IELParamValue getRefferedArrayByDimension(IELParamValue arg1Value, IELParamValue arg2Value, int[] dimension) {
        if (arg2Value != null && ELUtils.isParamValueNumber((IELParamValue)arg2Value)) {
            dimension[0] = arg2Value.getDVTNumber().intValue() - 1;
            while (dimension[0] > 0 && arg1Value instanceof XArrayValueHolder) {
                arg1Value = ((XArrayValueHolder)arg1Value).getItemElementValue();
                dimension[0] = dimension[0] - 1;
            }
        }
        return arg1Value;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public XCValue collectConstraints(XCModel model, IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
        if (this.parentHid == null) {
            return null;
        }
        String parentHidName = this.parentHid.getName();
        try {
            MethodCall methodCall = this.getMethodCall(guardian);
            if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty()) {
                BitVectorContext defaultContext = BitVectorContext.of((IRfNamedElement)(context != null ? context.getOrigin() : null), (boolean)true);
                ELParamValueScope value = this.evaluateInterpreter(evaluator, defaultContext, guardian);
                if (value == null) {
                    return null;
                }
                if (model.isRandListSumVariable(parentHidName, value, this.parentHid)) {
                    XCValue sumXCValue = model.createVariable(parentHidName, ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.ZERO)), (IHidEvaluator)value.scope), true, guardian);
                    XArrayValueHolder arrayValueHolder = value.getArrayValueHolder("sum");
                    if (arrayValueHolder != null && arrayValueHolder.isFixedSizeArray()) {
                        String sumVarName = sumXCValue.getIntVar().getName();
                        int index = sumVarName.lastIndexOf(".");
                        String namePrefix = sumVarName.substring(0, index);
                        int computedSize = arrayValueHolder.size();
                        IntVariable sumConstraint = null;
                        int i = 0;
                        while (i < computedSize) {
                            if (model.getSolver().isInterrupted()) break;
                            String name = DVTStringUtil.appendString((Object[])new Object[]{namePrefix, "[", i, "]"});
                            XCValue itemXCValue = model.getLeafVariable(name);
                            if (sumXCValue != null && !model.getSolver().isInterrupted()) {
                                sumConstraint = sumConstraint == null ? itemXCValue.getIntVar() : sumConstraint.add(itemXCValue.getIntVar());
                            }
                            ++i;
                        }
                        if (sumXCValue != null) {
                            sumXCValue.getIntVar().eq(sumConstraint).post();
                        }
                    }
                    return sumXCValue;
                }
                if (model.isRandListSizeVariable(parentHidName, value, this.parentHid)) {
                    XCValue xCVariable = model.createVariable(parentHidName, value, true, guardian);
                    xCVariable.getIntVar().setDomain((IDomain)new IntDomain(BigInteger.ZERO, xCVariable.getIntVar().getDomain().getUpperBound()));
                    return xCVariable;
                }
                return model.createConstant(value.value, guardian);
            }
            IELParamValue valueForSize = XUtils.getValue((ELParamValueScope)this.evaluateForSize(evaluator, context == null ? null : context.getOrigin(), guardian));
            DVTNumber dvtNumber = valueForSize.getDVTNumber();
            int size = dvtNumber.getSize();
            boolean sign = dvtNumber.hasSign();
            BigInteger lb = sign ? VlogBitVector.getPowerOfTwo((int)(size - 1)).negate() : BigInteger.ZERO;
            BigInteger ub = sign ? VlogBitVector.getPowerOfTwoMask((int)(size - 1)) : VlogBitVector.getPowerOfTwoMask((int)size);
            boolean isCountOnes = parentHidName.equals($COUNTONES);
            boolean isCountBits = parentHidName.equals($COUNTBITS);
            boolean isOneHot = $ONEHOT.equals(parentHidName);
            boolean isOneHot0 = $ONEHOT0.equals(parentHidName);
            ArrayList<XCValue> argumentXCValues = new ArrayList<XCValue>();
            ArrayList<IntVariable> inputVars = new ArrayList<IntVariable>();
            BitVectorContext noContext = BitVectorContext.of((IRfNamedElement)(context == null ? null : context.getOrigin()), (boolean)false);
            IHidObject firstArgHidObject = null;
            if (methodCall.argumentValuesMapRaw != null && !methodCall.argumentValuesMapRaw.isEmpty()) {
                for (IHidObject hidObject : methodCall.argumentValuesMapRaw.values()) {
                    if (firstArgHidObject == null) {
                        firstArgHidObject = hidObject;
                    }
                    this.collectInputVariables(model, evaluator, context, guardian, inputVars, (ListContainer<IHidObject>)hidObject);
                    if (!isCountOnes && !isCountBits && !isOneHot && !isOneHot0) continue;
                    XCValue argumentXCValue = hidObject.collectConstraints(model, evaluator, noContext, guardian.copy());
                    argumentXCValues.add(argumentXCValue);
                }
            }
            IntVariable argIntVar = argumentXCValues.isEmpty() ? null : ((XCValue)argumentXCValues.get(0)).getIntVar();
            XValueHolderFactory factory = guardian.getFactory();
            if (isCountBits && (argIntVar == null || argumentXCValues.size() != 2)) {
                guardian.logError("$countbits unsupported number of argumens");
            }
            if (isCountOnes && (argIntVar == null || argumentXCValues.size() != 1)) {
                guardian.logError("$countbits unsupported number of argumens");
            }
            if ((isOneHot || isOneHot0) && (argIntVar == null || argumentXCValues.size() != 1)) {
                guardian.logError("$onehot/$onehot0 unsupported number of argumens");
            }
            if ((isCountOnes || isCountBits || isOneHot || isOneHot0) && argIntVar != null) {
                BigInteger arg1Value;
                BigInteger bigInteger = arg1Value = isCountBits ? ((XCValue)argumentXCValues.get(1)).getIntVar().value() : BigInteger.ONE;
                if (arg1Value.equals(BigInteger.ONE)) {
                    isCountOnes = true;
                } else {
                    isCountOnes = true;
                    argIntVar.setSigned(false);
                    argIntVar = argIntVar.not();
                }
                IHidObject argHidObject = (IHidObject)methodCall.argumentValuesMapRaw.values().iterator().next();
                IELParamValue argValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)argHidObject, (IHidEvaluator)evaluator, (BitVectorContext)context, (IHidEvaluationGuardian)guardian));
                if (argIntVar.isInstantiated()) {
                    IELParamValue value = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)this, (IHidEvaluator)evaluator, (BitVectorContext)context, (IHidEvaluationGuardian)guardian));
                    return model.createVariable(model.intVar(null, true, 32, value.bigIntegerValue()), true, null);
                }
                if (argIntVar.isAnonymous()) {
                    String name = "$countones_arg_expr_" + factory.getUniqueId();
                    argIntVar.setName(name);
                    model.putLeafVariable(name, model.createVariable(argIntVar, true, null));
                }
                argIntVar.setNonRandom(true);
                IntVariable[] countVar = new IntVariable[1];
                int nofBits = argIntVar.nofBits();
                int inputVarsMaxNofBits = inputVars.isEmpty() ? argIntVar.nofBits() : inputVars.stream().map(IntVariable::nofBits).mapToInt(Integer::intValue).max().orElse(0);
                int i = 0;
                while (i < nofBits) {
                    VlogBitVector indexBitVector = VlogBitVector.createConstant((int)i);
                    XComputedSelect computedSelect = new XComputedSelect(null, new IELParamValue[]{ELParamValues.ParamValueNumber.of((DVTNumber)indexBitVector)});
                    XSelectProxy selectProxy = new XSelectProxy(argValue, (ListContainer)computedSelect, noContext, guardian);
                    IELParamValue selArgValue = XValueHolderFactory.createSelectProxyValue((IELParamValue)argValue, (XSelectProxy)selectProxy, (boolean)false, (boolean)true, (LanguageKind)LanguageKind.VLOG);
                    XCValue tempVar = model.createSelectVariable(argIntVar.getName(), ELParamValueScope.of((IELParamValue)argValue), ELParamValueScope.of((IELParamValue)selArgValue), true, guardian);
                    countVar[0] = countVar[0] == null ? tempVar.getIntVar() : countVar[0].add(tempVar.getIntVar());
                    if (nofBits > 2) {
                        tempVar.getIntVar().setRandomCandidateDelegate((domain, searchStrategy, random, store) -> {
                            if (BigInteger.ONE.equals(domain.size())) {
                                return domain.getLowerBound();
                            }
                            int lowerBound = countVar[0].getDomain().getLowerBound().intValue();
                            int upperBound = countVar[0].getDomain().getUpperBound().intValue();
                            if (inputVarsMaxNofBits < 16) {
                                return domain.randomCandidate(IDomain.SearchStrategy.RANDOM, random);
                            }
                            if (lowerBound > nofBits / 2 && lowerBound != nofBits) {
                                int next = random.nextInt(nofBits / (nofBits - lowerBound) / 2);
                                return next == 0 ? BigInteger.ZERO : BigInteger.ONE;
                            }
                            if (upperBound < nofBits / 2 && upperBound != 0) {
                                int next = random.nextInt(nofBits / upperBound / 2);
                                return next == 0 ? BigInteger.ONE : BigInteger.ZERO;
                            }
                            return domain.randomCandidate(IDomain.SearchStrategy.RANDOM, random);
                        });
                    }
                    ++i;
                }
                if (isOneHot) {
                    countVar[0] = countVar[0].eq(model.getCachedConstant(true, 32, BigInteger.ONE)).reify();
                } else if (isOneHot0) {
                    countVar[0] = countVar[0].le(model.getCachedConstant(true, 32, BigInteger.ONE)).reify();
                }
                return model.createVariable(countVar[0], true, null);
            }
            IntVariable outputVar = new IntVariable((Model)model, sign, size, lb, ub);
            Method.IMethodExecutor methodExecutor = inputs -> {
                model.partialUpdateValues(guardian);
                IELParamValue result = XUtils.getValue((ELParamValueScope)this.evaluate(evaluator, context, guardian.copy()));
                return new IntVariable(null, true, -1, result.bigIntegerValue(), null);
            };
            outputVar.call(parentHidName, methodExecutor, (Variable[])inputVars.toArray(new IntVariable[inputVars.size()]));
            return model.createVariable(outputVar, true, null);
        }
        catch (UnknownHidObjectEvaluationException unknownHidObjectEvaluationException) {
            guardian.logError("System call not implemented? " + parentHidName);
            return null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private void collectInputVariables(XCModel model, IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian, List<IntVariable> inputVars, ListContainer<IHidObject> hidObjects) {
        if (hidObjects == null || hidObjects.isEmpty()) {
            return;
        }
        for (IHidObject hidObject : hidObjects) {
            XCValue inputXCVar = null;
            if (hidObject instanceof RfHid) {
                inputXCVar = hidObject.collectConstraints(model, evaluator, context, guardian.copy());
            } else if (hidObject instanceof RfHidAccess) {
                inputXCVar = hidObject.collectConstraints(model, evaluator, context, guardian.copy());
            } else if (hidObject instanceof RfHidAccessArgs) {
                List<? extends IHidObject> arguments = ((RfHidAccessArgs)hidObject).getArgumentValues();
                for (IHidObject argument : arguments) {
                    this.collectInputVariables(model, evaluator, context, guardian, inputVars, (ListContainer<IHidObject>)argument);
                }
            } else if (hidObject instanceof RfHidOperator) {
                this.collectInputVariables(model, evaluator, context, guardian, inputVars, (ListContainer<IHidObject>)((RfHidOperator)hidObject).getLHValue());
                this.collectInputVariables(model, evaluator, context, guardian, inputVars, (ListContainer<IHidObject>)((RfHidOperator)hidObject).getRHValues());
            }
            if (inputXCVar == null) continue;
            IntVariable intVar = inputXCVar.getIntVar();
            inputVars.add(intVar);
        }
    }

    private IELParamValue computesPrintfSformatf(MethodCall methodCall, IHidEvaluator origEvaluator, BitVectorContext origContext, IHidEvaluationGuardian guardian, ELManager manager, Iterator<IHidObject> iterator) {
        String resultString;
        IHidObject formatStringHidObject;
        block14: {
            formatStringHidObject = iterator.next();
            String formatStringName = null;
            if (formatStringHidObject instanceof RfHidImplicit && ((RfHidImplicit)formatStringHidObject).isStringLiteral()) {
                formatStringName = ((RfHidImplicit)formatStringHidObject).getName();
            } else {
                IELParamValue eval = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)formatStringHidObject, (IHidEvaluator)origEvaluator, (BitVectorContext)BitVectorContext.of((IRfNamedElement)(origContext != null ? origContext.getOrigin() : null), (boolean)false), (IHidEvaluationGuardian)guardian));
                if (!(eval instanceof ELParamValues.ParamValueNumber)) {
                    throw new UnknownHidObjectEvaluationException(formatStringHidObject);
                }
                DVTNumber number = ((ELParamValues.ParamValueNumber)eval).getDVTNumber();
                if (!DVTNumber.isString((DVTNumber)number)) {
                    throw new UnknownHidObjectEvaluationException(formatStringHidObject);
                }
                formatStringName = number.toString();
            }
            if (formatStringName.length() < 2) {
                throw new UnknownHidObjectEvaluationException(formatStringHidObject);
            }
            ArrayDeque<IELParamValue> queueArgs = new ArrayDeque<IELParamValue>();
            while (iterator.hasNext()) {
                IHidObject currentArgHid = iterator.next();
                IELParamValue paramEvaluated = null;
                if (currentArgHid instanceof RfHidImplicit && ((RfHidImplicit)currentArgHid).isStringLiteral()) {
                    String rfHidImplicitName = ((RfHidImplicit)currentArgHid).getName();
                    paramEvaluated = ELUtils.stringToValue((String)rfHidImplicitName.substring(1, rfHidImplicitName.length() - 1));
                } else {
                    paramEvaluated = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)currentArgHid, (IHidEvaluator)origEvaluator, (BitVectorContext)BitVectorContext.of((IRfNamedElement)(origContext != null ? origContext.getOrigin() : null), (boolean)false), (IHidEvaluationGuardian)guardian));
                }
                if (paramEvaluated == null) {
                    throw new UnknownHidObjectEvaluationException(currentArgHid);
                }
                queueArgs.add(paramEvaluated);
            }
            String noQuoteName = formatStringName.substring(1, formatStringName.length() - 1);
            Object[] objects = queueArgs.toArray();
            resultString = null;
            try {
                resultString = new XStringFormatter(origEvaluator, true).format(noQuoteName, objects).toString();
            }
            catch (Exception ex) {
                IRfNamedElement enclosingScope;
                if (!(ex instanceof MissingFormatArgumentException)) {
                    throw ex;
                }
                IRfNamedElement iRfNamedElement = enclosingScope = origContext == null ? null : origContext.getOrigin();
                if (formatStringHidObject instanceof RfHidImplicit || enclosingScope == null) break block14;
                String formatSpecificer = ((MissingFormatArgumentException)ex).getFormatSpecifier();
                IHidObject methodCallHidObject = methodCall.methodHidObject;
                IHid functionHid = HidUtils.getHidFrom((IHidObject)methodCallHidObject);
                String errorMessage = MessageFormat.format("MISSING_ARG_FORMAT_SPEC: Missing argument for ''%{0}'' when calling ''{1}''", formatSpecificer, functionHid.getName());
                if (manager == null || enclosingScope == null) break block14;
                manager.reportProblem(1, ElaborationDebugZone.SECOND_PASS, false, errorMessage, enclosingScope, enclosingScope.getDeclaration(), enclosingScope.getOffset(), enclosingScope.getOffset() + enclosingScope.getName().length(), enclosingScope.getLine(), null, null, new Object[0]);
            }
        }
        if (resultString == null) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        if (resultString.contains("NA.NA")) {
            throw new UnknownHidObjectEvaluationException(formatStringHidObject);
        }
        return ELUtils.stringToValue((String)resultString);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean visitHidObject(IRfSingleLangProject rfProject, IHidVisitor visitor) {
        block35: {
            block33: {
                if (!super.visitHidObject(rfProject, visitor)) {
                    return false;
                }
                if (!visitor.enterMethodArguments()) {
                    return true;
                }
                argumentValues = this.argumentValues;
                if (argumentValues == null) {
                    return true;
                }
                parentHid = this.getParentHid();
                parentHidName = parentHid == null ? null : parentHid.getName();
                parentHidElement = parentHid != null ? parentHid.getElement() : null;
                isExportDpi = parentHid != null && parentHidElement instanceof RfPredefinedFunction == false && RfHid.getValidDefElement(parentHidElement) == null;
                isSystemCall = parentHidName != null && parentHidName.length() > 0 && parentHidName.charAt(0) == '$';
                isUnresolvedSystemCall = isSystemCall != false && HidUtils.isResolved((IHidObject)parentHid) == false;
                isLetFunction = parentHidElement instanceof RfFunction != false && ((RfFunction)parentHidElement).isLet() != false;
                isResolvable = isExportDpi == false && isUnresolvedSystemCall == false;
                arguments = null;
                try {
                    if (!(visitor instanceof SEvaluator.VlogSemanticOperatorVisitor)) break block33;
                    if (!isResolvable) {
                        return true;
                    }
                    if (isSystemCall) {
                        return true;
                    }
                    if (isLetFunction) {
                        return true;
                    }
                    if (parentHid == null) {
                        return true;
                    }
                    if (parentHid.getElement() instanceof RfFunction) {
                        arguments = ((RfFunction)parentHid.getElement()).getArgumentsWithPrefix("", 2);
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            i = 0;
            while (i < argumentValues.size()) {
                block36: {
                    block34: {
                        if (!HidUtils.isOperator((IHidObject)((IHidObject)argumentValues.get(i)))) break block36;
                        try {
                            if (visitor instanceof SEvaluator.VlogSemanticOperatorVisitor) {
                                info = new SMethodCallInfo(this.parentHid, i, arguments);
                                ((SEvaluator.VlogSemanticOperatorVisitor)visitor).setInfo(info);
                            }
                            if (visitor instanceof IReferenceHidOperatorVisitor) {
                                info = new SMethodCallInfo(this.parentHid, i, arguments);
                                ((IReferenceHidOperatorVisitor)visitor).setInfo(info);
                            }
                            if (visitor instanceof R2LTooltipManager.TooltipHidOperatorVisitor) {
                                info = new SMethodCallInfo(this.parentHid, i, arguments);
                                ((R2LTooltipManager.TooltipHidOperatorVisitor)visitor).setInfo(info);
                            }
                            flattened = HidUtils.flattenToOperators((IHidOperator)((IHidOperator)argumentValues.get(i)));
                            var16_19 = flattened.iterator();
                            ** GOTO lbl-1000
                            while ((operator = (IHidOperator)var16_19.next()).visitHidObject(rfProject, visitor)) lbl-1000:
                            // 2 sources

                            {
                                if (var16_19.hasNext()) continue;
                                break block34;
                            }
                            break block35;
                        }
                        catch (Throwable var17_20) {
                            if (visitor instanceof SEvaluator.VlogSemanticOperatorVisitor) {
                                ((SEvaluator.VlogSemanticOperatorVisitor)visitor).setInfo(null);
                            }
                            if (visitor instanceof IReferenceHidOperatorVisitor) {
                                ((IReferenceHidOperatorVisitor)visitor).setInfo(null);
                            }
                            if (visitor instanceof R2LTooltipManager.TooltipHidOperatorVisitor) {
                                ((R2LTooltipManager.TooltipHidOperatorVisitor)visitor).setInfo(null);
                            }
                            throw var17_20;
                        }
                        {
                            catch (OperationCanceledException | BuildCancelException | ElementFromCursorDetectionException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                DVTLogger.INSTANCE.logError((Throwable)e);
                                if (visitor instanceof SEvaluator.VlogSemanticOperatorVisitor) {
                                    ((SEvaluator.VlogSemanticOperatorVisitor)visitor).setInfo(null);
                                }
                                if (visitor instanceof IReferenceHidOperatorVisitor) {
                                    ((IReferenceHidOperatorVisitor)visitor).setInfo(null);
                                }
                                if (visitor instanceof R2LTooltipManager.TooltipHidOperatorVisitor) {
                                    ((R2LTooltipManager.TooltipHidOperatorVisitor)visitor).setInfo(null);
                                }
                                break block36;
                                break;
                            }
                        }
                    }
                    if (visitor instanceof SEvaluator.VlogSemanticOperatorVisitor) {
                        ((SEvaluator.VlogSemanticOperatorVisitor)visitor).setInfo(null);
                    }
                    if (visitor instanceof IReferenceHidOperatorVisitor) {
                        ((IReferenceHidOperatorVisitor)visitor).setInfo(null);
                    }
                    if (visitor instanceof R2LTooltipManager.TooltipHidOperatorVisitor) {
                        ((R2LTooltipManager.TooltipHidOperatorVisitor)visitor).setInfo(null);
                    }
                }
                ++i;
            }
            return true;
        }
        if (visitor instanceof SEvaluator.VlogSemanticOperatorVisitor) {
            ((SEvaluator.VlogSemanticOperatorVisitor)visitor).setInfo(null);
        }
        if (visitor instanceof IReferenceHidOperatorVisitor) {
            ((IReferenceHidOperatorVisitor)visitor).setInfo(null);
        }
        if (visitor instanceof R2LTooltipManager.TooltipHidOperatorVisitor) {
            ((R2LTooltipManager.TooltipHidOperatorVisitor)visitor).setInfo(null);
        }
        return false;
    }

    public HidOperatorWrapper xGetWithClause() {
        HidOperator hidOperator = this.getWithClause();
        if (hidOperator == null || this.parentHid == null) {
            return null;
        }
        IRfNamedElement functionCall = this.parentHid.getSecondaryScope();
        if (functionCall == null || functionCall.getDeclaration() == null) {
            VlogMacroZone macroZone = ((RfHid)this.parentHid).getMacroZone();
            return HidOperatorWrapper.of((HidOperator)hidOperator, (ParserPath)(macroZone != null ? macroZone.getParserPath() : null));
        }
        IRfDefElement declaration = functionCall.getDeclaration();
        return HidOperatorScopeWrapper.of((HidOperator)hidOperator, (IRfNamedElement)functionCall, (ParserPath)declaration.getParserPath());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.argumentValues == null ? 0 : this.argumentValues.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RfHidAccessArgs)) {
            return false;
        }
        RfHidAccessArgs other = (RfHidAccessArgs)((Object)obj);
        return !(this.argumentValues == null ? other.argumentValues != null : !this.argumentValues.equals(other.argumentValues));
    }
}

