/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.semantic.extension;

import java.math.BigInteger;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Pattern;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.SkippedHidObjectEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.LRUCache;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.VlogRealNumber;
import ro.amiq.dvt.utils.XArrayAssignmentPatternBitVectorContext;
import ro.amiq.dvt.utils.XGlobalCache;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfScalarType;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.IRfHidImplicitLayer;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

public class RfHidImplicit
extends HidImplicit
implements IRfHidImplicitLayer {
    private static final long serialVersionUID = 5L;
    public static final RfHidImplicit DEFAULT_1NS = new RfHidImplicit("1ns", 283);
    public static final RfHidImplicit ZERO_BIT = new RfHidImplicit("1'b0", 555);
    public static final RfHidImplicit ONE_BIT = new RfHidImplicit("1'b1", 555);
    public static final RfHidImplicit X_BIT = new RfHidImplicit("1'bx", 555);
    public static final RfHidImplicit EMPTY = new RfHidImplicit("", IHidImplicitConstants.ImplicitType.EMPTY.id);
    private static final int CACHE_LIMIT = 1024;
    private static final Map<RfHidImplicit, RfHidImplicit> cache = new LRUCache(1024);
    private static final int CACHE_INSIDE_MACRO_LIMIT = 128;
    private static final Map<RfHidImplicit, RfHidImplicit> cacheInsideMacro = new LRUCache(128);

    private static RfHidImplicit getFromCache(RfHidImplicit implicit, Map<RfHidImplicit, RfHidImplicit> cache) {
        if (implicit == null) {
            return null;
        }
        RfHidImplicit found = cache.get(implicit);
        if (found == null) {
            found = implicit;
            cache.put(implicit, implicit);
        }
        return found;
    }

    private RfHidImplicit(String name, int type) {
        super(DVTStringUtil.unescapeIdentifier((String)name, (boolean)false), type);
    }

    public static RfHidImplicit makeImplicit(String text, int type) {
        return RfHidImplicit.getFromCache(new RfHidImplicit(text, type), cache);
    }

    public static RfHidImplicit makeImplicit(String text, int type, ReparseInfo reparseInfo) {
        if (reparseInfo == null || reparseInfo.getLastReparseElement() == null) {
            return RfHidImplicit.makeImplicit(text, type);
        }
        return RfHidImplicitInsideMacro.makeImplicit(text, type, reparseInfo);
    }

    public Number parseNumberValue() {
        return this.isNumber() ? (Number)DVTStringUtil.parseNumberVLOG((String)this.name, null, (boolean)false) : (Number)null;
    }

    public static void cleanCaches() {
        cache.clear();
        cacheInsideMacro.clear();
    }

    public String guessTypeName(boolean translateType) {
        int type = this.getType();
        switch (type) {
            case 557: {
                return "string";
            }
            case 282: 
            case 555: 
            case 560: {
                if (this.name == null) {
                    return "integer";
                }
                if (this.name.indexOf(46) >= 0) {
                    return "real";
                }
                return "integer";
            }
        }
        return null;
    }

    public ELParamValueScope evaluateForSize(IHidEvaluator evaluator, IRfNamedElement origin, IHidEvaluationGuardian guardian) {
        if (guardian.shouldSkip((IHidObject)this)) {
            throw new SkippedHidObjectEvaluationException((IHidObject)this);
        }
        guardian.checkBuildCanceled();
        if (this.isNumber()) {
            if (this.isRealtimeNumber() && this.name.length() > 1) {
                return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)VlogRealNumber.create((double)0.0)));
            }
            if (this.name.length() == 2 && this.name.charAt(0) == '\'' && ("'1".equals(this.name) || "'0".equals(this.name) || "'x".equals(this.name) || "'X".equals(this.name) || "'z".equals(this.name) || "'Z".equals(this.name) || "'?".equals(this.name))) {
                VlogBitVector bitVector = VlogBitVector.create((boolean)false, (int)0, (int)0, null, (boolean)false, (boolean)false, (BigInteger)BigInteger.ZERO);
                return guardian.isEvaluateForSize() ? ELParamValueScope.UNDEFINED_VALUE : ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)bitVector));
            }
            DVTNumber result = XGlobalCache.INSTANCE.getImplicit(this.name);
            if (result != null) {
                return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)result));
            }
            BitSet[] tmpMask = new BitSet[2];
            int[] nofBits = new int[]{-1, -1, -1};
            Number number = ELUtils.parseNumberVLOG((String)this.name, null, (BitSet[])tmpMask, null, (int[])nofBits, (boolean)this.isRealtimeNumber());
            if (number instanceof BigInteger) {
                int nofBitsFinal = nofBits[0];
                EnumMap<MaskType, BitSet> masks = null;
                if (tmpMask[0] != null || tmpMask[1] != null) {
                    masks = new EnumMap<MaskType, BitSet>(MaskType.class);
                    if (tmpMask[0] != null && !tmpMask[0].isEmpty()) {
                        masks.put(MaskType.X, VlogBitVector.createMask((int)nofBitsFinal, (BitSet)tmpMask[0]));
                    }
                    if (tmpMask[1] != null && !tmpMask[1].isEmpty()) {
                        masks.put(MaskType.Z, VlogBitVector.createMask((int)nofBitsFinal, (BitSet)tmpMask[1]));
                    }
                    if (masks.isEmpty()) {
                        masks = null;
                    }
                }
                result = VlogBitVector.create((boolean)this.isSigned(), (int)(nofBitsFinal - 1), (int)0, null, (boolean)true, (boolean)false, (boolean)false, (boolean)false, null, masks, (BigInteger)((BigInteger)number));
                XGlobalCache.INSTANCE.putImplicit(this.name, result);
                return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)result));
            }
            if (number != null && number.floatValue() == Float.MAX_VALUE) {
                try {
                    String noUnderscoreName = RfHidImplicit.toNoUnderscoreName(this.name);
                    char possibleAMSUnit = noUnderscoreName.charAt(noUnderscoreName.length() - 1);
                    String floatUnit = null;
                    if (possibleAMSUnit == 'M') {
                        floatUnit = "e6";
                    } else if (possibleAMSUnit == 'K' || possibleAMSUnit == 'k') {
                        floatUnit = "e3";
                    } else if (possibleAMSUnit == 'm') {
                        floatUnit = "e-3";
                    } else if (possibleAMSUnit == 'u') {
                        floatUnit = "e-6";
                    } else if (possibleAMSUnit == 'n') {
                        floatUnit = "e-9";
                    } else if (possibleAMSUnit == 'p') {
                        floatUnit = "e-12";
                    } else if (possibleAMSUnit == 'f') {
                        floatUnit = "e-15";
                    } else if (possibleAMSUnit == 'a') {
                        floatUnit = "e-18";
                    }
                    result = floatUnit != null ? new VlogRealNumber(Double.parseDouble(String.valueOf(noUnderscoreName.substring(0, noUnderscoreName.length() - 1)) + floatUnit)) : new VlogRealNumber(Double.parseDouble(noUnderscoreName));
                    XGlobalCache.INSTANCE.putImplicit(this.name, result);
                    return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)result));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new UnknownHidObjectEvaluationException((IHidObject)this);
                }
            }
            throw new UnknownHidObjectEvaluationException((IHidObject)this);
        }
        if (this.isID()) {
            if (origin == null) {
                ELParamValueScope value = evaluator.getValue((IHid)this, BitVectorContext.of((IRfNamedElement)origin, (boolean)true), guardian);
                return XUtils.getValue((ELParamValueScope)value) != null ? ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)value.getDVTNumber())) : ELParamValueScope.UNDEFINED_VALUE;
            }
            IRfNamedElement resolvedElement = origin.semanticGetMember(this.getName(), null, null, origin, null, true, true, false);
            if (resolvedElement == null) {
                throw new UnknownHidObjectEvaluationException((IHidObject)this);
            }
            Hid dummyTypeHid = STransformer.BUILDERS.buildHid(this.name, resolvedElement, HidOccurrence.DUMMY_OCCURRENCE, 0L);
            if (dummyTypeHid == null) {
                throw new UnknownHidObjectEvaluationException((IHidObject)this);
            }
            ELParamValueScope value = evaluator.getValue((IHid)dummyTypeHid, BitVectorContext.of((IRfNamedElement)origin, (boolean)true), guardian);
            return XUtils.getValue((ELParamValueScope)value) != null ? ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)value.getDVTNumber())) : ELParamValueScope.UNDEFINED_VALUE;
        }
        if (this.isLiteralPredefinedScalar()) {
            RfScalarType scalarType = RfProject.getScalarType(this.name);
            if (scalarType == null) {
                throw new UnknownHidObjectEvaluationException((IHidObject)this);
            }
            BitVectorContext sizeContext = scalarType.getBitVectorContext(evaluator, guardian, origin);
            if (sizeContext == null || sizeContext.getContextNumber() == null) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)sizeContext.getContextNumber()));
        }
        if (this.isStringLiteral()) {
            return this.evaluateString(null);
        }
        if (this.isDollar()) {
            return ELParamValueScope.UNDEFINED_VALUE;
        }
        if (this.isEmptyJump() || this.isLiteralNull()) {
            return ELParamValueScope.UNDEFINED_VALUE;
        }
        throw new UnknownHidObjectEvaluationException((IHidObject)this);
    }

    public boolean isDisableFork() {
        return 106 == this.getType();
    }

    public int evaluateTimescale() {
        String numberName = this.name;
        int exponentTime = 1;
        if (numberName.length() > 1) {
            exponentTime = XUtils.timeUnitExponent((String)numberName);
            int endOffset = exponentTime == 15 ? 1 : 2;
            numberName = this.name.substring(0, this.name.length() - endOffset).trim();
        }
        if (numberName.equals("100")) {
            return exponentTime + 2;
        }
        if (numberName.equals("10")) {
            return exponentTime + 1;
        }
        if (numberName.equals("1")) {
            return exponentTime;
        }
        throw new UnknownHidObjectEvaluationException((IHidObject)this);
    }

    public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
        if (guardian.shouldSkip((IHidObject)this)) {
            throw new SkippedHidObjectEvaluationException((IHidObject)this);
        }
        guardian.checkBuildCanceled();
        guardian.incrementStepCount();
        if (this.isDollar()) {
            if (context == null) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            XArrayValueHolder arraySelectSource = context.getArraySelectSource();
            if (arraySelectSource == null) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            int size = arraySelectSource.size();
            IELParamValue topIndex = ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf((long)size - 1L)));
            return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((IELParamValue)(context != null ? context.transform(topIndex) : topIndex)));
        }
        if (this.isNumber()) {
            VlogBitVector bitVector;
            int nofBits;
            boolean isDoNotCache;
            String numberName = this.name;
            int exponentTime = 0;
            boolean bl = isDoNotCache = this.name.charAt(0) == '\'';
            if (this.isRealtimeNumber() && numberName.length() > 1) {
                if (evaluator.isInterpreter() && evaluator instanceof XValueHolder) {
                    exponentTime = XUtils.timeUnitExponent((String)numberName);
                    endOffset = exponentTime == 15 ? 1 : 2;
                    XGlobalCache.TimeScale timeScale = XUtils.getTimeScale((XValueHolder)((XValueHolder)evaluator));
                    exponentTime -= timeScale.unitExponent;
                    numberName = this.name.substring(0, this.name.length() - endOffset).trim();
                    isDoNotCache = true;
                } else if (context != null && context.getOrigin() != null) {
                    exponentTime = XUtils.timeUnitExponent((String)numberName);
                    endOffset = exponentTime == 15 ? 1 : 2;
                    IRfNamedElement timescaleScope = context.getTimescaleScope();
                    if (timescaleScope != null) {
                        XGlobalCache.TimeScale timeScale = XUtils.getTimescaleFromElement((IRfNamedElement)timescaleScope);
                        exponentTime -= timeScale.unitExponent;
                    }
                    numberName = this.name.substring(0, this.name.length() - endOffset).trim();
                    isDoNotCache = true;
                } else {
                    throw new UnknownHidObjectEvaluationException((IHidObject)this);
                }
            }
            if ("'1".equals(numberName)) {
                nofBits = context != null ? context.getSize() : 1;
                bitVector = VlogBitVector.create((boolean)false, (int)(nofBits - 1), (int)0, null, (boolean)false, (boolean)false, (BigInteger)VlogBitVector.getPowerOfTwoMask((int)nofBits));
                return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)(context != null ? context.transform((DVTNumber)bitVector) : bitVector)));
            }
            if ("'0".equals(numberName)) {
                nofBits = context != null ? context.getSize() : 1;
                bitVector = VlogBitVector.create((boolean)false, (int)(nofBits - 1), (int)0, null, (boolean)false, (boolean)false, (BigInteger)BigInteger.ZERO);
                return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)(context != null ? context.transform((DVTNumber)bitVector) : bitVector)));
            }
            if (numberName.length() == 2 && ("'x".equals(numberName) || "'X".equals(numberName) || "'z".equals(numberName) || "'Z".equals(numberName) || "'?".equals(numberName))) {
                nofBits = context != null ? context.getSize() : 1;
                boolean isX = "'x".equals(numberName) || "'X".equals(numberName);
                VlogBitVector bitVector2 = isX ? VlogBitVector.all((MaskType)MaskType.X, (int)nofBits) : VlogBitVector.all((MaskType)MaskType.Z, (int)nofBits);
                return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)(context != null ? context.transform((DVTNumber)bitVector2) : bitVector2)));
            }
            DVTNumber result = null;
            if (!isDoNotCache) {
                result = XGlobalCache.INSTANCE.getImplicit(numberName);
            }
            if (result != null) {
                return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)(context != null ? context.transform(result) : result)));
            }
            BitSet[] tmpMask = new BitSet[2];
            int[] nofBits2 = new int[]{-1, -1, -1};
            Number number = ELUtils.parseNumberVLOG((String)numberName, null, (BitSet[])tmpMask, (BitVectorContext)context, (int[])nofBits2, (boolean)this.isRealtimeNumber());
            if (number instanceof BigInteger) {
                int nofBitsFinal = nofBits2[0];
                EnumMap<MaskType, BitSet> masks = null;
                if (tmpMask[0] != null || tmpMask[1] != null) {
                    masks = new EnumMap<MaskType, BitSet>(MaskType.class);
                    if (tmpMask[0] != null && !tmpMask[0].isEmpty()) {
                        masks.put(MaskType.X, VlogBitVector.createMask((int)nofBitsFinal, (BitSet)tmpMask[0]));
                    }
                    if (tmpMask[1] != null && !tmpMask[1].isEmpty()) {
                        masks.put(MaskType.Z, VlogBitVector.createMask((int)nofBitsFinal, (BitSet)tmpMask[1]));
                    }
                    if (masks.isEmpty()) {
                        masks = null;
                    }
                }
                if (this.isRealtimeNumber()) {
                    double factor = StrictMath.pow(10.0, Math.abs(exponentTime));
                    double realtimeNumber = number.doubleValue();
                    if (exponentTime > 0) {
                        realtimeNumber = (double)number.longValue() * factor;
                    } else if (exponentTime < 0) {
                        realtimeNumber = (double)number.longValue() / factor;
                    }
                    result = new VlogRealNumber(realtimeNumber);
                } else {
                    boolean startsWithUnknown;
                    result = VlogBitVector.create((boolean)this.isSigned(), (int)(nofBitsFinal - 1), (int)0, null, (boolean)true, (boolean)false, (boolean)false, (boolean)false, null, masks, (BigInteger)((BigInteger)number));
                    boolean bl2 = startsWithUnknown = masks != null && (masks.get(MaskType.X) != null && this.hasLeading1((BitSet)masks.get(MaskType.X), nofBitsFinal) || masks.get(MaskType.Z) != null && this.hasLeading1((BitSet)masks.get(MaskType.Z), nofBitsFinal));
                    if (this.name.charAt(0) == '\'' && startsWithUnknown) {
                        return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)(context != null ? context.transformUnsizedXLiteral((VlogBitVector)result) : result)));
                    }
                }
            } else if (number instanceof Float && number.floatValue() == Float.MAX_VALUE) {
                try {
                    String noUnderscoreName = RfHidImplicit.toNoUnderscoreName(numberName);
                    char possibleAMSUnit = noUnderscoreName.charAt(noUnderscoreName.length() - 1);
                    int floatUnit = 0;
                    if (Character.isLetter(possibleAMSUnit)) {
                        if (possibleAMSUnit == 'M') {
                            floatUnit = 6;
                        } else if (possibleAMSUnit == 'K' || possibleAMSUnit == 'k') {
                            floatUnit = 3;
                        } else if (possibleAMSUnit == 'm') {
                            floatUnit = -3;
                        } else if (possibleAMSUnit == 'u') {
                            floatUnit = -6;
                        } else if (possibleAMSUnit == 'n') {
                            floatUnit = -9;
                        } else if (possibleAMSUnit == 'p') {
                            floatUnit = -12;
                        } else if (possibleAMSUnit == 'f') {
                            floatUnit = -15;
                        } else if (possibleAMSUnit == 'a') {
                            floatUnit = -18;
                        }
                        if (floatUnit != 0) {
                            noUnderscoreName = noUnderscoreName.substring(0, noUnderscoreName.length() - 1);
                        }
                    }
                    if ((floatUnit += exponentTime) != 0) {
                        result = new VlogRealNumber(Double.valueOf(String.valueOf(noUnderscoreName) + "e" + floatUnit).doubleValue());
                    }
                    result = new VlogRealNumber(Double.valueOf(noUnderscoreName).doubleValue());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new UnknownHidObjectEvaluationException((IHidObject)this);
                }
            } else {
                throw new UnknownHidObjectEvaluationException((IHidObject)this);
            }
            if (!isDoNotCache) {
                XGlobalCache.INSTANCE.putImplicit(numberName, result);
            }
            return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)(context != null ? context.transform(result) : result)));
        }
        if (this.isID()) {
            IRfNamedElement origin;
            String name = this.getName();
            if (name.startsWith("struct/") || name.startsWith("enum/") || name.startsWith("union/")) {
                return evaluator.getValue((IHid)this, context, guardian);
            }
            IRfNamedElement iRfNamedElement = origin = context != null ? context.getOrigin() : null;
            if (origin == null) {
                return evaluator.getValue((IHid)this, BitVectorContext.of((IRfNamedElement)origin, (boolean)true), guardian);
            }
            IRfNamedElement resolvedElement = origin.semanticGetMember(name, null, null, origin, null, true, true, false);
            if (resolvedElement == null) {
                throw new UnknownHidObjectEvaluationException((IHidObject)this);
            }
            Hid dummyTypeHid = STransformer.BUILDERS.buildHid(name, resolvedElement, HidOccurrence.DUMMY_OCCURRENCE, 0L);
            if (dummyTypeHid == null) {
                throw new UnknownHidObjectEvaluationException((IHidObject)this);
            }
            return evaluator.getValue((IHid)dummyTypeHid, context, guardian);
        }
        if (this.isLiteralPredefinedScalar()) {
            RfScalarType scalarType = RfProject.getScalarType(this.name);
            if (scalarType == null) {
                throw new UnknownHidObjectEvaluationException((IHidObject)this);
            }
            BitVectorContext scalarContext = scalarType.getBitVectorContext(evaluator, guardian, scalarType);
            if (scalarContext != null) {
                return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueType.of((IRfNamedElement)scalarType, (DVTNumber)scalarContext.getContextNumber()));
            }
            throw new UnknownHidObjectEvaluationException((IHidObject)this);
        }
        if (this.isStringLiteral()) {
            return this.evaluateString(context);
        }
        if (this.isEmptyQueue() && context != null) {
            if (context.isString()) {
                return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)false, (int)0, (int)0, (int[])new int[2], (boolean)false, (boolean)true)));
            }
            if (context instanceof XArrayAssignmentPatternBitVectorContext) {
                return ELParamValueScope.of((IELParamValue)((XArrayAssignmentPatternBitVectorContext)context).getLeftValue().newHolder());
            }
        }
        if (this.isEmptyJump()) {
            return ELParamValueScope.IMPLICIT_RESULT;
        }
        if (this.isLiteralNull()) {
            return ELParamValueScope.of((IELParamValue)IELParamValue.NULL_VALUE);
        }
        if (this.isEmptyType()) {
            return evaluator instanceof RfTypesResolver ? evaluator.getValue((IHid)this, context, guardian) : ELParamValueScope.of((IELParamValue)IELParamValue.EMPTY_VALUE);
        }
        throw new UnknownHidObjectEvaluationException((IHidObject)this);
    }

    private ELParamValueScope evaluateString(BitVectorContext context) {
        if (this.name.length() <= 2) {
            return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)(context != null ? context.transform((DVTNumber)VlogBitVector.EMPTY_STRING_CHARACTER) : VlogBitVector.EMPTY_STRING_CHARACTER)));
        }
        DVTNumber result = XGlobalCache.INSTANCE.getImplicit(this.name);
        if (result != null) {
            return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)(context != null ? context.transform(result) : result)));
        }
        String noQuoteName = DVTStringUtil.unquoteStringContent((String)this.name.substring(1, this.name.length() - 1));
        noQuoteName = DVTStringUtil.replaceDynamicAll((Pattern)DVTStringUtil.SPECIAL_CHARS_PATTERN, (CharSequence)noQuoteName, m -> {
            String group = m.group(1);
            int number = group.charAt(0) == 'x' ? Integer.parseInt(group.substring(1), 16) : Integer.parseInt(group, 8);
            return Character.toString((char)number);
        });
        int nofBits = noQuoteName.length() * 8;
        byte[] specifiedBytes = noQuoteName.getBytes(IDVTConstants.ASCII);
        if (specifiedBytes == null) {
            throw new UnknownHidObjectEvaluationException((IHidObject)this);
        }
        int[] nArray = new int[2];
        nArray[1] = nofBits - 1;
        result = VlogBitVector.create((boolean)false, (int)(nofBits - 1), (int)0, (int[])nArray, (boolean)false, (boolean)true, (BigInteger)new BigInteger(specifiedBytes));
        XGlobalCache.INSTANCE.putImplicit(this.name, result);
        return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)(context != null ? context.transform(result) : result)));
    }

    private boolean hasLeading1(BitSet number, int nofBits) {
        return number != null && number.get(nofBits - 1);
    }

    private static String toNoUnderscoreName(String name) {
        StringBuilder sb = new StringBuilder();
        int length = name.length();
        int i = 0;
        while (i < length) {
            char currChar = name.charAt(i);
            if (currChar != '_') {
                sb.append(currChar);
            }
            ++i;
        }
        return sb.toString();
    }

    private boolean isSigned() {
        int charSign;
        int index = this.name.indexOf(39);
        if (index < 0) {
            return true;
        }
        int n = charSign = index + 1 < this.name.length() ? (int)this.name.charAt(index + 1) : 48;
        return charSign == 115 || charSign == 83;
    }

    public IHid xToHid(IRfNamedElement enclosingScope, HidOccurrence occurrence) {
        IRfNamedElement member = enclosingScope == null ? null : enclosingScope.getLocalMember(null, this.name, null);
        return RfHid.create(this.name, null, member, occurrence, null);
    }

    private static class RfHidImplicitInsideMacro
    extends RfHidImplicit {
        private static final long serialVersionUID = 4L;
        private transient ReparseInfo reparseInfo;

        public static RfHidImplicit makeImplicit(String text, int type, ReparseInfo reparseInfo) {
            return RfHidImplicit.getFromCache(new RfHidImplicitInsideMacro(text, type, reparseInfo), cacheInsideMacro);
        }

        private RfHidImplicitInsideMacro(String name, int type, ReparseInfo reparseInfo) {
            super(name, type);
            this.reparseInfo = reparseInfo;
        }

        public IReparseInfo getReparseInfo() {
            return this.reparseInfo;
        }

        public ReparseInfo.ReparseElement getLastReparseElement() {
            if (this.reparseInfo == null) {
                return null;
            }
            return this.reparseInfo.getLastReparseElement();
        }

        public int hashCode() {
            ReparseInfo.ReparseElement reparseElement = this.getLastReparseElement();
            if (reparseElement == null) {
                return 0;
            }
            VlogMacroInfo reparseMacroInfo = reparseElement.getTransientReparseMacroInfo();
            if (reparseMacroInfo == null || reparseMacroInfo.getName() == null) {
                return 0;
            }
            int result = super.hashCode();
            result = 31 * result + this.reparseInfo.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RfHidImplicitInsideMacro other = (RfHidImplicitInsideMacro)obj;
            return !(this.reparseInfo == null ? other.reparseInfo != null : !this.reparseInfo.equals(other.reparseInfo));
        }
    }
}

