/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.semantic.extension;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.IRfAssertExpectElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.assertion.AssertTM;
import ro.amiq.dvt.model.reflection.assertion.AssertTMAbstractTransition;
import ro.amiq.dvt.model.reflection.assertion.AssertTMBinaryTransition;
import ro.amiq.dvt.model.reflection.assertion.AssertTMOppositeTransition;
import ro.amiq.dvt.model.reflection.assertion.AssertTMState;
import ro.amiq.dvt.model.reflection.assertion.IAssertTMState;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalConverter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;

public class RfPropertySequenceConverter {
    private final IHidObject propertySequence;
    private final IRfAssertExpectElement assertElement;
    private final IHidEvaluationGuardian guardian;
    private final IHidEvaluator evaluator;
    private final AssertTM assertTM;

    public static RfPropertySequenceConverter create(IHidObject propertySequence, IRfAssertExpectElement assertElement, IHidEvaluator evaluator, HidOperator alwaysEventControlOperator, IHidEvaluationGuardian guardian) {
        return new RfPropertySequenceConverter(propertySequence, assertElement, evaluator, alwaysEventControlOperator, guardian);
    }

    private RfPropertySequenceConverter(IHidObject propertySequence, IRfAssertExpectElement assertElement, IHidEvaluator evaluator, HidOperator alwaysEventControlOperator, IHidEvaluationGuardian guardian) {
        this.propertySequence = propertySequence;
        this.assertElement = assertElement;
        this.guardian = guardian;
        this.evaluator = evaluator;
        this.assertTM = AssertTM.of((IRfAssertExpectElement)assertElement);
        if (alwaysEventControlOperator != null) {
            this.assertTM.handleClockingEvent((IHidOperator)alwaysEventControlOperator);
            this.assertTM.setAlwaysBlockScoped(true);
        }
    }

    static IRfNamedElement getPropertyElement(IHidObject object) {
        IHidObject hidObject = object;
        if (object instanceof HidAccess) {
            hidObject = ((HidAccess)object).getParentHid();
        }
        return HidUtils.getResolvedElement((IHidObject)hidObject);
    }

    private AssertTM convertTuringMachine(IHidObject origin) {
        int lineNumber;
        if (origin == null) {
            return null;
        }
        RfHidOperator rootOperator = (RfHidOperator)origin;
        AssertTMState[] lastState = new AssertTMState[]{this.assertTM.getHead()};
        this.buildFSM((IHidObject)(rootOperator.isPropertySpec() && rootOperator.getOperatorKind() == IHidOperatorConstants.OperatorKind.UNARY_OPERATOR ? rootOperator.getLHValue() : rootOperator), (IAssertTMState[])lastState, this.assertTM.getFailure());
        this.assertTM.addTransition((IAssertTMState)lastState[0], (IAssertTMState)this.assertTM.getSuccess(), this.assertTM.getFailure(), this.assertTM);
        this.assertTM.setHids(HidUtils.flattenToHids((IHidObject)origin, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED));
        IRfDefElement declaration = this.assertElement.getDeclaration();
        ParserPath path = declaration != null ? declaration.getParserPath() : new ParserPath("<unknown>");
        int n = lineNumber = declaration != null ? declaration.getStartLine() : -1;
        if (lastState[0] == this.assertTM.getHead() || this.assertTM.states.isEmpty() || this.assertTM.transitionTable.keySet().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(DVTStringUtil.appendString((Object[])new Object[]{"*** Error: Fail to translate assertion '", this.assertElement.getName(), "'. Converted in '", HidUtils.toNiceString((IHidObject)origin), "'", System.lineSeparator()}));
            sb.append(DVTStringUtil.appendString((Object[])new Object[]{"    at line ", lineNumber, " in ", path, System.lineSeparator()}));
            this.guardian.logMessage(sb.toString());
            return null;
        }
        if (this.guardian.isAddExtraDebugInfo()) {
            StringBuilder sb = new StringBuilder();
            sb.append(DVTStringUtil.appendString((Object[])new Object[]{"*** Warning: Concurrent Assert: '", this.assertElement.getName(), "' converted in '", HidUtils.toNiceString((IHidObject)origin), "'", System.lineSeparator()}));
            if (this.assertTM.disableIffCondition != null) {
                sb.append(DVTStringUtil.appendString((Object[])new Object[]{"    ", "disable iff: '", HidUtils.toNiceString((IHidObject)this.assertTM.disableIffCondition), "'", System.lineSeparator()}));
            }
            sb.append(this.assertTM.toString("    "));
            sb.append(DVTStringUtil.appendString((Object[])new Object[]{"    at line ", lineNumber, " in ", path, System.lineSeparator()}));
            this.guardian.logMessage(sb.toString());
        }
        this.guardian.getFactory().registerAssertTM(((XValueHolder)this.evaluator).getInstanceScope(), this.assertElement, this.assertTM);
        return this.assertTM;
    }

    private IAssertTMState buildFSM(IHidObject object, IAssertTMState[] lastState, AssertTMState lastFailState) {
        if (object == null) {
            return null;
        }
        if (HidUtils.isHid((IHidObject)object) || HidUtils.isHidAccess((IHidObject)object) || HidUtils.isHidImplicit((IHidObject)object)) {
            IAssertTMState currentLastState;
            IAssertTMState newState = this.assertTM.createState(object, lastState[0], this.assertTM);
            lastState[0] = currentLastState = this.assertTM.addTransition(lastState[0], newState, lastFailState, this.assertTM);
            return newState;
        }
        if (HidUtils.isOperator((IHidObject)object)) {
            IAssertTMState currentLastState;
            RfHidOperator operator = (RfHidOperator)object;
            if (operator.isPropertySpec()) {
                if (operator.getOperatorKind() == IHidOperatorConstants.OperatorKind.UNARY_OPERATOR) {
                    return this.buildFSM(operator.getLHValue(), lastState, lastFailState);
                }
                lastState[0] = this.buildFSM(operator.getLHValue(), lastState, lastFailState);
                ListContainer rhValues = operator.getRHValues();
                int idx = rhValues.size() - 1;
                while (idx >= 0) {
                    IAssertTMState nextState;
                    lastState[0] = nextState = this.buildFSM((IHidObject)rhValues.get(idx), lastState, lastFailState);
                    --idx;
                }
                return lastState[0];
            }
            if (operator.getOperatorKind() == IHidOperatorConstants.OperatorKind.UNARY_OPERATOR) {
                IAssertTMState currentLastState2;
                if (operator.isEventControl()) {
                    this.assertTM.handleClockingEvent((IHidOperator)operator);
                }
                if (operator.isNotOperator()) {
                    return this.handleNotOperator(lastState, operator, lastFailState);
                }
                IAssertTMState newState = this.assertTM.createState((IHidObject)operator, lastState[0], this.assertTM);
                lastState[0] = currentLastState2 = this.assertTM.addTransition(lastState[0], newState, lastFailState, this.assertTM);
                return currentLastState2;
            }
            IHidObject lhValue = operator.getLHValue();
            ListContainer rhValues = operator.getRHValues();
            if (operator.isAssertBinary()) {
                IAssertTMState currentLastState3;
                AssertTMState.AssertStateKind kind;
                if (!operator.hasRHValues()) {
                    return null;
                }
                int operatorType = operator.getOperatorType();
                Object object2 = operatorType == 30 ? AssertTMState.AssertStateKind.AND : (operatorType == 161 ? AssertTMState.AssertStateKind.OR : (kind = operatorType == 134 ? AssertTMState.AssertStateKind.INTERSECT : null));
                if (kind == null) {
                    throw new UnknownHidObjectEvaluationException((IHidObject)operator);
                }
                AssertTMState.AssertTMStateExecute binaryBegin = new AssertTMState.AssertTMStateExecute(kind, this.assertTM){

                    public IHidObject execute(IHidObject hidObject, IHidEvaluator evaluator, AssertTM.AssertTMCursor cursor, IHidEvaluationGuardian guardian) {
                        if (cursor instanceof AssertTM.AssertTMCursorBinary var5_6 && binaryCursor.getChildrenCursors().size() == 2) {
                            guardian.callbackYieldThread(false);
                            return null;
                        }
                        IRfDefElement declaration = RfPropertySequenceConverter.this.assertElement.getDeclaration();
                        ParserPath parserPath = declaration.getParserPath();
                        XThread xLHThread = guardian.startConcurrentAssertionCursor((IHidOperator)hidObject, RfPropertySequenceConverter.this.assertElement.getName(), hidObject, evaluator, parserPath, cursor, AssertTM.AssertTMCursor.AssertTMCursorKind.OR);
                        if (xLHThread == null) {
                            return null;
                        }
                        XThread xRHThread = guardian.startConcurrentAssertionCursor((IHidOperator)hidObject, RfPropertySequenceConverter.this.assertElement.getName(), hidObject, evaluator, parserPath, cursor, AssertTM.AssertTMCursor.AssertTMCursorKind.OR);
                        if (xRHThread == null) {
                            return null;
                        }
                        cursor.moveToJoinState();
                        cursor.setFlag(8);
                        guardian.callbackYieldThread(false);
                        return null;
                    }
                };
                binaryBegin.setAdditionalText("start");
                AssertTMState.AssertTMStateExecute binaryLHFailState = new AssertTMState.AssertTMStateExecute(AssertTMState.AssertStateKind.FAIL, this.assertTM){

                    public IHidObject execute(IHidObject hidObject, IHidEvaluator evaluator, AssertTM.AssertTMCursor cursor, IHidEvaluationGuardian guardian) {
                        cursor.consume(false, guardian);
                        return null;
                    }
                };
                binaryLHFailState.setAdditionalText("binary LH");
                lastState[0] = currentLastState3 = this.assertTM.addTransition(lastState[0], (IAssertTMState)binaryBegin, lastFailState, this.assertTM);
                this.assertTM.createTransition((IHidOperator)operator, currentLastState3, lastFailState);
                IAssertTMState lhLastState = this.buildFSM(lhValue, lastState, (AssertTMState)binaryLHFailState);
                AssertTMState.AssertTMStateExecute lhSuccessState = new AssertTMState.AssertTMStateExecute(AssertTMState.AssertStateKind.SUCCESS, this.assertTM){

                    public IHidObject execute(IHidObject hidObject, IHidEvaluator evaluator, AssertTM.AssertTMCursor cursor, IHidEvaluationGuardian guardian) {
                        cursor.consume(true, guardian);
                        return null;
                    }
                };
                lhSuccessState.setAdditionalText("LH");
                this.assertTM.addTransition(lhLastState, (IAssertTMState)lhSuccessState, (AssertTMState)binaryLHFailState, this.assertTM);
                AssertTMState.AssertTMStateExecute binaryRHFailState = new AssertTMState.AssertTMStateExecute(AssertTMState.AssertStateKind.FAIL, this.assertTM){

                    public IHidObject execute(IHidObject hidObject, IHidEvaluator evaluator, AssertTM.AssertTMCursor cursor, IHidEvaluationGuardian guardian) {
                        cursor.consume(false, guardian);
                        return null;
                    }
                };
                binaryRHFailState.setAdditionalText("binary RH");
                lastState[0] = binaryBegin;
                IAssertTMState rhLastState = this.buildFSM(operator.getFirstRHValue(), lastState, (AssertTMState)binaryRHFailState);
                AssertTMState.AssertTMStateExecute rhSuccessState = new AssertTMState.AssertTMStateExecute(AssertTMState.AssertStateKind.SUCCESS, this.assertTM){

                    public IHidObject execute(IHidObject hidObject, IHidEvaluator evaluator, AssertTM.AssertTMCursor cursor, IHidEvaluationGuardian guardian) {
                        cursor.consume(true, guardian);
                        return null;
                    }
                };
                rhSuccessState.setAdditionalText("RH");
                this.assertTM.addTransition(rhLastState, (IAssertTMState)rhSuccessState, (AssertTMState)binaryRHFailState, this.assertTM);
                AssertTMState.AssertTMStateExecute binaryJoinState = new AssertTMState.AssertTMStateExecute(kind, this.assertTM){

                    public IHidObject execute(IHidObject hidObject, IHidEvaluator evaluator, AssertTM.AssertTMCursor cursor, IHidEvaluationGuardian guardian) {
                        List childrenCursors = cursor.getChildrenCursors();
                        if (childrenCursors.size() != 2) {
                            throw new IllegalStateException("Binary cursor should have two children");
                        }
                        AssertTM.AssertTMCursor candidateLHCursor = (AssertTM.AssertTMCursor)childrenCursors.get(0);
                        AssertTM.AssertTMCursor candidateRHCursor = (AssertTM.AssertTMCursor)childrenCursors.get(1);
                        if (!(candidateLHCursor instanceof AssertTM.AssertTMCursorBinary) || !(candidateRHCursor instanceof AssertTM.AssertTMCursorBinary)) {
                            throw new IllegalStateException("Binary cursor should have two binary children cursors");
                        }
                        AssertTM.AssertTMCursorBinary lhCursor = (AssertTM.AssertTMCursorBinary)candidateLHCursor;
                        AssertTM.AssertTMCursorBinary rhCursor = (AssertTM.AssertTMCursorBinary)candidateRHCursor;
                        AssertTMState.AssertStateKind kind = this.getKind();
                        AtomicBoolean atomicLHResult = lhCursor.getResult();
                        AtomicBoolean atomicRHResult = rhCursor.getResult();
                        boolean lhResult = atomicLHResult != null && atomicLHResult.get();
                        boolean rhResult = atomicRHResult != null && atomicRHResult.get();
                        AssertTMState.AssertTMStateExecute failState = (AssertTMState.AssertTMStateExecute)((AssertTMAbstractTransition)RfPropertySequenceConverter.this.assertTM.transitionTable.get((Object)this)).getFailState();
                        HidImplicit trueState = STransformer.BUILDERS.buildImplicit("1", IHidImplicitConstants.ImplicitType.QUA_NUMBER.id);
                        switch (kind) {
                            case OR: {
                                if (lhResult | rhResult) {
                                    cursor.removeChildren();
                                    return trueState;
                                }
                                if (atomicLHResult != null && atomicRHResult != null) {
                                    cursor.removeChildren();
                                    return failState.execute(hidObject, evaluator, cursor, guardian);
                                }
                                cursor.setFlag(8);
                                guardian.callbackYieldThread(false);
                                return null;
                            }
                            case AND: {
                                if (lhResult & rhResult) {
                                    cursor.removeChildren();
                                    return trueState;
                                }
                                if (atomicLHResult != null && atomicRHResult != null) {
                                    cursor.removeChildren();
                                    return failState.execute(hidObject, evaluator, (AssertTM.AssertTMCursor)rhCursor, guardian);
                                }
                                if (atomicLHResult != null && !lhResult) {
                                    cursor.removeChildren();
                                    guardian.callbackKill(rhCursor.getXThread().getId());
                                    return failState.execute(hidObject, evaluator, (AssertTM.AssertTMCursor)rhCursor, guardian);
                                }
                                if (atomicRHResult != null && !rhResult) {
                                    cursor.removeChildren();
                                    guardian.callbackKill(lhCursor.getXThread().getId());
                                    return failState.execute(hidObject, evaluator, (AssertTM.AssertTMCursor)rhCursor, guardian);
                                }
                                cursor.setFlag(8);
                                guardian.callbackYieldThread(false);
                                return null;
                            }
                        }
                        throw new UnsupportedOperationException("Unsupported cursor kind '" + kind + "'");
                    }

                    public IHidObject getHidObject() {
                        HidImplicit trueState = STransformer.BUILDERS.buildImplicit("1", IHidImplicitConstants.ImplicitType.QUA_NUMBER.id);
                        return trueState;
                    }
                };
                binaryJoinState.setAdditionalText("join");
                AssertTMAbstractTransition binaryTransition = (AssertTMAbstractTransition)this.assertTM.transitionTable.get(binaryBegin);
                if (!(binaryTransition instanceof AssertTMBinaryTransition)) {
                    return null;
                }
                ((AssertTMBinaryTransition)binaryTransition).setJoinState((IAssertTMState)binaryJoinState);
                lastState[0] = binaryJoinState;
                return binaryJoinState;
            }
            if (operator.isAssertSequential() || operator.isDisableIffExpr()) {
                IHidObject notOpCandidate;
                if (operator.isDisableIffExpr()) {
                    this.assertTM.disableIffCondition = ((IHidOperator)operator.getLHValue()).getLHValue();
                } else {
                    IAssertTMState leftState;
                    lastState[0] = leftState = this.buildFSM(lhValue, lastState, lastFailState);
                }
                if (!operator.hasRHValues()) {
                    return lastState[0];
                }
                if (operator.isOverlappingImplication()) {
                    this.assertTM.createTransition((IHidOperator)operator, lastState[0], lastFailState);
                }
                if (operator.isNonOverlappingImplication()) {
                    HidImplicit delayImplicit = this.assertTM.hidBuilders.buildImplicit("1", -1);
                    HidOperator cycleDelayOperator = this.assertTM.hidBuilders.buildCycleDelayConstOperator((IHidObject)delayImplicit, Collections.emptyList(), IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, HidOperatorOccurrence.DUMMY_OCCURRENCE);
                    IAssertTMState cycleDelayState = this.assertTM.createState((IHidObject)cycleDelayOperator, lastState[0], this.assertTM);
                    lastState[0] = this.assertTM.addTransition(lastState[0], cycleDelayState, lastFailState, (IHidOperator)operator, this.assertTM);
                    this.assertTM.createTransition((IHidOperator)operator, lastState[0], lastFailState);
                }
                if (HidUtils.isOperator((IHidObject)(notOpCandidate = operator.getFirstRHValue())) && ((IHidOperator)notOpCandidate).isNotOperator()) {
                    return this.handleNotOperator(lastState, (IHidOperator)notOpCandidate, lastFailState);
                }
                int idx = rhValues.size() - 1;
                while (idx >= 0) {
                    IAssertTMState nextState;
                    lastState[0] = nextState = this.buildFSM((IHidObject)rhValues.get(idx), lastState, lastFailState);
                    --idx;
                }
                return lastState[0];
            }
            if (operator.isSequenceAbbrev()) {
                IAssertTMState currentLastState2;
                IAssertTMState lastExprState;
                IAssertTMState currentLastState4;
                IHidOperator abbrevOperator = (IHidOperator)operator.getFirstRHValue();
                boolean isConstAbbrev = HidUtils.isHidImplicit((IHidObject)abbrevOperator.getLHValue());
                final HidImplicit trueState = STransformer.BUILDERS.buildImplicit("1", IHidImplicitConstants.ImplicitType.QUA_NUMBER.id);
                Object originState = isConstAbbrev ? this.assertTM.createState((IHidObject)trueState, lastState[0], this.assertTM) : new AssertTMState.AssertTMStateExecute(AssertTMState.AssertStateKind.ATOM, this.assertTM){

                    public IHidObject execute(IHidObject hidObject, IHidEvaluator evaluator, AssertTM.AssertTMCursor cursor, IHidEvaluationGuardian guardian) {
                        cursor.activateAbbrev();
                        return trueState;
                    }

                    public IHidObject getHidObject() {
                        return trueState;
                    }
                };
                lastState[0] = currentLastState4 = this.assertTM.addTransition(lastState[0], (IAssertTMState)originState, lastFailState, this.assertTM);
                IHidObject expr = operator.getLHValue();
                lastState[0] = lastExprState = this.buildFSM(expr, lastState, lastFailState);
                IAssertTMState turnArroundState = this.assertTM.createState(operator.getFirstRHValue(), lastState[0], this.assertTM);
                if (!(turnArroundState instanceof AssertTMState.AssertTMAbbrevDelay)) {
                    throw new IllegalStateException("Expected to create abbrev state from operator '" + HidUtils.toNiceString((IHidObject)operator) + "'");
                }
                ((AssertTMState.AssertTMAbbrevDelay)turnArroundState).setOriginState((IAssertTMState)originState);
                lastState[0] = currentLastState2 = this.assertTM.addTransition(lastState[0], turnArroundState, lastFailState, this.assertTM);
                return currentLastState2;
            }
            IAssertTMState newState = this.assertTM.createState((IHidObject)operator, lastState[0], this.assertTM);
            lastState[0] = currentLastState = this.assertTM.addTransition(lastState[0], newState, lastFailState, this.assertTM);
            return newState;
        }
        throw new UnknownHidObjectEvaluationException(object);
    }

    private IAssertTMState handleNotOperator(IAssertTMState[] lastState, IHidOperator notOperaetor, AssertTMState lastFailState) {
        IAssertTMState norExprLastState;
        IAssertTMState currentLastState;
        AssertTMState.AssertTMStateExecute notBegin = new AssertTMState.AssertTMStateExecute(AssertTMState.AssertStateKind.NOT, this.assertTM){

            public IHidObject execute(IHidObject hidObject, IHidEvaluator evaluator, AssertTM.AssertTMCursor cursor, IHidEvaluationGuardian guardian) {
                if (cursor instanceof AssertTM.AssertTMCursorNot var5_6 && !notCursor.getChildrenCursors().isEmpty()) {
                    guardian.callbackYieldThread(false);
                    return null;
                }
                IRfDefElement declaration = RfPropertySequenceConverter.this.assertElement.getDeclaration();
                ParserPath parserPath = declaration.getParserPath();
                XThread xThread = guardian.startConcurrentAssertionCursor((IHidOperator)hidObject, RfPropertySequenceConverter.this.assertElement.getName(), hidObject, evaluator, parserPath, cursor, AssertTM.AssertTMCursor.AssertTMCursorKind.NOT);
                if (xThread == null) {
                    return null;
                }
                guardian.callbackYieldThread(false);
                return null;
            }
        };
        notBegin.setAdditionalText("start ");
        AssertTMState.AssertTMStateExecute notFailState = new AssertTMState.AssertTMStateExecute(AssertTMState.AssertStateKind.FAIL, this.assertTM){

            public IHidObject execute(IHidObject hidObject, IHidEvaluator evaluator, AssertTM.AssertTMCursor cursor, IHidEvaluationGuardian guardian) {
                AssertTMAbstractTransition transition = (AssertTMAbstractTransition)RfPropertySequenceConverter.this.assertTM.transitionTable.get(cursor.getCurrentState());
                boolean result = transition != null && transition.getOperator() != null && (transition.getOperator().isOverlappingImplication() || transition.getOperator().isNonOverlappingImplication());
                cursor.consume(result, guardian);
                RfPropertySequenceConverter.this.assertTM.removeCursor(cursor);
                return null;
            }
        };
        notFailState.setAdditionalText("NOT");
        lastState[0] = currentLastState = this.assertTM.addTransition(lastState[0], (IAssertTMState)notBegin, lastFailState, this.assertTM);
        this.assertTM.createTransition(notOperaetor, currentLastState, (AssertTMState)notFailState);
        IHidObject notExpr = notOperaetor.getLHValue();
        lastState[0] = norExprLastState = this.buildFSM(notExpr, lastState, (AssertTMState)notFailState);
        AssertTMState.AssertTMStateExecute notEnd = new AssertTMState.AssertTMStateExecute(AssertTMState.AssertStateKind.NOT, this.assertTM){

            public IHidObject execute(IHidObject hidObject, IHidEvaluator evaluator, AssertTM.AssertTMCursor cursor, IHidEvaluationGuardian guardian) {
                try {
                    AtomicBoolean childResult = cursor.getChildResult();
                    if (childResult == null) {
                        guardian.callbackYieldThread(true);
                        return null;
                    }
                    boolean isNotPropertyOperatorSuccessEval = childResult.get();
                    AssertTMAbstractTransition assertTMAbstractTransition = (AssertTMAbstractTransition)RfPropertySequenceConverter.this.assertTM.transitionTable.get(cursor.getCurrentState());
                    if (isNotPropertyOperatorSuccessEval) {
                        AssertTMState.AssertTMStateExecute failState = (AssertTMState.AssertTMStateExecute)assertTMAbstractTransition.getFailState();
                        IHidObject iHidObject = failState.execute(hidObject, evaluator, cursor, guardian);
                        return iHidObject;
                    }
                    IAssertTMState nextState = cursor.nextState().getCurrentState();
                    if (nextState instanceof AssertTMState.AssertTMStateExecute) {
                        IHidObject iHidObject = ((AssertTMState.AssertTMStateExecute)nextState).execute(hidObject, evaluator, cursor, guardian);
                        return iHidObject;
                    }
                    IHidObject iHidObject = nextState.getHidObject();
                    return iHidObject;
                }
                finally {
                    cursor.resetChildResult();
                }
            }
        };
        notEnd.setAdditionalText("join");
        AssertTMState.AssertTMStateExecute notSuccesState = new AssertTMState.AssertTMStateExecute(AssertTMState.AssertStateKind.SUCCESS, this.assertTM){

            public IHidObject execute(IHidObject hidObject, IHidEvaluator evaluator, AssertTM.AssertTMCursor cursor, IHidEvaluationGuardian guardian) {
                cursor.consume(true, guardian);
                RfPropertySequenceConverter.this.assertTM.removeCursor(cursor);
                return null;
            }
        };
        notSuccesState.setAdditionalText("NOT");
        AssertTMAbstractTransition notTransition = (AssertTMAbstractTransition)this.assertTM.transitionTable.get(notBegin);
        if (!(notTransition instanceof AssertTMOppositeTransition)) {
            return null;
        }
        ((AssertTMOppositeTransition)notTransition).setJoinState((IAssertTMState)notEnd);
        lastState[0] = notEnd;
        this.assertTM.addTransition(norExprLastState, (IAssertTMState)notSuccesState, (AssertTMState)notFailState, this.assertTM);
        return lastState[0];
    }

    public AssertTM transform() {
        IHidObject propertySequenceCall;
        IHidObject origin = this.propertySequence;
        if (!HidUtils.isOperator((IHidObject)origin)) {
            return null;
        }
        origin = ((RfHidOperator)origin).hidObjectCopy();
        while ((propertySequenceCall = this.getFirstPropertySequenceInstance(origin)) != null) {
            IHidObject newOrigin;
            IHidObject flattenCall = this.flattenCall(propertySequenceCall);
            origin = newOrigin = this.replaceInstanceByFlatten(origin, flattenCall, propertySequenceCall);
        }
        return this.convertTuringMachine(origin);
    }

    private IHidObject getFirstPropertySequenceInstance(IHidObject expression) {
        if (expression == null || !HidUtils.isOperator((IHidObject)expression)) {
            return null;
        }
        RfHidOperator operator = (RfHidOperator)expression;
        IHidObject lhValue = operator.getLHValue();
        IRfNamedElement lhElement = RfPropertySequenceConverter.getPropertyElement(lhValue);
        if (lhElement instanceof RfPropertySequence) {
            return lhValue;
        }
        IHidObject lhProperty = this.getFirstPropertySequenceInstance(lhValue);
        if (lhProperty != null) {
            return lhProperty;
        }
        if (operator.hasRHValues()) {
            for (IHidObject rhValue : operator.getRHValues()) {
                IRfNamedElement rhElement = RfPropertySequenceConverter.getPropertyElement(rhValue);
                if (rhElement instanceof RfPropertySequence) {
                    return rhValue;
                }
                IHidObject rhProperty = this.getFirstPropertySequenceInstance(rhValue);
                if (rhProperty == null) continue;
                return rhProperty;
            }
        }
        return null;
    }

    private IHidObject replaceInstanceByFlatten(IHidObject origin, IHidObject flattenPropery, IHidObject oldPropertyCall) {
        if (origin == null || !HidUtils.isOperator((IHidObject)origin)) {
            return origin;
        }
        if (((HidOperator)origin).isAssociation()) {
            return origin;
        }
        HidOperator originOp = (HidOperator)origin;
        IHidObject lhValue = originOp.getLHValue();
        if (lhValue == oldPropertyCall) {
            originOp.setLHValue(flattenPropery);
            return originOp;
        }
        this.replaceInstanceByFlatten(lhValue, flattenPropery, oldPropertyCall);
        if (originOp.hasRHValues()) {
            ListContainer rhValues = originOp.getRHValues();
            if (rhValues.size() == 1 && originOp.getFirstRHValue() == oldPropertyCall) {
                originOp.setRHValues((ListContainer)flattenPropery);
                return originOp;
            }
            for (IHidObject rhValue : rhValues) {
                if (!HidUtils.isOperator((IHidObject)rhValue)) continue;
                this.replaceInstanceByFlatten(rhValue, flattenPropery, oldPropertyCall);
            }
        }
        return originOp;
    }

    private IHidObject flattenCall(IHidObject p) {
        IRfNamedElement element = RfPropertySequenceConverter.getPropertyElement(p);
        if (!(element instanceof RfPropertySequence)) {
            return null;
        }
        List<Object> formalArgumentValues = null;
        RfHidAccessArgs deepCopy = null;
        RfPropertySequence propertyElement = (RfPropertySequence)element;
        if (p instanceof RfHidAccessArgs) {
            deepCopy = ((RfHidAccessArgs)p).hidObjectCopy();
            formalArgumentValues = deepCopy.getArgumentValues();
        }
        if (p instanceof RfHid) {
            deepCopy = ((RfHid)p).hidObjectCopy();
            formalArgumentValues = Collections.emptyList();
        }
        if (deepCopy == null || formalArgumentValues == null) {
            return null;
        }
        IHidOperator convertProperty = HidEvalConverter.INSTANCE.convertElement((IRfNamedElement)propertyElement, this.guardian.copy(), this.evaluator);
        ListContainer formalArguments = convertProperty != null ? convertProperty.getRHValues() : ListContainer.emptyContainer();
        List<IRfFieldElement> arguments = propertyElement.getArguments();
        LinkedHashMap<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> argumentsValues = new LinkedHashMap<String, HidEvalCenter.MethodCallStatement.ArgumentInfo>();
        HidOperator propertyOperator = null;
        for (IHidObject formalArgument : formalArguments) {
            if (!HidUtils.isOperator((IHidObject)formalArgument, (long)HidOperatorQualifier.IS_OPERATOR_COMPLETE.value()) || !HidUtils.isOperatorOfType((IHidObject)formalArgument, (IHidOperatorConstants.OperatorType)IHidOperatorConstants.OperatorType.PROPERTY_SPEC)) continue;
            propertyOperator = (IHidOperator)formalArgument;
        }
        if (propertyOperator == null) {
            return null;
        }
        propertyOperator = propertyOperator.hidObjectCopy();
        int idxFormal = 0;
        for (IHidObject iHidObject : formalArgumentValues) {
            IRfFieldElement formalArg = arguments.get(idxFormal++);
            String formalArgName = formalArg.getName();
            HidEvalCenter.MethodCallStatement.ArgumentInfo argumentInfo = new HidEvalCenter.MethodCallStatement.ArgumentInfo(formalArgName, formalArg, iHidObject, null);
            argumentsValues.put(formalArgName, argumentInfo);
        }
        if (arguments.size() != argumentsValues.size()) {
            for (IRfFieldElement iRfFieldElement : arguments) {
                if (argumentsValues.containsKey(iRfFieldElement.getName())) continue;
                for (IHidObject valueOp : formalArguments) {
                    IRfFieldElement field;
                    if (!(valueOp instanceof RfHidOperator.XInitialDeclarationOperator) || (field = ((RfHidOperator.XInitialDeclarationOperator)valueOp).getField()) != iRfFieldElement) continue;
                    String formalArgName = iRfFieldElement.getName();
                    HidEvalCenter.MethodCallStatement.ArgumentInfo argumentInfo = new HidEvalCenter.MethodCallStatement.ArgumentInfo(formalArgName, iRfFieldElement, valueOp, null);
                    argumentsValues.put(formalArgName, argumentInfo);
                }
            }
        }
        this.guardian.getFactory().getRfMixedLangProject().getSingleLangProject(LanguageKind.VLOG.NATURE_ID);
        for (Map.Entry entry : argumentsValues.entrySet()) {
            boolean isTickCast;
            IRfNamedElement elementType;
            HidEvalCenter.MethodCallStatement.ArgumentInfo argumentInfo = (HidEvalCenter.MethodCallStatement.ArgumentInfo)entry.getValue();
            IHidObject actualValue = argumentInfo.argHidObject;
            if (HidUtils.isOperator((IHidObject)actualValue) && ((IHidOperator)actualValue).isAssociation()) {
                actualValue = ((IHidOperator)actualValue).getFirstRHValue();
            }
            boolean isFieldNoDataType = (elementType = argumentInfo.formalArg.getResolvedType(true)) == RfBitVectorScalarType.UNTYPED;
            String type = argumentInfo.formalArg.getDataType() != null ? ((DataType)argumentInfo.formalArg.getDataType()).getType() : null;
            boolean isEventPropertySequence = "event".equals(type) || "property".equals(type) || "sequence".equals(type);
            boolean bl = isTickCast = HidUtils.isOperator((IHidObject)actualValue) && ((IHidOperator)actualValue).isTickCast();
            if (isFieldNoDataType || isEventPropertySequence || isTickCast) {
                this.replaceOperator(propertyOperator, (IRfNamedElement)argumentInfo.formalArg, actualValue);
                continue;
            }
            if (elementType == null) {
                this.guardian.logError("Fail to evaluate concurrent assert '" + HidUtils.toNiceString((IHidObject)this.propertySequence) + "'. Fail to compute associated type of argument '" + argumentInfo.formalArgName + "'");
                return null;
            }
            Hid castMember = STransformer.BUILDERS.buildHid(elementType.getName(), elementType, HidOccurrence.DUMMY_OCCURRENCE, 0L);
            HidOperator typeOperator = STransformer.BUILDERS.buildOperator((IHidObject)castMember, Collections.emptyList(), 238, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "type", HidOperatorOccurrence.DUMMY_OCCURRENCE, 0L);
            STransformer.BUILDERS.buildOperator((IHidObject)typeOperator, Arrays.asList(actualValue), 538, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "'", HidOperatorOccurrence.DUMMY_OCCURRENCE, 0L);
            this.replaceOperator(propertyOperator, (IRfNamedElement)argumentInfo.formalArg, actualValue);
        }
        return propertyOperator;
    }

    private void replaceOperator(HidOperator operator, IRfNamedElement oldElement, IHidObject newValue) {
        IRfNamedElement element;
        IHidObject lhValue = operator.getLHValue();
        if (HidUtils.isOperator((IHidObject)lhValue)) {
            this.replaceOperator((HidOperator)lhValue, oldElement, newValue);
        }
        if (HidUtils.isHid((IHidObject)lhValue) && (element = ((Hid)lhValue).getElement()) == oldElement) {
            operator.setLHValue(newValue);
        }
        if (HidUtils.isHidAccessArgs((IHidObject)lhValue)) {
            this.replaceHidAccessArgs((IHidAccessArgs)lhValue, oldElement, newValue);
        }
        if (this.isHidAccessDotSelect(lhValue)) {
            this.replaceHidAccess((HidAccess)lhValue, oldElement, newValue);
        }
        if (!operator.hasRHValues()) {
            return;
        }
        ListContainer rhValues = operator.getRHValues();
        IHidObject firstRHValue = operator.getFirstRHValue();
        if (rhValues.size() == 1 && !HidUtils.isOperator((IHidObject)firstRHValue)) {
            IRfNamedElement element2;
            if (HidUtils.isOperator((IHidObject)firstRHValue)) {
                this.replaceOperator((HidOperator)firstRHValue, oldElement, newValue);
            }
            if (HidUtils.isHid((IHidObject)firstRHValue) && (element2 = ((Hid)firstRHValue).getElement()) == oldElement) {
                operator.setRHValues((ListContainer)newValue);
            }
            if (HidUtils.isHidAccessArgs((IHidObject)firstRHValue)) {
                this.replaceHidAccessArgs((IHidAccessArgs)firstRHValue, oldElement, newValue);
            }
            if (this.isHidAccessDotSelect(firstRHValue)) {
                this.replaceHidAccess((HidAccess)firstRHValue, oldElement, newValue);
            }
            return;
        }
        int idx = 0;
        for (IHidObject rhValue : rhValues) {
            IRfNamedElement element3;
            if (HidUtils.isOperator((IHidObject)rhValue)) {
                this.replaceOperator((HidOperator)rhValue, oldElement, newValue);
            }
            if (HidUtils.isHid((IHidObject)rhValue) && (element3 = ((Hid)rhValue).getElement()) == oldElement) {
                OptimizedUtils.listContainerRemove((ListContainer)rhValues, (int)idx);
                OptimizedUtils.listContainerAdd((ListContainer)rhValues, (int)idx, (Object)newValue);
            }
            if (HidUtils.isHidAccessArgs((IHidObject)rhValue)) {
                this.replaceHidAccessArgs((IHidAccessArgs)rhValue, oldElement, newValue);
            }
            if (this.isHidAccessDotSelect(rhValue)) {
                this.replaceHidAccess((HidAccess)rhValue, oldElement, newValue);
            }
            ++idx;
        }
    }

    private boolean isHidAccessDotSelect(IHidObject hidObject) {
        return HidUtils.isHidAccess((IHidObject)hidObject) && (((HidAccess)hidObject).isRangeSelect() || ((HidAccess)hidObject).getAccessKind() == 0);
    }

    private void replaceHidAccess(HidAccess hidAccess, IRfNamedElement oldElement, IHidObject newValue) {
        throw new UnsupportedOperationException("Unsupported opreation yet");
    }

    private void replaceHidAccessArgs(IHidAccessArgs hidAccessArgs, IRfNamedElement oldElement, IHidObject newValue) {
        List argumentValues = hidAccessArgs.getArgumentValues();
        int idx = 0;
        for (IHidObject hidObject : argumentValues) {
            if (HidUtils.isOperator((IHidObject)hidObject)) {
                this.replaceOperator((HidOperator)hidObject, oldElement, newValue);
            }
            if (HidUtils.isHid((IHidObject)hidObject)) {
                OptimizedUtils.listContainerRemove((ListContainer)((ListContainer)argumentValues), (int)idx);
                OptimizedUtils.listContainerAdd((ListContainer)((ListContainer)argumentValues), (int)idx, (Object)newValue);
            }
            if (this.isHidAccessDotSelect(hidObject)) {
                this.replaceHidAccess((HidAccess)hidObject, oldElement, newValue);
            }
            ++idx;
        }
    }
}

