/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.semantic.extension2;

import java.util.List;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.OperatorInfo;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataTypeCategory;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.RfSemanticError;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SContext;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SOperation;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;

public class ParticularOperations
extends SOperation {
    public HidOperator operator;

    public ParticularOperations(HidOperator operator) {
        this.operator = operator;
    }

    @Override
    protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
        ISDataType isValid = this.checkValidOperands(configInfo, triggerError, operatorInfo, operands, context);
        if (isValid != null) {
            return isValid;
        }
        RfHidOperator currentOperator = (RfHidOperator)this.operator;
        ISDataAbstract first = operands.get(0);
        SDataTypeCategory firstCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)first);
        if (currentOperator.isIfCondition()) {
            if (firstCategory == SDataTypeCategory.STRUCT_UNPACKED) {
                return SDataAbstracts.ILLEGAL;
            }
            if (firstCategory == SDataTypeCategory.UNION_UNPACKED) {
                return SDataAbstracts.ILLEGAL;
            }
            if (firstCategory == SDataTypeCategory.FIXED_SIZE_ARRAY_UNPACKED) {
                return SDataAbstracts.ILLEGAL;
            }
            if (firstCategory == SDataTypeCategory.NEW) {
                return SDataAbstracts.ILLEGAL;
            }
        } else if (currentOperator.getOperatorType() != IHidOperatorConstants.OperatorType.FOREACH_CONDITION.id && currentOperator.getOperatorType() != IHidOperatorConstants.OperatorType.FOR_CONDITION.id && currentOperator.getOperatorType() != IHidOperatorConstants.OperatorType.WHILE_CONDITION.id) {
            if (currentOperator.getOperatorType() == IHidOperatorConstants.OperatorType.REPEAT_CONDITION.id) {
                ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)first);
                if (firstDataType != null && firstDataType.isList()) {
                    if (triggerError) {
                        ParticularOperations.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_REPEAT_CONDITION_UNPACKED_ARRAY, null, SDataUtils.getVariableName((ISDataAbstract)first, (IHidObject)currentOperator.getLHValue()));
                    }
                    return SDataAbstracts.ILLEGAL;
                }
                if (firstCategory == SDataTypeCategory.STRING) {
                    if (triggerError) {
                        ParticularOperations.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_REPEAT_CONDITION_STRING, null, SDataUtils.getVariableName((ISDataAbstract)first, (IHidObject)currentOperator.getLHValue()));
                    }
                    return SDataAbstracts.ILLEGAL;
                }
                if (firstCategory == SDataTypeCategory.UNION_UNPACKED || firstCategory == SDataTypeCategory.STRUCT_UNPACKED) {
                    if (triggerError) {
                        ParticularOperations.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_REPEAT_CONDITION_UNPACKED_STRUCT, null, SDataUtils.getVariableName((ISDataAbstract)first, (IHidObject)currentOperator.getLHValue()));
                    }
                    return SDataAbstracts.ILLEGAL;
                }
            } else if (currentOperator.getOperatorType() == IHidOperatorConstants.OperatorType.CASE_CONDITION.id) {
                if (firstCategory == SDataTypeCategory.STRUCT_UNPACKED) {
                    return SDataAbstracts.ILLEGAL;
                }
                if (firstCategory == SDataTypeCategory.UNION_UNPACKED) {
                    return SDataAbstracts.ILLEGAL;
                }
                if (firstCategory == SDataTypeCategory.FIXED_SIZE_ARRAY_UNPACKED) {
                    return SDataAbstracts.ILLEGAL;
                }
                if (firstCategory != SDataTypeCategory.NUMERIC && firstCategory != SDataTypeCategory.SHORTREAL && firstCategory != SDataTypeCategory.STRING && firstCategory != SDataTypeCategory.ENUM && firstCategory != SDataTypeCategory.LITERAL_STRING && firstCategory != SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED && firstCategory != SDataTypeCategory.STRUCT_PACKED && firstCategory != SDataTypeCategory.UNION_PACKED) {
                    return SDataAbstracts.ILLEGAL;
                }
            } else {
                if (currentOperator.isCoverpointExpression()) {
                    switch (firstCategory) {
                        case NUMERIC: 
                        case LITERAL_STRING: 
                        case FIXED_SIZE_ARRAY_PACKED: 
                        case ENUM: 
                        case UNION_PACKED: 
                        case STRUCT_PACKED: {
                            return null;
                        }
                        case REAL: {
                            ParticularOperations.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_COVERPOINT_EXPRESSION_TYPE, null, new Object[0]);
                            return SDataAbstracts.ILLEGAL;
                        }
                    }
                    ParticularOperations.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_COVERPOINT_EXPRESSION: Coverpoint expression must be of an integral data type", null, new Object[0]);
                    return SDataAbstracts.ILLEGAL;
                }
                if (currentOperator.isPound()) {
                    if (firstCategory == SDataTypeCategory.STRUCT_UNPACKED) {
                        return SDataAbstracts.ILLEGAL;
                    }
                    if (firstCategory == SDataTypeCategory.UNION_UNPACKED) {
                        return SDataAbstracts.ILLEGAL;
                    }
                    if (firstCategory == SDataTypeCategory.FIXED_SIZE_ARRAY_UNPACKED) {
                        return SDataAbstracts.ILLEGAL;
                    }
                    if (firstCategory != SDataTypeCategory.NUMERIC && firstCategory != SDataTypeCategory.SHORTREAL && firstCategory != SDataTypeCategory.EVENT && firstCategory != SDataTypeCategory.ENUM && firstCategory != SDataTypeCategory.REAL) {
                        return SDataAbstracts.ILLEGAL;
                    }
                } else if (!currentOperator.isColonEq()) {
                    return SDataAbstracts.UNDEFINED;
                }
            }
        }
        return null;
    }

    @Override
    public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
        ISDataType isValid = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
        if (isValid != null) {
            return isValid;
        }
        return STransformer.LOGIC_VARIABLE;
    }
}

