/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.semantic.extension2;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParametricDependency;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISContext;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.OperatorInfo;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfErrorImplicitField;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SOperation;

public class SContext
implements ISContext {
    private Supplier<ISDataAbstract> contextDataTypeSupplier;
    private Supplier<ISDataAbstract> extraContextDataTypeSupplier;
    private Supplier<IRfNamedElement> assocArrayTypeSupplier;
    public String contextElementName;
    public SOperation contextOperation;
    public OperatorInfo contextOperatorInfo;
    public ArrayDeque<SOperation> previousOperations;
    private List<RfNamedElement> cacheMembers;
    private RfNamedElement cacheMemberOfList;
    private ELWidthCheckContext elabContext;
    private int optionalUnpackedDimensions;
    private Supplier<? extends Hid> lHSideHidSupplier;

    public SContext(Supplier<ISDataAbstract> contextDataTypeSupplier, SOperation contextOperation) {
        this.contextDataTypeSupplier = contextDataTypeSupplier;
        this.contextOperation = contextOperation;
        this.extraContextDataTypeSupplier = () -> null;
        this.assocArrayTypeSupplier = () -> null;
    }

    public SContext(Supplier<ISDataAbstract> contextDataTypeSupplier, Supplier<ISDataAbstract> extraContextDataTypeSupplier, Supplier<IRfNamedElement> assocArrayTypeSupplier, SOperation contextOperation) {
        this.contextDataTypeSupplier = contextDataTypeSupplier;
        this.contextOperation = contextOperation;
        this.extraContextDataTypeSupplier = extraContextDataTypeSupplier;
        this.assocArrayTypeSupplier = assocArrayTypeSupplier;
    }

    public SContext(SContext context) {
        this.contextDataTypeSupplier = context.contextDataTypeSupplier;
        this.extraContextDataTypeSupplier = context.extraContextDataTypeSupplier;
        this.assocArrayTypeSupplier = context.assocArrayTypeSupplier;
        this.contextOperation = context.contextOperation;
        this.contextElementName = context.contextElementName;
        this.cacheMembers = context.cacheMembers != null ? new ArrayList<RfNamedElement>(context.cacheMembers) : null;
        this.cacheMemberOfList = context.cacheMemberOfList;
        this.optionalUnpackedDimensions = context.optionalUnpackedDimensions;
    }

    public RfNamedElement calculateCorrespondentByPosition(int position) {
        final IRfNamedElement context = this.getContextDataTypeElement();
        if (context instanceof RfStruct) {
            if (this.cacheMembers == null) {
                Collection<RfNamedElement> members = ((RfStruct)context).getMembers();
                if (members == null) {
                    return null;
                }
                this.cacheMembers = new ArrayList<RfNamedElement>(members);
            }
            return position >= 0 && position < this.cacheMembers.size() ? this.cacheMembers.get(position) : null;
        }
        if (context instanceof RfListType) {
            if (((RfListType)context).isAssociativeArray()) {
                if (this.cacheMemberOfList == null) {
                    this.cacheMemberOfList = new RfErrorImplicitField("Pos" + position, false, null, 1, 0){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public String getSignature(RfTypesResolver resolver) {
                            return "";
                        }
                    };
                }
                return this.cacheMemberOfList;
            }
            if (this.cacheMemberOfList == null) {
                final IRfNamedElement typeOfElement = ((RfListType)context).getResolvedType(true);
                if (typeOfElement == null) {
                    return null;
                }
                DataType contextDataType = ((RfListType)context).getDataType();
                if (contextDataType == null) {
                    return null;
                }
                DataType newDataType = contextDataType.copy();
                if (newDataType.hasUnpackedDimension()) {
                    newDataType.decreaseUnpackedDimension();
                } else if (newDataType.hasPackedDimension()) {
                    newDataType.decreasePackedDimension();
                }
                this.cacheMemberOfList = new RfPredefinedField("Pos" + position, newDataType, 1, 0, null, null, true){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public RfLibrary getEnclosingLibrary() {
                        return (RfLibrary)context.getEnclosingLibrary();
                    }

                    @Override
                    public IRfNamedElement getAssociatedType(RfTypesResolver typesResolver) {
                        return typeOfElement;
                    }

                    @Override
                    protected IRfNamedElement getAssociatedTypeNoLastLevelParams(RfTypesResolver typesResolver, ParametricDependency parametricDependency) {
                        return typeOfElement;
                    }
                };
                this.cacheMemberOfList.setEnclosingScope((RfNamedElement)context.getEnclosingScope());
            }
            return this.cacheMemberOfList;
        }
        return null;
    }

    public IRfNamedElement calculateCorrespondentByName(String name, IHidObject originalFormalPart, IRfNamedElement initialScope) {
        IRfNamedElement context = this.getContextDataTypeElement();
        if (context instanceof RfStruct) {
            Hid originalFormalPartHid;
            RfNamedElement member = ((RfStruct)context).getLocalMember(RfField.class, name, false);
            if (member != null) {
                return member;
            }
            if (HidUtils.isHid((IHidObject)originalFormalPart) && (originalFormalPartHid = (Hid)originalFormalPart).getParentAccess() == null && initialScope != null) {
                IRfNamedElement type = initialScope.getMember(name, DVTRfUtils.MEMBERS_TYPES, null, true, true, false, true, false);
                return type;
            }
        }
        return null;
    }

    public boolean isUndefined() {
        ISDataAbstract contextDataType = this.getContextDataType();
        return SDataUtils.getUndefinedDataType((ISDataAbstract)contextDataType) == contextDataType;
    }

    public boolean isAssociativeArray() {
        return RfListType.isAssociativeArray((IRfScopeElement)this.getContextDataTypeElement());
    }

    public boolean isStruct() {
        return this.getContextDataTypeElement() instanceof RfStruct;
    }

    public boolean isArray() {
        return this.getContextDataTypeElement() instanceof IRfListType;
    }

    public void addOperationToQueue(SOperation operation) {
        if (this.previousOperations == null) {
            this.previousOperations = new ArrayDeque();
        }
        this.previousOperations.offer(operation);
    }

    public SOperation getPreviousOperation() {
        return this.previousOperations != null ? this.previousOperations.peekLast() : null;
    }

    public SOperation getPreviousOperation(SOperation operation, boolean returnFirstDifferent) {
        if (this.previousOperations == null || this.previousOperations.isEmpty()) {
            return null;
        }
        Iterator<SOperation> iterator = this.previousOperations.descendingIterator();
        SOperation temp = null;
        while (iterator.hasNext()) {
            temp = iterator.next();
            if (returnFirstDifferent && operation != temp) {
                return temp;
            }
            if (returnFirstDifferent || operation != temp) continue;
            return operation;
        }
        return null;
    }

    public void setPreviousOperations(ArrayDeque<SOperation> previous) {
        this.previousOperations = previous != null ? new ArrayDeque<SOperation>(previous) : null;
    }

    public void setOperatorInfo(OperatorInfo operatorInfo) {
        this.contextOperatorInfo = operatorInfo;
    }

    public void setElementName(String name) {
        this.contextElementName = name;
    }

    public void setOptionalUnpackedDimensions(int nofDimensions) {
        this.optionalUnpackedDimensions = nofDimensions;
    }

    public int getOptionalUnpackedDimensions() {
        return this.optionalUnpackedDimensions;
    }

    public void setContextOperation(SOperation contextOperation) {
        this.contextOperation = contextOperation;
    }

    public Hid getAssignPatternLHSideHid() {
        return this.lHSideHidSupplier != null ? this.lHSideHidSupplier.get() : null;
    }

    public Supplier<? extends Hid> getLHSideHidSupplier() {
        return this.lHSideHidSupplier;
    }

    public void setLHSideHid(Supplier<? extends Hid> lhSideHidSupplier) {
        this.lHSideHidSupplier = lhSideHidSupplier;
    }

    public ISDataAbstract getContextDataType() {
        return this.contextDataTypeSupplier.get();
    }

    protected IRfNamedElement getContextDataTypeElement() {
        ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)this.contextDataTypeSupplier.get());
        if (dataType == null) {
            return null;
        }
        return dataType.getType();
    }

    protected IRfNamedElement getAssocArrayType() {
        return this.assocArrayTypeSupplier.get();
    }

    public ISDataAbstract getExtraContextDataType() {
        return this.extraContextDataTypeSupplier.get();
    }

    public void setElabContext(ELWidthCheckContext context) {
        this.elabContext = context;
    }

    public boolean hasElabContext() {
        return this.elabContext != null;
    }

    public ELWidthCheckContext getElabContext() {
        return this.elabContext;
    }

    public String getElabPathForError() {
        return this.elabContext != null ? this.elabContext.getPathsTextForError() : "";
    }

    protected Supplier<ISDataAbstract> internalGetContextDataTypeSupplier() {
        return this.contextDataTypeSupplier;
    }

    protected Supplier<ISDataAbstract> internalGetExtraContextDataTypeSupplier() {
        return this.extraContextDataTypeSupplier;
    }
}

