/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.semantic.extension2;

import java.util.Arrays;
import java.util.Collection;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;

public class SDataType
implements ISDataType {
    private static final long serialVersionUID = 1L;
    public static final byte IRUN_RNM_PACKED = 2;
    private byte sign;
    private byte isPacked;
    private final IRfNamedElement type;
    private IDataType cachedListNonUnpackedDataType;
    private ISDataType cachedListBaseElementType = SDataAbstracts.UNDEFINED;
    private ISDataType enumElementType = SDataAbstracts.UNDEFINED;
    private int nofUnpackedDimensions;
    private int nofPackedDimensions;
    private String listSignature;
    private IRfTypeAliasElement aliasType;
    private boolean hasOnlyFixedSizeDimensions;

    private SDataType(IRfNamedElement type, byte sign, byte isPacked) {
        this.sign = sign;
        this.isPacked = isPacked;
        this.type = type;
    }

    public IRfNamedElement getType() {
        return this.type;
    }

    public IRfTypeAliasElement getAliasType() {
        return this.aliasType;
    }

    public static ISDataType of(IRfNamedElement type) {
        return SDataType.of(type, 0, 0);
    }

    public static ISDataType of(IRfNamedElement type, int sign, int isPacked) {
        if (sign == 0 && type instanceof RfBitVectorScalarType) {
            sign = ((RfBitVectorScalarType)type).getSign();
        }
        if (sign == 0) {
            sign = 2;
        }
        return type != null ? new SDataType(type, (byte)sign, (byte)isPacked) : SDataAbstracts.UNDEFINED;
    }

    public LanguageKind getLanguageKind() {
        return this.type == null ? null : this.type.getLanguageKind();
    }

    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean appendAliasInfo) {
        byte defaultSigning;
        StringBuilder bs = new StringBuilder();
        bs.append(this.type.getQualifiedName(7));
        if (this.type instanceof RfBitVectorScalarType && (defaultSigning = ((RfBitVectorScalarType)this.type).getSign()) != this.sign) {
            bs.append(" ").append(this.sign == 2 ? "unsigned" : "signed");
        }
        if (this.aliasType != null && appendAliasInfo) {
            bs.append("(alias: ");
            bs.append(this.aliasType.getQualifiedName(7));
            bs.append(")");
        }
        return bs.toString();
    }

    public boolean isUnderAlias() {
        return this.aliasType != null;
    }

    public ISDataType getEnumElementType() {
        return this.enumElementType;
    }

    public void setEnumElementType(ISDataType enumElementType) {
        this.enumElementType = enumElementType;
    }

    public String toString() {
        return this.getName(false);
    }

    public boolean isPacked() {
        return this.isPacked != 0;
    }

    public byte getPacked() {
        return this.isPacked;
    }

    public boolean isSigned() {
        return this.sign == 1;
    }

    public void setSign(int sign) {
        if (sign == 0) {
            sign = 2;
        }
        this.sign = (byte)sign;
    }

    public boolean isList() {
        return this.nofUnpackedDimensions != 0;
    }

    public void setNofUnpackedDimensions(int nofUnpackedDimensions) {
        this.nofUnpackedDimensions = nofUnpackedDimensions;
    }

    public void setNofPackedDimensions(int nofPackedDimensions) {
        this.nofPackedDimensions = nofPackedDimensions;
    }

    public void setHasOnlyFixedSizeDimensions(boolean value) {
        this.hasOnlyFixedSizeDimensions = value;
    }

    public void setCachedListBaseElementType(ISDataType sDataType) {
        this.cachedListBaseElementType = sDataType;
    }

    public void setCachedListNoUnpackedDimensionDataType(IDataType dataType) {
        this.cachedListNonUnpackedDataType = dataType;
    }

    public void setAliasType(IRfTypeAliasElement typeAlias) {
        this.aliasType = typeAlias;
    }

    public void setListSignature(String signature) {
        if (signature == null || signature.isEmpty()) {
            return;
        }
        this.listSignature = signature;
    }

    public Collection<IRfNamedElement> getTypes() {
        return Arrays.asList(this.type);
    }

    public boolean hasDimensions() {
        return this.nofUnpackedDimensions != 0 || this.nofPackedDimensions != 0;
    }

    public int getNofUnpackedDimensions() {
        return this.nofUnpackedDimensions;
    }

    public int getNofPackedDimensions() {
        return this.nofPackedDimensions;
    }

    public boolean hasOnlyFixedSizeDimensions() {
        return this.hasOnlyFixedSizeDimensions;
    }

    public ISDataType getCachedListBaseElementType() {
        return this.cachedListBaseElementType;
    }

    public IDataType getCachedListNoUnpackedDimensionDataType() {
        return this.cachedListNonUnpackedDataType;
    }

    public int getSign() {
        return this.sign;
    }

    public boolean isEnum() {
        return this.type instanceof RfStruct && ((RfStruct)this.type).isEnum();
    }

    public boolean isTime() {
        return this.type instanceof RfBitVectorScalarType && "time".equals(this.type.getName());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.sign;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.enumElementType == null ? 0 : this.enumElementType.hashCode());
        result = 31 * result + (this.aliasType == null ? 0 : this.aliasType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SDataType other = (SDataType)obj;
        if (this.sign != other.sign || this.hasOnlyFixedSizeDimensions ^ other.hasOnlyFixedSizeDimensions) {
            return false;
        }
        if (this.aliasType == null ? other.aliasType != null : !this.aliasType.equals(other.aliasType)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.enumElementType == null ? other.enumElementType != null : !this.enumElementType.equals(other.enumElementType));
    }

    public SDataType copy(boolean copyAliasName) {
        SDataType type = (SDataType)SDataType.of(this.type, this.sign, this.isPacked);
        type.enumElementType = this.enumElementType;
        type.nofUnpackedDimensions = this.nofUnpackedDimensions;
        type.hasOnlyFixedSizeDimensions = this.hasOnlyFixedSizeDimensions;
        type.cachedListBaseElementType = this.cachedListBaseElementType;
        type.cachedListNonUnpackedDataType = this.cachedListNonUnpackedDataType;
        type.nofPackedDimensions = this.nofPackedDimensions;
        type.listSignature = this.listSignature;
        if (copyAliasName) {
            type.aliasType = this.aliasType;
        }
        return type;
    }
}

