/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.semantic.extension2;

import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.EncryptedCodeAutoFilter;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISTransformer;
import ro.amiq.dvt.model.reflection.semantic.extension2.OperatorInfo;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataTypeAndCategoryPair;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataTypeCategory;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataVariable;
import ro.amiq.dvt.model.reflection.semantic.extension2.SemanticOperatorVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfSpecializedType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfComputedListType;
import ro.amiq.vlogdt.model.reflection.RfComputedStruct;
import ro.amiq.vlogdt.model.reflection.RfEncryptedCodeAutoManager;
import ro.amiq.vlogdt.model.reflection.RfErrorImplicitField;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.ParticularOperations;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SContext;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SDataType;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SMethodCallInfo;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SOperation;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;

public enum SEvaluator {
    INSTANCE;

    private static final HidOccurrence DUMMY_HID_OCCURRENCE;
    private static final HidOperatorOccurrence DUMMY_HID_OPERATOR_OCCURRENCE;
    private static final ParserPath DUMMY_PARSER_PATH;

    static {
        DUMMY_HID_OCCURRENCE = new HidOccurrence(0, -1, 0, 0L, null);
        DUMMY_HID_OPERATOR_OCCURRENCE = new HidOperatorOccurrence(0, -1, 0, 0L, null);
        DUMMY_PARSER_PATH = new ParserPath("");
    }

    private SEvaluator() {
        SDataAbstracts.registerTransformer((LanguageKind)LanguageKind.VLOG, (ISTransformer)STransformer.INSTANCE);
    }

    public void calculateAssociation(HidOperator association, IRfNamedElement lhSide, IRfNamedElement initialScope, ConfigInfo configInfo, ParserPath parserPath, ObjectSet<IRfNamedElement> visited, boolean triggerError, boolean isIrunRNMTech) {
        VlogSemanticOperatorVisitor evaluator = new VlogSemanticOperatorVisitor(configInfo, (IHidHolder)new RfHidHolder(initialScope), parserPath, triggerError, isIrunRNMTech);
        evaluator.resolveAssociation(association, lhSide, initialScope);
    }

    public void calculateImplicitNamedAssociation(HidOperator implicitConnection, IRfPortElement port, IRfNamedElement connectedElement, IRfNamedElement initialScope, HidOperatorOccurrence operatorOccurrence, ConfigInfo configInfo, ParserPath parserPath, boolean triggerError, boolean isIrunRNMTech) {
        VlogSemanticOperatorVisitor evaluator = new VlogSemanticOperatorVisitor(configInfo, (IHidHolder)new RfHidHolder(initialScope), parserPath, triggerError, isIrunRNMTech);
        evaluator.resolveImplicitNamedConnection(implicitConnection, (IRfNamedElement)port, connectedElement, operatorOccurrence);
    }

    public void calculate(ConfigInfo configInfo, RfHidHolder hidHolder, boolean triggerError) throws BuildCancelException {
        hidHolder.visitHidObject(null, (IHidVisitor)new VlogSemanticOperatorVisitor(configInfo, (IHidHolder)hidHolder, null, triggerError, configInfo.isIrunRNMTech()));
    }

    public ISDataAbstract calculateDataType(ConfigInfo configInfo, IHidObject operand, IRfNamedElement initialScope, OperatorInfo operatorInfo, ParserPath parserPath) {
        VlogSemanticOperatorVisitor evaluator = new VlogSemanticOperatorVisitor(configInfo, (IHidHolder)new RfHidHolder(initialScope), parserPath, false, configInfo.isIrunRNMTech());
        evaluator.setDimensionsWithMacros(true);
        return evaluator.getDataType(operand, operatorInfo);
    }

    public ISDataAbstract checkTypeCompatibility(IRfNamedElement lhSide, IRfNamedElement rhSide, boolean strictClassMatching, boolean matchingTypes, IRfNamedElement initialScope, ConfigInfo configInfo) {
        Hid rhSideHid;
        Hid lhSideHid = STransformer.BUILDERS.buildHid(lhSide.getName(), lhSide, DUMMY_HID_OCCURRENCE, 0L);
        HidOperator assoc = STransformer.BUILDERS.buildOperator((IHidObject)lhSideHid, Collections.singletonList(rhSideHid = STransformer.BUILDERS.buildHid(rhSide.getName(), rhSide, DUMMY_HID_OCCURRENCE, 0L)), IHidOperatorConstants.OperatorType.ASSOCIATION.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", DUMMY_HID_OPERATOR_OCCURRENCE, HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER);
        if (assoc == null) {
            return SDataAbstracts.UNDEFINED;
        }
        boolean hasOutputDirection = lhSide instanceof IRfFieldElement && ((IRfFieldElement)lhSide).isOutput();
        return this.checkTypeCompatibility(assoc, hasOutputDirection, strictClassMatching, matchingTypes, initialScope, configInfo);
    }

    public ISDataAbstract checkTypeCompatibility(HidOperator assoc, boolean hasOutputDirection, boolean strictClassMatching, boolean matchingTypes, IRfNamedElement initialScope, ConfigInfo configInfo) {
        VlogSemanticOperatorVisitor evaluator = new VlogSemanticOperatorVisitor(configInfo, (IHidHolder)new RfHidHolder(initialScope), DUMMY_PARSER_PATH, false, configInfo.isIrunRNMTech());
        evaluator.internalResolveAssociation(assoc, SOperation.ARG_VALUE_INSTANCE, true, hasOutputDirection, strictClassMatching, matchingTypes);
        return assoc.getOperatorResolvedType();
    }

    public void calculateMethodCall(ConfigInfo configInfo, RfHidAccessArgs methodAccess, IRfNamedElement initialScope, boolean triggerError) throws BuildCancelException {
        methodAccess.visitHidObject(null, (IHidVisitor)new VlogSemanticOperatorVisitor(configInfo, (IHidHolder)new RfHidHolder(initialScope), null, triggerError, configInfo.isIrunRNMTech()));
    }

    public static class VlogSemanticOperatorVisitor
    extends SemanticOperatorVisitor {
        private static final LanguageKind LANG_KIND = LanguageKind.VLOG;
        private ConfigInfo configInfo;
        private SMethodCallInfo parentHidForMethodCall;
        private boolean triggerError;
        private boolean dimensionsWithMacros;
        private boolean isIrunRNMTech;
        private boolean isEncryptedAutoApi;

        public VlogSemanticOperatorVisitor(ConfigInfo configInfo, IHidHolder hidHolder, ParserPath parserPath, boolean triggerError, boolean isIrunRNMTech) {
            super(hidHolder, parserPath);
            this.configInfo = configInfo;
            this.triggerError = triggerError;
            this.isEncryptedAutoApi = configInfo != null && configInfo.getEncryptedCodeAutoDefine() != null && configInfo.getEncryptedCodeAutoDefine().hasEnabledEncryptedCodeAuto();
            this.isIrunRNMTech = isIrunRNMTech;
        }

        public void setInfo(SMethodCallInfo correspondentMethodCall) {
            this.parentHidForMethodCall = correspondentMethodCall;
        }

        public void setDimensionsWithMacros(boolean dimensionsWithMacros) {
            this.dimensionsWithMacros = dimensionsWithMacros;
        }

        private boolean isValidLHOperand(HidOperator operator) {
            return operator.getOperatorKind() != IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR;
        }

        public IRfNamedElement getScope() {
            IRfNamedElement result = this.holder instanceof RfHidHolder ? ((RfHidHolder)this.holder).getScope() : null;
            return result instanceof IRfNamedElement ? result : null;
        }

        public boolean visit(HidOperator operator) throws BuildCancelException {
            RfProject rfProject = (RfProject)this.configInfo.getRfProject("ro.amiq.vlogdt.VlogNature");
            rfProject.checkBuildCanceled();
            if (!operator.isOperatorResolved()) {
                operator.setOperatorResolvedType((ISDataAbstract)SDataAbstracts.UNDEFINED);
            }
            if (!operator.isComplete() || operator.isHidden()) {
                return true;
            }
            if (operator.isWithClause()) {
                return true;
            }
            if (operator.hasOccurrence(HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER)) {
                this.resolveArgumentValues(operator);
            } else {
                this.resolveCompleteOperator(operator, null);
            }
            return true;
        }

        public boolean visit(Hid hid) throws BuildCancelException {
            return true;
        }

        public void resolveArgumentValues(HidOperator operator) {
            IRfNamedElement element;
            if (this.parentHidForMethodCall == null) {
                return;
            }
            IHidObject leftValue = operator.getLHValue();
            RfField correspondent = null;
            String correspondentName = null;
            IRfNamedElement iRfNamedElement = element = HidUtils.isHid((IHidObject)leftValue) ? ((Hid)leftValue).getElement() : null;
            if (!HidUtils.isResolved((IHidObject)leftValue) && leftValue instanceof IHid || element != null && element.hasNoDefs(false)) {
                String hidName = ((IHid)leftValue).getName();
                if (MethodCallUtils.isOrdered((IHidObject)operator)) {
                    if (this.parentHidForMethodCall.members == null) {
                        return;
                    }
                    if (this.parentHidForMethodCall.position >= this.parentHidForMethodCall.members.size()) {
                        operator.setOperatorResolvedType((ISDataAbstract)SDataAbstracts.ILLEGAL);
                        return;
                    }
                    correspondent = this.parentHidForMethodCall.members.get(this.parentHidForMethodCall.position);
                    if (correspondent == null) {
                        return;
                    }
                    correspondentName = hidName;
                } else {
                    if (this.parentHidForMethodCall.methodCallHid == null) {
                        return;
                    }
                    IRfNamedElement function = this.parentHidForMethodCall.methodCallHid.getElement();
                    if (this.parentHidForMethodCall.methodCallHid.isMethodCall(false) && function instanceof RfNamedElement) {
                        RfField argument = ((RfNamedElement)function).getLocalMember(RfField.class, hidName, true);
                        if (argument == null || !argument.isArgument()) {
                            return;
                        }
                        correspondent = argument;
                    }
                    if (correspondent == null) {
                        return;
                    }
                    correspondentName = correspondent.getName();
                }
                this.createHidAndUpdateOperator(operator, correspondentName, correspondent, true);
            } else if (element instanceof RfField && HidUtils.isResolved((IHidObject)leftValue)) {
                correspondent = (RfField)element;
            }
            boolean hasOutputDirection = correspondent != null && correspondent.isOutput();
            boolean isRef = correspondent != null && correspondent.isRef();
            this.internalResolveAssociation(operator, SOperation.ARG_VALUE_INSTANCE, false, hasOutputDirection, isRef, false);
            if (this.isEncryptedAutoApi && this.shouldAnalyzeOperator()) {
                RfEncryptedCodeAutoManager.computeAutoDefineInfoForCompleteOperator(this.configInfo.getEncryptedCodeAutoDefine(), operator, this.getScope());
            }
        }

        private boolean shouldAnalyzeOperator() {
            if (this.parentHidForMethodCall == null || this.parentHidForMethodCall.methodCallHid == null) {
                return true;
            }
            IRfNamedElement methodElement = this.parentHidForMethodCall.methodCallHid.getElement();
            if (methodElement == null) {
                return true;
            }
            String methodName = methodElement.getName();
            boolean insidePredefinedFunctionWithClause = methodElement instanceof RfPredefinedFunction && (RfHid.ARRAY_REDUCTION_METHODS.contains(methodName) || RfHid.MANDATORY_WITH_CLAUSE_METHODS.contains(methodName) || RfHid.OPTIONAL_RELATIONAL_WITH_CLAUSE_METHODS.contains(methodName));
            return !insidePredefinedFunctionWithClause;
        }

        private void resolveAssociation(HidOperator association, IRfNamedElement lhSide, IRfNamedElement initialScope) {
            association.setOperatorResolvedType((ISDataAbstract)SDataAbstracts.UNDEFINED);
            if (lhSide == null) {
                return;
            }
            boolean hasOutputDirection = lhSide instanceof IRfFieldElement && ((IRfFieldElement)lhSide).isOutput();
            boolean isRef = lhSide instanceof RfField && ((RfField)lhSide).isRef();
            List<HidOperator> associations = STransformer.INSTANCE.transformAssociation(association, lhSide, initialScope);
            for (HidOperator operator : associations) {
                this.internalResolveAssociation(operator, association.hasQualifier(HidQualifierCache.IS_PORT_CONNECTION_QUALIFIER) ? SOperation.PORT_CONNECTION_INSTANCE : SOperation.PARAMETER_VALUE_INSTANCE, false, hasOutputDirection, isRef, false);
            }
        }

        public void resolveImplicitNamedConnection(HidOperator implicitConnection, IRfNamedElement lhSide, IRfNamedElement rhSide, HidOperatorOccurrence operatorOccurrence) {
            if (implicitConnection != null) {
                implicitConnection.setOperatorResolvedType((ISDataAbstract)SDataAbstracts.UNDEFINED);
            }
            if (lhSide == null) {
                return;
            }
            boolean hasOutputDirection = lhSide instanceof IRfFieldElement && ((IRfFieldElement)lhSide).isOutput();
            boolean isRef = lhSide instanceof RfField && ((RfField)lhSide).isRef();
            List<HidOperator> associations = STransformer.INSTANCE.transformImplicitNamedConnection(implicitConnection, lhSide, rhSide, operatorOccurrence);
            for (HidOperator association : associations) {
                this.internalResolveAssociation(association, SOperation.PORT_CONNECTION_INSTANCE, false, hasOutputDirection, isRef, false);
            }
        }

        private void internalResolveAssociation(HidOperator operator, SOperation operation, boolean ignoreAssignmentLHSide, boolean hasOutputDirection, boolean strictClassMatching, boolean matchingTypes) {
            IHidObject lhValue = operator.getLHValue();
            IHidObject rhValue = (IHidObject)operator.getRHValues().get(0);
            IRfNamedElement scope = this.getScope();
            OperatorInfo operatorInfo = new OperatorInfo(operator, this.parserPath, scope, ignoreAssignmentLHSide, hasOutputDirection, strictClassMatching, matchingTypes);
            ISDataAbstract firstDataType = this.resolveOperand(lhValue, null, operatorInfo);
            SContext context = this.makeContext(null, lhValue, () -> firstDataType, operation, operatorInfo, scope);
            ISDataAbstract secondDataType = this.resolveOperand(rhValue, context, operatorInfo);
            ArrayList<ISDataAbstract> operands = new ArrayList<ISDataAbstract>(2);
            if (!hasOutputDirection) {
                operands.add(firstDataType);
                operands.add(secondDataType);
            } else {
                operands.add(secondDataType);
                operands.add(firstDataType);
            }
            ISDataAbstract resolvedType = operation.calculate(this.configInfo, this.triggerError, operatorInfo, operands, context);
            operator.setOperatorResolvedType(resolvedType);
        }

        private void createHidAndUpdateOperator(HidOperator operator, String correspondentName, IRfNamedElement correspondent, boolean isLHSide) {
            if (correspondent == null || operator == null) {
                return;
            }
            HidOperatorOccurrence operatorOccurrence = operator.getOccurrence();
            HidOccurrence hidOccurrence = new HidOccurrence(operatorOccurrence.getOpenBoundary(), operatorOccurrence.getVirtualOffset(), operatorOccurrence.getLine(), 0L, null);
            RfHid standIn = STransformer.makeStandInHid(correspondentName, correspondent, hidOccurrence, 0L);
            if (standIn == null) {
                return;
            }
            if (isLHSide) {
                operator.setLHValue((IHidObject)standIn);
            } else {
                operator.setRHValues(OptimizedUtils.listContainerClear((ListContainer)operator.getRHValues()));
                operator.addRHValue((IHidObject)standIn);
            }
        }

        private ISDataAbstract resolveOperand(IHidObject leftValue, SContext context, OperatorInfo operatorInfo) {
            ISDataAbstract dataType = leftValue instanceof HidOperator ? this.resolveCompleteOperator((HidOperator)leftValue, context) : this.getDataType(leftValue, operatorInfo);
            return dataType;
        }

        private void iterativeResolveCompleteOperator(HidOperator firstOperator, SContext firstContext) {
            RfProject rfProject = (RfProject)this.configInfo.getRfProject("ro.amiq.vlogdt.VlogNature");
            rfProject.checkBuildCanceled();
            IRfNamedElement scope = this.getScope();
            ArrayDeque<PartialOperator> working = new ArrayDeque<PartialOperator>();
            working.push(new PartialOperator(firstOperator, firstContext));
            while (!working.isEmpty()) {
                boolean isDelayAssignment;
                PartialOperator partial = (PartialOperator)working.pop();
                if (partial.isResolved()) continue;
                HidOperator operator = partial.operator;
                SContext context = partial.context;
                if (partial.getOperands() != null) {
                    ISDataAbstract resolvedTypeForOperation;
                    List<PartialOperator> operands = partial.getOperands();
                    ArrayList<ISDataAbstract> operandsList = new ArrayList<ISDataAbstract>(operands.size());
                    for (PartialOperator partialOperator : operands) {
                        operandsList.add(partialOperator.resolved);
                    }
                    if (partial.operatorInfo != null) {
                        partial.operatorInfo.setReplicatedConcatenationCondition(partial.isReplicatedConcatenationCondition);
                    }
                    resolvedTypeForOperation = (resolvedTypeForOperation = partial.currentOperation.calculate(this.configInfo, this.triggerError, partial.operatorInfo, operandsList, context)) != null ? resolvedTypeForOperation : SDataAbstracts.UNDEFINED;
                    operator.setOperatorResolvedType(resolvedTypeForOperation);
                    partial.resolved = resolvedTypeForOperation;
                    if (!this.isEncryptedAutoApi) continue;
                    RfEncryptedCodeAutoManager.computeAutoDefineInfoForEqualityOperator(this.configInfo.getEncryptedCodeAutoDefine(), partial.operator, scope);
                    continue;
                }
                SOperation currentOperation = SOperation.getOperation(operator, context);
                if (!(partial.isTransformed || currentOperation != SOperation.ASSIGNMENT_PATTERN_INSTANCE && currentOperation != SOperation.UNPACKED_CONCATENATION_INSTANCE)) {
                    if (partial.context == null || partial.context.isUndefined()) {
                        operator.setOperatorResolvedType((ISDataAbstract)SDataAbstracts.UNDEFINED);
                        partial.resolved = SDataAbstracts.UNDEFINED;
                        continue;
                    }
                    operator = STransformer.INSTANCE.transformAssignmentPattern(operator, partial.context, scope);
                    partial.setOperator(operator);
                    partial.setTransformed(true);
                    working.push(partial);
                    continue;
                }
                working.push(partial);
                IHidObject lhValue = operator.getLHValue();
                OperatorInfo operatorInfo = new OperatorInfo(operator, this.parserPath, scope, this.hasOutputDirection(currentOperation, context));
                PartialOperator lhPartial = this.internalResolveCompleteOperatorLHSide(lhValue, currentOperation, context, operatorInfo);
                context = this.makeContext(context, lhValue, () -> partialOperator.resolved, currentOperation, operatorInfo, scope);
                ArrayList<PartialOperator> operands = new ArrayList<PartialOperator>(4);
                if (this.isValidLHOperand(operator)) {
                    operands.add(lhPartial);
                }
                ListContainer rightValues = operator.getRHValues();
                boolean isReplicatedConcatenation = false;
                boolean bl = isDelayAssignment = operator.isPound() && operator.getOperatorKind() == IHidOperatorConstants.OperatorKind.TERNARY_OPERATOR;
                if (rightValues != null && !isDelayAssignment) {
                    int rhSize = rightValues.size();
                    if (rhSize > 2) {
                        IHidObject candidate = (IHidObject)rightValues.get(rhSize - 2);
                        isReplicatedConcatenation = HidUtils.isHidImplicit((IHidObject)candidate) && ((HidImplicit)candidate).isConcatenationReplication();
                    }
                    int i = rhSize - 1;
                    while (i >= 0) {
                        IHidObject rhValue = (IHidObject)rightValues.get(i);
                        if (rhValue instanceof RfHidImplicit && ((RfHidImplicit)rhValue).isConcatenationReplication()) {
                            if (currentOperation == SOperation.ASSIGNMENT_PATTERN_INSTANCE) {
                                break;
                            }
                        } else {
                            PartialOperator rhPartial = this.internalResolveCompleteOperatorRHSide(rhValue, context, working, operatorInfo);
                            if (isReplicatedConcatenation && i == rhSize - 1) {
                                rhPartial.setReplicatedConcatenationCondition(true);
                            }
                            operands.add(rhPartial);
                        }
                        --i;
                    }
                }
                if (lhPartial.hasOperator()) {
                    working.push(lhPartial);
                }
                partial.setOperands(operands);
                partial.setContext(context);
                partial.setOperatorInfo(operatorInfo);
                partial.setCurrentOperation(currentOperation);
            }
        }

        private PartialOperator internalResolveCompleteOperatorRHSide(IHidObject rhValue, SContext context, Deque<PartialOperator> working, OperatorInfo operatorInfo) {
            if (rhValue instanceof HidOperator) {
                PartialOperator newPartial = new PartialOperator((HidOperator)rhValue, context);
                working.push(newPartial);
                return newPartial;
            }
            return new PartialOperator(this.getDataType(rhValue, operatorInfo));
        }

        private PartialOperator internalResolveCompleteOperatorLHSide(IHidObject lhValue, SOperation currentOperation, SContext currentContext, OperatorInfo operatorInfo) {
            SContext lhContext;
            if (currentOperation == SOperation.RETURN_INSTANCE) {
                return new PartialOperator(this.resolveFunctionReturnType(this.getScope()));
            }
            SContext sContext = lhContext = currentOperation instanceof ParticularOperations || currentContext != null && currentOperation == SOperation.TERNARY_INSTANCE ? new SContext(() -> STransformer.LOGIC_VARIABLE, SOperation.ASSIGNMENT_INSTANCE) : null;
            if (lhContext != null) {
                lhContext.setOperatorInfo(operatorInfo);
            }
            if (lhValue instanceof HidOperator) {
                return new PartialOperator((HidOperator)lhValue, lhContext);
            }
            return new PartialOperator(this.getDataType(lhValue, operatorInfo));
        }

        public ISDataAbstract resolveCompleteOperator(HidOperator operator, SContext context) {
            try {
                this.iterativeResolveCompleteOperator(operator, context);
                if (this.isEncryptedAutoApi) {
                    RfEncryptedCodeAutoManager.computeAutoDefineInfoForCompleteOperator(this.configInfo.getEncryptedCodeAutoDefine(), operator, this.getScope());
                }
                return operator.getOperatorResolvedType();
            }
            catch (BuildCancelException e) {
                throw e;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return SDataAbstracts.UNDEFINED;
            }
        }

        private ISDataAbstract recursiveResolveCompleteOperator(HidOperator operator, SContext context) {
            try {
                ISDataAbstract resolvedTypeForOperation;
                SContext newContext;
                IRfNamedElement scope = this.getScope();
                SOperation currentOperation = SOperation.getOperation(operator, context);
                if (currentOperation == SOperation.ASSIGNMENT_PATTERN_INSTANCE || currentOperation == SOperation.UNPACKED_CONCATENATION_INSTANCE) {
                    if (context == null || context.isUndefined() || SDataTypeCategory.ASSOCIATIVE_ARRAY == SDataAbstracts.getOperandCategory((ISDataAbstract)context.getContextDataType())) {
                        operator.setOperatorResolvedType((ISDataAbstract)SDataAbstracts.UNDEFINED);
                        return SDataAbstracts.UNDEFINED;
                    }
                    operator = STransformer.INSTANCE.transformAssignmentPattern(operator, context, scope);
                }
                IHidObject lhValue = operator.getLHValue();
                OperatorInfo operatorInfo = new OperatorInfo(operator, this.parserPath, scope, this.hasOutputDirection(currentOperation, context));
                SContext sContext = newContext = currentOperation instanceof ParticularOperations || currentOperation == SOperation.TERNARY_INSTANCE ? new SContext(() -> STransformer.LOGIC_VARIABLE, SOperation.ASSIGNMENT_INSTANCE) : null;
                if (newContext != null) {
                    newContext.setOperatorInfo(operatorInfo);
                }
                ISDataAbstract firstDataType = currentOperation != SOperation.RETURN_INSTANCE ? this.resolveOperand(lhValue, newContext, operatorInfo) : this.resolveFunctionReturnType(scope);
                ArrayList<ISDataAbstract> operands = new ArrayList<ISDataAbstract>();
                if (this.isValidLHOperand(operator)) {
                    operands.add(firstDataType);
                }
                context = this.makeContext(context, lhValue, () -> firstDataType, currentOperation, operatorInfo, scope);
                ListContainer rightValues = operator.getRHValues();
                if (rightValues != null) {
                    int rhSize = rightValues.size();
                    int i = rhSize - 1;
                    while (i >= 0) {
                        IHidObject rhValue = (IHidObject)rightValues.get(i);
                        if (!(rhValue instanceof RfHidImplicit && ((RfHidImplicit)rhValue).isConcatenationReplication() || operator.isPound())) {
                            ISDataAbstract secondDataType = this.resolveOperand(rhValue, context, operatorInfo);
                            operands.add(secondDataType);
                        }
                        --i;
                    }
                }
                resolvedTypeForOperation = (resolvedTypeForOperation = currentOperation.calculate(this.configInfo, true, operatorInfo, operands, context)) != null ? resolvedTypeForOperation : SDataAbstracts.UNDEFINED;
                operator.setOperatorResolvedType(resolvedTypeForOperation);
                return resolvedTypeForOperation;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return SDataAbstracts.UNDEFINED;
            }
        }

        private boolean hasOutputDirection(SOperation currentOperation, SContext context) {
            if (context == null) {
                return false;
            }
            if (currentOperation == SOperation.ASSIGNMENT_PATTERN_INSTANCE || currentOperation == SOperation.UNPACKED_CONCATENATION_INSTANCE) {
                return context.contextOperatorInfo.hasOutputDirection();
            }
            if (context.contextOperation == SOperation.ASSIGNMENT_PATTERN_INSTANCE || context.contextOperation == SOperation.UNPACKED_CONCATENATION_INSTANCE) {
                return context.contextOperatorInfo.hasOutputDirection();
            }
            return false;
        }

        private ISDataAbstract resolveFunctionReturnType(IRfNamedElement scope) {
            RfFunction functionScope;
            RfFunction rfFunction = functionScope = scope instanceof RfFunction ? (RfFunction)scope : null;
            if (functionScope == null) {
                functionScope = (RfFunction)scope.getEnclosingScope(RfFunction.class);
            }
            if (functionScope == null || functionScope.isTask() || functionScope.isConstructor() || functionScope.isLet()) {
                return STransformer.VOID_DATA_TYPE;
            }
            return SDataAbstracts.get((IRfNamedElement)functionScope, (IRfNamedElement)scope, (ELWidthCheckContext)this.configInfo.getElabContext(), null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)this.isIrunRNMTech);
        }

        private SContext makeContext(SContext prevContext, IHidObject lhSide, Supplier<ISDataAbstract> firstDataType, SOperation currentOperation, OperatorInfo operatorInfo, IRfNamedElement scope) {
            SContext context = null;
            ELWidthCheckContext elabContext = this.configInfo.getElabContext();
            if (currentOperation == SOperation.CONCATENATION_INSTANCE) {
                if (prevContext == null) {
                    return null;
                }
                Supplier<ISDataAbstract> extraContextDataTypeSupplier = prevContext.isUndefined() ? () -> null : () -> STransformer.CONCATENATION_GENERIC_VARIABLE;
                context = new SContext(prevContext.internalGetContextDataTypeSupplier(), extraContextDataTypeSupplier, () -> null, currentOperation);
                context.setOperatorInfo(operatorInfo);
            } else if (currentOperation == SOperation.UNPACKED_CONCATENATION_INSTANCE || currentOperation == SOperation.ASSIGNMENT_PATTERN_INSTANCE || currentOperation == SOperation.INSIDE_SET_INSTANCE) {
                if (prevContext == null) {
                    return null;
                }
                context = new SContext(prevContext);
                context.setContextOperation(currentOperation);
                context.setLHSideHid(prevContext.getLHSideHidSupplier());
                context.setOperatorInfo(prevContext.contextOperatorInfo);
            } else if (currentOperation == SOperation.PARAMETER_VALUE_INSTANCE) {
                Supplier<Hid> lhSideHid = STransformer.makeHidSupplier(lhSide, scope, -1, -1, -1, HidQualifierCache.FORMAL_PART_QUALIFIER);
                context = new SContext(firstDataType, currentOperation);
                context.setLHSideHid(lhSideHid);
                context.setOperatorInfo(operatorInfo);
                String correspondentName = HidUtils.isHid((IHidObject)lhSide) && ((Hid)lhSide).getElement() != null ? ((Hid)lhSide).getElement().getName() : null;
                context.setElementName(correspondentName);
            } else if (currentOperation == SOperation.PORT_CONNECTION_INSTANCE) {
                Supplier<Hid> lhSideHid = STransformer.makeHidSupplier(lhSide, scope, -1, -1, -1, HidQualifierCache.FORMAL_PART_QUALIFIER);
                context = new SContext(firstDataType, currentOperation);
                context.setLHSideHid(lhSideHid);
                context.setOperatorInfo(operatorInfo);
                if (scope instanceof RfInstance) {
                    List<IndexType> unpackedDimensions;
                    DataType dataType = ((RfInstance)scope).getDataType();
                    List<IndexType> list = unpackedDimensions = dataType != null ? dataType.getUnpackedDimension() : null;
                    if (unpackedDimensions != null) {
                        context.setOptionalUnpackedDimensions(unpackedDimensions.size());
                    }
                }
            } else if (currentOperation == SOperation.ASSIGNMENT_INSTANCE || currentOperation == SOperation.ASSIGNMENT_PATTERN_ELEMENT_INSTANCE || currentOperation == SOperation.ARG_VALUE_INSTANCE || currentOperation == SOperation.RETURN_INSTANCE || currentOperation == SOperation.INSIDE_INSTANCE) {
                if (currentOperation == SOperation.ASSIGNMENT_PATTERN_ELEMENT_INSTANCE && prevContext != null && prevContext.isArray()) {
                    IRfNamedElement correspondentAssocType;
                    IRfNamedElement assocArrayType = prevContext.getContextDataTypeElement();
                    if (assocArrayType instanceof IRfListType && (correspondentAssocType = ((IRfListType)assocArrayType).getResolvedType(true)) != null) {
                        ISDataAbstract dataType = SDataAbstracts.get((IRfNamedElement)correspondentAssocType, (IRfNamedElement)scope, (ELWidthCheckContext)this.configInfo.getElabContext(), new HashSet(), (LanguageKind)LANG_KIND, (boolean)true, (boolean)false, (boolean)this.dimensionsWithMacros, (boolean)false, (boolean)this.isIrunRNMTech);
                        context = new SContext(() -> dataType, () -> null, () -> assocArrayType, currentOperation);
                        Hid dummy = HidUtils.makeStandInHid((String)(HidUtils.isHid((IHidObject)lhSide) || HidUtils.isHidImplicit((IHidObject)lhSide) ? ((IHid)lhSide).getName() : ""), null, (HidOccurrence)HidOccurrence.DUMMY_OCCURRENCE, (long)0L);
                        context.setLHSideHid(() -> dummy);
                        context.setOperatorInfo(operatorInfo);
                    }
                } else {
                    Supplier<Hid> lhSideHid = STransformer.makeHidSupplier(lhSide, scope, -1, -1, -1, HidQualifierCache.FORMAL_PART_QUALIFIER);
                    context = new SContext(firstDataType, currentOperation);
                    context.setLHSideHid(lhSideHid);
                    context.setOperatorInfo(operatorInfo);
                    if (HidUtils.isHid((IHidObject)lhSide)) {
                        RfHidAccess parentAccess;
                        IRfNamedElement resolvedElement = ((Hid)lhSide).getElement();
                        if (this.parentHidForMethodCall != null && resolvedElement instanceof IRfFieldElement && ((IRfFieldElement)resolvedElement).isArgument() && (parentAccess = (RfHidAccess)this.parentHidForMethodCall.methodCallHid.getParentAccess()) != null && parentAccess.getAccessKind() == 0 && parentAccess.getAssociatedType() instanceof IRfDesignElement && parentAccess.getElabDesignContext() != null) {
                            ELWidthCheckContext formalElabContext = parentAccess.getElabDesignContext();
                            elabContext = ELWidthCheckContext.of((ELParamValues)formalElabContext.getEvaluator(null).getLastValueContainer(), (ElementPath)formalElabContext.getFirstPath(true), (IRfDesignElement)((IRfDesignElement)parentAccess.getAssociatedType()), (ELParamValues)elabContext.getEvaluator(null).getLastValueContainer(), (ElementPath)elabContext.getFirstPath(false), (ELManager)elabContext.getManager());
                        }
                    }
                }
            } else if (currentOperation == SOperation.WITH_CLAUSE_INSTANCE && prevContext != null) {
                context = prevContext;
                context.setOperatorInfo(operatorInfo);
            } else {
                Supplier<? extends Hid> prevLHSide;
                if (currentOperation == SOperation.TERNARY_INSTANCE) {
                    if (prevContext == null) {
                        return null;
                    }
                    context = new SContext(prevContext);
                    context.setOperatorInfo(prevContext.contextOperatorInfo);
                } else {
                    context = new SContext(firstDataType, currentOperation);
                    context.setOperatorInfo(operatorInfo);
                }
                Supplier<? extends Hid> supplier = prevLHSide = prevContext != null ? prevContext.getLHSideHidSupplier() : null;
                if (prevLHSide != null) {
                    context.setLHSideHid(prevLHSide);
                }
            }
            if (prevContext != null && context != null) {
                context.setPreviousOperations(prevContext.previousOperations);
                context.addOperationToQueue(prevContext.contextOperation);
            }
            if (context != null && elabContext != null) {
                context.setElabContext(elabContext);
            }
            return context;
        }

        private ISDataAbstract resolveWithClause(RfHidAccessArgs value, ISDataAbstract dataType) {
            SContext withClauseContext = new SContext(() -> dataType, SOperation.WITH_CLAUSE_INSTANCE);
            withClauseContext.setElementName(value.getParentHid() != null ? value.getParentHid().getName() : "");
            return this.resolveCompleteOperator(value.getWithClause(), withClauseContext);
        }

        @NotNull
        public ISDataAbstract getDataType(IHidObject operand, OperatorInfo operatorInfo) {
            switch (operand.getHidKind()) {
                case IMPLICIT: {
                    return this.getDataTypeForImplicit(operand, this.configInfo.getElabContext(), this.getScope());
                }
                case HID: 
                case ACCESS: 
                case OPERATOR: {
                    return this.getDataTypeForOperand(operand, operatorInfo, this.getScope());
                }
            }
            return SDataAbstracts.UNDEFINED;
        }

        @NotNull
        protected ISDataAbstract getDataTypeForOperand(IHidObject operand, OperatorInfo operatorInfo, IRfNamedElement scope) {
            EncryptedCodeAutoFilter encryptedCodeAutoDefine;
            RfField potentialTypeParamater;
            boolean reducedChecks;
            boolean isVariable = false;
            boolean isWithClause = false;
            boolean isNetType = false;
            IRfNamedElement resolvedElement = null;
            ELWidthCheckContext elabContext = this.configInfo.getElabContext();
            boolean bl = reducedChecks = elabContext == null || elabContext.isReducedChecks();
            if (operand.getHidKind() == IHidObject.HidKind.OPERATOR) {
                return ((HidOperator)operand).getOperatorResolvedType();
            }
            if (operand.getHidKind() == IHidObject.HidKind.HID) {
                Hid hid = (Hid)operand;
                resolvedElement = hid.getElement();
                isNetType = resolvedElement instanceof RfField && ((RfField)resolvedElement).hasUserDefinedNetType(true);
                HidAccess parentAccess = hid.getParentAccess();
                if (parentAccess == null && this.parentHidForMethodCall != null && resolvedElement instanceof IRfFieldElement && ((IRfFieldElement)resolvedElement).isArgument()) {
                    parentAccess = this.parentHidForMethodCall.methodCallHid.getParentAccess();
                }
                if (parentAccess != null) {
                    scope = parentAccess.getAssociatedType();
                }
                if (parentAccess instanceof RfHidAccess) {
                    if (parentAccess.getAccessKind() == 0 || parentAccess.getAccessKind() == 2) {
                        IRfNamedElement parentAssocType = parentAccess.getAssociatedType();
                        if (reducedChecks && parentAssocType instanceof IRfSpecializedType) {
                            parentAssocType = ((IRfSpecializedType)parentAssocType).getGenericElement();
                        } else if (reducedChecks && parentAssocType instanceof RfComputedStruct) {
                            parentAssocType = ((RfComputedStruct)parentAssocType).getOriginal();
                        }
                        scope = parentAssocType;
                        ELWidthCheckContext parentElabContext = ((RfHidAccess)parentAccess).getElabDesignContext();
                        if (parentElabContext != null) {
                            ELWidthCheckContext copy = parentElabContext.getCopy();
                            copy.setReducedChecks(reducedChecks);
                            elabContext = copy;
                        }
                    }
                    if (resolvedElement == null && parentAccess.getParentHid() != null && (potentialTypeParamater = (RfField)hid.firstResolvedParent(RfField.class)) != null && potentialTypeParamater.isTypeParameter()) {
                        return SDataAbstracts.UNDEFINED;
                    }
                }
            }
            if (operand.getHidKind() == IHidObject.HidKind.ACCESS) {
                ELWidthCheckContext parentElabContext;
                HidAccess access = (HidAccess)operand;
                Hid parentHid = access.getParentHid();
                isNetType = parentHid.getElement() instanceof RfField && ((RfField)parentHid.getElement()).hasUserDefinedNetType(true);
                resolvedElement = access.getAssociatedType();
                if (parentHid.getParentAccess() != null) {
                    scope = parentHid.getParentAccess().getAssociatedType();
                }
                if (reducedChecks && resolvedElement instanceof IRfSpecializedType) {
                    resolvedElement = ((IRfSpecializedType)resolvedElement).getGenericElement();
                } else if (reducedChecks && resolvedElement instanceof RfComputedStruct) {
                    resolvedElement = ((RfComputedStruct)resolvedElement).getOriginal();
                }
                if (access instanceof RfHidAccess && (parentElabContext = ((RfHidAccess)access).getElabDesignContext()) != null) {
                    ELWidthCheckContext copy = parentElabContext.getCopy();
                    copy.setReducedChecks(reducedChecks);
                    elabContext = copy;
                }
                if (access.isSelect()) {
                    IRfNamedElement parentHidElement = parentHid != null ? parentHid.getElement() : null;
                    isVariable = parentHidElement == null || parentHidElement instanceof IRfFieldElement && !((IRfFieldElement)parentHidElement).isTypeParameter() || parentHidElement instanceof IRfMethodElement;
                } else if (access instanceof RfHidAccessArgs) {
                    IHidObject value;
                    ISDataAbstract actual;
                    ISDataType actualType;
                    List argValues;
                    String name;
                    isWithClause = ((RfHidAccessArgs)access).getWithClause() != null && ((RfHidAccessArgs)access).getWithClause().isWithClause();
                    isVariable |= isWithClause;
                    resolvedElement = parentHid.getElement();
                    String string = name = parentHid != null ? parentHid.getName() : null;
                    if (("$signed".equals(name) || "$unsigned".equals(name) || "$past".equals(name) || "$sampled".equals(name)) && (argValues = ((IHidAccessArgs)access).getArgumentValues()) != null && !argValues.isEmpty() && (actualType = SDataUtils.getDataType((ISDataAbstract)(actual = this.getDataType(value = MethodCallUtils.getValue((IHidObject)((IHidObject)argValues.get(0))), operatorInfo)))) instanceof SDataType) {
                        SDataVariable actualVariable = SDataUtils.getVariable((ISDataAbstract)actual);
                        ISDataType newDataType = actualType.copy(false);
                        if ("$signed".equals(name)) {
                            newDataType.setSign(1);
                        } else if ("$unsigned".equals(name)) {
                            newDataType.setSign(0);
                        }
                        return SDataVariable.of((ISDataType)newDataType, (actualVariable != null && actualVariable.isFinal ? 1 : 0) != 0);
                    }
                }
                if (resolvedElement == null && parentHid != null && parentHid.getParentHid() != null && (potentialTypeParamater = (RfField)parentHid.getParentHid().firstResolvedParent(RfField.class)) != null && potentialTypeParamater.isTypeParameter()) {
                    return SDataAbstracts.UNDEFINED;
                }
            }
            if ((encryptedCodeAutoDefine = this.configInfo.getEncryptedCodeAutoDefine()) != null && encryptedCodeAutoDefine.hasEnabledEncryptedCodeAuto() && operatorInfo != null) {
                IHidObject op = operand;
                if (op instanceof RfHidAccessArgs) {
                    op = ((RfHidAccessArgs)op).getParentHid();
                }
                if (op instanceof RfHid && resolvedElement != null) {
                    RfEncryptedCodeAutoManager.computeEncryptedCodeAutoInOperatorEngine((RfHid)op, operatorInfo.getOperator(), encryptedCodeAutoDefine, this.getScope(), this.parserPath);
                }
            }
            if (resolvedElement == null || resolvedElement instanceof RfErrorImplicitField) {
                return SDataAbstracts.UNDEFINED;
            }
            boolean isFinal = resolvedElement instanceof RfField && ((RfField)resolvedElement).isEnumElement();
            ISDataAbstract result = SDataAbstracts.get((IRfNamedElement)resolvedElement, (IRfNamedElement)scope, (ELWidthCheckContext)elabContext, null, (LanguageKind)LANG_KIND, (boolean)isFinal, (boolean)isVariable, (boolean)this.dimensionsWithMacros, (boolean)isNetType, (boolean)this.isIrunRNMTech);
            if (isWithClause) {
                result = this.resolveWithClause((RfHidAccessArgs)operand, result);
            }
            return result;
        }

        protected ISDataAbstract getDataTypeForImplicit(IHidObject hidObject, ELWidthCheckContext elabContext, IRfNamedElement scope) {
            RfHidImplicit operand = (RfHidImplicit)hidObject;
            if (operand.isLiteralNull()) {
                return SDataAbstracts.get((IRfNamedElement)SDataAbstracts.NULL_IMPLICIT, (IRfNamedElement)scope, (ELWidthCheckContext)elabContext, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            }
            if (operand.isStringLiteral()) {
                return SDataAbstracts.get((IRfNamedElement)STransformer.LITERAL_STRING_DUMMY, (IRfNamedElement)scope, (ELWidthCheckContext)elabContext, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            }
            String name = operand.getName();
            if (operand.isNumber()) {
                IRfNamedElement dataType = operand.isRealtimeNumber() ? this.makeDataTypeForRealtime() : this.makeDataTypeForNumeric(name);
                return SDataAbstracts.get((IRfNamedElement)dataType, (IRfNamedElement)scope, (ELWidthCheckContext)elabContext, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
            }
            if (operand.isID()) {
                RfField field = STransformer.resolveImplicit(name, scope);
                return SDataAbstracts.get((IRfNamedElement)field, (IRfNamedElement)scope, (ELWidthCheckContext)elabContext, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)this.isIrunRNMTech);
            }
            if (operand.isEmptyJump()) {
                return SDataAbstracts.get((IRfNamedElement)STransformer.VOID_IMPLICIT, (IRfNamedElement)scope, (ELWidthCheckContext)elabContext, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            }
            if (operand.isEmptyQueue()) {
                return SDataAbstracts.get((IRfNamedElement)STransformer.EMPTY_QUEUE_DUMMY, (IRfNamedElement)scope, (ELWidthCheckContext)elabContext, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            }
            if (operand.isDollar() || operand.isStar()) {
                return SDataAbstracts.get((IRfNamedElement)STransformer.INTEGER_IMPLICIT, (IRfNamedElement)scope, (ELWidthCheckContext)elabContext, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            }
            if (operand.isLiteralNew()) {
                return SDataAbstracts.get((IRfNamedElement)SDataAbstracts.NEW_IMPLICIT, (IRfNamedElement)scope, (ELWidthCheckContext)elabContext, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            }
            if (operand.isLiteralSigned()) {
                return SDataAbstracts.get((IRfNamedElement)STransformer.SIGNED_IMPLICIT, (IRfNamedElement)scope, (ELWidthCheckContext)elabContext, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            }
            if (operand.isLiteralUnsigned()) {
                return SDataAbstracts.get((IRfNamedElement)STransformer.UNSIGNED_IMPLICIT, (IRfNamedElement)scope, (ELWidthCheckContext)elabContext, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            }
            if (operand.isLiteralConst()) {
                return SDataAbstracts.get((IRfNamedElement)STransformer.CONST_IMPLICIT, (IRfNamedElement)scope, (ELWidthCheckContext)elabContext, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            }
            if (name == null) {
                return null;
            }
            SDataTypeAndCategoryPair categoryPair = SDataAbstracts.getKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType(name)));
            if (categoryPair != null && categoryPair.getDataType() != null) {
                IRfNamedElement dataType = categoryPair.getDataType().getType();
                boolean isFinal = !(scope instanceof RfStruct) || dataType instanceof RfField && ((RfField)dataType).isEnumElement();
                return SDataAbstracts.get((IRfNamedElement)dataType, (IRfNamedElement)scope, (ELWidthCheckContext)elabContext, null, (LanguageKind)LANG_KIND, (boolean)isFinal, (boolean)false, (boolean)false, (boolean)false, (boolean)this.isIrunRNMTech);
            }
            return SDataAbstracts.UNDEFINED;
        }

        private IRfNamedElement makeDataTypeForRealtime() {
            return STransformer.REALTIME_IMPLICIT;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private IRfNamedElement makeDataTypeForNumeric(String name) {
            StringBuilder actualNumber = new StringBuilder();
            int numberBase = 10;
            boolean isZero = "0".equals(name);
            if (isZero) return RfBitVectorScalarType.INTEGER;
            if ("1".equals(name)) {
                return RfBitVectorScalarType.INTEGER;
            }
            try {
                int length = name.length();
                int i = 0;
                while (true) {
                    if (i >= length) {
                        if (actualNumber.length() != 0) return RfBitVectorScalarType.INTEGER;
                        return null;
                    }
                    char currentCharacter = name.charAt(i);
                    if (currentCharacter != '_') {
                        if (currentCharacter == '.') {
                            return STransformer.REAL_IMPLICIT;
                        }
                        if (currentCharacter == '\'') {
                            RfBitVectorScalarType rfBitVectorScalarType;
                            int nofBits = 32;
                            if (actualNumber.length() != 0) {
                                nofBits = Integer.parseInt(actualNumber.toString());
                            }
                            actualNumber.setLength(0);
                            if (i + 1 >= length) {
                                return null;
                            }
                            int sign = 2;
                            char first = name.charAt(i + 1);
                            boolean has4State = false;
                            if (Character.isAlphabetic(first)) {
                                char baseChar = first;
                                ++i;
                                if (first == 's' || first == 'S') {
                                    if (i + 1 >= length) {
                                        return null;
                                    }
                                    sign = 1;
                                    baseChar = name.charAt(i + 1);
                                    ++i;
                                }
                                if ((numberBase = DVTStringUtil.numberBaseVLOG((char)baseChar)) <= 0) {
                                    return null;
                                }
                                String restOfNumber = name.substring(i + 1);
                                if (restOfNumber.contains("X") || restOfNumber.contains("x") || restOfNumber.contains("Z") || restOfNumber.contains("z")) {
                                    has4State = true;
                                }
                            }
                            if (has4State) {
                                rfBitVectorScalarType = RfBitVectorScalarType.LOGIC;
                                return RfComputedListType.of(rfBitVectorScalarType, nofBits, sign);
                            }
                            rfBitVectorScalarType = RfBitVectorScalarType.BIT;
                            return RfComputedListType.of(rfBitVectorScalarType, nofBits, sign);
                        }
                        if (!Character.isDigit(currentCharacter)) {
                            if (currentCharacter == 'e') return STransformer.REAL_IMPLICIT;
                            if (currentCharacter != 'E') return null;
                            return STransformer.REAL_IMPLICIT;
                        }
                        actualNumber.append(currentCharacter);
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Deprecated
        private int getNofBits(BigInteger bigNumber, boolean hasBaseNotation) {
            double numberOfBits = StrictMath.log(bigNumber.doubleValue()) / StrictMath.log(2.0);
            double fractionalPart = numberOfBits % 1.0;
            int integralPart = (int)(numberOfBits - fractionalPart);
            return integralPart + 1 + (hasBaseNotation ? 0 : 1);
        }

        private static class PartialOperator {
            private HidOperator operator;
            private SContext context;
            private OperatorInfo operatorInfo;
            private List<PartialOperator> operands;
            private SOperation currentOperation;
            private boolean isTransformed;
            private boolean isReplicatedConcatenationCondition;
            private ISDataAbstract resolved;

            public PartialOperator(HidOperator hidOperator, SContext context) {
                this.operator = hidOperator;
                this.context = context;
            }

            public boolean hasOperator() {
                return this.operator != null;
            }

            public PartialOperator(ISDataAbstract resolved) {
                this.resolved = resolved;
                this.isTransformed = false;
            }

            public void setTransformed(boolean isTransformed) {
                this.isTransformed = isTransformed;
            }

            public void setReplicatedConcatenationCondition(boolean value) {
                this.isReplicatedConcatenationCondition = value;
            }

            public void setOperator(HidOperator operator) {
                this.operator = operator;
            }

            public void setContext(SContext context) {
                this.context = context;
            }

            public boolean isResolved() {
                return this.resolved != null;
            }

            public void setOperands(List<PartialOperator> operands) {
                this.operands = operands;
            }

            public List<PartialOperator> getOperands() {
                return this.operands;
            }

            public void setOperatorInfo(OperatorInfo operatorInfo2) {
                this.operatorInfo = operatorInfo2;
            }

            public void setCurrentOperation(SOperation currentOperation) {
                this.currentOperation = currentOperation;
            }
        }
    }
}

