/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.semantic.extension2;

import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfTypeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.OperatorInfo;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataTypeCategory;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataVariable;
import ro.amiq.dvt.model.reflection.util.AssociationUtils;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.IDVTRangeSelectable;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.VlogAbstractRealNumber;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfAssociatedType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfComputedListType;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfCovercross;
import ro.amiq.vlogdt.model.reflection.RfErrorImplicitField;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSemanticError;
import ro.amiq.vlogdt.model.reflection.RfSpecializedVirtualInterface;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.RfVirtualModport;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfRealScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfStringType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.IRfHidImplicitLayer;
import ro.amiq.vlogdt.model.reflection.semantic.extension.IRfHidOperatorLayer;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.ParticularOperations;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SContext;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SDataType;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SEvaluator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;

public abstract class SOperation {
    public static final Arithmetic ARITHMETIC_INSTANCE = new Arithmetic();
    public static final Modulo MODULO_INSTANCE = new Modulo();
    public static final Relational RELATIONAL_INSTANCE = new Relational();
    public static final Logical LOGICAL_INSTANCE = new Logical();
    public static final Reduction REDUCTION_INSTANCE = new Reduction();
    public static final BitWise BITWISE_INSTANCE = new BitWise();
    public static final Equality EQUALITY_INSTANCE = new Equality();
    public static final Assignment ASSIGNMENT_INSTANCE = new Assignment();
    public static final BinAssignment BIN_ASSIGNMENT = new BinAssignment();
    public static final PortConnection PORT_CONNECTION_INSTANCE = new PortConnection();
    public static final ArgumentValue ARG_VALUE_INSTANCE = new ArgumentValue();
    public static final ParameterValue PARAMETER_VALUE_INSTANCE = new ParameterValue();
    public static final Cast CAST_INSTANCE = new Cast();
    public static final VoidCast VOID_CAST_INSTANCE = new VoidCast();
    public static final TernaryIF TERNARY_INSTANCE = new TernaryIF();
    public static final Concatenation CONCATENATION_INSTANCE = new Concatenation();
    public static final UnpackedConcatenation UNPACKED_CONCATENATION_INSTANCE = new UnpackedConcatenation();
    public static final AssignmentPattern ASSIGNMENT_PATTERN_INSTANCE = new AssignmentPattern();
    public static final AssignmentPatternElement ASSIGNMENT_PATTERN_ELEMENT_INSTANCE = new AssignmentPatternElement();
    public static final EventTrigger EVENT_TRIGGER_INSTANCE = new EventTrigger();
    public static final ClockOperationsOR CLOCK_OPERATIONS_INSTANCE = new ClockOperationsOR();
    public static final EventControl EVENT_CONTROL_INSTANCE = new EventControl();
    public static final Inside INSIDE_INSTANCE = new Inside();
    public static final SetOrList SET_OR_LIST_INSTANCE = new SetOrList();
    public static final InsideSet INSIDE_SET_INSTANCE = new InsideSet();
    public static final Distribution DISTRIBUTION_INSTANCE = new Distribution();
    public static final UniqueConstraint UNIQUE_CONSTRAINT_INSTANCE = new UniqueConstraint();
    public static final SolveBeforeConstraint SOLVE_BEFORE_CONSTRAINT_INSTANCE = new SolveBeforeConstraint();
    public static final WithClause WITH_CLAUSE_INSTANCE = new WithClause();
    public static final Return RETURN_INSTANCE = new Return();
    public static final Continue CONTINUE_INSTANCE = new Continue();
    public static final Break BREAK_INSTANCE = new Break();
    public static final CaseItemCondition CASE_ITEM_CONDITION_INSTANCE = new CaseItemCondition();
    public static final WithCoverpointBinsExpression WITH_COVERPOINT_BINS_EXPRESSION = new WithCoverpointBinsExpression();
    public static final DisableConstraint DISABLE_CONSTRAINT_INSTANCE = new DisableConstraint();
    public static final Undefined UNDEFINED = new Undefined();
    public static final Set<Integer> PARTICULAR_OPERATIONS = new HashSet<Integer>();

    static {
        PARTICULAR_OPERATIONS.add(IHidOperatorConstants.OperatorType.IF_CONDITION.id);
        PARTICULAR_OPERATIONS.add(IHidOperatorConstants.OperatorType.FOR_CONDITION.id);
        PARTICULAR_OPERATIONS.add(IHidOperatorConstants.OperatorType.WHILE_CONDITION.id);
        PARTICULAR_OPERATIONS.add(IHidOperatorConstants.OperatorType.REPEAT_CONDITION.id);
        PARTICULAR_OPERATIONS.add(IHidOperatorConstants.OperatorType.FOREACH_CONDITION.id);
        PARTICULAR_OPERATIONS.add(IHidOperatorConstants.OperatorType.CASE_CONDITION.id);
        PARTICULAR_OPERATIONS.add(IHidOperatorConstants.OperatorType.CASE_ITEM_CONDITION.id);
        PARTICULAR_OPERATIONS.add(IHidOperatorConstants.OperatorType.COVERPOINT_EXPRESSION.id);
    }

    protected abstract ISDataType checkOperands(ConfigInfo var1, boolean var2, OperatorInfo var3, List<ISDataAbstract> var4, SContext var5);

    public abstract ISDataAbstract calculate(ConfigInfo var1, boolean var2, OperatorInfo var3, List<ISDataAbstract> var4, SContext var5);

    public Map<String, Object> getAttributesForElabPaths(String elabPaths) {
        if (elabPaths == null || elabPaths.isEmpty()) {
            return null;
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
        attributes.put("ELAB_PROBLEMS_ELEMENTPATH_ATTRIBUTE", elabPaths);
        return attributes;
    }

    public ISDataAbstract getResolvedTypeAccordingToPriority(OperatorInfo operatorInfo, List<ISDataAbstract> operands) {
        ISDataAbstract first = operands.get(0);
        ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)first);
        SDataTypeCategory firstCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)firstDataType);
        if (operands.size() == 1) {
            ISDataType oldType;
            ISDataType iSDataType = oldType = firstDataType.getEnumElementType() != SDataAbstracts.UNDEFINED ? firstDataType.getEnumElementType() : firstDataType;
            if (oldType != null) {
                ISDataType newType = oldType.copy(true);
                newType.setSign(oldType.getSign());
                return SDataVariable.of((ISDataType)newType, (boolean)false);
            }
            return SDataVariable.of((ISDataType)firstDataType, (boolean)false);
        }
        ISDataAbstract second = operands.get(1);
        ISDataType secondDataType = SDataUtils.getDataType((ISDataAbstract)second);
        IRfNamedElement firstType = firstDataType.getType();
        IRfNamedElement secondType = secondDataType.getType();
        if ((firstType instanceof RfBitVectorScalarType || firstType instanceof RfComputedListType) && (secondType instanceof RfBitVectorScalarType || secondType instanceof RfComputedListType)) {
            long secondNumberOfBits;
            long firstNumberOfBits = ((IRfTypeElement)firstType).getBitSize();
            if (firstNumberOfBits > (secondNumberOfBits = (long)((IRfTypeElement)secondType).getBitSize())) {
                return SDataVariable.of((ISDataType)firstDataType, (boolean)false);
            }
            if (firstNumberOfBits < secondNumberOfBits) {
                return SDataVariable.of((ISDataType)secondDataType, (boolean)false);
            }
            if (firstNumberOfBits == secondNumberOfBits) {
                if (firstDataType.isSigned() && !secondDataType.isSigned()) {
                    return SDataVariable.of((ISDataType)firstDataType, (boolean)false);
                }
                if (secondDataType.isSigned() && !firstDataType.isSigned()) {
                    return SDataVariable.of((ISDataType)secondDataType, (boolean)false);
                }
                return SDataVariable.of((ISDataType)firstDataType, (boolean)false);
            }
        }
        SDataTypeCategory secondCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)secondDataType);
        if (firstCategory == SDataTypeCategory.REAL) {
            return SDataVariable.of((ISDataType)firstDataType, (boolean)false);
        }
        if (secondCategory == SDataTypeCategory.REAL) {
            return SDataVariable.of((ISDataType)secondDataType, (boolean)false);
        }
        if (firstCategory == SDataTypeCategory.SHORTREAL) {
            return SDataVariable.of((ISDataType)firstDataType, (boolean)false);
        }
        if (secondCategory == SDataTypeCategory.SHORTREAL) {
            return SDataVariable.of((ISDataType)secondDataType, (boolean)false);
        }
        if (firstCategory == SDataTypeCategory.ENUM) {
            if (secondCategory == SDataTypeCategory.ENUM) {
                ISDataType secondDataTypeIntegral;
                ISDataType firstDataTypeIntegral = firstDataType.getEnumElementType() != SDataAbstracts.UNDEFINED ? firstDataType.getEnumElementType() : firstDataType;
                ISDataType iSDataType = secondDataTypeIntegral = secondDataType.getEnumElementType() != SDataAbstracts.UNDEFINED ? secondDataType.getEnumElementType() : secondDataType;
                if (firstDataType == firstDataTypeIntegral && secondDataType == secondDataTypeIntegral) {
                    return SDataAbstracts.UNDEFINED;
                }
                ArrayList<ISDataAbstract> newOperands = new ArrayList<ISDataAbstract>(2);
                newOperands.add((ISDataAbstract)firstDataTypeIntegral);
                newOperands.add((ISDataAbstract)secondDataTypeIntegral);
                return this.getResolvedTypeAccordingToPriority(operatorInfo, newOperands);
            }
            return SDataVariable.of((ISDataType)secondDataType, (boolean)false);
        }
        return SDataVariable.of((ISDataType)firstDataType, (boolean)false);
    }

    private static final ISDataType acceptOperandsNature(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands) {
        int i = 0;
        while (i < operands.size()) {
            ISDataAbstract operand = operands.get(i);
            ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)operand);
            if (dataType == SDataAbstracts.ILLEGAL) {
                return SDataAbstracts.UNDEFINED;
            }
            if (dataType == SDataAbstracts.NON_STANDARD) {
                return SDataAbstracts.UNDEFINED;
            }
            if (dataType == SDataAbstracts.TYPE_UNDEFINED) {
                return SDataAbstracts.TYPE_UNDEFINED;
            }
            if (dataType == SDataAbstracts.PARAMETER_UNTYPED) {
                return SDataAbstracts.PARAMETER_UNTYPED;
            }
            if (dataType == STransformer.VOID_DATA_TYPE) {
                IRfNamedElement candidateFunction;
                SDataVariable variable = SDataUtils.getVariable((ISDataAbstract)operand);
                IRfNamedElement iRfNamedElement = candidateFunction = variable != null ? variable.getVariable() : null;
                if (!(!(candidateFunction instanceof RfFunction) || candidateFunction instanceof RfPredefinedFunction && RfPredefinedFunction.PREDEFINED_BOTH_TASK_AND_FUNCTION.contains(candidateFunction.getName()))) {
                    SOperation.addSemanticError(configInfo, triggerError, operatorInfo, ((RfFunction)candidateFunction).isTask() ? "ILLEGAL_EXPRESSION: Task ''{0}'' cannot be used as an expression" : "ILLEGAL_EXPRESSION: Void function ''{0}'' cannot be used as an expression", null, SDataUtils.getVariableName((ISDataAbstract)variable, null));
                }
                return STransformer.VOID_DATA_TYPE;
            }
            SDataTypeCategory category = SDataAbstracts.getOperandCategory((ISDataAbstract)operand);
            if (category == SDataTypeCategory.UNKNOWN) {
                return SDataAbstracts.UNDEFINED;
            }
            if (!(operand instanceof SDataVariable) && category != SDataTypeCategory.MODPORT && category != SDataTypeCategory.CONSTRAINT) {
                return dataType;
            }
            ++i;
        }
        return null;
    }

    protected ISDataType checkValidOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
        IRfNamedElement scope;
        ISDataType nonValidOperand = SOperation.acceptOperandsNature(configInfo, triggerError, operatorInfo, operands);
        if (nonValidOperand == null) {
            return null;
        }
        if (nonValidOperand == SDataAbstracts.UNDEFINED) {
            return SDataAbstracts.UNDEFINED;
        }
        if (nonValidOperand == SDataAbstracts.TYPE_UNDEFINED) {
            return SDataAbstracts.TYPE_UNDEFINED;
        }
        if (nonValidOperand == SDataAbstracts.PARAMETER_UNTYPED) {
            return SDataAbstracts.PARAMETER_UNTYPED;
        }
        if (nonValidOperand == STransformer.VOID_DATA_TYPE) {
            return SDataAbstracts.ILLEGAL;
        }
        SDataType dataType = (SDataType)nonValidOperand;
        if (dataType.getType() instanceof RfInterface && context != null && context.contextOperation instanceof Assignment && operands.size() == 2 && nonValidOperand == operands.get(1) && (scope = operatorInfo.getScope()) != null && scope.getEnclosingScope(RfInterface.class) != null) {
            if (triggerError) {
                SOperation.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_INTERFACE_NAME_SELF_REFERENCE, null, dataType.getName(configInfo.isSemanticShowAliasName()));
            }
            return SDataAbstracts.NON_STANDARD;
        }
        SOperation.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_TYPE_REFERENCE: ''{0}'' cannot be resolved to a variable", null, dataType.getName(configInfo.isSemanticShowAliasName()));
        return SDataAbstracts.ILLEGAL;
    }

    protected static void addSemanticWarning(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, String message, Map<String, Object> attributes, Object ... arguments) {
        if (triggerError) {
            SOperation.addSemanticProblem(configInfo, 2, operatorInfo, message, attributes, arguments);
        }
    }

    protected static void addSemanticError(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, String message, Map<String, Object> attributes, Object ... arguments) {
        if (triggerError) {
            SOperation.addSemanticProblem(configInfo, 1, operatorInfo, message, attributes, arguments);
        }
    }

    protected static void addSemanticErrorWithOffsets(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, String message, Map<String, Object> attributes, int startOffset, int endOffset, Object ... arguments) {
        if (triggerError) {
            SOperation.addSemanticProblem(configInfo, 1, operatorInfo, message, attributes, startOffset, endOffset, arguments);
        }
    }

    protected static void addSemanticProblem(ConfigInfo configInfo, int problemType, OperatorInfo operatorInfo, String message, Map<String, Object> attributes, Object ... arguments) {
        IRfNamedElement scope = operatorInfo.getScope();
        if (scope == null) {
            return;
        }
        HidOperatorOccurrence occurrence = operatorInfo.getOperator().getOccurrence();
        if (occurrence == null) {
            return;
        }
        int line = occurrence.getLine();
        int startOffset = occurrence.getOpenBoundaryOutsideMacro();
        int endOffset = occurrence.getCloseBoundaryOutsideMacro();
        RfProject rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vlogdt.VlogNature");
        rfProject.addSemanticError(problemType, message, scope.getLibPkgScope(), startOffset, endOffset, attributes, line, operatorInfo.getParserPath(), arguments);
    }

    protected static void addSemanticProblem(ConfigInfo configInfo, int problemType, OperatorInfo operatorInfo, String message, Map<String, Object> attributes, int startOffset, int endOffset, Object ... arguments) {
        IRfNamedElement scope = operatorInfo.getScope();
        if (scope == null) {
            return;
        }
        HidOperatorOccurrence occurrence = operatorInfo.getOperator().getOccurrence();
        if (occurrence == null) {
            return;
        }
        int line = occurrence.getLine();
        RfProject rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vlogdt.VlogNature");
        rfProject.addSemanticError(problemType, message, scope.getLibPkgScope(), startOffset, endOffset, attributes, line, operatorInfo.getParserPath(), arguments);
    }

    protected static void addAssignmentPatternLHSideSemanticError(ConfigInfo configInfo, OperatorInfo operatorInfo, String message) {
        IHid formalPart;
        IHid iHid = formalPart = operatorInfo.getOperator().getLHValue() instanceof IHid ? (IHid)operatorInfo.getOperator().getLHValue() : null;
        if (formalPart == null) {
            return;
        }
        IRfNamedElement scope = operatorInfo.getScope();
        if (scope == null) {
            return;
        }
        HidOccurrence occurrence = formalPart.getOccurrence();
        if (occurrence == null) {
            return;
        }
        int line = occurrence.getLine();
        int startOffset = occurrence.getOffsetOutsideMacro();
        int endOffset = startOffset == -1 ? -1 : startOffset + formalPart.getName().length();
        RfProject rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vlogdt.VlogNature");
        rfProject.addSemanticError(1, message, scope.getLibPkgScope(), startOffset, endOffset, null, line, operatorInfo.getParserPath(), formalPart.getName());
    }

    public ISDataType isUnsupportedTypeParameter(List<ISDataAbstract> operands) {
        for (ISDataAbstract operand : operands) {
            if (SDataUtils.getDataType((ISDataAbstract)operand) == SDataAbstracts.ILLEGAL) {
                return SDataAbstracts.UNDEFINED;
            }
            if (SDataUtils.getDataType((ISDataAbstract)operand) == SDataAbstracts.NON_STANDARD) {
                return SDataAbstracts.UNDEFINED;
            }
            if (SDataUtils.getDataType((ISDataAbstract)operand) == SDataAbstracts.TYPE_UNDEFINED) {
                return SDataAbstracts.TYPE_UNDEFINED;
            }
            SDataTypeCategory category = SDataAbstracts.getOperandCategory((ISDataAbstract)operand);
            if (category != SDataTypeCategory.UNKNOWN) continue;
            return SDataAbstracts.UNDEFINED;
        }
        return null;
    }

    public static SOperation getOperation(HidOperator hidOperator, SContext context) {
        RfHidOperator operator = (RfHidOperator)hidOperator;
        if (operator.isArithmetic() || operator.isIncrementOrDecrement() || operator.isArithmeticShift()) {
            return ARITHMETIC_INSTANCE;
        }
        if (operator.isModulo()) {
            return MODULO_INSTANCE;
        }
        if (operator.isRelational()) {
            return RELATIONAL_INSTANCE;
        }
        if (operator.isEqualityOrInequality() || operator.isWildcardEquality()) {
            return EQUALITY_INSTANCE;
        }
        if (operator.isLogical()) {
            return LOGICAL_INSTANCE;
        }
        if (operator.isReduction()) {
            return REDUCTION_INSTANCE;
        }
        if (operator.isBinaryBitwise() || operator.isBitwiseNot() || operator.isLogicalShift()) {
            return BITWISE_INSTANCE;
        }
        if (operator.hasOccurrence(HidOperatorQualifier.IS_PATTERN_VALUE)) {
            if (context == null || ASSIGNMENT_PATTERN_INSTANCE != context.contextOperation && UNPACKED_CONCATENATION_INSTANCE != context.contextOperation) {
                return UNDEFINED;
            }
            return ASSIGNMENT_PATTERN_ELEMENT_INSTANCE;
        }
        if (operator.isBinAssignment()) {
            return BIN_ASSIGNMENT;
        }
        if (operator.isAssignment()) {
            return ASSIGNMENT_INSTANCE;
        }
        if (operator.isTickCast()) {
            return CAST_INSTANCE;
        }
        if (operator.isVoidCast()) {
            return VOID_CAST_INSTANCE;
        }
        if (operator.isConditionalTernary()) {
            return TERNARY_INSTANCE;
        }
        if (operator.isAssignmentPattern()) {
            return ASSIGNMENT_PATTERN_INSTANCE;
        }
        if (operator.isNonStandardAssignmentPattern()) {
            if (context != null && INSIDE_SET_INSTANCE == context.contextOperation) {
                return CONCATENATION_INSTANCE;
            }
            return ASSIGNMENT_PATTERN_INSTANCE;
        }
        if (operator.isVLOGConcatenation(false)) {
            return SOperation.internalHasUnpackedArrayContext(context) ? UNPACKED_CONCATENATION_INSTANCE : CONCATENATION_INSTANCE;
        }
        if (operator.isEventTrigger()) {
            return EVENT_TRIGGER_INSTANCE;
        }
        if (operator.isEventControlOR()) {
            return CLOCK_OPERATIONS_INSTANCE;
        }
        if (operator.isEventControl() || operator.isAnyEdgeEvent()) {
            return EVENT_CONTROL_INSTANCE;
        }
        if (operator.isInside()) {
            return INSIDE_INSTANCE;
        }
        if (operator.isInsideSet()) {
            return INSIDE_SET_INSTANCE;
        }
        if (operator.isComma() || operator.isCovergroupRangeList() || operator.isDistSet()) {
            return SET_OR_LIST_INSTANCE;
        }
        if (operator.isDistribution()) {
            return DISTRIBUTION_INSTANCE;
        }
        if (operator.isWithClause() || operator.isWithClauseConstraint()) {
            return WITH_CLAUSE_INSTANCE;
        }
        if (operator.isReturnStatement()) {
            return RETURN_INSTANCE;
        }
        if (operator.isContinueStatement()) {
            return CONTINUE_INSTANCE;
        }
        if (operator.isBreakStatement()) {
            return BREAK_INSTANCE;
        }
        if (operator.isCaseItemCondition()) {
            return CASE_ITEM_CONDITION_INSTANCE;
        }
        if (operator.isWithCoverpointBinsExpression()) {
            return WITH_COVERPOINT_BINS_EXPRESSION;
        }
        if (PARTICULAR_OPERATIONS.contains(operator.getOperatorType()) || operator.isPound() || operator.isColonEq()) {
            return new ParticularOperations(operator);
        }
        if (operator.isDisableSoftConstraint()) {
            return DISABLE_CONSTRAINT_INSTANCE;
        }
        if (operator.isSolveBeforeOperators()) {
            return SOLVE_BEFORE_CONSTRAINT_INSTANCE;
        }
        if (operator.isUniquenessConstraint()) {
            return UNIQUE_CONSTRAINT_INSTANCE;
        }
        return UNDEFINED;
    }

    private static boolean internalHasUnpackedArrayContext(SContext context) {
        if (context == null) {
            return false;
        }
        SDataTypeCategory contextCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)context.getContextDataType());
        return context.contextOperation instanceof Assignment && (SDataTypeCategory.FIXED_SIZE_ARRAY_UNPACKED == contextCategory || SDataTypeCategory.ASSOCIATIVE_ARRAY == contextCategory || SDataTypeCategory.DYNAMIC_ARRAY == contextCategory || SDataTypeCategory.QUEUE == contextCategory);
    }

    private static boolean internalCheckStringOperand(ISDataType op) {
        if (op == null) {
            return false;
        }
        if (op == STransformer.LITERAL_STRING_DATA_TYPE) {
            return true;
        }
        if (op.getType() instanceof RfStringType && SDataAbstracts.getDataTypeCategory((ISDataType)op) == SDataTypeCategory.STRING) {
            return true;
        }
        if (op.getType() instanceof IRfListType) {
            ISDataType cachedListType = op.getCachedListBaseElementType();
            if (cachedListType == STransformer.LITERAL_STRING_DATA_TYPE) {
                return true;
            }
            if (cachedListType.getType() instanceof RfStringType && SDataAbstracts.getDataTypeCategory((ISDataType)cachedListType) == SDataTypeCategory.STRING) {
                return true;
            }
        }
        return false;
    }

    private static Hid internalGetAssignmentRelevantHid(IHidObject lhValue) {
        if (HidUtils.isHidAccess((IHidObject)lhValue)) {
            lhValue = ((HidAccess)lhValue).getParentHid();
        }
        if (!HidUtils.isHid((IHidObject)lhValue)) {
            return null;
        }
        Hid lhHid = (Hid)lhValue;
        while (lhHid != null) {
            IRfNamedElement element = lhHid.getElement();
            if (!(element instanceof RfField) || !(element.getEnclosingScope() instanceof RfStruct) || ((RfField)element).isEnumElement()) break;
            lhHid = lhHid.getParentHid();
        }
        return lhHid;
    }

    private static boolean internalIsConstant(Hid hid, IRfNamedElement scope) {
        if (hid == null || !(hid.getElement() instanceof RfField)) {
            return false;
        }
        RfField field = (RfField)hid.getElement();
        if (field.isConstRef() || field.isEnumElement() || field.isParameter()) {
            return true;
        }
        if (field.isConst()) {
            if (scope == null || field.getInitialValue(false) != null) {
                return true;
            }
            RfFunction enclosingFunction = (RfFunction)scope.getEnclosingScope(RfFunction.class);
            return enclosingFunction == null || !enclosingFunction.isConstructor() || field.getEnclosingScope() != enclosingFunction.getEnclosingScope();
        }
        return false;
    }

    protected static class ArgumentValue
    extends Association {
        protected ArgumentValue() {
        }

        @Override
        public ISDataType internalCheckOperands(ConfigInfo configInfo, boolean triggerError, boolean forceCheckWidth, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            IHidObject rhValue;
            ISDataType result = super.internalCheckOperands(configInfo, triggerError, forceCheckWidth, operatorInfo, operands, context);
            if (result != null) {
                return result;
            }
            ISDataAbstract first = operands.get(0);
            ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)first);
            IRfNamedElement firstVariableElement = SDataUtils.getVariableElement((ISDataAbstract)first);
            ISDataAbstract second = operands.get(1);
            ISDataType secondDataType = SDataUtils.getDataType((ISDataAbstract)second);
            HidOperator operator = operatorInfo.getOperator();
            if (firstVariableElement != null && firstVariableElement.getEnclosingScope() instanceof RfFunction && SDataAbstracts.getOperandCategory((ISDataAbstract)firstDataType) == SDataTypeCategory.EVENT && SDataAbstracts.getOperandCategory((ISDataAbstract)secondDataType) == SDataTypeCategory.EVENT && HidUtils.isOperator((IHidObject)(rhValue = operator.getFirstRHValue()))) {
                ArgumentValue.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_ASSIGNMENT: Illegal assignment of {0} ''{1}'' to {2} ''{3}''", null, "event expression", SDataUtils.getVariableName((ISDataAbstract)second, (IHidObject)rhValue), "event " + this.getBaseMessageType(firstVariableElement), firstVariableElement.getName());
                return SDataAbstracts.ILLEGAL;
            }
            return null;
        }
    }

    private static class Arithmetic
    extends SOperation {
        public static final EnumSet<SDataTypeCategory> permittedOperands = EnumSet.of(SDataTypeCategory.NUMERIC, new SDataTypeCategory[]{SDataTypeCategory.SHORTREAL, SDataTypeCategory.REAL, SDataTypeCategory.LITERAL_STRING, SDataTypeCategory.ENUM, SDataTypeCategory.STRUCT_PACKED, SDataTypeCategory.UNION_PACKED, SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED});

        private Arithmetic() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            Hid lhHid;
            boolean isImplicitEnumAssign;
            int size;
            RfHidOperator operator = (RfHidOperator)operatorInfo.getOperator();
            boolean hasImplicitAssign = operator.isIncrementOrDecrement() || operator.isArithmeticAssignment();
            IRfNamedElement scope = operatorInfo.getScope();
            if (hasImplicitAssign) {
                while (scope instanceof RfActionBlock) {
                    scope = scope.getEnclosingScope();
                }
                if (scope instanceof RfConstraint) {
                    Arithmetic.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_CONSTRAINT_EXPRESSION: Operator ''{0}'' with side effects not allowed in constraint block item", null, operatorInfo.getOperator().getOperatorText());
                    return SDataAbstracts.ILLEGAL;
                }
            }
            if (1 > (size = operands.size()) || size > 2) {
                return SDataAbstracts.ILLEGAL;
            }
            ISDataType nonValidOperand = this.checkValidOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (nonValidOperand != null) {
                return nonValidOperand;
            }
            ISDataAbstract first = operands.get(0);
            ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)first);
            SDataTypeCategory firstCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)first);
            boolean bl = isImplicitEnumAssign = hasImplicitAssign && firstDataType instanceof SDataType && ((SDataType)firstDataType).isEnum();
            if (hasImplicitAssign && (lhHid = SOperation.internalGetAssignmentRelevantHid(operator.getLHValue())) != null && SOperation.internalIsConstant(lhHid, operatorInfo.getScope())) {
                boolean isRef = lhHid.getElement() instanceof RfField && ((RfField)lhHid.getElement()).isRef();
                Arithmetic.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_CONSTANT_ASSIGN: Constant{0,choice,0#|1# ref} ''{1}'' cannot be assigned", null, isRef ? 1 : 0, SDataUtils.getVariableName((ISDataAbstract)first, (IHidObject)lhHid));
                return SDataAbstracts.ILLEGAL;
            }
            if (size == 1) {
                if (isImplicitEnumAssign) {
                    SDataVariable firstVariable = SDataUtils.getVariable((ISDataAbstract)first);
                    if (triggerError && firstVariable != null) {
                        Arithmetic.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_ENUM_ASSIGNMENT, null, "int", firstVariable.getVariableName(), firstDataType);
                    }
                    return SDataAbstracts.NON_STANDARD;
                }
                if (!permittedOperands.contains(firstCategory)) {
                    Arithmetic.addSemanticError(configInfo, triggerError, operatorInfo, "UNDEFINED_OPERATOR: Operator ''{0}'' is undefined for argument type ''{1}''", null, operatorInfo.getOperator().getOperatorText(), firstDataType);
                    return SDataAbstracts.ILLEGAL;
                }
            } else {
                ISDataAbstract second = operands.get(1);
                SDataTypeCategory secondCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)second);
                ISDataType secondDataType = SDataUtils.getDataType((ISDataAbstract)second);
                if (isImplicitEnumAssign) {
                    SDataVariable firstVariable = SDataUtils.getVariable((ISDataAbstract)first);
                    if (triggerError && firstVariable != null) {
                        Arithmetic.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_ENUM_ASSIGNMENT, null, secondDataType, firstVariable.getVariableName(), firstDataType);
                    }
                    return SDataAbstracts.NON_STANDARD;
                }
                if (!permittedOperands.contains(firstCategory) || !permittedOperands.contains(secondCategory)) {
                    Arithmetic.addSemanticError(configInfo, true, operatorInfo, "UNDEFINED_OPERATOR: Operator ''{0}'' is undefined for argument types ''{1}'', ''{2}''", null, operatorInfo.getOperator().getOperatorText(), firstDataType, secondDataType);
                    return SDataAbstracts.ILLEGAL;
                }
            }
            return null;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            return this.getResolvedTypeAccordingToPriority(operatorInfo, operands);
        }
    }

    private static class Assignment
    extends Equality {
        private Assignment() {
        }

        @Override
        public ISDataType internalCheckOperands(ConfigInfo configInfo, boolean triggerError, boolean forceCheckWidth, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            SDataVariable firstVariable;
            boolean isOutputAssociation;
            IRfNamedElement blockingAssignVariable;
            boolean lhIsConstant;
            IRfNamedElement scope = operatorInfo.getScope();
            if (this.getClass() == Assignment.class) {
                while (scope instanceof RfActionBlock) {
                    scope = scope.getEnclosingScope();
                }
                if (scope instanceof RfConstraint) {
                    Assignment.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_CONSTRAINT_EXPRESSION: Operator ''{0}'' with side effects not allowed in constraint block item", null, operatorInfo.getOperator().getOperatorText());
                    return SDataAbstracts.ILLEGAL;
                }
            }
            this.internalCheckWidthForNumberLiteral(configInfo, operatorInfo);
            ISDataType result = super.internalCheckOperands(configInfo, triggerError, forceCheckWidth, operatorInfo, operands, context);
            if (result != null && result != SDataAbstracts.PARAMETER_UNTYPED) {
                return result;
            }
            ISDataAbstract first = operands.get(0);
            ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)first);
            IRfNamedElement firstType = firstDataType.getType();
            HidOperator operator = operatorInfo.getOperator();
            Hid lhHid = SOperation.internalGetAssignmentRelevantHid(operator.getLHValue());
            boolean bl = lhIsConstant = !operator.hasQualifier(HidQualifierCache.IS_DEFPARAM_ASSIGN_QUALIFIER) && SOperation.internalIsConstant(lhHid, operatorInfo.getScope());
            if (lhIsConstant && lhHid != null && !(this instanceof Association) && !(this instanceof AssignmentPatternElement)) {
                boolean isRef = lhHid.getElement() instanceof RfField && ((RfField)lhHid.getElement()).isRef();
                Assignment.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_CONSTANT_ASSIGN: Constant{0,choice,0#|1# ref} ''{1}'' cannot be assigned", null, isRef ? 1 : 0, SDataUtils.getVariableName((ISDataAbstract)first, (IHidObject)lhHid));
                return SDataAbstracts.ILLEGAL;
            }
            if (operator.hasOccurrence(HidOperatorQualifier.IS_NONBLOCKING_ASSIGN) && (blockingAssignVariable = this.internalGetBlockingAssignIllegalVariable(lhHid)) != null) {
                Assignment.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_NON_BLOCKING_ASSIGNMENT: Cannot use automatic variable ''{0}'' as left hand side in non-blocking assignment", null, blockingAssignVariable.getName());
            }
            ISDataAbstract second = operands.get(1);
            ISDataType secondDataType = SDataUtils.getDataType((ISDataAbstract)second);
            IRfNamedElement secondType = secondDataType.getType();
            SDataTypeCategory secondCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)second);
            boolean hasOutputDirection = operatorInfo.hasOutputDirection();
            IRfNamedElement firstVariableElement = !hasOutputDirection ? SDataUtils.getVariableElement((ISDataAbstract)first) : SDataUtils.getVariableElement((ISDataAbstract)second);
            boolean isAssociationOrArgumentDefaultValue = this instanceof Association || Assignment.isArgumentDefaultValueOperator(operatorInfo, firstVariableElement);
            boolean isRefAssociation = isAssociationOrArgumentDefaultValue && firstVariableElement instanceof RfField && ((RfField)firstVariableElement).isRef();
            boolean bl2 = isOutputAssociation = isAssociationOrArgumentDefaultValue && firstVariableElement instanceof RfField && (((RfField)firstVariableElement).isOutput() || ((RfField)firstVariableElement).isInout());
            if (first == SDataAbstracts.PARAMETER_UNTYPED) {
                if (SDataUtils.getUndefinedDataType((ISDataAbstract)secondDataType) == null && secondCategory != SDataTypeCategory.NUMERIC && secondCategory != SDataTypeCategory.REAL && secondCategory != SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED && secondCategory != SDataTypeCategory.SHORTREAL && secondCategory != SDataTypeCategory.LITERAL_STRING && secondCategory != SDataTypeCategory.STRING && secondCategory != SDataTypeCategory.ENUM && secondCategory != SDataTypeCategory.STRUCT_PACKED && secondCategory != SDataTypeCategory.UNION_PACKED) {
                    IHidObject lhValue = operator.getLHValue();
                    IRfNamedElement lhElement = lhValue instanceof Hid ? ((Hid)lhValue).getElement() : null;
                    Assignment.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_ASSIGNMENT: Illegal assignment of expression type ''{1}'' to untyped parameter ''{0}'' (only integral or real types allowed)", null, lhElement != null ? lhElement.getName() : HidUtils.toNiceString((IHidObject)lhValue), secondDataType.getName(configInfo.isSemanticShowAliasName()));
                    return SDataAbstracts.ILLEGAL;
                }
                return SDataAbstracts.PARAMETER_UNTYPED;
            }
            if (second == SDataAbstracts.PARAMETER_UNTYPED) {
                return SDataAbstracts.PARAMETER_UNTYPED;
            }
            if (isRefAssociation || isOutputAssociation) {
                IRfNamedElement secondVariableElement;
                IHidObject rhValue = operator.getFirstRHValue();
                if (HidUtils.isHidImplicit((IHidObject)rhValue)) {
                    Assignment.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_ASSIGNMENT: Illegal assignment of {0} ''{1}'' to {2} ''{3}''", null, "expression", SDataUtils.getVariableName((ISDataAbstract)(!hasOutputDirection ? second : first), (IHidObject)rhValue), this.getOutputRefMessageType(firstVariableElement), firstVariableElement.getName());
                    return SDataAbstracts.ILLEGAL;
                }
                if (HidUtils.isOperator((IHidObject)rhValue) && (isRefAssociation || !((HidOperator)rhValue).isConcatOrAssignPatternOperator())) {
                    IRfNamedElement lHSide;
                    IRfNamedElement iRfNamedElement = lHSide = this instanceof PortConnection ? SDataUtils.getVariableElement((ISDataAbstract)first) : null;
                    if (lHSide != null && !(lHSide.getEnclosingScope() instanceof RfChecker) && SDataAbstracts.getOperandCategory((ISDataAbstract)firstDataType) == SDataTypeCategory.EVENT && SDataAbstracts.getOperandCategory((ISDataAbstract)secondDataType) == SDataTypeCategory.EVENT) {
                        Assignment.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_ASSIGNMENT: Illegal assignment of {0} ''{1}'' to {2} ''{3}''", null, "event expression", SDataUtils.getVariableName((ISDataAbstract)second, (IHidObject)rhValue), "event " + this.getBaseMessageType(firstVariableElement), firstVariableElement.getName());
                        return SDataAbstracts.ILLEGAL;
                    }
                    Assignment.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_ASSIGNMENT: Illegal assignment of {0} ''{1}'' to {2} ''{3}''", null, "expression", SDataUtils.getVariableName((ISDataAbstract)(!hasOutputDirection ? second : first), (IHidObject)rhValue), this.getOutputRefMessageType(firstVariableElement), firstVariableElement.getName());
                    return SDataAbstracts.ILLEGAL;
                }
                if (isRefAssociation && HidUtils.isHidAccess((IHidObject)rhValue) && (((HidAccess)rhValue).isRangeSelect() || this.internalIsInvalidListSelectForRef((HidAccess)rhValue) || ((HidAccess)rhValue).isMethodCall(false))) {
                    Assignment.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_ASSIGNMENT: Illegal assignment of {0} ''{1}'' to {2} ''{3}''", null, "expression", SDataUtils.getVariableName((ISDataAbstract)(!hasOutputDirection ? second : first), (IHidObject)rhValue), this.getOutputRefMessageType(firstVariableElement), firstVariableElement.getName());
                    return SDataAbstracts.ILLEGAL;
                }
                IRfNamedElement iRfNamedElement = secondVariableElement = !hasOutputDirection ? SDataUtils.getVariableElement((ISDataAbstract)second) : SDataUtils.getVariableElement((ISDataAbstract)first);
                if (secondVariableElement instanceof RfField) {
                    if (((RfField)secondVariableElement).isParameter() || ((RfField)secondVariableElement).isEnumElement()) {
                        Assignment.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_ASSIGNMENT: Illegal assignment of {0} ''{1}'' to {2} ''{3}''", null, "constant", SDataUtils.getVariableName((ISDataAbstract)(!hasOutputDirection ? second : first), (IHidObject)rhValue), this.getOutputRefMessageType(firstVariableElement), firstVariableElement.getName());
                        return SDataAbstracts.ILLEGAL;
                    }
                    Hid rhHid = SOperation.internalGetAssignmentRelevantHid(rhValue);
                    if (!lhIsConstant && SOperation.internalIsConstant(rhHid, null)) {
                        Assignment.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_ASSIGNMENT: Illegal assignment of {0} ''{1}'' to {2} ''{3}''", null, "constant", SDataUtils.getVariableName((ISDataAbstract)(!hasOutputDirection ? second : first), (IHidObject)rhValue), "non-constant " + this.getOutputRefMessageType(firstVariableElement), firstVariableElement.getName());
                        return SDataAbstracts.ILLEGAL;
                    }
                }
            }
            if (firstType instanceof RfClass && secondType instanceof RfClass) {
                RfClass secondClass;
                RfClass firstClass = (RfClass)firstDataType.getType();
                if (firstClass.equals(secondClass = (RfClass)secondDataType.getType()) || !operatorInfo.isStrictClassMatching() && secondClass.isSubClass(firstClass, true, false)) {
                    return null;
                }
                this.addSemanticError(configInfo, triggerError, Equality.UndefinedOperatorMessageInfoKind.CLASSES, operatorInfo, first, firstDataType, second, secondDataType, false, context != null ? context.getElabPathForError() : "", 2, 0);
                return SDataAbstracts.ILLEGAL;
            }
            if (firstDataType instanceof SDataType && ((SDataType)firstDataType).isEnum() && !(firstVariable = SDataUtils.getVariable((ISDataAbstract)first)).isEnumDeclarationAssign(operatorInfo.getOperator())) {
                ISDataType secondVariableDataType;
                IRfNamedElement secondEnum = null;
                if (secondDataType instanceof SDataType) {
                    secondEnum = ((SDataType)secondDataType).isEnum() ? secondDataType.getType() : null;
                } else if (second instanceof SDataVariable && (secondVariableDataType = ((SDataVariable)second).type) instanceof SDataType) {
                    IRfNamedElement iRfNamedElement = secondEnum = ((SDataType)secondVariableDataType).isEnum() ? secondVariableDataType.getType() : null;
                }
                if (secondEnum != null && !secondEnum.equals(firstDataType.getType())) {
                    if (triggerError) {
                        String aliasFirstEnum = ((RfStruct)firstDataType.getType()).getAliasName();
                        if (aliasFirstEnum == null) {
                            String variableName = SDataUtils.getVariableName((ISDataAbstract)firstVariable, null);
                            aliasFirstEnum = DVTStringUtil.appendString((Object[])new Object[]{"of '", variableName, "'"});
                        } else {
                            aliasFirstEnum = DVTStringUtil.appendString((Object[])new Object[]{"'", aliasFirstEnum, "'"});
                        }
                        String aliasSecondEnum = ((RfStruct)secondEnum).getAliasName();
                        if (aliasSecondEnum == null) {
                            String variableName = SDataUtils.getVariableName((ISDataAbstract)SDataUtils.getVariable((ISDataAbstract)second), null);
                            aliasSecondEnum = DVTStringUtil.appendString((Object[])new Object[]{"of '", variableName, "'"});
                        } else {
                            aliasSecondEnum = DVTStringUtil.appendString((Object[])new Object[]{"'", aliasSecondEnum, "'"});
                        }
                        Assignment.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_DIFFERENT_ENUMS_ASSIGNMENT, null, aliasFirstEnum, aliasSecondEnum);
                    }
                    return SDataAbstracts.NON_STANDARD;
                }
                if (secondEnum == null && firstVariable != null) {
                    if (triggerError) {
                        if (context == null || context.contextOperation == null || context.contextOperation != RETURN_INSTANCE) {
                            if (this instanceof AssignmentPatternElement) {
                                switch (operatorInfo.getAssignmentPatternElementCheckKind()) {
                                    case KEY: {
                                        Assignment.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_ENUM_ASSIGNMENT_IN_ASSOCIATION, null, secondDataType, "key", firstDataType);
                                        break;
                                    }
                                    case VALUE: {
                                        Assignment.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_ENUM_ASSIGNMENT_IN_ASSOCIATION, null, secondDataType, "value", firstDataType);
                                        break;
                                    }
                                    default: {
                                        Assignment.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_ENUM_ASSIGNMENT, null, secondDataType, firstVariable.getVariableName(), firstDataType);
                                        break;
                                    }
                                }
                            } else {
                                Assignment.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_ENUM_ASSIGNMENT, null, secondDataType, firstVariable.getVariableName(), firstDataType);
                            }
                        } else {
                            Assignment.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_ENUM_RETURN, null, secondDataType, firstDataType);
                        }
                    }
                    return SDataAbstracts.NON_STANDARD;
                }
            }
            if (!configInfo.isElabWidthCheckDisabled() && (triggerError || forceCheckWidth || operatorInfo.isMatchingTypes()) && firstDataType.getNofUnpackedDimensions() == 0 && secondDataType.getNofUnpackedDimensions() == 0) {
                ISDataType isValid = this.internalCheckWidth(configInfo, operatorInfo, isRefAssociation, first, second, firstDataType, secondDataType, context);
                if (operatorInfo.isMatchingTypes()) {
                    return isValid;
                }
            }
            return null;
        }

        public static boolean isArgumentDefaultValueOperator(OperatorInfo operatorInfo, IRfNamedElement firstVariableElement) {
            if (firstVariableElement == null) {
                return false;
            }
            if (!operatorInfo.getOperator().hasQualifier(HidQualifierCache.IS_DECLARATION_ASSIGN_QUALIFIER)) {
                return false;
            }
            return firstVariableElement instanceof IRfFieldElement && firstVariableElement.getEnclosingScope() instanceof RfFunction && MethodCallUtils.isValidMethodArgument((IRfNamedElement)firstVariableElement);
        }

        private boolean internalIsInvalidListSelectForRef(HidAccess hidAccess) {
            if (!hidAccess.isSelect()) {
                return false;
            }
            Hid parentHid = hidAccess.getParentHid();
            if (!(parentHid.getElement() instanceof RfAssociatedType)) {
                return false;
            }
            int dimensionsSize = 0;
            IRfNamedElement selectableType = ((RfAssociatedType)parentHid.getElement()).getAssociatedType();
            while (true) {
                List<IndexType> unpackedDimension;
                DataType dataType;
                if (selectableType instanceof RfTypeAlias) {
                    selectableType = ((RfTypeAlias)selectableType).getAssociatedType();
                    continue;
                }
                if (!(selectableType instanceof RfListType) || (dataType = ((RfListType)selectableType).getDataType()) == null || (unpackedDimension = dataType.getUnpackedDimension()) == null) break;
                dimensionsSize += unpackedDimension.size();
                selectableType = ((RfListType)selectableType).getAssociatedType();
            }
            return dimensionsSize < hidAccess.getSelects().size();
        }

        private IRfNamedElement internalGetBlockingAssignIllegalVariable(Hid hid) {
            if (hid == null) {
                return null;
            }
            IRfNamedElement element = hid.getElement();
            IRfScopeElement enclosingScope = element.getEnclosingScope();
            if ((enclosingScope instanceof RfFunction || enclosingScope instanceof RfActionBlock) && !element.isStorageStatic()) {
                return element;
            }
            return null;
        }

        private void internalCheckWidthForNumberLiteral(ConfigInfo configInfo, OperatorInfo operatorInfo) {
            IHidObject opiRHValue;
            HidOperator operator = operatorInfo.getOperator();
            ListContainer rhValues = operator.getRHValues();
            IHidObject iHidObject = opiRHValue = rhValues.size() == 1 ? (IHidObject)rhValues.get(0) : null;
            if (opiRHValue == null) {
                return;
            }
            if (!(opiRHValue instanceof RfHidImplicit) || !((RfHidImplicit)opiRHValue).isNumber()) {
                return;
            }
            RfHidImplicit implicit = (RfHidImplicit)opiRHValue;
            String name = implicit.getName();
            IRfNamedElement scope = operatorInfo.getScope();
            if (scope == null) {
                return;
            }
            HidOperatorOccurrence occurrence = operatorInfo.getOperator().getOccurrence();
            if (occurrence == null) {
                return;
            }
            if (name.startsWith("0'")) {
                return;
            }
            int[] nofBits = new int[]{-1, -1, -1};
            Number number = ELUtils.parseNumberVLOG((String)name, null, (BitSet[])new BitSet[2], null, (int[])nofBits, (boolean)implicit.isRealtimeNumber());
            if (!(number instanceof BigInteger)) {
                return;
            }
            boolean isNofBitsSpecified = nofBits[1] > 0;
            boolean isBaseSpecified = nofBits[2] > 0;
            int specifiedSize = 0;
            int actualSize = 0;
            if (!isNofBitsSpecified && !isBaseSpecified) {
                specifiedSize = 32;
                actualSize = 1 + ((BigInteger)number).bitLength();
                if (actualSize == 33) {
                    int line = occurrence.getLine();
                    int endOffset = occurrence.getCloseBoundaryOutsideMacro();
                    int startOffset = endOffset - name.length();
                    RfProject rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vlogdt.VlogNature");
                    rfProject.addSemanticError(2, "INTEGER_SIGN_OVERFLOW: Integer literal ''{0}'' on ''32'' bits has sign oveflow", scope.getLibPkgScope(), startOffset, endOffset, null, line, operatorInfo.getParserPath(), name);
                    return;
                }
            } else if (isNofBitsSpecified) {
                specifiedSize = nofBits[0];
                actualSize = ((BigInteger)number).bitLength();
            } else if (isBaseSpecified) {
                return;
            }
            if (actualSize > specifiedSize) {
                int line = occurrence.getLine();
                int endOffset = occurrence.getCloseBoundaryOutsideMacro();
                int startOffset = endOffset - name.length();
                RfProject rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vlogdt.VlogNature");
                rfProject.addSemanticError(2, "WIDTH_MISMATCH_TRUNCATION: Integer literal ''{0}'' will be truncated to fit on ''{1}'' bits", scope.getLibPkgScope(), startOffset, endOffset, null, line, operatorInfo.getParserPath(), name, String.valueOf(specifiedSize));
            }
        }

        private IELParamValue getOpiSize(IHidObject opiValue, IHidEvaluator evaluator, IRfNamedElement operatorScope, IHidEvaluationGuardian guardian) {
            IHidObject dataTypePortExpression;
            IRfNamedElement hidElement;
            if (HidUtils.isHid((IHidObject)opiValue) && (hidElement = ((Hid)opiValue).getElement()) instanceof RfPort && (dataTypePortExpression = ((RfPort)hidElement).getDataTypePortExpression()) != null) {
                return XUtils.getValue((ELParamValueScope)ELUtils.evaluateForSize((IHidObject)dataTypePortExpression, (IHidEvaluator)evaluator, (IRfNamedElement)operatorScope, (IHidEvaluationGuardian)guardian));
            }
            return XUtils.getValue((ELParamValueScope)ELUtils.evaluateForSize((IHidObject)opiValue, (IHidEvaluator)evaluator, (IRfNamedElement)operatorScope, (IHidEvaluationGuardian)guardian));
        }

        private ISDataType internalCheckWidth(ConfigInfo configInfo, OperatorInfo operatorInfo, boolean isRefAssociation, ISDataAbstract first, ISDataAbstract second, ISDataType firstDataType, ISDataType secondDataType, SContext context) {
            int secondSize;
            IHidEvaluationGuardian lhGuardian;
            IELParamValue lhSizeValue;
            IRfNamedElement lhOperatorScope;
            IRfHidOperatorLayer lhOperator;
            IRfHidOperatorLayer rhOperator;
            IHidObject opiRHValue;
            ELWidthCheckContext elabContext;
            if (context != null && context.getOptionalUnpackedDimensions() > 0) {
                return null;
            }
            ELWidthCheckContext eLWidthCheckContext = elabContext = context != null ? context.getElabContext() : null;
            if (elabContext == null) {
                return null;
            }
            HidOperator operator = operatorInfo.getOperator();
            ListContainer rhValues = operator.getRHValues();
            IHidObject opiLHValue = operator.getLHValue();
            IHidObject iHidObject = opiRHValue = rhValues.size() == 1 ? (IHidObject)rhValues.get(0) : null;
            if (opiRHValue == null) {
                return null;
            }
            boolean elabWidthCheckFiltered = configInfo.isElabWidthCheckFiltered();
            if (elabWidthCheckFiltered && this.isCheckWidthMismatchFiltered(opiRHValue)) {
                return null;
            }
            if (elabWidthCheckFiltered && configInfo.isInXVMFieldAutomation()) {
                return null;
            }
            IRfHidOperatorLayer iRfHidOperatorLayer = rhOperator = opiRHValue instanceof IRfHidOperatorLayer ? (IRfHidOperatorLayer)opiRHValue : null;
            if (rhOperator != null && (rhOperator.isAssignmentPattern() || rhOperator.isNonStandardAssignmentPattern() || rhOperator.isConditionalTernary())) {
                return null;
            }
            if (rhOperator != null && rhOperator.isVLOGConcatenation(false) && SOperation.internalHasUnpackedArrayContext(context)) {
                return null;
            }
            IRfHidOperatorLayer iRfHidOperatorLayer2 = lhOperator = opiLHValue instanceof IRfHidOperatorLayer ? (IRfHidOperatorLayer)opiLHValue : null;
            if (lhOperator != null && (lhOperator.isAssignmentPattern() || lhOperator.isNonStandardAssignmentPattern() || lhOperator.isConditionalTernary())) {
                return null;
            }
            if (operator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN) && first instanceof SDataVariable) {
                RfField candidate;
                IRfNamedElement variable = ((SDataVariable)first).getVariable();
                RfField rfField = candidate = variable instanceof RfField ? (RfField)variable : null;
                if (candidate != null && (candidate.isTypeParameter() || candidate.isParameterNoDataType())) {
                    return null;
                }
                if (candidate instanceof RfPort && !candidate.isInput()) {
                    return null;
                }
            }
            if (SOperation.internalCheckStringOperand(firstDataType) || SOperation.internalCheckStringOperand(secondDataType)) {
                return null;
            }
            boolean hasOutputDirection = operatorInfo.hasOutputDirection();
            boolean isConnection = this instanceof PortConnection || this instanceof ParameterValue || this instanceof ArgumentValue;
            IRfNamedElement rhOperatorScope = lhOperatorScope = operatorInfo.getScope();
            if (isConnection) {
                if (lhOperatorScope instanceof IRfInstanceElement) {
                    rhOperatorScope = (IRfNamedElement)lhOperatorScope.getEnclosingScope();
                } else if (opiLHValue instanceof Hid && ((Hid)opiLHValue).getElement() != null) {
                    lhOperatorScope = (IRfNamedElement)((Hid)opiLHValue).getElement().getEnclosingScope();
                }
            }
            ElementPath lhPath = elabContext.getFirstPath(true);
            ElementPath rhPath = elabContext.getFirstPath(false);
            IHidEvaluator lhEvaluator = elabContext.getEvaluatorForPortConnections(isConnection);
            if (opiLHValue instanceof RfHid || opiLHValue instanceof RfHidAccess) {
                lhEvaluator = RfTypesResolver.create((IRfScopeElement)(lhOperatorScope instanceof RfInstance && elabContext.getBinding() != null ? elabContext.getBinding() : lhOperatorScope), lhEvaluator.getLastValueContainer(), lhPath, elabContext.getManager(), 0, true);
            }
            IHidEvaluator rhEvaluator = elabContext.getEvaluatorForPortConnections(false);
            if (opiRHValue instanceof RfHid || opiRHValue instanceof RfHidAccess) {
                rhEvaluator = RfTypesResolver.create((IRfScopeElement)rhOperatorScope, rhEvaluator.getLastValueContainer(), rhPath, elabContext.getManager(), 0, true);
            }
            if (ELUtils.isUnsuccessfulEval((IELParamValue)(lhSizeValue = this.getOpiSize(opiLHValue, lhEvaluator, lhOperatorScope, lhGuardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.TYPE_MATCHING, (IRfNamedElement)lhOperatorScope, (ElementPath)lhPath, (boolean)true, (ELManager)elabContext.getManager()))))) {
                return null;
            }
            DVTNumber lhSizeNumber = lhSizeValue.getDVTNumber();
            if (DVTNumber.isUndefined((DVTNumber)lhSizeNumber) || lhSizeNumber instanceof IDVTRangeSelectable && ((IDVTRangeSelectable)lhSizeNumber).isUnconstrainedFirstDimension()) {
                return null;
            }
            IHidEvaluationGuardian rhGuardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.TYPE_MATCHING, (IRfNamedElement)rhOperatorScope, (ElementPath)rhPath, (boolean)true, (ELManager)elabContext.getManager());
            IELParamValue rhSizeValue = this.getOpiSize(opiRHValue, rhEvaluator, rhOperatorScope, rhGuardian);
            if (ELUtils.isUnsuccessfulEval((IELParamValue)rhSizeValue)) {
                return null;
            }
            DVTNumber rhSizeNumber = rhSizeValue.getDVTNumber();
            if (DVTNumber.isUndefined((DVTNumber)rhSizeNumber) || rhSizeNumber instanceof IDVTRangeSelectable && ((IDVTRangeSelectable)rhSizeNumber).isUnconstrainedFirstDimension()) {
                return null;
            }
            IHidObject lhValue = hasOutputDirection ? opiRHValue : opiLHValue;
            IHidObject rhValue = hasOutputDirection ? opiLHValue : opiRHValue;
            int rhSize = rhSizeNumber.getSize();
            int lhSize = lhSizeNumber.getSize();
            int firstSize = hasOutputDirection ? rhSize : lhSize;
            int n = secondSize = hasOutputDirection ? lhSize : rhSize;
            if (DVTNumber.isUnknownSize((int)firstSize) || DVTNumber.isUnknownSize((int)secondSize)) {
                return null;
            }
            if (isRefAssociation || operatorInfo.isMatchingTypes()) {
                boolean hasMismatchedType;
                boolean bl = hasMismatchedType = !lhSizeNumber.getClass().equals(rhSizeNumber.getClass());
                if (!hasMismatchedType && lhSizeNumber instanceof VlogBitVector) {
                    boolean bl2 = hasMismatchedType = firstSize != secondSize;
                }
                if (hasMismatchedType) {
                    if (isRefAssociation) {
                        Assignment.addSemanticError(configInfo, true, operatorInfo, "ILLEGAL_ASSIGNMENT: Illegal assignment of ''{0}'' type to {1} ''{2}'' of ''{3}'' type", null, String.valueOf(secondSize) + "-bit", this.getOutputRefMessageType(SDataUtils.getVariableElement((ISDataAbstract)first)), SDataUtils.getVariableName((ISDataAbstract)first, (IHidObject)lhValue), String.valueOf(firstSize) + "-bit");
                    }
                    return SDataAbstracts.ILLEGAL;
                }
                return null;
            }
            DVTNumber lhFinalSizeNumber = hasOutputDirection ? rhSizeNumber : lhSizeNumber;
            DVTNumber rhFinalSizeNumber = hasOutputDirection ? lhSizeNumber : rhSizeNumber;
            boolean isRhUnsizedIntegerLiteral = !hasOutputDirection && opiRHValue instanceof IRfHidImplicitLayer && ((IRfHidImplicitLayer)opiRHValue).isUnsizedIntegerLiteral();
            boolean isLhRealNumber = lhFinalSizeNumber instanceof VlogAbstractRealNumber;
            boolean isRhRealNumber = rhFinalSizeNumber instanceof VlogAbstractRealNumber;
            if (elabWidthCheckFiltered && isRhUnsizedIntegerLiteral && !isLhRealNumber) {
                if (firstSize < secondSize) {
                    BigInteger numberValue;
                    IELParamValue evaluate = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)opiRHValue, (IHidEvaluator)rhEvaluator, (BitVectorContext)BitVectorContext.of((IRfNamedElement)rhOperatorScope, (boolean)false), (IHidEvaluationGuardian)rhGuardian));
                    if (!ELUtils.isUnsuccessfulEval((IELParamValue)evaluate) && firstSize >= ELUtils.getMinimumNofBits((BigInteger)(numberValue = evaluate.bigIntegerValue()))) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            if (elabWidthCheckFiltered && firstSize > secondSize && firstDataType != null && RfXvmFactory.isXVMBitStreamType(firstDataType)) {
                return null;
            }
            boolean addRoundingWarning = false;
            boolean isRhVlogBitVector = rhFinalSizeNumber instanceof VlogBitVector;
            if (isLhRealNumber && isRhVlogBitVector) {
                int rhMinNumOfBIts;
                int fpRoundingThreshold = this.getFloatingPointRoundingThreshold(this.getDataTypeName(firstDataType));
                if (secondSize > fpRoundingThreshold && (rhMinNumOfBIts = this.getOperandMinNumOfBits(opiRHValue, secondSize, rhEvaluator, rhOperatorScope, rhGuardian)) > fpRoundingThreshold) {
                    addRoundingWarning = true;
                }
            } else if (lhFinalSizeNumber instanceof VlogBitVector && isRhRealNumber) {
                boolean secondIsRealtimeLiteral;
                boolean bl = secondIsRealtimeLiteral = second instanceof SDataVariable && ((SDataVariable)second).getVariable() == STransformer.REALTIME_IMPLICIT && HidUtils.isHidImplicit((IHidObject)rhValue);
                if (elabWidthCheckFiltered && secondIsRealtimeLiteral) {
                    String literalName;
                    boolean firstIsTimeVariable;
                    boolean bl3 = firstIsTimeVariable = firstDataType instanceof SDataType && ((SDataType)firstDataType).isTime();
                    if (!operatorInfo.isMatchingTypes() && firstIsTimeVariable && (literalName = ((HidImplicit)rhValue).getName()).indexOf(46) == -1) {
                        return null;
                    }
                }
                addRoundingWarning = true;
            }
            if (isLhRealNumber && isRhRealNumber) {
                boolean isRhHidImplicit = rhValue instanceof RfHidImplicit;
                if (this.isRealConversionPrecisionError((VlogAbstractRealNumber)lhFinalSizeNumber, (VlogAbstractRealNumber)rhFinalSizeNumber, isRhHidImplicit)) {
                    addRoundingWarning = true;
                }
                if (!addRoundingWarning) {
                    return null;
                }
            }
            if (addRoundingWarning) {
                String firstVariableName = SDataUtils.getVariableName((ISDataAbstract)(lhValue instanceof HidImplicit ? null : first), (IHidObject)lhValue);
                String secondVariableName = SDataUtils.getVariableName((ISDataAbstract)(rhValue instanceof HidImplicit ? null : second), (IHidObject)rhValue);
                String firstDataTypeName = isLhRealNumber ? this.getDataTypeName(firstDataType) : String.valueOf(firstSize) + "-bit";
                String secondDataTypeName = isRhRealNumber ? this.getDataTypeName(secondDataType) : String.valueOf(secondSize) + "-bit";
                this.addCheckWidthWarning(configInfo, true, operatorInfo, this.getWidthRoundingMessage(operator), firstDataTypeName, secondDataTypeName, firstVariableName, secondVariableName, elabContext.getPathsTextForError());
                return SDataAbstracts.ILLEGAL;
            }
            if (isLhRealNumber && isRhVlogBitVector) {
                return null;
            }
            boolean addTruncationWarning = firstSize < secondSize;
            boolean addPaddingWarning = firstSize > secondSize;
            String warningMessage = null;
            if (addTruncationWarning) {
                warningMessage = this.getWidthTruncationMessage(operator);
            } else if (addPaddingWarning) {
                warningMessage = this.getWidthPaddingMessage(operator);
            }
            if (warningMessage != null) {
                String firstVariableName = SDataUtils.getVariableName((ISDataAbstract)first, (IHidObject)lhValue);
                String secondVariableName = SDataUtils.getVariableName((ISDataAbstract)second, (IHidObject)rhValue);
                this.addCheckWidthWarning(configInfo, true, operatorInfo, warningMessage, String.valueOf(firstSize) + "-bit", String.valueOf(secondSize) + "-bit", firstVariableName, secondVariableName, elabContext.getPathsTextForError());
                return SDataAbstracts.ILLEGAL;
            }
            return null;
        }

        private int getOperandMinNumOfBits(IHidObject opi, int size, IHidEvaluator evaluator, IRfNamedElement originScope, IHidEvaluationGuardian guardian) {
            IELParamValue evaluate;
            IHidObject.HidKind hidKind = opi.getHidKind();
            if (hidKind == IHidObject.HidKind.IMPLICIT && !ELUtils.isUnsuccessfulEval((IELParamValue)(evaluate = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)opi, (IHidEvaluator)evaluator, (BitVectorContext)BitVectorContext.of((IRfNamedElement)originScope, (boolean)false), (IHidEvaluationGuardian)guardian))))) {
                BigInteger number = evaluate.bigIntegerValue();
                return number.equals(BigInteger.ZERO) ? 1 : number.bitLength();
            }
            return size;
        }

        private String getDataTypeName(ISDataType dataType) {
            IRfNamedElement namedElement;
            IRfNamedElement iRfNamedElement = namedElement = dataType != null ? dataType.getType() : null;
            if (namedElement == null) {
                return "";
            }
            return namedElement.getName();
        }

        private int getFloatingPointRoundingThreshold(String dataTypeName) {
            if (dataTypeName == null) {
                return Integer.MAX_VALUE;
            }
            if (dataTypeName.startsWith("real")) {
                return 53;
            }
            if (dataTypeName.equals("shortreal")) {
                return 24;
            }
            return Integer.MAX_VALUE;
        }

        private boolean isRealConversionPrecisionError(VlogAbstractRealNumber lhNumber, VlogAbstractRealNumber rhNumber, boolean isRhHidImplicit) {
            if (isRhHidImplicit) {
                return lhNumber.getSize() < rhNumber.getSize() && (double)rhNumber.floatValue() != rhNumber.doubleValue();
            }
            return lhNumber.getSize() < rhNumber.getSize();
        }

        protected static boolean internalLiteralHasSizedSpecified(HidImplicit literal) {
            int index = literal.getName().indexOf(39);
            return index > 0;
        }

        private boolean isCheckWidthMismatchFiltered(IHidObject rhValue) {
            if (!(rhValue instanceof RfHidOperator)) {
                return false;
            }
            RfHidOperator operator = (RfHidOperator)rhValue;
            if (operator.isVLOGConcatenation(true)) {
                return false;
            }
            if (operator.isUnaryPlusOrMinus()) {
                return this.isCheckWidthMismatchFiltered(operator.getLHValue());
            }
            return true;
        }

        protected String getOutputRefMessageType(IRfNamedElement element) {
            if (element instanceof RfField && ((RfField)element).isArgument()) {
                RfField field = (RfField)element;
                if (field.isOutput()) {
                    return "output argument";
                }
                if (field.isInout()) {
                    return "inout argument";
                }
                if (field.isRef()) {
                    return "ref argument";
                }
                return "argument";
            }
            return "variable";
        }

        protected String getBaseMessageType(IRfNamedElement element) {
            if (element instanceof RfField && ((RfField)element).isArgument()) {
                return ((RfField)element).isRef() ? "ref argument" : "argument";
            }
            return "variable";
        }

        protected String getWidthTruncationMessage(HidOperator operator) {
            return operator.hasQualifier(HidQualifierCache.IS_WITH_IMPLICIT_SIGNAL_QUALIFIER) ? "WIDTH_MISMATCH_IMPLICIT_SIGNAL: Assignment to ''{2}'' of ''{0}'' type from ''{3}'' of ''{1}'' type" : "WIDTH_MISMATCH_TRUNCATION: Assignment to ''{2}'' of ''{0}'' type from ''{3}'' of ''{1}'' type";
        }

        protected String getWidthPaddingMessage(HidOperator operator) {
            return operator.hasQualifier(HidQualifierCache.IS_WITH_IMPLICIT_SIGNAL_QUALIFIER) ? "WIDTH_MISMATCH_IMPLICIT_SIGNAL: Assignment to ''{2}'' of ''{0}'' type from ''{3}'' of ''{1}'' type" : "WIDTH_MISMATCH_PADDING: Assignment to ''{2}'' of ''{0}'' type from ''{3}'' of ''{1}'' type";
        }

        protected String getWidthRoundingMessage(HidOperator operator) {
            return operator.hasQualifier(HidQualifierCache.IS_WITH_IMPLICIT_SIGNAL_QUALIFIER) ? "WIDTH_MISMATCH_IMPLICIT_SIGNAL: Assignment to ''{2}'' of ''{0}'' type from ''{3}'' of ''{1}'' type" : "WIDTH_MISMATCH_ROUNDING: Assignment to ''{2}'' of ''{0}'' type from ''{3}'' of ''{1}'' type";
        }

        @Override
        protected String getUndefinedOperatorErrorMessage(Equality.UndefinedOperatorMessageInfoKind kind) {
            switch (kind) {
                case PACKED_UNPACKED: {
                    return "ILLEGAL_ASSIGNMENT: Illegal assignment to type ''{0}'' from type ''{1}'' (cannot assign a{2,choice,0# packed|1#n unpacked} type to a{2,choice,0#n unpacked|1# packed} type)";
                }
                case ARRAYS: {
                    return "ILLEGAL_ASSIGNMENT: Illegal assignment to type ''{0}'' from type ''{1}'' (arrays have incompatible {2,choice,0#dimensions|1#packed dimensions|2#unpacked dimensions|3#element types|4#element type signing|5#2-state/4-state element types})";
                }
                case CLASSES: {
                    return "ILLEGAL_ASSIGNMENT: Illegal assignment to type ''{0}'' from type ''{1}'' (class types are not assignment compatible)";
                }
            }
            return "ILLEGAL_ASSIGNMENT: Illegal assignment to type ''{0}'' from type ''{1}''";
        }

        protected void addCheckWidthWarning(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, String message, String firstNumberOfBits, String secondNumberOfBits, String firstVariableName, String secondVariableName, String elabPath) {
            Assignment.addSemanticWarning(configInfo, triggerError, operatorInfo, message, this.getAttributesForElabPaths(elabPath), firstNumberOfBits, secondNumberOfBits, firstVariableName, secondVariableName);
        }

        @Override
        protected void addSemanticError(ConfigInfo configInfo, boolean triggerError, Equality.UndefinedOperatorMessageInfoKind infoKind, OperatorInfo operatorInfo, ISDataAbstract firstAbstract, ISDataType first, ISDataAbstract secondAbstract, ISDataType second, boolean reverseOrder, String elabPath, int firstDetailsChoice, int secondDetailsChoice) {
            ISDataType firstDataType = reverseOrder ? second : first;
            ISDataType secondDataType = reverseOrder ? first : second;
            String message = this.getUndefinedOperatorErrorMessage(infoKind);
            int detailsChoice = reverseOrder ? firstDetailsChoice : secondDetailsChoice;
            Assignment.addSemanticError(configInfo, triggerError, operatorInfo, message, this.getAttributesForElabPaths(elabPath), firstDataType.getName(configInfo.isSemanticShowAliasName()), secondDataType.getName(configInfo.isSemanticShowAliasName()), detailsChoice);
        }

        @Override
        protected void addSemanticError(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, ISDataAbstract firstAbstract, ISDataType first, ISDataAbstract secondAbstract, ISDataType second, boolean reverseOrder, String elabPath) {
            ISDataType firstDataType = reverseOrder ? second : first;
            ISDataType secondDataType = reverseOrder ? first : second;
            String message = this.getUndefinedOperatorErrorMessage(Equality.UndefinedOperatorMessageInfoKind.NO_EXTRA_INFO);
            Assignment.addSemanticError(configInfo, triggerError, operatorInfo, message, this.getAttributesForElabPaths(elabPath), firstDataType.getName(configInfo.isSemanticShowAliasName()), secondDataType.getName(configInfo.isSemanticShowAliasName()));
        }

        @Override
        protected void addSemanticWarning(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, ISDataAbstract firstAbstract, ISDataType first, ISDataAbstract secondAbstract, ISDataType second, boolean reverseOrder, String elabPath) {
            ISDataType firstDataType = reverseOrder ? second : first;
            ISDataType secondDataType = reverseOrder ? first : second;
            String message = this.getUndefinedOperatorErrorMessage(Equality.UndefinedOperatorMessageInfoKind.NO_EXTRA_INFO);
            Assignment.addSemanticWarning(configInfo, triggerError, operatorInfo, message, this.getAttributesForElabPaths(elabPath), firstDataType.getName(configInfo.isSemanticShowAliasName()), secondDataType.getName(configInfo.isSemanticShowAliasName()));
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid == null) {
                return operands.get(0);
            }
            if (!operatorInfo.ignoreAssignmentLHSide() && operands.size() == 2 && SOperation.acceptOperandsNature(configInfo, true, operatorInfo, Collections.singletonList(operands.get(0))) == null) {
                return operands.get(0);
            }
            return isValid;
        }
    }

    private static class AssignmentPattern
    extends SOperation {
        public static final EnumSet<SDataTypeCategory> permittedContexts = EnumSet.of(SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED, new SDataTypeCategory[]{SDataTypeCategory.FIXED_SIZE_ARRAY_UNPACKED, SDataTypeCategory.DYNAMIC_ARRAY, SDataTypeCategory.ASSOCIATIVE_ARRAY, SDataTypeCategory.QUEUE, SDataTypeCategory.UNION_PACKED, SDataTypeCategory.UNION_UNPACKED, SDataTypeCategory.STRUCT_UNPACKED, SDataTypeCategory.STRUCT_PACKED});

        private AssignmentPattern() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid;
            HidOperator operator;
            ListContainer rhValues;
            ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)context.getContextDataType());
            if (!(dataType == null || (rhValues = (operator = operatorInfo.getOperator()).getRHValues()) == null || rhValues.isEmpty() || operator instanceof IRfHidOperatorLayer && ((IRfHidOperatorLayer)operator).isReplication())) {
                IRfNamedElement type = dataType.getType();
                if (type instanceof RfStruct && !((RfStruct)type).isEnum()) {
                    RfStruct associatedStruct = (RfStruct)type;
                    List<RfField> structFields = associatedStruct.getFields();
                    IHidObject firstAssociation = (IHidObject)rhValues.get(0);
                    if (AssociationUtils.isOrdered((IHidObject)firstAssociation, (long)HidQualifierCache.IS_ASSOCIATION_QUALIFIER)) {
                        if (rhValues.size() != structFields.size()) {
                            AssignmentPattern.addSemanticError(configInfo, triggerError, operatorInfo, "ASSIGNMENT_PATTERN_VALUES: Expecting ''{1}'' value{1,choice,0#s|1#|1<s}, found ''{0}''", null, rhValues.size(), structFields.size());
                        }
                    } else {
                        LinkedHashMap<RfField, FieldState> structFieldsMap = new LinkedHashMap<RfField, FieldState>();
                        int unassignedFields = 0;
                        int multipleAssignedFields = 0;
                        for (RfField field : structFields) {
                            FieldState returnedValue = structFieldsMap.putIfAbsent(field, FieldState.UNASSIGNED);
                            if (returnedValue != null) continue;
                            ++unassignedFields;
                        }
                        boolean stopErrors = false;
                        RfHidOperator defaultAssignmentPattern = null;
                        for (IHidObject assignmentOperand : rhValues) {
                            if (!(assignmentOperand instanceof RfHidOperator)) continue;
                            RfHidOperator hidOperator = (RfHidOperator)assignmentOperand;
                            IHidObject lhValue = hidOperator.getLHValue();
                            if (HidUtils.isHid((IHidObject)lhValue)) {
                                IRfNamedElement element = ((RfHid)lhValue).getElement();
                                if (element instanceof RfField && !((RfField)element).isTypeParameter()) {
                                    FieldState previousValue = (FieldState)((Object)structFieldsMap.get(element));
                                    if (previousValue == FieldState.UNASSIGNED) {
                                        structFieldsMap.put((RfField)element, FieldState.ASSIGNED);
                                        --unassignedFields;
                                        continue;
                                    }
                                    if (previousValue != FieldState.ASSIGNED) continue;
                                    structFieldsMap.put((RfField)element, FieldState.MULTIPLE);
                                    ++multipleAssignedFields;
                                    continue;
                                }
                                stopErrors = true;
                                break;
                            }
                            if (lhValue instanceof RfHidImplicit && ((RfHidImplicit)lhValue).isLiteralDefault()) {
                                defaultAssignmentPattern = hidOperator;
                                continue;
                            }
                            stopErrors = true;
                            break;
                        }
                        if (defaultAssignmentPattern != null && !stopErrors) {
                            IHidObject defaultValue = defaultAssignmentPattern.getFirstRHValue();
                            ISDataAbstract assignedDataType = SEvaluator.INSTANCE.calculateDataType(configInfo, defaultValue, associatedStruct, operatorInfo, null);
                            OperatorInfo defaultAssignOperatorInfo = new OperatorInfo((HidOperator)defaultAssignmentPattern, operatorInfo.getParserPath(), operatorInfo.getScope(), operatorInfo.ignoreAssignmentLHSide(), operatorInfo.hasOutputDirection(), operatorInfo.isStrictClassMatching(), operatorInfo.isMatchingTypes());
                            for (Map.Entry entry : structFieldsMap.entrySet()) {
                                if (entry.getValue() != FieldState.UNASSIGNED) continue;
                                RfField field = (RfField)entry.getKey();
                                AssignmentPattern.checkStructMemberAssignment(field, assignedDataType, configInfo, triggerError, defaultAssignOperatorInfo, context);
                            }
                            unassignedFields = 0;
                            structFieldsMap.clear();
                        }
                        if (!(stopErrors || unassignedFields == 0 && multipleAssignedFields == 0)) {
                            StringJoiner unassignedErrorJoiner = new StringJoiner(", ");
                            StringJoiner multipleAssignedErrorJoiner = new StringJoiner(", ");
                            for (Map.Entry entry : structFieldsMap.entrySet()) {
                                if (entry.getValue() == FieldState.UNASSIGNED) {
                                    unassignedErrorJoiner.add("'" + ((RfField)entry.getKey()).getName() + "'");
                                    continue;
                                }
                                if (entry.getValue() != FieldState.MULTIPLE) continue;
                                multipleAssignedErrorJoiner.add("'" + ((RfField)entry.getKey()).getName() + "'");
                            }
                            if (unassignedFields != 0) {
                                AssignmentPattern.addSemanticError(configInfo, triggerError, operatorInfo, "INCOMPLETE_ASSIGNMENT_PATTERN: Assignment pattern for struct ''{1}'' is missing association{0,choice,0#s|1#|1<s} to member{0,choice,0#s|1#|1<s} {2}", null, unassignedFields, dataType.getName(configInfo.isSemanticShowAliasName()), unassignedErrorJoiner.toString());
                            }
                            if (multipleAssignedFields != 0) {
                                AssignmentPattern.addSemanticError(configInfo, triggerError, operatorInfo, "ASSIGNMENT_PATTERN_MULTIPLE_ASSOCIATIONS: Assignment pattern for struct ''{1}'' has multiple associations for member{0,choice,0#s|1#|1<s} {2}", null, multipleAssignedFields, dataType.getName(configInfo.isSemanticShowAliasName()), multipleAssignedErrorJoiner.toString());
                            }
                        }
                    }
                } else if (type instanceof RfListType) {
                    boolean stopErrors = false;
                    RfHidOperator defaultAssignmentPattern = null;
                    for (IHidObject assignmentOperand : rhValues) {
                        if (!(assignmentOperand instanceof RfHidOperator)) continue;
                        RfHidOperator hidOperator = (RfHidOperator)assignmentOperand;
                        IHidObject lhValue = hidOperator.getLHValue();
                        if (lhValue instanceof RfHidImplicit) {
                            if (((RfHidImplicit)lhValue).isLiteralDefault()) {
                                defaultAssignmentPattern = hidOperator;
                                continue;
                            }
                            stopErrors = true;
                            continue;
                        }
                        if (!(lhValue instanceof RfHid) || !(((RfHid)lhValue).getElement() instanceof RfTypeAlias)) continue;
                        stopErrors = true;
                    }
                    if (defaultAssignmentPattern != null && !stopErrors) {
                        IHidObject rhValue = defaultAssignmentPattern.getFirstRHValue();
                        if (rhValue instanceof IHidOperator && ((IHidOperator)rhValue).isConcatOrAssignPatternOperator()) {
                            return null;
                        }
                        Hid assignedListHid = context.getAssignPatternLHSideHid();
                        if (assignedListHid == null) {
                            return null;
                        }
                        IRfNamedElement element = assignedListHid.getElement();
                        if (element == null) {
                            return null;
                        }
                        ISDataAbstract defaultAssignedDataType = SEvaluator.INSTANCE.calculateDataType(configInfo, rhValue, type, operatorInfo, null);
                        OperatorInfo defaultAssignOperatorInfo = new OperatorInfo((HidOperator)defaultAssignmentPattern, operatorInfo.getParserPath(), operatorInfo.getScope(), operatorInfo.ignoreAssignmentLHSide(), operatorInfo.hasOutputDirection(), operatorInfo.isStrictClassMatching(), operatorInfo.isMatchingTypes());
                        AssignmentPattern.checkListAssignment(element, (ISDataAbstract)SDataVariable.of((ISDataType)dataType, (boolean)false), defaultAssignedDataType, true, configInfo, triggerError, defaultAssignOperatorInfo, context);
                    }
                }
            }
            if ((isValid = this.checkValidOperands(configInfo, true, operatorInfo, operands, context)) != null) {
                return isValid;
            }
            return null;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (context == null || context.getContextDataType() == null) {
                return null;
            }
            ISDataAbstract contextDataType = context.getContextDataType();
            if (context.isUndefined()) {
                return contextDataType;
            }
            SDataTypeCategory contextCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)contextDataType);
            SOperation previousOperation = context.getPreviousOperation();
            if (!(previousOperation instanceof Assignment) && !(previousOperation instanceof Cast)) {
                OperatorInfo contextOperatorInfo = context.contextOperatorInfo;
                if (!permittedContexts.contains(contextCategory) && SDataTypeCategory.STRING != contextCategory && contextOperatorInfo != null) {
                    AssignmentPattern.addSemanticError(configInfo, triggerError, contextOperatorInfo, "UNDEFINED_OPERATOR: Operator ''{0}'' is undefined for argument types ''{1}'', ''{2}''", null, contextOperatorInfo.getOperator().getOperatorText(), SDataUtils.getDataType((ISDataAbstract)contextDataType).getName(configInfo.isSemanticShowAliasName()), "assignment pattern");
                    return SDataAbstracts.ILLEGAL;
                }
                if (triggerError) {
                    AssignmentPattern.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_ASSIGNMENT_PATTERN_CONTEXT, null, SDataUtils.getDataType((ISDataAbstract)contextDataType).getName(configInfo.isSemanticShowAliasName()));
                }
                return SDataAbstracts.NON_STANDARD;
            }
            if (!permittedContexts.contains(contextCategory)) {
                IRfNamedElement bitVector;
                if (SDataTypeCategory.STRING == contextCategory) {
                    if (triggerError) {
                        AssignmentPattern.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_ASSIGNMENT_PATTERN_STRING_CONTEXT, null, new Object[0]);
                    }
                    return SDataAbstracts.NON_STANDARD;
                }
                if (SDataTypeCategory.NUMERIC != contextCategory) {
                    AssignmentPattern.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_ASSIGNMENT: Illegal use of assignment pattern to type ''{0}''", null, SDataUtils.getDataType((ISDataAbstract)contextDataType).getName(configInfo.isSemanticShowAliasName()));
                    return SDataAbstracts.ILLEGAL;
                }
                ISDataType bitVectorDataType = SDataUtils.getDataType((ISDataAbstract)contextDataType);
                IRfNamedElement iRfNamedElement = bitVector = bitVectorDataType instanceof SDataType ? ((SDataType)bitVectorDataType).getType() : null;
                if (bitVector != null && (bitVector instanceof RfBitVectorScalarType || bitVector instanceof RfComputedListType) && ((IRfTypeElement)bitVector).getBitSize() == 1) {
                    if (triggerError) {
                        AssignmentPattern.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_SCALAR_ASSIGNMENT_PATTERN, null, SDataUtils.getDataType((ISDataAbstract)contextDataType).getName(configInfo.isSemanticShowAliasName()));
                    }
                    return SDataAbstracts.NON_STANDARD;
                }
            }
            return SDataVariable.of((ISDataType)SDataUtils.getDataType((ISDataAbstract)contextDataType), (boolean)false);
        }

        private static OperatorInfo createAssignPatElemOperatorInfo(IRfNamedElement lhs, OperatorInfo assignPatElemOperatorInfo) {
            HidOperator operator = assignPatElemOperatorInfo.getOperator();
            HidOperatorOccurrence occurrence = operator.getOccurrence();
            RfHid lhSideHid = STransformer.makeStandInHid(lhs.getName(), lhs, new HidOccurrence(occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), 0L, null), 0L);
            RfHidOperator dummyOperator = STransformer.makeStandInOperator((IHidObject)lhSideHid, OptimizedUtils.asList((ListContainer)operator.getRHValues(), (boolean)false), operator.getOperatorType(), operator.getOperatorKind(), operator.getOperatorText(), operator.getOccurrence(), operator.getQualifiers());
            return new OperatorInfo((HidOperator)dummyOperator, assignPatElemOperatorInfo.getParserPath(), assignPatElemOperatorInfo.getScope(), assignPatElemOperatorInfo.ignoreAssignmentLHSide(), assignPatElemOperatorInfo.hasOutputDirection(), assignPatElemOperatorInfo.isStrictClassMatching(), assignPatElemOperatorInfo.isMatchingTypes());
        }

        private static void checkAssignment(IRfNamedElement type, ISDataAbstract assignedDataType, ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            boolean prevElabWidthCheckDisabled = configInfo.isElabWidthCheckDisabled();
            configInfo.setElabWidthCheckDisabled(true);
            try {
                if (type instanceof RfStruct && !((RfStruct)type).isEnum()) {
                    ISDataType isValid = ASSIGNMENT_INSTANCE.checkOperands(configInfo, false, operatorInfo, operands, context);
                    if (isValid == null) {
                        return;
                    }
                    for (RfField field : ((RfStruct)type).getFields()) {
                        AssignmentPattern.checkStructMemberAssignment(field, assignedDataType, configInfo, triggerError, operatorInfo, context);
                    }
                    return;
                }
                if (triggerError) {
                    ASSIGNMENT_INSTANCE.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
                }
            }
            finally {
                configInfo.setElabWidthCheckDisabled(prevElabWidthCheckDisabled);
            }
        }

        private static void checkStructMemberAssignment(RfField member, ISDataAbstract assignedDataType, ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, SContext context) {
            IRfNamedElement type = member.getAssociatedType();
            if (type instanceof RfTypeAlias) {
                type = ((RfTypeAlias)type).getTranslatedType();
            }
            ISDataAbstract fieldDataType = SDataAbstracts.get((IRfNamedElement)member, (IRfNamedElement)operatorInfo.getScope(), (ELWidthCheckContext)configInfo.getElabContext(), null, (LanguageKind)LanguageKind.VLOG, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
            if (type instanceof RfListType) {
                AssignmentPattern.checkListAssignment(member, fieldDataType, assignedDataType, false, configInfo, triggerError, operatorInfo, context);
                return;
            }
            operatorInfo = AssignmentPattern.createAssignPatElemOperatorInfo(member, operatorInfo);
            ArrayList<ISDataAbstract> operands = new ArrayList<ISDataAbstract>(2);
            operands.add(fieldDataType);
            operands.add(assignedDataType);
            AssignmentPattern.checkAssignment(type, assignedDataType, configInfo, triggerError, operatorInfo, operands, context);
        }

        private static void checkListAssignment(IRfNamedElement listElement, ISDataAbstract lhDataTypeVariable, ISDataAbstract rhDataTypeVariable, boolean listMemberAssociation, ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, SContext context) {
            ISDataAbstract lhSubArrayDataVariable;
            ISDataType lhDataType = SDataUtils.getDataType((ISDataAbstract)lhDataTypeVariable);
            if (lhDataType == null) {
                return;
            }
            ISDataType rhDataType = SDataUtils.getDataType((ISDataAbstract)rhDataTypeVariable);
            if (rhDataType == null) {
                return;
            }
            int extraDimensions = lhDataType.getNofUnpackedDimensions() - rhDataType.getNofUnpackedDimensions();
            if (listMemberAssociation && extraDimensions < 1) {
                extraDimensions = 1;
            }
            IRfNamedElement lhTypeElement = lhDataType.getType();
            while (extraDimensions-- > 0 && lhTypeElement != null) {
                if (lhTypeElement instanceof RfTypeAlias) {
                    lhTypeElement = ((RfTypeAlias)lhTypeElement).getTranslatedType();
                }
                if (!(lhTypeElement instanceof IRfListType)) break;
                lhTypeElement = ((IRfListType)lhTypeElement).getResolvedType(true);
            }
            if (lhTypeElement == null) {
                return;
            }
            if (lhTypeElement instanceof RfTypeAlias) {
                lhTypeElement = ((RfTypeAlias)lhTypeElement).getTranslatedType();
            }
            if (!((lhSubArrayDataVariable = SDataAbstracts.get((IRfNamedElement)lhTypeElement, (IRfNamedElement)operatorInfo.getScope(), (ELWidthCheckContext)configInfo.getElabContext(), null, (LanguageKind)LanguageKind.VLOG, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false)) instanceof SDataVariable)) {
                return;
            }
            SDataVariable newLHOperandVariable = SDataVariable.of((ISDataType)((SDataVariable)lhSubArrayDataVariable).type, (IRfNamedElement)listElement, (boolean)false);
            operatorInfo = AssignmentPattern.createAssignPatElemOperatorInfo(lhTypeElement, operatorInfo);
            ArrayList<ISDataAbstract> operands = new ArrayList<ISDataAbstract>(2);
            operands.add((ISDataAbstract)newLHOperandVariable);
            operands.add(rhDataTypeVariable);
            AssignmentPattern.checkAssignment(lhTypeElement, rhDataTypeVariable, configInfo, triggerError, operatorInfo, operands, context);
        }

        private static enum FieldState {
            UNASSIGNED,
            ASSIGNED,
            MULTIPLE;

        }
    }

    private static class AssignmentPatternElement
    extends Assignment {
        private AssignmentPatternElement() {
        }

        protected String getUndefinedOperatorErrorMessage(Equality.UndefinedOperatorMessageInfoKind kind, OperatorInfo.AssignmentPatternElementCheckKind checkKind) {
            switch (checkKind) {
                case KEY: {
                    switch (kind) {
                        case PACKED_UNPACKED: {
                            return "ILLEGAL_ASSIGNMENT: Illegal assignment to type ''{0}'' from key ''{1}'' of type ''{2}'' (cannot assign a{3,choice,0# packed|1#n unpacked} type to a{3,choice,0#n unpacked|1# packed} type)";
                        }
                        case ARRAYS: {
                            return "ILLEGAL_ASSIGNMENT: Illegal assignment to type ''{0}'' from key ''{1}'' of type ''{2}'' (arrays have incompatible {2,choice,0#dimensions|1#packed dimensions|2#unpacked dimensions|3#element types|4#element type signing|5#2-state/4-state element types})";
                        }
                        case CLASSES: {
                            return "ILLEGAL_ASSIGNMENT: Illegal assignment to type ''{0}'' from key ''{1}'' of type ''{2}'' (class types are not assignment compatible)";
                        }
                    }
                    return "ILLEGAL_ASSIGNMENT: Illegal assignment to type ''{0}'' from key ''{1}'' of type ''{2}''";
                }
                case VALUE: {
                    switch (kind) {
                        case PACKED_UNPACKED: {
                            return "ILLEGAL_ASSIGNMENT: Illegal assignment to type ''{0}'' from value ''{1}'' of type ''{2}'' (cannot assign a{3,choice,0# packed|1#n unpacked} type to a{3,choice,0#n unpacked|1# packed} type)";
                        }
                        case ARRAYS: {
                            return "ILLEGAL_ASSIGNMENT: Illegal assignment to type ''{0}'' from value ''{1}'' of type ''{2}'' (arrays have incompatible {3,choice,0#dimensions|1#packed dimensions|2#unpacked dimensions|3#element types|4#element type signing|5#2-state/4-state element types})";
                        }
                        case CLASSES: {
                            return "ILLEGAL_ASSIGNMENT: Illegal assignment to type ''{0}'' from value ''{1}'' of type ''{2}'' (class types are not assignment compatible)";
                        }
                    }
                    return "ILLEGAL_ASSIGNMENT: Illegal assignment to type ''{0}'' from value ''{1}'' of type ''{2}''";
                }
            }
            switch (kind) {
                case PACKED_UNPACKED: {
                    return "ILLEGAL_ASSIGNMENT: Illegal assignment to type ''{0}'' from type ''{1}'' (cannot assign a{2,choice,0# packed|1#n unpacked} type to a{2,choice,0#n unpacked|1# packed} type)";
                }
                case ARRAYS: {
                    return "ILLEGAL_ASSIGNMENT: Illegal assignment to type ''{0}'' from type ''{1}'' (arrays have incompatible {2,choice,0#dimensions|1#packed dimensions|2#unpacked dimensions|3#element types|4#element type signing|5#2-state/4-state element types})";
                }
                case CLASSES: {
                    return "ILLEGAL_ASSIGNMENT: Illegal assignment to type ''{0}'' from type ''{1}'' (class types are not assignment compatible)";
                }
            }
            return "ILLEGAL_ASSIGNMENT: Illegal assignment to type ''{0}'' from type ''{1}''";
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            RfStruct enclosingStruct;
            SDataVariable formalPart;
            IRfNamedElement keyElement;
            IRfNamedElement hidElement;
            boolean isLiteralDefaultKey;
            HidOperator operator = operatorInfo.getOperator();
            IHidObject operatorLHValue = operator.getLHValue();
            IRfNamedElement assocArrayType = context.getAssocArrayType();
            boolean bl = isLiteralDefaultKey = operatorLHValue instanceof RfHidImplicit && ((RfHidImplicit)operatorLHValue).isLiteralDefault();
            if (assocArrayType instanceof RfListType && context.getPreviousOperation() != UNPACKED_CONCATENATION_INSTANCE && !(operands.get(0) instanceof SDataType) && !isLiteralDefaultKey) {
                ArrayList<ISDataAbstract> checkOperands;
                ISDataAbstract dataAbstract;
                IRfNamedElement variable;
                IRfNamedElement indexType = ((RfListType)assocArrayType).getIndexType();
                IRfNamedElement associatedBaseType = ((IRfListType)assocArrayType).getResolvedType(true);
                boolean prevElabWidthCheckDisabled = configInfo.isElabWidthCheckDisabled();
                configInfo.setElabWidthCheckDisabled(true);
                IRfNamedElement iRfNamedElement = variable = operatorLHValue instanceof RfHid ? ((RfHid)operatorLHValue).getElement() : null;
                if (!(variable instanceof RfErrorImplicitField || variable instanceof RfPredefinedField && ((RfPredefinedField)variable).isImplicitKeyInAssociation())) {
                    dataAbstract = SDataAbstracts.get((IRfNamedElement)indexType, (IRfNamedElement)operatorInfo.getScope(), (ELWidthCheckContext)configInfo.getElabContext(), null, (LanguageKind)LanguageKind.VLOG, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
                    checkOperands = new ArrayList();
                    checkOperands.add(dataAbstract);
                    checkOperands.add(operands.get(0));
                    operatorInfo.setAssignmentPatternElementCheckKind(OperatorInfo.AssignmentPatternElementCheckKind.KEY);
                    super.checkOperands(configInfo, triggerError, operatorInfo, checkOperands, context);
                    OperatorInfo finalOperatorInfo = operatorInfo;
                    Predicate<IHidObject> hidsCollector = element -> {
                        IHid hid = HidUtils.getHidFrom((IHidObject)element);
                        if (hid instanceof RfHid) {
                            boolean isCovergroupExpression = ((RfHid)hid).hasQualifier(HidQualifierCache.IS_IN_COVERGROUP_EXPRESSION);
                            boolean isConstantHid = ((RfHid)hid).isConstantExpression(isCovergroupExpression);
                            boolean isResolved = hid.getElement() != null;
                            if (isResolved & !isConstantHid) {
                                int offsetStart = hid.getOffset();
                                int offsetEnd = offsetStart + hid.getName().length();
                                AssignmentPatternElement.addSemanticErrorWithOffsets(configInfo, triggerError, finalOperatorInfo, "ILLEGAL_NONCONSTANT_EXPRESSION: Expecting constant expression, but found ''{0}''", null, offsetStart, offsetEnd, HidUtils.toNiceString((IHidObject)hid));
                            }
                        }
                        return true;
                    };
                    HidUtils.flattenToObjects(hidsCollector, (IHidObject)operatorLHValue, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
                }
                dataAbstract = SDataAbstracts.get((IRfNamedElement)associatedBaseType, (IRfNamedElement)operatorInfo.getScope(), (ELWidthCheckContext)configInfo.getElabContext(), null, (LanguageKind)LanguageKind.VLOG, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
                checkOperands = new ArrayList<ISDataAbstract>();
                checkOperands.add(dataAbstract);
                checkOperands.add(operands.get(1));
                operatorInfo.setAssignmentPatternElementCheckKind(OperatorInfo.AssignmentPatternElementCheckKind.VALUE);
                super.checkOperands(configInfo, triggerError, operatorInfo, checkOperands, context);
                configInfo.setElabWidthCheckDisabled(prevElabWidthCheckDisabled);
            }
            operatorInfo.setAssignmentPatternElementCheckKind(OperatorInfo.AssignmentPatternElementCheckKind.DEFAULT);
            IRfNamedElement iRfNamedElement = hidElement = operatorLHValue instanceof Hid ? ((Hid)operatorLHValue).getElement() : null;
            if (context != null && !AssociationUtils.isOrdered((IHidObject)operatorInfo.getOperator(), (long)HidQualifierCache.IS_ASSOCIATION_QUALIFIER) && operatorLHValue instanceof Hid && !((Hid)operatorLHValue).hasQualifier(HidQualifierCache.NUMBER) && hidElement == null) {
                AssignmentPatternElement.addAssignmentPatternLHSideSemanticError(configInfo, operatorInfo, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared");
                return SDataAbstracts.UNDEFINED;
            }
            if (context != null && AssociationUtils.isOrdered((IHidObject)operatorInfo.getOperator(), (long)HidQualifierCache.IS_ASSOCIATION_QUALIFIER) && hidElement instanceof RfErrorImplicitField) {
                if (context.getPreviousOperation() == ASSIGNMENT_PATTERN_INSTANCE) {
                    AssignmentPatternElement.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_ASSIGNMENT: Illegal use of ordered assignment pattern to associative array", null, new Object[0]);
                    return SDataAbstracts.ILLEGAL;
                }
                if (context.getPreviousOperation() == UNPACKED_CONCATENATION_INSTANCE) {
                    AssignmentPatternElement.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_ASSIGNMENT: Illegal use of concatenation to associative array", null, new Object[0]);
                    return SDataAbstracts.ILLEGAL;
                }
            }
            if (context != null && context.getPreviousOperation() == UNPACKED_CONCATENATION_INSTANCE && operands.size() == 2) {
                ISDataType result = this.internalCheckOperands(configInfo, false, true, operatorInfo, operands, context);
                if (result != null) {
                    if (!(operands.get(0) instanceof SDataVariable) || !(operands.get(1) instanceof SDataVariable)) {
                        return SDataAbstracts.UNDEFINED;
                    }
                    SDataVariable first = (SDataVariable)operands.get(0);
                    SDataVariable second = (SDataVariable)operands.get(1);
                    ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)first);
                    ISDataType secondDataType = SDataUtils.getDataType((ISDataAbstract)second);
                    if (firstDataType.getNofUnpackedDimensions() == secondDataType.getNofUnpackedDimensions() - 1) {
                        ArrayList<ISDataAbstract> newOperands = new ArrayList<ISDataAbstract>();
                        SDataVariable firstVariable = firstDataType.hasDimensions() ? SDataVariable.of((ISDataType)firstDataType.getCachedListBaseElementType(), (boolean)false) : first;
                        newOperands.add((ISDataAbstract)firstVariable);
                        SDataVariable secondVariable = SDataVariable.of((ISDataType)secondDataType.getCachedListBaseElementType(), (boolean)false);
                        newOperands.add((ISDataAbstract)secondVariable);
                        if (context != null && context.hasElabContext()) {
                            HidOperatorOccurrence occurrence = operator.getOccurrence();
                            RfHid lhSide = STransformer.makeStandInHid("unresolved", null, new HidOccurrence(occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), 0L, null), 0L);
                            RfHidOperator dummyOperator = STransformer.makeStandInOperator((IHidObject)lhSide, OptimizedUtils.asList((ListContainer)operator.getRHValues(), (boolean)false), IHidOperatorConstants.OperatorType.NO_TYPE.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, operator.getOperatorText(), operator.getOccurrence(), operator.getQualifiers());
                            operatorInfo = new OperatorInfo((HidOperator)dummyOperator, context.contextOperatorInfo.getParserPath(), context.contextOperatorInfo.getScope(), context.contextOperatorInfo.hasOutputDirection());
                        }
                        result = this.internalCheckOperands(configInfo, false, true, operatorInfo, newOperands, context);
                    }
                    String secondOperandName = SDataUtils.getVariableName((ISDataAbstract)second, (IHidObject)((operator = operatorInfo.getOperator()) != null ? operator.getFirstRHValue() : null));
                    SDataTypeCategory firstCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)first);
                    SDataTypeCategory secondCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)second);
                    if (result == SDataAbstracts.NON_STANDARD && (secondCategory == SDataTypeCategory.NUMERIC || secondCategory == SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED || secondCategory == SDataTypeCategory.ENUM) && firstCategory == SDataTypeCategory.STRING) {
                        String elabPath = context != null ? context.getElabPathForError() : "";
                        AssignmentPatternElement.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_STRING_OPERATION, this.getAttributesForElabPaths(elabPath), "concatenation member '" + secondOperandName + "'", secondDataType.getName());
                    }
                    if (result != null) {
                        AssignmentPatternElement.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_ASSIGNMENT: Illegal assignment of concatenation member ''{0}'' of type ''{1}'' to array element of type ''{2}''", null, secondOperandName, secondDataType, SDataUtils.getDataType((ISDataAbstract)operands.get(0)));
                    }
                }
            } else if (context != null && operands.size() == 2 && operands.get(0) instanceof SDataVariable && (keyElement = (formalPart = (SDataVariable)operands.get(0)).getVariable()) instanceof RfField && keyElement.getEnclosingScope() instanceof RfStruct && !(enclosingStruct = (RfStruct)keyElement.getEnclosingScope()).isEnum()) {
                return this.internalCheckOperands(configInfo, triggerError, true, operatorInfo, operands, context);
            }
            return null;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            return SDataAbstracts.UNDEFINED;
        }

        @Override
        protected String getWidthPaddingMessage(HidOperator operator) {
            return "WIDTH_MISMATCH_PADDING: Assignment to array element of ''{0}'' type from ''{3}'' of ''{1}'' type";
        }

        @Override
        protected String getWidthRoundingMessage(HidOperator operator) {
            return "WIDTH_MISMATCH_ROUNDING: Assignment to array element of ''{0}'' type from ''{3}'' of ''{1}'' type";
        }

        @Override
        protected String getWidthTruncationMessage(HidOperator operator) {
            return "WIDTH_MISMATCH_TRUNCATION: Assignment to array element of ''{0}'' type from ''{3}'' of ''{1}'' type";
        }

        @Override
        protected void addSemanticError(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, ISDataAbstract firstAbstract, ISDataType first, ISDataAbstract secondAbstract, ISDataType second, boolean reverseOrder, String elabPath) {
            ISDataType firstDataType = reverseOrder ? second : first;
            ISDataType secondDataType = reverseOrder ? first : second;
            ISDataAbstract firstDataAbstract = reverseOrder ? secondAbstract : firstAbstract;
            ISDataAbstract secondDataAbstract = reverseOrder ? firstAbstract : secondAbstract;
            String message = this.getUndefinedOperatorErrorMessage(Equality.UndefinedOperatorMessageInfoKind.NO_EXTRA_INFO, operatorInfo.getAssignmentPatternElementCheckKind());
            switch (operatorInfo.getAssignmentPatternElementCheckKind()) {
                case KEY: {
                    AssignmentPatternElement.addSemanticError(configInfo, triggerError, operatorInfo, message, this.getAttributesForElabPaths(elabPath), firstDataType.getName(configInfo.isSemanticShowAliasName()), SDataUtils.getVariableName((ISDataAbstract)firstDataAbstract, (IHidObject)operatorInfo.getOperator().getLHValue()), secondDataType.getName(configInfo.isSemanticShowAliasName()));
                    break;
                }
                case VALUE: {
                    AssignmentPatternElement.addSemanticError(configInfo, triggerError, operatorInfo, message, this.getAttributesForElabPaths(elabPath), firstDataType.getName(configInfo.isSemanticShowAliasName()), SDataUtils.getVariableName((ISDataAbstract)secondDataAbstract, (IHidObject)operatorInfo.getOperator().getFirstRHValue()), secondDataType.getName(configInfo.isSemanticShowAliasName()));
                    break;
                }
                default: {
                    AssignmentPatternElement.addSemanticError(configInfo, triggerError, operatorInfo, message, this.getAttributesForElabPaths(elabPath), firstDataType.getName(configInfo.isSemanticShowAliasName()), secondDataType.getName(configInfo.isSemanticShowAliasName()));
                }
            }
        }

        @Override
        protected void addSemanticError(ConfigInfo configInfo, boolean triggerError, Equality.UndefinedOperatorMessageInfoKind infoKind, OperatorInfo operatorInfo, ISDataAbstract firstAbstract, ISDataType first, ISDataAbstract secondAbstract, ISDataType second, boolean reverseOrder, String elabPath, int firstDetailsChoice, int secondDetailsChoice) {
            ISDataType firstDataType = reverseOrder ? second : first;
            ISDataType secondDataType = reverseOrder ? first : second;
            ISDataAbstract firstDataAbstract = reverseOrder ? secondAbstract : firstAbstract;
            ISDataAbstract secondDataAbstract = reverseOrder ? firstAbstract : secondAbstract;
            String message = this.getUndefinedOperatorErrorMessage(infoKind, operatorInfo.getAssignmentPatternElementCheckKind());
            int detailsChoice = reverseOrder ? firstDetailsChoice : secondDetailsChoice;
            switch (operatorInfo.getAssignmentPatternElementCheckKind()) {
                case KEY: {
                    AssignmentPatternElement.addSemanticError(configInfo, triggerError, operatorInfo, message, this.getAttributesForElabPaths(elabPath), firstDataType.getName(configInfo.isSemanticShowAliasName()), SDataUtils.getVariableName((ISDataAbstract)firstDataAbstract, (IHidObject)operatorInfo.getOperator().getLHValue()), secondDataType.getName(configInfo.isSemanticShowAliasName()), detailsChoice);
                    break;
                }
                case VALUE: {
                    AssignmentPatternElement.addSemanticError(configInfo, triggerError, operatorInfo, message, this.getAttributesForElabPaths(elabPath), firstDataType.getName(configInfo.isSemanticShowAliasName()), SDataUtils.getVariableName((ISDataAbstract)secondDataAbstract, (IHidObject)operatorInfo.getOperator().getFirstRHValue()), secondDataType.getName(configInfo.isSemanticShowAliasName()), detailsChoice);
                    break;
                }
                default: {
                    AssignmentPatternElement.addSemanticError(configInfo, triggerError, operatorInfo, message, this.getAttributesForElabPaths(elabPath), firstDataType.getName(configInfo.isSemanticShowAliasName()), secondDataType.getName(configInfo.isSemanticShowAliasName()), detailsChoice);
                }
            }
        }

        @Override
        protected void addSemanticWarning(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, ISDataAbstract firstAbstract, ISDataType first, ISDataAbstract secondAbstract, ISDataType second, boolean reverseOrder, String elabPath) {
            ISDataType firstDataType = reverseOrder ? second : first;
            ISDataType secondDataType = reverseOrder ? first : second;
            String message = this.getUndefinedOperatorErrorMessage(Equality.UndefinedOperatorMessageInfoKind.NO_EXTRA_INFO);
            AssignmentPatternElement.addSemanticWarning(configInfo, triggerError, operatorInfo, message, this.getAttributesForElabPaths(elabPath), firstDataType.getName(configInfo.isSemanticShowAliasName()), secondDataType.getName(configInfo.isSemanticShowAliasName()));
        }
    }

    protected static abstract class Association
    extends Assignment {
        protected Association() {
        }

        @Override
        protected String getUndefinedOperatorErrorMessage(Equality.UndefinedOperatorMessageInfoKind kind) {
            switch (kind) {
                case PACKED_UNPACKED: {
                    return "ILLEGAL_ASSIGNMENT: Illegal assignment of ''{0}'' to {1} ''{2}'' of type ''{3}'' (cannot assign a{4,choice,0# packed|1#n unpacked} type to a{4,choice,0#n unpacked|1# packed} type)";
                }
                case SIGN_STATE: {
                    return "ILLEGAL_ASSIGNMENT: Illegal assignment of ''{0}'' to {1} ''{2}'' of type ''{3}'' (cannot assign a{4,choice,0# signed|1#n unsigned|2# 2-state|3# 4-state} type to a{4,choice,0#n unsigned|1# signed|2# 4-state|3# 2-state} type)";
                }
                case ARRAYS: {
                    return "ILLEGAL_ASSIGNMENT: Illegal assignment of ''{0}'' to {1} ''{2}'' of type ''{3}'' (arrays have incompatible {4,choice,0#dimensions|1#packed dimensions|2#unpacked dimensions|3#element types|4#element type signing|5#2-state/4-state element types})";
                }
                case CLASSES: {
                    return "ILLEGAL_ASSIGNMENT: Illegal assignment of ''{0}'' to {1} ''{2}'' of type ''{3}'' (class types are not assignment compatible)";
                }
            }
            return "ILLEGAL_ASSIGNMENT: Illegal assignment of ''{0}'' to {1} ''{2}'' of type ''{3}''";
        }

        @Override
        protected String getWidthTruncationMessage(HidOperator operator) {
            return "WIDTH_MISMATCH_TRUNCATION: Assignment to ''{2}'' of ''{0}'' type from ''{3}'' of ''{1}'' type";
        }

        @Override
        protected String getWidthPaddingMessage(HidOperator operator) {
            return "WIDTH_MISMATCH_PADDING: Assignment to ''{2}'' of ''{0}'' type from ''{3}'' of ''{1}'' type";
        }

        @Override
        protected String getWidthRoundingMessage(HidOperator operator) {
            return "WIDTH_MISMATCH_ROUNDING: Assignment to ''{2}'' of ''{0}'' type from ''{3}'' of ''{1}'' type";
        }

        @Override
        protected void addSemanticError(ConfigInfo configInfo, boolean triggerError, Equality.UndefinedOperatorMessageInfoKind infoKind, OperatorInfo operatorInfo, ISDataAbstract firstAbstract, ISDataType first, ISDataAbstract secondAbstract, ISDataType second, boolean reverseOrder, String elabPath, int firstDetailsChoice, int secondDetailsChoice) {
            ISDataType firstDataType = (reverseOrder ^= operatorInfo.hasOutputDirection()) ? second : first;
            ISDataType secondDataType = reverseOrder ? first : second;
            IRfNamedElement firstVariableElement = SDataUtils.getVariableElement((ISDataAbstract)(reverseOrder ? secondAbstract : firstAbstract));
            String firstVariableName = SDataUtils.getVariableName((ISDataAbstract)(reverseOrder ? secondAbstract : firstAbstract), null);
            String message = this.getUndefinedOperatorErrorMessage(infoKind);
            int detailsChoice = reverseOrder ? firstDetailsChoice : secondDetailsChoice;
            Association.addSemanticError(configInfo, triggerError, operatorInfo, message, this.getAttributesForElabPaths(elabPath), secondDataType.getName(configInfo.isSemanticShowAliasName()), this.getBaseMessageType(firstVariableElement), firstVariableName, firstDataType.getName(configInfo.isSemanticShowAliasName()), detailsChoice);
        }

        @Override
        protected void addSemanticError(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, ISDataAbstract firstAbstract, ISDataType first, ISDataAbstract secondAbstract, ISDataType second, boolean reverseOrder, String elabPath) {
            ISDataType firstDataType = (reverseOrder ^= operatorInfo.hasOutputDirection()) ? second : first;
            ISDataType secondDataType = reverseOrder ? first : second;
            IRfNamedElement firstVariableElement = SDataUtils.getVariableElement((ISDataAbstract)(reverseOrder ? secondAbstract : firstAbstract));
            String firstVariableName = SDataUtils.getVariableName((ISDataAbstract)(reverseOrder ? secondAbstract : firstAbstract), null);
            String message = this.getUndefinedOperatorErrorMessage(Equality.UndefinedOperatorMessageInfoKind.NO_EXTRA_INFO);
            Association.addSemanticError(configInfo, triggerError, operatorInfo, message, this.getAttributesForElabPaths(elabPath), secondDataType.getName(configInfo.isSemanticShowAliasName()), this.getBaseMessageType(firstVariableElement), firstVariableName, firstDataType.getName(configInfo.isSemanticShowAliasName()));
        }

        @Override
        protected void addSemanticWarning(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, ISDataAbstract firstAbstract, ISDataType first, ISDataAbstract secondAbstract, ISDataType second, boolean reverseOrder, String elabPath) {
            ISDataType firstDataType = (reverseOrder ^= operatorInfo.hasOutputDirection()) ? second : first;
            ISDataType secondDataType = reverseOrder ? first : second;
            IRfNamedElement firstVariableElement = SDataUtils.getVariableElement((ISDataAbstract)(reverseOrder ? secondAbstract : firstAbstract));
            String firstVariableName = SDataUtils.getVariableName((ISDataAbstract)(reverseOrder ? secondAbstract : firstAbstract), null);
            String message = this.getUndefinedOperatorErrorMessage(Equality.UndefinedOperatorMessageInfoKind.NO_EXTRA_INFO);
            Association.addSemanticWarning(configInfo, triggerError, operatorInfo, message, this.getAttributesForElabPaths(elabPath), secondDataType.getName(configInfo.isSemanticShowAliasName()), this.getBaseMessageType(firstVariableElement), firstVariableName, firstDataType.getName(configInfo.isSemanticShowAliasName()));
        }
    }

    private static class BinAssignment
    extends Assignment {
        private BinAssignment() {
        }

        @Override
        public ISDataType internalCheckOperands(ConfigInfo configInfo, boolean triggerError, boolean forceCheckWidth, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            RfHidOperator rhOperator;
            if (operands.size() != 2) {
                return SDataAbstracts.ILLEGAL;
            }
            HidOperator operator = operatorInfo.getOperator();
            IHidObject rhValue = operator.getFirstRHValue();
            if (rhValue instanceof RfHidImplicit && ((RfHidImplicit)rhValue).isOthers()) {
                return SDataAbstracts.UNDEFINED;
            }
            SDataTypeCategory category = null;
            IHidObject hidObject = rhValue;
            if (rhValue instanceof RfHidOperator && ((RfHidOperator)rhValue).isIffExpression()) {
                rhValue = ((RfHidOperator)rhValue).getLHValue();
            }
            if (rhValue instanceof RfHidOperator && ((rhOperator = (RfHidOperator)rhValue).isWithCoverpointBinsExpression() || rhOperator.isCovergroupRangeList() || rhOperator.isTransList())) {
                return SDataAbstracts.UNDEFINED;
            }
            IRfNamedElement contextDataTypeElement = context.getContextDataTypeElement();
            ISDataAbstract assignedDataType = SEvaluator.INSTANCE.calculateDataType(configInfo, rhValue, contextDataTypeElement, operatorInfo, null);
            category = SDataAbstracts.getOperandCategory((ISDataAbstract)assignedDataType);
            if (category != null && category != SDataTypeCategory.DYNAMIC_ARRAY && category != SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED && category != SDataTypeCategory.FIXED_SIZE_ARRAY_UNPACKED && category != SDataTypeCategory.QUEUE && category != SDataTypeCategory.SET && category != SDataTypeCategory.UNKNOWN && category != SDataTypeCategory.ILLEGAL) {
                IRfNamedElement rhElement = hidObject instanceof Hid ? ((Hid)hidObject).getElement() : null;
                BinAssignment.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_BINS_ASSIGNMENT: Set covergroup expression ''{0}'' is not an array of values", null, rhElement != null ? rhElement.getName() : HidUtils.toNiceString((IHidObject)hidObject));
                return SDataAbstracts.ILLEGAL;
            }
            return SDataAbstracts.UNDEFINED;
        }
    }

    private static class BitWise
    extends Logical {
        private final EnumSet<SDataTypeCategory> permittedOperands = EnumSet.of(SDataTypeCategory.NUMERIC, new SDataTypeCategory[]{SDataTypeCategory.LITERAL_STRING, SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED, SDataTypeCategory.STRUCT_PACKED, SDataTypeCategory.UNION_PACKED, SDataTypeCategory.ENUM});

        private BitWise() {
        }

        @Override
        public EnumSet<SDataTypeCategory> getPermittedOperands() {
            return this.permittedOperands;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            return this.getResolvedTypeAccordingToPriority(operatorInfo, operands);
        }
    }

    private static class Break
    extends Continue {
        private Break() {
        }

        @Override
        public String getStatementError() {
            return "ILLEGAL_BREAK_OUTSIDE_LOOP: Break statement not allowed outside loop";
        }
    }

    private static class CaseItemCondition
    extends SOperation {
        private CaseItemCondition() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            IRfNamedElement operatorScope = operatorInfo.getScope();
            if (operatorScope instanceof RfGenerateBlock) {
                return null;
            }
            ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)operands.get(0));
            ISDataType secondDataType = SDataUtils.getDataType((ISDataAbstract)operands.get(1));
            if (SDataUtils.getUndefinedDataType((ISDataAbstract)firstDataType) != null || SDataUtils.getUndefinedDataType((ISDataAbstract)secondDataType) != null) {
                return null;
            }
            if (SOperation.internalCheckStringOperand(firstDataType) || SOperation.internalCheckStringOperand(secondDataType)) {
                return null;
            }
            ELWidthCheckContext elabContext = context.getElabContext();
            if (elabContext == null) {
                return null;
            }
            IHidEvaluator evaluator = elabContext.getEvaluator((IRfScopeElement)operatorScope);
            IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.TYPE_MATCHING, (IRfNamedElement)operatorScope, null, (boolean)true, (ELManager)elabContext.getManager());
            IHidObject firstHid = operatorInfo.getOperator().getLHValue();
            IHidObject secondHidObject = operatorInfo.getOperator().getFirstRHValue();
            IELParamValue firstSizeValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluateForSize((IHidObject)firstHid, (IHidEvaluator)evaluator, (IRfNamedElement)operatorScope, (IHidEvaluationGuardian)guardian));
            if (ELUtils.isUnsuccessfulEval((IELParamValue)firstSizeValue)) {
                return null;
            }
            DVTNumber firstSizeNumber = firstSizeValue.getDVTNumber();
            int firstSize = firstSizeNumber.getSize();
            if (DVTNumber.isUnknownSize((int)firstSize)) {
                return null;
            }
            ArrayList<IHidObject> secondHidObjects = new ArrayList<IHidObject>(2);
            if (HidUtils.isOperator((IHidObject)secondHidObject) && ((RfHidOperator)secondHidObject).isComma()) {
                ListContainer rhValues = ((HidOperator)secondHidObject).getRHValues();
                if (rhValues == null) {
                    return null;
                }
                for (IHidObject rhValue : rhValues) {
                    secondHidObjects.add(rhValue);
                }
            } else {
                secondHidObjects.add(secondHidObject);
            }
            if (configInfo.isElabWidthCheckDisabled()) {
                return null;
            }
            boolean isIllegal = false;
            for (IHidObject secondHid : secondHidObjects) {
                String secondName;
                String firstName;
                IELParamValue secondSizeValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluateForSize((IHidObject)secondHid, (IHidEvaluator)evaluator, (IRfNamedElement)operatorScope, (IHidEvaluationGuardian)guardian));
                if (ELUtils.isUnsuccessfulEval((IELParamValue)secondSizeValue)) {
                    return null;
                }
                DVTNumber secondSizeNumber = secondSizeValue.getDVTNumber();
                int secondSize = secondSizeNumber.getSize();
                if (DVTNumber.isUnknownSize((int)secondSize)) {
                    return null;
                }
                if (firstSize < secondSize) {
                    firstName = SDataUtils.getVariableName((ISDataAbstract)firstDataType, (IHidObject)firstHid);
                    secondName = SDataUtils.getVariableName((ISDataAbstract)secondDataType, (IHidObject)secondHid);
                    CaseItemCondition.addSemanticWarning(configInfo, triggerError, operatorInfo, "CASE_ITEM_WIDTH_MISMATCH: Comparison between case expression ''{0}'' of ''{1}'' type and item expression ''{2}'' of ''{3}'' type", this.getAttributesForElabPaths(elabContext.getPathsTextForError()), firstName, String.valueOf(firstSize) + "-bit", secondName, String.valueOf(secondSize) + "-bit");
                    isIllegal = true;
                    continue;
                }
                if (!(firstSizeNumber.hasSign() ^ secondSizeNumber.hasSign())) continue;
                firstName = SDataUtils.getVariableName((ISDataAbstract)firstDataType, (IHidObject)firstHid);
                secondName = SDataUtils.getVariableName((ISDataAbstract)secondDataType, (IHidObject)secondHid);
                CaseItemCondition.addSemanticWarning(configInfo, triggerError, operatorInfo, "CASE_ITEM_SIGNING_MISMATCH: Comparison between case expression ''{0}'' of {1} type and item expression ''{2}'' of {3} type", this.getAttributesForElabPaths(elabContext.getPathsTextForError()), firstName, String.valueOf(firstSizeNumber.hasSign() ? "" : "un") + "signed", secondName, String.valueOf(secondSizeNumber.hasSign() ? "" : "un") + "signed");
                isIllegal = true;
            }
            return isIllegal ? SDataAbstracts.ILLEGAL : null;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType nonValidOperand = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (nonValidOperand != null) {
                return nonValidOperand;
            }
            return STransformer.LOGIC_VARIABLE;
        }
    }

    private static class Cast
    extends SOperation {
        private Cast() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            boolean bitStreamCast;
            boolean isSecondPredefinedScalarOrPacked;
            ISDataAbstract firstData = operands.get(0);
            ISDataAbstract secondData = operands.get(1);
            ISDataType isValid = this.isUnsupportedTypeParameter(operands);
            if (isValid != null) {
                return isValid;
            }
            ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)firstData);
            IRfNamedElement firstType = firstDataType.getType();
            if (!(!(firstData instanceof SDataVariable) || firstType instanceof RfPredefinedScalarType || firstType instanceof RfListType && ((RfListType)firstType).getAssociatedType() instanceof RfPredefinedScalarType)) {
                Cast.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_VARIABLE_REFERENCE: ''{0}'' cannot be resolved to a type", null, ((SDataVariable)firstData).getVariableName());
                return SDataAbstracts.ILLEGAL;
            }
            if (!(secondData instanceof SDataVariable)) {
                Cast.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_TYPE_REFERENCE: ''{0}'' cannot be resolved to a variable", null, SDataUtils.getDataType((ISDataAbstract)secondData).getName(configInfo.isSemanticShowAliasName()));
                return SDataAbstracts.ILLEGAL;
            }
            ListContainer rhValues = operatorInfo.getOperator().getRHValues();
            if (STransformer.SIGNED == firstDataType || STransformer.UNSIGNED == firstDataType || STransformer.CONST == firstDataType) {
                return null;
            }
            ISDataType secondDataType = SDataUtils.getDataType((ISDataAbstract)secondData);
            IRfNamedElement secondType = secondDataType.getType();
            if (firstType == secondType) {
                return null;
            }
            if (firstType instanceof RfClass && secondType instanceof RfClass) {
                RfClass firstClass = (RfClass)firstType;
                RfClass secondClass = (RfClass)secondType;
                if (firstClass.equals(secondClass) || firstClass.isSubClass(secondClass, true, false) || secondClass.isSubClass(firstClass, true, false)) {
                    return null;
                }
                String variableName = SDataUtils.getVariableName((ISDataAbstract)secondData, rhValues != null && !rhValues.isEmpty() ? (IHidObject)rhValues.get(0) : null);
                Cast.addSemanticError(configInfo, triggerError, operatorInfo, this.getUndefinedOperatorErrorMessage(UndefinedOperatorMessageInfoKind.CLASSES), null, variableName, secondDataType.getName(configInfo.isSemanticShowAliasName()), firstDataType.getName(configInfo.isSemanticShowAliasName()));
                return SDataAbstracts.ILLEGAL;
            }
            boolean isFirstPredefinedScalarOrPacked = firstType instanceof RfPredefinedScalarType || firstType.isPackedBitStream();
            boolean bl = isSecondPredefinedScalarOrPacked = secondType instanceof RfPredefinedScalarType || "literal_string".equals(secondType.getName()) || secondType.isPackedBitStream();
            if (isFirstPredefinedScalarOrPacked && isSecondPredefinedScalarOrPacked && (!(firstType instanceof RfStringType) || !(secondType instanceof RfRealScalarType) && secondType != RfPredefinedScalarType.CHANDLE)) {
                return null;
            }
            if (firstType instanceof RfCovercross.QueueType || secondType instanceof RfCovercross.QueueType) {
                return null;
            }
            boolean listToListWithSameBaseElementTypeCast = false;
            boolean listToListWithSameBaseElementTypeCastComputed = false;
            if (firstType instanceof RfListType && secondType instanceof RfListType) {
                ISDataType firstCachedBase = firstDataType.getCachedListBaseElementType();
                ISDataType secondCachedBase = secondDataType.getCachedListBaseElementType();
                listToListWithSameBaseElementTypeCast = firstCachedBase != null && SDataUtils.getUndefinedDataType((ISDataAbstract)firstCachedBase) == null && secondCachedBase != null && SDataUtils.getUndefinedDataType((ISDataAbstract)secondCachedBase) == null && firstCachedBase.getType().equals(secondCachedBase.getType());
                listToListWithSameBaseElementTypeCastComputed = true;
            }
            ELWidthCheckContext elabContext = context != null ? context.getElabContext() : null;
            boolean bl2 = bitStreamCast = !RfListType.isAssociativeArray((IRfScopeElement)firstType) && !(firstType instanceof RfClass) && firstType.isBitStream() && secondType.isBitStream();
            if (listToListWithSameBaseElementTypeCast || bitStreamCast) {
                if (firstType instanceof RfStringType) {
                    return null;
                }
                if (elabContext == null) {
                    return null;
                }
                IHidEvaluator evaluator = elabContext.getEvaluatorForPortConnections(true);
                IRfNamedElement operatorScope = operatorInfo.getScope();
                IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.TYPE_MATCHING, (IRfNamedElement)operatorScope, null, (boolean)true, (ELManager)elabContext.getManager());
                IHidObject firstHid = operatorInfo.getOperator().getLHValue();
                IHidObject secondHid = operatorInfo.getOperator().getFirstRHValue();
                IELParamValue firstSizeValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluateForSize((IHidObject)firstHid, (IHidEvaluator)evaluator, (IRfNamedElement)operatorScope, (IHidEvaluationGuardian)guardian));
                if (firstSizeValue == null) {
                    return null;
                }
                DVTNumber firstSizeNumber = firstSizeValue.getDVTNumber();
                if (DVTNumber.isUndefined((DVTNumber)firstSizeNumber)) {
                    return null;
                }
                int firstSize = firstSizeNumber.getSize();
                if (DVTNumber.isUnknownSize((int)firstSize)) {
                    return null;
                }
                IELParamValue secondSizeValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluateForSize((IHidObject)secondHid, (IHidEvaluator)evaluator, (IRfNamedElement)operatorScope, (IHidEvaluationGuardian)guardian));
                if (secondSizeValue == null) {
                    return null;
                }
                DVTNumber secondSizeNumber = secondSizeValue.getDVTNumber();
                if (DVTNumber.isUndefined((DVTNumber)secondSizeNumber)) {
                    return null;
                }
                int secondSize = secondSizeNumber.getSize();
                if (DVTNumber.isUnknownSize((int)secondSize)) {
                    return null;
                }
                if (firstSize == secondSize) {
                    return null;
                }
                String variableName = SDataUtils.getVariableName((ISDataAbstract)secondData, rhValues != null && !rhValues.isEmpty() ? (IHidObject)rhValues.get(0) : null);
                String firstName = firstDataType.getName(configInfo.isSemanticShowAliasName());
                String secondName = secondDataType.getName(configInfo.isSemanticShowAliasName());
                Map<String, Object> attributes = this.getAttributesForElabPaths(context != null ? context.getElabPathForError() : "");
                Cast.addSemanticError(configInfo, triggerError, operatorInfo, this.getUndefinedOperatorErrorMessage(UndefinedOperatorMessageInfoKind.ARRAYS), attributes, variableName, secondName, firstName, 0);
                return SDataAbstracts.ILLEGAL;
            }
            String variableName = SDataUtils.getVariableName((ISDataAbstract)secondData, rhValues != null && !rhValues.isEmpty() ? (IHidObject)rhValues.get(0) : null);
            String firstName = firstDataType.getName(configInfo.isSemanticShowAliasName());
            String secondName = secondDataType.getName(configInfo.isSemanticShowAliasName());
            Map<String, Object> attributes = this.getAttributesForElabPaths(context != null ? context.getElabPathForError() : "");
            if (!listToListWithSameBaseElementTypeCast && listToListWithSameBaseElementTypeCastComputed) {
                Cast.addSemanticError(configInfo, triggerError, operatorInfo, this.getUndefinedOperatorErrorMessage(UndefinedOperatorMessageInfoKind.ARRAYS), attributes, variableName, secondName, firstName, 1);
            } else if (!bitStreamCast) {
                if (!firstType.isBitStream()) {
                    Cast.addSemanticError(configInfo, triggerError, operatorInfo, this.getUndefinedOperatorErrorMessage(UndefinedOperatorMessageInfoKind.NON_BIT_STREAM_CAST), attributes, variableName, secondName, firstName, 0);
                } else {
                    Cast.addSemanticError(configInfo, triggerError, operatorInfo, this.getUndefinedOperatorErrorMessage(UndefinedOperatorMessageInfoKind.NON_BIT_STREAM_CAST), attributes, variableName, secondName, firstName, 1);
                }
            } else {
                Cast.addSemanticError(configInfo, triggerError, operatorInfo, this.getUndefinedOperatorErrorMessage(UndefinedOperatorMessageInfoKind.NO_EXTRA_INFO), attributes, variableName, secondName, firstName);
            }
            return SDataAbstracts.ILLEGAL;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            boolean isSecondVariableFinal;
            ISDataType isValid = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            ISDataAbstract first = operands.get(0);
            ISDataAbstract second = operands.get(1);
            ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)first);
            ISDataType secondDataType = SDataUtils.getDataType((ISDataAbstract)second);
            SDataVariable secondVariable = SDataUtils.getVariable((ISDataAbstract)second);
            boolean bl = isSecondVariableFinal = secondVariable != null && secondVariable.isFinal;
            if (firstDataType == STransformer.SIGNED && secondDataType instanceof SDataType) {
                ISDataType newDataType = secondDataType.copy(false);
                newDataType.setSign(1);
                return SDataVariable.of((ISDataType)newDataType, (boolean)isSecondVariableFinal);
            }
            if (firstDataType == STransformer.UNSIGNED && secondDataType instanceof SDataType) {
                ISDataType newDataType = secondDataType.copy(false);
                newDataType.setSign(0);
                return SDataVariable.of((ISDataType)newDataType, (boolean)isSecondVariableFinal);
            }
            if (firstDataType == STransformer.CONST && secondDataType instanceof SDataType) {
                return SDataVariable.of((ISDataType)secondDataType, (boolean)true);
            }
            return SDataVariable.of((ISDataType)SDataUtils.getDataType((ISDataAbstract)first), (boolean)false);
        }

        protected String getUndefinedOperatorErrorMessage(UndefinedOperatorMessageInfoKind kind) {
            switch (kind) {
                case ARRAYS: {
                    return "ILLEGAL_CAST_OPERATION: Cannot cast ''{0}'' of type ''{1}'' to ''{2}'' (arrays have incompatible {3,choice,0#dimensions|1#element types})";
                }
                case CLASSES: {
                    return "ILLEGAL_CAST_OPERATION: Cannot cast ''{0}'' of type ''{1}'' to ''{2}'' (class types are not assignment compatible)";
                }
                case NON_BIT_STREAM_CAST: {
                    return "ILLEGAL_CAST_OPERATION: Cannot cast ''{0}'' of type ''{1}'' to ''{2}'' (non-bitstream cast {3,choice,0#type|1#expression})";
                }
            }
            return "ILLEGAL_CAST_OPERATION: Cannot cast ''{0}'' of type ''{1}'' to ''{2}''";
        }

        protected static enum UndefinedOperatorMessageInfoKind {
            NO_EXTRA_INFO,
            ARRAYS,
            CLASSES,
            NON_BIT_STREAM_CAST;

        }
    }

    private static class ClockOperationsOR
    extends SOperation {
        private ClockOperationsOR() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkValidOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            if (operatorInfo.getOperator() == null) {
                return null;
            }
            return this.checkEventTypes(configInfo, triggerError, operatorInfo, operands, OptimizedUtils.asList((ListContainer)operatorInfo.getOperator().getRHValues(), (boolean)false));
        }

        private ISDataType checkEventTypes(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, List<IHidObject> values) {
            StringBuilder errorElements = new StringBuilder();
            int operandsSize = operands.size();
            if (values == null || operandsSize != values.size()) {
                return null;
            }
            int i = 0;
            while (i < operandsSize) {
                ISDataType dataType;
                ISDataAbstract operand = operands.get(i);
                SDataTypeCategory category = SDataAbstracts.getOperandCategory((ISDataAbstract)operand);
                if (category != SDataTypeCategory.REAL && (dataType = SDataUtils.getDataType((ISDataAbstract)operand)) != null && dataType.getNofUnpackedDimensions() != 0) {
                    IHidObject value = values.get(operandsSize - 1 - i);
                    errorElements.append(errorElements.length() == 0 ? " " : ", ").append(HidUtils.toNiceString((IHidObject)value));
                }
                ++i;
            }
            if (errorElements.length() != 0) {
                if (triggerError) {
                    ClockOperationsOR.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_EVENT_CONTROL, null, errorElements);
                }
                return SDataAbstracts.NON_STANDARD;
            }
            return null;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            return STransformer.LOGIC_VARIABLE;
        }
    }

    private static class Concatenation
    extends SOperation {
        public static final EnumSet<SDataTypeCategory> permittedOperands = EnumSet.of(SDataTypeCategory.NUMERIC, new SDataTypeCategory[]{SDataTypeCategory.LITERAL_STRING, SDataTypeCategory.STRING, SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED, SDataTypeCategory.STRUCT_PACKED, SDataTypeCategory.UNION_PACKED, SDataTypeCategory.ENUM});

        private Concatenation() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType nonValidOperand = this.checkValidOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (nonValidOperand != null) {
                return nonValidOperand;
            }
            if (context != null && context.isUndefined()) {
                return SDataUtils.getDataType((ISDataAbstract)context.getContextDataType());
            }
            if (operands.size() == 2 && operatorInfo.getOperator().getRHValues().size() == 3) {
                int totalSize;
                ISDataType second;
                IRfNamedElement secondType;
                BitVectorContext bitVectorContext;
                IHidEvaluator.NullHidEvaluator evaluator;
                IELParamValue lhSizeValue;
                ListContainer rhValues = operatorInfo.getOperator().getRHValues();
                IHidObject sizeHidObject = (IHidObject)rhValues.get(2);
                int firstSize = 0;
                int secondSize = 0;
                if (sizeHidObject instanceof HidImplicit && !ELUtils.isUnsuccessfulEval((IELParamValue)(lhSizeValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)sizeHidObject, (IHidEvaluator)(evaluator = context != null && context.getElabContext() != null ? context.getElabContext().getEvaluator((IRfScopeElement)operatorInfo.getScope()) : new IHidEvaluator.NullHidEvaluator()), (BitVectorContext)(bitVectorContext = BitVectorContext.of((IRfNamedElement)operatorInfo.getScope(), (boolean)false)), (IHidEvaluationGuardian)IHidEvaluationGuardian.DUMMY_EVAL_GUARDIAN)))) && lhSizeValue.getDVTNumber() instanceof VlogBitVector) {
                    firstSize = ((VlogBitVector)lhSizeValue.getDVTNumber()).intValue();
                }
                if ((secondType = (second = SDataUtils.getDataType((ISDataAbstract)operands.get(1))).getType()) instanceof RfBitVectorScalarType || secondType instanceof RfComputedListType) {
                    secondSize = ((IRfTypeElement)secondType).getBitSize();
                }
                if ((totalSize = firstSize * secondSize) > 0) {
                    return SDataType.of(RfComputedListType.of((RfBitVectorScalarType)secondType, totalSize, 2));
                }
                operands = operands.subList(1, operands.size());
            }
            boolean has4StateType = false;
            boolean isString = false;
            ISDataType result = null;
            ListContainer rhValues = operatorInfo.getOperator().getRHValues();
            BitSet isIllegalValueSet = new BitSet(rhValues.size());
            int index = rhValues.size();
            for (ISDataAbstract operand : operands) {
                ISDataType iSDataType;
                ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)operand);
                SDataTypeCategory operandCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)operand);
                IHidObject rhValue = (IHidObject)rhValues.get(--index);
                String variableName = SDataUtils.getVariableName((ISDataAbstract)operand, rhValues != null && !rhValues.isEmpty() ? rhValue : null);
                if (!permittedOperands.contains(operandCategory) || firstDataType.getNofUnpackedDimensions() != 0) {
                    Concatenation.addSemanticError(configInfo, triggerError, operatorInfo, "UNDEFINED_OPERATOR: Concatenation operator is undefined for argument ''{0}'' of type ''{1}''", null, variableName, firstDataType.getName(configInfo.isSemanticShowAliasName()));
                    result = SDataAbstracts.ILLEGAL;
                }
                if (result == SDataAbstracts.ILLEGAL) continue;
                if (operandCategory == SDataTypeCategory.STRING || operandCategory == SDataTypeCategory.LITERAL_STRING) {
                    isString = true;
                    result = result == null || result == STransformer.STRING_CONCATENATION_VARIABLE.type ? STransformer.STRING_CONCATENATION_VARIABLE.type : SDataAbstracts.ILLEGAL;
                    continue;
                }
                if (operandCategory == SDataTypeCategory.ENUM && firstDataType.getEnumElementType() != SDataAbstracts.UNDEFINED) {
                    firstDataType = firstDataType.getEnumElementType();
                }
                isIllegalValueSet.set(index, rhValue instanceof RfHidImplicit && !Assignment.internalLiteralHasSizedSpecified((RfHidImplicit)rhValue));
                ISDataType typeCandidate = firstDataType.hasDimensions() ? firstDataType.getCachedListBaseElementType() : firstDataType;
                has4StateType |= RfBitVectorScalarType.isFourState(typeCandidate != null ? typeCandidate.getType() : null);
                if (result == null || result == STransformer.NUMERIC_4_STATE_CONCATENATION_VARIABLE.type || result == STransformer.NUMERIC_2_STATE_CONCATENATION_VARIABLE.type) {
                    if (has4StateType) {
                        iSDataType = STransformer.NUMERIC_4_STATE_CONCATENATION_VARIABLE.type;
                        continue;
                    }
                    iSDataType = STransformer.NUMERIC_2_STATE_CONCATENATION_VARIABLE.type;
                    continue;
                }
                iSDataType = result = SDataAbstracts.ILLEGAL;
            }
            if (!isString && context != null && context.getContextDataType() != null) {
                IRfNamedElement contextDataTypeElement = context.getContextDataTypeElement();
                boolean bl = isString = contextDataTypeElement != null && "string".equals(contextDataTypeElement.getName());
            }
            if (!isString && !operatorInfo.isReplicatedConcatenationCondition()) {
                IHidObject candidate;
                ListContainer rightOps;
                IRfNamedElement initialScope = operatorInfo.getScope();
                ParserPath parserPath = operatorInfo.getParserPath();
                RfProject rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vlogdt.VlogNature");
                HidOperator thisOperator = operatorInfo.getOperator();
                if (HidUtils.isOperator((IHidObject)thisOperator) && thisOperator.isVLOGConcatenation(true) && (rightOps = thisOperator.getRHValues()).size() == 3 && HidUtils.isHidImplicit((IHidObject)(candidate = (IHidObject)rightOps.get(1))) && ((IHidImplicit)candidate).isConcatenationReplication()) {
                    IHidObject nofReplicationsObject = (IHidObject)rightOps.get(2);
                    Set toHids = HidUtils.flattenToHids((IHidObject)nofReplicationsObject, (Set)HidFlatteningOption.IMPLICITS_SELECTS_AND_ARGS_EXCLUDED);
                    for (IHid hid : toHids) {
                        if (!(hid instanceof RfHid)) continue;
                        ((RfHid)hid).checkConstantPrimary(triggerError, initialScope, parserPath, isString, true, rfProject, configInfo);
                    }
                }
                index = 0;
                while (index < rhValues.size()) {
                    IHidObject value = (IHidObject)rhValues.get(index);
                    if (isIllegalValueSet.get(index)) {
                        HidOperatorOccurrence occurrence = operatorInfo.getOperator().getOccurrence();
                        int line = HidUtils.getLine((HidOccurrence)occurrence);
                        String valueName = HidUtils.toNiceString((IHidObject)value);
                        int startOffset = HidUtils.getStartOffset((HidOccurrence)occurrence);
                        int endOffset = HidUtils.getEndOffset((IHidObject)operatorInfo.getOperator(), (int)startOffset, (HidOccurrence)occurrence);
                        rfProject.addSemanticError(2, "ILLEGAL_UNSIZED_NUMBER_IN_BIT_CONCATENATION : Expecting a sized constant number, found ''{0}''", operatorInfo.getScope().getLibPkgScope(), startOffset, endOffset, null, line, operatorInfo.getParserPath(), valueName);
                        result = null;
                    }
                    ++index;
                }
            }
            return result != null ? result : SDataAbstracts.ILLEGAL;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (SDataUtils.getUndefinedDataType((ISDataAbstract)isValid) != null) {
                return isValid;
            }
            if (isValid == STransformer.STRING_CONCATENATION_VARIABLE.type) {
                return STransformer.STRING_CONCATENATION_VARIABLE;
            }
            if (isValid == STransformer.NUMERIC_2_STATE_CONCATENATION_VARIABLE.type) {
                return STransformer.NUMERIC_2_STATE_CONCATENATION_VARIABLE;
            }
            if (isValid == STransformer.NUMERIC_4_STATE_CONCATENATION_VARIABLE.type) {
                return STransformer.NUMERIC_4_STATE_CONCATENATION_VARIABLE;
            }
            return SDataVariable.of((ISDataType)isValid, (boolean)false);
        }
    }

    private static class Constraint
    extends SOperation {
        private Constraint() {
        }

        protected static void addSemanticError(RfProject rfProject, OperatorInfo operatorInfo, Hid hid, int problemType, String message, Map<String, Object> attributes, Object ... arguments) {
            if (rfProject == null || hid == null) {
                return;
            }
            IRfNamedElement element = hid.getElement();
            if (element == null) {
                return;
            }
            IRfScopeElement scope = element.getEnclosingScope();
            if (scope == null) {
                return;
            }
            HidOccurrence occurrence = hid.getOccurrence();
            if (occurrence == null) {
                return;
            }
            int line = occurrence.getLine();
            int offsetStart = occurrence.getOffsetOutsideMacro();
            int offsetEnd = offsetStart + element.getName().length();
            rfProject.addSemanticError(problemType, message, scope instanceof IRfNamedElement ? ((IRfNamedElement)scope).getLibPkgScope() : null, offsetStart, offsetEnd, attributes, line, operatorInfo.getParserPath(), arguments);
        }

        protected List<IHid> internalGetFlattenedHids(IHidObject value) {
            if (value == null) {
                return Collections.emptyList();
            }
            ArrayList<IHid> hids = new ArrayList<IHid>();
            Predicate<IHidObject> result = element -> {
                IHid hid = HidUtils.getHidFrom((IHidObject)element);
                if (hid != null) {
                    hids.add(hid);
                }
                return true;
            };
            HidUtils.flattenToObjects(result, (IHidObject)value, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
            return hids;
        }

        protected IHidObject internalExtractObjectFromOperator(HidOperator operator) {
            return operator;
        }

        protected int getErrorConstraintOption() {
            return 0;
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType nonValidOperand = this.checkValidOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (nonValidOperand != null) {
                return nonValidOperand;
            }
            RfProject rfProject = null;
            HidOperator operator = operatorInfo.getOperator();
            boolean illegal = false;
            List<IHid> objs = this.internalGetFlattenedHids(this.internalExtractObjectFromOperator(operator));
            ArrayDeque<Hid> parentToChildHids = new ArrayDeque<Hid>();
            for (IHid obj : objs) {
                if (!(obj instanceof Hid)) continue;
                Hid hid = (Hid)obj;
                while (hid != null) {
                    parentToChildHids.push(hid);
                    hid = hid.getParentHid();
                }
                boolean hasParentRandomizeAccess = false;
                boolean isNotRand = true;
                boolean isRandc = false;
                while (!parentToChildHids.isEmpty()) {
                    hid = (Hid)parentToChildHids.pop();
                    IRfNamedElement element = hid.getElement();
                    if (!(element instanceof RfField) || ((RfField)element).isImplicit() || hasParentRandomizeAccess) continue;
                    hasParentRandomizeAccess = hid.getParentAccess() != null && hid.getParentAccess().getAccessKind() == 3;
                    boolean bl = !((RfField)element).isRand();
                    isRandc = ((RfField)element).isRandc();
                    if (!(isNotRand &= bl) && !isRandc) continue;
                    if (rfProject == null) {
                        rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vlogdt.VlogNature");
                    }
                    Constraint.addSemanticError(rfProject, operatorInfo, hid, 2, isRandc ? "ILLEGAL_RANDC_IN_CONSTRAINT: Cannot use randc variable ''{0}'' in {1,choice,0#|1#solve-before|2#unique|3#distribution} constraint" : "ILLEGAL_NON_RAND_IN_CONSTRAINT: Cannot use non-rand variable ''{0}'' in {1,choice,0#|1#solve-before|2#unique|3#distribution} constraint", null, element.getName(), this.getErrorConstraintOption());
                    illegal = true;
                }
            }
            return illegal ? SDataAbstracts.ILLEGAL : null;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType nonValidOperand = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (nonValidOperand != null) {
                return nonValidOperand;
            }
            return STransformer.BIT_VARIABLE;
        }
    }

    private static class Continue
    extends SOperation {
        private Continue() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            IRfNamedElement scope = operatorInfo.getScope();
            if (scope == null) {
                return null;
            }
            boolean isLoop = false;
            IRfNamedElement firstScope = scope;
            boolean isInProduction = false;
            boolean isFirstInFork = false;
            do {
                RfFunction functionScope;
                if (firstScope instanceof RfFunction && (functionScope = (RfFunction)firstScope).isProduction()) {
                    isInProduction = true;
                    break;
                }
                if (!(firstScope instanceof RfActionBlock)) continue;
                RfActionBlock actionBlock = (RfActionBlock)firstScope;
                isFirstInFork |= actionBlock.isForkJoin() || actionBlock.isForkJoinAny() || actionBlock.isForkJoinNone();
                if (!actionBlock.isLoop()) continue;
                isLoop = !isFirstInFork;
                break;
            } while ((firstScope = firstScope.getEnclosingScope()) instanceof IRfNamedElement);
            if (!isLoop && !isInProduction) {
                Continue.addSemanticError(configInfo, triggerError, operatorInfo, this.getStatementError(), null, new Object[0]);
                return SDataAbstracts.ILLEGAL;
            }
            return null;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            return STransformer.CONTINUE_OR_BREAK_DATA_TYPE;
        }

        protected String getStatementError() {
            return "ILLEGAL_CONTINUE_OUTSIDE_LOOP: Continue statement not allowed outside loop";
        }
    }

    private static class DisableConstraint
    extends SOperation {
        private DisableConstraint() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            Hid constraintTargetHid;
            HidOperator operator = operatorInfo.getOperator();
            if (operator == null || operands.size() != 1) {
                return SDataAbstracts.ILLEGAL;
            }
            IHidObject lhValue = operator.getLHValue();
            Object object = lhValue instanceof HidAccess ? ((HidAccess)lhValue).getParentHid() : (constraintTargetHid = lhValue instanceof Hid ? (Hid)lhValue : null);
            if (constraintTargetHid == null) {
                return null;
            }
            int startOffset = constraintTargetHid.getAncestorHid().getOccurrence().getOffset();
            int endOffset = operator.getCloseBoundary();
            IRfNamedElement targetElem = constraintTargetHid.getElement();
            if (targetElem == null) {
                return SDataAbstracts.ILLEGAL;
            }
            if (!(targetElem instanceof RfField)) {
                DisableConstraint.addSemanticErrorWithOffsets(configInfo, triggerError, operatorInfo, "INVALID_DISABLE_SOFT_CONSTRAINT: Non-variable ''{0}'' not allowed in disable soft constraint", null, startOffset, endOffset, HidUtils.toNiceString((IHidObject)operator.getLHValue()));
                return SDataAbstracts.ILLEGAL;
            }
            RfField field = (RfField)targetElem;
            if (field.isEnumElement() || field.isConst() || field.isTypeParameter() || field.isParameter()) {
                DisableConstraint.addSemanticErrorWithOffsets(configInfo, triggerError, operatorInfo, "INVALID_DISABLE_SOFT_CONSTRAINT: Non-variable ''{0}'' not allowed in disable soft constraint", null, startOffset, endOffset, HidUtils.toNiceString((IHidObject)operator.getLHValue()));
                return SDataAbstracts.ILLEGAL;
            }
            return null;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            return STransformer.BIT_VARIABLE;
        }
    }

    private static class Distribution
    extends Constraint {
        private Distribution() {
        }

        @Override
        protected IHidObject internalExtractObjectFromOperator(HidOperator operator) {
            return operator.getLHValue();
        }

        @Override
        protected int getErrorConstraintOption() {
            return 3;
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            IRfNamedElement scope = operatorInfo.getScope();
            while (scope instanceof RfActionBlock) {
                scope = scope.getEnclosingScope();
            }
            if (scope instanceof RfConstraint) {
                return super.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            }
            return this.checkValidOperands(configInfo, triggerError, operatorInfo, operands, context);
        }
    }

    private static class Equality
    extends SOperation {
        public static final EnumSet<SDataTypeCategory> permittedOperands = EnumSet.of(SDataTypeCategory.NUMERIC, new SDataTypeCategory[]{SDataTypeCategory.SHORTREAL, SDataTypeCategory.REAL, SDataTypeCategory.LITERAL_STRING, SDataTypeCategory.STRING, SDataTypeCategory.EVENT, SDataTypeCategory.COVERGROUP, SDataTypeCategory.CLASS, SDataTypeCategory.MODPORT, SDataTypeCategory.INTERFACE, SDataTypeCategory.GENERIC_INTERFACE, SDataTypeCategory.NULL, SDataTypeCategory.CHANDLE, SDataTypeCategory.NEW, SDataTypeCategory.ENUM, SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED, SDataTypeCategory.FIXED_SIZE_ARRAY_UNPACKED, SDataTypeCategory.ASSOCIATIVE_ARRAY, SDataTypeCategory.DYNAMIC_ARRAY, SDataTypeCategory.QUEUE, SDataTypeCategory.STRUCT_PACKED, SDataTypeCategory.STRUCT_UNPACKED, SDataTypeCategory.UNION_PACKED, SDataTypeCategory.UNION_UNPACKED});

        private Equality() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            SDataVariable firstVariable;
            ISDataType isValid = this.internalCheckOperands(configInfo, triggerError, false, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            ISDataAbstract first = operands.get(0);
            ISDataAbstract second = operands.get(1);
            ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)first);
            ISDataType secondDataType = SDataUtils.getDataType((ISDataAbstract)second);
            if (triggerError && firstDataType instanceof SDataType && ((SDataType)firstDataType).isEnum() && !(firstVariable = SDataUtils.getVariable((ISDataAbstract)first)).isEnumDeclarationAssign(operatorInfo.getOperator())) {
                IRfNamedElement secondVariableElement;
                IRfNamedElement secondEnum = secondDataType instanceof SDataType && ((SDataType)secondDataType).isEnum() ? secondDataType.getType() : null;
                IRfNamedElement iRfNamedElement = secondVariableElement = second instanceof SDataVariable ? ((SDataVariable)second).getEnumLiteral() : null;
                if (secondEnum == null) {
                    IRfNamedElement iRfNamedElement2 = secondEnum = secondVariableElement instanceof RfField && ((RfField)secondVariableElement).isEnumElement() ? (IRfNamedElement)secondVariableElement.getEnclosingScope() : null;
                }
                if (secondEnum != null && !secondEnum.equals(firstDataType.getType())) {
                    String aliasFirstEnum = ((RfStruct)firstDataType.getType()).getAliasName();
                    if (aliasFirstEnum == null) {
                        String variableName = SDataUtils.getVariableName((ISDataAbstract)firstVariable, null);
                        aliasFirstEnum = DVTStringUtil.appendString((Object[])new Object[]{"of '", variableName, "'"});
                    } else {
                        aliasFirstEnum = DVTStringUtil.appendString((Object[])new Object[]{"'", aliasFirstEnum, "'"});
                    }
                    String aliasSecondEnum = ((RfStruct)secondEnum).getAliasName();
                    if (aliasSecondEnum == null) {
                        SDataVariable secondVariable = SDataUtils.getVariable((ISDataAbstract)second);
                        String variableName = SDataUtils.getVariableName((ISDataAbstract)secondVariable, null);
                        aliasSecondEnum = DVTStringUtil.appendString((Object[])new Object[]{"of '", variableName, "'"});
                    } else {
                        aliasSecondEnum = DVTStringUtil.appendString((Object[])new Object[]{"'", aliasSecondEnum, "'"});
                    }
                    Equality.addSemanticProblem(configInfo, 2, operatorInfo, "IMPLICIT_ENUM_CAST: Auto-cast from enum type {0} to enum type {1}", null, aliasFirstEnum, aliasSecondEnum);
                }
            }
            return null;
        }

        public ISDataType internalCheckOperands(ConfigInfo configInfo, boolean triggerError, boolean forceCheckWidth, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid;
            if (operands.size() != 2) {
                return SDataAbstracts.ILLEGAL;
            }
            ISDataType nonValidOperand = this.checkValidOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (nonValidOperand != null) {
                return nonValidOperand;
            }
            ISDataAbstract firstData = operands.get(0);
            ISDataAbstract secondData = operands.get(1);
            ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)firstData);
            ISDataType secondDataType = SDataUtils.getDataType((ISDataAbstract)secondData);
            SDataTypeCategory firstCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)firstData);
            SDataTypeCategory secondCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)secondData);
            if (!permittedOperands.contains(firstCategory) || !permittedOperands.contains(secondCategory)) {
                this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, false, context != null ? context.getElabPathForError() : "");
                return SDataAbstracts.ILLEGAL;
            }
            if (operatorInfo.isMatchingTypes() && firstCategory == secondCategory && firstCategory == SDataTypeCategory.NUMERIC) {
                if (firstDataType.getType() != null && !firstDataType.getType().equals(secondDataType.getType())) {
                    return SDataAbstracts.ILLEGAL;
                }
                if (firstDataType.isSigned() ^ secondDataType.isSigned()) {
                    return SDataAbstracts.ILLEGAL;
                }
            }
            if ((isValid = this.checkIllegal(configInfo, triggerError, operatorInfo, firstData, firstCategory, null, secondData, secondCategory, null, false, context)) != null) {
                return isValid;
            }
            isValid = this.checkIllegal(configInfo, triggerError, operatorInfo, secondData, secondCategory, null, firstData, firstCategory, null, true, context);
            if (isValid != null) {
                return isValid;
            }
            return null;
        }

        protected ISDataType checkIllegal(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, ISDataAbstract firstData, SDataTypeCategory firstCategory, IRfNamedElement firstArrayElement, ISDataAbstract secondData, SDataTypeCategory secondCategory, IRfNamedElement secondArrayElement, boolean reverseOrder, SContext context) {
            ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)firstData);
            ISDataType secondDataType = SDataUtils.getDataType((ISDataAbstract)secondData);
            if (firstDataType.isPacked() && secondDataType.isPacked()) {
                IRfNamedElement iRfNamedElement = firstElement = !operatorInfo.hasOutputDirection() ? SDataUtils.getVariableElement((ISDataAbstract)firstData) : SDataUtils.getVariableElement((ISDataAbstract)secondData);
                if (!(this instanceof Association || Assignment.isArgumentDefaultValueOperator(operatorInfo, firstElement) || this instanceof AssignmentPatternElement)) {
                    return null;
                }
                IRfNamedElement iRfNamedElement2 = secondElement = !operatorInfo.hasOutputDirection() ? SDataUtils.getVariableElement((ISDataAbstract)secondData) : SDataUtils.getVariableElement((ISDataAbstract)firstData);
                if (operatorInfo.isMatchingTypes() || !reverseOrder && firstElement instanceof RfField && ((RfField)firstElement).isRef() && secondElement instanceof RfField) {
                    ISDataType firstCachedBase = firstDataType.getCachedListBaseElementType();
                    ISDataType secondCachedBase = secondDataType.getCachedListBaseElementType();
                    boolean isFirst4State = RfBitVectorScalarType.isFourState(firstCachedBase != null && SDataUtils.getUndefinedDataType((ISDataAbstract)firstCachedBase) == null ? firstCachedBase.getType() : firstDataType.getType());
                    boolean isSecond4State = RfBitVectorScalarType.isFourState(secondCachedBase != null && SDataUtils.getUndefinedDataType((ISDataAbstract)secondCachedBase) == null ? secondCachedBase.getType() : secondDataType.getType());
                    boolean isIllegal = false;
                    if (isFirst4State ^ isSecond4State) {
                        this.addSemanticError(configInfo, triggerError, UndefinedOperatorMessageInfoKind.SIGN_STATE, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "", isFirst4State ? 3 : 2, isFirst4State ? 2 : 3);
                        isIllegal = true;
                    }
                    if (firstDataType.isSigned() ^ secondDataType.isSigned()) {
                        this.addSemanticError(configInfo, triggerError, UndefinedOperatorMessageInfoKind.SIGN_STATE, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "", firstDataType.isSigned() ? 0 : 1, firstDataType.isSigned() ? 1 : 0);
                        isIllegal = true;
                    }
                    if (isIllegal) {
                        return SDataAbstracts.ILLEGAL;
                    }
                }
                return null;
            }
            boolean isFirstIndexArray = firstCategory == SDataTypeCategory.FIXED_SIZE_ARRAY_UNPACKED || firstCategory == SDataTypeCategory.DYNAMIC_ARRAY || firstCategory == SDataTypeCategory.QUEUE;
            boolean bl = isFirstAssociativeArray = firstCategory == SDataTypeCategory.ASSOCIATIVE_ARRAY;
            if (isFirstIndexArray || isFirstAssociativeArray) {
                ISDataType firstListElementDataType = firstDataType.getCachedListBaseElementType();
                if (secondDataType.isPacked()) {
                    if (firstListElementDataType instanceof SDataType && ((SDataType)firstListElementDataType).getPacked() == 2) {
                        return null;
                    }
                    this.addSemanticError(configInfo, triggerError, UndefinedOperatorMessageInfoKind.PACKED_UNPACKED, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "", 1, 0);
                    return SDataAbstracts.ILLEGAL;
                }
                if (firstCategory == SDataTypeCategory.FIXED_SIZE_ARRAY_UNPACKED && secondCategory == SDataTypeCategory.NULL) {
                    this.addSemanticError(configInfo, triggerError, UndefinedOperatorMessageInfoKind.ARRAYS, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "", 2, 2);
                    return SDataAbstracts.ILLEGAL;
                }
                if (firstCategory == SDataTypeCategory.FIXED_SIZE_ARRAY_UNPACKED && secondDataType == STransformer.EMPTY_QUEUE) {
                    this.addSemanticError(configInfo, triggerError, UndefinedOperatorMessageInfoKind.ARRAYS, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "", 2, 2);
                    return SDataAbstracts.ILLEGAL;
                }
                if (firstDataType == STransformer.EMPTY_QUEUE && secondCategory == SDataTypeCategory.FIXED_SIZE_ARRAY_UNPACKED) {
                    this.addSemanticError(configInfo, triggerError, UndefinedOperatorMessageInfoKind.ARRAYS, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "", 2, 2);
                    return SDataAbstracts.ILLEGAL;
                }
                boolean isSecondIndexArray = secondCategory == SDataTypeCategory.FIXED_SIZE_ARRAY_UNPACKED || secondCategory == SDataTypeCategory.DYNAMIC_ARRAY || secondCategory == SDataTypeCategory.QUEUE;
                boolean isSecondAssociativeArray = secondCategory == SDataTypeCategory.ASSOCIATIVE_ARRAY;
                boolean bl2 = isEmptyQueue = firstDataType == STransformer.EMPTY_QUEUE || secondDataType == STransformer.EMPTY_QUEUE;
                if (!isEmptyQueue && !reverseOrder && (isSecondIndexArray || isFirstAssociativeArray && isSecondAssociativeArray)) {
                    if (firstDataType.getNofUnpackedDimensions() != secondDataType.getNofUnpackedDimensions()) {
                        this.addSemanticError(configInfo, triggerError, UndefinedOperatorMessageInfoKind.ARRAYS, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "", 2, 2);
                        return SDataAbstracts.ILLEGAL;
                    }
                    ISDataType secondListElementDataType = secondDataType.getCachedListBaseElementType();
                    firstListElementCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)firstListElementDataType);
                    SDataTypeCategory secondListElementCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)secondListElementDataType);
                    if (firstListElementCategory != SDataTypeCategory.UNKNOWN && secondListElementCategory != SDataTypeCategory.UNKNOWN) {
                        if (firstArrayElement == null) {
                            firstArrayElement = SDataUtils.getVariableElement((ISDataAbstract)firstData);
                        }
                        if (secondArrayElement == null) {
                            secondArrayElement = SDataUtils.getVariableElement((ISDataAbstract)secondData);
                        }
                        if ((isValid = this.checkIllegal(configInfo, false, operatorInfo, (ISDataAbstract)firstListElementDataType, firstListElementCategory, firstArrayElement, (ISDataAbstract)secondListElementDataType, secondListElementCategory, secondArrayElement, false, context)) != null) {
                            this.addSemanticError(configInfo, triggerError, UndefinedOperatorMessageInfoKind.ARRAYS, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "", 3, 3);
                            return isValid;
                        }
                        isValid = this.checkIllegal(configInfo, false, operatorInfo, (ISDataAbstract)secondListElementDataType, secondListElementCategory, secondArrayElement, (ISDataAbstract)firstListElementDataType, firstListElementCategory, firstArrayElement, true, context);
                        if (isValid != null) {
                            this.addSemanticError(configInfo, triggerError, UndefinedOperatorMessageInfoKind.ARRAYS, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "", 3, 3);
                            return isValid;
                        }
                        IRfNamedElement firstType = firstListElementDataType != null ? firstListElementDataType.getType() : null;
                        IRfNamedElement iRfNamedElement = secondType = secondListElementDataType != null ? secondListElementDataType.getType() : null;
                        if (firstType instanceof RfStruct && ((RfStruct)firstType).isEnum() && !firstType.equals(secondType)) {
                            this.addSemanticError(configInfo, triggerError, UndefinedOperatorMessageInfoKind.ARRAYS, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "", 3, 3);
                            return SDataAbstracts.ILLEGAL;
                        }
                        boolean isConnection = this instanceof PortConnection || this instanceof ParameterValue;
                        IRfNamedElement lhOperatorScope = operatorInfo.getScope();
                        IRfNamedElement rhOperatorScope = isConnection && lhOperatorScope instanceof IRfInstanceElement ? (IRfNamedElement)lhOperatorScope.getEnclosingScope() : lhOperatorScope;
                        IHidObject lhHidObject = operatorInfo.getOperator().getLHValue();
                        IHidObject rhHidObject = operatorInfo.getOperator().getFirstRHValue();
                        if (!(context == null || context.getElabContext() == null || rhHidObject instanceof RfHidOperator && (((RfHidOperator)rhHidObject).isConcatOrAssignPatternOperator() || ((RfHidOperator)rhHidObject).isNonStandardAssignmentPattern() || ((RfHidOperator)rhHidObject).isConditionalTernary()))) {
                            ELWidthCheckContext elabContext = context.getElabContext();
                            ElementPath lhPath = elabContext.getFirstPath(true);
                            ElementPath rhPath = elabContext.getFirstPath(false);
                            IHidEvaluationGuardian lhGuardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.TYPE_MATCHING, (IRfNamedElement)lhOperatorScope, (ElementPath)lhPath, (boolean)true, (ELManager)elabContext.getManager());
                            IHidEvaluationGuardian rhGuardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.TYPE_MATCHING, (IRfNamedElement)rhOperatorScope, (ElementPath)rhPath, (boolean)true, (ELManager)elabContext.getManager());
                            IHidEvaluator lhEvaluator = elabContext.getEvaluatorForPortConnections(isConnection);
                            IHidEvaluator rhEvaluator = elabContext.getEvaluatorForPortConnections(false);
                            if (lhHidObject instanceof RfHid || lhHidObject instanceof RfHidAccess) {
                                lhEvaluator = RfTypesResolver.create((IRfScopeElement)(lhOperatorScope instanceof RfInstance && elabContext.getBinding() != null ? elabContext.getBinding() : lhOperatorScope), lhEvaluator.getLastValueContainer(), lhPath, elabContext.getManager(), 0, false);
                            }
                            if (rhHidObject instanceof RfHid || rhHidObject instanceof RfHidAccess) {
                                rhEvaluator = RfTypesResolver.create((IRfScopeElement)rhOperatorScope, rhEvaluator.getLastValueContainer(), rhPath, elabContext.getManager(), 0, false);
                            }
                            boolean isUnknownSize = true;
                            if (isFirstIndexArray && isSecondIndexArray && (firstDataType.hasOnlyFixedSizeDimensions() || !HidUtils.isHid((IHidObject)lhHidObject)) && (secondDataType.hasOnlyFixedSizeDimensions() || !HidUtils.isHid((IHidObject)rhHidObject))) {
                                lhSizeValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluateForSize((IHidObject)lhHidObject, (IHidEvaluator)lhEvaluator, (IRfNamedElement)lhOperatorScope, (IHidEvaluationGuardian)lhGuardian));
                                int lhSize = ELUtils.isUnsuccessfulEval((IELParamValue)lhSizeValue) ? -2 : lhSizeValue.getDVTNumber().getSize();
                                IELParamValue rhSizeValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluateForSize((IHidObject)rhHidObject, (IHidEvaluator)rhEvaluator, (IRfNamedElement)rhOperatorScope, (IHidEvaluationGuardian)rhGuardian));
                                int rhSize = ELUtils.isUnsuccessfulEval((IELParamValue)rhSizeValue) ? -2 : rhSizeValue.getDVTNumber().getSize();
                                boolean bl3 = isUnknownSize = DVTNumber.isUnknownSize((int)lhSize) || DVTNumber.isUnknownSize((int)rhSize);
                                if (lhSize != rhSize && !isUnknownSize) {
                                    this.addSemanticError(configInfo, triggerError, UndefinedOperatorMessageInfoKind.ARRAYS, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "", 0, 0);
                                    return SDataAbstracts.ILLEGAL;
                                }
                            }
                            if (isUnknownSize) {
                                IHidObject iHidObject = lhHidObject;
                                if (iHidObject instanceof RfHid && (lhSizeValue = (RfHid)iHidObject) == (RfHid)iHidObject && ( instanceOfPatternExpressionValue = hid.getParentAccess()) instanceof RfHidAccess && (lhSize = (RfHidAccess) instanceOfPatternExpressionValue) == (RfHidAccess) instanceOfPatternExpressionValue) {
                                    ((RfTypesResolver)lhEvaluator).update((RfHidAccess)access, null);
                                } else {
                                    if (lhHidObject instanceof RfHidAccess var43_60) {
                                        ((RfTypesResolver)lhEvaluator).update((RfHidAccess)access, null);
                                    }
                                }
                                if (rhHidObject instanceof RfHid var45_62 && ( instanceOfPatternExpressionValue = hid.getParentAccess()) instanceof RfHidAccess && (var46_64 = (RfHidAccess) instanceOfPatternExpressionValue) == (RfHidAccess) instanceOfPatternExpressionValue) {
                                    ((RfTypesResolver)rhEvaluator).update((RfHidAccess)access, null);
                                } else {
                                    if (rhHidObject instanceof RfHidAccess var49_66) {
                                        ((RfTypesResolver)rhEvaluator).update((RfHidAccess)access, null);
                                    }
                                }
                                DataType firstNoUnpackedDimensionDataType = (DataType)firstDataType.getCachedListNoUnpackedDimensionDataType();
                                DataType secondNoUnpackedDimensionDataType = (DataType)secondDataType.getCachedListNoUnpackedDimensionDataType();
                                DataType lhNoUnpackedDimensionDataType = operatorInfo.hasOutputDirection() ? secondNoUnpackedDimensionDataType : firstNoUnpackedDimensionDataType;
                                DataType rhNoUnpackedDimensionDataType = operatorInfo.hasOutputDirection() ? firstNoUnpackedDimensionDataType : secondNoUnpackedDimensionDataType;
                                BitVectorContext lhBitVectorContext = lhNoUnpackedDimensionDataType.getBitVectorContext(lhEvaluator, lhGuardian, lhOperatorScope);
                                int lhSize = lhBitVectorContext != null ? lhBitVectorContext.getSize() : -2;
                                BitVectorContext rhBitVectorContext = rhNoUnpackedDimensionDataType.getBitVectorContext(rhEvaluator, rhGuardian, rhOperatorScope);
                                int rhSize = rhBitVectorContext != null ? rhBitVectorContext.getSize() : -2;
                                boolean bl4 = isUnknownSize = DVTNumber.isUnknownSize((int)lhSize) || DVTNumber.isUnknownSize((int)rhSize);
                                if (lhSize != rhSize && !isUnknownSize) {
                                    this.addSemanticError(configInfo, triggerError, UndefinedOperatorMessageInfoKind.ARRAYS, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "", 1, 1);
                                    return SDataAbstracts.ILLEGAL;
                                }
                            }
                        }
                        if (firstListElementDataType != null && secondListElementDataType != null) {
                            boolean isIllegal = false;
                            if (this instanceof Association && SDataUtils.getUndefinedDataType((ISDataAbstract)firstListElementDataType) == null && SDataUtils.getUndefinedDataType((ISDataAbstract)secondListElementDataType) == null) {
                                IRfNamedElement firstElement = !operatorInfo.hasOutputDirection() ? SDataUtils.getVariableElement((ISDataAbstract)firstData) : SDataUtils.getVariableElement((ISDataAbstract)secondData);
                                IRfNamedElement iRfNamedElement3 = secondElement = !operatorInfo.hasOutputDirection() ? SDataUtils.getVariableElement((ISDataAbstract)secondData) : SDataUtils.getVariableElement((ISDataAbstract)firstData);
                                if (firstElement instanceof RfField && ((RfField)firstElement).isRef() && secondElement instanceof RfField && (isFirst4State = RfBitVectorScalarType.isFourState(firstListElementDataType.getType())) ^ (isSecond4State = RfBitVectorScalarType.isFourState(secondListElementDataType.getType()))) {
                                    this.addSemanticError(configInfo, triggerError, UndefinedOperatorMessageInfoKind.ARRAYS, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "", 5, 5);
                                    isIllegal = true;
                                }
                            }
                            if (firstListElementDataType.isSigned() ^ secondListElementDataType.isSigned()) {
                                this.addSemanticError(configInfo, triggerError, UndefinedOperatorMessageInfoKind.ARRAYS, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "", 4, 4);
                                isIllegal = true;
                            }
                            if (isIllegal) {
                                return SDataAbstracts.ILLEGAL;
                            }
                        }
                    }
                }
                IRfNamedElement iRfNamedElement = firstElement = !operatorInfo.hasOutputDirection() ? SDataUtils.getVariableElement((ISDataAbstract)firstData) : SDataUtils.getVariableElement((ISDataAbstract)secondData);
                if (!reverseOrder && (isSecondIndexArray || isSecondAssociativeArray) && firstCategory != secondCategory && (this instanceof Association || Assignment.isArgumentDefaultValueOperator(operatorInfo, firstElement))) {
                    IRfNamedElement iRfNamedElement4 = secondElement = !operatorInfo.hasOutputDirection() ? SDataUtils.getVariableElement((ISDataAbstract)secondData) : SDataUtils.getVariableElement((ISDataAbstract)firstData);
                    if (firstElement instanceof RfField && ((RfField)firstElement).isRef() && secondElement instanceof RfField) {
                        this.addSemanticError(configInfo, triggerError, UndefinedOperatorMessageInfoKind.ARRAYS, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "", 0, 0);
                        return SDataAbstracts.ILLEGAL;
                    }
                }
                if (!reverseOrder && secondCategory == SDataTypeCategory.MODPORT) {
                    if (firstArrayElement == null) {
                        firstArrayElement = SDataUtils.getVariableElement((ISDataAbstract)firstData);
                    }
                    if ((isValid = this.checkIllegal(configInfo, false, operatorInfo, (ISDataAbstract)firstListElementDataType, firstListElementCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)firstListElementDataType), firstArrayElement, secondData, secondCategory, null, false, context)) != null) {
                        this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "");
                        return isValid;
                    }
                    return null;
                }
            }
            if (!(reverseOrder || firstCategory != SDataTypeCategory.MODPORT && firstCategory != SDataTypeCategory.INTERFACE || secondCategory != SDataTypeCategory.MODPORT && secondCategory != SDataTypeCategory.INTERFACE)) {
                IRfNamedElement firstType = firstDataType.getType();
                String string = firstName = firstCategory == SDataTypeCategory.MODPORT ? firstType.getNameAndEnclosing() : firstDataType.getName(configInfo.isSemanticShowAliasName());
                if (firstType instanceof RfVirtualModport) {
                    firstType = ((RfVirtualModport)firstType).getOrigin();
                }
                if (firstType instanceof RfSpecializedVirtualInterface) {
                    firstType = ((RfSpecializedVirtualInterface)firstType).getGenericElement();
                }
                IRfNamedElement secondType = secondDataType.getType();
                String string2 = secondName = secondCategory == SDataTypeCategory.MODPORT ? secondType.getNameAndEnclosing() : secondDataType.getName(configInfo.isSemanticShowAliasName());
                if (secondType instanceof RfVirtualModport) {
                    secondType = ((RfVirtualModport)secondType).getOrigin();
                }
                if (secondType instanceof RfSpecializedVirtualInterface) {
                    secondType = ((RfSpecializedVirtualInterface)secondType).getGenericElement();
                }
                if (firstCategory != secondCategory) {
                    if (firstCategory == SDataTypeCategory.MODPORT) {
                        firstType = ((RfModport)firstType).getEnclosingScope();
                    } else {
                        secondType = ((RfModport)secondType).getEnclosingScope();
                    }
                }
                if ((firstCandidate = SDataUtils.getVariableElement((ISDataAbstract)firstData)) == null && firstArrayElement != null) {
                    firstCandidate = firstArrayElement;
                }
                if ((secondCandidate = SDataUtils.getVariableElement((ISDataAbstract)secondData)) == null && secondArrayElement != null) {
                    secondCandidate = secondArrayElement;
                }
                if (firstCandidate instanceof IRfFieldElement && !(firstCandidate instanceof IRfInstanceElement) || secondCandidate instanceof IRfFieldElement && !(secondCandidate instanceof IRfInstanceElement)) {
                    firstType = firstType instanceof RfModport ? ((RfModport)firstType).getEnclosingScope() : firstType;
                    secondType = secondType instanceof RfModport ? ((RfModport)secondType).getEnclosingScope() : secondType;
                    isEqual = firstType.getName().equals(secondType.getName());
                } else {
                    isEqual = firstType.equals(secondType);
                }
                if (!isEqual) {
                    String firstVariableName = SDataUtils.getVariableName((ISDataAbstract)firstData, null);
                    String elabPath = context != null ? context.getElabPathForError() : "";
                    Equality.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_ASSIGNMENT: Illegal assignment of ''{0}'' to {1} ''{2}'' of type ''{3}''", this.getAttributesForElabPaths(elabPath), secondName, "argument", firstVariableName, firstName);
                    return SDataAbstracts.ILLEGAL;
                }
                return null;
            }
            if (firstCategory == secondCategory) {
                if (!(reverseOrder || firstCategory != SDataTypeCategory.STRUCT_UNPACKED && firstCategory != SDataTypeCategory.UNION_UNPACKED || firstDataType.getType().equals(secondDataType.getType()))) {
                    this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "");
                    return SDataAbstracts.ILLEGAL;
                }
                return null;
            }
            if (firstCategory == SDataTypeCategory.ASSOCIATIVE_ARRAY && secondCategory != SDataTypeCategory.ASSOCIATIVE_ARRAY) {
                this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "");
                return SDataAbstracts.ILLEGAL;
            }
            if (firstCategory == SDataTypeCategory.DYNAMIC_ARRAY && secondCategory != SDataTypeCategory.NEW && secondCategory != SDataTypeCategory.QUEUE && secondCategory != SDataTypeCategory.FIXED_SIZE_ARRAY_UNPACKED) {
                if (secondCategory == SDataTypeCategory.NULL) {
                    if (triggerError) {
                        Equality.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_DYNAMIC_ARRAY_NULL_OPERATION, null, operatorInfo.getOperator().getOperatorText(), firstDataType.getName(configInfo.isSemanticShowAliasName()));
                    }
                    return SDataAbstracts.NON_STANDARD;
                }
                this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "");
                return SDataAbstracts.ILLEGAL;
            }
            if (secondCategory == SDataTypeCategory.DYNAMIC_ARRAY && reverseOrder) {
                return null;
            }
            if ((firstCategory == SDataTypeCategory.NUMERIC || firstCategory == SDataTypeCategory.REAL || firstCategory == SDataTypeCategory.SHORTREAL) && secondCategory == SDataTypeCategory.NULL) {
                if (triggerError && this instanceof AssignmentPatternElement) {
                    switch (operatorInfo.getAssignmentPatternElementCheckKind()) {
                        case KEY: {
                            Equality.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_NUMERIC_NULL_OPERATION_IN_ASSOC, null, "key", firstDataType.getName(configInfo.isSemanticShowAliasName()));
                            break;
                        }
                        case VALUE: {
                            Equality.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_NUMERIC_NULL_OPERATION_IN_ASSOC, null, "value", firstDataType.getName(configInfo.isSemanticShowAliasName()));
                            break;
                        }
                        default: {
                            Equality.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_NUMERIC_NULL_OPERATION, null, operatorInfo.getOperator().getOperatorText(), firstDataType.getName(configInfo.isSemanticShowAliasName()));
                            break;
                        }
                    }
                } else if (triggerError) {
                    Equality.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_NUMERIC_NULL_OPERATION, null, operatorInfo.getOperator().getOperatorText(), firstDataType.getName(configInfo.isSemanticShowAliasName()));
                }
                return SDataAbstracts.NON_STANDARD;
            }
            if (firstCategory == SDataTypeCategory.NUMERIC && secondCategory == SDataTypeCategory.STRING) {
                if (triggerError && this instanceof AssignmentPatternElement) {
                    switch (operatorInfo.getAssignmentPatternElementCheckKind()) {
                        case KEY: {
                            Equality.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_STRING_OPERATION, null, "key", secondDataType, context != null ? context.getElabPathForError() : "");
                            break;
                        }
                        case VALUE: {
                            Equality.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_STRING_OPERATION, null, "value", secondDataType, context != null ? context.getElabPathForError() : "");
                            break;
                        }
                        default: {
                            Equality.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_STRING_OPERATION, null, String.valueOf(reverseOrder ? "second" : "first") + " operand", firstDataType, context != null ? context.getElabPathForError() : "");
                            break;
                        }
                    }
                } else if (triggerError) {
                    Equality.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_STRING_OPERATION, null, String.valueOf(reverseOrder ? "second" : "first") + " operand", firstDataType, context != null ? context.getElabPathForError() : "");
                }
                return SDataAbstracts.NON_STANDARD;
            }
            if (firstCategory == SDataTypeCategory.NUMERIC && secondCategory != SDataTypeCategory.SHORTREAL && secondCategory != SDataTypeCategory.ENUM && secondCategory != SDataTypeCategory.REAL && secondCategory != SDataTypeCategory.EVENT && secondCategory != SDataTypeCategory.LITERAL_STRING && secondCategory != SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED && secondCategory != SDataTypeCategory.UNION_PACKED && secondCategory != SDataTypeCategory.STRUCT_PACKED) {
                this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "");
                return SDataAbstracts.ILLEGAL;
            }
            if (firstCategory == SDataTypeCategory.ENUM && secondCategory != SDataTypeCategory.NUMERIC && secondCategory != SDataTypeCategory.SHORTREAL && secondCategory != SDataTypeCategory.REAL && secondCategory != SDataTypeCategory.LITERAL_STRING && secondCategory != SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED && secondCategory != SDataTypeCategory.UNION_PACKED && secondCategory != SDataTypeCategory.STRUCT_PACKED && secondCategory != SDataTypeCategory.NULL) {
                if (secondCategory == SDataTypeCategory.STRING && context != null && !(context.contextOperation instanceof Assignment)) {
                    if (triggerError && this instanceof AssignmentPatternElement) {
                        switch (operatorInfo.getAssignmentPatternElementCheckKind()) {
                            case KEY: {
                                Equality.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_STRING_OPERATION, null, "association key", secondDataType, context != null ? context.getElabPathForError() : "");
                                break;
                            }
                            case VALUE: {
                                Equality.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_STRING_OPERATION, null, "association value", secondDataType, context != null ? context.getElabPathForError() : "");
                                break;
                            }
                            default: {
                                Equality.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_STRING_OPERATION, null, "first operand", firstDataType, context != null ? context.getElabPathForError() : "");
                                break;
                            }
                        }
                    } else if (triggerError) {
                        Equality.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_STRING_OPERATION, null, "first operand", firstDataType, context != null ? context.getElabPathForError() : "");
                    }
                    return SDataAbstracts.NON_STANDARD;
                }
                this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "");
                return SDataAbstracts.ILLEGAL;
            }
            if (firstCategory == SDataTypeCategory.REAL && secondCategory != SDataTypeCategory.NUMERIC && secondCategory != SDataTypeCategory.SHORTREAL && secondCategory != SDataTypeCategory.ENUM && secondCategory != SDataTypeCategory.LITERAL_STRING && secondCategory != SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED && secondCategory != SDataTypeCategory.UNION_PACKED && secondCategory != SDataTypeCategory.STRUCT_PACKED) {
                this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "");
                return SDataAbstracts.ILLEGAL;
            }
            if (firstCategory == SDataTypeCategory.SHORTREAL && secondCategory != SDataTypeCategory.NUMERIC && secondCategory != SDataTypeCategory.REAL && secondCategory != SDataTypeCategory.ENUM && secondCategory != SDataTypeCategory.LITERAL_STRING && secondCategory != SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED && secondCategory != SDataTypeCategory.UNION_PACKED && secondCategory != SDataTypeCategory.STRUCT_PACKED) {
                this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "");
                return SDataAbstracts.ILLEGAL;
            }
            if (firstCategory == SDataTypeCategory.EVENT && secondCategory != SDataTypeCategory.NULL && secondCategory != SDataTypeCategory.NUMERIC) {
                this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "");
                return SDataAbstracts.ILLEGAL;
            }
            if (firstCategory == SDataTypeCategory.COVERGROUP && secondCategory != SDataTypeCategory.NEW && secondCategory != SDataTypeCategory.NULL) {
                this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "");
                return SDataAbstracts.ILLEGAL;
            }
            if (firstCategory == SDataTypeCategory.CLASS && secondCategory != SDataTypeCategory.NULL && secondCategory != SDataTypeCategory.NEW) {
                this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "");
                return SDataAbstracts.ILLEGAL;
            }
            if (firstCategory == SDataTypeCategory.CHANDLE && secondCategory != SDataTypeCategory.NULL) {
                this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "");
                return SDataAbstracts.ILLEGAL;
            }
            if (firstCategory == SDataTypeCategory.STRING && (secondCategory == SDataTypeCategory.NUMERIC || secondCategory == SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED || secondCategory == SDataTypeCategory.ENUM)) {
                if (triggerError && this instanceof AssignmentPatternElement) {
                    switch (operatorInfo.getAssignmentPatternElementCheckKind()) {
                        case KEY: {
                            Equality.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_STRING_OPERATION, null, "association key", secondDataType, context != null ? context.getElabPathForError() : "");
                            break;
                        }
                        case VALUE: {
                            Equality.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_STRING_OPERATION, null, "association value", secondDataType, context != null ? context.getElabPathForError() : "");
                            break;
                        }
                        default: {
                            Equality.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_STRING_OPERATION, null, String.valueOf(reverseOrder ? "first" : "second") + " operand", secondDataType, context != null ? context.getElabPathForError() : "");
                            break;
                        }
                    }
                } else if (triggerError) {
                    Equality.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_STRING_OPERATION, null, String.valueOf(reverseOrder ? "first" : "second") + " operand", secondDataType, context != null ? context.getElabPathForError() : "");
                }
                return SDataAbstracts.NON_STANDARD;
            }
            if (firstCategory == SDataTypeCategory.STRING && secondCategory == SDataTypeCategory.QUEUE && STransformer.EMPTY_QUEUE == secondDataType) {
                if (context != null && context.contextOperation == RETURN_INSTANCE) {
                    if (triggerError) {
                        Equality.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_EMPTY_QUEUE_STRING_RETURN, null, new Object[0]);
                    }
                    return SDataAbstracts.NON_STANDARD;
                }
                if (this instanceof Assignment) {
                    if (triggerError) {
                        IRfNamedElement firstElement = !operatorInfo.hasOutputDirection() ? SDataUtils.getVariableElement((ISDataAbstract)firstData) : SDataUtils.getVariableElement((ISDataAbstract)secondData);
                        Equality.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_EMPTY_QUEUE_STRING_ASSIGNMENT, null, firstElement.getName());
                    }
                    return SDataAbstracts.NON_STANDARD;
                }
            }
            if (firstCategory == SDataTypeCategory.STRING && secondCategory == SDataTypeCategory.LITERAL_STRING && operatorInfo.getOperator() != null && operatorInfo.getOperator().getOperatorType() == 484) {
                if (triggerError) {
                    Equality.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_STRING_OPERATION, null, String.valueOf(reverseOrder ? "first" : "second") + " operand", secondDataType, context != null ? context.getElabPathForError() : "");
                }
                return SDataAbstracts.NON_STANDARD;
            }
            if (firstCategory == SDataTypeCategory.STRING && secondCategory != SDataTypeCategory.LITERAL_STRING && secondCategory != SDataTypeCategory.NULL) {
                this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "");
                return SDataAbstracts.ILLEGAL;
            }
            if (firstCategory == SDataTypeCategory.STRUCT_UNPACKED && secondCategory != SDataTypeCategory.STRUCT_UNPACKED) {
                if (secondCategory == SDataTypeCategory.STRUCT_PACKED && secondDataType instanceof SDataType && ((SDataType)secondDataType).getPacked() == 2) {
                    if (!firstDataType.getType().equals(secondDataType.getType())) {
                        this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "");
                        return SDataAbstracts.ILLEGAL;
                    }
                    return null;
                }
                this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "");
                return SDataAbstracts.ILLEGAL;
            }
            if (firstCategory == SDataTypeCategory.UNION_UNPACKED && secondCategory != SDataTypeCategory.UNION_UNPACKED) {
                if (secondCategory == SDataTypeCategory.UNION_PACKED && secondDataType instanceof SDataType && ((SDataType)secondDataType).getPacked() == 2) {
                    if (!firstDataType.getType().equals(secondDataType.getType())) {
                        this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "");
                        return SDataAbstracts.ILLEGAL;
                    }
                    return null;
                }
                this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "");
                return SDataAbstracts.ILLEGAL;
            }
            if (firstCategory == SDataTypeCategory.INTERFACE && secondCategory != SDataTypeCategory.NULL && secondCategory != SDataTypeCategory.GENERIC_INTERFACE && secondCategory != SDataTypeCategory.MODPORT) {
                this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "");
                return SDataAbstracts.ILLEGAL;
            }
            if (firstCategory == SDataTypeCategory.GENERIC_INTERFACE && secondCategory != SDataTypeCategory.INTERFACE && secondCategory != SDataTypeCategory.MODPORT && secondCategory != SDataTypeCategory.NULL) {
                this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "");
                return SDataAbstracts.ILLEGAL;
            }
            if (firstCategory == SDataTypeCategory.QUEUE && secondCategory != SDataTypeCategory.QUEUE && secondCategory != SDataTypeCategory.DYNAMIC_ARRAY && secondCategory != SDataTypeCategory.FIXED_SIZE_ARRAY_UNPACKED) {
                this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "");
                return SDataAbstracts.ILLEGAL;
            }
            if (firstCategory == SDataTypeCategory.EVENT && secondCategory != SDataTypeCategory.NULL && secondCategory != SDataTypeCategory.EVENT) {
                this.addSemanticError(configInfo, triggerError, operatorInfo, firstData, firstDataType, secondData, secondDataType, reverseOrder, context != null ? context.getElabPathForError() : "");
                return SDataAbstracts.ILLEGAL;
            }
            return null;
        }

        protected String getUndefinedOperatorErrorMessage(UndefinedOperatorMessageInfoKind kind) {
            switch (kind) {
                case ARRAYS: {
                    return "UNDEFINED_OPERATOR: Operator ''{0}'' is undefined for argument types ''{1}'', ''{2}'' (arrays have incompatible {3,choice,0#dimensions|1#packed dimensions|2#unpacked dimensions|3#element types|4#element type signing|5#2-state/4-state element types})";
                }
            }
            return "UNDEFINED_OPERATOR: Operator ''{0}'' is undefined for argument types ''{1}'', ''{2}''";
        }

        protected void addSemanticError(ConfigInfo configInfo, boolean triggerError, UndefinedOperatorMessageInfoKind infoKind, OperatorInfo operatorInfo, ISDataAbstract firstAbstract, ISDataType first, ISDataAbstract secondAbstract, ISDataType second, boolean reverseOrder, String elabPath, int firstDetailsChoice, int secondDetailsChoice) {
            ISDataType firstDataType = reverseOrder ? second : first;
            ISDataType secondDataType = reverseOrder ? first : second;
            String message = this.getUndefinedOperatorErrorMessage(infoKind);
            int detailsChoice = reverseOrder ? secondDetailsChoice : firstDetailsChoice;
            Equality.addSemanticError(configInfo, triggerError, operatorInfo, message, this.getAttributesForElabPaths(elabPath), operatorInfo.getOperator().getOperatorText(), firstDataType.getName(configInfo.isSemanticShowAliasName()), secondDataType.getName(configInfo.isSemanticShowAliasName()), detailsChoice);
        }

        protected void addSemanticError(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, ISDataAbstract firstAbstract, ISDataType first, ISDataAbstract secondAbstract, ISDataType second, boolean reverseOrder, String elabPath) {
            ISDataType firstDataType = reverseOrder ? second : first;
            ISDataType secondDataType = reverseOrder ? first : second;
            String message = this.getUndefinedOperatorErrorMessage(UndefinedOperatorMessageInfoKind.NO_EXTRA_INFO);
            Equality.addSemanticError(configInfo, triggerError, operatorInfo, message, this.getAttributesForElabPaths(elabPath), operatorInfo.getOperator().getOperatorText(), firstDataType.getName(configInfo.isSemanticShowAliasName()), secondDataType.getName(configInfo.isSemanticShowAliasName()));
        }

        protected void addSemanticWarning(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, ISDataAbstract firstAbstract, ISDataType first, ISDataAbstract secondAbstract, ISDataType second, boolean reverseOrder, String elabPath) {
            ISDataType firstDataType = reverseOrder ? second : first;
            ISDataType secondDataType = reverseOrder ? first : second;
            String message = this.getUndefinedOperatorErrorMessage(UndefinedOperatorMessageInfoKind.NO_EXTRA_INFO);
            Equality.addSemanticWarning(configInfo, triggerError, operatorInfo, message, this.getAttributesForElabPaths(elabPath), operatorInfo.getOperator().getOperatorText(), firstDataType.getName(configInfo.isSemanticShowAliasName()), secondDataType.getName(configInfo.isSemanticShowAliasName()));
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            return STransformer.LOGIC_VARIABLE;
        }

        protected static enum UndefinedOperatorMessageInfoKind {
            NO_EXTRA_INFO,
            PACKED_UNPACKED,
            SIGN_STATE,
            ARRAYS,
            CLASSES;

        }
    }

    private static class EventControl
    extends SOperation {
        private EventControl() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkValidOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            if (operatorInfo.getOperator() == null) {
                return null;
            }
            return CLOCK_OPERATIONS_INSTANCE.checkEventTypes(configInfo, triggerError, operatorInfo, operands, Arrays.asList(operatorInfo.getOperator().getLHValue()));
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            return STransformer.EVENT_VARIABLE;
        }
    }

    private static class EventTrigger
    extends SOperation {
        private EventTrigger() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            if (operands.size() != 1) {
                return SDataAbstracts.ILLEGAL;
            }
            ISDataType nonValidOperand = this.checkValidOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (nonValidOperand != null) {
                return nonValidOperand;
            }
            ISDataAbstract firstData = operands.get(0);
            ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)firstData);
            if (SDataAbstracts.getOperandCategory((ISDataAbstract)firstData) != SDataTypeCategory.EVENT) {
                EventTrigger.addSemanticError(configInfo, triggerError, operatorInfo, "UNDEFINED_OPERATOR: Operator ''{0}'' is undefined for argument type ''{1}''", null, operatorInfo.getOperator().getOperatorText(), firstDataType.getName(configInfo.isSemanticShowAliasName()));
                return SDataAbstracts.ILLEGAL;
            }
            return null;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            return SDataVariable.of((ISDataType)SDataUtils.getDataType((ISDataAbstract)operands.get(0)), (boolean)false);
        }
    }

    private static class Inside
    extends SOperation {
        private Inside() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.isUnsupportedTypeParameter(operands);
            if (isValid != null) {
                return isValid;
            }
            if (operands.size() != 2) {
                return SDataAbstracts.ILLEGAL;
            }
            ISDataAbstract first = operands.get(0);
            if (!(first instanceof SDataVariable)) {
                Inside.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_TYPE_REFERENCE: ''{0}'' cannot be resolved to a variable", null, SDataUtils.getDataType((ISDataAbstract)first));
                return SDataAbstracts.ILLEGAL;
            }
            ISDataAbstract second = operands.get(1);
            if (second != STransformer.SET_VARIABLE) {
                return SDataAbstracts.ILLEGAL;
            }
            return null;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType nonValidOperand = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (nonValidOperand != null) {
                return nonValidOperand;
            }
            return STransformer.LOGIC_VARIABLE;
        }
    }

    private static class InsideSet
    extends SOperation {
        private InsideSet() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkValidOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            if (context == null) {
                return SDataAbstracts.UNDEFINED;
            }
            isValid = SOperation.acceptOperandsNature(configInfo, triggerError, operatorInfo, Collections.singletonList(context.getContextDataType()));
            if (isValid != null) {
                return isValid;
            }
            ISDataType contextDataType = SDataUtils.getDataType((ISDataAbstract)context.getContextDataType());
            SDataVariable variable = SDataVariable.of((ISDataType)contextDataType, (boolean)false);
            for (ISDataAbstract operand : operands) {
                ArrayList<ISDataAbstract> newOperands = new ArrayList<ISDataAbstract>(2);
                newOperands.add((ISDataAbstract)variable);
                ISDataType operandDataType = SDataUtils.getDataType((ISDataAbstract)operand);
                if (operandDataType.getNofUnpackedDimensions() != 0) {
                    operandDataType = operandDataType.getCachedListBaseElementType();
                }
                newOperands.add((ISDataAbstract)SDataVariable.of((ISDataType)operandDataType, (boolean)false));
                ISDataType resultCheck = EQUALITY_INSTANCE.internalCheckOperands(configInfo, false, false, operatorInfo, newOperands, null);
                if (!SDataUtils.isIllegalDataType((ISDataAbstract)resultCheck)) continue;
                ListContainer rhValues = operatorInfo.getOperator().getRHValues();
                String rhSideVariableName = SDataUtils.getVariableName((ISDataAbstract)operand, rhValues != null && !rhValues.isEmpty() ? (IHidObject)rhValues.get(0) : null);
                if (rhSideVariableName.equals("unknown")) {
                    InsideSet.addSemanticError(configInfo, triggerError, operatorInfo, "UNDEFINED_OPERATOR: Set member of type ''{0}'' is incompatible with left-hand side expression type ''{1}''", null, operandDataType.getName(configInfo.isSemanticShowAliasName()), contextDataType.getName(configInfo.isSemanticShowAliasName()));
                    continue;
                }
                InsideSet.addSemanticError(configInfo, triggerError, operatorInfo, "UNDEFINED_OPERATOR: Set member ''{0}'' of type ''{1}'' is incompatible with left-hand side expression type ''{2}''", null, rhSideVariableName, operandDataType.getName(configInfo.isSemanticShowAliasName()), contextDataType.getName(configInfo.isSemanticShowAliasName()));
            }
            return null;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType nonValidOperand = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (nonValidOperand != null) {
                return nonValidOperand;
            }
            return STransformer.SET_VARIABLE;
        }
    }

    private static class Logical
    extends SOperation {
        private final EnumSet<SDataTypeCategory> permittedOperands = EnumSet.of(SDataTypeCategory.NUMERIC, new SDataTypeCategory[]{SDataTypeCategory.SHORTREAL, SDataTypeCategory.REAL, SDataTypeCategory.LITERAL_STRING, SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED, SDataTypeCategory.STRUCT_PACKED, SDataTypeCategory.UNION_PACKED, SDataTypeCategory.ENUM});

        private Logical() {
        }

        public EnumSet<SDataTypeCategory> getPermittedOperands() {
            return this.permittedOperands;
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            int size = operands.size();
            if (1 > size || size > 2) {
                return SDataAbstracts.ILLEGAL;
            }
            ISDataType nonValidOperand = this.checkValidOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (nonValidOperand != null) {
                return nonValidOperand;
            }
            ISDataAbstract first = operands.get(0);
            ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)first);
            SDataTypeCategory firstCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)first);
            RfHidOperator operator = (RfHidOperator)operatorInfo.getOperator();
            EnumSet<SDataTypeCategory> permitted = this.getPermittedOperands();
            if (size == 1) {
                if (!permitted.contains(firstCategory)) {
                    boolean isNonStandardNullCheck;
                    boolean bl = isNonStandardNullCheck = operator.isLogical() && (SDataTypeCategory.INTERFACE == firstCategory || SDataTypeCategory.MODPORT == firstCategory || SDataTypeCategory.CLASS == firstCategory || SDataTypeCategory.NULL == firstCategory);
                    if (isNonStandardNullCheck) {
                        if (triggerError) {
                            Logical.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_LOGICAL_NEGATION, null, operator.getOperatorText(), firstDataType.getName(configInfo.isSemanticShowAliasName()));
                        }
                        return SDataAbstracts.NON_STANDARD;
                    }
                    Logical.addSemanticError(configInfo, triggerError, operatorInfo, "UNDEFINED_OPERATOR: Operator ''{0}'' is undefined for argument type ''{1}''", null, operator.getOperatorText(), firstDataType.getName(configInfo.isSemanticShowAliasName()));
                    return SDataAbstracts.ILLEGAL;
                }
            } else {
                boolean isNonStandardNullCheck;
                boolean isEnumAssign;
                ISDataAbstract second = operands.get(1);
                SDataTypeCategory secondCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)second);
                ISDataType secondDataType = SDataUtils.getDataType((ISDataAbstract)second);
                ISDataType nonStandardResult = null;
                boolean bl = isEnumAssign = operator.isLogicalAssignment() && firstDataType instanceof SDataType && ((SDataType)firstDataType).isEnum();
                if (isEnumAssign) {
                    SDataVariable firstVariable = SDataUtils.getVariable((ISDataAbstract)first);
                    if (triggerError && firstVariable != null) {
                        Logical.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_ENUM_ASSIGNMENT, null, secondDataType, firstVariable.getVariableName(), firstDataType);
                    }
                    return SDataAbstracts.NON_STANDARD;
                }
                if (!permitted.contains(firstCategory)) {
                    boolean bl2 = isNonStandardNullCheck = operator.isLogical() && (SDataTypeCategory.INTERFACE == firstCategory || SDataTypeCategory.MODPORT == firstCategory || SDataTypeCategory.CLASS == firstCategory || SDataTypeCategory.NULL == firstCategory);
                    if (isNonStandardNullCheck) {
                        if (triggerError) {
                            Logical.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_BINARY_LOGICAL_OPERATOR, null, operator.getOperatorText(), firstDataType.getName(configInfo.isSemanticShowAliasName()));
                        }
                        nonStandardResult = SDataAbstracts.NON_STANDARD;
                    } else {
                        Logical.addSemanticError(configInfo, triggerError, operatorInfo, "UNDEFINED_OPERATOR: Operator ''{0}'' is undefined for argument types ''{1}'', ''{2}''", null, operator.getOperatorText(), firstDataType.getName(configInfo.isSemanticShowAliasName()), secondDataType.getName(configInfo.isSemanticShowAliasName()));
                        return SDataAbstracts.ILLEGAL;
                    }
                }
                if (!permitted.contains(secondCategory)) {
                    boolean bl3 = isNonStandardNullCheck = operator.isLogical() && (SDataTypeCategory.INTERFACE == secondCategory || SDataTypeCategory.MODPORT == firstCategory || SDataTypeCategory.CLASS == secondCategory || SDataTypeCategory.NULL == secondCategory);
                    if (isNonStandardNullCheck) {
                        if (triggerError) {
                            Logical.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_BINARY_LOGICAL_OPERATOR, null, operator.getOperatorText(), secondDataType.getName(configInfo.isSemanticShowAliasName()));
                        }
                        return SDataAbstracts.NON_STANDARD;
                    }
                    Logical.addSemanticError(configInfo, triggerError, operatorInfo, "UNDEFINED_OPERATOR: Operator ''{0}'' is undefined for argument types ''{1}'', ''{2}''", null, operator.getOperatorText(), firstDataType.getName(configInfo.isSemanticShowAliasName()), secondDataType.getName(configInfo.isSemanticShowAliasName()));
                    return SDataAbstracts.ILLEGAL;
                }
                return nonStandardResult;
            }
            return null;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            return STransformer.LOGIC_VARIABLE;
        }
    }

    private static class Modulo
    extends SOperation {
        public static final EnumSet<SDataTypeCategory> permittedOperands = EnumSet.of(SDataTypeCategory.NUMERIC, new SDataTypeCategory[]{SDataTypeCategory.SHORTREAL, SDataTypeCategory.LITERAL_STRING, SDataTypeCategory.ENUM, SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED, SDataTypeCategory.STRUCT_PACKED, SDataTypeCategory.UNION_PACKED});

        private Modulo() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            boolean isEnumAssign;
            if (operands.size() != 2) {
                return SDataAbstracts.ILLEGAL;
            }
            ISDataType nonValidOperand = this.checkValidOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (nonValidOperand != null) {
                return nonValidOperand;
            }
            ISDataAbstract first = operands.get(0);
            ISDataAbstract second = operands.get(1);
            ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)first);
            ISDataType secondDataType = SDataUtils.getDataType((ISDataAbstract)second);
            SDataTypeCategory firstCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)first);
            SDataTypeCategory secondCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)second);
            boolean bl = isEnumAssign = ((IRfHidOperatorLayer)operatorInfo.getOperator()).isModuloAssignment() && firstDataType instanceof SDataType && ((SDataType)firstDataType).isEnum();
            if (isEnumAssign) {
                SDataVariable firstVariable = SDataUtils.getVariable((ISDataAbstract)first);
                if (triggerError && firstVariable != null) {
                    Modulo.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_ENUM_ASSIGNMENT, null, secondDataType, firstVariable.getVariableName(), firstDataType);
                }
                return SDataAbstracts.NON_STANDARD;
            }
            if (!permittedOperands.contains(firstCategory) || !permittedOperands.contains(secondCategory)) {
                Modulo.addSemanticError(configInfo, true, operatorInfo, "UNDEFINED_OPERATOR: Operator ''{0}'' is undefined for argument types ''{1}'', ''{2}''", null, operatorInfo.getOperator().getOperatorText(), firstDataType, secondDataType);
                return SDataAbstracts.ILLEGAL;
            }
            return null;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            return this.getResolvedTypeAccordingToPriority(operatorInfo, operands);
        }
    }

    protected static class ParameterValue
    extends Association {
        protected ParameterValue() {
        }

        @Override
        protected String getOutputRefMessageType(IRfNamedElement element) {
            return "parameter";
        }

        @Override
        protected String getBaseMessageType(IRfNamedElement element) {
            return "parameter";
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            return operands.get(0);
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            if (operands.size() != 2) {
                return SDataAbstracts.ILLEGAL;
            }
            ISDataAbstract firstData = operands.get(0);
            ISDataAbstract secondData = operands.get(1);
            ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)firstData);
            if (firstDataType == SDataAbstracts.TYPE_UNDEFINED) {
                if (secondData instanceof ISDataType) {
                    ISDataType secondDataType = (ISDataType)secondData;
                    if (secondDataType.isUnderAlias()) {
                        return secondDataType;
                    }
                    IRfNamedElement secondType = secondDataType.getType();
                    if (!(secondType instanceof RfInterface || secondType instanceof RfModport || secondType instanceof RfClockingBlock)) {
                        return secondDataType;
                    }
                    IHidObject operatorRHValue = operatorInfo.getOperator().getFirstRHValue();
                    if (operatorRHValue instanceof Hid && ((Hid)operatorRHValue).hasQualifier(HidQualifierCache.VIRTUAL_INTERFACE_TYPE)) {
                        return secondDataType;
                    }
                    if ((operatorRHValue = HidUtils.getAncestorHidFrom((IHidObject)operatorRHValue)) instanceof Hid && ((Hid)operatorRHValue).hasQualifier(HidQualifierCache.VIRTUAL_INTERFACE_TYPE)) {
                        return secondDataType;
                    }
                    if (triggerError) {
                        ParameterValue.addSemanticError(configInfo, true, operatorInfo, "ILLEGAL_PARAMETER_OVERRIDE: Expected a type when overriding parameter ''{0}'', found {1} ''{2}''", null, context.contextElementName, secondDataType.getType().getKindName(), secondDataType.getName(configInfo.isSemanticShowAliasName()));
                    }
                    return SDataAbstracts.ILLEGAL;
                }
                ListContainer rhValues = operatorInfo.getOperator().getRHValues();
                if (triggerError) {
                    ParameterValue.addSemanticError(configInfo, true, operatorInfo, "ILLEGAL_PARAMETER_OVERRIDE: Expected a type when overriding parameter ''{0}'', found value ''{1}''", null, context.contextElementName, SDataUtils.getVariableName((ISDataAbstract)secondData, rhValues != null && !rhValues.isEmpty() ? (IHidObject)rhValues.get(0) : null));
                }
                return SDataAbstracts.ILLEGAL;
            }
            return super.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
        }
    }

    protected static class PortConnection
    extends Association {
        protected PortConnection() {
        }

        @Override
        protected String getOutputRefMessageType(IRfNamedElement element) {
            if (element instanceof RfPort) {
                RfPort field = (RfPort)element;
                if (field.isOutput()) {
                    return "output port";
                }
                if (field.isInout()) {
                    return "inout port";
                }
                if (field.isRef()) {
                    return "ref port";
                }
            }
            return "port";
        }

        @Override
        protected String getBaseMessageType(IRfNamedElement element) {
            return String.valueOf(element instanceof RfField && ((RfField)element).isRef() ? "ref " : "") + "port";
        }

        @Override
        protected String getWidthTruncationMessage(HidOperator operator) {
            return operator.hasQualifier(HidQualifierCache.IS_WITH_IMPLICIT_SIGNAL_QUALIFIER) ? "WIDTH_MISMATCH_IMPLICIT_SIGNAL: Assignment to ''{2}'' of ''{0}'' type from ''{3}'' of ''{1}'' type" : "WIDTH_MISMATCH_TRUNCATION: Assignment to ''{2}'' of ''{0}'' type from ''{3}'' of ''{1}'' type";
        }

        @Override
        protected String getWidthPaddingMessage(HidOperator operator) {
            return operator.hasQualifier(HidQualifierCache.IS_WITH_IMPLICIT_SIGNAL_QUALIFIER) ? "WIDTH_MISMATCH_IMPLICIT_SIGNAL: Assignment to ''{2}'' of ''{0}'' type from ''{3}'' of ''{1}'' type" : "WIDTH_MISMATCH_PADDING: Assignment to ''{2}'' of ''{0}'' type from ''{3}'' of ''{1}'' type";
        }

        @Override
        protected String getWidthRoundingMessage(HidOperator operator) {
            return operator.hasQualifier(HidQualifierCache.IS_WITH_IMPLICIT_SIGNAL_QUALIFIER) ? "WIDTH_MISMATCH_IMPLICIT_SIGNAL: Assignment to ''{2}'' of ''{0}'' type from ''{3}'' of ''{1}'' type" : "WIDTH_MISMATCH_ROUNDING: Assignment to ''{2}'' of ''{0}'' type from ''{3}'' of ''{1}'' type";
        }

        @Override
        public ISDataType internalCheckOperands(ConfigInfo configInfo, boolean triggerError, boolean forceCheckWidth, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            IHidObject rhValue;
            ISDataType result = super.internalCheckOperands(configInfo, triggerError, forceCheckWidth, operatorInfo, operands, context);
            if (result != null) {
                return result;
            }
            ISDataAbstract first = operands.get(0);
            ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)first);
            IRfNamedElement firstVariableElement = SDataUtils.getVariableElement((ISDataAbstract)first);
            ISDataAbstract second = operands.get(1);
            ISDataType secondDataType = SDataUtils.getDataType((ISDataAbstract)second);
            HidOperator operator = operatorInfo.getOperator();
            if (firstVariableElement != null && !(firstVariableElement.getEnclosingScope() instanceof RfChecker) && SDataAbstracts.getOperandCategory((ISDataAbstract)firstDataType) == SDataTypeCategory.EVENT && SDataAbstracts.getOperandCategory((ISDataAbstract)secondDataType) == SDataTypeCategory.EVENT && HidUtils.isOperator((IHidObject)(rhValue = operator.getFirstRHValue()))) {
                PortConnection.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_ASSIGNMENT: Illegal assignment of {0} ''{1}'' to {2} ''{3}''", null, "event expression", SDataUtils.getVariableName((ISDataAbstract)second, (IHidObject)rhValue), "event " + this.getBaseMessageType(firstVariableElement), firstVariableElement.getName());
                return SDataAbstracts.ILLEGAL;
            }
            return null;
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            if (operands.size() != 2) {
                return SDataAbstracts.ILLEGAL;
            }
            boolean reverseOrder = operatorInfo.hasOutputDirection();
            if (context != null && context.getOptionalUnpackedDimensions() > 0) {
                ISDataAbstract first = reverseOrder ? operands.get(1) : operands.get(0);
                ISDataAbstract second = reverseOrder ? operands.get(0) : operands.get(1);
                ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)first);
                ISDataType secondDataType = SDataUtils.getDataType((ISDataAbstract)second);
                SDataTypeCategory firstCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)firstDataType);
                SDataTypeCategory secondCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)secondDataType);
                if (secondCategory == SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED && (firstCategory == SDataTypeCategory.NUMERIC || firstCategory == SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED || firstCategory == SDataTypeCategory.UNION_PACKED || firstCategory == SDataTypeCategory.STRUCT_PACKED)) {
                    this.checkPortConnectionOperands(configInfo, triggerError, operatorInfo, operands);
                    return null;
                }
                if (secondCategory == SDataTypeCategory.FIXED_SIZE_ARRAY_UNPACKED) {
                    IRfNamedElement secondArrayElement;
                    ISDataType result;
                    int unrolledNofDimensions = secondDataType.getNofUnpackedDimensions() - context.getOptionalUnpackedDimensions();
                    if (unrolledNofDimensions > 0) {
                        if (firstCategory != SDataTypeCategory.FIXED_SIZE_ARRAY_UNPACKED && firstCategory != SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED) {
                            this.addSemanticError(configInfo, triggerError, operatorInfo, first, firstDataType, second, secondDataType, reverseOrder, context.getElabPathForError());
                            return SDataAbstracts.ILLEGAL;
                        }
                        this.checkPortConnectionOperands(configInfo, triggerError, operatorInfo, operands);
                        return null;
                    }
                    if (unrolledNofDimensions < 0) {
                        this.addSemanticError(configInfo, triggerError, operatorInfo, first, firstDataType, second, secondDataType, reverseOrder, context.getElabPathForError());
                        return SDataAbstracts.ILLEGAL;
                    }
                    ISDataType secondCachedListType = secondDataType.getCachedListBaseElementType();
                    SDataTypeCategory secondListElementCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)secondCachedListType);
                    if (secondListElementCategory != SDataTypeCategory.UNKNOWN && !SDataUtils.isIllegalDataType((ISDataAbstract)(result = this.checkIllegal(configInfo, false, operatorInfo, first, firstCategory, null, (ISDataAbstract)secondCachedListType, secondListElementCategory, secondArrayElement = SDataUtils.getVariableElement((ISDataAbstract)second), false, null))) && !SDataUtils.isIllegalDataType((ISDataAbstract)(result = this.checkIllegal(configInfo, false, operatorInfo, (ISDataAbstract)secondCachedListType, secondListElementCategory, secondArrayElement, first, firstCategory, null, true, null)))) {
                        this.checkPortConnectionOperands(configInfo, triggerError, operatorInfo, operands);
                        return null;
                    }
                }
            }
            this.checkPortConnectionOperands(configInfo, triggerError, operatorInfo, operands);
            return super.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
        }

        private void checkPortConnectionOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands) {
            IHidObject origActualObject = operatorInfo.getOperator().getFirstRHValue();
            IHidObject actualObject = origActualObject;
            if (HidUtils.isHidAccess((IHidObject)actualObject)) {
                actualObject = ((HidAccess)actualObject).getParentHid();
            }
            if (!HidUtils.isHid((IHidObject)actualObject)) {
                return;
            }
            Hid actualHid = (Hid)actualObject;
            boolean reverseOrder = operatorInfo.hasOutputDirection();
            ISDataAbstract formal = reverseOrder ? operands.get(1) : operands.get(0);
            IRfNamedElement formalElem = SDataUtils.getVariableElement((ISDataAbstract)formal);
            if (formalElem instanceof RfPort && ((RfPort)formalElem).isInout()) {
                IRfNamedElement actualElem;
                if (actualHid.getParentHid() != null) {
                    Hid ancestorHid = actualHid.getAncestorHid();
                    IRfNamedElement ancestorElement = ancestorHid.getElement();
                    if (ancestorElement instanceof IRfInstanceElement || ancestorElement instanceof RfInstanceHolder || ancestorElement instanceof RfPort && ((RfPort)ancestorElement).isInterfacePort()) {
                        HidAccess firstAccess;
                        do {
                            if ((firstAccess = ancestorHid.getFirstAccess()) != null) continue;
                            ancestorHid = null;
                            break;
                        } while ((ancestorHid = firstAccess.getFirstHid()) != null && ((ancestorElement = ancestorHid.getElement()) instanceof IRfInstanceElement || ancestorElement instanceof IRfBlockElement));
                    }
                    actualHid = ancestorHid;
                }
                IRfNamedElement iRfNamedElement = actualElem = actualHid != null ? actualHid.getElement() : null;
                if (actualElem instanceof RfField && !((RfField)actualElem).isNet()) {
                    IRfScopeElement formalElemScope = formalElem.getEnclosingScope();
                    String formalElementScopeKind = DesignUtils.getDesignKindInstanceText((IRfScopeElement)formalElemScope);
                    PortConnection.addSemanticError(configInfo, triggerError, operatorInfo, "PORT_CONNECTION: Inout port ''{0}'' of {1} ''{2}'' connected to variable ''{3}''", null, formalElem.getName(), formalElementScopeKind, formalElemScope.getName(), SDataUtils.getVariableName(null, (IHidObject)origActualObject));
                }
            } else if (formalElem instanceof RfPort && ((RfPort)formalElem).isOutput()) {
                DataType dataType;
                IRfNamedElement actualElem = actualHid.getElement();
                DataType dataType2 = dataType = actualElem instanceof IRfAssociatedType ? ((IRfAssociatedType)actualElem).getDataType() : null;
                if (dataType != null && "reg".equals(dataType.getType())) {
                    IRfScopeElement formalElemScope = formalElem.getEnclosingScope();
                    String formalElementScopeKind = DesignUtils.getDesignKindInstanceText((IRfScopeElement)formalElemScope);
                    PortConnection.addSemanticWarning(configInfo, triggerError, operatorInfo, "PORT_CONNECTION: Output port ''{0}'' of {1} ''{2}'' connected to ''{3}'' of ''reg'' data type", null, formalElem.getName(), formalElementScopeKind, formalElemScope.getName(), SDataUtils.getVariableName(null, (IHidObject)origActualObject));
                } else if (actualElem instanceof RfPort && ((RfPort)actualElem).isInput() && actualHid.getParentAccess() == null && !((RfPort)formalElem).hasUserDefinedNetType(false) && !((RfPort)actualElem).hasUserDefinedNetType(false)) {
                    IRfScopeElement formalElemScope = formalElem.getEnclosingScope();
                    IRfScopeElement actualElemScope = actualElem.getEnclosingScope();
                    String formalElementScopeKind = DesignUtils.getDesignKindInstanceText((IRfScopeElement)formalElemScope);
                    String actualElementScopeKind = DesignUtils.getDesignKindInstanceText((IRfScopeElement)actualElemScope);
                    PortConnection.addSemanticError(configInfo, triggerError, operatorInfo, "PORT_CONNECTION: Output port ''{0}'' of {1} ''{2}'' connected to input port ''{3}'' of {4} ''{5}''", null, formalElem.getName(), formalElementScopeKind, formalElemScope.getName(), SDataUtils.getVariableName(null, (IHidObject)actualObject), actualElementScopeKind, actualElemScope.getName());
                }
            }
        }
    }

    private static class Reduction
    extends Logical {
        private final EnumSet<SDataTypeCategory> permittedOperands = EnumSet.of(SDataTypeCategory.NUMERIC, new SDataTypeCategory[]{SDataTypeCategory.LITERAL_STRING, SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED, SDataTypeCategory.STRUCT_PACKED, SDataTypeCategory.UNION_PACKED, SDataTypeCategory.ENUM});

        private Reduction() {
        }

        @Override
        public EnumSet<SDataTypeCategory> getPermittedOperands() {
            return this.permittedOperands;
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            if (operands.size() != 1) {
                return SDataAbstracts.ILLEGAL;
            }
            return super.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
        }
    }

    private static class Relational
    extends SOperation {
        public static final EnumSet<SDataTypeCategory> permittedOperands = EnumSet.of(SDataTypeCategory.NUMERIC, new SDataTypeCategory[]{SDataTypeCategory.SHORTREAL, SDataTypeCategory.REAL, SDataTypeCategory.LITERAL_STRING, SDataTypeCategory.STRING, SDataTypeCategory.ENUM, SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED, SDataTypeCategory.UNION_PACKED, SDataTypeCategory.STRUCT_PACKED});

        private Relational() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            int size = operands.size();
            if (1 > size || size > 2) {
                return SDataAbstracts.ILLEGAL;
            }
            ISDataAbstract first = operands.get(0);
            ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)first);
            SDataTypeCategory firstCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)first);
            ISDataType nonValidOperand = this.checkValidOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (nonValidOperand != null) {
                return nonValidOperand;
            }
            if (size == 1) {
                if (!permittedOperands.contains(firstCategory)) {
                    Relational.addSemanticError(configInfo, triggerError, operatorInfo, "UNDEFINED_OPERATOR: Operator ''{0}'' is undefined for argument type ''{1}''", null, operatorInfo.getOperator().getOperatorText(), firstDataType.getName(configInfo.isSemanticShowAliasName()));
                    return SDataAbstracts.ILLEGAL;
                }
            } else {
                ISDataAbstract second = operands.get(1);
                ISDataType secondDataType = SDataUtils.getDataType((ISDataAbstract)second);
                SDataTypeCategory secondCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)second);
                if (!permittedOperands.contains(firstCategory) || !permittedOperands.contains(secondCategory)) {
                    Relational.addSemanticError(configInfo, triggerError, operatorInfo, "UNDEFINED_OPERATOR: Operator ''{0}'' is undefined for argument types ''{1}'', ''{2}''", null, operatorInfo.getOperator().getOperatorText(), firstDataType.getName(configInfo.isSemanticShowAliasName()), secondDataType.getName(configInfo.isSemanticShowAliasName()));
                    return SDataAbstracts.ILLEGAL;
                }
                if ((firstCategory == SDataTypeCategory.NUMERIC || firstCategory == SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED || firstCategory == SDataTypeCategory.ENUM) && secondCategory == SDataTypeCategory.STRING) {
                    if (triggerError) {
                        String elabPath = context != null ? context.getElabPathForError() : "";
                        Relational.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_STRING_OPERATION, this.getAttributesForElabPaths(elabPath), "first", firstDataType.getName(configInfo.isSemanticShowAliasName()));
                    }
                    return SDataAbstracts.NON_STANDARD;
                }
                if ((secondCategory == SDataTypeCategory.NUMERIC || secondCategory == SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED || secondCategory == SDataTypeCategory.ENUM) && firstCategory == SDataTypeCategory.STRING) {
                    if (triggerError) {
                        String elabPath = context != null ? context.getElabPathForError() : "";
                        Relational.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_STRING_OPERATION, this.getAttributesForElabPaths(elabPath), "second", secondDataType.getName(configInfo.isSemanticShowAliasName()));
                    }
                    return SDataAbstracts.NON_STANDARD;
                }
                if (firstCategory == SDataTypeCategory.STRING && secondCategory != SDataTypeCategory.STRING && secondCategory != SDataTypeCategory.LITERAL_STRING) {
                    Relational.addSemanticError(configInfo, triggerError, operatorInfo, "UNDEFINED_OPERATOR: Operator ''{0}'' is undefined for argument types ''{1}'', ''{2}''", null, operatorInfo.getOperator().getOperatorText(), firstDataType.getName(configInfo.isSemanticShowAliasName()), secondDataType.getName(configInfo.isSemanticShowAliasName()));
                    return SDataAbstracts.ILLEGAL;
                }
                if (secondCategory == SDataTypeCategory.STRING && firstCategory != SDataTypeCategory.STRING && firstCategory != SDataTypeCategory.LITERAL_STRING) {
                    Relational.addSemanticError(configInfo, triggerError, operatorInfo, "UNDEFINED_OPERATOR: Operator ''{0}'' is undefined for argument types ''{1}'', ''{2}''", null, operatorInfo.getOperator().getOperatorText(), firstDataType.getName(configInfo.isSemanticShowAliasName()), secondDataType.getName(configInfo.isSemanticShowAliasName()));
                    return SDataAbstracts.ILLEGAL;
                }
                if (firstDataType instanceof SDataType && ((SDataType)firstDataType).isEnum()) {
                    IRfNamedElement secondVariableElement;
                    IRfNamedElement secondEnum = secondDataType instanceof SDataType && ((SDataType)secondDataType).isEnum() ? secondDataType.getType() : null;
                    IRfNamedElement iRfNamedElement = secondVariableElement = second instanceof SDataVariable ? ((SDataVariable)second).getEnumLiteral() : null;
                    if (secondEnum == null) {
                        IRfNamedElement iRfNamedElement2 = secondEnum = secondVariableElement instanceof RfField && ((RfField)secondVariableElement).isEnumElement() ? (IRfNamedElement)secondVariableElement.getEnclosingScope() : null;
                    }
                    if (secondEnum != null && !secondEnum.equals(firstDataType.getType())) {
                        if (triggerError) {
                            String aliasFirstEnum = ((RfStruct)firstDataType.getType()).getAliasName();
                            if (aliasFirstEnum == null) {
                                SDataVariable firstVariable = SDataUtils.getVariable((ISDataAbstract)first);
                                String variableName = SDataUtils.getVariableName((ISDataAbstract)firstVariable, null);
                                aliasFirstEnum = DVTStringUtil.appendString((Object[])new Object[]{"of '", variableName, "'"});
                            } else {
                                aliasFirstEnum = DVTStringUtil.appendString((Object[])new Object[]{"'", aliasFirstEnum, "'"});
                            }
                            String aliasSecondEnum = ((RfStruct)secondEnum).getAliasName();
                            if (aliasSecondEnum == null) {
                                SDataVariable secondVariable = SDataUtils.getVariable((ISDataAbstract)second);
                                String variableName = SDataUtils.getVariableName((ISDataAbstract)secondVariable, null);
                                aliasSecondEnum = DVTStringUtil.appendString((Object[])new Object[]{"of '", variableName, "'"});
                            } else {
                                aliasSecondEnum = DVTStringUtil.appendString((Object[])new Object[]{"'", aliasSecondEnum, "'"});
                            }
                            Relational.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_DIFFERENT_ENUMS_COMPARISON, null, aliasFirstEnum, aliasSecondEnum);
                        }
                        return SDataAbstracts.NON_STANDARD;
                    }
                    if (secondEnum == null) {
                        SDataVariable firstVariable = SDataUtils.getVariable((ISDataAbstract)first);
                        if (triggerError && firstVariable != null && (context == null || context.contextOperation == null || context.contextOperation != RETURN_INSTANCE)) {
                            Relational.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_ENUM_COMPARISON, null, secondDataType, firstVariable.getVariableName(), firstDataType);
                        }
                        return SDataAbstracts.NON_STANDARD;
                    }
                }
            }
            return null;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            return STransformer.LOGIC_VARIABLE;
        }
    }

    private static class Return
    extends Assignment {
        private Return() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            boolean isEmptyReturn;
            if (operands.size() != 2) {
                return SDataAbstracts.ILLEGAL;
            }
            RfFunction funcScope = (RfFunction)operatorInfo.getScope(RfFunction.class);
            if (funcScope == null) {
                return null;
            }
            ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)operands.get(0));
            ISDataAbstract second = operands.get(1);
            boolean bl = isEmptyReturn = second instanceof SDataVariable && STransformer.VOID_IMPLICIT.equals(((SDataVariable)second).getVariable());
            if (isEmptyReturn) {
                if (!funcScope.isConstructor() && !funcScope.isProduction() && firstDataType != STransformer.VOID_DATA_TYPE) {
                    Return.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_EMPTY_RETURN: Empty return not allowed in non-void function, expecting ''{0}''", null, firstDataType.getName(configInfo.isSemanticShowAliasName()));
                    return SDataAbstracts.ILLEGAL;
                }
                return null;
            }
            if (funcScope.isTask()) {
                Return.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_VALUE_RETURN: Value return not allowed in task", null, new Object[0]);
                return SDataAbstracts.ILLEGAL;
            }
            if (funcScope.isConstructor()) {
                Return.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_VALUE_RETURN: Value return not allowed in constructor", null, new Object[0]);
                return SDataAbstracts.ILLEGAL;
            }
            if (funcScope.isProduction()) {
                Return.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_VALUE_RETURN: Value return not allowed in randsequence production", null, new Object[0]);
                return SDataAbstracts.ILLEGAL;
            }
            if (firstDataType == STransformer.VOID_DATA_TYPE) {
                Return.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_VALUE_RETURN: Value return not allowed in void function", null, new Object[0]);
                return SDataAbstracts.ILLEGAL;
            }
            if (context != null && context.hasElabContext()) {
                HidOperator operator = operatorInfo.getOperator();
                HidOperatorOccurrence occurrence = operator.getOccurrence();
                RfHid lhSide = STransformer.makeStandInHid(funcScope.getName(), funcScope, new HidOccurrence(occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), 0L, null), 0L);
                RfHidOperator dummyOperator = STransformer.makeStandInOperator((IHidObject)lhSide, OptimizedUtils.asList((ListContainer)operator.getRHValues(), (boolean)false), IHidOperatorConstants.OperatorType.NO_TYPE.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, operator.getOperatorText(), operator.getOccurrence(), operator.getQualifiers());
                operatorInfo = new OperatorInfo((HidOperator)dummyOperator, context.contextOperatorInfo.getParserPath(), context.contextOperatorInfo.getScope(), context.contextOperatorInfo.hasOutputDirection());
            }
            return this.internalCheckOperands(configInfo, triggerError, false, operatorInfo, operands, context);
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            return operands.get(0);
        }

        @Override
        protected String getWidthPaddingMessage(HidOperator operator) {
            return "WIDTH_MISMATCH_PADDING: Returning ''{3}'' of ''{1}'' type for function of ''{0}'' return type";
        }

        @Override
        protected String getWidthTruncationMessage(HidOperator operator) {
            return "WIDTH_MISMATCH_TRUNCATION: Returning ''{3}'' of ''{1}'' type for function of ''{0}'' return type";
        }

        @Override
        protected String getWidthRoundingMessage(HidOperator operator) {
            return "WIDTH_MISMATCH_ROUNDING: Returning ''{3}'' of ''{1}'' type for function of ''{0}'' return type";
        }

        @Override
        protected String getUndefinedOperatorErrorMessage(Equality.UndefinedOperatorMessageInfoKind kind) {
            switch (kind) {
                case PACKED_UNPACKED: {
                    return "ILLEGAL_RETURN_VALUE_TYPE: Illegal return value of type ''{1}'' for function of type ''{0}'' (cannot assign a{2,choice,0# packed|1#n unpacked} type to a{2,choice,0#n unpacked|1# packed} type)";
                }
                case ARRAYS: {
                    return "ILLEGAL_RETURN_VALUE_TYPE: Illegal return value of type ''{1}'' for function of type ''{0}'' (arrays have incompatible {2,choice,0#dimensions|1#packed dimensions|2#unpacked dimensions|3#element types|4#element type signing|5#2-state/4-state element types})";
                }
                case CLASSES: {
                    return "ILLEGAL_RETURN_VALUE_TYPE: Illegal return value of type ''{1}'' for function of type ''{0}'' (class types are not assignment compatible)";
                }
            }
            return "ILLEGAL_RETURN_VALUE_TYPE: Illegal return value of type ''{1}'' for function of type ''{0}''";
        }
    }

    private static class SetOrList
    extends SOperation {
        private SetOrList() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            return this.checkValidOperands(configInfo, triggerError, operatorInfo, operands, context);
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType nonValidOperand = this.checkValidOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (nonValidOperand != null) {
                return nonValidOperand;
            }
            return STransformer.SET_VARIABLE;
        }
    }

    private static class SolveBeforeConstraint
    extends Constraint {
        private SolveBeforeConstraint() {
        }

        @Override
        protected int getErrorConstraintOption() {
            return 1;
        }
    }

    private static class TernaryIF
    extends SOperation {
        private TernaryIF() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            if (operands.size() != 3) {
                return SDataAbstracts.ILLEGAL;
            }
            if (context == null || context.contextOperation == null || context.contextOperatorInfo == null || context.getContextDataType() == null) {
                return null;
            }
            ISDataAbstract contextDataType = context.getContextDataType();
            if (context.isUndefined()) {
                return SDataUtils.getDataType((ISDataAbstract)contextDataType);
            }
            ISDataAbstract conditionData = operands.get(0);
            SDataTypeCategory conditionCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)conditionData);
            if (conditionCategory == SDataTypeCategory.STRUCT_UNPACKED) {
                return SDataAbstracts.ILLEGAL;
            }
            if (conditionCategory == SDataTypeCategory.UNION_UNPACKED) {
                return SDataAbstracts.ILLEGAL;
            }
            if (conditionCategory == SDataTypeCategory.FIXED_SIZE_ARRAY_UNPACKED) {
                return SDataAbstracts.ILLEGAL;
            }
            if (conditionCategory == SDataTypeCategory.NEW) {
                return SDataAbstracts.ILLEGAL;
            }
            HidOperator operator = operatorInfo.getOperator();
            ListContainer rhValues = operator.getRHValues();
            IHidObject firstValue = (IHidObject)rhValues.get(1);
            boolean checkFirst = !HidUtils.isOperator((IHidObject)firstValue) || !((HidOperator)firstValue).isConditionalTernary();
            IHidObject secondValue = (IHidObject)rhValues.get(0);
            boolean checkSecond = !HidUtils.isOperator((IHidObject)secondValue) || !((HidOperator)secondValue).isConditionalTernary();
            ISDataAbstract firstData = operands.get(1);
            ISDataAbstract secondData = operands.get(2);
            HidOperator contextOperator = context.contextOperatorInfo.getOperator();
            ArrayList<ISDataAbstract> newOperands = null;
            boolean isParticularOperation = TernaryIF.getOperation(contextOperator, null) instanceof ParticularOperations;
            ISDataType firstResult = null;
            if (checkFirst && context.getPreviousOperation() != null && !isParticularOperation) {
                newOperands = new ArrayList<ISDataAbstract>(2);
                if (context.getExtraContextDataType() != STransformer.CONCATENATION_GENERIC_VARIABLE) {
                    newOperands.add(contextDataType);
                }
                newOperands.add(firstData);
                RfHidOperator dummyOperator = STransformer.makeStandInOperator(contextOperator.getLHValue(), Arrays.asList(firstValue), IHidOperatorConstants.OperatorType.NO_TYPE.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, contextOperator.getOperatorText(), contextOperator.getOccurrence(), contextOperator.getQualifiers());
                OperatorInfo newOperatorInfo = new OperatorInfo((HidOperator)dummyOperator, context.contextOperatorInfo.getParserPath(), context.contextOperatorInfo.getScope(), context.contextOperatorInfo.hasOutputDirection());
                newOperatorInfo.setReplicatedConcatenationCondition(operatorInfo.isReplicatedConcatenationCondition());
                firstResult = context.getPreviousOperation().checkOperands(configInfo, triggerError, newOperatorInfo, newOperands, context);
                if (SDataUtils.getUndefinedDataType((ISDataAbstract)firstResult) == null) {
                    firstResult = null;
                }
            }
            ISDataType secondResult = null;
            if (checkSecond && context.getPreviousOperation() != null && !isParticularOperation) {
                newOperands = new ArrayList(2);
                if (context.getExtraContextDataType() != STransformer.CONCATENATION_GENERIC_VARIABLE) {
                    newOperands.add(contextDataType);
                }
                newOperands.add(secondData);
                RfHidOperator dummyOperator = STransformer.makeStandInOperator(contextOperator.getLHValue(), Arrays.asList(secondValue), IHidOperatorConstants.OperatorType.NO_TYPE.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, contextOperator.getOperatorText(), contextOperator.getOccurrence(), contextOperator.getQualifiers());
                OperatorInfo newOperatorInfo = new OperatorInfo((HidOperator)dummyOperator, context.contextOperatorInfo.getParserPath(), context.contextOperatorInfo.getScope(), context.contextOperatorInfo.hasOutputDirection());
                newOperatorInfo.setReplicatedConcatenationCondition(operatorInfo.isReplicatedConcatenationCondition());
                secondResult = context.getPreviousOperation().checkOperands(configInfo, triggerError, newOperatorInfo, newOperands, context);
                if (SDataUtils.getUndefinedDataType((ISDataAbstract)secondResult) == null) {
                    secondResult = null;
                }
            }
            return firstResult != null ? firstResult : secondResult;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            if (context == null || !(context.getContextDataType() instanceof SDataVariable) || !(context.contextOperation instanceof Assignment)) {
                return operands.get(1);
            }
            return context.getContextDataType();
        }
    }

    private static class Undefined
    extends SOperation {
        private Undefined() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            return null;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            return null;
        }
    }

    private static class UniqueConstraint
    extends Constraint {
        private UniqueConstraint() {
        }

        @Override
        protected int getErrorConstraintOption() {
            return 2;
        }
    }

    private static class UnpackedConcatenation
    extends SOperation {
        private UnpackedConcatenation() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkValidOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            return null;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (context != null && context.contextOperatorInfo.hasOutputDirection() && triggerError) {
                UnpackedConcatenation.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_TARGET_UNPACKED_ARRAY_CONCATENATION, null, new Object[0]);
            }
            if (context == null || context.getContextDataType() == null) {
                return null;
            }
            ISDataAbstract contextDataType = context.getContextDataType();
            if (context.isUndefined()) {
                return contextDataType;
            }
            return SDataVariable.of((ISDataType)SDataUtils.getDataType((ISDataAbstract)contextDataType), (boolean)false);
        }
    }

    private static class VoidCast
    extends SOperation {
        private VoidCast() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataAbstract operand = operands.get(0);
            ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)operand);
            if (dataType == STransformer.VOID_DATA_TYPE) {
                int severity;
                IRfNamedElement candidateFunction = SDataUtils.getVariableElement((ISDataAbstract)operand);
                if (!(candidateFunction instanceof RfFunction)) {
                    return SDataAbstracts.UNDEFINED;
                }
                if (candidateFunction instanceof RfPredefinedFunction && RfPredefinedFunction.PREDEFINED_BOTH_TASK_AND_FUNCTION.contains(candidateFunction.getName())) {
                    return SDataAbstracts.UNDEFINED;
                }
                boolean isTask = ((RfFunction)candidateFunction).isTask();
                String pattern = isTask ? "ILLEGAL_VOID_CAST: Void cast of task ''{0}'' not allowed" : RfSemanticError.NON_STANDARD_VOID_CAST_OF_VOID_FUNCTION;
                int n = severity = isTask ? 1 : RfSemanticError.getNonStandardSeverity();
                if (triggerError) {
                    VoidCast.addSemanticProblem(configInfo, severity, operatorInfo, pattern, null, candidateFunction.getName());
                }
                return isTask ? SDataAbstracts.ILLEGAL : SDataAbstracts.NON_STANDARD;
            }
            return STransformer.VOID_DATA_TYPE;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            return SDataAbstracts.UNDEFINED;
        }
    }

    private static class WithClause
    extends SOperation {
        private WithClause() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            if (context == null) {
                return null;
            }
            HidOperator operator = operatorInfo.getOperator();
            if (operator != null && operator.isWithClauseConstraint()) {
                return null;
            }
            ISDataType returnType = null;
            boolean dependsOnWithClause = false;
            if (RfHid.ARRAY_REDUCTION_METHODS.contains(context.contextElementName)) {
                dependsOnWithClause = true;
                returnType = "sum".equals(context.contextElementName) || "product".equals(context.contextElementName) ? ARITHMETIC_INSTANCE.checkOperands(configInfo, false, operatorInfo, operands, null) : LOGICAL_INSTANCE.checkOperands(configInfo, false, operatorInfo, operands, null);
            } else if (RfHid.OPTIONAL_RELATIONAL_WITH_CLAUSE_METHODS.contains(context.contextElementName)) {
                dependsOnWithClause = true;
                returnType = RELATIONAL_INSTANCE.checkOperands(configInfo, false, operatorInfo, operands, null);
            }
            if (dependsOnWithClause) {
                if (SDataUtils.isIllegalDataType(returnType) && operands.size() == 1) {
                    ISDataType operandDataType = SDataUtils.getDataType((ISDataAbstract)operands.get(0));
                    WithClause.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_WITH_CLAUSE_EXPRESSION: Illegal type ''{1}'' of ''with'' clause expression for method ''{0}''", null, context.contextElementName, operandDataType.getName(configInfo.isSemanticShowAliasName()));
                }
                return returnType;
            }
            LOGICAL_INSTANCE.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            return null;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            if (context == null || context.contextElementName == null) {
                return SDataAbstracts.UNDEFINED;
            }
            ISDataType state = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (state != null) {
                return state;
            }
            if (RfHid.ARRAY_REDUCTION_METHODS.contains(context.contextElementName)) {
                return operands.get(0);
            }
            return context.getContextDataType();
        }
    }

    private static class WithCoverpointBinsExpression
    extends SOperation {
        private WithCoverpointBinsExpression() {
        }

        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            if (operands.size() != 2) {
                return SDataAbstracts.ILLEGAL;
            }
            ISDataType isValid = this.checkValidOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            ListContainer operatorRHSide = operatorInfo.getOperator().getRHValues();
            boolean hasItem = false;
            Set hids = HidUtils.flattenToHids((List)OptimizedUtils.asList((ListContainer)operatorRHSide, (boolean)false), (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
            for (IHid iHid : hids) {
                if (!"item".equals(iHid.getName())) continue;
                hasItem = true;
                break;
            }
            if (!hasItem) {
                WithCoverpointBinsExpression.addSemanticWarning(configInfo, triggerError, operatorInfo, "WITH_COVERPOINT_BINS_EXPRESSION: Coverpoint bins ''with'' expression should explicitly contain ''item''", null, new Object[0]);
            }
            ISDataAbstract second = operands.get(1);
            SDataTypeCategory secondCategory = SDataAbstracts.getOperandCategory((ISDataAbstract)second);
            switch (secondCategory) {
                case NUMERIC: 
                case LITERAL_STRING: 
                case FIXED_SIZE_ARRAY_PACKED: 
                case ENUM: 
                case UNION_PACKED: 
                case STRUCT_PACKED: {
                    return null;
                }
                case REAL: {
                    WithCoverpointBinsExpression.addSemanticProblem(configInfo, RfSemanticError.getNonStandardSeverity(), operatorInfo, RfSemanticError.NON_STANDARD_COVERPOINT_EXPRESSION_TYPE, null, new Object[0]);
                    return SDataAbstracts.ILLEGAL;
                }
            }
            WithCoverpointBinsExpression.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_COVERPOINT_EXPRESSION: Coverpoint expression must be of an integral data type", null, new Object[0]);
            return SDataAbstracts.ILLEGAL;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType nonValidOperand = this.checkOperands(configInfo, triggerError, operatorInfo, operands, context);
            if (nonValidOperand != null) {
                return nonValidOperand;
            }
            return STransformer.BIT_VARIABLE;
        }
    }
}

