/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.semantic.extension2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IDataType;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidBuilders;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISContext;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISTransformer;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataTypeCategory;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataVariable;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfSpecializedType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfComputedListType;
import ro.amiq.vlogdt.model.reflection.RfComputedStruct;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfDuplicate;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModportPort;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedClass;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedEventType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SDataType;

public enum STransformer implements ISTransformer
{
    INSTANCE;

    public static final DummyElement SET_DUMMY;
    public static final DummyElement EMPTY_QUEUE_DUMMY;
    public static final DummyElement SIGNED_DUMMY;
    public static final DummyElement UNSIGNED_DUMMY;
    public static final DummyElement CONST_DUMMY;
    public static final DummyElement CONSTRAINT_BLOCK_DUMMY;
    public static final DummyElement LITERAL_STRING_DUMMY;
    public static final DummyElement CONCATENATION_GENERIC_DUMMY;
    public static final DummyElement CONTINUE_OR_BREAK_DUMMY;
    public static final RfNamedElement REAL_IMPLICIT;
    public static final RfNamedElement REALTIME_IMPLICIT;
    public static final RfNamedElement INTEGER_IMPLICIT;
    public static final RfNamedElement LOGIC_IMPLICIT;
    public static final RfNamedElement EVENT_IMPLICIT;
    public static final RfNamedElement VOID_IMPLICIT;
    public static final DummyElement SIGNED_IMPLICIT;
    public static final DummyElement UNSIGNED_IMPLICIT;
    public static final DummyElement CONST_IMPLICIT;
    public static final ISDataType LOGIC_DATA_TYPE;
    public static final ISDataType BIT_DATA_TYPE;
    public static final ISDataType STRING_DATA_TYPE;
    public static final ISDataType ENUM_VARIABLE_DATA_TYPE;
    public static final ISDataType VOID_DATA_TYPE;
    public static final ISDataType EVENT_DATA_TYPE;
    public static final ISDataType LITERAL_STRING_DATA_TYPE;
    public static final ISDataType SET_DATA_TYPE;
    public static final ISDataType SIGNED;
    public static final ISDataType UNSIGNED;
    public static final ISDataType CONST;
    public static final ISDataType EMPTY_QUEUE;
    public static final ISDataType CONCATENATION_GENERIC_DATA_TYPE;
    public static final SDataVariable LITERAL_STRING_VARIABLE;
    public static final SDataVariable LOGIC_VARIABLE;
    public static final SDataVariable BIT_VARIABLE;
    public static final SDataVariable EVENT_VARIABLE;
    public static final SDataVariable STRING_CONCATENATION_VARIABLE;
    public static final SDataVariable NUMERIC_4_STATE_CONCATENATION_VARIABLE;
    public static final SDataVariable NUMERIC_2_STATE_CONCATENATION_VARIABLE;
    public static final SDataVariable CONCATENATION_GENERIC_VARIABLE;
    public static final SDataVariable SET_VARIABLE;
    public static final ISDataType CONTINUE_OR_BREAK_DATA_TYPE;
    public static final Set<Class<? extends IRfNamedElement>> DECLARATION_FIELD_OR_PORT;
    public static final IHidBuilders BUILDERS;

    static {
        SET_DUMMY = new DummyElement("set");
        EMPTY_QUEUE_DUMMY = new DummyElement("empty_queue");
        SIGNED_DUMMY = new DummyElement("signed");
        UNSIGNED_DUMMY = new DummyElement("unsigned");
        CONST_DUMMY = new DummyElement("const");
        CONSTRAINT_BLOCK_DUMMY = new DummyElement("constraint");
        LITERAL_STRING_DUMMY = new DummyElement("literal_string");
        CONCATENATION_GENERIC_DUMMY = new DummyElement("concatenation_generic");
        CONTINUE_OR_BREAK_DUMMY = new DummyElement("continue_or_break");
        REAL_IMPLICIT = new RfPredefinedField("real", RfProject.getSimpleDataType("real"), 1, 1, "", "real");
        REALTIME_IMPLICIT = new RfPredefinedField("realtime", RfProject.getSimpleDataType("realtime"), 1, 1, "", "realtime");
        INTEGER_IMPLICIT = new RfPredefinedField("integer", RfProject.getSimpleDataType("integer"), 1, 1, "", "integer");
        LOGIC_IMPLICIT = new RfPredefinedField("logic", RfProject.getSimpleDataType("logic"), 1, 1, "", "logic");
        EVENT_IMPLICIT = new RfPredefinedField("event", RfProject.getSimpleDataType("event"), 1, 1, "", "event");
        VOID_IMPLICIT = new RfPredefinedField("void", RfProject.getSimpleDataType("void"), 1, 1, "", "void");
        SIGNED_IMPLICIT = new DummyElement("signed");
        UNSIGNED_IMPLICIT = new DummyElement("unsigned");
        CONST_IMPLICIT = new DummyElement("const");
        LOGIC_DATA_TYPE = SDataAbstracts.getCachedScalarDataType((ISDataType)SDataType.of(RfProject.getScalarType("logic")));
        BIT_DATA_TYPE = SDataAbstracts.getCachedScalarDataType((ISDataType)SDataType.of(RfProject.getScalarType("bit")));
        STRING_DATA_TYPE = SDataAbstracts.getCachedScalarDataType((ISDataType)SDataType.of(RfProject.getScalarType("string")));
        ENUM_VARIABLE_DATA_TYPE = SDataAbstracts.getCachedScalarDataType((ISDataType)SDataType.of(RfProject.getScalarType("int")));
        VOID_DATA_TYPE = SDataAbstracts.getCachedScalarDataType((ISDataType)SDataType.of(RfProject.getScalarType("void")));
        EVENT_DATA_TYPE = SDataAbstracts.getCachedScalarDataType((ISDataType)SDataType.of(RfProject.getScalarType("event")));
        LITERAL_STRING_DATA_TYPE = SDataType.of((IRfNamedElement)LITERAL_STRING_DUMMY, 0, 1);
        SET_DATA_TYPE = SDataType.of((IRfNamedElement)SET_DUMMY);
        SIGNED = SDataType.of((IRfNamedElement)SIGNED_DUMMY);
        UNSIGNED = SDataType.of((IRfNamedElement)UNSIGNED_DUMMY);
        CONST = SDataType.of((IRfNamedElement)CONST_DUMMY);
        EMPTY_QUEUE = SDataType.of((IRfNamedElement)EMPTY_QUEUE_DUMMY);
        EMPTY_QUEUE.setCachedListBaseElementType(VOID_DATA_TYPE);
        EMPTY_QUEUE.setNofUnpackedDimensions(1);
        CONCATENATION_GENERIC_DATA_TYPE = SDataType.of((IRfNamedElement)CONCATENATION_GENERIC_DUMMY);
        LITERAL_STRING_VARIABLE = SDataVariable.of((ISDataType)LITERAL_STRING_DATA_TYPE, (boolean)false);
        LOGIC_VARIABLE = SDataVariable.of((ISDataType)LOGIC_DATA_TYPE, (boolean)false);
        BIT_VARIABLE = SDataVariable.of((ISDataType)BIT_DATA_TYPE, (boolean)false);
        EVENT_VARIABLE = SDataVariable.of((ISDataType)EVENT_DATA_TYPE, (boolean)false);
        STRING_CONCATENATION_VARIABLE = SDataVariable.of((ISDataType)STRING_DATA_TYPE, (boolean)false);
        NUMERIC_4_STATE_CONCATENATION_VARIABLE = LOGIC_VARIABLE;
        NUMERIC_2_STATE_CONCATENATION_VARIABLE = BIT_VARIABLE;
        CONCATENATION_GENERIC_VARIABLE = SDataVariable.of((ISDataType)CONCATENATION_GENERIC_DATA_TYPE, (boolean)false);
        SET_VARIABLE = SDataVariable.of((ISDataType)SET_DATA_TYPE, (boolean)false);
        CONTINUE_OR_BREAK_DATA_TYPE = SDataType.of((IRfNamedElement)CONTINUE_OR_BREAK_DUMMY);
        DECLARATION_FIELD_OR_PORT = new HashSet<Class<? extends IRfNamedElement>>();
        DECLARATION_FIELD_OR_PORT.add(RfField.class);
        DECLARATION_FIELD_OR_PORT.add(RfPort.class);
        DECLARATION_FIELD_OR_PORT.add(RfModportPort.class);
        BUILDERS = new IHidBuilders(){

            public RfHidImplicit buildImplicit(String name, int type) {
                return STransformer.makeStandInImplicit(name, type);
            }

            public RfHid buildHid(String name, IRfNamedElement resolved, HidOccurrence occurrence, long hidQualifiers) {
                return STransformer.makeStandInHid(name, resolved, occurrence, hidQualifiers);
            }

            public RfHidAccess buildAccess(Hid first, Hid second, int access) {
                return STransformer.makeStandInAccess(first, second, access);
            }

            public RfHidAccess buildAccess(Hid parent, Hid child, List<IHidObject> selects, int access) {
                return STransformer.makeStandInAccess(parent, child, selects, access);
            }

            public RfHidOperator buildOperator(IHidObject lhSide, List<IHidObject> rhSide, int type, IHidOperatorConstants.OperatorKind kind, String text, HidOperatorOccurrence occurrence, long operatorQualifiers) {
                return STransformer.makeStandInOperator(lhSide, rhSide, type, kind, text, occurrence, operatorQualifiers);
            }

            public HidOperator buildDefparamOperator(ElementPath hierarchyParamPath, IRfScopeElement param, String value, int offset) {
                return STransformer.makeStandInDefparamOperator(hierarchyParamPath, value, offset);
            }

            public HidOperator buildNotOperator(IHidObject condition, HidOperatorOccurrence occurrence) {
                return STransformer.makeStandInOperator(condition, Collections.emptyList(), 479, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "!", occurrence, 0L);
            }

            public HidOperator buildCycleDelayConstOperator(IHidObject lhSide, List<IHidObject> rhSide, IHidOperatorConstants.OperatorKind kind, HidOperatorOccurrence occurrence) {
                return STransformer.makeStandInOperator(lhSide, rhSide, 526, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "##", occurrence, 0L);
            }

            public HidOperator buildCycleDelayRangeOperator(IHidObject lhSide, List<IHidObject> rhSide, IHidOperatorConstants.OperatorKind kind, HidOperatorOccurrence occurrence) {
                RfHidOperator rangeOperator = STransformer.makeStandInOperator(lhSide, rhSide, 461, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, ":", occurrence, HidQualifierCache.IS_RANGE_OR_PART_SELECT_QUALIFIER);
                return STransformer.makeStandInOperator((IHidObject)rangeOperator, Collections.emptyList(), 526, kind, "##", occurrence, 0L);
            }
        };
    }

    private STransformer() {
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("logic"), 2, 1), (SDataTypeCategory)SDataTypeCategory.NUMERIC);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("logic"), 1, 1), (SDataTypeCategory)SDataTypeCategory.NUMERIC);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("bit"), 2, 1), (SDataTypeCategory)SDataTypeCategory.NUMERIC);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("bit"), 1, 1), (SDataTypeCategory)SDataTypeCategory.NUMERIC);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("reg"), 2, 1), (SDataTypeCategory)SDataTypeCategory.NUMERIC);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("reg"), 1, 1), (SDataTypeCategory)SDataTypeCategory.NUMERIC);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("byte"), 2, 1), (SDataTypeCategory)SDataTypeCategory.NUMERIC);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("byte"), 1, 1), (SDataTypeCategory)SDataTypeCategory.NUMERIC);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("shortint"), 2, 1), (SDataTypeCategory)SDataTypeCategory.NUMERIC);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("shortint"), 1, 1), (SDataTypeCategory)SDataTypeCategory.NUMERIC);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("integer"), 2, 1), (SDataTypeCategory)SDataTypeCategory.NUMERIC);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("integer"), 1, 1), (SDataTypeCategory)SDataTypeCategory.NUMERIC);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("int"), 2, 1), (SDataTypeCategory)SDataTypeCategory.NUMERIC);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("int"), 1, 1), (SDataTypeCategory)SDataTypeCategory.NUMERIC);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("time"), 2, 1), (SDataTypeCategory)SDataTypeCategory.NUMERIC);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("time"), 1, 1), (SDataTypeCategory)SDataTypeCategory.NUMERIC);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("longint"), 2, 1), (SDataTypeCategory)SDataTypeCategory.NUMERIC);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("longint"), 1, 1), (SDataTypeCategory)SDataTypeCategory.NUMERIC);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("shortreal"), 0, 0), (SDataTypeCategory)SDataTypeCategory.SHORTREAL);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("real"), 0, 0), (SDataTypeCategory)SDataTypeCategory.REAL);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("realtime"), 0, 0), (SDataTypeCategory)SDataTypeCategory.REAL);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("null"), 0, 0), (SDataTypeCategory)SDataTypeCategory.NULL);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("void"), 0, 0), (SDataTypeCategory)SDataTypeCategory.VOID);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("chandle"), 0, 0), (SDataTypeCategory)SDataTypeCategory.CHANDLE);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("event"), 0, 0), (SDataTypeCategory)SDataTypeCategory.EVENT);
        SDataAbstracts.putKnownScalar((ISDataType)SDataType.of(RfProject.getScalarType("string"), 0, 0), (SDataTypeCategory)SDataTypeCategory.STRING);
    }

    public static boolean checkValidType(IRfNamedElement type) {
        if (type instanceof IRfSpecializedType) {
            type = ((IRfSpecializedType)type).getGenericElement();
        } else if (type instanceof RfComputedStruct) {
            type = ((RfComputedStruct)type).getOriginal();
        }
        return DVTRfUtils.MEMBERS_TYPES.contains(type.getClass());
    }

    public static boolean isConcatenationResultType(ISDataType type) {
        return STransformer.STRING_CONCATENATION_VARIABLE.type == type || STransformer.NUMERIC_4_STATE_CONCATENATION_VARIABLE.type == type || STransformer.NUMERIC_2_STATE_CONCATENATION_VARIABLE.type == type;
    }

    public ISDataAbstract transform(IRfNamedElement element, IRfNamedElement scope, ELWidthCheckContext elabContext, HashSet<IRfNamedElement> visited, boolean isFinal, boolean isVariable, boolean dimensionsWithMacros, boolean isNetAlias, boolean isIrunRNMTech) {
        ISDataType possiblePredefined;
        boolean isUserDefinedNettypeElement;
        DataType typeDataType;
        ISDataType undefinedData;
        if (element == null || element == RfHid.SYSTEM_TASK_UNRESOLVED_HID) {
            return SDataAbstracts.UNDEFINED;
        }
        RfField field = null;
        if (element instanceof RfField) {
            field = (RfField)element;
            if (field.isTypeParameter()) {
                return SDataAbstracts.TYPE_UNDEFINED;
            }
            if (field.isParameterNoDataType()) {
                return SDataAbstracts.PARAMETER_UNTYPED;
            }
            if (field.hasInterconnectNettype()) {
                return SDataAbstracts.UNDEFINED;
            }
            if (!field.isPredefined() && field.hasNoDefs(false)) {
                return SDataAbstracts.UNDEFINED;
            }
        }
        if (element instanceof RfFunction && (((RfFunction)element).isLet() || ((RfFunction)element).isProduction())) {
            return SDataAbstracts.UNDEFINED;
        }
        if (element instanceof RfFunction && ((RfFunction)element).isTask()) {
            return SDataVariable.of((ISDataType)VOID_DATA_TYPE, (IRfNamedElement)element, (boolean)false);
        }
        if (SDataAbstracts.NULL_IMPLICIT == element) {
            return SDataVariable.of((ISDataType)SDataAbstracts.NULL, (boolean)false);
        }
        if (SDataAbstracts.NEW_IMPLICIT == element || element instanceof RfFunction && ((RfFunction)element).isConstructor()) {
            return SDataVariable.of((ISDataType)SDataAbstracts.NEW, (boolean)false);
        }
        if (SIGNED_IMPLICIT == element) {
            return SIGNED;
        }
        if (UNSIGNED_IMPLICIT == element) {
            return UNSIGNED;
        }
        if (CONST_IMPLICIT == element) {
            return CONST;
        }
        if (LITERAL_STRING_DUMMY == element) {
            return LITERAL_STRING_VARIABLE;
        }
        if (EMPTY_QUEUE_DUMMY == element) {
            return SDataVariable.of((ISDataType)EMPTY_QUEUE, (boolean)false);
        }
        if (element instanceof RfPredefinedScalarType) {
            ISDataType possible;
            ISDataType possiblePredefined2;
            int isPacked = 0;
            byte sign = 0;
            if (element instanceof RfBitVectorScalarType) {
                sign = ((RfBitVectorScalarType)element).getSign();
                element = ((RfBitVectorScalarType)element).getScalarWithDefaultSign();
                isPacked = 1;
            }
            if ((possiblePredefined2 = SDataAbstracts.getCachedScalarDataType((ISDataType)(possible = SDataType.of(element, sign, isPacked)))) != SDataAbstracts.UNDEFINED) {
                possible = possiblePredefined2;
            }
            return isVariable ? SDataVariable.of((ISDataType)possible, (boolean)isFinal) : possible;
        }
        int[] signing = new int[1];
        RfTypeAlias typeAlias = null;
        boolean reducedChecks = elabContext == null || elabContext.isReducedChecks();
        IRfNamedElement assocType = element;
        if (element instanceof RfTypeAlias || element instanceof RfField || element instanceof RfFunction) {
            AssociatedTypeInfo typeInfo = AssociatedTypeInfo.get((RfAssociatedType)element, scope, elabContext, signing, reducedChecks);
            assocType = typeInfo.getResolvedType();
            typeAlias = typeInfo.getAlias();
        }
        if (reducedChecks && assocType instanceof IRfSpecializedType) {
            assocType = ((IRfSpecializedType)assocType).getGenericElement();
        } else if (reducedChecks && element instanceof RfComputedStruct) {
            assocType = ((RfComputedStruct)assocType).getOriginal();
        }
        if (assocType instanceof RfBitVectorScalarType) {
            signing[0] = ((RfBitVectorScalarType)assocType).getSign();
            assocType = ((RfBitVectorScalarType)assocType).getScalarWithDefaultSign();
        }
        if ((undefinedData = this.isUndefinedElement(assocType, field != null)) != null) {
            return undefinedData;
        }
        if (element instanceof RfConstraint) {
            return SDataType.of(assocType, signing[0], 0);
        }
        DataType dataType = typeDataType = element instanceof RfField || element instanceof RfFunction ? ((RfAssociatedType)element).getDataType() : null;
        if (element instanceof RfModportPort && assocType instanceof RfListType) {
            typeDataType = ((RfListType)assocType).getDataType();
        }
        if (typeDataType == null && assocType instanceof RfAssociatedType) {
            typeDataType = ((RfAssociatedType)assocType).getDataType();
        }
        ISDataAbstract enumType = null;
        if (assocType instanceof RfStruct && ((RfStruct)assocType).isEnum() && (enumType = this.transform(((RfStruct)assocType).getEnumBaseType(), scope, elabContext, visited, isFinal, isVariable, dimensionsWithMacros, isNetAlias, isIrunRNMTech)) instanceof SDataType && SDataUtils.getUndefinedDataType((ISDataAbstract)enumType) == null) {
            signing[0] = ((SDataType)enumType).getSign();
        }
        ISDataType cachedListBaseElementType = SDataAbstracts.UNDEFINED;
        DataType cachedListNoUnpackedDimenionDataType = null;
        int packedDimension = 0;
        int unpackedDimension = 0;
        boolean hasNonFixedSizeDimensions = false;
        boolean bl = isUserDefinedNettypeElement = isIrunRNMTech && isNetAlias;
        if (assocType instanceof RfListType) {
            ISDataType baseElementPossible;
            RfTypeAlias baseElementTypeAlias = null;
            DataType baseElementDataType = null;
            int[] baseElementSigning = new int[1];
            byte baseElementListPackedSign = 0;
            IRfNamedElement baseElementTypeForList = assocType;
            while (baseElementTypeForList instanceof RfListType) {
                baseElementDataType = ((RfListType)baseElementTypeForList).getDataType();
                if (baseElementDataType != null && baseElementDataType.getUnpackedDimension() != null) {
                    ++unpackedDimension;
                    if (RfListType.isNotFixedArray((IRfScopeElement)baseElementTypeForList)) {
                        hasNonFixedSizeDimensions = true;
                    }
                } else if (baseElementDataType != null && baseElementDataType.getPackedDimension() != null) {
                    if (cachedListNoUnpackedDimenionDataType == null) {
                        cachedListNoUnpackedDimenionDataType = baseElementDataType;
                    }
                    ++packedDimension;
                }
                if (baseElementTypeForList instanceof RfComputedListType) {
                    baseElementListPackedSign = ((RfComputedListType)baseElementTypeForList).getPackedSign();
                } else if (baseElementTypeForList instanceof RfListType) {
                    DataType dataType2 = ((RfListType)baseElementTypeForList).getDataType();
                    baseElementListPackedSign = dataType2 != null ? dataType2.getSign() : (byte)0;
                }
                AssociatedTypeInfo typeInfo = AssociatedTypeInfo.get((RfListType)baseElementTypeForList, scope, elabContext, baseElementSigning, reducedChecks);
                baseElementTypeForList = typeInfo.getResolvedType();
                baseElementTypeAlias = typeInfo.getAlias();
                if (reducedChecks && baseElementTypeForList instanceof IRfSpecializedType) {
                    baseElementTypeForList = ((IRfSpecializedType)baseElementTypeForList).getGenericElement();
                } else if (reducedChecks && baseElementTypeForList instanceof RfComputedStruct) {
                    baseElementTypeForList = ((RfComputedStruct)baseElementTypeForList).getOriginal();
                }
                ISDataType undefinedData2 = this.isUndefinedElement(baseElementTypeForList, true);
                if (undefinedData2 == null) continue;
                return undefinedData2;
            }
            int isPacked = 0;
            if (baseElementTypeForList instanceof RfStruct) {
                isPacked = isUserDefinedNettypeElement ? 2 : (((RfStruct)baseElementTypeForList).isPacked() ? 1 : 0);
            } else if (baseElementTypeForList instanceof RfListType) {
                isPacked = isUserDefinedNettypeElement ? 2 : (packedDimension != 0 && unpackedDimension == 0 ? 1 : 0);
            } else if (baseElementTypeForList instanceof RfBitVectorScalarType) {
                int n = isPacked = isUserDefinedNettypeElement ? 2 : 1;
            }
            if (baseElementTypeForList instanceof RfBitVectorScalarType) {
                baseElementSigning[0] = baseElementListPackedSign != 0 ? baseElementListPackedSign : ((RfBitVectorScalarType)baseElementTypeForList).getSign();
                baseElementTypeForList = ((RfBitVectorScalarType)baseElementTypeForList).getScalarWithDefaultSign();
            }
            ISDataAbstract baseElementEnumType = null;
            if (baseElementTypeForList instanceof RfStruct && ((RfStruct)baseElementTypeForList).isEnum()) {
                baseElementEnumType = this.transform(((RfStruct)baseElementTypeForList).getEnumBaseType(), scope, elabContext, visited, isFinal, isVariable, dimensionsWithMacros, isNetAlias, isIrunRNMTech);
            }
            cachedListBaseElementType = SDataType.of(baseElementTypeForList, baseElementSigning[0], isPacked);
            cachedListBaseElementType.setAliasType((IRfTypeAliasElement)baseElementTypeAlias);
            if (baseElementEnumType instanceof SDataType) {
                cachedListBaseElementType.setEnumElementType((ISDataType)((SDataType)baseElementEnumType));
            }
            if ((baseElementPossible = SDataAbstracts.getCachedScalarDataType((ISDataType)cachedListBaseElementType)) != SDataAbstracts.UNDEFINED) {
                cachedListBaseElementType = baseElementPossible;
            }
            if (cachedListNoUnpackedDimenionDataType == null && baseElementDataType != null) {
                cachedListNoUnpackedDimenionDataType = baseElementDataType.copy();
                cachedListNoUnpackedDimenionDataType.setUnpackedDimension(null);
            }
        } else if (!STransformer.checkValidType(assocType) && !(element instanceof RfClockingBlock)) {
            return SDataAbstracts.UNDEFINED;
        }
        if (typeDataType != null && "ground".equals(typeDataType.getNetType())) {
            return SDataAbstracts.UNDEFINED;
        }
        int isPacked = 0;
        if (assocType instanceof RfStruct) {
            isPacked = isUserDefinedNettypeElement ? 2 : (((RfStruct)assocType).isPacked() ? 1 : 0);
        } else if (assocType instanceof RfListType) {
            isPacked = packedDimension != 0 && unpackedDimension == 0 ? 1 : 0;
        } else if (assocType instanceof RfBitVectorScalarType) {
            isPacked = 1;
        }
        if (isPacked == 1 && cachedListBaseElementType != SDataAbstracts.UNDEFINED) {
            signing[0] = cachedListBaseElementType.getSign();
        }
        ISDataType possible = SDataType.of(assocType, signing[0], isPacked);
        possible.setNofPackedDimensions(packedDimension);
        possible.setNofUnpackedDimensions(unpackedDimension);
        possible.setHasOnlyFixedSizeDimensions(unpackedDimension > 0 && !hasNonFixedSizeDimensions);
        possible.setCachedListBaseElementType(cachedListBaseElementType);
        possible.setCachedListNoUnpackedDimensionDataType((IDataType)cachedListNoUnpackedDimenionDataType);
        possible.setAliasType((IRfTypeAliasElement)typeAlias);
        if (enumType instanceof SDataType) {
            possible.setEnumElementType((ISDataType)((SDataType)enumType));
        }
        if ((possiblePredefined = SDataAbstracts.getCachedScalarDataType((ISDataType)possible)) != SDataAbstracts.UNDEFINED) {
            possible = possiblePredefined;
        }
        if (possible == VOID_DATA_TYPE) {
            return SDataVariable.of((ISDataType)VOID_DATA_TYPE, (IRfNamedElement)element, (boolean)false);
        }
        if (element instanceof RfFunction || element instanceof RfClockingBlock || element instanceof RfModportPort || element instanceof RfDuplicate) {
            return SDataVariable.of((ISDataType)possible, (boolean)isFinal);
        }
        if (element instanceof RfField) {
            return SDataVariable.of((ISDataType)possible, (IRfNamedElement)element, (boolean)isFinal);
        }
        if (isVariable) {
            return SDataVariable.of((ISDataType)possible, (boolean)isFinal);
        }
        return possible;
    }

    private ISDataType isUndefinedElement(IRfNamedElement assocType, boolean isVariable) {
        if (assocType == null || !(assocType instanceof RfNamedElement)) {
            return SDataAbstracts.UNDEFINED;
        }
        if (assocType instanceof RfField && ((RfField)assocType).isTypeParameter()) {
            return isVariable ? SDataAbstracts.UNDEFINED : SDataAbstracts.TYPE_UNDEFINED;
        }
        return null;
    }

    public static RfField resolveImplicit(String name, IRfNamedElement scope) {
        IRfNamedElement result = scope.getLocalMember(DECLARATION_FIELD_OR_PORT, name, null);
        return result instanceof RfField ? (RfField)result : null;
    }

    public SDataTypeCategory getCategory(ISDataAbstract dataType) {
        IRfNamedElement type;
        ISDataType data;
        block40: {
            data = SDataUtils.getDataType((ISDataAbstract)dataType);
            if (data == null) {
                return SDataTypeCategory.UNKNOWN;
            }
            if (dataType == SDataAbstracts.ILLEGAL) {
                return SDataTypeCategory.ILLEGAL;
            }
            if (dataType == SDataAbstracts.NON_STANDARD) {
                return SDataTypeCategory.ILLEGAL;
            }
            if (dataType == SDataAbstracts.UNDEFINED || dataType == SDataAbstracts.TYPE_UNDEFINED || dataType == SDataAbstracts.PARAMETER_UNTYPED) {
                return SDataTypeCategory.UNKNOWN;
            }
            if (data == LITERAL_STRING_DATA_TYPE) {
                return SDataTypeCategory.LITERAL_STRING;
            }
            if (data == SDataAbstracts.NEW) {
                return SDataTypeCategory.NEW;
            }
            if (data == SDataAbstracts.NULL) {
                return SDataTypeCategory.NULL;
            }
            if (data == VOID_DATA_TYPE) {
                return SDataTypeCategory.VOID;
            }
            if (data == SET_DATA_TYPE) {
                return SDataTypeCategory.SET;
            }
            if (data == SIGNED || data == UNSIGNED || data == CONST) {
                return SDataTypeCategory.NUMERIC;
            }
            type = data.getType();
            if (type instanceof RfPredefinedClass && "interface".equals(type.getName())) {
                return SDataTypeCategory.GENERIC_INTERFACE;
            }
            if (type instanceof RfClass) {
                return SDataTypeCategory.CLASS;
            }
            if (type instanceof RfInterface) {
                return SDataTypeCategory.INTERFACE;
            }
            if (type instanceof RfModport) {
                return SDataTypeCategory.MODPORT;
            }
            if (type instanceof RfConstraint) {
                return SDataTypeCategory.CONSTRAINT;
            }
            if (data.getNofUnpackedDimensions() != 0 || data.getNofPackedDimensions() != 0) {
                if (RfListType.isQueue((IRfScopeElement)type) || EMPTY_QUEUE_DUMMY == type) {
                    return SDataTypeCategory.QUEUE;
                }
                if (RfListType.isAssociativeArray((IRfScopeElement)type)) {
                    return SDataTypeCategory.ASSOCIATIVE_ARRAY;
                }
                if (RfListType.isDynamicArray((IRfScopeElement)type)) {
                    return SDataTypeCategory.DYNAMIC_ARRAY;
                }
                if (data.isPacked()) {
                    return SDataTypeCategory.FIXED_SIZE_ARRAY_PACKED;
                }
                return SDataTypeCategory.FIXED_SIZE_ARRAY_UNPACKED;
            }
            if (type instanceof RfCovergroup) {
                return SDataTypeCategory.COVERGROUP;
            }
            if (type instanceof RfClockingBlock) {
                return SDataTypeCategory.CLOCKING_BLOCK;
            }
            if (!(type instanceof RfStruct)) break block40;
            switch (((RfStruct)type).getParticularType()) {
                case "enum": {
                    return SDataTypeCategory.ENUM;
                }
                case "struct": {
                    return data.isPacked() ? SDataTypeCategory.STRUCT_PACKED : SDataTypeCategory.STRUCT_UNPACKED;
                }
                case "union": {
                    return data.isPacked() ? SDataTypeCategory.UNION_PACKED : SDataTypeCategory.UNION_UNPACKED;
                }
            }
            return SDataTypeCategory.UNKNOWN;
        }
        if (type instanceof RfPredefinedScalarType && type.getName().equals("enum")) {
            return SDataTypeCategory.ENUM;
        }
        if (type instanceof RfPredefinedEventType) {
            return SDataTypeCategory.EVENT;
        }
        if (type instanceof RfComputedListType) {
            return SDataTypeCategory.NUMERIC;
        }
        if (type instanceof RfBitVectorScalarType) {
            return SDataTypeCategory.NUMERIC;
        }
        if (type instanceof RfPackage) {
            return SDataTypeCategory.PACKAGE;
        }
        return SDataAbstracts.getDataTypeCategory((ISDataType)data);
    }

    public static final RfHidImplicit makeStandInImplicit(String name, int type) {
        if (name == null) {
            return null;
        }
        RfHidImplicit implicit = RfHidImplicit.makeImplicit(name, type);
        return implicit;
    }

    public static final RfHid makeStandInHid(String name, IRfNamedElement resolved, HidOccurrence occurrence, long qualifiers) {
        if (name == null) {
            return null;
        }
        RfHid hid = RfHid.create(name, null, resolved, occurrence, null);
        hid.addQualifier(qualifiers);
        return hid;
    }

    public static final Supplier<Hid> makeHidSupplier(IHidObject hidObject, IRfNamedElement scope, int offset, int virtualOffset, int line, long qualifiers) {
        if (hidObject == null) {
            return null;
        }
        IHid hidFrom = HidUtils.getHidFrom((IHidObject)hidObject);
        if (hidFrom == null) {
            return null;
        }
        if (hidFrom.getParentHid() == null) {
            return () -> {
                IRfNamedElement element = null;
                if (HidUtils.isHidImplicit((IHidObject)hidFrom) && ((HidImplicit)hidFrom).isID() && scope != null) {
                    element = STransformer.resolveImplicit(hidFrom.getName(), scope);
                } else if (HidUtils.isHid((IHidObject)hidFrom)) {
                    element = ((Hid)hidFrom).getElement();
                }
                if (element == null) {
                    return null;
                }
                HidOccurrence occurrence = new HidOccurrence(offset, virtualOffset, line, qualifiers, null);
                return STransformer.makeStandInHid(element.getName(), element, occurrence, qualifiers);
            };
        }
        if (!(hidFrom instanceof RfHid)) {
            return null;
        }
        return () -> ((RfHid)hidFrom).upwardsCopy(true);
    }

    @NotNull
    public static RfHidAccess makeStandInAccess(Hid prev, Hid next, int accessKind) {
        RfHidAccess access = new RfHidAccess(accessKind, null, null);
        prev.addAccess((HidAccess)access);
        if (next != null) {
            access.addHid(next);
        }
        return access;
    }

    @NotNull
    public static RfHidAccess makeStandInAccess(Hid prev, Hid next, List<IHidObject> selects, int accessKind) {
        RfHidAccess access = new RfHidAccess(accessKind, (ListContainer<IHidObject>)OptimizedUtils.listContainerCreate(selects, (boolean)true), null);
        prev.addAccess((HidAccess)access);
        if (next != null) {
            access.addHid(next);
        }
        return access;
    }

    @NotNull
    public static RfHidAccessArgs makeStandInAccessArgs(Hid prev, List<? extends IHidObject> arguments) {
        RfHidAccessArgs accessArgs = new RfHidAccessArgs(Integer.MIN_VALUE, null, arguments, null, null);
        prev.addAccess((HidAccess)accessArgs);
        return accessArgs;
    }

    public static final RfHidOperator makeStandInOperator(IHidObject lhSide, Collection<? extends IHidObject> rhSide, int type, IHidOperatorConstants.OperatorKind kind, String text, HidOperatorOccurrence occurrence, long qualifiers) {
        if (lhSide == null || rhSide == null) {
            return null;
        }
        RfHidOperator operator = RfHidOperator.create(type, kind, text, occurrence, null);
        operator.addLHValue(lhSide);
        for (IHidObject iHidObject : rhSide) {
            operator.addRHValue(iHidObject);
        }
        operator.addQualifier(qualifiers);
        return operator;
    }

    private static HidOperator makeStandInDefparamOperator(ElementPath hierarchyParamPath, String value, int offset) {
        if (hierarchyParamPath == null || hierarchyParamPath.isEmpty()) {
            return null;
        }
        Number number = DVTStringUtil.parseNumberVLOG((String)value, null, (boolean)false);
        String implicitText = number == null ? "\"" + value + "\"" : value;
        int implicitKind = number == null ? 557 : 282;
        RfHidImplicit implicitRhSide = STransformer.makeStandInImplicit(implicitText, implicitKind);
        RfHid lhSide = null;
        String[] segments = hierarchyParamPath.getSegments();
        int i = 0;
        while (i < segments.length) {
            String part = segments[i];
            if (lhSide == null) {
                lhSide = STransformer.makeStandInHid(part, null, HidOccurrence.DUMMY_OCCURRENCE, 0L);
            } else {
                RfHid newHid = STransformer.makeStandInHid(part, null, HidOccurrence.DUMMY_OCCURRENCE, 0L);
                STransformer.makeStandInAccess(lhSide, newHid, 0);
                lhSide = newHid;
            }
            ++i;
        }
        HidOperatorOccurrence dummyHidOperatorOccurrence = new HidOperatorOccurrence(offset, -1, -1, 0L, null);
        RfHidOperator equalsOp = STransformer.makeStandInOperator((IHidObject)lhSide, Collections.singletonList(implicitRhSide), 498, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", dummyHidOperatorOccurrence, 0L);
        return equalsOp;
    }

    public ISDataAbstract transform(Collection<? extends IRfNamedElement> elements, boolean isFinal, boolean isAccess) {
        return null;
    }

    public HidOperator transformAssignmentPattern(HidOperator assignPattern, ISContext context, IRfNamedElement initialScope) {
        return HidUtils.transformAssignmentPattern((HidOperator)assignPattern, (ISContext)context, (IRfNamedElement)initialScope, (boolean)true, (IHidBuilders)BUILDERS);
    }

    @NotNull
    public List<HidOperator> transformAssociation(HidOperator association, final IRfNamedElement lhSideElement, IRfNamedElement initialScope) {
        HidOperatorOccurrence occurrence = association.getOccurrence();
        ISContext context = new ISContext(){

            public IRfNamedElement calculateCorrespondentByPosition(int position) {
                return lhSideElement;
            }

            public IRfNamedElement calculateCorrespondentByName(String name, IHidObject originalFormalPart, IRfNamedElement initialScope) {
                return lhSideElement;
            }
        };
        int index = 0;
        ArrayList collected = new ArrayList();
        boolean success = HidUtils.transformAssociation(null, (IHidObject)association, (int)index, (ISContext)context, (IRfNamedElement)initialScope, (HidOperatorOccurrence)occurrence, (long)association.getQualifiers(), (boolean)true, collected, (IHidBuilders)BUILDERS);
        return success ? collected : Collections.emptyList();
    }

    public List<HidOperator> transformImplicitNamedConnection(HidOperator implicitConnection, final IRfNamedElement lhSideElement, final IRfNamedElement rhSideElement, HidOperatorOccurrence operatorOccurrence) {
        if (lhSideElement == null) {
            return Collections.emptyList();
        }
        ISContext context = new ISContext(){

            public IRfNamedElement calculateCorrespondentByName(String name, IHidObject originalFormalPart, IRfNamedElement initialScope) {
                return lhSideElement;
            }

            public IRfNamedElement getImplicitConnectionValue() {
                return rhSideElement;
            }
        };
        String correspondentName = lhSideElement.getName();
        long operatorQualifiers = implicitConnection != null ? implicitConnection.getQualifiers() : operatorOccurrence.getQualifiers();
        ArrayList collected = new ArrayList();
        boolean success = HidUtils.transformImplicitAssociation((HidOperator)implicitConnection, (String)correspondentName, (ISContext)context, (HidOperatorOccurrence)operatorOccurrence, (long)operatorQualifiers, (boolean)true, collected, (IHidBuilders)BUILDERS);
        return success ? collected : Collections.emptyList();
    }

    private static class AssociatedTypeInfo {
        private RfTypeAlias aliasType;
        private IRfNamedElement associatedType;

        private AssociatedTypeInfo() {
        }

        public static AssociatedTypeInfo get(RfAssociatedType element, IRfNamedElement scope, ELWidthCheckContext elabContext, int[] signing, boolean reducedChecks) {
            AssociatedTypeInfo result = new AssociatedTypeInfo();
            if (element == null) {
                return result;
            }
            RfNamedElement elementEnclosing = element.getEnclosingScope();
            RfTypesResolver typesResolver = null;
            if (elabContext != null) {
                ElementPath hierarchyPath = elabContext.getFirstPath((IRfScopeElement)elementEnclosing);
                if (scope instanceof IRfInstanceElement) {
                    scope = ((IRfInstanceElement)scope).getGenericDesign(hierarchyPath);
                }
                typesResolver = RfTypesResolver.create((IRfScopeElement)scope, elabContext.getEvaluator((IRfScopeElement)elementEnclosing).getLastValueContainer(), hierarchyPath, elabContext.getManager(), 0, false);
            } else {
                if (scope instanceof IRfInstanceElement) {
                    scope = ((IRfInstanceElement)scope).getGenericDesign(null);
                }
                typesResolver = RfTypesResolver.create((IRfScopeElement)scope, null, element.getRfProject() != null ? element.getRfProject().getNonELManager() : null, 0);
            }
            if (element instanceof RfPredefinedFunction && scope instanceof RfComputedStruct) {
                typesResolver.update(scope, null, true, false);
            }
            RfAssociatedType rfAssociatedType = element instanceof RfTypeAlias ? element : (result.associatedType = reducedChecks ? element.getAssociatedTypeNoLastLevelParams(typesResolver) : element.getAssociatedType(typesResolver));
            if (result.associatedType instanceof RfTypeAlias) {
                result.aliasType = (RfTypeAlias)result.associatedType;
                result.associatedType = ((RfTypeAlias)result.associatedType).getTranslatedType(typesResolver, reducedChecks, null, signing);
            }
            return result;
        }

        public RfTypeAlias getAlias() {
            return this.aliasType;
        }

        public IRfNamedElement getResolvedType() {
            return this.associatedType;
        }
    }
}

