/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.util;

import antlr.CharBuffer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class CharBufferCacher {
    private CharBuffer cachedCharBuffer;
    private Reader cachedFileReader;
    private String cachedFilePath;
    private int cachedMarker;
    private static volatile CharBufferCacher instance;
    private static final Object latch;

    static {
        latch = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharBufferCacher getInstance() {
        if (instance == null) {
            Object object = latch;
            synchronized (object) {
                if (instance == null) {
                    instance = new CharBufferCacher();
                }
            }
        }
        return instance;
    }

    public CharBuffer getBuffer(String fileAbsolutePath) throws FileNotFoundException {
        if (this.cachedFilePath != null && this.cachedFilePath.equals(fileAbsolutePath)) {
            this.cachedCharBuffer.rewind(this.cachedMarker);
            this.cachedMarker = this.cachedCharBuffer.mark();
            return this.cachedCharBuffer;
        }
        this.clearCache();
        this.cachedFileReader = new BufferedReader(new FileReader(fileAbsolutePath));
        this.cachedCharBuffer = new CharBuffer(this.cachedFileReader);
        this.cachedFilePath = fileAbsolutePath;
        this.cachedMarker = this.cachedCharBuffer.mark();
        return this.cachedCharBuffer;
    }

    public void clearCache() {
        if (this.cachedFileReader != null) {
            DVTUtilsCommon.INSTANCE.closeClosable((Closeable)this.cachedFileReader);
        }
        this.cachedFilePath = null;
        this.cachedCharBuffer = null;
        this.cachedFileReader = null;
    }
}

