/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.model.reflection.RfEncryptedCodeAutoManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.DVTCustomToken;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogUtil;

public class EncryptedCodeAutoWrapper {
    private boolean fIsExternPureFunction;
    private boolean fIsTypedefClass;
    private boolean fIsInterfaceClass;
    private boolean fIsVirtualInterface;
    private boolean fIsImportExportDPIFunction;
    private boolean fIsCovergroupFunction;
    private VlogUtil fUtil;
    private Deque<DVTCustomToken> fTokenOpenedScopesStack;
    private Queue<DVTCustomToken> fWaitingTokenQueue;
    private Map<Integer, Integer> fStartEndElementsTokenTypes;
    private Map<Integer, String> fEndElementsTokenTypes;

    public EncryptedCodeAutoWrapper(VlogUtil util) {
        this.fUtil = util;
        this.fTokenOpenedScopesStack = new ArrayDeque<DVTCustomToken>();
        this.fWaitingTokenQueue = new LinkedList<DVTCustomToken>();
        this.fStartEndElementsTokenTypes = RfEncryptedCodeAutoManager.getStartEndElementsTokenTypes();
        this.fEndElementsTokenTypes = RfEncryptedCodeAutoManager.getEndElementsTokenTypes();
    }

    public void updateNoScopeOpenedCases(DVTCustomToken nextToken) {
        try {
            if (!this.fIsExternPureFunction && nextToken.getType() == 99 || nextToken.getType() == 181) {
                this.fIsExternPureFunction = true;
            } else if (!RfEncryptedCodeAutoManager.isFunctionOrTaskToken(nextToken)) {
                this.fIsExternPureFunction = false;
            }
            if (!this.fIsCovergroupFunction && nextToken.getType() == 61) {
                this.fIsCovergroupFunction = true;
            } else if (this.fIsCovergroupFunction && nextToken.getType() == 83) {
                this.fIsCovergroupFunction = false;
            }
            if (!(this.fIsImportExportDPIFunction || nextToken.getType() != 121 && nextToken.getType() != 97)) {
                this.fIsImportExportDPIFunction = true;
            } else if (!RfEncryptedCodeAutoManager.isDPIToken(nextToken)) {
                this.fIsImportExportDPIFunction = false;
            }
            if (!this.fIsTypedefClass && nextToken.getType() == 240) {
                this.fIsTypedefClass = true;
            } else if (!RfEncryptedCodeAutoManager.isClassToken(nextToken)) {
                this.fIsTypedefClass = false;
            }
            if (!this.fIsInterfaceClass && nextToken.getType() == 133) {
                this.fIsInterfaceClass = true;
            } else if (!RfEncryptedCodeAutoManager.isClassToken(nextToken)) {
                this.fIsInterfaceClass = false;
            }
            if (!this.fIsVirtualInterface && nextToken.getType() == 249) {
                this.fIsVirtualInterface = true;
            } else if (nextToken.getType() != 133) {
                this.fIsVirtualInterface = false;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean shouldAddStartToken(DVTCustomToken nextToken, Deque<DVTCustomToken> fTokenOpenedScopesStack) {
        DVTCustomToken peek;
        if ((nextToken.getType() == 108 || nextToken.getType() == 223) && (this.fIsExternPureFunction || this.fIsImportExportDPIFunction || this.fIsCovergroupFunction)) {
            return false;
        }
        if (nextToken.getType() == 133 && this.fIsVirtualInterface) {
            return false;
        }
        if (RfEncryptedCodeAutoManager.isClassToken(nextToken) && this.fIsTypedefClass) {
            return false;
        }
        if (RfEncryptedCodeAutoManager.isClassToken(nextToken) && this.fIsInterfaceClass && !fTokenOpenedScopesStack.isEmpty() && (peek = fTokenOpenedScopesStack.peek()).getType() == 133) {
            fTokenOpenedScopesStack.pop();
        }
        return true;
    }

    private void reportAutoClosedWarning(DVTCustomToken warningMessageToken) {
        try {
            RfProject rfProject = this.fUtil.getRfProject();
            if (rfProject == null) {
                return;
            }
            IProject project = rfProject.getProject();
            if (project == null) {
                return;
            }
            boolean debug = false;
            if (this.fUtil.getEncryptedCodeAutoFilter() != null) {
                debug = this.fUtil.getEncryptedCodeAutoFilter().isDebug();
            }
            if (debug) {
                this.reportAsymmetricalEncryptionWarning(warningMessageToken, project);
            } else if (this.fUtil.getEncryptedCodeAutoFilter() != null) {
                this.fUtil.getEncryptedCodeAutoFilter().incrementClosedScopes();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void reportAsymmetricalEncryptionWarning(DVTCustomToken token, IProject project) {
        int line = token.getLine();
        String text = token.getText();
        VlogFileInstance fileInstance = token.getFileInstance();
        if (fileInstance == null) {
            return;
        }
        ParserPath parserPath = fileInstance.getParserPath();
        if (parserPath == null) {
            return;
        }
        DVTBuildConsoleRegistry.getConsole((IProject)project).print("Encrypted code auto-close: " + text + "\n\t in file " + parserPath.path + " at line " + line);
    }

    private DVTCustomToken makeToken(DVTCustomToken nextToken, int literalEndclass, String literalText, int tokenOffset, DVTCustomToken endOfFileToken) {
        DVTCustomToken dvtCustomToken = new DVTCustomToken(literalEndclass, literalText);
        dvtCustomToken.setFileInstance(nextToken.getFileInstance());
        dvtCustomToken.setFilename(nextToken.getFilename());
        dvtCustomToken.setOffset(endOfFileToken != null ? endOfFileToken.getOffset() : tokenOffset);
        this.reportAutoClosedWarning(nextToken);
        return dvtCustomToken;
    }

    private boolean validSameNestedScopes(DVTCustomToken nextToken) {
        return nextToken.getType() == 37;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DVTCustomToken handleCurrentMissingToken(DVTCustomToken nextToken, DVTCustomToken fLastValidEofTokenLT, ParserPath currentParserPath) {
        try {
            DVTCustomToken dvtCustomToken;
            Integer endTokenTypee;
            DVTCustomToken peek;
            if (this.fStartEndElementsTokenTypes.containsKey(nextToken.getType()) && this.shouldAddStartToken(nextToken, this.fTokenOpenedScopesStack)) {
                if (!this.fTokenOpenedScopesStack.isEmpty()) {
                    peek = this.fTokenOpenedScopesStack.peek();
                    if (this.fUtil.isEncrypted(peek.getParserPath()) && peek.getType() == nextToken.getType() && !this.validSameNestedScopes(nextToken)) {
                        if (currentParserPath == null) return null;
                        if (!currentParserPath.equals((Object)peek.getParserPath())) {
                            return null;
                        }
                        this.fWaitingTokenQueue.add(nextToken);
                        Integer peekEndTokenType = this.fStartEndElementsTokenTypes.get(peek.getType());
                        this.fTokenOpenedScopesStack.pop();
                        this.fTokenOpenedScopesStack.push(nextToken);
                        return this.makeToken(peek, peekEndTokenType, this.fEndElementsTokenTypes.get(peekEndTokenType), nextToken.getOffset(), fLastValidEofTokenLT);
                    }
                    this.fTokenOpenedScopesStack.push(nextToken);
                } else {
                    this.fTokenOpenedScopesStack.push(nextToken);
                }
            }
            if (this.fTokenOpenedScopesStack.isEmpty()) return null;
            if (!this.fEndElementsTokenTypes.containsKey(nextToken.getType())) return null;
            peek = this.fTokenOpenedScopesStack.peek();
            Integer endTokenType = this.fStartEndElementsTokenTypes.get(peek.getType());
            if (endTokenType == null) {
                return null;
            }
            if (endTokenType.intValue() == nextToken.getType()) {
                this.fTokenOpenedScopesStack.pop();
                return null;
            }
            if (!this.fUtil.isEncrypted(peek.getParserPath())) return null;
            Iterator<DVTCustomToken> iterator = this.fTokenOpenedScopesStack.iterator();
            do {
                if (iterator.hasNext()) continue;
                return null;
            } while ((endTokenTypee = this.fStartEndElementsTokenTypes.get((dvtCustomToken = iterator.next()).getType())) == null || endTokenTypee.intValue() != nextToken.getType());
            if (currentParserPath == null) return null;
            if (!currentParserPath.equals((Object)peek.getParserPath())) {
                return null;
            }
            this.fWaitingTokenQueue.add(nextToken);
            this.fTokenOpenedScopesStack.pop();
            return this.makeToken(peek, endTokenType, this.fEndElementsTokenTypes.get(endTokenType), nextToken.getOffset() - 1, fLastValidEofTokenLT);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DVTCustomToken getMissingAutoClosedScopeEncryptionToken(boolean atEOF, DVTCustomToken lastValidEofTokenLT, ParserPath currentParserPath) {
        try {
            if (!this.fWaitingTokenQueue.isEmpty()) {
                DVTCustomToken tokenBufferToken = this.fWaitingTokenQueue.peek();
                if (!this.fUtil.hasEncryptedCodeAutoPath(tokenBufferToken.getParserPath())) {
                    return null;
                }
                if (this.fTokenOpenedScopesStack.isEmpty()) {
                    return this.fWaitingTokenQueue.poll();
                }
                DVTCustomToken lexerStackToken = this.fTokenOpenedScopesStack.peek();
                Integer startEndTokenType = this.fStartEndElementsTokenTypes.get(lexerStackToken.getType());
                if (startEndTokenType != null && startEndTokenType.intValue() == tokenBufferToken.getType()) {
                    this.fTokenOpenedScopesStack.pop();
                    return this.fWaitingTokenQueue.poll();
                }
                if (!this.fEndElementsTokenTypes.containsKey(tokenBufferToken.getType())) return this.fWaitingTokenQueue.poll();
                if (!this.fUtil.hasEncryptedCodeAutoPath(lexerStackToken.getParserPath())) return null;
                if (!this.fUtil.isEncrypted(lexerStackToken.getParserPath())) return null;
                boolean bl = true;
                boolean isEncryptedAutoClosed = bl;
                if (!isEncryptedAutoClosed) {
                    return null;
                }
                Integer endTokenType = this.fStartEndElementsTokenTypes.get(lexerStackToken.getType());
                if (endTokenType == null) {
                    return null;
                }
                if (currentParserPath == null) return null;
                if (!currentParserPath.equals((Object)lexerStackToken.getParserPath())) {
                    return null;
                }
                String endTokenString = this.fEndElementsTokenTypes.get(endTokenType);
                this.fTokenOpenedScopesStack.pop();
                if (endTokenString == null) {
                    return null;
                }
                DVTCustomToken dVTCustomToken = this.makeToken(lexerStackToken, endTokenType, endTokenString, 0, lastValidEofTokenLT);
                return dVTCustomToken;
            }
            if (!atEOF) {
                return null;
            }
            if (this.fTokenOpenedScopesStack.isEmpty()) {
                return null;
            }
            DVTCustomToken token = this.fTokenOpenedScopesStack.peek();
            if (!this.fUtil.hasEncryptedCodeAutoPath(token.getParserPath())) return null;
            if (!this.fUtil.isEncrypted(token.getParserPath())) return null;
            boolean bl = true;
            boolean isEncryptedFile = bl;
            if (!isEncryptedFile) {
                return null;
            }
            if (currentParserPath == null) return null;
            if (!currentParserPath.equals((Object)token.getParserPath())) {
                return null;
            }
            int tokenType = token.getType();
            Integer endTokenType = this.fStartEndElementsTokenTypes.get(tokenType);
            if (endTokenType == null) {
                return null;
            }
            String endETokenString = this.fEndElementsTokenTypes.get(endTokenType);
            this.fTokenOpenedScopesStack.pop();
            if (endETokenString == null) {
                return null;
            }
            DVTCustomToken dVTCustomToken = this.makeToken(token, endTokenType, endETokenString, 0, lastValidEofTokenLT);
            return dVTCustomToken;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }
}

