/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.indexer.IIdentifierIndexerExtension;
import ro.amiq.dvt.model.indexer.IdentifierIndexerManager;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.model.indexer.IdentifierIndexer;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedClass;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.r2lparser.R2LTooltipManager;
import ro.amiq.vlogdt.ui.editor.VlogWordFinder;

public class RfBatchUtils {
    public static final String HIERARCHY_SEPARATOR = "::";
    private static final String NATURE_PREFIX = "ro.amiq.vlogdt.VlogNature ";
    private static final int MAX_LIMIT = 1000;
    private static RfElementCache fRfElementCache = new RfElementCache();

    public static RfNamedElement getNamedElementFromString(IProject project, String s) {
        return RfBatchUtils.getNamedElementFromString(project, s, false);
    }

    public static RfNamedElement getNamedElementFromString(IProject project, String s, boolean skipLibrary) {
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        if (s.startsWith("`")) {
            List<RfNamedElement> macros = rfProject.getMacrosWithPrefix(s.substring(1, s.length()), 1);
            if (macros != null && !macros.isEmpty()) {
                return macros.get(0);
            }
            return null;
        }
        String[] firstAndRest = RfElementPath.SPLIT_PATTERN.split(s = s.replace(".", " ").replace(HIERARCHY_SEPARATOR, " "), 2);
        RfLibrary library = rfProject.getLibraryWithPrefix(firstAndRest[0], 1);
        if (library != null) {
            if (firstAndRest.length == 1 || firstAndRest[1].isEmpty()) {
                return library;
            }
            return (RfNamedElement)RfElementPath.fromString((String)NATURE_PREFIX.concat(firstAndRest[1])).toNamedElement(project);
        }
        for (RfLibrary libraryCandidate : rfProject.getLibraries()) {
            String libraryCandidateSegment = skipLibrary ? "" : String.valueOf(libraryCandidate.getName()) + " ";
            IRfNamedElement result = RfElementPath.fromString((String)(NATURE_PREFIX + libraryCandidateSegment + s)).toNamedElement(project);
            if (result == null) continue;
            return (RfNamedElement)result;
        }
        return null;
    }

    public static String getScopeRelativeTo(IRfNamedElement element, IRfNamedElement relativeTo, boolean isExternMethodImplementation) {
        if (element == null || relativeTo == null) {
            return "";
        }
        if (relativeTo instanceof RfListType) {
            relativeTo = ((RfListType)relativeTo).getAssociatedType();
        }
        if (relativeTo == null) {
            return "";
        }
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<IRfNamedElement> differentScopes = new ArrayList<IRfNamedElement>();
        List<IRfNamedElement> elementScopeStack = RfBatchUtils.getScopeStack(element, false);
        List<IRfNamedElement> relativeToScopeStack = RfBatchUtils.getScopeStack(relativeTo, false);
        for (IRfNamedElement elementScope : relativeToScopeStack) {
            differentScopes.add(elementScope);
            if (!elementScopeStack.contains(elementScope)) continue;
            if (isExternMethodImplementation) break;
            differentScopes.remove(differentScopes.size() - 1);
            break;
        }
        if (differentScopes.isEmpty()) {
            return "";
        }
        IRfNamedElement member = element.getMember(relativeTo.getName(), null, null, true, true, true, true, false);
        if (member != null && member.equals(relativeTo) && !isExternMethodImplementation) {
            return "";
        }
        for (IRfNamedElement scope : differentScopes) {
            IRfNamedElement elementFoundInScope = element.getMember(scope.getName(), null, null, true, true, true, true, false);
            result.add(scope.getName());
            if (elementFoundInScope != null && elementFoundInScope.equals(scope)) break;
        }
        Collections.reverse(result);
        return DVTStringUtil.join(result, (String)HIERARCHY_SEPARATOR);
    }

    private static List<IRfNamedElement> getScopeStack(IRfNamedElement element, boolean reverseOrder) {
        ArrayList<IRfNamedElement> result = new ArrayList<IRfNamedElement>();
        IRfNamedElement parent = element;
        while ((parent = parent.getEnclosingScope()) != null) {
            if (parent instanceof IRfLibraryElement) break;
            if (parent instanceof IRfNamedElement) {
                result.add(parent);
                continue;
            }
            result.add(((IRfDefElement)parent).getNamedElement());
        }
        if (reverseOrder) {
            Collections.reverse(result);
        }
        return result;
    }

    private static Set<IRfNamedElement> getScopeSet(IRfNamedElement element, boolean includeLibrary) {
        HashSet<IRfNamedElement> result = new HashSet<IRfNamedElement>();
        IRfNamedElement parent = element;
        while ((parent = parent.getEnclosingScope()) != null) {
            if (parent instanceof IRfLibraryElement) {
                if (!includeLibrary) break;
                result.add(parent);
                break;
            }
            if (parent instanceof IRfNamedElement) {
                result.add(parent);
                continue;
            }
            result.add(((IRfDefElement)parent).getNamedElement());
        }
        return result;
    }

    public static RfWNamedElementAndScope getRfElement(RfProject rfProject, IFile file, IDocument document, int offset, IRfScope[] previousScope, boolean macroExpanded, DVTEditor textEditor) {
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
        if (parserPath == null) {
            return null;
        }
        return RfBatchUtils.getRfElement(rfProject, parserPath, document, offset, previousScope, macroExpanded, false, textEditor);
    }

    public static void clearCaches() {
        fRfElementCache = new RfElementCache();
    }

    public static IRfScopeElement getRfScope(RfProject rfProject, ParserPath parserPath, int offset) {
        RfFileDef rfFileDef = rfProject.getFile(parserPath);
        if (rfFileDef == null) {
            return null;
        }
        return rfFileDef.getScope(offset, true, true, null);
    }

    public static RfWNamedElementAndScope getRfElement(RfProject rfProject, ParserPath parserPath, IDocument document, int offset, IRfScope[] previousScope, boolean macroExpanded, boolean skipHidEngine, DVTEditor textEditor) {
        IRegion region;
        RfFileDef rfFileDef;
        block12: {
            block11: {
                try {
                    if (rfProject != null && parserPath != null && document != null) break block11;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            rfFileDef = rfProject.getFile(parserPath);
            if (rfFileDef != null) break block12;
            return null;
        }
        if (previousScope == null) {
            previousScope = new IRfScope[1];
        }
        IRfScope rfScope = null;
        if (previousScope[0] != null) {
            rfScope = previousScope[0];
        } else {
            previousScope[0] = rfScope = rfFileDef.getScope(offset, true, true, null);
        }
        RfInstance instance = null;
        if (rfScope instanceof RfFieldDef && ((RfFieldDef)rfScope).getNamedElement() instanceof RfInstance) {
            instance = (RfInstance)((RfFieldDef)rfScope).getNamedElement();
            rfScope = ((RfFieldDef)rfScope).getNamedElement().getEnclosingScope();
        }
        if ((region = VlogWordFinder.getDefault().getWordAtOffset(document, offset)) == null || region.getLength() == 0) {
            String text;
            String string = text = offset - 2 >= 0 && offset <= document.getLength() - 1 ? document.get(offset - 2, 2) : null;
            if (!".*".equals(text)) {
                return new RfWNamedElementAndScope(null, rfScope);
            }
        }
        fRfElementCache.setDocument(document);
        RfWNamedElementAndScope cachedElement = fRfElementCache.getCacheElement(region);
        if (cachedElement != null) {
            return cachedElement;
        }
        R2LTooltipManager manager = new R2LTooltipManager(textEditor, rfProject, rfScope, instance, rfFileDef.getParserPath(), document, offset, offset, null, false, macroExpanded, skipHidEngine);
        RfWNamedElementAndScope element = manager.getElement();
        fRfElementCache.putCacheElement(region, element);
        return element;
    }

    public static RfWNamedElementAndScope getRfElement(RfProject rfProject, ParserPath parserPath, IDocument document, int offset) {
        return RfBatchUtils.getRfElement(rfProject, parserPath, document, offset, null, false, false, null);
    }

    public static IRegion getMacroRegionAtOffset(RfProject rfProject, ParserPath parserPath, IDocument document, int offset, int limit) {
        return RfBatchUtils.getMacroRegionAtOffset(rfProject, parserPath, document, offset, limit, false, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IRegion getMacroRegionAtOffset(RfProject rfProject, ParserPath parserPath, IDocument document, int offset, int limit, boolean alwaysAssumeHasParams, boolean includeMacroParams) {
        try {
            if (offset < 0) return null;
            if (offset >= document.getLength()) {
                return null;
            }
            ITypedRegion region = RfBatchUtils.getTypedRegion(document, offset);
            if (region == null) {
                return null;
            }
            String regionType = region.getType();
            if (!regionType.equals("__dftl_partition_content_type") && !regionType.equals("__vlog_escaped_id")) {
                return null;
            }
            char ch = document.getChar(Math.max(0, offset));
            if (!Character.isJavaIdentifierPart(ch) && !Character.isJavaIdentifierPart(ch = ch == '`' ? document.getChar(Math.max(0, ++offset)) : document.getChar(Math.max(0, --offset)))) {
                return null;
            }
            int startOffset = 0;
            int endOffset = 0;
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, offset - 1), false);
            while (scanner.getOffset() > 0 && (ch = (char)scanner.read()) != '`') {
                if (!includeMacroParams) {
                    if (!Character.isJavaIdentifierPart(ch)) return null;
                }
                if (!includeMacroParams || RfBatchUtils.isMacroParamCharacter(ch)) continue;
                return null;
            }
            startOffset = scanner.getOffset();
            scanner = new DVTCharacterScanner(20, document, offset, true);
            while (ch != '\uffff' && Character.isJavaIdentifierPart(ch = (char)scanner.read())) {
            }
            endOffset = scanner.getOffset() - 1;
            if (!alwaysAssumeHasParams) {
                VlogMacroInfo macro = rfProject.getMacroBeforeLineInFile(document.get(startOffset + 1, endOffset - startOffset - 1), parserPath, document.getLineOfOffset(startOffset + 1) + 1);
                if (macro == null) {
                    return null;
                }
                if (!macro.hasParams()) {
                    return new Region(startOffset, endOffset - startOffset);
                }
            }
            int nested = 0;
            int characterNumber = 0;
            while (ch != '\uffff') {
                if (endOffset >= document.getLength()) {
                    return new Region(startOffset, endOffset - startOffset);
                }
                ++characterNumber;
                endOffset = scanner.getOffset();
                region = RfBatchUtils.getTypedRegion(document, endOffset - 1);
                if (region == null) {
                    ch = (char)scanner.read();
                    continue;
                }
                regionType = region.getType();
                if (!regionType.equals("__dftl_partition_content_type") && !regionType.equals("__vlog_escaped_id")) {
                    ch = (char)scanner.read();
                    continue;
                }
                if (nested == 0 && Character.isWhitespace(ch)) {
                    ch = (char)scanner.read();
                    continue;
                }
                if (nested == 0 && ch != '(') {
                    return new Region(startOffset, --endOffset - startOffset);
                }
                if (ch == ')' && nested < 1) {
                    return new Region(startOffset, --endOffset - startOffset);
                }
                if (ch == ')' && nested == 1) {
                    return new Region(startOffset, endOffset - startOffset);
                }
                if (ch == '(') {
                    ++nested;
                } else if (ch == ')') {
                    --nested;
                }
                if (nested == 0 && characterNumber >= limit) {
                    return new Region(startOffset, endOffset - startOffset);
                }
                ch = (char)scanner.read();
            }
            return new Region(startOffset, endOffset - startOffset);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private static boolean isMacroParamCharacter(char ch) {
        return ch == '(' || ch == ')' || Character.isWhitespace(ch) || ch == ',' || Character.isJavaIdentifierPart(ch);
    }

    public static ITypedRegion getTypedRegion(IDocument document, int offset) {
        block3: {
            try {
                if (offset >= 0) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        IDocumentExtension3 extension3 = (IDocumentExtension3)document;
        return extension3.getPartition("__vlog_partitioning", offset, false);
    }

    public static VlogMacroInfo getMacro(RfProject rfProject, ParserPath parserPath, IDocument document, int offset) {
        List<RfNamedElement> macros;
        IRegion region;
        block7: {
            block6: {
                if (document != null) break block6;
                return null;
            }
            region = VlogWordFinder.getDefault().getWordAtOffset(document, offset);
            String word = document.get(region.getOffset(), region.getLength());
            if (word.startsWith("`")) {
                word = word.substring(1);
                return rfProject.getMacroBeforeLineInFile(word, parserPath, document.getLineOfOffset(offset) + 1);
            }
            macros = rfProject.getMacrosWithPrefix(word, 1);
            if (macros != null && !macros.isEmpty()) break block7;
            return null;
        }
        try {
            String wordBefore = RfBatchUtils.getWordBefore(document, region.getOffset());
            if ("`define".equals(wordBefore) || "`undef".equals(wordBefore)) {
                return (VlogMacroInfo)macros.get(0);
            }
        }
        catch (Exception x) {
            DVTLogger.INSTANCE.logError((Throwable)x);
        }
        return null;
    }

    public static String getWordBefore(IDocument doc, int offset) {
        DVTStringBuilder wordBuff;
        block11: {
            wordBuff = new DVTStringBuilder();
            if (offset >= 1) break block11;
            return "";
        }
        try {
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, doc, Math.max(0, offset - 1), false);
            int i = offset - 1;
            while (i >= 0) {
                char c = (char)scanner.read();
                if (!Character.isWhitespace(c) || wordBuff.length() != 0) {
                    if (Character.isJavaIdentifierPart(c)) {
                        wordBuff.prepend(c);
                    } else if (c == '`') {
                        wordBuff.prepend(c);
                    } else if (!Character.isJavaIdentifierPart(c)) {
                        return wordBuff.toString();
                    }
                }
                --i;
            }
            if (i < 0) {
                return wordBuff.toString();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return "";
    }

    public static void disconnectPositionToDocument(IDocument document, RfFileDef fileDef) {
        try {
            if (document == null) {
                return;
            }
            if (!document.containsPositionCategory("REFLECTION")) {
                return;
            }
            boolean isCloned = DVTUtilsCommon.INSTANCE.isOpenClonedEditorSharingSameDocument(document);
            if (isCloned) {
                return;
            }
            document.removePositionCategory("REFLECTION");
            document.addPositionCategory("REFLECTION");
            if (document.containsPositionCategory("SEMANTIC_HIGHLIGHT")) {
                document.removePositionCategory("SEMANTIC_HIGHLIGHT");
                document.addPositionCategory("SEMANTIC_HIGHLIGHT");
            }
            fileDef.removePosition();
            RfBatchUtils.disconnectRecursive(fileDef);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private static void disconnectRecursive(RfDefElement root) {
        Collection<RfDefElement> cildren = root.getChildren();
        if (cildren == null) {
            return;
        }
        for (RfDefElement child : cildren) {
            child.removePosition();
            if (child.getChildren() == cildren) continue;
            RfBatchUtils.disconnectRecursive(child);
        }
    }

    public static RfFunction getParentFunction(RfFunction function) {
        boolean isConstructor = function.isConstructor();
        if (isConstructor) {
            return null;
        }
        RfNamedElement parentClass = function.getEnclosingScope();
        String functionName = function.getName();
        RfNamedElement currentClass = parentClass;
        while (currentClass != null && currentClass instanceof RfClass) {
            RfFunction candidate;
            RfClass parent = ((RfClass)currentClass).getParent();
            if (parent != null && (candidate = parent.getLocalMember(RfFunction.class, functionName, true)) != null && !candidate.isPrivate()) {
                return candidate;
            }
            currentClass = parent;
        }
        while (parentClass != null && parentClass instanceof RfClass) {
            List<RfClass> implementedClasses = ((RfClass)parentClass).getParentInterfaces();
            if (implementedClasses != null) {
                for (RfClass implementedClass : implementedClasses) {
                    RfFunction candidate = implementedClass.getLocalMember(RfFunction.class, functionName, true);
                    if (candidate == null || candidate.isPrivate()) continue;
                    return candidate;
                }
            }
            parentClass = ((RfClass)parentClass).getParent();
        }
        return null;
    }

    public static RfFunction getParentPredefinedFunction(RfFunction function, boolean mustHaveDef) {
        return RfBatchUtils.getParentPredefinedFunction(function, mustHaveDef, 0);
    }

    public static RfFunction getParentPredefinedFunction(RfFunction function, boolean mustHaveDef, int maxParents) {
        if (!function.isPredefined() && !function.isConstructor()) {
            return null;
        }
        HashSet<Class<RfPredefinedClass>> validScopes = new HashSet<Class<RfPredefinedClass>>();
        validScopes.add(RfClass.class);
        validScopes.add(RfSpecializedClass.class);
        validScopes.add(RfPredefinedClass.class);
        RfClass currentClass = (RfClass)function.getEnclosingScope(validScopes);
        if (currentClass == null) {
            return null;
        }
        currentClass = currentClass.getParent();
        String functionName = function.getName();
        boolean limitedSearch = maxParents > 0;
        while (currentClass != null) {
            if (currentClass.isInterfaceClass()) {
                return null;
            }
            RfFunction localFunction = null;
            localFunction = function.isConstructor() ? currentClass.getConstructorWithPrefix(functionName, 2, 1, IRfNamedElement.AccessModifier.SHOW_PROTECTED) : currentClass.getFunctionWithPrefix(functionName, 2, 1, IRfNamedElement.AccessModifier.SHOW_PROTECTED);
            if (!(localFunction == null || mustHaveDef && localFunction.hasNoDefs(false))) {
                return localFunction;
            }
            if (limitedSearch && --maxParents == 0) {
                return null;
            }
            currentClass = currentClass.getParent();
        }
        return null;
    }

    public static IFile getFileFromTextEditor(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        Object adapter = editorInput.getAdapter(IFile.class);
        if (!(adapter instanceof IFile)) {
            return null;
        }
        return (IFile)adapter;
    }

    public static IIdentifierIndexerExtension getIndexer(IProject project) {
        return IdentifierIndexerManager.getInstance().getProjectIndexer(IdentifierIndexer.class, project);
    }

    public static int getMacroStartOffset(IDocument document, int offset) {
        if (offset < 0 || offset >= document.getLength()) {
            return -1;
        }
        ITypedRegion region = RfBatchUtils.getTypedRegion(document, offset);
        if (region == null) {
            return -1;
        }
        String regionType = region.getType();
        if (!regionType.equals("__dftl_partition_content_type") && !regionType.equals("__vlog_escaped_id")) {
            return -1;
        }
        DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, offset - 1), false);
        int nesting = 0;
        int limit = 0;
        int result = -1;
        Level state = Level.INITIAL;
        HashMap<Integer, Integer> nestingOffsetMap = new HashMap<Integer, Integer>();
        StringBuilder ids = new StringBuilder();
        while (scanner.getOffset() > 0 && limit < 1000) {
            char ch = (char)scanner.read();
            ITypedRegion offsetRegion = RfBatchUtils.getTypedRegion(document, scanner.getOffset());
            if (offsetRegion == null) {
                ++limit;
                continue;
            }
            String offsetRegionType = offsetRegion.getType();
            if (offsetRegionType == null || !offsetRegionType.equals("__dftl_partition_content_type") && !offsetRegionType.equals("__vlog_escaped_id")) {
                ++limit;
                continue;
            }
            if (ch == ')') {
                --nesting;
            } else if (ch == '(') {
                ++nesting;
                state = Level.OB;
            } else if (Character.isWhitespace(ch)) {
                ids.setLength(0);
                if (state == Level.OB) {
                    state = Level.OB_WS;
                }
                if (state == Level.OB_ID) {
                    nestingOffsetMap.put(nesting, -1);
                    state = Level.OB_NID;
                }
            } else if (Character.isJavaIdentifierPart(ch)) {
                if (state == Level.OB_ID || state == Level.OB || state == Level.OB_WS) {
                    state = Level.OB_ID;
                }
                ids.append(ch);
            } else if (ch == '`') {
                Integer nestingOffset = (Integer)nestingOffsetMap.get(nesting);
                if (nestingOffset == null && nesting > 0) {
                    if (state != Level.OB_ID) {
                        return -1;
                    }
                    nestingOffsetMap.put(nesting, scanner.getOffset());
                    result = scanner.getOffset();
                }
            } else if (state != Level.INITIAL) {
                state = Level.OB_NID;
                nestingOffsetMap.put(nesting, -1);
            }
            ++limit;
        }
        return result;
    }

    static enum Level {
        INITIAL,
        OB,
        OB_WS,
        OB_ID,
        OB_NID;

    }

    private static class RfElementCache {
        private IDocument fDocument;
        private RfWNamedElementAndScope fCachedElement;
        private IRegion fCachedRegion;
        private long fTimestamp;

        private RfElementCache() {
        }

        public void setDocument(IDocument document) {
            if (document == this.fDocument) {
                return;
            }
            this.fDocument = document;
            this.fCachedRegion = null;
            this.fCachedElement = null;
            this.fTimestamp = 0L;
        }

        public RfWNamedElementAndScope getCacheElement(IRegion region) {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                try {
                                    if (region != null && this.fCachedRegion != null) break block7;
                                    return null;
                                }
                                catch (Exception exception) {
                                    return null;
                                }
                            }
                            if (this.fCachedElement != null) break block8;
                            return null;
                        }
                        if (region.getLength() != 0) break block9;
                        return null;
                    }
                    if (region.equals(this.fCachedRegion)) break block10;
                    return null;
                }
                long oldTimestamp = this.fTimestamp;
                this.fTimestamp = System.currentTimeMillis();
                if (this.fTimestamp - oldTimestamp <= 200L) break block11;
                return null;
            }
            return new RfWNamedElementAndScope(this.fCachedElement);
        }

        public void putCacheElement(IRegion region, RfWNamedElementAndScope element) {
            this.fCachedElement = new RfWNamedElementAndScope(element);
            this.fCachedRegion = region;
            this.fTimestamp = System.currentTimeMillis();
        }
    }
}

