/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.util;

import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfCheckerDef;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClassDef;
import ro.amiq.vlogdt.model.reflection.RfCovercrossDef;
import ro.amiq.vlogdt.model.reflection.RfCovergroupDef;
import ro.amiq.vlogdt.model.reflection.RfCoverpointDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlockDef;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterfaceDef;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfModuleDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackageDef;
import ro.amiq.vlogdt.model.reflection.RfPrimitiveDef;
import ro.amiq.vlogdt.model.reflection.RfProgramDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStructDef;
import ro.amiq.vlogdt.model.reflection.RfTypeAliasDef;

public class RfEnclosingScopeUtils {
    private static String getText(Object element) {
        String result = null;
        if (element instanceof RfDefElement && ((RfDefElement)element).getNamedElement() == null) {
            return null;
        }
        try {
            if (element instanceof RfGenerateBlockDef) {
                result = ((RfDefElement)element).getName();
            }
            if (element instanceof RfInterfaceDef) {
                result = ((RfDefElement)element).getName();
            } else if (element instanceof RfModuleDef) {
                result = ((RfDefElement)element).getName();
            } else if (element instanceof RfProgramDef) {
                result = ((RfDefElement)element).getName();
            } else if (element instanceof RfPackageDef) {
                result = ((RfDefElement)element).getName();
            } else if (element instanceof RfClassDef) {
                result = ((RfDefElement)element).getName();
            } else if (element instanceof RfPrimitiveDef) {
                result = ((RfDefElement)element).getName();
            } else if (element instanceof RfCheckerDef) {
                result = ((RfDefElement)element).getName();
            } else if (element instanceof RfCovergroupDef) {
                result = ((RfDefElement)element).getName();
            } else if (element instanceof RfFieldDef && ((RfFieldDef)element).getNamedElement() instanceof RfInstance) {
                RfNamedElement instance = ((RfFieldDef)element).getNamedElement();
                DataType dataType = ((RfField)instance).getDataType();
                result = dataType != null ? String.valueOf(((RfDefElement)element).getName()) + " (" + dataType.getType() + ")" : null;
            } else if (element instanceof RfCoverpointDef) {
                result = ((RfDefElement)element).getNamedElement().getEnclosingScope().getName();
            } else if (element instanceof RfCovercrossDef) {
                result = ((RfDefElement)element).getNamedElement().getEnclosingScope().getName();
            } else if (element instanceof RfFunctionDef) {
                List<RfNamedElement> namedElements = ((RfDefElement)element).getNamedElements();
                result = namedElements != null && namedElements.size() == 1 && namedElements.get(0) != null && namedElements.get(0).getEnclosingScope() instanceof RfClass ? DVTStringUtil.appendString((Object[])new Object[]{namedElements.get(0).getEnclosingScope().getName(), "::", ((RfDefElement)element).getName(), "()"}) : DVTStringUtil.appendString((Object[])new Object[]{((RfDefElement)element).getName(), "()"});
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    public static IRfDefElement getScope(IProject project, ParserPath parserPath, int offset, boolean allowInstance) {
        RfDefElement scopeDef;
        if (project == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        RfFileDef fileDef = rfProject.getFileDefUsingParserPath(parserPath);
        if (fileDef == null) {
            return null;
        }
        RfDefElement scope = fileDef.getScope(offset, false, allowInstance);
        RfDefElement rfDefElement = scope instanceof RfDefElement ? scope : (scopeDef = scope instanceof RfNamedElement ? ((RfNamedElement)((Object)scope)).getDeclaration() : null);
        if (scopeDef == null) {
            return null;
        }
        if ((scopeDef instanceof RfTypeAliasDef || scopeDef instanceof RfStructDef) && (scopeDef.getNamedElement().getEnclosingScope() == null || scopeDef instanceof RfFileDef && scopeDef.getNamedElement() == null)) {
            scopeDef = null;
        } else if (scopeDef instanceof RfTypeAliasDef || scopeDef instanceof RfStructDef) {
            scopeDef = scopeDef.getNamedElement().getEnclosingScope().getDeclaration();
        } else if (scopeDef instanceof RfFileDef) {
            scopeDef = scopeDef.getNamedElement().getDeclaration();
        }
        return scopeDef;
    }

    public static String getScopeInfo(IProject project, ParserPath parserPath, int offset) {
        String kindName;
        IRfDefElement scopeDef = RfEnclosingScopeUtils.getScope(project, parserPath, offset, true);
        String text = RfEnclosingScopeUtils.getText(scopeDef);
        if (text == null) {
            return null;
        }
        if (scopeDef != null && scopeDef.getNamedElement() != null && (kindName = scopeDef.getNamedElement().getKindName()) != null && !kindName.isEmpty()) {
            text = String.valueOf(kindName) + ": " + text;
        }
        return " [" + text + "]";
    }
}

