/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.util;

import java.util.ConcurrentModificationException;
import java.util.Deque;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStructDef;
import ro.amiq.vlogdt.model.reflection.RfTypeAliasDef;

public class RfGUIEnclosingScopeUtils {
    public static IRfScope getScope(ITextEditor editor, int offset, boolean includeActionBlocks, boolean allowInstance, Deque<RfDefElement> scopeTree) {
        IFile file;
        RfProject rfProject;
        IDocument document;
        RfDefElement scope;
        block18: {
            block17: {
                IProject project;
                block16: {
                    block15: {
                        block14: {
                            scope = null;
                            project = RfGUIEnclosingScopeUtils.getProject(editor);
                            if (project != null) break block14;
                            return null;
                        }
                        if (DVTPlugin.getDefault().collect().c(project, "F7376")) break block15;
                        return null;
                    }
                    document = DVTFileUtils.getInstance().getDocument(editor);
                    if (document != null) break block16;
                    return null;
                }
                rfProject = RfManager.getInstance().getRfProject(project);
                if (rfProject != null) break block17;
                return null;
            }
            file = (IFile)editor.getAdapter(IResource.class);
            if (file != null) break block18;
            return null;
        }
        try {
            RfFileDef fileDef = rfProject.getFile((IResource)file);
            if (fileDef != null) {
                scope = RfGUIEnclosingScopeUtils.getLineScope(fileDef, offset, document, includeActionBlocks, allowInstance, scopeTree);
                if ((scope instanceof RfTypeAliasDef || scope instanceof RfStructDef) && scope.getNamedElement().getEnclosingScope() == null || scope instanceof RfFileDef && scope.getNamedElement() == null) {
                    scope = null;
                } else if (scope instanceof RfTypeAliasDef || scope instanceof RfStructDef) {
                    scope = scope.getNamedElement().getEnclosingScope().getDeclaration();
                } else if (scope instanceof RfFileDef) {
                    scope = scope.getNamedElement().getDeclaration();
                }
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return scope;
    }

    private static RfDefElement getLineScope(RfFileDef fileDef, int offset, IDocument document, boolean includeActionBlocks, boolean allowInstance, Deque<RfDefElement> scopeTree) {
        try {
            int line = document.getLineOfOffset(offset);
            IRegion region = document.getLineInformation(line);
            return fileDef.getScope(region.getOffset() + region.getLength(), includeActionBlocks, allowInstance, scopeTree);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static IProject getProject(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }
}

