/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.util;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTRfNameTypeScopeHelper;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfProgram;

public class RfNameTypeScopeHelper
implements DVTRfNameTypeScopeHelper {
    private static final long serialVersionUID = 1L;
    private String fName;
    private int fType = 0;

    public RfNameTypeScopeHelper(IRfNamedElement element) {
        if (element instanceof RfClass) {
            this.fType = 1;
        } else if (element instanceof RfInterface) {
            this.fType = 512;
        } else if (element instanceof RfProgram) {
            this.fType = 256;
        } else if (element instanceof RfModule) {
            this.fType = 128;
        } else if (element instanceof RfField && ((RfField)element).isInstance()) {
            this.fType = 1024;
        } else if (element instanceof RfPackage) {
            this.fType = 2048;
        } else if (element instanceof RfPrimitive) {
            this.fType = 4096;
        } else if (element instanceof RfChecker) {
            this.fType = 8192;
        } else if (element instanceof RfLibrary) {
            this.fType = 16384;
        } else if (!(element instanceof RfNamedElement)) {
            this.fType = 65536;
        } else {
            return;
        }
        this.fName = element.getName();
    }

    public RfNameTypeScopeHelper(int type, String name) {
        this.fType = type;
        this.fName = name;
    }

    public String getElementName() {
        return this.fName;
    }

    public int getElementKind() {
        return this.fType;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fName == null ? 0 : this.fName.hashCode());
        result = 31 * result + this.fType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RfNameTypeScopeHelper other = (RfNameTypeScopeHelper)obj;
        if (this.fName == null ? other.fName != null : !this.fName.equals(other.fName)) {
            return false;
        }
        return this.fType == other.fType;
    }
}

