/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.util;

import java.util.Deque;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.model.reflection.util.RfUtilsBase;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.ui.editor.VlogWordFinder;

public class RfUtils
extends RfUtilsBase {
    private static volatile RfUtils INSTANCE;
    private static final Object SYNC_OBJ;

    static {
        SYNC_OBJ = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final RfUtils getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJ;
            synchronized (object) {
                INSTANCE = new RfUtils();
            }
        }
        return INSTANCE;
    }

    public static List<RfNamedElement> getMacros(ITextEditor textEditor, IDocument document, int offset) {
        RfProject rfProject;
        block10: {
            IFile file;
            block9: {
                IEditorInput editorInput;
                block8: {
                    block7: {
                        try {
                            if (document != null) break block7;
                            return null;
                        }
                        catch (Exception x) {
                            DVTLogger.INSTANCE.logError((Throwable)x);
                            return null;
                        }
                    }
                    editorInput = textEditor.getEditorInput();
                    if (editorInput != null) break block8;
                    return null;
                }
                file = (IFile)editorInput.getAdapter(IFile.class);
                if (file != null) break block9;
                return null;
            }
            rfProject = RfManager.getInstance().getRfProject(file.getProject());
            if (rfProject != null) break block10;
            return null;
        }
        IRegion region = VlogWordFinder.getDefault().getWordAtOffset(document, offset);
        String word = document.get(region.getOffset(), region.getLength());
        if (word.startsWith("`")) {
            return rfProject.getMacrosWithPrefix(word.substring(1), 1);
        }
        return rfProject.getMacrosWithPrefix(word, 1);
    }

    public static RfWNamedElementAndScope getRfElement(RfProject rfProject, ITextEditor textEditor, IDocument document, int offset) {
        return RfUtils.getRfElement(rfProject, textEditor, document, offset, null, false);
    }

    public static IFile getFile(VlogFileInstance instance, IProject project) {
        if (instance == null || instance.getParserPath() == null || instance.getParserPath().path == null) {
            return null;
        }
        return DVTFileUtils.getInstance().findProjectFile(project, instance.getParserPath().path);
    }

    public static RfNamedElement getNamedElementFromString(IProject project, String s) {
        return RfBatchUtils.getNamedElementFromString(project, s);
    }

    public static RfNamedElement getNamedElementFromString(IProject project, String s, boolean skipLibrary) {
        return RfBatchUtils.getNamedElementFromString(project, s, skipLibrary);
    }

    private static void getRegClassInfo(IRfDefElement declaration) {
        IRfNamedElement namedElement = declaration.getNamedElement();
        if (!(namedElement instanceof RfClass)) {
            return;
        }
        if (!((RfClass)namedElement).isSubClass("uvm_reg", true)) {
            return;
        }
        List<RfField> fields = ((RfClass)namedElement).getLocalFields();
        if (fields == null || fields.isEmpty()) {
            return;
        }
        TestHelper.out.println("-------------------------------------------------------------------");
        TestHelper.out.println("Register             = " + namedElement.getName());
        for (RfField field : fields) {
            RfUtils.getRegFieldInfo(field, (RfClass)namedElement);
        }
        TestHelper.out.println("-------------------------------------------------------------------");
    }

    private static void getRegFieldInfo(RfField field, RfClass enclosingClass) {
        if (!(field instanceof RfAssociatedType)) {
            return;
        }
        final String fieldName = field.getName();
        IRfNamedElement assocType = field.getAssociatedType();
        if (assocType == null) {
            return;
        }
        if (!"uvm_reg_field".equals(assocType.getName())) {
            return;
        }
        enclosingClass.visitHidObject(field.getRfProject(), new IHidVisitor<RfHid>(){

            public boolean visit(RfHid hidObject) {
                if (!"configure".equals(hidObject.getName())) {
                    return true;
                }
                Hid parentHid = hidObject.getParentHid();
                if (parentHid == null) {
                    return true;
                }
                if (!fieldName.equals(parentHid.getName())) {
                    return true;
                }
                ListContainer accesses = hidObject.getAccesses();
                if (accesses == null || accesses.size() != 1) {
                    TestHelper.out.println("Wrong access number");
                    return true;
                }
                HidAccess access = hidObject.getFirstAccess();
                if (!(access instanceof RfHidAccessArgs)) {
                    TestHelper.out.println("Wrong access kind");
                    return true;
                }
                List<? extends IHidObject> argValues = ((RfHidAccessArgs)access).getArgumentValues();
                if (argValues == null || argValues.isEmpty()) {
                    TestHelper.out.println("Wrong arguments");
                    return true;
                }
                TestHelper.out.println("Field             = " + fieldName);
                int i = 0;
                while (i < argValues.size()) {
                    IHidObject argValue = argValues.get(i);
                    switch (i) {
                        case 1: {
                            TestHelper.out.println("   size                    = " + ((RfHidOperator)argValue).getRHValues());
                            break;
                        }
                        case 2: {
                            TestHelper.out.println("   lsb_pos                 = " + ((RfHidOperator)argValue).getRHValues());
                            break;
                        }
                        case 3: {
                            TestHelper.out.println("   access                  = " + ((RfHidOperator)argValue).getRHValues());
                            break;
                        }
                        case 4: {
                            TestHelper.out.println("   volatile                = " + ((RfHidOperator)argValue).getRHValues());
                            break;
                        }
                        case 5: {
                            TestHelper.out.println("   reset                   = " + ((RfHidOperator)argValue).getRHValues());
                            break;
                        }
                        case 6: {
                            TestHelper.out.println("   has_reset               = " + ((RfHidOperator)argValue).getRHValues());
                            break;
                        }
                        case 7: {
                            TestHelper.out.println("   is_rand                 = " + ((RfHidOperator)argValue).getRHValues());
                            break;
                        }
                        case 8: {
                            TestHelper.out.println("   individually_accessible = " + ((RfHidOperator)argValue).getRHValues());
                            break;
                        }
                    }
                    ++i;
                }
                return true;
            }

            public Class<RfHid> getType() {
                return RfHid.class;
            }
        });
    }

    @Override
    public IRfScope getRfScope(ITextEditor textEditor, IDocument document, int offset, boolean includeActionBlocks, boolean allowInstance, Deque<RfDefElement> scopeTree) {
        RfProject rfProject;
        IFile file;
        block12: {
            block11: {
                IEditorInput editorInput;
                block10: {
                    block9: {
                        block8: {
                            if (textEditor != null) break block8;
                            return null;
                        }
                        if (document != null) break block9;
                        return null;
                    }
                    editorInput = textEditor.getEditorInput();
                    if (editorInput != null) break block10;
                    return null;
                }
                file = (IFile)editorInput.getAdapter(IFile.class);
                if (file != null) break block11;
                return null;
            }
            rfProject = RfManager.getInstance().getRfProject(file.getProject());
            if (rfProject != null) break block12;
            return null;
        }
        try {
            RfFileDef rfFileDef = rfProject.getFile((IResource)file);
            if (rfFileDef != null) {
                return rfFileDef.getScope(offset, includeActionBlocks, allowInstance, scopeTree);
            }
        }
        catch (Exception x) {
            DVTLogger.INSTANCE.logError((Throwable)x);
        }
        return null;
    }

    public static IProject getIProject(ITextEditor editor) {
        if (!(editor instanceof DVTEditor)) {
            return null;
        }
        return ((DVTEditor)editor).getProject();
    }

    public static IFile getFile(ITextEditor editor) {
        if (!(editor instanceof DVTEditor)) {
            return null;
        }
        return ((DVTEditor)editor).getCurrentFile();
    }

    public static String getNewLineDelimiter() {
        return "<br>";
    }

    public static String getEscapedString(String text) {
        return DVTStringUtil.partiallyEscapeHTML((String)text);
    }

    public static String getStyledText(String signature, String comment) {
        return "<b>" + DVTStringUtil.partiallyEscapeHTML((String)signature) + "</b><br>" + DVTStringUtil.partiallyEscapeHTML((String)comment);
    }

    public static String wrapIntoBold(String text) {
        if (text.isEmpty()) {
            return text;
        }
        return "<b>" + text + "</b>";
    }

    public static String wrapIntoParagraph(String text) {
        if (text.isEmpty()) {
            return text;
        }
        return "<p>" + text + "</p>";
    }
}

