/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.util;

import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.comment.formatter.CommentFormatter;
import ro.amiq.dvt.diagrams.wavedrom.WaveDromManager;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IDVTFile;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.trace.connections.utils.TCViewUtils;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.MethodSignatureUseCase;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfDefaultConstructorDef;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfKind;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedClass;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.parser.VlogException;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.r2lparser.R2LOverrideFunction;
import ro.amiq.vlogdt.ui.editor.VlogWordFinder;
import ro.amiq.vlogdt.ui.editor.WordAtOffsetInfo;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.vlogdt.ui.preferences.PrefConst;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public abstract class RfUtilsBase {
    public static final String ASSOC_TYPE_OF = "ASSOC_TYPE_OF";
    private static final Set<String> VALID_KEYWORDS_HYPERLINK = new HashSet<String>();

    static {
        VALID_KEYWORDS_HYPERLINK.add("new");
    }

    public static RfWNamedElementAndScope getRfElement(IRfSingleLangProject rfProject, IFile file, IDocument document, int offset, DVTEditor editor) {
        return RfBatchUtils.getRfElement((RfProject)rfProject, file, document, offset, null, false, editor);
    }

    public static RfNamedElementActionHyperlink createOpenAction(IRfNamedElement namedElement, IRfScopeElement scope, IRfScopeElement scopee, HidOperator hidContext, boolean isHierarchicalAccess, IProject project, IRegion hyperlinkRegion, boolean firstImpl) {
        if (hyperlinkRegion.getLength() == 0) {
            return null;
        }
        RfNamedElementActionHyperlink hyperlink = RfUtilsBase.createOpenAction(namedElement, project, hyperlinkRegion, firstImpl, false);
        if (hyperlink == null) {
            return null;
        }
        hyperlink.setScope(scope);
        hyperlink.setAssocType(scopee);
        hyperlink.setHidContext(hidContext);
        hyperlink.setHierarchicalAccess(isHierarchicalAccess);
        return hyperlink;
    }

    public static RfNamedElementActionHyperlink createOpenAction(IRfNamedElement namedElement, IProject project, IRegion hyperlinkRegion) {
        boolean firstImplementation = PrefConst.getJumpToImplementationFunctionTaskLayerAndSkipExternPrototype();
        return RfUtilsBase.createOpenAction(namedElement, project, hyperlinkRegion, firstImplementation);
    }

    public static RfNamedElementActionHyperlink createOpenAction(IRfNamedElement namedElement, IProject project, IRegion hyperlinkRegion, String hyperlinkText) {
        boolean firstImplementation = PrefConst.getJumpToImplementationFunctionTaskLayerAndSkipExternPrototype();
        return RfUtilsBase.createOpenAction(namedElement, project, hyperlinkRegion, firstImplementation, true, hyperlinkText);
    }

    public static RfNamedElementActionHyperlink createOpenAction(IRfNamedElement namedElement, IProject project, IRegion hyperlinkRegion, boolean firstImpl) {
        return RfUtilsBase.createOpenAction(namedElement, project, hyperlinkRegion, firstImpl, true);
    }

    public static RfNamedElementActionHyperlink createOpenAction(IRfNamedElement namedElement, IProject project, IRegion hyperlinkRegion, boolean firstImpl, boolean skipPredefined) {
        return RfUtilsBase.createOpenAction(namedElement, project, hyperlinkRegion, firstImpl, skipPredefined, null);
    }

    public static String getAssociatedTypeHyperlinkLabelPart(IRfNamedElement namedElement) {
        RfKind kind = RfKind.of(namedElement);
        switch (kind) {
            case INTERFACE_PORT: 
            case MODPORT_PORT: 
            case INPUT_PORT: 
            case OUTPUT_PORT: 
            case INOUT_PORT: 
            case REF_PORT: 
            case PORT: {
                return "Port";
            }
            case FUNCTION: {
                return "Return";
            }
            case TYPEDEF: 
            case TYPE_PARAMETER: {
                return "Aliased";
            }
        }
        return DVTStringUtil.toTitleCase((String)kind.getName());
    }

    /*
     * Unable to fully structure code
     */
    public static RfNamedElementActionHyperlink createOpenAction(IRfNamedElement namedElement, final IProject project, IRegion hyperlinkRegion, boolean firstImpl, boolean skipPredefined, String hyperlinkText) {
        block15: {
            block17: {
                block16: {
                    block14: {
                        if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
                            return null;
                        }
                        if (namedElement == null) {
                            return null;
                        }
                        if (skipPredefined && namedElement.isPredefined() && !(namedElement instanceof RfPredefinedFunction) && !(namedElement instanceof RfPredefinedClass) && !(namedElement instanceof RfPredefinedStruct)) {
                            return null;
                        }
                        isPredefinedOverriddenFunction = namedElement instanceof RfPredefinedFunction != false && ((RfPredefinedFunction)namedElement).isPredefinedOverridden() != false;
                        isNamedArrayMethodItem = namedElement instanceof RfPredefinedField != false && ((RfPredefinedField)namedElement).isNamedArrayMethodItem() != false;
                        action = null;
                        if (!namedElement.isAutoDefined()) break block14;
                        action = new Action(){

                            public void run() {
                            }
                        };
                        break block15;
                    }
                    if (!(namedElement instanceof VlogMacroInfo)) break block16;
                    macroInfo = (VlogMacroInfo)namedElement;
                    fullPath = macroInfo.getFileInstance().getParserPath();
                    resource = macroInfo.getFileAdapter();
                    line = macroInfo.getLine();
                    elementName = namedElement.getName();
                    action = new Action(){

                        public void run() {
                            if (resource == null) {
                                VlogFileUtils.getInstance().openFile(project, fullPath.path, line, elementName);
                            } else {
                                VlogFileUtils.getInstance().openEditor((IFile)resource, line, null);
                            }
                        }

                        public String getPath() {
                            return fullPath.path;
                        }

                        public String getElementName() {
                            return elementName;
                        }

                        public int getLine() {
                            return line;
                        }
                    };
                    break block15;
                }
                if (!namedElement.isPredefined() || isPredefinedOverriddenFunction || isNamedArrayMethodItem) break block17;
                action = new Action(){

                    public void run() {
                    }
                };
                break block15;
            }
            if (!(namedElement instanceof RfResultImplicitVariable)) ** GOTO lbl46
            enclosingScope = ((RfResultImplicitVariable)namedElement).getEnclosingScope();
            if (!(enclosingScope instanceof RfFunction)) {
                return null;
            }
            declaration = enclosingScope.getDeclaration();
            if (declaration == null) {
                return null;
            }
            hitHitToJump = declaration.getStartLine();
            rfFileDef = declaration.getDefFile();
            if (rfFileDef == null) {
                return null;
            }
            parserPath = rfFileDef.getParserPath();
            elementName = namedElement.getName();
            action = new Action(){

                public void run() {
                    VlogFileUtils.getInstance().openFile(project, parserPath.path, hitHitToJump, elementName);
                }

                public String getPath() {
                    return parserPath.path;
                }

                public String getElementName() {
                    return elementName;
                }

                public int getLine() {
                    return hitHitToJump;
                }
            };
            break block15;
lbl-1000:
            // 1 sources

            {
                assocType = ((RfInstance.RfInstanceList)namedElement).getAssociatedType();
                if (assocType == null) {
                    return null;
                }
                namedElement = assocType;
lbl46:
                // 2 sources

                ** while (namedElement instanceof RfInstance.RfInstanceList)
            }
lbl47:
            // 1 sources

            v0 = declaration = namedElement instanceof RfSpecializedClass != false ? ((RfSpecializedClass)namedElement).getDeclaration() : namedElement.getDeclaration();
            if (declaration == null) {
                return null;
            }
            if (declaration instanceof RfFunctionDef && ((RfFunctionDef)declaration).isPrototype() && firstImpl) {
                for (IRfDefElement layer : namedElement.getDeclarations()) {
                    if (!(layer instanceof RfFunctionDef) || ((RfFunctionDef)layer).isPrototype()) continue;
                    declaration = layer;
                    break;
                }
            }
            if ((rfFileDef = declaration.getDefFile()) == null) {
                return null;
            }
            parserPath = rfFileDef.getParserPath();
            hitHitToJump = declaration.getStartLine();
            elementName = declaration instanceof RfDefaultConstructorDef != false ? "default" : namedElement.getName();
            if (hyperlinkRegion != null && namedElement instanceof RfField && namedElement.getDeclarations().size() >= 2 && (argumentScope = ((RfFileDef)rfFileDef).getScope(offset = hyperlinkRegion.getOffset(), false)) instanceof RfFunctionDef && (functionDef = (RfFunctionDef)argumentScope).getArgumentInfos() != null) {
                for (ArgInfo arg : functionDef.getArgumentInfos()) {
                    if (!arg.getName().equals(elementName)) continue;
                    hitHitToJump = arg.getStartLine();
                    break;
                }
            }
            line = hitHitToJump;
            action = new Action(){

                public void run() {
                    VlogFileUtils.getInstance().openFile(project, parserPath.path, line, elementName);
                }

                public String getPath() {
                    return parserPath.path;
                }

                public String getElementName() {
                    return elementName;
                }

                public int getLine() {
                    return line;
                }
            };
        }
        return new RfNamedElementActionHyperlink(project, namedElement, hyperlinkRegion, (IAction)action, hyperlinkText);
    }

    public static RfNamedElementActionHyperlink createOpenAction(RfDefElement defElement, IProject project, IRegion region) {
        return RfUtilsBase.createOpenAction(defElement, null, project, region);
    }

    public static RfNamedElementActionHyperlink createOpenAction(RfDefElement defElement, String selectIdentifier, IProject project, IRegion region) {
        return RfUtilsBase.createOpenAction(defElement, selectIdentifier, project, region, null);
    }

    public static RfNamedElementActionHyperlink createOpenAction(RfDefElement defElement, final String selectIdentifier, final IProject project, IRegion region, String hyperlinkText) {
        if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
            return null;
        }
        if (defElement == null) {
            return null;
        }
        RfFileDef rfFileDef = null;
        rfFileDef = defElement instanceof RfFileDef ? (RfFileDef)defElement : defElement.getDefFile();
        if (rfFileDef == null) {
            return null;
        }
        final ParserPath fullPath = rfFileDef.getParserPath();
        final int line = defElement.getStartLine();
        Action action = new Action(){

            public void run() {
                VlogFileUtils.getInstance().openFile(project, fullPath.path, line, selectIdentifier);
            }

            public String getPath() {
                return fullPath.path;
            }

            public String getElementName() {
                return selectIdentifier;
            }

            public int getLine() {
                return line;
            }
        };
        return new RfNamedElementActionHyperlink(project, defElement.getNamedElement(), region, (IAction)action, hyperlinkText);
    }

    public static IRfScope getActionsCommonRfScope(ITextEditor textEditor, IDocument document, List<IRegion> regions) {
        RfProject rfProject;
        IFile file;
        block12: {
            block11: {
                IEditorInput editorInput;
                block10: {
                    block9: {
                        block8: {
                            if (textEditor != null) break block8;
                            return null;
                        }
                        if (document != null) break block9;
                        return null;
                    }
                    editorInput = textEditor.getEditorInput();
                    if (editorInput != null) break block10;
                    return null;
                }
                file = (IFile)editorInput.getAdapter(IFile.class);
                if (file != null) break block11;
                return null;
            }
            rfProject = RfManager.getInstance().getRfProject(file.getProject());
            if (rfProject != null) break block12;
            return null;
        }
        try {
            RfFileDef rfFileDef = rfProject.getFile((IResource)file);
            if (rfFileDef != null) {
                return rfFileDef.getActionsCommonScope(regions);
            }
        }
        catch (Exception x) {
            DVTLogger.INSTANCE.logError((Throwable)x);
        }
        return null;
    }

    public abstract IRfScope getRfScope(ITextEditor var1, IDocument var2, int var3, boolean var4, boolean var5, Deque<RfDefElement> var6);

    public static IRfScope getRfScope(ITextEditor textEditor, IDocument document, int offset) {
        return RfUtils.getInstance().getRfScope(textEditor, document, offset, true, false, null);
    }

    public static RfNamedElementActionHyperlink getAssociatedTypeHyperlink(DVTEditor editor, IRfNamedElement namedElement, IRfScopeElement scopeElement, IProject project, IRegion hyperlinkRegion) {
        RfNamedElementActionHyperlink assocTypeHypelink;
        if (namedElement instanceof IRfInstanceElement) {
            return RfUtilsBase.createOpenAction(((IRfInstanceElement)namedElement).getGenericDesign(null), project, hyperlinkRegion);
        }
        if (scopeElement instanceof RfDefElement) {
            scopeElement = ((RfDefElement)scopeElement).getNamedElement();
        }
        int offset = hyperlinkRegion == null ? -1 : hyperlinkRegion.getOffset();
        ElementPath path = DesignPathManager.getInstance().getPathFor(editor, offset, namedElement, scopeElement, false, false);
        RfTypesResolver resolver = RfTypesResolver.create(scopeElement, path, namedElement.getRfProject().getNonELManager(), 14);
        IRfNamedElement associatedType = null;
        if (namedElement instanceof RfAssociatedType) {
            associatedType = ((RfAssociatedType)namedElement).getAssociatedType(resolver);
            if (associatedType == null) {
                RfNamedElement enclosingScope = ((RfAssociatedType)namedElement).getEnclosingScope();
                String typeName = ((RfAssociatedType)namedElement).getAssociatedTypeName();
                associatedType = enclosingScope.getOtherLangMemberWithPrefix(typeName, 1);
            }
            if (associatedType instanceof RfStruct && namedElement instanceof RfTypeAlias) {
                associatedType = namedElement;
            }
        }
        if (associatedType instanceof RfListType) {
            associatedType = ((RfListType)associatedType).getAssociatedType(resolver);
        }
        if ((assocTypeHypelink = RfUtilsBase.createOpenAction(associatedType, project, hyperlinkRegion)) != null) {
            assocTypeHypelink.setMeta(ASSOC_TYPE_OF, namedElement);
        }
        return assocTypeHypelink;
    }

    public static RfNamedElementActionHyperlink getRfNamedElementActionHyperlink(RfProject rfProject, ITextEditor editor, IDocument document, int offset) {
        boolean firstImplementation = PrefConst.getJumpToImplementationFunctionTaskLayerAndSkipExternPrototype();
        return RfUtilsBase.getRfNamedElementActionHyperlink(rfProject, editor, document, offset, firstImplementation, null, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RfNamedElementActionHyperlink getRfNamedElementActionHyperlink(RfProject rfProject, ITextEditor editor, IDocument document, int offset, boolean firstImplementation, IRfScope[] scope, boolean macroExpanded) {
        try {
            RfWNamedElementAndScope elementAndScope;
            WordAtOffsetInfo wordAtOffsetInfo = VlogWordFinder.getDefault().getWordStringAndRegionAtOffset(document, offset);
            IRegion hyperlinkRegion = wordAtOffsetInfo.getRegion();
            if (hyperlinkRegion.getLength() == 0) {
                return null;
            }
            IProject project = rfProject.getProject();
            if (project == null) {
                return null;
            }
            String hyperlinkedWord = wordAtOffsetInfo.getWord();
            if (hyperlinkedWord != null && !hyperlinkedWord.isEmpty() && !VALID_KEYWORDS_HYPERLINK.contains(hyperlinkedWord)) {
                String[] verilogKeywords;
                String[] stringArray = verilogKeywords = PrefConst.getVerilogKeywords(false);
                int n = verilogKeywords.length;
                int n2 = 0;
                while (n2 < n) {
                    String keyword = stringArray[n2];
                    if (hyperlinkedWord.equals(keyword)) {
                        return null;
                    }
                    ++n2;
                }
            }
            if ((elementAndScope = RfUtilsBase.getRfElement(rfProject, editor, document, offset, scope, macroExpanded)) != null && elementAndScope.getIRfNamedElement() != null) {
                return RfUtilsBase.createOpenAction(elementAndScope.getIRfNamedElement(), elementAndScope.getScope(), elementAndScope.getAssocScope(), elementAndScope.getHidContext(), RfReferencesUtils.isHierarchicalAccess((IRfNamedElementAndScope)elementAndScope), project, hyperlinkRegion, firstImplementation);
            }
            VlogMacroInfo macro = RfUtilsBase.getLastDefineBeforeMacroUse(rfProject, editor, document, offset);
            if (macro == null) {
                return null;
            }
            return RfUtilsBase.createOpenAction(macro, project, hyperlinkRegion);
        }
        catch (Exception x) {
            DVTLogger.INSTANCE.logError((Throwable)x);
            return null;
        }
    }

    public static RfWNamedElementAndScope getRfElement(RfProject rfProject, ITextEditor textEditor, IDocument document, int offset, IRfScope[] scope, boolean macroExpanded) {
        IFile file;
        block9: {
            IEditorInput editorInput;
            block8: {
                block7: {
                    block6: {
                        try {
                            if (textEditor != null) break block6;
                            return null;
                        }
                        catch (Exception x) {
                            DVTLogger.INSTANCE.logError((Throwable)x);
                            return null;
                        }
                    }
                    if (document != null) break block7;
                    return null;
                }
                editorInput = textEditor.getEditorInput();
                if (editorInput != null) break block8;
                return null;
            }
            file = (IFile)editorInput.getAdapter(IFile.class);
            if (file != null) break block9;
            return null;
        }
        return RfBatchUtils.getRfElement(rfProject, file, document, offset, scope, macroExpanded, (DVTEditor)textEditor);
    }

    public static VlogMacroInfo getLastDefineBeforeMacroUse(RfProject rfProject, ITextEditor editor, IDocument document, int offset) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        return RfUtilsBase.getLastDefineBeforeMacroUse(rfProject, file, document, offset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VlogMacroInfo getLastDefineBeforeMacroUse(RfProject rfProject, IFile file, IDocument document, int offset) {
        try {
            if (document == null) {
                return null;
            }
            if (file == null) {
                return null;
            }
            ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
            if (parserPath == null) {
                return null;
            }
            int line = document.getLineOfOffset(offset) + 1;
            IRegion region = VlogWordFinder.getDefault().getWordAtOffset(document, offset);
            String word = document.get(region.getOffset(), region.getLength());
            if (!word.startsWith("`")) {
                String wordBefore = RfBatchUtils.getWordBefore(document, region.getOffset());
                if ("`define".equals(wordBefore)) return rfProject.getMacroBeforeLineInFile(word, parserPath, line);
                if (!"`undef".equals(wordBefore)) return null;
                return rfProject.getMacroBeforeLineInFile(word, parserPath, line);
            }
            VlogMacroInfo result = rfProject.getMacroBeforeLineInFile(word = word.substring(1), parserPath, line);
            if (result != null) {
                return result;
            }
            List<RfNamedElement> candidates = rfProject.getMacrosWithPrefix(word, 1);
            if (candidates == null) return null;
            if (!candidates.isEmpty()) return (VlogMacroInfo)candidates.get(0);
            return null;
        }
        catch (Exception x) {
            DVTLogger.INSTANCE.logError((Throwable)x);
        }
        return null;
    }

    public static DVTPair<String, String> getSpecadorFormatting(RfNamedElement element, String comment, IProject project, ITextEditor textEditor) {
        if (element == null || comment == null || project == null || comment.isEmpty()) {
            return new DVTPair((Object)"", (Object)"");
        }
        return CommentFormatter.INSTANCE.format(comment, (IRfNamedElement)element, textEditor);
    }

    public static String getContentAssistProposalText(IRfNamedElement element, int line, ParserPath parserPath) throws VlogException {
        String signature;
        if (element == null) {
            return null;
        }
        if (element instanceof RfFunction) {
            ((RfFunction)element).setSignatureUseCase(MethodSignatureUseCase.CONTENT_ASSIST_PROPOSAL);
        }
        if ((signature = element.getSignature()) == null) {
            return null;
        }
        if (element instanceof VlogMacroInfo && ((VlogMacroInfo)element).isUndef()) {
            signature = String.valueOf(signature) + " [is undefined]";
        } else if (element instanceof VlogMacroInfo && !((VlogMacroInfo)element).hasParams() && ((VlogMacroInfo)element).hasReplacement()) {
            String replacement = ((VlogMacroInfo)element).getReplacement(null, null, line, parserPath);
            if (replacement != null) {
                signature = String.valueOf(signature) + " = " + replacement;
            }
        } else if (element instanceof R2LOverrideFunction) {
            signature = " override " + signature;
        }
        return RfUtils.getStyledText(signature, element.getComment());
    }

    public static void getTooltipFormattedText(IRfNamedElementAndScope elementScope, boolean actualValue, ITextEditor textEditor, DVTTooltipContent tooltipContent) throws VlogException {
        String tooltipComment;
        String waveValue;
        String powerDomains;
        if (elementScope == null) {
            return;
        }
        if (tooltipContent == null) {
            return;
        }
        IRfNamedElement element = elementScope.getIRfNamedElement();
        if (element == null) {
            return;
        }
        if (element instanceof RfFunction) {
            ((RfFunction)element).setSignatureUseCase(MethodSignatureUseCase.TOOLTIP_TEXT);
        }
        String shallow = element.isShallowCompiled() ? "shallow" : (element.isIncrementalShallowCompiled() ? "incremental shallow" : "");
        IFile file = RfUtils.getFile(textEditor);
        int line = tooltipContent.getLine();
        int offset = -1;
        if (line != -1 && file != null) {
            offset = DVTFileUtils.getInstance().getLineOffset(file, line - 1) + tooltipContent.getColumn();
        }
        String signature = null;
        if (element instanceof IRfFieldElement && ELUtils.isActualValueConstant((IRfNamedElement)element) && textEditor instanceof DVTEditor) {
            signature = element.getTooltipSignature(elementScope.getScope(), DesignPathManager.getInstance().getPathFor((DVTEditor)textEditor, offset, element, elementScope.getScope(), false, false), elementScope.getHid(), true);
        } else {
            IRfScopeElement scope = elementScope.getScope();
            signature = actualValue ? element.getTooltipSignature(scope, DesignPathManager.getInstance().getPathFor((DVTEditor)textEditor, offset, element instanceof RfInstance ? (IRfNamedElement)element.getEnclosingScope() : element, elementScope.getScope(), false, false), elementScope.getHid(), true) : element.getSignature();
        }
        if (signature == null) {
            return;
        }
        String upfSignature = "";
        if (element instanceof VlogMacroInfo && ((VlogMacroInfo)element).isUndef()) {
            signature = String.valueOf(signature) + " [is undefined]";
        } else if (element instanceof VlogMacroInfo && !((VlogMacroInfo)element).hasParams() && ((VlogMacroInfo)element).hasReplacement() && textEditor instanceof DVTEditor) {
            ParserPath parserPath = ((DVTEditor)textEditor).getParserPath();
            String replacement = ((VlogMacroInfo)element).getReplacement(null, null, line, parserPath);
            if (replacement != null) {
                signature = String.valueOf(signature) + " = " + replacement;
            }
        } else if (element instanceof R2LOverrideFunction) {
            signature = " override " + signature;
        } else if ((element instanceof RfInstance || element instanceof RfPort) && textEditor instanceof IDVTBreadcrumbHost && (powerDomains = DVTPFUtils.getPowerDomainsForInstanceOrPortUsingDPM((IDVTBreadcrumbHost)((IDVTBreadcrumbHost)textEditor), (IRfNamedElement)element, (String)"<br>", (int)offset, (IRfScopeElement)elementScope.getScope())) != null && !powerDomains.isEmpty()) {
            upfSignature = RfUtils.getStyledText("Low Power Information", powerDomains);
        }
        if (TCViewUtils.getModuleOrEntity((IRfNamedElement)element) != null && (waveValue = DVTWaveViewIDEFactory.getInstance().getTooltipForSignalValueInEditor((IDVTBreadcrumbHost)textEditor, elementScope, "<br>", offset)) != null && !waveValue.isEmpty()) {
            tooltipContent.set(DVTTooltipContent.TooltipContent.WAVE_VALUE, String.valueOf(RfUtils.getNewLineDelimiter()) + RfUtils.wrapIntoParagraph(RfUtils.getEscapedString(waveValue)));
        }
        if (!(element instanceof RfNamedElement) || element.getRfProject() == null || CommentUtils.getInstance().shouldUseOldTooltip()) {
            tooltipComment = element.getComment();
            String commentDelim = tooltipComment.isEmpty() ? "" : RfUtils.getNewLineDelimiter();
            String signatureDelim = upfSignature.isEmpty() ? "" : RfUtils.getNewLineDelimiter();
            String shallowDelim = shallow.isEmpty() ? "" : RfUtils.getNewLineDelimiter();
            tooltipContent.set(DVTTooltipContent.TooltipContent.SIGNATURE, RfUtils.wrapIntoBold(RfUtils.getEscapedString(signature)));
            tooltipContent.set(DVTTooltipContent.TooltipContent.COMMENT, String.valueOf(commentDelim) + RfUtils.getEscapedString(element.getComment()));
            tooltipContent.set(DVTTooltipContent.TooltipContent.SHALLOW, String.valueOf(shallowDelim) + RfUtils.getEscapedString(shallow));
            tooltipContent.set(DVTTooltipContent.TooltipContent.UPF_SIGNATURE, String.valueOf(signatureDelim) + RfUtils.getEscapedString(upfSignature));
            return;
        }
        tooltipComment = element.getRawUntrimmedComment("\n\n");
        if (tooltipComment.isEmpty()) {
            tooltipComment = element.getComment();
        }
        tooltipComment = WaveDromManager.getInstance().getCommentWithExtractedWaveformFile(tooltipComment);
        DVTPair<String, String> tooltipPair = RfUtilsBase.getSpecadorFormatting((RfNamedElement)element, tooltipComment, element.getRfProject().getProject(), textEditor);
        tooltipComment = (String)tooltipPair.getKey();
        tooltipContent.set(DVTTooltipContent.TooltipContent.SIGNATURE, RfUtils.wrapIntoBold(RfUtils.getEscapedString(signature)));
        tooltipContent.set(DVTTooltipContent.TooltipContent.COMMENT, tooltipComment);
        tooltipContent.set(DVTTooltipContent.TooltipContent.SHALLOW, shallow.isEmpty() ? "" : String.valueOf(RfUtils.getNewLineDelimiter()) + shallow);
        tooltipContent.set(DVTTooltipContent.TooltipContent.UPF_SIGNATURE, upfSignature.isEmpty() ? "" : String.valueOf(RfUtils.getNewLineDelimiter()) + upfSignature);
        tooltipContent.set(DVTTooltipContent.TooltipContent.PREFERENCE, (String)tooltipPair.getValue());
    }

    public static RfNamedElementActionHyperlink getCustomRfNamedElementActionHyperlink(RfProject rfProject, ITextEditor editor, IDocument document, int offset) {
        RfNamedElementActionHyperlink associatedTypeAction;
        IPath currentFilePath;
        RfNamedElementActionHyperlink openDeclarationAction;
        block5: {
            try {
                openDeclarationAction = RfUtilsBase.getRfNamedElementActionHyperlink(rfProject, editor, document, offset);
                if (openDeclarationAction != null) break block5;
                return null;
            }
            catch (Exception x) {
                DVTLogger.INSTANCE.logError((Throwable)x);
                return null;
            }
        }
        IRfNamedElement namedElement = openDeclarationAction.getRfNamedElement();
        IRfDefElement declaration = namedElement != null ? namedElement.getDeclaration() : null;
        String elementName = namedElement != null ? namedElement.getName() : null;
        IEditorInput editorInput = editor.getEditorInput();
        IFile currentFile = editorInput != null ? (IFile)editorInput.getAdapter(IFile.class) : null;
        IPath iPath = currentFilePath = currentFile != null ? currentFile.getLocation() : null;
        if (namedElement instanceof VlogMacroInfo || DVTUtilsCommon.INSTANCE.showHyperlinkAction(declaration, elementName, offset, currentFilePath)) {
            return openDeclarationAction;
        }
        if (namedElement instanceof RfInstance && (associatedTypeAction = RfUtilsBase.getAssociatedTypeHyperlink(editor instanceof DVTEditor ? (DVTEditor)editor : null, namedElement, openDeclarationAction.getScope(), rfProject.getProject(), openDeclarationAction.getHyperlinkRegion())) != null && associatedTypeAction.getRfNamedElement() instanceof IRfDesignElement) {
            associatedTypeAction.setScope(openDeclarationAction.getScope());
            return associatedTypeAction;
        }
        return openDeclarationAction;
    }

    public static boolean internalFastCheckIsSorted(RfNamedElement prev, RfNamedElement next) {
        RfDefElement prevDeclaration = prev.getDeclaration();
        RfDefElement nextDeclaration = next.getDeclaration();
        return prevDeclaration != null && nextDeclaration != null && Objects.equals(prevDeclaration.getParserPath(), nextDeclaration.getParserPath()) && prevDeclaration.getStartOffset() < nextDeclaration.getStartOffset();
    }

    public void reparseFiles(Set<IDVTFile> reparsedFiles, IProgressMonitor monitor, IProject project) {
        if (reparsedFiles == null || reparsedFiles.isEmpty()) {
            return;
        }
        DocumentManager documentManager = new DocumentManager();
        try {
            documentManager.activate();
            for (IDVTFile reparsedFile : reparsedFiles) {
                IFile file = reparsedFile.getFile();
                IDocument document = documentManager.getDocument(reparsedFile.getParserPath(), project);
                FileCompileInfo fileCompileInfo = new FileCompileInfo(file);
                VlogModelManager.getInstance().cbIncrementalBuild(monitor, fileCompileInfo, document, true);
            }
        }
        finally {
            documentManager.deactivate();
        }
    }
}

