/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.util;

import java.util.Deque;
import java.util.List;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.DataTypeDimensions;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

public class RfWNamedElementAndScope
implements IRfNamedElementAndScope {
    private IRfNamedElement element;
    private IRfNamedElement elementAssocType;
    private IRfScopeElement initialScope;
    private IRfScopeElement calledFromScope;
    private Deque<RfWNamedElementAndScope> elementAndScopeStack;
    private List<String> selects;
    private DataTypeDimensions dimensions;
    private Hid hid;
    private HidOperator hidContext;

    public RfWNamedElementAndScope(IRfNamedElement element, IRfScopeElement initialScope) {
        this.element = element;
        this.initialScope = initialScope;
    }

    public RfWNamedElementAndScope(IRfNamedElement element, IRfScopeElement initialScope, List<String> selects, DataTypeDimensions dimensions) {
        this(element, initialScope);
        this.selects = selects;
        this.dimensions = dimensions;
    }

    public RfWNamedElementAndScope(IRfNamedElement element, IRfScopeElement initialScope, IRfScopeElement calledFromScope, Deque<RfWNamedElementAndScope> elementAndScopeStack, Hid hid, HidOperator context) {
        this(element, initialScope);
        this.calledFromScope = calledFromScope;
        this.elementAndScopeStack = elementAndScopeStack;
        this.hid = hid;
        this.hidContext = context;
    }

    public RfWNamedElementAndScope(RfWNamedElementAndScope element) {
        if (element != null) {
            this.element = element.element;
            this.initialScope = element.initialScope;
            this.selects = element.selects;
            this.dimensions = element.dimensions;
            this.calledFromScope = element.calledFromScope;
            this.elementAndScopeStack = element.elementAndScopeStack;
            this.hid = element.hid;
            this.hidContext = element.hidContext;
            this.hid = element.hid;
        }
    }

    public HidOperator getHidContext() {
        return this.hidContext;
    }

    public IRfNamedElement getAssocScope() {
        HidAccess parentAccess;
        if (this.elementAssocType != null) {
            return this.elementAssocType;
        }
        IRfScopeElement scope = this.getScope();
        if (this.hid == null) {
            return null;
        }
        RfTypesResolver typesResolver = RfTypesResolver.create(scope, this.getIRfNamedElement().getRfProject(), 8);
        ELManager elManager = typesResolver.getManager();
        IRfNamedElement element = this.hid.getElement();
        if (element != null && element.isPredefined()) {
            Hid parentHid = this.hid.getParentHid();
            if (parentHid != null) {
                IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)parentHid.getElement(), null, (boolean)true, (ELManager)elManager);
                typesResolver.resolveHidInContext((IHidObject)parentHid, guardian, false);
            }
        } else {
            IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)(scope instanceof IRfDefElement ? ((IRfDefElement)scope).getNamedElement() : (IRfNamedElement)scope), null, (boolean)true, (ELManager)elManager);
            typesResolver.resolveHidInContext((IHidObject)this.hid, guardian, false);
        }
        if ((parentAccess = this.hid.getParentAccess()) != null) {
            this.elementAssocType = parentAccess.getAssociatedType();
        }
        return this.elementAssocType;
    }

    public IRfScopeElement getScope() {
        return this.initialScope;
    }

    public Deque<RfWNamedElementAndScope> getElementAndScopeStack() {
        return this.elementAndScopeStack;
    }

    public RfNamedElement getCalledFromScope() {
        if (this.calledFromScope instanceof RfNamedElement) {
            return (RfNamedElement)this.calledFromScope;
        }
        if (this.calledFromScope instanceof RfDefElement) {
            return ((RfDefElement)this.calledFromScope).getNamedElement();
        }
        return null;
    }

    public RfNamedElement getNamedElement() {
        return this.element instanceof RfNamedElement ? (RfNamedElement)this.element : null;
    }

    public IRfNamedElement getIRfNamedElement() {
        return this.element;
    }

    public void setNamedElement(IRfNamedElement element) {
        this.element = element;
    }

    public List<String> getSelects() {
        return this.selects;
    }

    public DataTypeDimensions getDimensions() {
        return this.dimensions;
    }

    public String toString() {
        if (this.element == null) {
            return "element: null";
        }
        return "element: " + this.element.getTooltipSignature(null, null, null, false).replace("\n", "") + " initialScope: " + this.getTypeFromScope(this.initialScope) + " calledFromScope: " + this.getTypeFromScope(this.calledFromScope) + " elementAndScopeStack.size(): " + (this.elementAndScopeStack == null ? "null" : Integer.valueOf(this.elementAndScopeStack.size()));
    }

    private String getTypeFromScope(IRfScopeElement scope) {
        String result = "null";
        if (scope == null || !(scope instanceof RfAssociatedType)) {
            return result;
        }
        DataType dt = ((RfAssociatedType)scope).getDataType();
        if (dt == null) {
            return result;
        }
        return String.valueOf(dt.getTypeName("logic", null)) + "." + dt.getUnpackedDimension();
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public Hid getHid() {
        return this.hid;
    }
}

