/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;

public class VFUtils {
    public static Iterable<RfFunction> virtualParentsIterable(final RfFunction function) {
        return new Iterable<RfFunction>(){

            @Override
            public Iterator<RfFunction> iterator() {
                return new ParentIterator(function, true);
            }
        };
    }

    public static Iterable<RfFunction> parentsIterable(final RfFunction function) {
        return new Iterable<RfFunction>(){

            @Override
            public Iterator<RfFunction> iterator() {
                return new ParentIterator(function, false);
            }
        };
    }

    public static RfFunction getParent(RfFunction function) {
        if (function == null) {
            return null;
        }
        if (!(function.getEnclosingScope() instanceof RfClass)) {
            return null;
        }
        RfClass currentClass = (RfClass)function.getEnclosingScope();
        while ((currentClass = currentClass.getParent()) != null) {
            RfFunction currentFunction = (RfFunction)currentClass.getMember(function.getName(), new HashSet<Class<? extends IRfNamedElement>>(Arrays.asList(RfFunction.class)), null, false, false, false, false, false);
            if (currentFunction == null) continue;
            return currentFunction;
        }
        return null;
    }

    public static RfFunction getVirtualRoot(RfFunction function) {
        RfFunction candidate = null;
        for (RfFunction f2 : VFUtils.parentsIterable(function)) {
            if (!f2.hasVirtualQualifier()) continue;
            candidate = f2;
        }
        return candidate;
    }

    private static class ParentIterator
    implements Iterator<RfFunction> {
        private RfFunction next;
        private RfFunction stopAt;
        private boolean onlyVirtual;

        public ParentIterator(RfFunction function, boolean onlyVirtual) {
            this.onlyVirtual = onlyVirtual;
            this.next = function;
            if (onlyVirtual) {
                this.stopAt = VFUtils.getVirtualRoot(function);
            }
            if (onlyVirtual && this.stopAt == null) {
                this.next = null;
            }
        }

        private void computeNext() {
            this.next = this.onlyVirtual && this.next == this.stopAt ? null : VFUtils.getParent(this.next);
        }

        @Override
        public RfFunction next() {
            RfFunction result = this.next;
            this.computeNext();
            return result;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }
    }
}

