/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.RWSearchTypeEnum;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.benchmark.StopWatch;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfKind;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfScalarType;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedClass;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedTypeAlias;
import ro.amiq.vlogdt.model.reflection.util.VlogRfGUIReferencesUtilsCommon;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.ui.search.ReferenceSearchPageInput;
import ro.amiq.vlogdt.ui.search.RfSearchQueryElement;
import ro.amiq.vlogdt.ui.search.SearchQueryProvider;
import ro.amiq.vlogdt.ui.search.new_engine.MacroCallHitsInfo;
import ro.amiq.vlogdt.ui.search.new_engine.MultiReferenceHidSearchVisitor;
import ro.amiq.vlogdt.ui.search.new_engine.OffsetNamedElementFilePair;
import ro.amiq.vlogdt.ui.search.new_engine.SearchMatchKindsWrapper;
import ro.amiq.vlogdt.ui.search.new_engine.ShowTLMPortsSearchQuery;

public class VlogRfGUIReferencesUtils
extends VlogRfGUIReferencesUtilsCommon {
    private static final Set<Class<? extends IRfNamedElement>> CLASS_PARENT_KIND = new HashSet<Class<? extends IRfNamedElement>>();

    static {
        CLASS_PARENT_KIND.add(RfField.class);
        CLASS_PARENT_KIND.add(RfClass.class);
        CLASS_PARENT_KIND.add(RfModule.class);
        CLASS_PARENT_KIND.add(RfProgram.class);
        CLASS_PARENT_KIND.add(RfPredefinedClass.class);
        CLASS_PARENT_KIND.add(RfTypeAlias.class);
        CLASS_PARENT_KIND.add(RfPredefinedTypeAlias.class);
        CLASS_PARENT_KIND.add(RfInstance.class);
        CLASS_PARENT_KIND.add(RfInstance.RfBindInstance.class);
        CLASS_PARENT_KIND.add(RfModport.class);
    }

    public static boolean matchesMethodArgumentForRefactoring(IRfNamedElement namedElement, IRfNamedElement candidate, boolean forRefactor) {
        if (!forRefactor) {
            return false;
        }
        if (!(namedElement instanceof RfField) || !((RfField)namedElement).isArgument()) {
            return false;
        }
        if (!(namedElement.getEnclosingScope() instanceof RfFunction)) {
            return false;
        }
        if (candidate != null && candidate.getName() != null && !candidate.getName().equals(namedElement.getName())) {
            return false;
        }
        RfFunction elementFunction = (RfFunction)namedElement.getEnclosingScope();
        if (elementFunction.isPredefined() || elementFunction.isConstructor()) {
            return false;
        }
        RfClass elementEnclosingClass = elementFunction.getEnclosingScope(RfClass.class);
        if (elementEnclosingClass == null) {
            return false;
        }
        if (!(candidate instanceof RfField) || !((RfField)candidate).isArgument()) {
            return false;
        }
        IRfScopeElement candidateFunction = candidate.getEnclosingScope();
        if (!(candidateFunction instanceof RfFunction)) {
            return false;
        }
        RfClass candidateEnclosingClass = (RfClass)candidate.getEnclosingScope(RfClass.class);
        if (candidateEnclosingClass == null) {
            return false;
        }
        if (!candidateFunction.getName().equals(elementFunction.getName())) {
            return false;
        }
        RfClass elementParentClassWithVirtualFunction = VlogRfGUIReferencesUtils.getFarthestParentWhereFunctionIsVirtual(elementEnclosingClass, elementFunction);
        if (elementParentClassWithVirtualFunction == null) {
            return false;
        }
        return candidateEnclosingClass == elementParentClassWithVirtualFunction || candidateEnclosingClass.isSubClass(elementParentClassWithVirtualFunction);
    }

    private static RfClass getFarthestParentWhereFunctionIsVirtual(RfClass enclosingClass, RfFunction function) {
        RfClass lastParent = enclosingClass;
        RfClass candidateParent = enclosingClass;
        String functionName = function.getName();
        boolean isVirtual = function.hasVirtualQualifier();
        while ((candidateParent = candidateParent.getParent()) != null) {
            RfFunction tempFunction = candidateParent.getLocalMember(RfFunction.class, functionName, true);
            if (tempFunction == null || !tempFunction.hasVirtualQualifier()) continue;
            lastParent = candidateParent;
            isVirtual = true;
        }
        if (!isVirtual) {
            return null;
        }
        return lastParent;
    }

    public static void showUsagesAction(IRfNamedElement namedElement, IRfScopeElement scopeElement, ElementPath designPathContext, boolean isHierarchicalAccess, IProject project, String searchedString) {
        if (namedElement == null || project == null) {
            return;
        }
        ReferenceSearchPageInput input = new ReferenceSearchPageInput(namedElement, scopeElement, designPathContext, true, false, true, isHierarchicalAccess, null, searchedString);
        ISearchQuery query = new SearchQueryProvider(1, 6, false, true, false, false, RWSearchTypeEnum.USAGES).createQuery((TextSearchQueryProvider.TextSearchInput)input);
        if (query != null) {
            NewSearchUI.runQueryInBackground((ISearchQuery)query);
        }
    }

    public static void showFilteredUsagesAction(IRfNamedElement namedElement, IRfScopeElement scopeElement, IProject project, String searchedString, BiPredicate<IHidObject, IRfClassElement> filterPredicate) {
        if (namedElement == null || project == null) {
            return;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        RfTypesResolver resolver = RfTypesResolver.create(scopeElement, rfProject, 8);
        ShowTLMPortsSearchQuery query = new ShowTLMPortsSearchQuery(project, namedElement, resolver, null, searchedString, filterPredicate);
        if (query != null) {
            NewSearchUI.runQueryInBackground((ISearchQuery)query);
        }
    }

    public static ISearchQuery showReadersAction(IRfFieldElement namedElement, IRfScopeElement scopeElement, ElementPath designContextPath, HidOperator context, IProject project, String searchedString, boolean isHierarchicalAccess) {
        ReferenceSearchPageInput input;
        ISearchQuery query;
        if (namedElement == null || project == null) {
            return null;
        }
        if (RfSearchUtils.isOutputPortInImplicitNamedConnection((IRfNamedElement)namedElement, (IRfScopeElement)scopeElement, (HidOperator)context)) {
            IRfNamedElement implicitNamedElement = RfSearchUtils.getImplicitNamedElement((IRfNamedElement)namedElement, (IRfInstanceElement)((IRfInstanceElement)scopeElement));
            if (implicitNamedElement instanceof IRfFieldElement) {
                namedElement = (IRfFieldElement)implicitNamedElement;
            }
            if (designContextPath != null) {
                designContextPath = DesignPathManager.getInstance().removeTrailingGenerateSegments(project, (IRfNamedElement)namedElement, designContextPath.removeLastSegment());
            }
        }
        if ((query = new SearchQueryProvider(1, 6, false, true, false, false, RWSearchTypeEnum.READERS).createQuery((TextSearchQueryProvider.TextSearchInput)(input = new ReferenceSearchPageInput((IRfNamedElement)namedElement, scopeElement, designContextPath, true, false, true, isHierarchicalAccess, null, searchedString)))) != null) {
            NewSearchUI.runQueryInBackground((ISearchQuery)query);
        }
        return query;
    }

    public static ISearchQuery showWritersAction(IRfFieldElement namedElement, IRfScopeElement scopeElement, ElementPath designContextPath, HidOperator context, IProject project, String string, boolean isHierarchicalAccess) {
        ReferenceSearchPageInput input;
        ISearchQuery query;
        if (namedElement == null || project == null) {
            return null;
        }
        if (RfSearchUtils.isInputPortInImplicitNamedConnection((IRfNamedElement)namedElement, (IRfScopeElement)scopeElement, (HidOperator)context)) {
            IRfNamedElement implicitNamedElement = RfSearchUtils.getImplicitNamedElement((IRfNamedElement)namedElement, (IRfInstanceElement)((IRfInstanceElement)scopeElement));
            if (implicitNamedElement instanceof IRfFieldElement) {
                namedElement = (IRfFieldElement)implicitNamedElement;
            }
            if (designContextPath != null) {
                designContextPath = DesignPathManager.getInstance().removeTrailingGenerateSegments(project, (IRfNamedElement)namedElement, designContextPath.removeLastSegment());
            }
        }
        if ((query = new SearchQueryProvider(1, 6, false, true, false, false, RWSearchTypeEnum.WRITERS).createQuery((TextSearchQueryProvider.TextSearchInput)(input = new ReferenceSearchPageInput((IRfNamedElement)namedElement, scopeElement, designContextPath, true, false, true, isHierarchicalAccess, null, string)))) != null) {
            NewSearchUI.runQueryInBackground((ISearchQuery)query);
        }
        return query;
    }

    public static String getSearchType(IRfNamedElement type) {
        if (type instanceof RfTypeAlias) {
            IRfNamedElement translatedType = ((RfTypeAlias)type).getTranslatedType();
            if (translatedType == null || translatedType instanceof RfTypeAlias) {
                return "Typedef";
            }
            return "Typedef (" + VlogRfGUIReferencesUtils.getSearchType(translatedType) + ")";
        }
        if (type instanceof RfScalarType) {
            return "Scalar";
        }
        if (type instanceof RfStruct) {
            if (((RfStruct)type).isStruct()) {
                return "Struct";
            }
            if (((RfStruct)type).isEnum()) {
                return "Enum";
            }
            if (((RfStruct)type).isUnion()) {
                return "Union";
            }
        }
        if (type instanceof RfClass) {
            return "Class";
        }
        if (type instanceof RfProgram) {
            return "Program";
        }
        if (type instanceof RfModule) {
            return "Module";
        }
        if (type instanceof RfPackage) {
            return "Package";
        }
        if (type instanceof RfInterface) {
            return "Interface";
        }
        if (type instanceof RfCovergroup) {
            return "Cover group";
        }
        if (type instanceof RfField) {
            if (((RfField)type).isEvent()) {
                return "Event";
            }
            return "Field";
        }
        if (type instanceof RfFunction) {
            if (((RfFunction)type).isTask()) {
                return "Task";
            }
            return "Function";
        }
        if (type instanceof VlogMacroInfo) {
            return "Macro";
        }
        return "Text";
    }

    public static boolean checkEquals(IRfNamedElement namedElement, IRfNamedElement foundElement, boolean isStrictVirtual) {
        if (foundElement == null) {
            return false;
        }
        if (!(foundElement instanceof RfFunction)) {
            return foundElement.checkEquals((Object)namedElement);
        }
        if (!isStrictVirtual) {
            return foundElement.checkEquals((Object)namedElement);
        }
        if (foundElement == namedElement) {
            return true;
        }
        if (!foundElement.getName().equals(namedElement.getName())) {
            return false;
        }
        if (foundElement.getClass() == namedElement.getClass()) {
            RfNamedElement foundEnclScope = ((RfNamedElement)foundElement).getEnclosingScope();
            RfNamedElement rfEnclScope = ((RfNamedElement)namedElement).getEnclosingScope();
            return rfEnclScope.checkEquals(foundEnclScope);
        }
        return false;
    }

    public static boolean isVarInsideForLoop(IRfNamedElement element) {
        if (element instanceof RfField && ((RfField)element).isVariable() && !((RfField)element).isStorageStatic()) {
            return element.getEnclosingScope() instanceof RfActionBlock && ((RfActionBlock)element.getEnclosingScope()).isForOrForeach();
        }
        return false;
    }

    public static IRfNamedElement getNamedElementOfDataType(RfNamedElement element, DataType dataType, boolean isFirst, IRfNamedElement enclosing) {
        if (dataType == null || dataType.getType() == null) {
            return null;
        }
        if (enclosing == null) {
            enclosing = element.getEnclosingScope();
        }
        if (enclosing == null) {
            return null;
        }
        return enclosing.getMember(dataType.getType(), DVTRfUtils.MEMBERS_TYPES, null, isFirst, true, false, true, false);
    }

    /*
     * Unable to fully structure code
     */
    public static Set<IRfNamedElement> getNonOverlappingScopes(Set<IRfNamedElement> allDependencies) {
        result = new HashSet<IRfNamedElement>();
        block0: for (IRfNamedElement dependency : allDependencies) {
            enclosingScope = dependency.getEnclosingScope();
            if (!(dependency instanceof RfInstance.RfBindInstance)) ** GOTO lbl10
            result.add(dependency);
            continue;
            while (!(allDependencies.contains(enclosingScope) && !(enclosingScope instanceof RfLibrary) || allDependencies.contains(enclosingScope) && dependency instanceof RfInstance && enclosingScope instanceof RfModule)) {
                enclosingScope = enclosingScope.getEnclosingScope();
lbl10:
                // 2 sources

                if (enclosingScope != null) continue;
                result.add(dependency);
                continue block0;
            }
        }
        return result;
    }

    public static List<RfNamedElement> getAllFunctionsFromInheritanceTree(RfFunction element, boolean includeDeclarations) {
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        RfNamedElement closestTypeContainer = element.getClosestTypeContainer();
        if (!(closestTypeContainer instanceof RfClass)) {
            return result;
        }
        RfClass clazz = (RfClass)closestTypeContainer;
        HashSet<RfClass> visited = new HashSet<RfClass>();
        visited.add(clazz);
        RfClass parent = clazz.getParent();
        while (parent != null) {
            if (visited.contains(parent)) break;
            visited.add(parent);
            RfFunction localMember = parent.getLocalMember(RfFunction.class, element.getName(), true);
            if (localMember != null) {
                result.add(localMember);
            }
            VlogRfGUIReferencesUtils.getFunctionsFromParentInterfaces(parent, result, visited, element, includeDeclarations);
            VlogRfGUIReferencesUtils.getFunctionsFromChildrenClasses(parent, result, visited, element, includeDeclarations);
            parent = parent.getParent();
        }
        VlogRfGUIReferencesUtils.getFunctionsFromParentInterfaces(clazz, result, visited, element, includeDeclarations);
        VlogRfGUIReferencesUtils.getFunctionsFromChildrenClasses(clazz, result, visited, element, includeDeclarations);
        return result;
    }

    private static void getFunctionsFromParentInterfaces(RfClass clazz, List<RfNamedElement> result, Set<RfClass> visited, RfFunction element, boolean includeDeclarations) {
        List<RfClass> parentInterfaces = clazz.getParentInterfaces();
        if (parentInterfaces == null || parentInterfaces.isEmpty()) {
            return;
        }
        for (RfClass interfaceClass : parentInterfaces) {
            if (visited.contains(interfaceClass)) continue;
            visited.add(interfaceClass);
            RfFunction localMember = interfaceClass.getLocalMember(RfFunction.class, element.getName(), true);
            if (localMember != null) {
                result.add(localMember);
            }
            if (includeDeclarations) {
                VlogRfGUIReferencesUtils.getFunctionsFromChildrenClasses(interfaceClass, result, visited, element, includeDeclarations);
            }
            VlogRfGUIReferencesUtils.getFunctionsFromParentInterfaces(interfaceClass, result, visited, element, includeDeclarations);
        }
    }

    private static void getFunctionsFromChildrenClasses(RfClass clazz, List<RfNamedElement> result, Set<RfClass> visited, RfFunction element, boolean includeDeclarations) {
        Set<RfClass> children = clazz.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (RfClass child : children) {
            if (visited.contains(child)) continue;
            visited.add(child);
            RfFunction localMember = child.getLocalMember(RfFunction.class, element.getName(), true);
            if (localMember != null) {
                result.add(localMember);
            }
            VlogRfGUIReferencesUtils.getFunctionsFromChildrenClasses(child, result, visited, element, includeDeclarations);
        }
    }

    public static List<RfNamedElement> getAllFunctionParametersFromInheritanceTree(RfField field, RfFunction element) {
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        RfNamedElement closestTypeContainer = element.getClosestTypeContainer();
        if (!(closestTypeContainer instanceof RfClass)) {
            return result;
        }
        RfClass clazz = (RfClass)closestTypeContainer;
        HashSet<RfClass> visited = new HashSet<RfClass>();
        visited.add(clazz);
        RfClass parent = clazz.getParent();
        while (parent != null) {
            RfField parameter;
            if (visited.contains(parent)) break;
            visited.add(parent);
            RfFunction currentFunction = parent.getLocalMember(RfFunction.class, element.getName(), true);
            if (currentFunction != null && (parameter = currentFunction.getArgumentWithPrefix(field.getName(), 1)) != null) {
                result.add(parameter);
            }
            VlogRfGUIReferencesUtils.getFunctionsParametersFromParentInterfaces(field, parent, result, visited, element);
            VlogRfGUIReferencesUtils.getFunctionsParametersFromChildrenClasses(field, parent, result, visited, element);
            parent = parent.getParent();
        }
        VlogRfGUIReferencesUtils.getFunctionsParametersFromParentInterfaces(field, clazz, result, visited, element);
        VlogRfGUIReferencesUtils.getFunctionsParametersFromChildrenClasses(field, clazz, result, visited, element);
        return result;
    }

    private static void getFunctionsParametersFromParentInterfaces(RfField field, RfClass clazz, List<RfNamedElement> result, Set<RfClass> visited, RfFunction element) {
        List<RfClass> parentInterfaces = clazz.getParentInterfaces();
        if (parentInterfaces == null || parentInterfaces.isEmpty()) {
            return;
        }
        for (RfClass interfaceClass : parentInterfaces) {
            RfField parameter;
            if (visited.contains(interfaceClass)) continue;
            visited.add(interfaceClass);
            RfFunction currentFunction = interfaceClass.getLocalMember(RfFunction.class, element.getName(), true);
            if (currentFunction != null && (parameter = currentFunction.getArgumentWithPrefix(field.getName(), 1)) != null) {
                result.add(parameter);
            }
            VlogRfGUIReferencesUtils.getFunctionsParametersFromParentInterfaces(field, interfaceClass, result, visited, element);
            VlogRfGUIReferencesUtils.getFunctionsParametersFromChildrenClasses(field, interfaceClass, result, visited, element);
        }
    }

    private static void getFunctionsParametersFromChildrenClasses(RfField field, RfClass clazz, List<RfNamedElement> result, Set<RfClass> visited, RfFunction element) {
        Set<RfClass> children = clazz.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (RfClass child : children) {
            RfField parameter;
            if (visited.contains(child)) continue;
            visited.add(child);
            RfFunction currentFunction = child.getLocalMember(RfFunction.class, element.getName(), true);
            if (currentFunction != null && (parameter = currentFunction.getArgumentWithPrefix(field.getName(), 1)) != null) {
                result.add(parameter);
            }
            VlogRfGUIReferencesUtils.getFunctionsParametersFromParentInterfaces(field, clazz, result, visited, element);
            VlogRfGUIReferencesUtils.getFunctionsParametersFromChildrenClasses(field, child, result, visited, element);
        }
    }

    public static List<RfNamedElement> getAllConstraintsFromInheritanceTree(RfConstraint constraint) {
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        RfNamedElement closestTypeContainer = constraint.getClosestTypeContainer();
        if (!(closestTypeContainer instanceof RfClass)) {
            return result;
        }
        RfClass clazz = (RfClass)closestTypeContainer;
        HashSet<RfClass> visited = new HashSet<RfClass>();
        visited.add(clazz);
        RfClass parent = clazz.getParent();
        while (parent != null) {
            if (visited.contains(parent)) break;
            visited.add(parent);
            RfConstraint localMember = parent.getLocalMember(RfConstraint.class, constraint.getName(), true);
            if (localMember != null) {
                result.add(localMember);
            }
            VlogRfGUIReferencesUtils.getConstraintsFromParentInterfaces(parent, result, visited, constraint);
            VlogRfGUIReferencesUtils.getConstraintsFromChildrenClasses(parent, result, visited, constraint);
            parent = parent.getParent();
        }
        VlogRfGUIReferencesUtils.getConstraintsFromParentInterfaces(clazz, result, visited, constraint);
        VlogRfGUIReferencesUtils.getConstraintsFromChildrenClasses(clazz, result, visited, constraint);
        return result;
    }

    private static void getConstraintsFromParentInterfaces(RfClass clazz, List<RfNamedElement> result, Set<RfClass> visited, RfConstraint constraint) {
        List<RfClass> parentInterfaces = clazz.getParentInterfaces();
        if (parentInterfaces == null || parentInterfaces.isEmpty()) {
            return;
        }
        for (RfClass interfaceClass : parentInterfaces) {
            if (visited.contains(interfaceClass)) continue;
            visited.add(interfaceClass);
            RfConstraint localMember = interfaceClass.getLocalMember(RfConstraint.class, constraint.getName(), true);
            if (localMember != null) {
                result.add(localMember);
            }
            VlogRfGUIReferencesUtils.getConstraintsFromParentInterfaces(interfaceClass, result, visited, constraint);
            VlogRfGUIReferencesUtils.getConstraintsFromChildrenClasses(interfaceClass, result, visited, constraint);
        }
    }

    private static void getConstraintsFromChildrenClasses(RfClass clazz, List<RfNamedElement> result, Set<RfClass> visited, RfConstraint constraint) {
        Set<RfClass> children = clazz.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (RfClass child : children) {
            if (visited.contains(child)) continue;
            visited.add(child);
            RfConstraint localMember = child.getLocalMember(RfConstraint.class, constraint.getName(), true);
            if (localMember != null) {
                result.add(localMember);
            }
            VlogRfGUIReferencesUtils.getConstraintsFromParentInterfaces(child, result, visited, constraint);
            VlogRfGUIReferencesUtils.getConstraintsFromChildrenClasses(child, result, visited, constraint);
        }
    }

    private static IRfNamedElement changeSearchedElement(IRfNamedElement namedElement) {
        if (namedElement instanceof RfResultImplicitVariable && namedElement.getEnclosingScope() instanceof RfFunction) {
            return (RfFunction)namedElement.getEnclosingScope();
        }
        return namedElement;
    }

    public static List<IRfNamedElement> getElementsToSearch(IRfNamedElement namedElement, boolean includeDeclarations, boolean semanticSearch) {
        ArrayList<IRfNamedElement> elements = new ArrayList<IRfNamedElement>();
        IRfNamedElement changeSearchedElement = VlogRfGUIReferencesUtils.changeSearchedElement(namedElement);
        elements.add(changeSearchedElement);
        if (semanticSearch) {
            return elements;
        }
        if (changeSearchedElement instanceof RfFunction && ((RfFunction)changeSearchedElement).isVirtual()) {
            elements.addAll(VlogRfGUIReferencesUtils.getAllFunctionsFromInheritanceTree((RfFunction)changeSearchedElement, includeDeclarations));
        }
        if (changeSearchedElement instanceof RfConstraint) {
            elements.addAll(VlogRfGUIReferencesUtils.getAllConstraintsFromInheritanceTree((RfConstraint)changeSearchedElement));
        } else if (includeDeclarations && changeSearchedElement instanceof RfField && changeSearchedElement.getEnclosingScope() instanceof RfFunction && ((RfFunction)changeSearchedElement.getEnclosingScope()).isVirtual()) {
            elements.addAll(VlogRfGUIReferencesUtils.getAllFunctionParametersFromInheritanceTree((RfField)changeSearchedElement, (RfFunction)changeSearchedElement.getEnclosingScope()));
        }
        return elements;
    }

    public static void computeMatchesForSemanticSearch(IReportHitsListener<SearchHit> listener, Pattern searchPattern, IProject project, IRfNamedElement namedElement, IProgressMonitor monitor, Map<IProject, Set<ParserPath>> searchedFiles, FileSynchedAndAvailableManager fileManager, boolean includeDeclarations, boolean forRefactoring, boolean isStrictVirtual, boolean disableHitInMacroArgument) {
        DocumentManager documentManager = new DocumentManager();
        try {
            List<IRfNamedElement> userDefinedElements;
            documentManager.activate();
            IRfSingleLangProject rfSingleLangProject = RfMixedLangManager.getInstance().getRfSingleLangProject(project, "ro.amiq.vlogdt.VlogNature", true);
            if (!(rfSingleLangProject instanceof RfProject) || !(namedElement instanceof RfSearchQueryElement)) {
                return;
            }
            RfProject rfProject = (RfProject)rfSingleLangProject;
            List<IRfNamedElement> elements = VlogRfGUIReferencesUtils.getElementsToBeSearchedFor(rfProject, searchPattern, (RfSearchQueryElement)namedElement);
            if (elements == null || elements.isEmpty()) {
                return;
            }
            VlogRfGUIReferencesUtils.logDebug((String)("[SEARCH ENGINE: VHDLDT] Semantic search: Elements that match the search pattern '" + searchPattern + "' and the selected search type '" + ((RfSearchQueryElement)namedElement).getStringType() + "' are: " + elements));
            ElementsWrapper elementsWrapper = VlogRfGUIReferencesUtils.getElementsWrapper(elements);
            List<IRfNamedElement> predefinedElements = elementsWrapper.getPredefinedElements();
            if (predefinedElements != null && !predefinedElements.isEmpty()) {
                VlogRfGUIReferencesUtils.serchForPredefinedElements(listener, project, monitor, searchedFiles, includeDeclarations, forRefactoring, isStrictVirtual, documentManager, rfProject, predefinedElements, disableHitInMacroArgument);
            }
            if ((userDefinedElements = elementsWrapper.getUserDefinedElements()) == null || userDefinedElements.isEmpty()) {
                return;
            }
            try {
                for (IRfNamedElement element : userDefinedElements) {
                    RfSearchUtils.computeReferences(listener, (IProject)project, (IRfNamedElement)element, null, (String)element.getName(), (IProgressMonitor)monitor, searchedFiles, (FileSynchedAndAvailableManager)fileManager, (boolean)includeDeclarations, (boolean)forRefactoring, (boolean)isStrictVirtual, (boolean)false, (boolean)disableHitInMacroArgument);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        finally {
            documentManager.deactivate();
        }
    }

    private static void serchForPredefinedElements(IReportHitsListener<SearchHit> listener, IProject project, IProgressMonitor monitor, Map<IProject, Set<ParserPath>> searchedFiles, boolean includeDeclarations, boolean forRefactoring, boolean isStrictVirtual, DocumentManager documentManager, RfProject rfProject, List<IRfNamedElement> predefinedElements, boolean disableHitInMacroArgument) {
        HashMap<OffsetNamedElementFilePair, MacroCallHitsInfo> macroInfoMap = new HashMap<OffsetNamedElementFilePair, MacroCallHitsInfo>();
        FileSynchedAndAvailableManager fileManager = new FileSynchedAndAvailableManager(VlogRfReferencesUtils.getSearchedFiles(searchedFiles), monitor, false);
        HashMap<RfFunction, LinkedHashSet<RfClass>> functionClassFamily = new HashMap<RfFunction, LinkedHashSet<RfClass>>();
        MultiReferenceHidSearchVisitor hidVisitor = new MultiReferenceHidSearchVisitor(monitor, fileManager, predefinedElements, "", true, isStrictVirtual, project, forRefactoring, macroInfoMap, documentManager, includeDeclarations, listener, functionClassFamily, RfTypesResolver.create((IRfScopeElement)rfProject, rfProject, 8), disableHitInMacroArgument);
        rfProject.visitHidObject(null, hidVisitor);
        try {
            hidVisitor.reportFromBuffer();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private static List<IRfNamedElement> getElementsToBeSearchedFor(RfProject rfProject, Pattern searchpattern, RfSearchQueryElement namedElement) {
        Matcher matcher = searchpattern.matcher("");
        String searchPackage = null;
        String[] searchStructs = null;
        if (matcher.pattern().pattern().startsWith("`")) {
            matcher = Pattern.compile(matcher.pattern().pattern().substring(1)).matcher("");
        } else {
            String[] tempMatchPatterns = DVTStringUtil.split((Pattern)DVTStringUtil.BACKSLASH_DOT, (String)matcher.pattern().pattern());
            if (tempMatchPatterns.length == 1) {
                if ((tempMatchPatterns = DVTStringUtil.split((Pattern)DVTStringUtil.COLON_COLON, (String)tempMatchPatterns[0])).length == 2) {
                    searchPackage = tempMatchPatterns[0];
                    matcher = Pattern.compile(tempMatchPatterns[1]).matcher("");
                }
            } else if (tempMatchPatterns.length > 1) {
                int index = tempMatchPatterns[0].indexOf("::");
                if (tempMatchPatterns.length > 0 && index > 0) {
                    searchPackage = tempMatchPatterns[0].substring(0, index);
                    tempMatchPatterns[0] = tempMatchPatterns[0].substring(index + 2);
                }
                searchStructs = new String[tempMatchPatterns.length - 1];
                int i = 0;
                while (i < tempMatchPatterns.length - 1) {
                    searchStructs[i] = tempMatchPatterns[tempMatchPatterns.length - 2 - i];
                    ++i;
                }
                matcher = Pattern.compile(tempMatchPatterns[tempMatchPatterns.length - 1]).matcher("");
            }
        }
        switch (namedElement.getType()) {
            case 0: {
                return VlogRfGUIReferencesUtils.filterEelements(rfProject.getAllTypes(false, false), matcher, namedElement, searchPackage, searchStructs);
            }
            case 1: 
            case 5: {
                return VlogRfGUIReferencesUtils.filterEelements(rfProject.getAllFunctionsAndTasks(true), matcher, namedElement, searchPackage, searchStructs);
            }
            case 2: {
                return VlogRfGUIReferencesUtils.filterEelements(rfProject.getAllFields(), matcher, namedElement, searchPackage, searchStructs);
            }
            case 3: {
                return VlogRfGUIReferencesUtils.filterEelements(rfProject.getAllEvents(), matcher, namedElement, searchPackage, searchStructs);
            }
            case 4: {
                return VlogRfGUIReferencesUtils.filterEelements(rfProject.getAllCovergroups(), matcher, namedElement, searchPackage, searchStructs);
            }
            case 7: {
                List<VlogMacroInfo> macros = rfProject.getAllMacros();
                if (macros == null) {
                    return null;
                }
                return VlogRfGUIReferencesUtils.filterEelements(macros.toArray(new RfNamedElement[macros.size()]), matcher, namedElement, searchPackage, searchStructs);
            }
        }
        return null;
    }

    private static ElementsWrapper getElementsWrapper(List<IRfNamedElement> elements) {
        ElementsWrapper wrapper = new ElementsWrapper();
        if (elements == null || elements.isEmpty()) {
            return wrapper;
        }
        for (IRfNamedElement element : elements) {
            if (element instanceof RfPredefinedFunction || element instanceof RfPredefinedField) {
                wrapper.addPredefinedElement(element);
                continue;
            }
            wrapper.addUserDefinedElement(element);
        }
        return wrapper;
    }

    private static List<IRfNamedElement> filterEelements(RfNamedElement[] allElements, Matcher matcher, RfSearchQueryElement namedElement, String searchPackage, String[] searchStructs) {
        ArrayList<IRfNamedElement> result = new ArrayList<IRfNamedElement>();
        if (allElements == null || allElements.length == 0) {
            return result;
        }
        int searchFor = namedElement.getType();
        RfNamedElement[] rfNamedElementArray = allElements;
        int n = allElements.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                RfNamedElement element;
                block11: {
                    element = rfNamedElementArray[n2];
                    if (searchFor == 1 && element instanceof RfFunction && ((RfFunction)element).isTask() || searchFor == 5 && element instanceof RfFunction && !((RfFunction)element).isTask()) break block10;
                    matcher.reset(element.getName());
                    if (!matcher.matches()) break block10;
                    if (searchPackage == null && searchStructs == null) break block11;
                    RfNamedElement enclosing = element;
                    if (searchStructs != null) {
                        String[] stringArray = searchStructs;
                        int n3 = searchStructs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String struct = stringArray[n4];
                            if ((enclosing = enclosing.getEnclosingScope()) != null && Pattern.matches(struct, enclosing.getName())) {
                                ++n4;
                                continue;
                            }
                            break block10;
                        }
                    }
                    if (searchPackage != null && ((enclosing = enclosing.getEnclosingScope()) == null || !Pattern.matches(searchPackage, enclosing.getName()))) break block10;
                }
                result.add(element);
            }
            ++n2;
        }
        return result;
    }

    public static void logComputeReferencesTime(IRfNamedElement namedElement, long startTime) {
        long stopTime = System.currentTimeMillis();
        DVTLogger.INSTANCE.logInfo("[REFERENCES ENGINE BENCHMARK] VLOGDT - NEW SEARCH ENGINE - time for references of " + RfKind.of(namedElement).getName() + " " + namedElement.getName() + " = " + StopWatch.formatTime((long)(stopTime - startTime)));
    }

    public static boolean isSemanticSearch(IRfNamedElement namedElement) {
        return namedElement instanceof RfSearchQueryElement;
    }

    public static boolean skipNonStrictMatchesInSemanticSearchMode(boolean isSemanticSearch, SearchMatchKindsWrapper searchMatchKind) {
        if (!isSemanticSearch) {
            return false;
        }
        if (searchMatchKind == null) {
            return false;
        }
        if (searchMatchKind.getFunctionCallKind() != null && searchMatchKind.getFunctionCallKind() != RfFunction.FunctionCallKind.STRICT) {
            return true;
        }
        return searchMatchKind.getTypeCompatibleKind() != null && searchMatchKind.getTypeCompatibleKind() != RfField.TypeCompatibilityMatchKind.STRICT_MATCH;
    }

    public static boolean isClassFieldOrFunctionArgument(IRfNamedElement namedELement) {
        if (!(namedELement instanceof RfField)) {
            return false;
        }
        RfField rfField = (RfField)namedELement;
        if (rfField.isField() && rfField.getEnclosingScope() instanceof RfClass) {
            return true;
        }
        return rfField.isArgument() && rfField.getEnclosingScope() instanceof RfFunction;
    }

    public static boolean isChildOfScope(IRfNamedElement parentScope, RfNamedElement childCandidateScope, String fieldName) {
        if (parentScope == null || childCandidateScope == null) {
            return false;
        }
        if (parentScope == childCandidateScope) {
            return true;
        }
        if (childCandidateScope.getLocalMember(RfField.class, fieldName, false) != null) {
            return false;
        }
        return VlogRfGUIReferencesUtils.isChildOfScope(parentScope, childCandidateScope.getEnclosingScope(), fieldName);
    }

    static class ElementsWrapper {
        private List<IRfNamedElement> predefinedElements = new ArrayList<IRfNamedElement>();
        private List<IRfNamedElement> userDefinedElements = new ArrayList<IRfNamedElement>();

        public List<IRfNamedElement> getPredefinedElements() {
            return this.predefinedElements;
        }

        public List<IRfNamedElement> getUserDefinedElements() {
            return this.userDefinedElements;
        }

        public void addPredefinedElement(IRfNamedElement element) {
            this.predefinedElements.add(element);
        }

        public void addUserDefinedElement(IRfNamedElement element) {
            this.userDefinedElements.add(element);
        }
    }
}

