/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.indexer.GreyCodePair;
import ro.amiq.dvt.model.indexer.IdentifierIndexerManager;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfConfigurationRule;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.refactor.rename.NameConflictStatus;
import ro.amiq.dvt.ui.refactor.rename.NameConflictStatusType;
import ro.amiq.dvt.ui.refactor.rename.RenameAcrossHierarchyInfo;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.search.RWSearchTypeEnum;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.utils.SearchedElementWrapper;
import ro.amiq.vlogdt.model.indexer.IdentifierIndexer;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfMacroVisitor;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfConfiguration;
import ro.amiq.vlogdt.model.reflection.RfConfigurationRule;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedActionBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfScalarType;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfSuperImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.SearchDependencyContainer;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedClass;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.parser.CodePreprocFileInfo;
import ro.amiq.vlogdt.parser.CodePreprocLineInfo;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.ui.editor.VlogWordFinder;
import ro.amiq.vlogdt.ui.preferences.PrefConst;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameRefactorInfo;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameWithFileInfo;
import ro.amiq.vlogdt.ui.search.MacroCallSearchStatus;
import ro.amiq.vlogdt.ui.search.MacroSearchVisitor;
import ro.amiq.vlogdt.ui.search.RfSearchQueryElement;
import ro.amiq.vlogdt.ui.search.new_engine.ForceHidOperatorVisitor;
import ro.amiq.vlogdt.ui.search.new_engine.MacroCallHitsInfo;
import ro.amiq.vlogdt.ui.search.new_engine.MacroCallParameterHit;
import ro.amiq.vlogdt.ui.search.new_engine.OffsetNamedElementFilePair;
import ro.amiq.vlogdt.ui.search.new_engine.ReferenceCommentDefElementVisitor;
import ro.amiq.vlogdt.ui.search.new_engine.ReferenceHidOperatorVisitor;
import ro.amiq.vlogdt.ui.search.new_engine.ReferenceHidSearchVisitor;
import ro.amiq.vlogdt.ui.search.new_engine.ReferenceImportExportHidOperatorVisitor;
import ro.amiq.vlogdt.ui.search.new_engine.ReferenceNamedElementVisitor;
import ro.amiq.vlogdt.ui.search.new_engine.ReferencePotentialHidVisitor;
import ro.amiq.vlogdt.ui.search.new_engine.SearchMatchKindsWrapper;
import ro.amiq.vlogdt.ui.search.text.SearchMatchKindLineElement;
import ro.amiq.vlogdt.ui.search.text.VlogSearchHit;
import ro.amiq.vlogdt.utils.Utils;

public class VlogRfReferencesUtilsCommon
extends RfReferencesUtils {
    private static final int SCAN_LIMIT = 1000;
    private static final String REFERENCES_ENGINE_MACRO_INFO_MESSAGE = "[REFERENCES ENGINE] Reverted to old search engine (macro) for ";
    public static final String NOT_SUPPORTED_RENAME_MESSAGE = "The operation is unavailable on the current selection (the scope could not be determined). Please select another Verilog Language element name or the same element from another location.";
    public static final String IS_PREDEFINED_ELEMENT_RENAME_MESSAGE = "The operation is not allowed on the current selection (the selected element is predefined). Please select another Verilog Language element.";
    private static final Set<Class<? extends IRfNamedElement>> CLASS_PARENT_KIND = new HashSet<Class<? extends IRfNamedElement>>();
    public static final String NEW_NAME_IS_KEYWORD = "New name{0} is a keyword.";
    private static final Set<Class<? extends IRfNamedElement>> acceptedTopLevelTypes = new HashSet<Class>(Arrays.asList(RfClass.class, RfModule.class, RfInterface.class, RfProgram.class, RfPackage.class, RfChecker.class, RfConfiguration.class));

    static {
        CLASS_PARENT_KIND.add(RfField.class);
        CLASS_PARENT_KIND.add(RfClass.class);
        CLASS_PARENT_KIND.add(RfModule.class);
        CLASS_PARENT_KIND.add(RfProgram.class);
        CLASS_PARENT_KIND.add(RfPredefinedClass.class);
        CLASS_PARENT_KIND.add(RfTypeAlias.class);
        CLASS_PARENT_KIND.add(RfPredefinedTypeAlias.class);
        CLASS_PARENT_KIND.add(RfInstance.class);
        CLASS_PARENT_KIND.add(RfInstance.RfBindInstance.class);
        CLASS_PARENT_KIND.add(RfModport.class);
    }

    private static Map<IProject, Set<ParserPath>> getCompiledFiles(RfProject rfProject) {
        if (rfProject == null) {
            return Collections.emptyMap();
        }
        Set<ParserPath> compiledFilesSet = rfProject.getCompiledFilesSet();
        if (compiledFilesSet == null || compiledFilesSet.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<IProject, Set<ParserPath>> result = new HashMap<IProject, Set<ParserPath>>();
        result.put(rfProject.getProject(), compiledFilesSet);
        return result;
    }

    public static IStatus computeMacrosHits(IRfNamedElement namedElement, RfProject rfProject, Pattern searchPattern, Map<IProject, Set<ParserPath>> searchedFiles, FileSynchedAndAvailableManager fileManager, boolean includeDeclarations, IProgressMonitor monitor, IReportHitsListener<SearchHit> reportListener) {
        String patternText = namedElement.getName();
        DVTLogger.INSTANCE.logInfo("[REFERENCES ENGINE] Reverted to old search engine (macro) for \"" + patternText + "\"");
        Map<IProject, Set<ParserPath>> filesToSearchIn = searchedFiles == null || searchedFiles.isEmpty() ? VlogRfReferencesUtilsCommon.getCompiledFiles(rfProject) : searchedFiles;
        return new MacroSearchVisitor(namedElement, searchPattern, includeDeclarations, namedElement.getName(), reportListener, fileManager).search(monitor, filesToSearchIn);
    }

    public static boolean searchForMacros(IRfNamedElement namedElement) {
        return namedElement instanceof VlogMacroInfo || namedElement instanceof RfSearchQueryElement && ((RfSearchQueryElement)namedElement).isMacro();
    }

    public static boolean matchesMethodArgumentForRefactoring(IRfNamedElement namedElement, IRfNamedElement candidate, boolean forRefactor) {
        if (!forRefactor) {
            return false;
        }
        if (!(namedElement instanceof RfField) || !((RfField)namedElement).isArgument()) {
            return false;
        }
        if (!(namedElement.getEnclosingScope() instanceof RfFunction)) {
            return false;
        }
        if (candidate != null && candidate.getName() != null && !candidate.getName().equals(namedElement.getName())) {
            return false;
        }
        RfFunction elementFunction = (RfFunction)namedElement.getEnclosingScope();
        if (elementFunction.isPredefined() || elementFunction.isConstructor()) {
            return false;
        }
        RfClass elementEnclosingClass = elementFunction.getEnclosingScope(RfClass.class);
        if (elementEnclosingClass == null) {
            return false;
        }
        if (!(candidate instanceof RfField) || !((RfField)candidate).isArgument()) {
            return false;
        }
        IRfScopeElement candidateFunction = candidate.getEnclosingScope();
        if (!(candidateFunction instanceof RfFunction)) {
            return false;
        }
        RfClass candidateEnclosingClass = (RfClass)candidate.getEnclosingScope(RfClass.class);
        if (candidateEnclosingClass == null) {
            return false;
        }
        if (!candidateFunction.getName().equals(elementFunction.getName())) {
            return false;
        }
        RfClass elementParentClassWithVirtualFunction = VlogRfReferencesUtilsCommon.getFarthestParentWhereFunctionIsVirtual(elementEnclosingClass, elementFunction);
        if (elementParentClassWithVirtualFunction == null) {
            return false;
        }
        return candidateEnclosingClass == elementParentClassWithVirtualFunction || candidateEnclosingClass.isSubClass(elementParentClassWithVirtualFunction);
    }

    private static RfClass getFarthestParentWhereFunctionIsVirtual(RfClass enclosingClass, RfFunction function) {
        RfClass lastParent = enclosingClass;
        RfClass candidateParent = enclosingClass;
        String functionName = function.getName();
        boolean isVirtual = function.hasVirtualQualifier();
        while ((candidateParent = candidateParent.getParent()) != null) {
            RfFunction tempFunction = candidateParent.getLocalMember(RfFunction.class, functionName, true);
            if (tempFunction == null || !tempFunction.hasVirtualQualifier()) continue;
            lastParent = candidateParent;
            isVirtual = true;
        }
        if (!isVirtual) {
            return null;
        }
        return lastParent;
    }

    public static String getSearchType(IRfNamedElement type) {
        if (type instanceof RfTypeAlias) {
            IRfNamedElement translatedType = ((RfTypeAlias)type).getTranslatedType();
            if (translatedType == null || translatedType instanceof RfTypeAlias) {
                return "Typedef";
            }
            return "Typedef (" + VlogRfReferencesUtilsCommon.getSearchType(translatedType) + ")";
        }
        if (type instanceof RfScalarType) {
            return "Scalar";
        }
        if (type instanceof RfStruct) {
            if (((RfStruct)type).isStruct()) {
                return "Struct";
            }
            if (((RfStruct)type).isEnum()) {
                return "Enum";
            }
            if (((RfStruct)type).isUnion()) {
                return "Union";
            }
        }
        if (type instanceof RfClass) {
            return "Class";
        }
        if (type instanceof RfProgram) {
            return "Program";
        }
        if (type instanceof RfModule) {
            return "Module";
        }
        if (type instanceof RfPackage) {
            return "Package";
        }
        if (type instanceof RfInterface) {
            return "Interface";
        }
        if (type instanceof RfCovergroup) {
            return "Cover group";
        }
        if (type instanceof RfField) {
            if (((RfField)type).isEvent()) {
                return "Event";
            }
            return "Field";
        }
        if (type instanceof RfFunction) {
            if (((RfFunction)type).isTask()) {
                return "Task";
            }
            return "Function";
        }
        if (type instanceof VlogMacroInfo) {
            return "Macro";
        }
        return "Text";
    }

    public static boolean checkEquals(IRfNamedElement namedElement, RfTypesResolver namedResolver, IRfNamedElement foundElement, RfTypesResolver foundResolver, boolean isStrictVirtual, Map<RfFunction, LinkedHashSet<RfClass>> functionClassFamily) {
        if (foundElement == null) {
            return false;
        }
        if (!(foundElement instanceof RfFunction)) {
            return foundElement.checkEquals((Object)namedElement);
        }
        if (!isStrictVirtual) {
            if (foundElement instanceof RfFunction && ((RfFunction)foundElement).isVirtual() && namedElement instanceof RfFunction && ((RfFunction)namedElement).isVirtual()) {
                LinkedHashSet<RfClass> computeClassFamily = VlogRfReferencesUtilsCommon.computeFunctionClassFamily((RfFunction)foundElement, functionClassFamily);
                return ((RfFunction)foundElement).computeEquals(foundResolver, namedElement, namedResolver, computeClassFamily).isMatch();
            }
            return foundElement.checkEquals((Object)namedElement);
        }
        if (foundElement == namedElement) {
            return true;
        }
        if (!foundElement.getName().equals(namedElement.getName())) {
            return false;
        }
        if (foundElement.getClass() == namedElement.getClass()) {
            RfNamedElement foundEnclScope = ((RfNamedElement)foundElement).getEnclosingScope();
            RfNamedElement rfEnclScope = ((RfNamedElement)namedElement).getEnclosingScope();
            return rfEnclScope.checkEquals(foundEnclScope);
        }
        return false;
    }

    public static boolean isVarInsideForLoop(IRfNamedElement element) {
        if (element instanceof RfField && ((RfField)element).isVariable() && !((RfField)element).isStorageStatic()) {
            return element.getEnclosingScope() instanceof RfActionBlock && ((RfActionBlock)element.getEnclosingScope()).isForOrForeach();
        }
        return false;
    }

    public static IRfNamedElement getNamedElementOfDataType(RfNamedElement element, DataType dataType, boolean isFirst, IRfNamedElement enclosing) {
        if (dataType == null || dataType.getType() == null) {
            return null;
        }
        if (enclosing == null) {
            enclosing = element.getEnclosingScope();
        }
        if (enclosing == null) {
            return null;
        }
        return enclosing.getMember(dataType.getType(), DVTRfUtils.MEMBERS_TYPES, null, isFirst, true, false, true, false);
    }

    /*
     * Unable to fully structure code
     */
    public static Set<IRfNamedElement> getNonOverlappingScopes(Set<IRfNamedElement> allDependencies) {
        result = new HashSet<IRfNamedElement>();
        block0: for (IRfNamedElement dependency : allDependencies) {
            enclosingScope = dependency.getEnclosingScope();
            if (!(dependency instanceof RfInstance.RfBindInstance)) ** GOTO lbl10
            result.add(dependency);
            continue;
            while (!(allDependencies.contains(enclosingScope) && !(enclosingScope instanceof RfLibrary) || allDependencies.contains(enclosingScope) && dependency instanceof RfInstance && enclosingScope instanceof RfModule)) {
                enclosingScope = enclosingScope.getEnclosingScope();
lbl10:
                // 2 sources

                if (enclosingScope != null) continue;
                result.add(dependency);
                continue block0;
            }
        }
        return result;
    }

    public static List<RfNamedElement> getAllFunctionsFromInheritanceTree(RfFunction element, boolean includeDeclarations) {
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        RfNamedElement closestTypeContainer = element.getClosestTypeContainer();
        if (!(closestTypeContainer instanceof RfClass)) {
            return result;
        }
        RfClass clazz = (RfClass)closestTypeContainer;
        HashSet<RfClass> visited = new HashSet<RfClass>();
        visited.add(clazz);
        RfClass parent = clazz.getParent();
        while (parent != null) {
            if (visited.contains(parent)) break;
            visited.add(parent);
            RfFunction localMember = parent.getLocalMember(RfFunction.class, element.getName(), true);
            if (localMember != null) {
                result.add(localMember);
            }
            VlogRfReferencesUtilsCommon.getFunctionsFromParentInterfaces(parent, result, visited, element, includeDeclarations);
            VlogRfReferencesUtilsCommon.getFunctionsFromChildrenClasses(parent, result, visited, element, includeDeclarations);
            parent = parent.getParent();
        }
        VlogRfReferencesUtilsCommon.getFunctionsFromParentInterfaces(clazz, result, visited, element, includeDeclarations);
        VlogRfReferencesUtilsCommon.getFunctionsFromChildrenClasses(clazz, result, visited, element, includeDeclarations);
        return result;
    }

    private static void getFunctionsFromParentInterfaces(RfClass clazz, List<RfNamedElement> result, Set<RfClass> visited, RfFunction element, boolean includeDeclarations) {
        List<RfClass> parentInterfaces = clazz.getParentInterfaces();
        if (parentInterfaces == null || parentInterfaces.isEmpty()) {
            return;
        }
        for (RfClass interfaceClass : parentInterfaces) {
            if (visited.contains(interfaceClass)) continue;
            visited.add(interfaceClass);
            RfFunction localMember = interfaceClass.getLocalMember(RfFunction.class, element.getName(), true);
            if (localMember != null) {
                result.add(localMember);
            }
            if (includeDeclarations) {
                VlogRfReferencesUtilsCommon.getFunctionsFromChildrenClasses(interfaceClass, result, visited, element, includeDeclarations);
            }
            VlogRfReferencesUtilsCommon.getFunctionsFromParentInterfaces(interfaceClass, result, visited, element, includeDeclarations);
        }
    }

    private static void getFunctionsFromChildrenClasses(RfClass clazz, List<RfNamedElement> result, Set<RfClass> visited, RfFunction element, boolean includeDeclarations) {
        Set<RfClass> children = clazz.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (RfClass child : children) {
            if (visited.contains(child)) continue;
            visited.add(child);
            RfFunction localMember = child.getLocalMember(RfFunction.class, element.getName(), true);
            if (localMember != null) {
                result.add(localMember);
            }
            if (includeDeclarations) {
                VlogRfReferencesUtilsCommon.getFunctionsFromParentInterfaces(child, result, visited, element, includeDeclarations);
            }
            VlogRfReferencesUtilsCommon.getFunctionsFromChildrenClasses(child, result, visited, element, includeDeclarations);
        }
    }

    public static List<RfNamedElement> getAllFunctionParametersFromInheritanceTree(RfField field, RfFunction element) {
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        RfNamedElement closestTypeContainer = element.getClosestTypeContainer();
        if (!(closestTypeContainer instanceof RfClass)) {
            return result;
        }
        RfClass clazz = (RfClass)closestTypeContainer;
        HashSet<RfClass> visited = new HashSet<RfClass>();
        visited.add(clazz);
        RfClass parent = clazz.getParent();
        while (parent != null) {
            RfField parameter;
            if (visited.contains(parent)) break;
            visited.add(parent);
            RfFunction currentFunction = parent.getLocalMember(RfFunction.class, element.getName(), true);
            if (currentFunction != null && (parameter = currentFunction.getArgumentWithPrefix(field.getName(), 1)) != null) {
                result.add(parameter);
            }
            VlogRfReferencesUtilsCommon.getFunctionsParametersFromParentInterfaces(field, parent, result, visited, element);
            VlogRfReferencesUtilsCommon.getFunctionsParametersFromChildrenClasses(field, parent, result, visited, element);
            parent = parent.getParent();
        }
        VlogRfReferencesUtilsCommon.getFunctionsParametersFromParentInterfaces(field, clazz, result, visited, element);
        VlogRfReferencesUtilsCommon.getFunctionsParametersFromChildrenClasses(field, clazz, result, visited, element);
        return result;
    }

    private static void getFunctionsParametersFromParentInterfaces(RfField field, RfClass clazz, List<RfNamedElement> result, Set<RfClass> visited, RfFunction element) {
        List<RfClass> parentInterfaces = clazz.getParentInterfaces();
        if (parentInterfaces == null || parentInterfaces.isEmpty()) {
            return;
        }
        for (RfClass interfaceClass : parentInterfaces) {
            RfField parameter;
            if (visited.contains(interfaceClass)) continue;
            visited.add(interfaceClass);
            RfFunction currentFunction = interfaceClass.getLocalMember(RfFunction.class, element.getName(), true);
            if (currentFunction != null && (parameter = currentFunction.getArgumentWithPrefix(field.getName(), 1)) != null) {
                result.add(parameter);
            }
            VlogRfReferencesUtilsCommon.getFunctionsParametersFromParentInterfaces(field, interfaceClass, result, visited, element);
            VlogRfReferencesUtilsCommon.getFunctionsParametersFromChildrenClasses(field, interfaceClass, result, visited, element);
        }
    }

    private static void getFunctionsParametersFromChildrenClasses(RfField field, RfClass clazz, List<RfNamedElement> result, Set<RfClass> visited, RfFunction element) {
        Set<RfClass> children = clazz.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (RfClass child : children) {
            RfField parameter;
            if (visited.contains(child)) continue;
            visited.add(child);
            RfFunction currentFunction = child.getLocalMember(RfFunction.class, element.getName(), true);
            if (currentFunction != null && (parameter = currentFunction.getArgumentWithPrefix(field.getName(), 1)) != null) {
                result.add(parameter);
            }
            VlogRfReferencesUtilsCommon.getFunctionsParametersFromParentInterfaces(field, clazz, result, visited, element);
            VlogRfReferencesUtilsCommon.getFunctionsParametersFromChildrenClasses(field, child, result, visited, element);
        }
    }

    public static List<RfNamedElement> getAllConstraintsFromInheritanceTree(RfConstraint constraint) {
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        RfNamedElement closestTypeContainer = constraint.getClosestTypeContainer();
        if (!(closestTypeContainer instanceof RfClass)) {
            return result;
        }
        RfClass clazz = (RfClass)closestTypeContainer;
        HashSet<RfClass> visited = new HashSet<RfClass>();
        visited.add(clazz);
        RfClass parent = clazz.getParent();
        while (parent != null) {
            if (visited.contains(parent)) break;
            visited.add(parent);
            RfConstraint localMember = parent.getLocalMember(RfConstraint.class, constraint.getName(), true);
            if (localMember != null) {
                result.add(localMember);
            }
            VlogRfReferencesUtilsCommon.getConstraintsFromParentInterfaces(parent, result, visited, constraint);
            VlogRfReferencesUtilsCommon.getConstraintsFromChildrenClasses(parent, result, visited, constraint);
            parent = parent.getParent();
        }
        VlogRfReferencesUtilsCommon.getConstraintsFromParentInterfaces(clazz, result, visited, constraint);
        VlogRfReferencesUtilsCommon.getConstraintsFromChildrenClasses(clazz, result, visited, constraint);
        return result;
    }

    private static void getConstraintsFromParentInterfaces(RfClass clazz, List<RfNamedElement> result, Set<RfClass> visited, RfConstraint constraint) {
        List<RfClass> parentInterfaces = clazz.getParentInterfaces();
        if (parentInterfaces == null || parentInterfaces.isEmpty()) {
            return;
        }
        for (RfClass interfaceClass : parentInterfaces) {
            if (visited.contains(interfaceClass)) continue;
            visited.add(interfaceClass);
            RfConstraint localMember = interfaceClass.getLocalMember(RfConstraint.class, constraint.getName(), true);
            if (localMember != null) {
                result.add(localMember);
            }
            VlogRfReferencesUtilsCommon.getConstraintsFromParentInterfaces(interfaceClass, result, visited, constraint);
            VlogRfReferencesUtilsCommon.getConstraintsFromChildrenClasses(interfaceClass, result, visited, constraint);
        }
    }

    private static void getConstraintsFromChildrenClasses(RfClass clazz, List<RfNamedElement> result, Set<RfClass> visited, RfConstraint constraint) {
        Set<RfClass> children = clazz.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (RfClass child : children) {
            if (visited.contains(child)) continue;
            visited.add(child);
            RfConstraint localMember = child.getLocalMember(RfConstraint.class, constraint.getName(), true);
            if (localMember != null) {
                result.add(localMember);
            }
            VlogRfReferencesUtilsCommon.getConstraintsFromParentInterfaces(child, result, visited, constraint);
            VlogRfReferencesUtilsCommon.getConstraintsFromChildrenClasses(child, result, visited, constraint);
        }
    }

    private static IRfNamedElement changeSearchedElement(IRfNamedElement namedElement) {
        if (namedElement instanceof RfResultImplicitVariable && namedElement.getEnclosingScope() instanceof RfFunction) {
            return (RfFunction)namedElement.getEnclosingScope();
        }
        return namedElement;
    }

    public static List<IRfNamedElement> getElementsToSearch(IRfNamedElement namedElement, boolean includeDeclarations, boolean semanticSearch) {
        ArrayList<IRfNamedElement> elements = new ArrayList<IRfNamedElement>();
        IRfNamedElement changeSearchedElement = VlogRfReferencesUtilsCommon.changeSearchedElement(namedElement);
        elements.add(changeSearchedElement);
        if (semanticSearch) {
            return elements;
        }
        if (changeSearchedElement instanceof RfFunction && ((RfFunction)changeSearchedElement).isVirtual()) {
            elements.addAll(VlogRfReferencesUtilsCommon.getAllFunctionsFromInheritanceTree((RfFunction)changeSearchedElement, includeDeclarations));
        }
        if (changeSearchedElement instanceof RfConstraint) {
            elements.addAll(VlogRfReferencesUtilsCommon.getAllConstraintsFromInheritanceTree((RfConstraint)changeSearchedElement));
        } else if (includeDeclarations && changeSearchedElement instanceof RfField && changeSearchedElement.getEnclosingScope() instanceof RfFunction && ((RfFunction)changeSearchedElement.getEnclosingScope()).isVirtual()) {
            elements.addAll(VlogRfReferencesUtilsCommon.getAllFunctionParametersFromInheritanceTree((RfField)changeSearchedElement, (RfFunction)changeSearchedElement.getEnclosingScope()));
        }
        return elements;
    }

    public static boolean skipNonStrictMatchesInSemanticSearchMode(boolean isSemanticSearch, SearchMatchKindsWrapper searchMatchKind) {
        if (!isSemanticSearch) {
            return false;
        }
        if (searchMatchKind == null) {
            return false;
        }
        if (searchMatchKind.getFunctionCallKind() != null && searchMatchKind.getFunctionCallKind() != RfFunction.FunctionCallKind.STRICT) {
            return true;
        }
        return searchMatchKind.getTypeCompatibleKind() != null && searchMatchKind.getTypeCompatibleKind() != RfField.TypeCompatibilityMatchKind.STRICT_MATCH;
    }

    public static boolean isClassFieldOrFunctionArgument(IRfNamedElement namedELement) {
        if (!(namedELement instanceof RfField)) {
            return false;
        }
        RfField rfField = (RfField)namedELement;
        if (rfField.isField() && rfField.getEnclosingScope() instanceof RfClass) {
            return true;
        }
        return rfField.isArgument() && rfField.getEnclosingScope() instanceof RfFunction;
    }

    public static boolean isChildOfScope(IRfNamedElement parentScope, RfNamedElement childCandidateScope, String fieldName) {
        if (parentScope == null || childCandidateScope == null) {
            return false;
        }
        if (parentScope == childCandidateScope) {
            return true;
        }
        if (childCandidateScope.getLocalMember(RfField.class, fieldName, false) != null) {
            return false;
        }
        return VlogRfReferencesUtilsCommon.isChildOfScope(parentScope, childCandidateScope.getEnclosingScope(), fieldName);
    }

    public static void reportGreyCodeHits(Set<SearchHit> allMatches, DocumentManager documentManager, FileSynchedAndAvailableManager fileManager, RfProject rfProject, IProject project, IReportHitsListener<SearchHit> reportHitsListener, IProgressMonitor monitor, String searchedString) throws Exception {
        Collection lineAndColumnGreyCodeHits = IdentifierIndexerManager.getInstance().getHitsInGreyCode(project, IdentifierIndexer.class, searchedString);
        if (lineAndColumnGreyCodeHits == null || lineAndColumnGreyCodeHits.isEmpty()) {
            return;
        }
        int checkForQueryInterruptionCounter = 0;
        HashMap<ParserPath, CodePreprocLineInfo[]> preprocLineInfoMap = new HashMap<ParserPath, CodePreprocLineInfo[]>();
        for (GreyCodePair greyCodePair : lineAndColumnGreyCodeHits) {
            if (checkForQueryInterruptionCounter++ == 20) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                checkForQueryInterruptionCounter = 0;
            }
            VlogRfReferencesUtilsCommon.reportGreyCodeHit(reportHitsListener, greyCodePair, allMatches, preprocLineInfoMap, documentManager, fileManager, rfProject, project, searchedString);
        }
    }

    private static void reportGreyCodeHit(IReportHitsListener<SearchHit> listener, GreyCodePair greyCodePair, Set<SearchHit> allMatches, Map<ParserPath, CodePreprocLineInfo[]> preprocLineInfoMap, DocumentManager documentManager, FileSynchedAndAvailableManager fileManager, RfProject rfProject, IProject project, String searchedString) throws BadLocationException {
        int line = greyCodePair.getLine();
        int column = greyCodePair.getColumn();
        int fileIndex = greyCodePair.getFileIndex();
        String filename = IdentifierIndexerManager.getInstance().getFile(project, IdentifierIndexer.class, fileIndex);
        ParserPath parserPath = new ParserPath(filename);
        if (!fileManager.isSynchedFile(parserPath, project)) {
            return;
        }
        IDocument document = documentManager.getDocument(parserPath, project);
        if (document == null) {
            return;
        }
        IRegion lineInformation = document.getLineInformation(line - 1);
        int lineOffset = lineInformation.getOffset();
        int offset = lineOffset + column - 1;
        String lineContents = document.get(lineInformation.getOffset(), lineInformation.getLength());
        VlogSearchHit searchElement = new VlogSearchHit(parserPath, line, offset, lineContents, searchedString.length(), project, null);
        String grayCodeSpecialScope = " [Not Compiled]";
        searchElement.setExtraInfo(grayCodeSpecialScope);
        int counter = VlogRfReferencesUtils.countStartWS((String)lineContents);
        if (counter >= 0) {
            searchElement.setSearchedElement(searchedString, offset - lineOffset - counter, true);
        }
        if (allMatches != null && allMatches.contains((Object)searchElement)) {
            return;
        }
        if (VlogRfReferencesUtilsCommon.shouldReport(rfProject, preprocLineInfoMap, parserPath, document, offset)) {
            listener.addMatch((Object)searchElement);
        }
    }

    private static boolean shouldReport(RfProject rfProject, Map<ParserPath, CodePreprocLineInfo[]> preprocLineInfoMap, ParserPath parserPath, IDocument document, int offset) throws BadLocationException {
        CodePreprocLineInfo[] codePreprocLineInfos = VlogRfReferencesUtilsCommon.getPreprocLineInfos(rfProject, preprocLineInfoMap, parserPath);
        if (codePreprocLineInfos == null || codePreprocLineInfos.length == 0) {
            return false;
        }
        int i = 0;
        while (i < codePreprocLineInfos.length) {
            int startOffset = document.getLineOffset(codePreprocLineInfos[i].getLine() - 1) + codePreprocLineInfos[i].getColumn();
            int endOffset = document.getLineOffset(codePreprocLineInfos[i + 1].getLine() - 1) + codePreprocLineInfos[i + 1].getColumn();
            if (startOffset <= offset && offset <= endOffset) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    private static CodePreprocLineInfo[] getPreprocLineInfos(RfProject rfProject, Map<ParserPath, CodePreprocLineInfo[]> map, ParserPath parserPath) {
        if (map.containsKey(parserPath)) {
            return map.get(parserPath);
        }
        CodePreprocFileInfo inactiveCodePositions = Utils.getInstance().getInactiveCodePositions(rfProject, parserPath);
        CodePreprocLineInfo[] codePreprocLineInfos = inactiveCodePositions == null ? null : inactiveCodePositions.getCodePreprocLineInfo();
        map.put(parserPath, codePreprocLineInfos);
        return codePreprocLineInfos;
    }

    public static void computeMatchesForElement(final IReportHitsListener<SearchHit> listener, final RfProject rfProject, IProject project, IProgressMonitor monitor, FileSynchedAndAvailableManager fileManager, boolean includeDeclarations, boolean forRefactoring, final boolean isStrictVirtual, Map<OffsetNamedElementFilePair, MacroCallHitsInfo> macroInfoMap, final DocumentManager documentManager, final IRfNamedElement element, String searchedString, boolean semanticSearch, Map<Integer, List<SearchedElementWrapper>> searchedElementsRelativeDepthPairs, RenameAcrossHierarchyInfo renameWrapper, SearchedElementWrapper elementWrapper, RfTypesResolver resolver, boolean disableHitInMacroArgument) throws Exception {
        IRfNamedElement enclosingScope;
        String operationType;
        if (element instanceof DummyElement && "force_assignments".equals(element.getName())) {
            VlogRfReferencesUtilsCommon.searchForForceAssignments(listener, monitor, documentManager, fileManager, rfProject, project);
            return;
        }
        Job commentSearchJob = null;
        if (forRefactoring && !PrefConst.getRefactorIgnoreJavadocComments() && !VlogRfReferencesUtilsCommon.isLocalScope(element.getEnclosingScope())) {
            commentSearchJob = new Job("Searching for references in comments"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        long start = System.currentTimeMillis();
                        rfProject.accept(new ReferenceCommentDefElementVisitor(element, documentManager, rfProject, (IReportHitsListener<SearchHit>)listener, isStrictVirtual));
                        long end = System.currentTimeMillis();
                        VlogRfReferencesUtilsCommon.logDebug((String)("[SEARCH ENGINE: VLOGDT] Searching in JavaDoc via def visitor: " + (double)(end - start) / 1000.0));
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            commentSearchJob.setSystem(true);
            commentSearchJob.schedule();
        }
        HashMap<RfFunction, LinkedHashSet<RfClass>> functionClassFamily = new HashMap<RfFunction, LinkedHashSet<RfClass>>();
        ReferenceHidOperatorVisitor referenceHidOperatorVisitor = new ReferenceHidOperatorVisitor(monitor, fileManager, element, semanticSearch, isStrictVirtual, project, forRefactoring, macroInfoMap, documentManager, includeDeclarations, listener, searchedElementsRelativeDepthPairs, renameWrapper, elementWrapper, functionClassFamily, resolver, disableHitInMacroArgument);
        ReferenceHidSearchVisitor referenceHidVisitor = new ReferenceHidSearchVisitor(monitor, fileManager, element, searchedString, semanticSearch, isStrictVirtual, project, forRefactoring, macroInfoMap, documentManager, includeDeclarations, listener, elementWrapper, functionClassFamily, resolver, disableHitInMacroArgument);
        ReferenceImportExportHidOperatorVisitor referenceImportExportHidOperatorVisitor = new ReferenceImportExportHidOperatorVisitor(monitor, fileManager, element, project, forRefactoring, macroInfoMap, documentManager, listener, resolver, disableHitInMacroArgument);
        ReferenceNamedElementVisitor referenceNamedElementVisitor = new ReferenceNamedElementVisitor(monitor, fileManager, element, semanticSearch, includeDeclarations, forRefactoring, project, isStrictVirtual, macroInfoMap, documentManager, listener, elementWrapper, functionClassFamily, resolver, disableHitInMacroArgument);
        ReferencePotentialHidVisitor referencePotentialHidVisitor = new ReferencePotentialHidVisitor(monitor, fileManager, element, project, forRefactoring, macroInfoMap, documentManager, listener, resolver, disableHitInMacroArgument);
        String string = operationType = forRefactoring ? "Refactoring" : "Searching";
        if (element.isPredefined()) {
            VlogRfReferencesUtilsCommon.logDebug((String)("[SEARCH ENGINE: VLOGDT] " + operationType + " for predefined " + element.getKindName() + " '" + element.getName() + "'"));
            VlogRfReferencesUtilsCommon.searchForPredefinedElement(referenceHidOperatorVisitor, referenceHidVisitor, referenceImportExportHidOperatorVisitor, referenceNamedElementVisitor, rfProject);
        } else if (RfSearchUtils.isTypeElement((IRfNamedElement)element, (IProject)project)) {
            VlogRfReferencesUtilsCommon.logDebug((String)("[SEARCH ENGINE: VLOGDT] " + operationType + " for type " + element.getKindName() + " '" + element.getName() + "'"));
            VlogRfReferencesUtilsCommon.searchForTypeElement(element, referenceImportExportHidOperatorVisitor, referenceNamedElementVisitor, referenceHidVisitor, rfProject, includeDeclarations, semanticSearch);
        } else {
            VlogRfReferencesUtilsCommon.logDebug((String)("[SEARCH ENGINE: VLOGDT] " + operationType + " for non-type " + element.getKindName() + " '" + element.getName() + "'"));
            VlogRfReferencesUtilsCommon.searchForNonTypeElement(element, referencePotentialHidVisitor, referenceHidOperatorVisitor, referenceHidVisitor, referenceNamedElementVisitor, referenceImportExportHidOperatorVisitor, rfProject, includeDeclarations, semanticSearch);
        }
        if (commentSearchJob != null) {
            commentSearchJob.join();
        }
        if (!RfSearchUtils.isPortOrParameterElement((IRfNamedElement)element) && !(element instanceof IRfDesignElement)) {
            return;
        }
        Object object = enclosingScope = element instanceof IRfDesignElement ? element : element.getEnclosingScope();
        if (!(enclosingScope instanceof IRfDesignElement)) {
            return;
        }
        IRfDesignElement designElement = (IRfDesignElement)enclosingScope;
        ELManager elManager = rfProject.getELManager();
        List instancesFor = elManager.getMemory().getInstancesFor((IRfNamedElement)designElement, designElement.getKind() == IRfNamedElement.ElementKind.VHDL_ENTITY, Integer.MAX_VALUE);
        if (instancesFor == null || instancesFor.isEmpty()) {
            return;
        }
        referenceHidOperatorVisitor.setAssumeHitWhenSameNameAndType();
        referenceNamedElementVisitor.setAssumeHitWhenSameNameAndType();
        referenceNamedElementVisitor.clearHitsOnSameLine();
        for (ELInstance elInstance : instancesFor) {
            Map parameterOverrides;
            List portConnections;
            IRfInstanceElement instanceElement;
            if (elInstance == null || !((instanceElement = elInstance.getDescription()) instanceof RfInstance) || instanceElement instanceof DummyInstance) continue;
            IRfConfiguration elaborationConfig = elInstance.getElaborationConfig();
            IRfConfigurationRule elaborationRule = elInstance.getElaborationRule();
            if ((elaborationConfig == null || elaborationConfig.isDummyConfig()) && elaborationRule == null || elaborationRule != null && (element instanceof IRfPortElement ? (portConnections = elaborationRule.getPortConnections(false, false)) != null && !portConnections.isEmpty() : RfSearchUtils.isParameterElement((IRfNamedElement)element) && (parameterOverrides = elaborationRule.getParameterOverrides(false)) != null && !parameterOverrides.isEmpty())) continue;
            instanceElement.visitHidObject(null, (IHidVisitor)referenceHidOperatorVisitor);
            referenceNamedElementVisitor.visit((RfInstance)instanceElement);
        }
    }

    private static boolean isLocalScope(IRfScopeElement enclosingScope) {
        return enclosingScope instanceof RfFunctionDef || enclosingScope instanceof RfActionBlockDef;
    }

    private static void searchForForceAssignments(IReportHitsListener<SearchHit> listener, IProgressMonitor monitor, DocumentManager documentManager, FileSynchedAndAvailableManager fileManager, RfProject rfProject, IProject project) {
        ForceHidOperatorVisitor forceHidOperatorVisitor = new ForceHidOperatorVisitor(monitor, documentManager, fileManager, listener, project);
        rfProject.visitHidObject(null, forceHidOperatorVisitor);
    }

    static void searchForTypeElement(IRfNamedElement namedElement, ReferenceImportExportHidOperatorVisitor referenceImportExportHidOperator, ReferenceNamedElementVisitor referenceNamedElementVisitor, ReferenceHidSearchVisitor referenceHidVisitor, RfProject rfProject, boolean includeDeclarations, boolean semanticSearch) throws Exception {
        rfProject.visitDirectMembersOfLibraries(referenceNamedElementVisitor);
        referenceNamedElementVisitor.skipDirectLibraryMembers(true);
        Set<IRfNamedElement> referencedScopes = null;
        referencedScopes = namedElement instanceof RfPackage ? VlogRfReferencesUtilsCommon.getAllDependencies(namedElement, rfProject, includeDeclarations, semanticSearch, false) : VlogRfReferencesUtilsCommon.getAllDependencies(namedElement, rfProject, includeDeclarations, semanticSearch, true);
        VlogRfReferencesUtilsCommon.logDebug((String)("[SEARCH ENGINE: VLOGDT] Dependencies for type " + namedElement.getKindName() + " '" + namedElement.getName() + "' are: " + referencedScopes));
        for (IRfNamedElement reference : referencedScopes) {
            Map<ElementPath, List<IRfConfigurationRule>> instanceRules;
            if (reference == null) continue;
            reference.visitHidObject(null, (IHidVisitor)referenceHidVisitor);
            referenceHidVisitor.reportFromBuffer();
            reference.visitHidObject(null, (IHidVisitor)referenceImportExportHidOperator);
            if (reference instanceof RfLibrary && referencedScopes.size() > 1) {
                Collection members = namedElement.getMembers(true, true);
                if (members == null || members.isEmpty()) continue;
                for (IRfNamedElement iRfNamedElement : members) {
                    if (!(iRfNamedElement instanceof RfNamedElement)) continue;
                    if (iRfNamedElement instanceof RfFunction && ((RfFunction)iRfNamedElement).isExtern()) {
                        referenceNamedElementVisitor.visit((RfFunction)iRfNamedElement);
                    }
                    if (!(iRfNamedElement instanceof RfConstraint) || ((RfConstraint)iRfNamedElement).getDeclarations().size() <= 1) continue;
                    referenceNamedElementVisitor.visit((RfConstraint)iRfNamedElement);
                }
            } else if (reference instanceof RfNamedElement) {
                ((RfNamedElement)reference).accept(null, referenceNamedElementVisitor);
            }
            if (!(reference instanceof RfConfiguration) || (instanceRules = ((RfConfiguration)reference).getInstanceRules()) == null) continue;
            for (List<Object> list : instanceRules.values()) {
                if (list == null || list.isEmpty()) continue;
                for (IRfConfigurationRule iRfConfigurationRule : list) {
                    if (!(iRfConfigurationRule instanceof RfConfigurationRule)) continue;
                    referenceNamedElementVisitor.visit((RfConfigurationRule)iRfConfigurationRule);
                }
            }
        }
        if (includeDeclarations) {
            VlogRfReferencesUtilsCommon.logDebug((String)("[SEARCH ENGINE: VLOGDT] Searching for declarations of " + namedElement.getKindName() + " '" + namedElement.getName() + "'"));
            VlogRfReferencesUtilsCommon.searchForElementDeclarations(referenceNamedElementVisitor, namedElement, true, namedElement instanceof RfSearchQueryElement);
        }
    }

    private static void searchForElementDeclarations(ReferenceNamedElementVisitor referenceNamedVisitor, IRfNamedElement namedElement, boolean includeDeclarations, boolean semanticSearch) {
        List<IRfNamedElement> elementsToSearch = VlogRfReferencesUtilsCommon.getElementsToSearch(namedElement, includeDeclarations, semanticSearch);
        if (elementsToSearch == null || elementsToSearch.isEmpty()) {
            return;
        }
        referenceNamedVisitor.skipDirectLibraryMembers(false);
        for (IRfNamedElement searchedElement : elementsToSearch) {
            if (!(searchedElement instanceof RfNamedElement)) continue;
            referenceNamedVisitor.visit((RfNamedElement)searchedElement);
        }
    }

    static void searchForPredefinedElement(ReferenceHidOperatorVisitor referenceHidOperatorVisitor, ReferenceHidSearchVisitor referenceHidVisitor, ReferenceImportExportHidOperatorVisitor referenceImportExportHidOperator, ReferenceNamedElementVisitor referenceNamedElementVisitor, RfProject rfProject) {
        rfProject.visitHidObject(null, referenceHidVisitor);
        try {
            referenceHidVisitor.reportFromBuffer();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        rfProject.visitHidObject(null, referenceHidOperatorVisitor);
        rfProject.visitHidObject(null, referenceImportExportHidOperator);
        try {
            rfProject.accept(referenceNamedElementVisitor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void searchForNonTypeElement(IRfNamedElement namedElement, ReferencePotentialHidVisitor referencePotentialHidVisitor, ReferenceHidOperatorVisitor referenceHidOperatorVisitor, ReferenceHidSearchVisitor referenceHidVisitor, ReferenceNamedElementVisitor referenceNamedVisitor, ReferenceImportExportHidOperatorVisitor referenceImportExportVisitor, RfProject rfProject, boolean includeDeclarations, boolean semanticSearch) {
        Set<IRfNamedElement> potentialVisitedScopes;
        Set<IRfNamedElement> referencedScopes = VlogRfReferencesUtilsCommon.getAllDependencies(namedElement, rfProject, includeDeclarations, semanticSearch, false);
        IRfScopeElement enclosingScope = namedElement.getEnclosingScope();
        if (enclosingScope instanceof IRfNamedElement) {
            referencedScopes.add((IRfNamedElement)enclosingScope);
        }
        VlogRfReferencesUtilsCommon.logDebug((String)("[SEARCH ENGINE VLOGDT] Dependencies for " + namedElement.getKindName() + " '" + namedElement.getName() + "' are:\n" + referencedScopes));
        if ((enclosingScope instanceof RfClass || enclosingScope instanceof RfStruct) && (potentialVisitedScopes = VlogRfReferencesUtilsCommon.getAllPotentialDependencies(namedElement.getName(), rfProject)) != null) {
            for (IRfNamedElement potentialVisitedScope : potentialVisitedScopes) {
                potentialVisitedScope.visitHidObject(null, (IHidVisitor)referencePotentialHidVisitor);
            }
        }
        if (VlogRfReferencesUtilsCommon.isParameter(namedElement)) {
            rfProject.visitDirectMembersOfLibraries(referenceNamedVisitor);
            referenceNamedVisitor.skipDirectLibraryMembers(true);
        }
        boolean isInsidePackage = enclosingScope instanceof IRfPackageElement;
        for (IRfNamedElement referenceScope : referencedScopes) {
            if (!(referenceScope instanceof RfNamedElement)) continue;
            referenceScope.visitHidObject(null, (IHidVisitor)referenceHidOperatorVisitor);
            referenceScope.visitHidObject(null, (IHidVisitor)referenceHidVisitor);
            try {
                referenceHidVisitor.reportFromBuffer();
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            if (isInsidePackage) {
                referenceScope.visitHidObject(null, (IHidVisitor)referenceImportExportVisitor);
            }
            ((RfNamedElement)referenceScope).accept(null, referenceNamedVisitor);
        }
        if (includeDeclarations) {
            VlogRfReferencesUtilsCommon.searchForElementDeclarations(referenceNamedVisitor, namedElement, true, semanticSearch);
            VlogRfReferencesUtilsCommon.logDebug((String)("[SEARCH ENGINE: VLOGDT] Searching for declarations of " + namedElement.getKindName() + " '" + namedElement.getName() + "'"));
        }
    }

    private static Set<IRfNamedElement> getAllPotentialDependencies(String name, RfProject rfProject) {
        LinkedHashSet<IRfNamedElement> result = new LinkedHashSet<IRfNamedElement>();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (CLOSEST_TYPE_CONTAINER_FOR_REFERENCES.contains(namedElement.getClass()) && namedElement.hasReferenceToIdentifierName(name)) {
                result.add(namedElement);
                return false;
            }
            return true;
        };
        rfProject.accept(visitor);
        return result;
    }

    private static boolean isParameter(IRfNamedElement element) {
        if (!(element instanceof RfField)) {
            return false;
        }
        RfField field = (RfField)element;
        return field.isTypeParameter() || field.isParameter() || field.isParameterNoDataType();
    }

    public static Set<IRfNamedElement> getAllDependencies(IRfNamedElement element, IRfSingleLangProject singleLangProject, boolean includeDeclarations, boolean semanticSearch, boolean searchForType) {
        Set<IRfNamedElement> result = SearchDependencyContainer.getAllDependencies(element, singleLangProject, includeDeclarations, semanticSearch, searchForType, true);
        ArrayList<IRfNamedElement> dependencyList = new ArrayList<IRfNamedElement>(result);
        Collections.sort(dependencyList, (element1, element2) -> {
            if (element1 == null) {
                if (element2 == null) {
                    return 0;
                }
                return -1;
            }
            if (element2 == null) {
                return 1;
            }
            IResource element1FileAdapter = element1.getFileAdapter();
            IResource element2FileAdapter = element2.getFileAdapter();
            if (element1FileAdapter == null) {
                if (element2FileAdapter == null) {
                    return 0;
                }
                return 1;
            }
            if (element2FileAdapter == null) {
                return -1;
            }
            return element1FileAdapter.getLocation().toOSString().compareTo(element2FileAdapter.getLocation().toOSString());
        });
        LinkedHashSet<IRfNamedElement> sortedResult = new LinkedHashSet<IRfNamedElement>();
        sortedResult.addAll(dependencyList);
        return sortedResult;
    }

    public static MacroCallHitsInfo computeMacroHit(boolean isPossibleMatch, IRfNamedElement namedElement, RfTypesResolver resolver, RfProject project, Map<OffsetNamedElementFilePair, MacroCallHitsInfo> macroInfoMap, int offset, ParserPath file, IDocument document, Map<RfFunction, LinkedHashSet<RfClass>> functionClassFamily, boolean disableHitInMacroArgument) {
        OffsetNamedElementFilePair offsetElement = new OffsetNamedElementFilePair(offset, namedElement, file);
        MacroCallHitsInfo macroCallHitsInfo = macroInfoMap.get(offsetElement);
        if (macroCallHitsInfo == null) {
            MacroCallSearchStatus info = VlogRfReferencesUtilsCommon.locateMatch(namedElement, project, document, file, offset);
            if (info == null) {
                return null;
            }
            Matcher hidMatcher = info.getMatcher();
            int startOffset = 0;
            int endOffset = 0;
            ArrayList<MacroCallParameterHit> hitsList = new ArrayList<MacroCallParameterHit>();
            if (!disableHitInMacroArgument) {
                while (hidMatcher.find()) {
                    startOffset = hidMatcher.start();
                    endOffset = hidMatcher.end();
                    RfWNamedElementAndScope elementAndScope = RfBatchUtils.getRfElement(project, file, document, offset + endOffset, null, false, true, null);
                    if (elementAndScope == null) continue;
                    IRfNamedElement element = elementAndScope.getIRfNamedElement();
                    boolean isMatch = false;
                    if (namedElement instanceof RfFunction && element instanceof RfFunction) {
                        LinkedHashSet<RfClass> computeClassFamily = VlogRfReferencesUtilsCommon.computeFunctionClassFamily((RfFunction)namedElement, functionClassFamily);
                        RfTypesResolver hitResolver = RfTypesResolver.create((IRfScopeElement)elementAndScope.getAssocScope(), project, 8);
                        isMatch = ((RfFunction)namedElement).computeEquals(resolver, element, hitResolver, computeClassFamily).isMatch();
                    } else {
                        isMatch = namedElement.checkEquals((Object)element);
                    }
                    if (!isMatch && !isPossibleMatch) continue;
                    hitsList.add(new MacroCallParameterHit(info.getMacroCallText().substring(startOffset, endOffset), offset + startOffset));
                }
            }
            macroCallHitsInfo = new MacroCallHitsInfo(hitsList, info.getMacroCallText().trim());
            macroInfoMap.put(offsetElement, macroCallHitsInfo);
        }
        return macroCallHitsInfo;
    }

    private static MacroCallSearchStatus locateMatch(IRfNamedElement namedElement, RfProject project, IDocument document, ParserPath file, int offset) {
        IRegion macroCallRegion = RfBatchUtils.getMacroRegionAtOffset(project, file, document, offset, 1000, true, false);
        if (macroCallRegion == null) {
            return null;
        }
        String macroCallText = null;
        try {
            macroCallText = document.get(macroCallRegion.getOffset(), macroCallRegion.getLength());
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        if (macroCallText == null) {
            return null;
        }
        int flags = 8;
        String matchString = "";
        if (namedElement.getName().startsWith("$")) {
            matchString = namedElement.getName();
            flags |= 0x10;
        } else {
            matchString = "\\b" + namedElement.getName() + "\\b";
        }
        Matcher hidMatcher = Pattern.compile(matchString, flags).matcher(macroCallText);
        MacroCallSearchStatus info = new MacroCallSearchStatus(hidMatcher, macroCallText, namedElement, offset);
        return info;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDeclaration(HidOccurrence occurence, IRfNamedElement element, IRfNamedElement namedElement, ParserPath parserPath, IDocument openDocument) {
        try {
            if (element == null) {
                return false;
            }
            int startOffsetLine = openDocument.getLineOfOffset(occurence.getOffset());
            int currentMatchStartLine = startOffsetLine + 1;
            int endOffsetLine = openDocument.getLineOfOffset(occurence.getOffset() + element.getName().length());
            IRfDefElement declaration = element.getDeclaration();
            if (declaration == null) {
                return false;
            }
            if (element != namedElement && element instanceof RfField) {
                if (element.getEnclosingScope() instanceof RfModport) return false;
                if (element.getEnclosingScope() instanceof RfClockingBlock) {
                    return false;
                }
            }
            if (!(element instanceof RfNamedElement)) {
                IRfDefElement typeLayer = declaration;
                if (typeLayer.getDefFile() == null) return false;
                if (!typeLayer.getDefFile().getParserPath().equals((Object)parserPath)) return false;
                if (typeLayer.getStartLine() == currentMatchStartLine) return true;
                if (openDocument.getLineOfOffset(typeLayer.getEndOffset()) != endOffsetLine) return false;
                return true;
            }
            Collection typeLayers = element.getDeclarations();
            if (typeLayers == null) {
                return false;
            }
            Iterator iterator = typeLayers.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return false;
                }
                IRfDefElement typeLayer = (IRfDefElement)iterator.next();
                if (typeLayer == null) {
                    return false;
                }
                if (typeLayer.getDefFile() == null || !typeLayer.getDefFile().getParserPath().equals((Object)parserPath)) continue;
                if (typeLayer.getStartLine() == currentMatchStartLine) return true;
                if (openDocument.getLineOfOffset(typeLayer.getEndOffset()) == endOffsetLine) break;
            }
            return true;
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    public static IStatus checkOtherElements(String newName, IProject project, IRfNamedElement namedElement, IRfNamedElement declarationEnclosingScope, boolean usageCheck) {
        return VlogRfReferencesUtilsCommon.checkOtherElements(newName, project, namedElement, declarationEnclosingScope, usageCheck, false);
    }

    public static IStatus checkOtherElements(String newName, IProject project, IRfNamedElement namedElement, IRfNamedElement declarationEnclosingScope, boolean usageCheck, boolean forceSaveCandidates) {
        if (!(declarationEnclosingScope instanceof RfNamedElement)) {
            return Status.OK_STATUS;
        }
        if (namedElement instanceof RfTypeAlias || namedElement instanceof RfClass || namedElement instanceof RfCovergroup || namedElement instanceof RfInterface || namedElement instanceof RfProgram || namedElement instanceof RfModule || namedElement instanceof RfModport) {
            NameConflictStatus status;
            boolean inEnclosingScope;
            IRfNamedElement conflictingCandidate;
            List<RfNamedElement> candidates = ((RfNamedElement)declarationEnclosingScope).getTypeAliasesWithPrefix(newName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PROTECTED);
            if (candidates != null && !candidates.isEmpty()) {
                if (usageCheck || forceSaveCandidates) {
                    NameConflictStatus status2 = new NameConflictStatus(4, "ro.amiq.vlogdt", "There is already a type with this name in this package.", usageCheck ? NameConflictStatusType.NAME_CONFLICT : NameConflictStatusType.DUPLICATE);
                    status2.setConflicting(candidates);
                    return status2;
                }
                return new Status(4, "ro.amiq.vlogdt", "There is already a type with this name in this package.");
            }
            candidates = ((RfNamedElement)declarationEnclosingScope).getTypeAliasesWithPrefix(newName, 1, 3, IRfNamedElement.AccessModifier.SHOW_PROTECTED);
            if (candidates != null && !candidates.isEmpty()) {
                conflictingCandidate = candidates.get(0);
                inEnclosingScope = VlogRfReferencesUtils.isInEnclosingScope(namedElement, conflictingCandidate);
                if (!usageCheck && inEnclosingScope || usageCheck && !inEnclosingScope) {
                    NameConflictStatus status3 = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("{0} ''{1}'' shadows {2} ''{3}''.", VlogRfReferencesUtils.capitalize((String)VlogRfReferencesUtils.capitalize((String)namedElement.getKindName())), namedElement.getFullNameLabel(), conflictingCandidate.getKindName(), conflictingCandidate.getFullNameLabel()), NameConflictStatusType.SHADOWS);
                    status3.setConflicting(candidates);
                    return status3;
                }
            }
            if ((candidates = ((RfNamedElement)declarationEnclosingScope).getClassesWithPrefix(newName, 1, 1)) != null && !candidates.isEmpty()) {
                if (usageCheck || forceSaveCandidates) {
                    status = new NameConflictStatus(4, "ro.amiq.vlogdt", "There is already a class with this name in this package.", usageCheck ? NameConflictStatusType.NAME_CONFLICT : NameConflictStatusType.DUPLICATE);
                    status.setConflicting(candidates);
                    return status;
                }
                return new Status(4, "ro.amiq.vlogdt", "There is already a class with this name in this package.");
            }
            candidates = ((RfNamedElement)declarationEnclosingScope).getClassesWithPrefix(newName, 1, 3);
            if (candidates != null && !candidates.isEmpty()) {
                conflictingCandidate = candidates.get(0);
                inEnclosingScope = VlogRfReferencesUtils.isInEnclosingScope(namedElement, conflictingCandidate);
                if (!usageCheck && inEnclosingScope || usageCheck && !inEnclosingScope) {
                    NameConflictStatus status4 = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("{0} ''{1}'' shadows {2} ''{3}''.", VlogRfReferencesUtils.capitalize((String)namedElement.getKindName()), namedElement.getFullNameLabel(), conflictingCandidate.getKindName(), conflictingCandidate.getFullNameLabel()), NameConflictStatusType.SHADOWS);
                    status4.setConflicting(candidates);
                    return status4;
                }
            }
            if ((candidates = ((RfNamedElement)declarationEnclosingScope).getCovergroupsWithPrefix(newName, 1, 1)) != null && !candidates.isEmpty()) {
                if (usageCheck || forceSaveCandidates) {
                    status = new NameConflictStatus(4, "ro.amiq.vlogdt", "There is already a cover group with this name in this package.", usageCheck ? NameConflictStatusType.NAME_CONFLICT : NameConflictStatusType.DUPLICATE);
                    status.setConflicting(candidates);
                    return status;
                }
                return new Status(4, "ro.amiq.vlogdt", "There is already a cover group with this name in this package.");
            }
            candidates = ((RfNamedElement)declarationEnclosingScope).getCovergroupsWithPrefix(newName, 1, 3);
            if (candidates != null && !candidates.isEmpty()) {
                conflictingCandidate = candidates.get(0);
                inEnclosingScope = VlogRfReferencesUtils.isInEnclosingScope(namedElement, conflictingCandidate);
                if (!usageCheck && inEnclosingScope || usageCheck && !inEnclosingScope) {
                    NameConflictStatus status5 = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("{0} ''{1}'' shadows {2} ''{3}''.", VlogRfReferencesUtils.capitalize((String)namedElement.getKindName()), namedElement.getFullNameLabel(), conflictingCandidate.getKindName(), conflictingCandidate.getFullNameLabel()), NameConflictStatusType.SHADOWS);
                    status5.setConflicting(candidates);
                    return status5;
                }
            }
            if ((candidates = ((RfNamedElement)declarationEnclosingScope).getInterfacesWithPrefix(newName, 1, 1)) != null && !candidates.isEmpty()) {
                if (usageCheck || forceSaveCandidates) {
                    status = new NameConflictStatus(4, "ro.amiq.vlogdt", "There is already an interface with this name in this package.", usageCheck ? NameConflictStatusType.NAME_CONFLICT : NameConflictStatusType.DUPLICATE);
                    status.setConflicting(candidates);
                    return status;
                }
                return new Status(4, "ro.amiq.vlogdt", "There is already an interface with this name in this package.");
            }
            candidates = ((RfNamedElement)declarationEnclosingScope).getInterfacesWithPrefix(newName, 1, 3);
            if (candidates != null && !candidates.isEmpty()) {
                conflictingCandidate = candidates.get(0);
                inEnclosingScope = VlogRfReferencesUtils.isInEnclosingScope(namedElement, conflictingCandidate);
                if (!usageCheck && inEnclosingScope || usageCheck && !inEnclosingScope) {
                    NameConflictStatus status6 = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("{0} ''{1}'' shadows {2} ''{3}''.", VlogRfReferencesUtils.capitalize((String)namedElement.getKindName()), namedElement.getFullNameLabel(), conflictingCandidate.getKindName(), conflictingCandidate.getFullNameLabel()), NameConflictStatusType.SHADOWS);
                    status6.setConflicting(candidates);
                    return status6;
                }
            }
            if ((candidates = ((RfNamedElement)declarationEnclosingScope).getProgramsWithPrefix(newName, 1, 1)) != null && !candidates.isEmpty()) {
                if (usageCheck || forceSaveCandidates) {
                    status = new NameConflictStatus(4, "ro.amiq.vlogdt", "There is already a program with this name in this package.", usageCheck ? NameConflictStatusType.NAME_CONFLICT : NameConflictStatusType.DUPLICATE);
                    status.setConflicting(candidates);
                    return status;
                }
                return new Status(4, "ro.amiq.vlogdt", "There is already a program with this name in this package.");
            }
            candidates = ((RfNamedElement)declarationEnclosingScope).getProgramsWithPrefix(newName, 1, 3);
            if (candidates != null && !candidates.isEmpty()) {
                conflictingCandidate = candidates.get(0);
                inEnclosingScope = VlogRfReferencesUtils.isInEnclosingScope(namedElement, conflictingCandidate);
                if (!usageCheck && inEnclosingScope || usageCheck && !inEnclosingScope) {
                    NameConflictStatus status7 = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("{0} ''{1}'' shadows {2} ''{3}''.", VlogRfReferencesUtils.capitalize((String)namedElement.getKindName()), namedElement.getFullNameLabel(), conflictingCandidate.getKindName(), conflictingCandidate.getFullNameLabel()), NameConflictStatusType.SHADOWS);
                    status7.setConflicting(candidates);
                    return status7;
                }
            }
            if ((candidates = ((RfNamedElement)declarationEnclosingScope).getModulesWithPrefix(newName, 1, 1)) != null && !candidates.isEmpty()) {
                if (usageCheck || forceSaveCandidates) {
                    status = new NameConflictStatus(4, "ro.amiq.vlogdt", "There is already a module with this name in this package.", usageCheck ? NameConflictStatusType.NAME_CONFLICT : NameConflictStatusType.DUPLICATE);
                    status.setConflicting(candidates);
                    return status;
                }
                return new Status(4, "ro.amiq.vlogdt", "There is already a module with this name in this package.");
            }
            candidates = ((RfNamedElement)declarationEnclosingScope).getModulesWithPrefix(newName, 1, 3);
            if (candidates != null && !candidates.isEmpty()) {
                conflictingCandidate = candidates.get(0);
                inEnclosingScope = VlogRfReferencesUtils.isInEnclosingScope(namedElement, conflictingCandidate);
                if (!usageCheck && inEnclosingScope || usageCheck && !inEnclosingScope) {
                    NameConflictStatus status8 = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("{0} ''{1}'' shadows {2} ''{3}''.", VlogRfReferencesUtils.capitalize((String)namedElement.getKindName()), namedElement.getFullNameLabel(), conflictingCandidate.getKindName(), conflictingCandidate.getFullNameLabel()), NameConflictStatusType.SHADOWS);
                    status8.setConflicting(candidates);
                    return status8;
                }
            }
            if ((candidates = ((RfNamedElement)declarationEnclosingScope).getModportsWithPrefix(newName, 1, 1)) != null && !candidates.isEmpty()) {
                if (usageCheck || forceSaveCandidates) {
                    status = new NameConflictStatus(4, "ro.amiq.vlogdt", "There is already a modport with this name in this package.", usageCheck ? NameConflictStatusType.NAME_CONFLICT : NameConflictStatusType.DUPLICATE);
                    status.setConflicting(candidates);
                    return status;
                }
                return new Status(4, "ro.amiq.vlogdt", "There is already a modport with this name in this package.");
            }
            candidates = ((RfNamedElement)declarationEnclosingScope).getModportsWithPrefix(newName, 1, 3);
            if (candidates != null && !candidates.isEmpty()) {
                conflictingCandidate = candidates.get(0);
                inEnclosingScope = VlogRfReferencesUtils.isInEnclosingScope(namedElement, conflictingCandidate);
                if (!usageCheck && inEnclosingScope || usageCheck && !inEnclosingScope) {
                    NameConflictStatus status9 = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("{0} ''{1}'' shadows {2} ''{3}''.", VlogRfReferencesUtils.capitalize((String)namedElement.getKindName()), namedElement.getFullNameLabel(), conflictingCandidate.getKindName(), conflictingCandidate.getFullNameLabel()), NameConflictStatusType.SHADOWS);
                    status9.setConflicting(candidates);
                    return status9;
                }
            }
            return Status.OK_STATUS;
        }
        if (namedElement instanceof RfFunction) {
            boolean inEnclosingScope;
            IRfNamedElement conflictingCandidate;
            if (!(declarationEnclosingScope instanceof RfNamedElement)) {
                return Status.OK_STATUS;
            }
            List<RfFunction> candidates = ((RfNamedElement)declarationEnclosingScope).getFunctionsWithPrefix(newName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PROTECTED);
            if (candidates != null && !candidates.isEmpty()) {
                if (usageCheck || forceSaveCandidates) {
                    NameConflictStatus status = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "a function"), usageCheck ? NameConflictStatusType.NAME_CONFLICT : NameConflictStatusType.DUPLICATE);
                    status.setConflicting(candidates);
                    return status;
                }
                return new Status(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "a function"));
            }
            candidates = ((RfNamedElement)declarationEnclosingScope).getTasksWithPrefix(newName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PROTECTED);
            if (candidates != null && !candidates.isEmpty()) {
                if (usageCheck || forceSaveCandidates) {
                    NameConflictStatus status = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "a task"), usageCheck ? NameConflictStatusType.NAME_CONFLICT : NameConflictStatusType.DUPLICATE);
                    status.setConflicting(candidates);
                    return status;
                }
                return new Status(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "a task"));
            }
            candidates = ((RfNamedElement)declarationEnclosingScope).getFunctionsWithPrefix(newName, 1, 3, IRfNamedElement.AccessModifier.SHOW_PROTECTED);
            if (candidates != null && !candidates.isEmpty()) {
                conflictingCandidate = candidates.get(0);
                inEnclosingScope = VlogRfReferencesUtils.isInEnclosingScope(namedElement, conflictingCandidate);
                if (!usageCheck && inEnclosingScope || usageCheck && !inEnclosingScope) {
                    NameConflictStatus status = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("{0} ''{1}'' shadows {2} ''{3}''.", VlogRfReferencesUtils.capitalize((String)namedElement.getKindName()), namedElement.getFullNameLabel(), conflictingCandidate.getKindName(), conflictingCandidate.getFullNameLabel()), NameConflictStatusType.SHADOWS);
                    status.setConflicting(candidates);
                    return status;
                }
            }
            if ((candidates = ((RfNamedElement)declarationEnclosingScope).getTasksWithPrefix(newName, 1, 3, IRfNamedElement.AccessModifier.SHOW_PROTECTED)) != null && !candidates.isEmpty()) {
                conflictingCandidate = candidates.get(0);
                inEnclosingScope = VlogRfReferencesUtils.isInEnclosingScope(namedElement, conflictingCandidate);
                if (!usageCheck && inEnclosingScope || usageCheck && !inEnclosingScope) {
                    NameConflictStatus status = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("{0} ''{1}'' shadows {2} ''{3}''.", VlogRfReferencesUtils.capitalize((String)namedElement.getKindName()), namedElement.getFullNameLabel(), conflictingCandidate.getKindName(), conflictingCandidate.getFullNameLabel()), NameConflictStatusType.SHADOWS);
                    status.setConflicting(candidates);
                    return status;
                }
            }
            return Status.OK_STATUS;
        }
        if (namedElement instanceof RfCoverpoint) {
            List<RfCoverpoint> candidates = ((RfNamedElement)declarationEnclosingScope).getCoverpointsWithPrefix(newName, 1, 1);
            if (candidates != null && !candidates.isEmpty()) {
                if (usageCheck || forceSaveCandidates) {
                    NameConflictStatus status = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "a coverpoint"), usageCheck ? NameConflictStatusType.NAME_CONFLICT : NameConflictStatusType.DUPLICATE);
                    status.setConflicting(candidates);
                    return status;
                }
                return new Status(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "a coverpoint"));
            }
            candidates = ((RfNamedElement)declarationEnclosingScope).getCoverpointsWithPrefix(newName, 1, 3);
            if (candidates != null && !candidates.isEmpty()) {
                IRfNamedElement conflictingCandidate = candidates.get(0);
                boolean inEnclosingScope = VlogRfReferencesUtils.isInEnclosingScope(namedElement, conflictingCandidate);
                if (!usageCheck && inEnclosingScope || usageCheck && !inEnclosingScope) {
                    NameConflictStatus status = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("{0} ''{1}'' shadows {2} ''{3}''.", VlogRfReferencesUtils.capitalize((String)namedElement.getKindName()), namedElement.getFullNameLabel(), conflictingCandidate.getKindName(), conflictingCandidate.getFullNameLabel()), NameConflictStatusType.SHADOWS);
                    status.setConflicting(candidates);
                    return status;
                }
            }
            return Status.OK_STATUS;
        }
        if (namedElement instanceof RfChecker) {
            List<RfChecker> candidates = ((RfNamedElement)declarationEnclosingScope).getCheckersWithPrefix(newName, 1, 1);
            if (candidates != null && !candidates.isEmpty()) {
                if (usageCheck || forceSaveCandidates) {
                    NameConflictStatus status = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "a checker"), usageCheck ? NameConflictStatusType.NAME_CONFLICT : NameConflictStatusType.DUPLICATE);
                    status.setConflicting(candidates);
                    return status;
                }
                return new Status(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "a checker"));
            }
            candidates = ((RfNamedElement)declarationEnclosingScope).getCheckersWithPrefix(newName, 1, 3);
            if (candidates != null && !candidates.isEmpty()) {
                IRfNamedElement conflictingCandidate = candidates.get(0);
                boolean inEnclosingScope = VlogRfReferencesUtils.isInEnclosingScope(namedElement, conflictingCandidate);
                if (!usageCheck && inEnclosingScope || usageCheck && !inEnclosingScope) {
                    NameConflictStatus status = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("{0} ''{1}'' shadows {2} ''{3}''.", VlogRfReferencesUtils.capitalize((String)namedElement.getKindName()), namedElement.getFullNameLabel(), conflictingCandidate.getKindName(), conflictingCandidate.getFullNameLabel()), NameConflictStatusType.SHADOWS);
                    status.setConflicting(candidates);
                    return status;
                }
            }
            return Status.OK_STATUS;
        }
        if (namedElement instanceof RfPropertySequence) {
            short kind = ((RfPropertySequence)namedElement).getKind();
            String kindName = kind == 1 ? "a property" : (kind == 2 ? "a sequence" : " an element");
            List<RfPropertySequence> candidates = ((RfNamedElement)declarationEnclosingScope).getPropertiesSequencesWithPrefix(newName, kind, 1, 3);
            if (candidates != null && !candidates.isEmpty()) {
                if (usageCheck || forceSaveCandidates) {
                    NameConflictStatus status = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", kindName), usageCheck ? NameConflictStatusType.NAME_CONFLICT : NameConflictStatusType.DUPLICATE);
                    status.setConflicting(candidates);
                    return status;
                }
                return new Status(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", kindName));
            }
            candidates = ((RfNamedElement)declarationEnclosingScope).getPropertiesSequencesWithPrefix(newName, kind, 1, 3);
            if (candidates != null && !candidates.isEmpty()) {
                IRfNamedElement conflictingCandidate = candidates.get(0);
                boolean inEnclosingScope = VlogRfReferencesUtils.isInEnclosingScope(namedElement, conflictingCandidate);
                if (!usageCheck && inEnclosingScope || usageCheck && !inEnclosingScope) {
                    NameConflictStatus status = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("{0} ''{1}'' shadows {2} ''{3}''.", VlogRfReferencesUtils.capitalize((String)namedElement.getKindName()), namedElement.getFullNameLabel(), conflictingCandidate.getKindName(), conflictingCandidate.getFullNameLabel()), NameConflictStatusType.SHADOWS);
                    status.setConflicting(candidates);
                    return status;
                }
            }
            return Status.OK_STATUS;
        }
        if (namedElement instanceof RfField) {
            boolean inEnclosingScope;
            RfField conflictingCandidate;
            if (!(declarationEnclosingScope instanceof RfNamedElement)) {
                return Status.OK_STATUS;
            }
            List<RfField> candidates = ((RfNamedElement)declarationEnclosingScope).getEnumElementsWithPrefix(newName, 1, 1);
            if (candidates != null && !candidates.isEmpty()) {
                if (usageCheck || forceSaveCandidates) {
                    NameConflictStatus status = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "an enum element"), usageCheck ? NameConflictStatusType.NAME_CONFLICT : NameConflictStatusType.DUPLICATE);
                    status.setConflicting(candidates);
                    return status;
                }
                return new Status(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "an enum element"));
            }
            candidates = ((RfNamedElement)declarationEnclosingScope).getFieldsWithPrefix(newName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PROTECTED);
            if (candidates != null && !candidates.isEmpty()) {
                if (usageCheck || forceSaveCandidates) {
                    NameConflictStatus status = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "a field"), usageCheck ? NameConflictStatusType.NAME_CONFLICT : NameConflictStatusType.DUPLICATE);
                    status.setConflicting(candidates);
                    return status;
                }
                return new Status(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "a field"));
            }
            candidates = ((RfNamedElement)declarationEnclosingScope).getVarsWithPrefix(-1, newName, 1);
            if (candidates != null && !candidates.isEmpty()) {
                if (usageCheck || forceSaveCandidates) {
                    NameConflictStatus status = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "a variable"), usageCheck ? NameConflictStatusType.NAME_CONFLICT : NameConflictStatusType.DUPLICATE);
                    status.setConflicting(candidates);
                    return status;
                }
                return new Status(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "a variable"));
            }
            candidates = ((RfNamedElement)declarationEnclosingScope).getArgumentsWithPrefix(newName, 1);
            if (candidates != null && !candidates.isEmpty()) {
                if (usageCheck || forceSaveCandidates) {
                    NameConflictStatus status = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "an argument"), usageCheck ? NameConflictStatusType.NAME_CONFLICT : NameConflictStatusType.DUPLICATE);
                    status.setConflicting(candidates);
                    return status;
                }
                return new Status(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "an argument"));
            }
            candidates = ((RfNamedElement)declarationEnclosingScope).getParametersWithPrefix(newName, 128, 1, 1);
            if (candidates != null && !candidates.isEmpty()) {
                if (usageCheck || forceSaveCandidates) {
                    NameConflictStatus status = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "a parameter"), usageCheck ? NameConflictStatusType.NAME_CONFLICT : NameConflictStatusType.DUPLICATE);
                    status.setConflicting(candidates);
                    return status;
                }
                return new Status(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "a parameter"));
            }
            candidates = ((RfNamedElement)declarationEnclosingScope).getFieldsWithPrefix(newName, 1, 3, IRfNamedElement.AccessModifier.SHOW_PROTECTED);
            if (candidates != null && !candidates.isEmpty()) {
                conflictingCandidate = candidates.get(0);
                inEnclosingScope = VlogRfReferencesUtils.isInEnclosingScope(namedElement, conflictingCandidate);
                if (!usageCheck && inEnclosingScope || usageCheck && !inEnclosingScope) {
                    NameConflictStatus status = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("{0} ''{1}'' shadows {2} ''{3}''.", VlogRfReferencesUtils.capitalize((String)namedElement.getKindName()), namedElement.getFullNameLabel(), conflictingCandidate.getKindName(), conflictingCandidate.getFullNameLabel()), NameConflictStatusType.SHADOWS);
                    status.setConflicting(candidates);
                    return status;
                }
            }
            if ((candidates = ((RfNamedElement)declarationEnclosingScope).getParametersWithPrefix(newName, 128, 1, 3)) != null && !candidates.isEmpty()) {
                conflictingCandidate = candidates.get(0);
                inEnclosingScope = VlogRfReferencesUtils.isInEnclosingScope(namedElement, conflictingCandidate);
                if (!usageCheck && inEnclosingScope || usageCheck && !inEnclosingScope) {
                    NameConflictStatus status = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("{0} ''{1}'' shadows {2} ''{3}''.", VlogRfReferencesUtils.capitalize((String)namedElement.getKindName()), namedElement.getFullNameLabel(), conflictingCandidate.getKindName(), conflictingCandidate.getFullNameLabel()), NameConflictStatusType.SHADOWS);
                    status.setConflicting(candidates);
                    return status;
                }
            }
            if ((candidates = ((RfNamedElement)declarationEnclosingScope).getEnumElementsWithPrefix(newName, 1, 3)) != null && !candidates.isEmpty()) {
                conflictingCandidate = candidates.get(0);
                inEnclosingScope = VlogRfReferencesUtils.isInEnclosingScope(namedElement, conflictingCandidate);
                if (!usageCheck && inEnclosingScope || usageCheck && !inEnclosingScope) {
                    NameConflictStatus status = new NameConflictStatus(4, "ro.amiq.vlogdt", MessageFormat.format("{0} ''{1}'' shadows {2} ''{3}''.", VlogRfReferencesUtils.capitalize((String)namedElement.getKindName()), namedElement.getFullNameLabel(), conflictingCandidate.getKindName(), conflictingCandidate.getFullNameLabel()), NameConflictStatusType.SHADOWS);
                    status.setConflicting(candidates);
                    return status;
                }
            }
            return Status.OK_STATUS;
        }
        if (namedElement instanceof RfConstraint) {
            List<RfConstraint> candidates = ((RfNamedElement)declarationEnclosingScope).getConstraintsWithPrefix(newName, 1, 3);
            if (candidates != null && !candidates.isEmpty()) {
                return new Status(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "a constraint"));
            }
            return Status.OK_STATUS;
        }
        if (namedElement instanceof RfClockingBlock) {
            List<RfClockingBlock> candidates = ((RfNamedElement)declarationEnclosingScope).getClockingBlocksWithPrefix(newName, 1, 3);
            if (candidates != null && !candidates.isEmpty()) {
                return new Status(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "a clocking block"));
            }
            return Status.OK_STATUS;
        }
        if (namedElement instanceof RfPackage) {
            List<RfPackage> candidates = ((RfNamedElement)declarationEnclosingScope).getPackagesWithPrefix(newName, 1);
            if (candidates != null && !candidates.isEmpty()) {
                return new Status(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "a package"));
            }
            return Status.OK_STATUS;
        }
        if (namedElement instanceof RfNamedActionBlock || namedElement instanceof RfGenerateBlock && !((RfGenerateBlock)namedElement).hasImplicitName()) {
            if (!(declarationEnclosingScope instanceof RfNamedElement)) {
                return Status.OK_STATUS;
            }
            List<RfActionBlock> candidates = ((RfNamedElement)declarationEnclosingScope).getNamedBlocksWithPrefix(newName, 1, 1);
            if (candidates != null && !candidates.isEmpty()) {
                return new Status(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "a statement block"));
            }
            List<RfGenerateBlock> generateBlocksCandidates = ((RfNamedElement)declarationEnclosingScope).getGenerateBlocksWithPrefix(newName, 1, 1);
            if (generateBlocksCandidates != null && !generateBlocksCandidates.isEmpty()) {
                return new Status(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "a generate block"));
            }
            return Status.OK_STATUS;
        }
        if (namedElement instanceof VlogMacroInfo) {
            IRfMacroVisitor visitor;
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (!rfProject.visitMacros(visitor = macroInfo -> !macroInfo.getName().equals(newName))) {
                return new Status(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "a macro"));
            }
            return Status.OK_STATUS;
        }
        if (namedElement instanceof RfAssertExpect) {
            List<RfAssertExpect> candidates = ((RfNamedElement)declarationEnclosingScope).getAssertsExpectsWithPrefix(newName, 1, 3);
            if (candidates != null && !candidates.isEmpty()) {
                return new Status(4, "ro.amiq.vlogdt", MessageFormat.format("There is already {0} with this name.", "an assert expect"));
            }
            return Status.OK_STATUS;
        }
        if (!(namedElement instanceof RfNamedElement)) {
            return Status.OK_STATUS;
        }
        return new Status(4, "ro.amiq.vlogdt", "Unexpected error while checking new name");
    }

    public static boolean isInEnclosingScope(IRfNamedElement namedElement, IRfNamedElement conflictingElement) {
        IRfScopeElement enclosingScope = namedElement.getEnclosingScope();
        if (namedElement instanceof RfField && ((RfField)namedElement).isEnumElement()) {
            enclosingScope = enclosingScope.getEnclosingScope();
        }
        IRfScopeElement enclosingConflictingElement = conflictingElement.getEnclosingScope();
        if (conflictingElement instanceof RfField && ((RfField)conflictingElement).isEnumElement()) {
            enclosingConflictingElement = enclosingConflictingElement.getEnclosingScope();
        }
        while (enclosingScope != null) {
            if (enclosingScope == enclosingConflictingElement) {
                return true;
            }
            enclosingScope = enclosingScope.getEnclosingScope();
        }
        return false;
    }

    public static LinkedHashSet<RfClass> computeFunctionClassFamily(RfFunction function, Map<RfFunction, LinkedHashSet<RfClass>> functionClassFamily) {
        if (functionClassFamily == null || !function.isVirtual()) {
            return null;
        }
        LinkedHashSet<RfClass> classFamily = functionClassFamily.get(function);
        if (classFamily == null) {
            classFamily = function.computeClassFamily();
            functionClassFamily.put(function, classFamily);
        }
        return classFamily;
    }

    public static boolean isKeyWordNewName(String newName, boolean isVerilogAMS) {
        if (newName == null || newName.isEmpty()) {
            return false;
        }
        String[] words = PrefConst.getVerilogKeywords(isVerilogAMS);
        int i = 0;
        while (i < words.length) {
            if (words[i].equals(newName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getFullNameLabel(IRfNamedElement element, RfTypesResolver resolver, ElementPath designContextPath) {
        if (designContextPath != null) {
            return designContextPath + "." + element.getName();
        }
        return element instanceof RfNamedElement ? ((RfNamedElement)element).getFullNameLabel(resolver) : element.getFullNameLabel();
    }

    public static String getSearchedStringFromOffset(IDocument document, int offset) {
        IRegion wordAtOffset = VlogWordFinder.getDefault().getWordAtOffset(document, offset);
        if (wordAtOffset == null) {
            return "";
        }
        try {
            return document.get(wordAtOffset.getOffset(), wordAtOffset.getLength());
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    public static boolean shouldShowConstraints(IRfNamedElement namedElement) {
        if (!(namedElement instanceof RfField)) {
            return false;
        }
        return ((RfField)namedElement).isRand() || ((RfField)namedElement).isRandc();
    }

    public static boolean shouldSkipFunctionUsage(RfFunction.FunctionCallKind type, boolean includeDeclarations, Hid hid, IRfScopeElement enclosingScope) {
        return VlogRfReferencesUtilsCommon.shouldSkipFunctionUsage(type, includeDeclarations, hid, enclosingScope, null);
    }

    public static boolean shouldSkipFunctionUsage(RfFunction.FunctionCallKind type, boolean includeDeclarations, Hid hid, IRfScopeElement enclosingScope, IRfScopeElement scope) {
        if (includeDeclarations || type == null || type == RfFunction.FunctionCallKind.STRICT) {
            return false;
        }
        if (type == RfFunction.FunctionCallKind.FULL) {
            return true;
        }
        if (!(type != RfFunction.FunctionCallKind.CHILDREN || enclosingScope instanceof RfClass && ((RfClass)enclosingScope).isInterfaceClass())) {
            return true;
        }
        if (hid == null || !(enclosingScope instanceof RfClass)) {
            return false;
        }
        RfClass enclosingClass = (RfClass)enclosingScope;
        Hid parentHid = hid.getParentHid();
        if (parentHid != null) {
            IRfNamedElement parentHidElement = parentHid.getElement();
            if (parentHidElement instanceof RfSuperImplicitVariable) {
                return true;
            }
            if (parentHidElement instanceof RfField) {
                IRfNamedElement associatedType = ((RfField)parentHidElement).getAssociatedType();
                if (!(associatedType instanceof RfClass)) {
                    return false;
                }
                RfClass fieldClassType = (RfClass)associatedType;
                if (!VlogRfReferencesUtilsCommon.pathBetweenTwoClasses(enclosingClass, fieldClassType)) {
                    return true;
                }
            }
        } else {
            if (!(scope instanceof RfNamedElement)) {
                return false;
            }
            RfNamedElement scopeElement = (RfNamedElement)scope;
            RfNamedElement closestTypeContainer = scopeElement.getClosestTypeContainer();
            if (!(closestTypeContainer instanceof RfClass)) {
                return false;
            }
            RfClass closestClass = (RfClass)closestTypeContainer;
            if (!VlogRfReferencesUtilsCommon.pathBetweenTwoClasses(enclosingClass, closestClass)) {
                return true;
            }
        }
        return false;
    }

    public static RfClass computeCommonAncestor(RfClass firstClass, RfClass secondClass) {
        try {
            RfClass p = firstClass;
            while (p != null) {
                if (secondClass.isSubClass(p = p.getGenericClass())) {
                    return p;
                }
                p = p.getParent();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    private static boolean pathBetweenTwoClasses(RfClass enclosingClass, RfClass closestClass) {
        return enclosingClass.isChildOfClassOrInterface(closestClass) || closestClass.isChildOfClassOrInterface(enclosingClass);
    }

    public static LineElement computeLineElementHit(IFile file, SearchHit match, IRfNamedElement namedElement) {
        LineElement element = new LineElement((IResource)file, match.getLine(), match.getOffset(), match.getContents(), namedElement);
        if (!(match instanceof VlogSearchHit)) {
            return element;
        }
        element.setIsInUnelaboratedCode(((VlogSearchHit)match).isInUnelaboratedCode());
        if (((VlogSearchHit)match).getSearchMatchKind() == null) {
            return element;
        }
        return new SearchMatchKindLineElement(element, ((VlogSearchHit)match).getSearchMatchKind());
    }

    public static boolean isNonTypeCompatibleMatch(SearchMatchKindsWrapper searchMatchKind) {
        return searchMatchKind != null && searchMatchKind.getTypeCompatibleKind() == RfField.TypeCompatibilityMatchKind.NON_TYPE_COMPATIBLE_MATCH;
    }

    public static LineElement computeLineElementHit(IFile file, SearchHit match) {
        return VlogRfReferencesUtilsCommon.computeLineElementHit(file, match, null);
    }

    public static void computeGettersSetters(RWSearchTypeEnum searchRWType, SearchHit match, RfClass enclosingClass, final IRfNamedElement namedElement, Set<RfFunction> potentialGetters, Set<RfFunction> potentialSetters) {
        IRfScopeElement matchSemanticScope = match.getSemanticScope();
        if (!(matchSemanticScope instanceof RfFunction)) {
            return;
        }
        IRfScopeElement matchScope = matchSemanticScope.getEnclosingScope();
        if (!(matchScope instanceof RfClass)) {
            return;
        }
        RfClass matchClassScope = (RfClass)matchScope;
        if (matchClassScope != enclosingClass && !matchClassScope.isSubClass(enclosingClass)) {
            return;
        }
        final Boolean[] isSetter = new Boolean[1];
        final Boolean[] isGetter = new Boolean[1];
        isSetter[0] = false;
        isGetter[0] = false;
        final int[] nOfOperators = new int[]{0};
        ((RfFunction)matchSemanticScope).visitHidObject(null, new IHidVisitor<RfHidOperator>(){

            public boolean visit(RfHidOperator hidOperator) {
                if (nOfOperators[0] == 1) {
                    isGetter[0] = false;
                    isSetter[0] = false;
                    return false;
                }
                if (hidOperator.isAssignment()) {
                    IHidObject lhValue = hidOperator.getLHValue();
                    if (!HidUtils.isHid((IHidObject)lhValue)) {
                        return false;
                    }
                    Hid lhHid = (Hid)lhValue;
                    IRfNamedElement element = lhHid.getElement();
                    if (element != null && element.equals(namedElement)) {
                        isSetter[0] = true;
                    }
                } else if (hidOperator.isReturnStatement()) {
                    ListContainer rhValues = hidOperator.getRHValues();
                    if (rhValues == null || rhValues.isEmpty()) {
                        return false;
                    }
                    for (IHidObject rhValue : rhValues) {
                        if (!HidUtils.isHid((IHidObject)rhValue)) {
                            return false;
                        }
                        Hid rhHid = (Hid)rhValue;
                        IRfNamedElement element = rhHid.getElement();
                        if (element == null || !element.equals(namedElement)) continue;
                        isGetter[0] = true;
                    }
                }
                nOfOperators[0] = nOfOperators[0] + 1;
                return true;
            }

            public Class<RfHidOperator> getType() {
                return RfHidOperator.class;
            }
        });
        if (isGetter[0].booleanValue() && (searchRWType == RWSearchTypeEnum.READERS || searchRWType == RWSearchTypeEnum.USAGES)) {
            potentialGetters.add((RfFunction)matchSemanticScope);
        }
        if (isSetter[0].booleanValue() && (searchRWType == RWSearchTypeEnum.WRITERS || searchRWType == RWSearchTypeEnum.USAGES)) {
            potentialSetters.add((RfFunction)matchSemanticScope);
        }
    }

    public static VlogRenameRefactorInfo getRefactorInfo(RfWNamedElementAndScope namedElementAndScope, IProject project, ITextEditor textEditor) {
        IFile file;
        if (textEditor == null) {
            return new VlogRenameRefactorInfo(project, namedElementAndScope, textEditor);
        }
        IResource resource = (IResource)textEditor.getAdapter(IResource.class);
        IFile iFile = file = resource instanceof IFile ? (IFile)resource : null;
        if (!VlogRfReferencesUtilsCommon.shouldRenameFile(file, namedElementAndScope.getIRfNamedElement())) {
            return new VlogRenameRefactorInfo(project, namedElementAndScope, textEditor);
        }
        return new VlogRenameWithFileInfo(project, namedElementAndScope, textEditor, file);
    }

    public static boolean shouldRenameFile(IFile file, IRfNamedElement namedElement) {
        if (file == null || namedElement == null) {
            return false;
        }
        if (!acceptedTopLevelTypes.contains(namedElement.getClass())) {
            return false;
        }
        IPath location = file.getLocation();
        if (location == null) {
            return false;
        }
        String fileName = location.removeFileExtension().lastSegment();
        return namedElement.getName().equals(fileName);
    }

    public static boolean isStructField(IHid hid) {
        IRfNamedElement element = hid.getElement();
        if (!(element instanceof RfField)) {
            return false;
        }
        IRfNamedElement associatedType = ((RfField)element).getAssociatedType();
        if (associatedType instanceof RfListType) {
            associatedType = ((RfListType)associatedType).getAssociatedBaseType();
        }
        if (associatedType instanceof RfTypeAlias) {
            associatedType = ((RfTypeAlias)associatedType).getTranslatedType();
        }
        return associatedType instanceof RfStruct && !((RfStruct)associatedType).isEnum();
    }

    public static SearchMatchKindsWrapper getTypeCompatibilityMatchKind(RfNamedElement enclosingScopeObj, RfTypesResolver objResolver, RfNamedElement enclosingScope, RfTypesResolver thisResolver) {
        RfClass genericClass;
        enclosingScopeObj = enclosingScope instanceof RfClass ? objResolver.getSpecializedElementScope(enclosingScopeObj) : enclosingScopeObj;
        RfNamedElement rfNamedElement = enclosingScope = enclosingScope instanceof RfClass ? thisResolver.getSpecializedElementScope(enclosingScope) : enclosingScope;
        if (enclosingScopeObj instanceof RfSpecializedClass && enclosingScope instanceof RfSpecializedClass) {
            RfClass genericClassObj = ((RfSpecializedClass)enclosingScopeObj).getGenericClass();
            RfClass genericClass2 = ((RfSpecializedClass)enclosingScope).getGenericClass();
            if (((RfNamedElement)genericClass2).equals(genericClassObj) && !enclosingScope.equals(enclosingScopeObj)) {
                return new SearchMatchKindsWrapper(RfField.TypeCompatibilityMatchKind.NON_TYPE_COMPATIBLE_MATCH);
            }
        } else if (enclosingScopeObj instanceof RfSpecializedClass ? enclosingScope.equals(genericClass = ((RfSpecializedClass)enclosingScopeObj).getGenericClass()) : enclosingScope instanceof RfSpecializedClass && enclosingScopeObj.equals(genericClass = ((RfSpecializedClass)enclosingScope).getGenericClass())) {
            return SearchMatchKindsWrapper.getStrictMatch();
        }
        return enclosingScope != null && enclosingScope.equals(enclosingScopeObj) ? SearchMatchKindsWrapper.getStrictMatch() : new SearchMatchKindsWrapper(RfField.TypeCompatibilityMatchKind.NO_MATCH);
    }

    public static boolean shouldHaveDesignPath(IRfNamedElement namedElement, boolean isHierarchicalAccess) {
        return !isHierarchicalAccess && RfSearchUtils.canBeReadOrWritten((IRfNamedElement)namedElement) && VlogRfReferencesUtilsCommon.isValidElement(namedElement);
    }

    private static boolean isValidElement(IRfNamedElement namedElement) {
        boolean isValid;
        boolean bl = isValid = namedElement instanceof IRfPortElement || RfSearchUtils.isParameterElement((IRfNamedElement)namedElement) || VlogRfReferencesUtilsCommon.isSignal(namedElement);
        if (!isValid) {
            return false;
        }
        IRfScopeElement enclosingScope = namedElement.getEnclosingScope();
        while (enclosingScope != null) {
            if (VlogRfReferencesUtilsCommon.isDesignElement(enclosingScope)) {
                return true;
            }
            enclosingScope = enclosingScope.getEnclosingScope();
        }
        return false;
    }

    private static boolean isSignal(IRfNamedElement namedElement) {
        if (!(namedElement instanceof RfField)) {
            return false;
        }
        RfField field = (RfField)namedElement;
        if (field.isSignal()) {
            return true;
        }
        DataType dataType = field.getDataType();
        if (dataType == null) {
            return false;
        }
        String type = dataType.getType();
        if (type == null) {
            return false;
        }
        return type.startsWith("logic");
    }

    private static boolean isDesignElement(IRfScopeElement enclosingScope) {
        return enclosingScope instanceof IRfDesignElement && !(enclosingScope instanceof RfLibrary);
    }

    public static IRfNamedElement getNamedElementWithDesignPath(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return null;
        }
        if (namedElement instanceof IRfInstanceElement || namedElement instanceof RfModule || namedElement instanceof RfInterface || namedElement instanceof RfGenerateBlock) {
            return namedElement;
        }
        IRfScopeElement enclosingScope = namedElement.getEnclosingScope();
        if (enclosingScope instanceof IRfNamedElement) {
            return VlogRfReferencesUtilsCommon.getNamedElementWithDesignPath((IRfNamedElement)enclosingScope);
        }
        return null;
    }
}

