/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.callhierarchy.CallHierarchyComputeStrategy;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.VlogCallerHierarchyFunctionCallInfo;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

public class CallHierarchyTreeElementWrapper
extends RfTreeElementWrapper {
    private String fParserPath;
    private RfTreeElementWrapper fRecurenceWrapper;
    private int fMacroCallLine;
    private int fMacroCallOffset;
    private IFile fMacroCallFile;
    private VlogMacroInfo fMacroInfo;
    private String fOverrideParentName;
    private boolean fOverridesExist;
    private boolean fIsStaticAccess;
    private boolean fIsConditionalMethod;
    private WrapperKind fWrapperKind;
    private CallHierarchyComputeStrategy fHierarchyStrategy;
    private Hid fHid;
    private HidOccurrence fHidOccurrence;
    private String fName;
    private Map<Integer, List<VlogCallerHierarchyFunctionCallInfo>> fMatchLinesAndInfos;

    public CallHierarchyTreeElementWrapper(Object element, String path, Hid hid, HidOccurrence hidOccurrence, WrapperKind wrapperKind) {
        super(element);
        this.fHid = hid;
        this.fParserPath = path;
        this.fHidOccurrence = hidOccurrence;
        this.fWrapperKind = wrapperKind;
        this.fHierarchyStrategy = CallHierarchyComputeStrategy.CALLEE;
        this.setExpanded(-2);
        this.setAdditionalInfo(IDVTElementWrapper.Attribute.CHILDREN_COMPUTED, false);
    }

    public CallHierarchyTreeElementWrapper(Object element, String path, String name, Map<Integer, List<VlogCallerHierarchyFunctionCallInfo>> linesAndInfos, WrapperKind wrapperKind) {
        super(element);
        this.fParserPath = path;
        this.fWrapperKind = wrapperKind;
        this.fName = name;
        this.fMatchLinesAndInfos = linesAndInfos;
        this.fHierarchyStrategy = CallHierarchyComputeStrategy.CALLER;
        this.setExpanded(-2);
        this.setAdditionalInfo(IDVTElementWrapper.Attribute.CHILDREN_COMPUTED, false);
    }

    public CallHierarchyTreeElementWrapper(Object element, WrapperKind wrapperKind, CallHierarchyComputeStrategy strategy) {
        super(element);
        this.fWrapperKind = wrapperKind;
        this.fHierarchyStrategy = strategy;
        this.setExpanded(-2);
        this.setAdditionalInfo(IDVTElementWrapper.Attribute.CHILDREN_COMPUTED, false);
    }

    public CallHierarchyTreeElementWrapper(CallHierarchyTreeElementWrapper wrapper) {
        super(wrapper.getRfElement());
        this.fParserPath = wrapper.getParserPath();
        this.fHid = wrapper.getHid();
        this.fHidOccurrence = wrapper.getHidOccurrence();
        this.setRecurenceWrapper(wrapper.getRecurenceWrapper());
        this.setMacroLine(wrapper.getMacroLine());
        this.setMacroOffset(wrapper.getMacroOffset());
        this.setMacroCallFile(wrapper.getMacroCallFile());
        this.setOverrideParentName(wrapper.getOverrideParentName());
        this.setOverrides(wrapper.hasOverrides());
        this.setStaticAccess(wrapper.isStaticAccess());
        this.setIsConditionalMethod(wrapper.isConditionalMethod());
        this.fWrapperKind = wrapper.getWrapperKind();
        this.setExpanded(wrapper.getExpanded());
        this.setAdditionalInfo(IDVTElementWrapper.Attribute.CHILDREN_COMPUTED, wrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.CHILDREN_COMPUTED));
        this.fHierarchyStrategy = wrapper.getHierarchyStrategy();
        this.fName = wrapper.getName();
        this.fMatchLinesAndInfos = new LinkedHashMap<Integer, List<VlogCallerHierarchyFunctionCallInfo>>();
        if (wrapper.getMatchLinesAndInfos() == null) {
            return;
        }
        for (Map.Entry<Integer, List<VlogCallerHierarchyFunctionCallInfo>> entry : wrapper.getMatchLinesAndInfos().entrySet()) {
            this.fMatchLinesAndInfos.put(entry.getKey(), entry.getValue());
        }
    }

    public void setMacroInfo(VlogMacroInfo macroInfo) {
        this.fMacroInfo = macroInfo;
    }

    public VlogMacroInfo getMacroInfo() {
        return this.fMacroInfo;
    }

    public RfTreeElementWrapper getRecurenceWrapper() {
        return this.fRecurenceWrapper;
    }

    public void setRecurenceWrapper(RfTreeElementWrapper recurenceWrapper) {
        this.fRecurenceWrapper = recurenceWrapper;
    }

    public IFile getMacroCallFile() {
        return this.fMacroCallFile;
    }

    public void setMacroCallFile(IFile file) {
        this.fMacroCallFile = file;
    }

    public int getMacroLine() {
        return this.fMacroCallLine;
    }

    public void setMacroLine(int line) {
        this.fMacroCallLine = line;
    }

    public int getMacroOffset() {
        return this.fMacroCallOffset;
    }

    public void setMacroOffset(int offset) {
        this.fMacroCallOffset = offset;
    }

    public WrapperKind getWrapperKind() {
        return this.fWrapperKind;
    }

    public boolean hasHidOccurrence() {
        return this.fHidOccurrence != null;
    }

    public HidOccurrence getHidOccurrence() {
        return this.fHidOccurrence;
    }

    public void setHidOccurrence(HidOccurrence hidOccurrence) {
        this.fHidOccurrence = hidOccurrence;
    }

    public boolean hasHid() {
        return this.fHid != null;
    }

    public Hid getHid() {
        return this.fHid;
    }

    public String getParserPath() {
        return this.fParserPath;
    }

    public void setOverrideParentName(String parentName) {
        this.fOverrideParentName = parentName;
    }

    public String getOverrideParentName() {
        return this.fOverrideParentName;
    }

    public void setOverrides(boolean overrides) {
        this.fOverridesExist = overrides;
    }

    public boolean hasOverrides() {
        return this.fOverridesExist;
    }

    public void setStaticAccess(boolean isStatic) {
        this.fIsStaticAccess = isStatic;
    }

    public boolean isStaticAccess() {
        return this.fIsStaticAccess;
    }

    public void setIsConditionalMethod(boolean value) {
        this.fIsConditionalMethod = value;
    }

    public boolean isConditionalMethod() {
        return this.fIsConditionalMethod;
    }

    public List<Integer> getMatchLines() {
        if (this.fMatchLinesAndInfos == null) {
            return null;
        }
        return new ArrayList<Integer>(this.fMatchLinesAndInfos.keySet());
    }

    public int getFirstOffset() {
        if (this.fMatchLinesAndInfos == null || this.fMatchLinesAndInfos.isEmpty()) {
            return -1;
        }
        for (List<VlogCallerHierarchyFunctionCallInfo> infos : this.fMatchLinesAndInfos.values()) {
            if (infos == null || infos.isEmpty()) continue;
            return infos.get(0).getOffset();
        }
        return -1;
    }

    public List<Integer> getOffsets() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (this.fMatchLinesAndInfos == null || this.fMatchLinesAndInfos.isEmpty()) {
            return result;
        }
        for (List<VlogCallerHierarchyFunctionCallInfo> infos : this.fMatchLinesAndInfos.values()) {
            if (infos == null || infos.isEmpty()) continue;
            result.addAll(infos.stream().map(info -> info.getOffset()).collect(Collectors.toList()));
        }
        return result;
    }

    public Map<Integer, List<VlogCallerHierarchyFunctionCallInfo>> getMatchLinesAndInfos() {
        return this.fMatchLinesAndInfos;
    }

    public CallHierarchyComputeStrategy getHierarchyStrategy() {
        return this.fHierarchyStrategy;
    }

    public void setHierarchyStrategy(CallHierarchyComputeStrategy strategy) {
        this.fHierarchyStrategy = strategy;
    }

    public String getName() {
        return this.fName;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("");
        RfNamedElement namedElement = (RfNamedElement)this.getRfElement();
        if (namedElement != null) {
            result.append(namedElement.getName());
        }
        if (this.fHid != null) {
            if (namedElement == null) {
                result.append(this.fHid.getName());
            }
            HidOccurrence occurrence = this.fHid.getOccurrence();
            if (this.fHidOccurrence == null && occurrence != null) {
                result.append("-" + occurrence.getLine() + "-");
                result.append(occurrence.getOffset());
            }
        }
        if (this.fHidOccurrence != null) {
            result.append("-" + this.fHidOccurrence.getLine() + "-");
            result.append("-" + this.fHidOccurrence.getOffset() + "-");
        }
        return result.toString();
    }

    public static enum WrapperKind {
        RECURRENCE,
        POTENTIAL,
        ACTION_BLOCK,
        OVERRIDE,
        UPDATING,
        MACRO,
        NORMAL;

    }
}

