/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.TypesViewLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VlogLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VlogLanguageElement;

public class ChecksViewLabelProvider
extends VlogLabelProvider {
    private TypesViewLabelProvider fTypesViewLabelProvider = new TypesViewLabelProvider();

    public Image getColumnImage(Object wrapper, int columnIndex) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        Object element = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
        if (element instanceof VlogLanguageElement && columnIndex == 0) {
            return DVTImages.imageCache.getImage(DVTImages.VLOG_LANGUAGE);
        }
        Image result = null;
        if (element instanceof String && columnIndex == 0) {
            result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_PACKAGE);
        } else if (element instanceof RfAssertExpect && columnIndex == 0) {
            RfAssertExpect tmpElement = (RfAssertExpect)element;
            if (tmpElement.isAssert()) {
                if (tmpElement.isConcurrentAssertionStatement()) {
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ASSERT_CONCURRENT);
                }
                if (tmpElement.isDeferred()) {
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ASSERT_IMMEDIATE_DEFERRED);
                }
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ASSERT_IMMEDIATE);
            }
            if (tmpElement.isAssume()) {
                if (tmpElement.isConcurrentAssertionStatement()) {
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ASSUME_CONCURRENT);
                }
                if (tmpElement.isDeferred()) {
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ASSUME_IMMEDIATE_DEFERRED);
                }
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ASSUME_IMMEDIATE);
            }
            if (tmpElement.isExpect()) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ASSERT_CONCURRENT);
            }
            if (tmpElement.isRestrict()) {
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_RESTRICT);
            }
        } else if (columnIndex == 0) {
            result = this.fTypesViewLabelProvider.getImage(wrapper);
        }
        if (result == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (!((RfTreeElementWrapper)((Object)wrapper)).getOverlayStatus()) {
            return result;
        }
        if (this.fDecorator != null) {
            return this.fDecorator.decorateImage(result, wrapper);
        }
        return result;
    }

    public String getColumnText(Object wrapper, int columnIndex) {
        Object element;
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        RfTreeElementWrapper rfWrapper = (RfTreeElementWrapper)((Object)wrapper);
        if (rfWrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.MATCH) != null && columnIndex == 0) {
            this.setBoldFont(rfWrapper);
        }
        if ((element = rfWrapper.getRfElement()) instanceof VlogLanguageElement && columnIndex == 0) {
            return (String)((VlogLanguageElement)((Object)element)).getInfo();
        }
        if (element instanceof RfAssertExpect) {
            if (columnIndex == 0) {
                return rfWrapper.getTreeName();
            }
            return ViewsUtils.trimText((String)((RfAssertExpect)element).getComment(), (int)100, (boolean)true);
        }
        if (columnIndex == 0 && element instanceof String) {
            return (String)element;
        }
        if (columnIndex == 0) {
            return this.fTypesViewLabelProvider.getText(wrapper);
        }
        return "";
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public String getText(Object object) {
        String result = this.getColumnText(object, 0);
        if (result == null) {
            return "";
        }
        return result;
    }

    public String getTextForSearch(Object element) {
        StringBuilder result = new StringBuilder();
        result.append(this.getColumnText(element, 0)).append(" ").append(this.getColumnText(element, 1));
        return result.toString();
    }
}

