/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import org.eclipse.core.resources.IFile;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.VlogLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VlogLanguageElement;
import ro.amiq.vlogdt.parser.VlogFileInstance;

public class CompileOrderLabelProvider
extends VlogLabelProvider {
    public Image getImage(Object object) {
        if (!(object instanceof RfTreeElementWrapper)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        Object rfElement = ((RfTreeElementWrapper)((Object)object)).getRfElement();
        if (rfElement instanceof VlogLanguageElement) {
            return DVTImages.imageCache.getImage(DVTImages.VLOG_LANGUAGE);
        }
        if (!(rfElement instanceof VlogFileInstance)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        VlogFileInstance instance = (VlogFileInstance)rfElement;
        String name = instance.getShortFileName();
        if (name != null && name.startsWith("__vlog__") && name.endsWith(".libfile")) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_LIBRARY);
        }
        IFile file = RfUtils.getFile(instance, ((RfTreeElementWrapper)((Object)object)).getProject());
        Image result = null;
        result = file != null ? DVTImages.imageCache.getImage(DVTImages.DESC_VLOG_MODULE) : DVTImages.imageCache.getImage(DVTImages.DESC_VLOG_MODULE_GRAY);
        if (result == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (this.fDecorator != null) {
            return this.fDecorator.decorateImage(result, object);
        }
        return result;
    }

    public String getText(Object object) {
        String result = this.internalGetText(object);
        if (result == null) {
            return "";
        }
        return result;
    }

    private String internalGetText(Object object) {
        int index;
        Object element;
        if (!(object instanceof RfTreeElementWrapper)) {
            return "";
        }
        RfTreeElementWrapper treeElementWrapper = (RfTreeElementWrapper)((Object)object);
        if (treeElementWrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.MATCH) != null) {
            this.setBoldFont(treeElementWrapper);
        }
        if ((element = treeElementWrapper.getRfElement()) instanceof VlogLanguageElement) {
            return (String)((VlogLanguageElement)((Object)element)).getInfo();
        }
        if (element instanceof String) {
            return element.toString();
        }
        if (element instanceof RfNamedElement) {
            return ((RfNamedElement)element).getName();
        }
        if (!(element instanceof VlogFileInstance)) {
            return "";
        }
        VlogFileInstance instance = (VlogFileInstance)element;
        String name = instance.getShortFileName();
        if (name == null) {
            return "";
        }
        if (name.startsWith("__vlog__") && name.endsWith(".libfile")) {
            return "Libraries";
        }
        String buildStatus = "";
        if (instance.isPrecompiledDbFile()) {
            buildStatus = String.valueOf(buildStatus) + "[P]";
        }
        if (instance.isShallowCompiled()) {
            buildStatus = String.valueOf(buildStatus) + "[S]";
        } else if (instance.isIncrementalShallowCompiled()) {
            buildStatus = String.valueOf(buildStatus) + "[iS]";
        }
        if (instance.isOptimizeSkip() && new Boolean(System.getenv("DVT_MARK_SKIPPED_FILES_IN_COMPILEORDER")).booleanValue()) {
            buildStatus = String.valueOf(buildStatus) + "[skip]";
        }
        if (!buildStatus.isEmpty()) {
            name = String.valueOf(buildStatus) + " " + name;
        }
        if ((index = instance.getIndex()) <= 0) {
            return name;
        }
        return String.valueOf(name) + " [" + index + "]";
    }

    public Object[] getChildren(Object wrapper) {
        if (wrapper == null) {
            return null;
        }
        if (wrapper instanceof IDVTElementWrapper && ((IDVTElementWrapper)wrapper).getChildren() != null) {
            return ((IDVTElementWrapper)wrapper).getChildren().toArray();
        }
        return null;
    }
}

