/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfCovercross;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.TypesViewLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VlogLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VlogLanguageElement;

public class CoverageViewLabelProvider
extends VlogLabelProvider {
    private TypesViewLabelProvider fTypesViewLabelProvider = new TypesViewLabelProvider();

    public Image getColumnImage(Object element, int columnIndex) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        RfTreeElementWrapper rfWrapper = (RfTreeElementWrapper)((Object)element);
        Object rfElement = rfWrapper.getRfElement();
        if (rfElement instanceof VlogLanguageElement && columnIndex == 0) {
            return DVTImages.imageCache.getImage(DVTImages.VLOG_LANGUAGE);
        }
        Image result = null;
        if (rfElement instanceof String || columnIndex == 1) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (rfElement instanceof RfCovergroup) {
            result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_COVERGROUP);
        } else if (rfElement instanceof RfCovercross) {
            result = DVTImages.imageCache.getImage(DVTImages.COVER_CROSS);
        } else if (rfElement instanceof RfCoverpoint) {
            result = DVTImages.imageCache.getImage(DVTImages.COVER_ITEM);
        } else if (rfElement instanceof RfField) {
            result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
        } else if (columnIndex == 0) {
            result = this.fTypesViewLabelProvider.getImage(element);
        }
        if (result == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (!rfWrapper.getOverlayStatus()) {
            return result;
        }
        if (this.fDecorator != null) {
            result = this.fDecorator.decorateImage(result, element);
        }
        if (result == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        return result;
    }

    public String getColumnText(Object wrapper, int columnIndex) {
        Object element;
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        RfTreeElementWrapper rfWrapper = (RfTreeElementWrapper)((Object)wrapper);
        if (rfWrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.MATCH) != null && columnIndex == 0) {
            this.setBoldFont(rfWrapper);
        }
        if ((element = rfWrapper.getRfElement()) instanceof VlogLanguageElement && columnIndex == 0) {
            return (String)((VlogLanguageElement)((Object)element)).getInfo();
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (element instanceof RfCovergroup) {
            RfCovergroup rfCovergroup = (RfCovergroup)element;
            if (columnIndex == 0) {
                return rfCovergroup.getName();
            }
            return ViewsUtils.trimText((String)rfCovergroup.getComment(), (int)100, (boolean)true);
        }
        if (element instanceof RfCoverpoint) {
            RfCoverpoint rfCoverpoint = (RfCoverpoint)element;
            if (columnIndex == 0) {
                return rfCoverpoint.getName();
            }
            return ViewsUtils.trimText((String)rfCoverpoint.getComment(), (int)100, (boolean)true);
        }
        if (element instanceof RfField) {
            RfField rfField = (RfField)element;
            if (columnIndex == 0) {
                return rfField.getName();
            }
            return ViewsUtils.trimText((String)rfField.getComment(), (int)100, (boolean)true);
        }
        if (element instanceof RfAssertExpect) {
            RfAssertExpect assertExpect = (RfAssertExpect)element;
            if (columnIndex == 0) {
                return rfWrapper.getTreeName();
            }
            return ViewsUtils.trimText((String)assertExpect.getComment(), (int)100, (boolean)true);
        }
        if (element instanceof RfNamedElement && columnIndex == 0) {
            return this.fTypesViewLabelProvider.getText(wrapper);
        }
        return null;
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public String getText(Object object) {
        String result = this.getColumnText(object, 0);
        if (result == null) {
            return "";
        }
        return result;
    }

    public String getTextForSearch(Object element) {
        StringBuilder result = new StringBuilder();
        result.append(this.getColumnText(element, 0)).append(" ").append(this.getColumnText(element, 1));
        return result.toString();
    }
}

