/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.HistoryItemType;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTRfNameTypeScopeHelper;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vlogdt.model.reflection.util.RfNameTypeScopeHelper;

public class DHHistoryItem
extends HistoryItem {
    String elementName;
    String projectName;
    private List<? extends DVTRfNameTypeScopeHelper> elementScope;
    private String configurationName;
    private HistoryItemType historyItemType;

    public DHHistoryItem(String label, String projectName, String elementName, String configurationName, List<? extends DVTRfNameTypeScopeHelper> elementScope, HistoryItemType historyItemType) {
        super(label);
        this.setConfigurationName(configurationName);
        this.projectName = projectName;
        this.elementName = elementName;
        this.elementScope = elementScope;
        this.historyItemType = historyItemType;
    }

    public boolean equals(Object hi) {
        if (hi instanceof DHHistoryItem) {
            int otherSize;
            boolean firstPart;
            DHHistoryItem lhi = (DHHistoryItem)((Object)hi);
            boolean bl = firstPart = this.projectName.equals(lhi.projectName) && this.elementName.equals(lhi.elementName);
            if (!firstPart) {
                return false;
            }
            if (this.getConfigurationName() != null && this.getConfigurationName().equals(lhi.getConfigurationName())) {
                return false;
            }
            int size = this.elementScope != null ? this.elementScope.size() : 0;
            int n = otherSize = lhi.elementScope != null ? lhi.elementScope.size() : 0;
            if (size != otherSize) {
                return false;
            }
            int i = 0;
            while (i < size) {
                if (!this.elementScope.get(i).equals(lhi.elementScope.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() + this.projectName.hashCode() + this.elementName.hashCode() + this.elementScope.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (DVTRfNameTypeScopeHelper dVTRfNameTypeScopeHelper : this.elementScope) {
            String str = String.valueOf(dVTRfNameTypeScopeHelper.getElementKind()) + "'" + dVTRfNameTypeScopeHelper.getElementName();
            str = str.replaceAll("\\.", "___dvt_dot___");
            result.append(str).append(".");
        }
        String string = this.getConfigurationName();
        if (string != null && !string.isEmpty()) {
            result.append(string).append("'");
        }
        result.append(this.elementName);
        return result.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HistoryItem parseHistoryItem(String projectName, String top, boolean isElab, HistoryItemType historyItemType) {
        try {
            ArrayList<String> pieces = new ArrayList<String>(Arrays.asList(top.split("\\.")));
            if (pieces.size() < 2) {
                return null;
            }
            String[] elementNameType = ((String)pieces.remove(pieces.size() - 1)).split("'");
            String elementName = null;
            String configurationName = null;
            if (isElab) {
                if (elementNameType.length != 1) {
                    return null;
                }
                elementName = elementNameType[0];
            } else {
                if (elementNameType.length != 2) {
                    return null;
                }
                elementName = elementNameType[1];
                configurationName = elementNameType[0];
            }
            ArrayList<RfNameTypeScopeHelper> scopeHelpers = new ArrayList<RfNameTypeScopeHelper>();
            Iterator iterator = pieces.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    String label = "[" + projectName + "] " + elementName;
                    return new DHHistoryItem(label, projectName, elementName, configurationName, scopeHelpers, historyItemType);
                }
                String piece = (String)iterator.next();
                String[] scopePieces = piece.split("'");
                if (scopePieces.length != 2) {
                    return null;
                }
                scopeHelpers.add(new RfNameTypeScopeHelper(Integer.parseInt(scopePieces[0]), scopePieces[1].replaceAll("___dvt_dot___", ".")));
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public LanguageKind getLanguage() {
        return LanguageKind.VLOG;
    }

    public IProject getProject() {
        if (this.projectName == null) {
            return null;
        }
        return Utils.getProject((String)this.projectName);
    }

    public List<? extends DVTRfNameTypeScopeHelper> getElementScope() {
        return this.elementScope;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public HistoryItemType getHistoryItemType() {
        return this.historyItemType;
    }
}

