/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.VlogLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VlogLanguageElement;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.utils.Utils;

public class MacroViewLabelProvider
extends VlogLabelProvider {
    private static final int MAX_CHARS_IN_MACRO_EXPANSION = 100;

    public Image getImage(Object wrapper) {
        return this.getColumnImage(wrapper, 0);
    }

    public Image getColumnImage(Object wrapper, int columnIndex) {
        Image result = null;
        Object element = null;
        if (wrapper instanceof DVTTreeElementWrapper) {
            element = ((DVTTreeElementWrapper)wrapper).getRfElement();
            if (!(element instanceof VlogMacroInfo) && !(element instanceof VlogLanguageElement)) {
                return DVTImages.imageCache.getImage(DVTImages.TRANSPARENT);
            }
        } else if (!(wrapper instanceof RfTreeElementWrapper)) {
            if (wrapper instanceof VlogLanguageElement && columnIndex == 0) {
                return DVTImages.imageCache.getImage(DVTImages.VLOG_LANGUAGE);
            }
            if (!(wrapper instanceof VlogMacroInfo)) {
                return DVTImages.imageCache.getImage(DVTImages.TRANSPARENT);
            }
            element = wrapper;
        } else {
            element = ((IDVTElementWrapper)wrapper).getRfElement();
        }
        if (columnIndex == 0) {
            if (element instanceof VlogLanguageElement) {
                return DVTImages.imageCache.getImage(DVTImages.VLOG_LANGUAGE);
            }
            result = element instanceof String ? DVTImages.imageCache.getImage(DVTImages.TRANSPARENT) : (((VlogMacroInfo)element).isUndefConfigMacro() ? DVTImages.imageCache.getImage(DVTImages.PREPROC_IFNDEF_UNDEF) : (((VlogMacroInfo)element).isDefinedConfigMacro() ? DVTImages.imageCache.getImage(DVTImages.PREPROC_IFNDEF) : DVTImages.imageCache.getImage(DVTImages.PREPROC_DEFINE)));
            if (result != null && this.fDecorator != null) {
                return this.fDecorator.decorateImage(result, wrapper);
            }
        } else if (columnIndex == 2) {
            if (!(element instanceof VlogMacroInfo)) {
                return DVTImages.imageCache.getImage(DVTImages.TRANSPARENT);
            }
            VlogMacroInfo macroInfo = (VlogMacroInfo)element;
            ParserPath parserPath = macroInfo.getFileInstance().getParserPath();
            if (parserPath == null || parserPath.path == null) {
                return DVTImages.imageCache.getImage(DVTImages.TRANSPARENT);
            }
            IFile file = (IFile)Utils.getInstance().getFileAdapter(macroInfo.getRfProject(), parserPath.path);
            if (file == null) {
                result = DVTImages.imageCache.getImage(DVTImages.DESC_VLOG_MODULE_GRAY);
            } else {
                result = DVTImages.imageCache.getImage(DVTImages.DESC_VLOG_MODULE);
                IContainer parent = file.getParent();
                while (parent != null && !(parent instanceof IProject)) {
                    if (parent.isLinked()) {
                        result = DVTImages.imageCache.getImage(DVTImages.DESC_VLOG_MODULE_LINKED);
                        break;
                    }
                    parent = parent.getParent();
                }
            }
            if (result != null && this.fDecorator != null) {
                return this.fDecorator.decorateImage(result, wrapper);
            }
        }
        if (result == null) {
            result = DVTImages.imageCache.getImage(DVTImages.TRANSPARENT);
        }
        return result;
    }

    public String getColumnText(Object wrapper, int columnIndex) {
        String result = "";
        Object element = null;
        if (!(wrapper instanceof RfTreeElementWrapper || wrapper instanceof VlogMacroInfo || wrapper instanceof DVTTreeElementWrapper)) {
            if (columnIndex != 0) {
                return result;
            }
            if (wrapper instanceof IRfNamedElement) {
                return ((IRfNamedElement)wrapper).getName();
            }
            if (wrapper instanceof VlogLanguageElement) {
                return (String)((VlogLanguageElement)((Object)wrapper)).getInfo();
            }
            return result;
        }
        if (wrapper instanceof VlogMacroInfo) {
            element = wrapper;
        } else if (wrapper instanceof DVTTreeElementWrapper) {
            element = ((DVTTreeElementWrapper)wrapper).getRfElement();
            if (!(element instanceof VlogMacroInfo) && element instanceof IRfNamedElement) {
                return columnIndex == 0 ? ((IRfNamedElement)element).getName() : result;
            }
        } else {
            element = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
        }
        if (element instanceof VlogLanguageElement && columnIndex == 0) {
            return (String)((VlogLanguageElement)((Object)element)).getInfo();
        }
        switch (columnIndex) {
            case 0: {
                if (!(element instanceof VlogMacroInfo)) break;
                result = ((VlogMacroInfo)element).getSignature(false, false);
                break;
            }
            case 1: {
                if (!(element instanceof VlogMacroInfo) || ((VlogMacroInfo)element).hasParams() || !((VlogMacroInfo)element).hasReplacement()) break;
                try {
                    String lineDelimiter = DVTDocumentCommon.getLineDelimiterByProject(null);
                    result = ((VlogMacroInfo)element).getLabelProviderReplacement();
                    result = result.substring(0, Math.min(100, result.length()));
                    if (result.contains(lineDelimiter)) {
                        result = result.substring(0, result.indexOf(lineDelimiter));
                    }
                    if (result == null) break;
                    result = result.trim();
                }
                catch (Exception exception) {}
                break;
            }
            case 2: {
                VlogMacroInfo macroInfo;
                ParserPath parserPath;
                if (!(element instanceof VlogMacroInfo) || (parserPath = (macroInfo = (VlogMacroInfo)element).getFileInstance().getParserPath()) == null || parserPath.path == null) break;
                result = new File(parserPath.path).getName();
                break;
            }
            case 3: {
                if (!(element instanceof VlogMacroInfo)) break;
                result = Integer.toString(((VlogMacroInfo)element).getLine());
                break;
            }
        }
        return result;
    }

    public String getText(Object wrapper) {
        return this.getColumnText(wrapper, 0);
    }
}

