/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.trace.connections.model.TCConnSignal;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public class PortConnectionsHidOperatorVisitor
implements IHidVisitor<RfHidOperator> {
    private IRfNamedElement fRfElement;
    private IRfNamedElement fScope;
    private boolean hasPortConnections;

    public PortConnectionsHidOperatorVisitor(IRfNamedElement element) {
        this.fRfElement = element;
        this.hasPortConnections = false;
    }

    public boolean visit(RfHidOperator hidOperator) {
        if (!hidOperator.isAssociation()) {
            return true;
        }
        boolean isPortConnection = hidOperator.hasQualifier(HidOperatorQualifier.IS_PORT_CONNECTION.value());
        if (!isPortConnection) {
            return true;
        }
        if (this.fRfElement instanceof IRfFieldElement && this.fScope instanceof RfInstance && this.checkDotStarImplicitConnections()) {
            return false;
        }
        IHidObject lhHidObject = hidOperator.getLHValue();
        if (this.checkEachSideOfOperator(lhHidObject)) {
            return false;
        }
        ListContainer rhHidObjects = hidOperator.getRHValues();
        if (rhHidObjects == null || rhHidObjects.isEmpty()) {
            return true;
        }
        for (IHidObject rhValue : rhHidObjects) {
            if (!this.checkEachSideOfOperator(rhValue)) continue;
            return false;
        }
        return true;
    }

    private boolean checkEachSideOfOperator(IHidObject hidObject) {
        if (HidUtils.isHid((IHidObject)hidObject)) {
            IRfNamedElement rhHidElement = ((RfHid)hidObject).getElement();
            boolean isMatch = this.fRfElement.checkEquals((Object)rhHidElement);
            if (isMatch) {
                this.hasPortConnections = true;
                return true;
            }
        } else if (HidUtils.isOperator((IHidObject)hidObject)) {
            RfHidOperator rhHidOperator = (RfHidOperator)hidObject;
            ListContainer rhValues = rhHidOperator.getRHValues();
            if (rhValues == null || rhValues.isEmpty()) {
                return false;
            }
            for (IHidObject iHidObject : rhValues) {
                if (!this.checkEachSideOfOperator(iHidObject)) continue;
                return true;
            }
        } else if (hidObject instanceof RfHidAccessArgs) {
            RfHidAccessArgs access = (RfHidAccessArgs)hidObject;
            List<? extends IHidObject> argumentValues = access.getArgumentValues();
            if (argumentValues == null || argumentValues.isEmpty()) {
                return true;
            }
            for (IHidObject iHidObject : argumentValues) {
                if (!this.checkEachSideOfOperator(iHidObject)) continue;
                return true;
            }
        } else if (HidUtils.isHidAccess((IHidObject)hidObject)) {
            RfHidAccess access = (RfHidAccess)hidObject;
            Hid parentHid = access.getParentHid();
            while (parentHid != null && parentHid.getParentHid() != null && parentHid.getParentHid().getParentHid() != null) {
                parentHid = parentHid.getParentHid();
            }
            if (parentHid == null) {
                return false;
            }
            if (this.checkEachSideOfOperator((IHidObject)parentHid)) {
                return true;
            }
        }
        return false;
    }

    private boolean checkDotStarImplicitConnections() {
        RfNamedElement enclosingDesign = ((RfInstance)this.fScope).getEnclosingScope();
        HashMap dummyPortCache = new HashMap();
        Map portsWithSignals = DesignUtils.mapInstancePortConnections((DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)this.fScope), dummyPortCache, (Set)HidFlatteningOption.ALL_EXCLUDED);
        for (Map.Entry portWithSignals : portsWithSignals.entrySet()) {
            IRfPortElement port = (IRfPortElement)portWithSignals.getKey();
            boolean isPortEquals = this.fRfElement.checkEquals((Object)port);
            if (isPortEquals) {
                this.hasPortConnections = true;
                return true;
            }
            Set signals = (Set)portWithSignals.getValue();
            if (signals == null || signals.isEmpty()) {
                return false;
            }
            for (TCConnSignal tcConnSignal : signals) {
                IRfNamedElement signal;
                boolean isSignalEquals;
                if (tcConnSignal.statement.cacheImplicitPortConnection == null || !(isSignalEquals = this.fRfElement.checkEquals((Object)(signal = DesignUtils.resolveSignal((Object)tcConnSignal.signal, (DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)enclosingDesign), null, dummyPortCache))))) continue;
                this.hasPortConnections = true;
                return true;
            }
        }
        return false;
    }

    public Class<RfHidOperator> getType() {
        return RfHidOperator.class;
    }

    public void setHolder(IHidHolder holder) {
        if (holder != null) {
            this.fScope = ((RfHidHolder)holder).getScope();
        }
    }

    public boolean hasPortConnections() {
        return this.hasPortConnections;
    }
}

