/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.Comparator;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfKind;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.editor.outline.CategorySortingAction;
import ro.amiq.vlogdt.ui.editor.outline.IUpdateElement;

public class QuickViewCategorySortingAction
extends CategorySortingAction {
    Comparator<IDVTElementWrapper> fComparator;
    private IUpdateElement fAtic;

    public QuickViewCategorySortingAction(IUpdateElement atic) {
        this.fAtic = atic;
        boolean disabled = VlogPlugin.getDefault().getPreferenceStore().getBoolean("outline.lexical_sort");
        this.setEnabled(!disabled);
        if (!disabled) {
            boolean checked = VlogPlugin.getDefault().getPreferenceStore().getBoolean("outline.category_sort");
            super.valueChanged(checked);
        }
    }

    @Override
    protected void valueChanged(boolean on) {
        super.valueChanged(on);
        this.fAtic.update(true);
    }

    public Comparator<IDVTElementWrapper> getComparator() {
        if (this.fComparator == null) {
            this.fComparator = new Comparator<IDVTElementWrapper>(){

                public int category(IDVTElementWrapper wrapper) {
                    RfNamedElement namedElem = ((RfDefElement)wrapper.getRfElement()).getNamedElement();
                    RfKind kind = RfKind.of(namedElem);
                    return kind.ordinal();
                }

                @Override
                public int compare(IDVTElementWrapper e1, IDVTElementWrapper e2) {
                    int cat2;
                    if (!(e1.getRfElement() instanceof RfDefElement) || !(e2.getRfElement() instanceof RfDefElement)) {
                        return 0;
                    }
                    int cat1 = this.category(e1);
                    if (cat1 != (cat2 = this.category(e2))) {
                        return cat1 - cat2;
                    }
                    String name1 = ((RfDefElement)e1.getRfElement()).getName();
                    String name2 = ((RfDefElement)e2.getRfElement()).getName();
                    return name1.compareTo(name2);
                }
            };
        }
        return this.fComparator;
    }
}

